/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ProcedureSqlConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Default: `user-defined procedure`) Specifies a comment for the procedure.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#comment ProcedureSql#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#database ProcedureSql#database}
    */
    readonly database: string;
    /**
    * Enable stdout/stderr fast path logging for anonyous stored procs. This is a public parameter (similar to LOG_LEVEL). For more information, check [ENABLE_CONSOLE_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-console-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#enable_console_output ProcedureSql#enable_console_output}
    */
    readonly enableConsoleOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the stored procedure executes with the privileges of the owner (an “owner’s rights” stored procedure) or with the privileges of the caller (a “caller’s rights” stored procedure). If you execute the statement CREATE PROCEDURE … EXECUTE AS CALLER, then in the future the procedure will execute as a caller’s rights procedure. If you execute CREATE PROCEDURE … EXECUTE AS OWNER, then the procedure will execute as an owner’s rights procedure. For more information, see [Understanding caller’s rights and owner’s rights stored procedures](https://docs.snowflake.com/en/developer-guide/stored-procedure/stored-procedures-rights). Valid values are (case-insensitive): `CALLER` | `OWNER`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#execute_as ProcedureSql#execute_as}
    */
    readonly executeAs?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#id ProcedureSql#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies that the procedure is secure. For more information about secure procedures, see [Protecting Sensitive Information with Secure UDFs and Stored Procedures](https://docs.snowflake.com/en/developer-guide/secure-udf-procedure). Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#is_secure ProcedureSql#is_secure}
    */
    readonly isSecure?: string;
    /**
    * LOG_LEVEL to use when filtering events For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#log_level ProcedureSql#log_level}
    */
    readonly logLevel?: string;
    /**
    * METRIC_LEVEL value to control whether to emit metrics to Event Table For more information, check [METRIC_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#metric-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#metric_level ProcedureSql#metric_level}
    */
    readonly metricLevel?: string;
    /**
    * The name of the procedure; the identifier does not need to be unique for the schema in which the procedure is created because stored procedures are [identified and resolved by the combination of the name and argument types](https://docs.snowflake.com/en/developer-guide/udf-stored-procedure-naming-conventions.html#label-procedure-function-name-overloading). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#name ProcedureSql#name}
    */
    readonly name: string;
    /**
    * Specifies the behavior of the procedure when called with null inputs. Valid values are (case-insensitive): `CALLED ON NULL INPUT` | `RETURNS NULL ON NULL INPUT`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#null_input_behavior ProcedureSql#null_input_behavior}
    */
    readonly nullInputBehavior?: string;
    /**
    * Defines the code executed by the stored procedure. The definition can consist of any valid code. Wrapping `$$` signs are added by the provider automatically; do not include them. The `procedure_definition` value must be SQL source code. For more information, see [Snowflake Scripting](https://docs.snowflake.com/en/developer-guide/snowflake-scripting/index). To mitigate permadiff on this field, the provider replaces blank characters with a space. This can lead to false positives in cases where a change in case or run of whitespace is semantically significant.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#procedure_definition ProcedureSql#procedure_definition}
    */
    readonly procedureDefinition: string;
    /**
    * Specifies the type of the result returned by the stored procedure. For `<result_data_type>`, use the Snowflake data type that corresponds to the type of the language that you are using (see [SQL data type](https://docs.snowflake.com/en/sql-reference-data-types)). For `RETURNS TABLE ( [ col_name col_data_type [ , ... ] ] )`, if you know the Snowflake data types of the columns in the returned table, specify the column names and types. Otherwise (e.g. if you are determining the column types during run time), you can omit the column names and types (i.e. `TABLE ()`).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#return_type ProcedureSql#return_type}
    */
    readonly returnType: string;
    /**
    * The schema in which to create the procedure. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#schema ProcedureSql#schema}
    */
    readonly schema: string;
    /**
    * Trace level value to use when generating/filtering trace events For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#trace_level ProcedureSql#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * arguments block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#arguments ProcedureSql#arguments}
    */
    readonly arguments?: ProcedureSqlArguments[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#timeouts ProcedureSql#timeouts}
    */
    readonly timeouts?: ProcedureSqlTimeouts;
}
export interface ProcedureSqlParametersEnableConsoleOutput {
}
export declare function procedureSqlParametersEnableConsoleOutputToTerraform(struct?: ProcedureSqlParametersEnableConsoleOutput): any;
export declare function procedureSqlParametersEnableConsoleOutputToHclTerraform(struct?: ProcedureSqlParametersEnableConsoleOutput): any;
export declare class ProcedureSqlParametersEnableConsoleOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureSqlParametersEnableConsoleOutput | undefined;
    set internalValue(value: ProcedureSqlParametersEnableConsoleOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureSqlParametersEnableConsoleOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureSqlParametersEnableConsoleOutputOutputReference;
}
export interface ProcedureSqlParametersLogLevel {
}
export declare function procedureSqlParametersLogLevelToTerraform(struct?: ProcedureSqlParametersLogLevel): any;
export declare function procedureSqlParametersLogLevelToHclTerraform(struct?: ProcedureSqlParametersLogLevel): any;
export declare class ProcedureSqlParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureSqlParametersLogLevel | undefined;
    set internalValue(value: ProcedureSqlParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureSqlParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureSqlParametersLogLevelOutputReference;
}
export interface ProcedureSqlParametersMetricLevel {
}
export declare function procedureSqlParametersMetricLevelToTerraform(struct?: ProcedureSqlParametersMetricLevel): any;
export declare function procedureSqlParametersMetricLevelToHclTerraform(struct?: ProcedureSqlParametersMetricLevel): any;
export declare class ProcedureSqlParametersMetricLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureSqlParametersMetricLevel | undefined;
    set internalValue(value: ProcedureSqlParametersMetricLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureSqlParametersMetricLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureSqlParametersMetricLevelOutputReference;
}
export interface ProcedureSqlParametersTraceLevel {
}
export declare function procedureSqlParametersTraceLevelToTerraform(struct?: ProcedureSqlParametersTraceLevel): any;
export declare function procedureSqlParametersTraceLevelToHclTerraform(struct?: ProcedureSqlParametersTraceLevel): any;
export declare class ProcedureSqlParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureSqlParametersTraceLevel | undefined;
    set internalValue(value: ProcedureSqlParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ProcedureSqlParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureSqlParametersTraceLevelOutputReference;
}
export interface ProcedureSqlParameters {
}
export declare function procedureSqlParametersToTerraform(struct?: ProcedureSqlParameters): any;
export declare function procedureSqlParametersToHclTerraform(struct?: ProcedureSqlParameters): any;
export declare class ProcedureSqlParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureSqlParameters | undefined;
    set internalValue(value: ProcedureSqlParameters | undefined);
    private _enableConsoleOutput;
    get enableConsoleOutput(): ProcedureSqlParametersEnableConsoleOutputList;
    private _logLevel;
    get logLevel(): ProcedureSqlParametersLogLevelList;
    private _metricLevel;
    get metricLevel(): ProcedureSqlParametersMetricLevelList;
    private _traceLevel;
    get traceLevel(): ProcedureSqlParametersTraceLevelList;
}
export declare class ProcedureSqlParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureSqlParametersOutputReference;
}
export interface ProcedureSqlShowOutput {
}
export declare function procedureSqlShowOutputToTerraform(struct?: ProcedureSqlShowOutput): any;
export declare function procedureSqlShowOutputToHclTerraform(struct?: ProcedureSqlShowOutput): any;
export declare class ProcedureSqlShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureSqlShowOutput | undefined;
    set internalValue(value: ProcedureSqlShowOutput | undefined);
    get argumentsRaw(): string;
    get catalogName(): string;
    get createdOn(): string;
    get description(): string;
    get externalAccessIntegrations(): string;
    get isAggregate(): cdktf.IResolvable;
    get isAnsi(): cdktf.IResolvable;
    get isBuiltin(): cdktf.IResolvable;
    get isSecure(): cdktf.IResolvable;
    get isTableFunction(): cdktf.IResolvable;
    get maxNumArguments(): number;
    get minNumArguments(): number;
    get name(): string;
    get schemaName(): string;
    get secrets(): string;
    get validForClustering(): cdktf.IResolvable;
}
export declare class ProcedureSqlShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureSqlShowOutputOutputReference;
}
export interface ProcedureSqlArguments {
    /**
    * The argument type.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#arg_data_type ProcedureSql#arg_data_type}
    */
    readonly argDataType: string;
    /**
    * Optional default value for the argument. For text values use single quotes. Numeric values can be unquoted. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#arg_default_value ProcedureSql#arg_default_value}
    */
    readonly argDefaultValue?: string;
    /**
    * The argument name. The provider wraps it in double quotes by default, so be aware of that while referencing the argument in the procedure definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#arg_name ProcedureSql#arg_name}
    */
    readonly argName: string;
}
export declare function procedureSqlArgumentsToTerraform(struct?: ProcedureSqlArguments | cdktf.IResolvable): any;
export declare function procedureSqlArgumentsToHclTerraform(struct?: ProcedureSqlArguments | cdktf.IResolvable): any;
export declare class ProcedureSqlArgumentsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ProcedureSqlArguments | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureSqlArguments | cdktf.IResolvable | undefined);
    private _argDataType?;
    get argDataType(): string;
    set argDataType(value: string);
    get argDataTypeInput(): string | undefined;
    private _argDefaultValue?;
    get argDefaultValue(): string;
    set argDefaultValue(value: string);
    resetArgDefaultValue(): void;
    get argDefaultValueInput(): string | undefined;
    private _argName?;
    get argName(): string;
    set argName(value: string);
    get argNameInput(): string | undefined;
}
export declare class ProcedureSqlArgumentsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ProcedureSqlArguments[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ProcedureSqlArgumentsOutputReference;
}
export interface ProcedureSqlTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#create ProcedureSql#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#delete ProcedureSql#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#read ProcedureSql#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#update ProcedureSql#update}
    */
    readonly update?: string;
}
export declare function procedureSqlTimeoutsToTerraform(struct?: ProcedureSqlTimeouts | cdktf.IResolvable): any;
export declare function procedureSqlTimeoutsToHclTerraform(struct?: ProcedureSqlTimeouts | cdktf.IResolvable): any;
export declare class ProcedureSqlTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ProcedureSqlTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ProcedureSqlTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql snowflake_procedure_sql}
*/
export declare class ProcedureSql extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_procedure_sql";
    /**
    * Generates CDKTF code for importing a ProcedureSql resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ProcedureSql to import
    * @param importFromId The id of the existing ProcedureSql that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ProcedureSql to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/procedure_sql snowflake_procedure_sql} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ProcedureSqlConfig
    */
    constructor(scope: Construct, id: string, config: ProcedureSqlConfig);
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _enableConsoleOutput?;
    get enableConsoleOutput(): boolean | cdktf.IResolvable;
    set enableConsoleOutput(value: boolean | cdktf.IResolvable);
    resetEnableConsoleOutput(): void;
    get enableConsoleOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _executeAs?;
    get executeAs(): string;
    set executeAs(value: string);
    resetExecuteAs(): void;
    get executeAsInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _isSecure?;
    get isSecure(): string;
    set isSecure(value: string);
    resetIsSecure(): void;
    get isSecureInput(): string | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _metricLevel?;
    get metricLevel(): string;
    set metricLevel(value: string);
    resetMetricLevel(): void;
    get metricLevelInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _nullInputBehavior?;
    get nullInputBehavior(): string;
    set nullInputBehavior(value: string);
    resetNullInputBehavior(): void;
    get nullInputBehaviorInput(): string | undefined;
    private _parameters;
    get parameters(): ProcedureSqlParametersList;
    private _procedureDefinition?;
    get procedureDefinition(): string;
    set procedureDefinition(value: string);
    get procedureDefinitionInput(): string | undefined;
    get procedureLanguage(): string;
    private _returnType?;
    get returnType(): string;
    set returnType(value: string);
    get returnTypeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    private _showOutput;
    get showOutput(): ProcedureSqlShowOutputList;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _arguments;
    get arguments(): ProcedureSqlArgumentsList;
    putArguments(value: ProcedureSqlArguments[] | cdktf.IResolvable): void;
    resetArguments(): void;
    get argumentsInput(): cdktf.IResolvable | ProcedureSqlArguments[] | undefined;
    private _timeouts;
    get timeouts(): ProcedureSqlTimeoutsOutputReference;
    putTimeouts(value: ProcedureSqlTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ProcedureSqlTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
