"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SnowflakeProvider = void 0;
exports.snowflakeProviderTokenAccessorToTerraform = snowflakeProviderTokenAccessorToTerraform;
exports.snowflakeProviderTokenAccessorToHclTerraform = snowflakeProviderTokenAccessorToHclTerraform;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function snowflakeProviderTokenAccessorToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        client_id: cdktf.stringToTerraform(struct.clientId),
        client_secret: cdktf.stringToTerraform(struct.clientSecret),
        redirect_uri: cdktf.stringToTerraform(struct.redirectUri),
        refresh_token: cdktf.stringToTerraform(struct.refreshToken),
        token_endpoint: cdktf.stringToTerraform(struct.tokenEndpoint),
    };
}
function snowflakeProviderTokenAccessorToHclTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    const attrs = {
        client_id: {
            value: cdktf.stringToHclTerraform(struct.clientId),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        client_secret: {
            value: cdktf.stringToHclTerraform(struct.clientSecret),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        redirect_uri: {
            value: cdktf.stringToHclTerraform(struct.redirectUri),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        refresh_token: {
            value: cdktf.stringToHclTerraform(struct.refreshToken),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
        token_endpoint: {
            value: cdktf.stringToHclTerraform(struct.tokenEndpoint),
            isBlock: false,
            type: "simple",
            storageClassType: "string",
        },
    };
    // remove undefined attributes
    return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs snowflake}
*/
class SnowflakeProvider extends cdktf.TerraformProvider {
    // ==============
    // STATIC Methods
    // ==============
    /**
    * Generates CDKTF code for importing a SnowflakeProvider resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SnowflakeProvider to import
    * @param importFromId The id of the existing SnowflakeProvider that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SnowflakeProvider to import is found
    */
    static generateConfigForImport(scope, importToId, importFromId, provider) {
        return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "snowflake", importId: importFromId, provider });
    }
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs snowflake} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SnowflakeProviderConfig = {}
    */
    constructor(scope, id, config = {}) {
        super(scope, id, {
            terraformResourceType: 'snowflake',
            terraformGeneratorMetadata: {
                providerName: 'snowflake',
                providerVersion: '2.2.0',
                providerVersionConstraint: ' ~> 2.0'
            },
            terraformProviderSource: 'snowflakedb/snowflake'
        });
        this._accountName = config.accountName;
        this._authenticator = config.authenticator;
        this._clientIp = config.clientIp;
        this._clientRequestMfaToken = config.clientRequestMfaToken;
        this._clientStoreTemporaryCredential = config.clientStoreTemporaryCredential;
        this._clientTimeout = config.clientTimeout;
        this._disableConsoleLogin = config.disableConsoleLogin;
        this._disableQueryContextCache = config.disableQueryContextCache;
        this._disableTelemetry = config.disableTelemetry;
        this._driverTracing = config.driverTracing;
        this._externalBrowserTimeout = config.externalBrowserTimeout;
        this._host = config.host;
        this._includeRetryReason = config.includeRetryReason;
        this._insecureMode = config.insecureMode;
        this._jwtClientTimeout = config.jwtClientTimeout;
        this._jwtExpireTimeout = config.jwtExpireTimeout;
        this._keepSessionAlive = config.keepSessionAlive;
        this._loginTimeout = config.loginTimeout;
        this._maxRetryCount = config.maxRetryCount;
        this._ocspFailOpen = config.ocspFailOpen;
        this._oktaUrl = config.oktaUrl;
        this._organizationName = config.organizationName;
        this._params = config.params;
        this._passcode = config.passcode;
        this._passcodeInPassword = config.passcodeInPassword;
        this._password = config.password;
        this._port = config.port;
        this._previewFeaturesEnabled = config.previewFeaturesEnabled;
        this._privateKey = config.privateKey;
        this._privateKeyPassphrase = config.privateKeyPassphrase;
        this._profile = config.profile;
        this._protocol = config.protocol;
        this._requestTimeout = config.requestTimeout;
        this._role = config.role;
        this._skipTomlFilePermissionVerification = config.skipTomlFilePermissionVerification;
        this._tmpDirectoryPath = config.tmpDirectoryPath;
        this._token = config.token;
        this._useLegacyTomlFile = config.useLegacyTomlFile;
        this._user = config.user;
        this._validateDefaultParameters = config.validateDefaultParameters;
        this._warehouse = config.warehouse;
        this._alias = config.alias;
        this._tokenAccessor = config.tokenAccessor;
    }
    get accountName() {
        return this._accountName;
    }
    set accountName(value) {
        this._accountName = value;
    }
    resetAccountName() {
        this._accountName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountNameInput() {
        return this._accountName;
    }
    get authenticator() {
        return this._authenticator;
    }
    set authenticator(value) {
        this._authenticator = value;
    }
    resetAuthenticator() {
        this._authenticator = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get authenticatorInput() {
        return this._authenticator;
    }
    get clientIp() {
        return this._clientIp;
    }
    set clientIp(value) {
        this._clientIp = value;
    }
    resetClientIp() {
        this._clientIp = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientIpInput() {
        return this._clientIp;
    }
    get clientRequestMfaToken() {
        return this._clientRequestMfaToken;
    }
    set clientRequestMfaToken(value) {
        this._clientRequestMfaToken = value;
    }
    resetClientRequestMfaToken() {
        this._clientRequestMfaToken = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientRequestMfaTokenInput() {
        return this._clientRequestMfaToken;
    }
    get clientStoreTemporaryCredential() {
        return this._clientStoreTemporaryCredential;
    }
    set clientStoreTemporaryCredential(value) {
        this._clientStoreTemporaryCredential = value;
    }
    resetClientStoreTemporaryCredential() {
        this._clientStoreTemporaryCredential = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientStoreTemporaryCredentialInput() {
        return this._clientStoreTemporaryCredential;
    }
    get clientTimeout() {
        return this._clientTimeout;
    }
    set clientTimeout(value) {
        this._clientTimeout = value;
    }
    resetClientTimeout() {
        this._clientTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get clientTimeoutInput() {
        return this._clientTimeout;
    }
    get disableConsoleLogin() {
        return this._disableConsoleLogin;
    }
    set disableConsoleLogin(value) {
        this._disableConsoleLogin = value;
    }
    resetDisableConsoleLogin() {
        this._disableConsoleLogin = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableConsoleLoginInput() {
        return this._disableConsoleLogin;
    }
    get disableQueryContextCache() {
        return this._disableQueryContextCache;
    }
    set disableQueryContextCache(value) {
        this._disableQueryContextCache = value;
    }
    resetDisableQueryContextCache() {
        this._disableQueryContextCache = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableQueryContextCacheInput() {
        return this._disableQueryContextCache;
    }
    get disableTelemetry() {
        return this._disableTelemetry;
    }
    set disableTelemetry(value) {
        this._disableTelemetry = value;
    }
    resetDisableTelemetry() {
        this._disableTelemetry = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get disableTelemetryInput() {
        return this._disableTelemetry;
    }
    get driverTracing() {
        return this._driverTracing;
    }
    set driverTracing(value) {
        this._driverTracing = value;
    }
    resetDriverTracing() {
        this._driverTracing = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get driverTracingInput() {
        return this._driverTracing;
    }
    get externalBrowserTimeout() {
        return this._externalBrowserTimeout;
    }
    set externalBrowserTimeout(value) {
        this._externalBrowserTimeout = value;
    }
    resetExternalBrowserTimeout() {
        this._externalBrowserTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get externalBrowserTimeoutInput() {
        return this._externalBrowserTimeout;
    }
    get host() {
        return this._host;
    }
    set host(value) {
        this._host = value;
    }
    resetHost() {
        this._host = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get hostInput() {
        return this._host;
    }
    get includeRetryReason() {
        return this._includeRetryReason;
    }
    set includeRetryReason(value) {
        this._includeRetryReason = value;
    }
    resetIncludeRetryReason() {
        this._includeRetryReason = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get includeRetryReasonInput() {
        return this._includeRetryReason;
    }
    get insecureMode() {
        return this._insecureMode;
    }
    set insecureMode(value) {
        this._insecureMode = value;
    }
    resetInsecureMode() {
        this._insecureMode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get insecureModeInput() {
        return this._insecureMode;
    }
    get jwtClientTimeout() {
        return this._jwtClientTimeout;
    }
    set jwtClientTimeout(value) {
        this._jwtClientTimeout = value;
    }
    resetJwtClientTimeout() {
        this._jwtClientTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtClientTimeoutInput() {
        return this._jwtClientTimeout;
    }
    get jwtExpireTimeout() {
        return this._jwtExpireTimeout;
    }
    set jwtExpireTimeout(value) {
        this._jwtExpireTimeout = value;
    }
    resetJwtExpireTimeout() {
        this._jwtExpireTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get jwtExpireTimeoutInput() {
        return this._jwtExpireTimeout;
    }
    get keepSessionAlive() {
        return this._keepSessionAlive;
    }
    set keepSessionAlive(value) {
        this._keepSessionAlive = value;
    }
    resetKeepSessionAlive() {
        this._keepSessionAlive = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get keepSessionAliveInput() {
        return this._keepSessionAlive;
    }
    get loginTimeout() {
        return this._loginTimeout;
    }
    set loginTimeout(value) {
        this._loginTimeout = value;
    }
    resetLoginTimeout() {
        this._loginTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get loginTimeoutInput() {
        return this._loginTimeout;
    }
    get maxRetryCount() {
        return this._maxRetryCount;
    }
    set maxRetryCount(value) {
        this._maxRetryCount = value;
    }
    resetMaxRetryCount() {
        this._maxRetryCount = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get maxRetryCountInput() {
        return this._maxRetryCount;
    }
    get ocspFailOpen() {
        return this._ocspFailOpen;
    }
    set ocspFailOpen(value) {
        this._ocspFailOpen = value;
    }
    resetOcspFailOpen() {
        this._ocspFailOpen = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ocspFailOpenInput() {
        return this._ocspFailOpen;
    }
    get oktaUrl() {
        return this._oktaUrl;
    }
    set oktaUrl(value) {
        this._oktaUrl = value;
    }
    resetOktaUrl() {
        this._oktaUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get oktaUrlInput() {
        return this._oktaUrl;
    }
    get organizationName() {
        return this._organizationName;
    }
    set organizationName(value) {
        this._organizationName = value;
    }
    resetOrganizationName() {
        this._organizationName = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get organizationNameInput() {
        return this._organizationName;
    }
    get params() {
        return this._params;
    }
    set params(value) {
        this._params = value;
    }
    resetParams() {
        this._params = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get paramsInput() {
        return this._params;
    }
    get passcode() {
        return this._passcode;
    }
    set passcode(value) {
        this._passcode = value;
    }
    resetPasscode() {
        this._passcode = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passcodeInput() {
        return this._passcode;
    }
    get passcodeInPassword() {
        return this._passcodeInPassword;
    }
    set passcodeInPassword(value) {
        this._passcodeInPassword = value;
    }
    resetPasscodeInPassword() {
        this._passcodeInPassword = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passcodeInPasswordInput() {
        return this._passcodeInPassword;
    }
    get password() {
        return this._password;
    }
    set password(value) {
        this._password = value;
    }
    resetPassword() {
        this._password = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get passwordInput() {
        return this._password;
    }
    get port() {
        return this._port;
    }
    set port(value) {
        this._port = value;
    }
    resetPort() {
        this._port = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get portInput() {
        return this._port;
    }
    get previewFeaturesEnabled() {
        return this._previewFeaturesEnabled;
    }
    set previewFeaturesEnabled(value) {
        this._previewFeaturesEnabled = value;
    }
    resetPreviewFeaturesEnabled() {
        this._previewFeaturesEnabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get previewFeaturesEnabledInput() {
        return this._previewFeaturesEnabled;
    }
    get privateKey() {
        return this._privateKey;
    }
    set privateKey(value) {
        this._privateKey = value;
    }
    resetPrivateKey() {
        this._privateKey = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyInput() {
        return this._privateKey;
    }
    get privateKeyPassphrase() {
        return this._privateKeyPassphrase;
    }
    set privateKeyPassphrase(value) {
        this._privateKeyPassphrase = value;
    }
    resetPrivateKeyPassphrase() {
        this._privateKeyPassphrase = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get privateKeyPassphraseInput() {
        return this._privateKeyPassphrase;
    }
    get profile() {
        return this._profile;
    }
    set profile(value) {
        this._profile = value;
    }
    resetProfile() {
        this._profile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get profileInput() {
        return this._profile;
    }
    get protocol() {
        return this._protocol;
    }
    set protocol(value) {
        this._protocol = value;
    }
    resetProtocol() {
        this._protocol = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get protocolInput() {
        return this._protocol;
    }
    get requestTimeout() {
        return this._requestTimeout;
    }
    set requestTimeout(value) {
        this._requestTimeout = value;
    }
    resetRequestTimeout() {
        this._requestTimeout = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get requestTimeoutInput() {
        return this._requestTimeout;
    }
    get role() {
        return this._role;
    }
    set role(value) {
        this._role = value;
    }
    resetRole() {
        this._role = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get roleInput() {
        return this._role;
    }
    get skipTomlFilePermissionVerification() {
        return this._skipTomlFilePermissionVerification;
    }
    set skipTomlFilePermissionVerification(value) {
        this._skipTomlFilePermissionVerification = value;
    }
    resetSkipTomlFilePermissionVerification() {
        this._skipTomlFilePermissionVerification = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get skipTomlFilePermissionVerificationInput() {
        return this._skipTomlFilePermissionVerification;
    }
    get tmpDirectoryPath() {
        return this._tmpDirectoryPath;
    }
    set tmpDirectoryPath(value) {
        this._tmpDirectoryPath = value;
    }
    resetTmpDirectoryPath() {
        this._tmpDirectoryPath = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tmpDirectoryPathInput() {
        return this._tmpDirectoryPath;
    }
    get token() {
        return this._token;
    }
    set token(value) {
        this._token = value;
    }
    resetToken() {
        this._token = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenInput() {
        return this._token;
    }
    get useLegacyTomlFile() {
        return this._useLegacyTomlFile;
    }
    set useLegacyTomlFile(value) {
        this._useLegacyTomlFile = value;
    }
    resetUseLegacyTomlFile() {
        this._useLegacyTomlFile = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get useLegacyTomlFileInput() {
        return this._useLegacyTomlFile;
    }
    get user() {
        return this._user;
    }
    set user(value) {
        this._user = value;
    }
    resetUser() {
        this._user = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userInput() {
        return this._user;
    }
    get validateDefaultParameters() {
        return this._validateDefaultParameters;
    }
    set validateDefaultParameters(value) {
        this._validateDefaultParameters = value;
    }
    resetValidateDefaultParameters() {
        this._validateDefaultParameters = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get validateDefaultParametersInput() {
        return this._validateDefaultParameters;
    }
    get warehouse() {
        return this._warehouse;
    }
    set warehouse(value) {
        this._warehouse = value;
    }
    resetWarehouse() {
        this._warehouse = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warehouseInput() {
        return this._warehouse;
    }
    get alias() {
        return this._alias;
    }
    set alias(value) {
        this._alias = value;
    }
    resetAlias() {
        this._alias = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aliasInput() {
        return this._alias;
    }
    get tokenAccessor() {
        return this._tokenAccessor;
    }
    set tokenAccessor(value) {
        this._tokenAccessor = value;
    }
    resetTokenAccessor() {
        this._tokenAccessor = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get tokenAccessorInput() {
        return this._tokenAccessor;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_name: cdktf.stringToTerraform(this._accountName),
            authenticator: cdktf.stringToTerraform(this._authenticator),
            client_ip: cdktf.stringToTerraform(this._clientIp),
            client_request_mfa_token: cdktf.stringToTerraform(this._clientRequestMfaToken),
            client_store_temporary_credential: cdktf.stringToTerraform(this._clientStoreTemporaryCredential),
            client_timeout: cdktf.numberToTerraform(this._clientTimeout),
            disable_console_login: cdktf.stringToTerraform(this._disableConsoleLogin),
            disable_query_context_cache: cdktf.booleanToTerraform(this._disableQueryContextCache),
            disable_telemetry: cdktf.booleanToTerraform(this._disableTelemetry),
            driver_tracing: cdktf.stringToTerraform(this._driverTracing),
            external_browser_timeout: cdktf.numberToTerraform(this._externalBrowserTimeout),
            host: cdktf.stringToTerraform(this._host),
            include_retry_reason: cdktf.stringToTerraform(this._includeRetryReason),
            insecure_mode: cdktf.booleanToTerraform(this._insecureMode),
            jwt_client_timeout: cdktf.numberToTerraform(this._jwtClientTimeout),
            jwt_expire_timeout: cdktf.numberToTerraform(this._jwtExpireTimeout),
            keep_session_alive: cdktf.booleanToTerraform(this._keepSessionAlive),
            login_timeout: cdktf.numberToTerraform(this._loginTimeout),
            max_retry_count: cdktf.numberToTerraform(this._maxRetryCount),
            ocsp_fail_open: cdktf.stringToTerraform(this._ocspFailOpen),
            okta_url: cdktf.stringToTerraform(this._oktaUrl),
            organization_name: cdktf.stringToTerraform(this._organizationName),
            params: cdktf.hashMapper(cdktf.stringToTerraform)(this._params),
            passcode: cdktf.stringToTerraform(this._passcode),
            passcode_in_password: cdktf.booleanToTerraform(this._passcodeInPassword),
            password: cdktf.stringToTerraform(this._password),
            port: cdktf.numberToTerraform(this._port),
            preview_features_enabled: cdktf.listMapper(cdktf.stringToTerraform, false)(this._previewFeaturesEnabled),
            private_key: cdktf.stringToTerraform(this._privateKey),
            private_key_passphrase: cdktf.stringToTerraform(this._privateKeyPassphrase),
            profile: cdktf.stringToTerraform(this._profile),
            protocol: cdktf.stringToTerraform(this._protocol),
            request_timeout: cdktf.numberToTerraform(this._requestTimeout),
            role: cdktf.stringToTerraform(this._role),
            skip_toml_file_permission_verification: cdktf.booleanToTerraform(this._skipTomlFilePermissionVerification),
            tmp_directory_path: cdktf.stringToTerraform(this._tmpDirectoryPath),
            token: cdktf.stringToTerraform(this._token),
            use_legacy_toml_file: cdktf.booleanToTerraform(this._useLegacyTomlFile),
            user: cdktf.stringToTerraform(this._user),
            validate_default_parameters: cdktf.stringToTerraform(this._validateDefaultParameters),
            warehouse: cdktf.stringToTerraform(this._warehouse),
            alias: cdktf.stringToTerraform(this._alias),
            token_accessor: snowflakeProviderTokenAccessorToTerraform(this._tokenAccessor),
        };
    }
    synthesizeHclAttributes() {
        const attrs = {
            account_name: {
                value: cdktf.stringToHclTerraform(this._accountName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            authenticator: {
                value: cdktf.stringToHclTerraform(this._authenticator),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_ip: {
                value: cdktf.stringToHclTerraform(this._clientIp),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_request_mfa_token: {
                value: cdktf.stringToHclTerraform(this._clientRequestMfaToken),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_store_temporary_credential: {
                value: cdktf.stringToHclTerraform(this._clientStoreTemporaryCredential),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            client_timeout: {
                value: cdktf.numberToHclTerraform(this._clientTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            disable_console_login: {
                value: cdktf.stringToHclTerraform(this._disableConsoleLogin),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            disable_query_context_cache: {
                value: cdktf.booleanToHclTerraform(this._disableQueryContextCache),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            disable_telemetry: {
                value: cdktf.booleanToHclTerraform(this._disableTelemetry),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            driver_tracing: {
                value: cdktf.stringToHclTerraform(this._driverTracing),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            external_browser_timeout: {
                value: cdktf.numberToHclTerraform(this._externalBrowserTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            host: {
                value: cdktf.stringToHclTerraform(this._host),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            include_retry_reason: {
                value: cdktf.stringToHclTerraform(this._includeRetryReason),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            insecure_mode: {
                value: cdktf.booleanToHclTerraform(this._insecureMode),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            jwt_client_timeout: {
                value: cdktf.numberToHclTerraform(this._jwtClientTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            jwt_expire_timeout: {
                value: cdktf.numberToHclTerraform(this._jwtExpireTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            keep_session_alive: {
                value: cdktf.booleanToHclTerraform(this._keepSessionAlive),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            login_timeout: {
                value: cdktf.numberToHclTerraform(this._loginTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            max_retry_count: {
                value: cdktf.numberToHclTerraform(this._maxRetryCount),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            ocsp_fail_open: {
                value: cdktf.stringToHclTerraform(this._ocspFailOpen),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            okta_url: {
                value: cdktf.stringToHclTerraform(this._oktaUrl),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            organization_name: {
                value: cdktf.stringToHclTerraform(this._organizationName),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            params: {
                value: cdktf.hashMapperHcl(cdktf.stringToHclTerraform)(this._params),
                isBlock: false,
                type: "map",
                storageClassType: "stringMap",
            },
            passcode: {
                value: cdktf.stringToHclTerraform(this._passcode),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            passcode_in_password: {
                value: cdktf.booleanToHclTerraform(this._passcodeInPassword),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            password: {
                value: cdktf.stringToHclTerraform(this._password),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            port: {
                value: cdktf.numberToHclTerraform(this._port),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            preview_features_enabled: {
                value: cdktf.listMapperHcl(cdktf.stringToHclTerraform, false)(this._previewFeaturesEnabled),
                isBlock: false,
                type: "set",
                storageClassType: "stringList",
            },
            private_key: {
                value: cdktf.stringToHclTerraform(this._privateKey),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            private_key_passphrase: {
                value: cdktf.stringToHclTerraform(this._privateKeyPassphrase),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            profile: {
                value: cdktf.stringToHclTerraform(this._profile),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            protocol: {
                value: cdktf.stringToHclTerraform(this._protocol),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            request_timeout: {
                value: cdktf.numberToHclTerraform(this._requestTimeout),
                isBlock: false,
                type: "simple",
                storageClassType: "number",
            },
            role: {
                value: cdktf.stringToHclTerraform(this._role),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            skip_toml_file_permission_verification: {
                value: cdktf.booleanToHclTerraform(this._skipTomlFilePermissionVerification),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            tmp_directory_path: {
                value: cdktf.stringToHclTerraform(this._tmpDirectoryPath),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            token: {
                value: cdktf.stringToHclTerraform(this._token),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            use_legacy_toml_file: {
                value: cdktf.booleanToHclTerraform(this._useLegacyTomlFile),
                isBlock: false,
                type: "simple",
                storageClassType: "boolean",
            },
            user: {
                value: cdktf.stringToHclTerraform(this._user),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            validate_default_parameters: {
                value: cdktf.stringToHclTerraform(this._validateDefaultParameters),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            warehouse: {
                value: cdktf.stringToHclTerraform(this._warehouse),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            alias: {
                value: cdktf.stringToHclTerraform(this._alias),
                isBlock: false,
                type: "simple",
                storageClassType: "string",
            },
            token_accessor: {
                value: snowflakeProviderTokenAccessorToHclTerraform(this._tokenAccessor),
                isBlock: true,
                type: "list",
                storageClassType: "SnowflakeProviderTokenAccessorList",
            },
        };
        // remove undefined attributes
        return Object.fromEntries(Object.entries(attrs).filter(([_, value]) => value !== undefined && value.value !== undefined));
    }
}
exports.SnowflakeProvider = SnowflakeProvider;
_a = JSII_RTTI_SYMBOL_1;
SnowflakeProvider[_a] = { fqn: "@cdktf/provider-snowflake.provider.SnowflakeProvider", version: "15.1.0" };
// =================
// STATIC PROPERTIES
// =================
SnowflakeProvider.tfResourceType = "snowflake";
//# sourceMappingURL=data:application/json;base64,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