/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ResourceMonitorConfig extends cdktf.TerraformMetaArguments {
    /**
    * The number of credits allocated to the resource monitor per frequency interval. When total usage for all warehouses assigned to the monitor reaches this number for the current frequency interval, the resource monitor is considered to be at 100% of quota.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#credit_quota ResourceMonitor#credit_quota}
    */
    readonly creditQuota?: number;
    /**
    * The date and time when the resource monitor suspends the assigned warehouses.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#end_timestamp ResourceMonitor#end_timestamp}
    */
    readonly endTimestamp?: string;
    /**
    * The frequency interval at which the credit usage resets to 0. Valid values are (case-insensitive): `MONTHLY` | `DAILY` | `WEEKLY` | `YEARLY` | `NEVER`. If you set a `frequency` for a resource monitor, you must also set `start_timestamp`. If you specify `NEVER` for the frequency, the credit usage for the warehouse does not reset. After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#frequency ResourceMonitor#frequency}
    */
    readonly frequency?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#id ResourceMonitor#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Identifier for the resource monitor; must be unique for your account. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#name ResourceMonitor#name}
    */
    readonly name: string;
    /**
    * Specifies a list of percentages of the credit quota. After reaching any of the values the users passed in the notify_users field will be notified (to receive the notification they should have notifications enabled). Values over 100 are supported.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#notify_triggers ResourceMonitor#notify_triggers}
    */
    readonly notifyTriggers?: number[];
    /**
    * Specifies the list of users (their identifiers) to receive email notifications on resource monitors. For more information about this resource, see [docs](./user).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#notify_users ResourceMonitor#notify_users}
    */
    readonly notifyUsers?: string[];
    /**
    * The date and time when the resource monitor starts monitoring credit usage for the assigned warehouses. If you set a `start_timestamp` for a resource monitor, you must also set `frequency`.  After removing this field from the config, the previously set value will be preserved on the Snowflake side, not the default value. That's due to Snowflake limitation and the lack of unset functionality for this parameter.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#start_timestamp ResourceMonitor#start_timestamp}
    */
    readonly startTimestamp?: string;
    /**
    * Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses immediately cancel any currently running queries or statements. In addition, this action sends a notification to all users who have enabled notifications for themselves.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#suspend_immediate_trigger ResourceMonitor#suspend_immediate_trigger}
    */
    readonly suspendImmediateTrigger?: number;
    /**
    * Represents a numeric value specified as a percentage of the credit quota. Values over 100 are supported. After reaching this value, all assigned warehouses while allowing currently running queries to complete will be suspended. No new queries can be executed by the warehouses until the credit quota for the resource monitor is increased. In addition, this action sends a notification to all users who have enabled notifications for themselves.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#suspend_trigger ResourceMonitor#suspend_trigger}
    */
    readonly suspendTrigger?: number;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#timeouts ResourceMonitor#timeouts}
    */
    readonly timeouts?: ResourceMonitorTimeouts;
}
export interface ResourceMonitorShowOutput {
}
export declare function resourceMonitorShowOutputToTerraform(struct?: ResourceMonitorShowOutput): any;
export declare function resourceMonitorShowOutputToHclTerraform(struct?: ResourceMonitorShowOutput): any;
export declare class ResourceMonitorShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ResourceMonitorShowOutput | undefined;
    set internalValue(value: ResourceMonitorShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get creditQuota(): number;
    get endTime(): string;
    get frequency(): string;
    get level(): string;
    get name(): string;
    get owner(): string;
    get remainingCredits(): number;
    get startTime(): string;
    get suspendAt(): number;
    get suspendImmediateAt(): number;
    get usedCredits(): number;
}
export declare class ResourceMonitorShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ResourceMonitorShowOutputOutputReference;
}
export interface ResourceMonitorTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#create ResourceMonitor#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#delete ResourceMonitor#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#read ResourceMonitor#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#update ResourceMonitor#update}
    */
    readonly update?: string;
}
export declare function resourceMonitorTimeoutsToTerraform(struct?: ResourceMonitorTimeouts | cdktf.IResolvable): any;
export declare function resourceMonitorTimeoutsToHclTerraform(struct?: ResourceMonitorTimeouts | cdktf.IResolvable): any;
export declare class ResourceMonitorTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ResourceMonitorTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ResourceMonitorTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor snowflake_resource_monitor}
*/
export declare class ResourceMonitor extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_resource_monitor";
    /**
    * Generates CDKTF code for importing a ResourceMonitor resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ResourceMonitor to import
    * @param importFromId The id of the existing ResourceMonitor that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ResourceMonitor to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/resource_monitor snowflake_resource_monitor} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ResourceMonitorConfig
    */
    constructor(scope: Construct, id: string, config: ResourceMonitorConfig);
    private _creditQuota?;
    get creditQuota(): number;
    set creditQuota(value: number);
    resetCreditQuota(): void;
    get creditQuotaInput(): number | undefined;
    private _endTimestamp?;
    get endTimestamp(): string;
    set endTimestamp(value: string);
    resetEndTimestamp(): void;
    get endTimestampInput(): string | undefined;
    private _frequency?;
    get frequency(): string;
    set frequency(value: string);
    resetFrequency(): void;
    get frequencyInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _notifyTriggers?;
    get notifyTriggers(): number[];
    set notifyTriggers(value: number[]);
    resetNotifyTriggers(): void;
    get notifyTriggersInput(): number[] | undefined;
    private _notifyUsers?;
    get notifyUsers(): string[];
    set notifyUsers(value: string[]);
    resetNotifyUsers(): void;
    get notifyUsersInput(): string[] | undefined;
    private _showOutput;
    get showOutput(): ResourceMonitorShowOutputList;
    private _startTimestamp?;
    get startTimestamp(): string;
    set startTimestamp(value: string);
    resetStartTimestamp(): void;
    get startTimestampInput(): string | undefined;
    private _suspendImmediateTrigger?;
    get suspendImmediateTrigger(): number;
    set suspendImmediateTrigger(value: number);
    resetSuspendImmediateTrigger(): void;
    get suspendImmediateTriggerInput(): number | undefined;
    private _suspendTrigger?;
    get suspendTrigger(): number;
    set suspendTrigger(value: number);
    resetSuspendTrigger(): void;
    get suspendTriggerInput(): number | undefined;
    private _timeouts;
    get timeouts(): ResourceMonitorTimeoutsOutputReference;
    putTimeouts(value: ResourceMonitorTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ResourceMonitorTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
