/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecondaryConnectionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the identifier for a primary connection from which to create a replica (i.e. a secondary connection). For more information about this resource, see [docs](./primary_connection).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#as_replica_of SecondaryConnection#as_replica_of}
    */
    readonly asReplicaOf: string;
    /**
    * Specifies a comment for the secondary connection.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#comment SecondaryConnection#comment}
    */
    readonly comment?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#id SecondaryConnection#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String that specifies the identifier (i.e. name) for the connection. Must start with an alphabetic character and may only contain letters, decimal digits (0-9), and underscores (_). For a secondary connection, the name must match the name of its primary connection. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#name SecondaryConnection#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#timeouts SecondaryConnection#timeouts}
    */
    readonly timeouts?: SecondaryConnectionTimeouts;
}
export interface SecondaryConnectionShowOutput {
}
export declare function secondaryConnectionShowOutputToTerraform(struct?: SecondaryConnectionShowOutput): any;
export declare function secondaryConnectionShowOutputToHclTerraform(struct?: SecondaryConnectionShowOutput): any;
export declare class SecondaryConnectionShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecondaryConnectionShowOutput | undefined;
    set internalValue(value: SecondaryConnectionShowOutput | undefined);
    get accountLocator(): string;
    get accountName(): string;
    get comment(): string;
    get connectionUrl(): string;
    get createdOn(): string;
    get failoverAllowedToAccounts(): string[];
    get isPrimary(): cdktf.IResolvable;
    get name(): string;
    get organizationName(): string;
    get primary(): string;
    get regionGroup(): string;
    get snowflakeRegion(): string;
}
export declare class SecondaryConnectionShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecondaryConnectionShowOutputOutputReference;
}
export interface SecondaryConnectionTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#create SecondaryConnection#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#delete SecondaryConnection#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#read SecondaryConnection#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#update SecondaryConnection#update}
    */
    readonly update?: string;
}
export declare function secondaryConnectionTimeoutsToTerraform(struct?: SecondaryConnectionTimeouts | cdktf.IResolvable): any;
export declare function secondaryConnectionTimeoutsToHclTerraform(struct?: SecondaryConnectionTimeouts | cdktf.IResolvable): any;
export declare class SecondaryConnectionTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecondaryConnectionTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecondaryConnectionTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection snowflake_secondary_connection}
*/
export declare class SecondaryConnection extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_secondary_connection";
    /**
    * Generates CDKTF code for importing a SecondaryConnection resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecondaryConnection to import
    * @param importFromId The id of the existing SecondaryConnection that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecondaryConnection to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secondary_connection snowflake_secondary_connection} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecondaryConnectionConfig
    */
    constructor(scope: Construct, id: string, config: SecondaryConnectionConfig);
    private _asReplicaOf?;
    get asReplicaOf(): string;
    set asReplicaOf(value: string);
    get asReplicaOfInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    get isPrimary(): cdktf.IResolvable;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _showOutput;
    get showOutput(): SecondaryConnectionShowOutputList;
    private _timeouts;
    get timeouts(): SecondaryConnectionTimeoutsOutputReference;
    putTimeouts(value: SecondaryConnectionTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecondaryConnectionTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
