/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretWithAuthorizationCodeGrantConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the name value of the Snowflake security integration that connects Snowflake to an external service. For more information about this resource, see [docs](./api_authentication_integration_with_authorization_code_grant).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#api_authentication SecretWithAuthorizationCodeGrant#api_authentication}
    */
    readonly apiAuthentication: string;
    /**
    * Specifies a comment for the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#comment SecretWithAuthorizationCodeGrant#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the secret Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#database SecretWithAuthorizationCodeGrant#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#id SecretWithAuthorizationCodeGrant#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String that specifies the identifier (i.e. name) for the secret, must be unique in your schema. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#name SecretWithAuthorizationCodeGrant#name}
    */
    readonly name: string;
    /**
    * Specifies the token as a string that is used to obtain a new access token from the OAuth authorization server when the access token expires. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#oauth_refresh_token SecretWithAuthorizationCodeGrant#oauth_refresh_token}
    */
    readonly oauthRefreshToken: string;
    /**
    * Specifies the timestamp as a string when the OAuth refresh token expires. Accepted string formats: YYYY-MM-DD, YYYY-MM-DD HH:MI, YYYY-MM-DD HH:MI:SS, YYYY-MM-DD HH:MI <timezone>
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#oauth_refresh_token_expiry_time SecretWithAuthorizationCodeGrant#oauth_refresh_token_expiry_time}
    */
    readonly oauthRefreshTokenExpiryTime: string;
    /**
    * The schema in which to create the secret. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#schema SecretWithAuthorizationCodeGrant#schema}
    */
    readonly schema: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#timeouts SecretWithAuthorizationCodeGrant#timeouts}
    */
    readonly timeouts?: SecretWithAuthorizationCodeGrantTimeouts;
}
export interface SecretWithAuthorizationCodeGrantDescribeOutput {
}
export declare function secretWithAuthorizationCodeGrantDescribeOutputToTerraform(struct?: SecretWithAuthorizationCodeGrantDescribeOutput): any;
export declare function secretWithAuthorizationCodeGrantDescribeOutputToHclTerraform(struct?: SecretWithAuthorizationCodeGrantDescribeOutput): any;
export declare class SecretWithAuthorizationCodeGrantDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithAuthorizationCodeGrantDescribeOutput | undefined;
    set internalValue(value: SecretWithAuthorizationCodeGrantDescribeOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get integrationName(): string;
    get name(): string;
    get oauthAccessTokenExpiryTime(): string;
    get oauthRefreshTokenExpiryTime(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get schemaName(): string;
    get secretType(): string;
    get username(): string;
}
export declare class SecretWithAuthorizationCodeGrantDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithAuthorizationCodeGrantDescribeOutputOutputReference;
}
export interface SecretWithAuthorizationCodeGrantShowOutput {
}
export declare function secretWithAuthorizationCodeGrantShowOutputToTerraform(struct?: SecretWithAuthorizationCodeGrantShowOutput): any;
export declare function secretWithAuthorizationCodeGrantShowOutputToHclTerraform(struct?: SecretWithAuthorizationCodeGrantShowOutput): any;
export declare class SecretWithAuthorizationCodeGrantShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithAuthorizationCodeGrantShowOutput | undefined;
    set internalValue(value: SecretWithAuthorizationCodeGrantShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get secretType(): string;
}
export declare class SecretWithAuthorizationCodeGrantShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithAuthorizationCodeGrantShowOutputOutputReference;
}
export interface SecretWithAuthorizationCodeGrantTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#create SecretWithAuthorizationCodeGrant#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#delete SecretWithAuthorizationCodeGrant#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#read SecretWithAuthorizationCodeGrant#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#update SecretWithAuthorizationCodeGrant#update}
    */
    readonly update?: string;
}
export declare function secretWithAuthorizationCodeGrantTimeoutsToTerraform(struct?: SecretWithAuthorizationCodeGrantTimeouts | cdktf.IResolvable): any;
export declare function secretWithAuthorizationCodeGrantTimeoutsToHclTerraform(struct?: SecretWithAuthorizationCodeGrantTimeouts | cdktf.IResolvable): any;
export declare class SecretWithAuthorizationCodeGrantTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretWithAuthorizationCodeGrantTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecretWithAuthorizationCodeGrantTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant snowflake_secret_with_authorization_code_grant}
*/
export declare class SecretWithAuthorizationCodeGrant extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_secret_with_authorization_code_grant";
    /**
    * Generates CDKTF code for importing a SecretWithAuthorizationCodeGrant resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecretWithAuthorizationCodeGrant to import
    * @param importFromId The id of the existing SecretWithAuthorizationCodeGrant that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecretWithAuthorizationCodeGrant to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_authorization_code_grant snowflake_secret_with_authorization_code_grant} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretWithAuthorizationCodeGrantConfig
    */
    constructor(scope: Construct, id: string, config: SecretWithAuthorizationCodeGrantConfig);
    private _apiAuthentication?;
    get apiAuthentication(): string;
    set apiAuthentication(value: string);
    get apiAuthenticationInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): SecretWithAuthorizationCodeGrantDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oauthRefreshToken?;
    get oauthRefreshToken(): string;
    set oauthRefreshToken(value: string);
    get oauthRefreshTokenInput(): string | undefined;
    private _oauthRefreshTokenExpiryTime?;
    get oauthRefreshTokenExpiryTime(): string;
    set oauthRefreshTokenExpiryTime(value: string);
    get oauthRefreshTokenExpiryTimeInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    get secretType(): string;
    private _showOutput;
    get showOutput(): SecretWithAuthorizationCodeGrantShowOutputList;
    private _timeouts;
    get timeouts(): SecretWithAuthorizationCodeGrantTimeoutsOutputReference;
    putTimeouts(value: SecretWithAuthorizationCodeGrantTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecretWithAuthorizationCodeGrantTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
