/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SecretWithClientCredentialsConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the name value of the Snowflake security integration that connects Snowflake to an external service. For more information about this resource, see [docs](./api_authentication_integration_with_client_credentials).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#api_authentication SecretWithClientCredentials#api_authentication}
    */
    readonly apiAuthentication: string;
    /**
    * Specifies a comment for the secret.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#comment SecretWithClientCredentials#comment}
    */
    readonly comment?: string;
    /**
    * The database in which to create the secret Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#database SecretWithClientCredentials#database}
    */
    readonly database: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#id SecretWithClientCredentials#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * String that specifies the identifier (i.e. name) for the secret, must be unique in your schema. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#name SecretWithClientCredentials#name}
    */
    readonly name: string;
    /**
    * Specifies a list of scopes to use when making a request from the OAuth server by a role with USAGE on the integration during the OAuth client credentials flow.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#oauth_scopes SecretWithClientCredentials#oauth_scopes}
    */
    readonly oauthScopes: string[];
    /**
    * The schema in which to create the secret. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#schema SecretWithClientCredentials#schema}
    */
    readonly schema: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#timeouts SecretWithClientCredentials#timeouts}
    */
    readonly timeouts?: SecretWithClientCredentialsTimeouts;
}
export interface SecretWithClientCredentialsDescribeOutput {
}
export declare function secretWithClientCredentialsDescribeOutputToTerraform(struct?: SecretWithClientCredentialsDescribeOutput): any;
export declare function secretWithClientCredentialsDescribeOutputToHclTerraform(struct?: SecretWithClientCredentialsDescribeOutput): any;
export declare class SecretWithClientCredentialsDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithClientCredentialsDescribeOutput | undefined;
    set internalValue(value: SecretWithClientCredentialsDescribeOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get integrationName(): string;
    get name(): string;
    get oauthAccessTokenExpiryTime(): string;
    get oauthRefreshTokenExpiryTime(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get schemaName(): string;
    get secretType(): string;
    get username(): string;
}
export declare class SecretWithClientCredentialsDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithClientCredentialsDescribeOutputOutputReference;
}
export interface SecretWithClientCredentialsShowOutput {
}
export declare function secretWithClientCredentialsShowOutputToTerraform(struct?: SecretWithClientCredentialsShowOutput): any;
export declare function secretWithClientCredentialsShowOutputToHclTerraform(struct?: SecretWithClientCredentialsShowOutput): any;
export declare class SecretWithClientCredentialsShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): SecretWithClientCredentialsShowOutput | undefined;
    set internalValue(value: SecretWithClientCredentialsShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get databaseName(): string;
    get name(): string;
    get oauthScopes(): string[];
    get owner(): string;
    get ownerRoleType(): string;
    get schemaName(): string;
    get secretType(): string;
}
export declare class SecretWithClientCredentialsShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): SecretWithClientCredentialsShowOutputOutputReference;
}
export interface SecretWithClientCredentialsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#create SecretWithClientCredentials#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#delete SecretWithClientCredentials#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#read SecretWithClientCredentials#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#update SecretWithClientCredentials#update}
    */
    readonly update?: string;
}
export declare function secretWithClientCredentialsTimeoutsToTerraform(struct?: SecretWithClientCredentialsTimeouts | cdktf.IResolvable): any;
export declare function secretWithClientCredentialsTimeoutsToHclTerraform(struct?: SecretWithClientCredentialsTimeouts | cdktf.IResolvable): any;
export declare class SecretWithClientCredentialsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): SecretWithClientCredentialsTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: SecretWithClientCredentialsTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials snowflake_secret_with_client_credentials}
*/
export declare class SecretWithClientCredentials extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_secret_with_client_credentials";
    /**
    * Generates CDKTF code for importing a SecretWithClientCredentials resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the SecretWithClientCredentials to import
    * @param importFromId The id of the existing SecretWithClientCredentials that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the SecretWithClientCredentials to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/secret_with_client_credentials snowflake_secret_with_client_credentials} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SecretWithClientCredentialsConfig
    */
    constructor(scope: Construct, id: string, config: SecretWithClientCredentialsConfig);
    private _apiAuthentication?;
    get apiAuthentication(): string;
    set apiAuthentication(value: string);
    get apiAuthenticationInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): SecretWithClientCredentialsDescribeOutputList;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _oauthScopes?;
    get oauthScopes(): string[];
    set oauthScopes(value: string[]);
    get oauthScopesInput(): string[] | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    get secretType(): string;
    private _showOutput;
    get showOutput(): SecretWithClientCredentialsShowOutputList;
    private _timeouts;
    get timeouts(): SecretWithClientCredentialsTimeoutsOutputReference;
    putTimeouts(value: SecretWithClientCredentialsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | SecretWithClientCredentialsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
