/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceUserConfig extends cdktf.TerraformMetaArguments {
    /**
    * Specifies the action that Snowflake performs for in-progress queries if connectivity is lost due to abrupt termination of a session (e.g. network outage, browser termination, service interruption). For more information, check [ABORT_DETACHED_QUERY docs](https://docs.snowflake.com/en/sql-reference/parameters#abort-detached-query).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#abort_detached_query ServiceUser#abort_detached_query}
    */
    readonly abortDetachedQuery?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether autocommit is enabled for the session. Autocommit determines whether a DML statement, when executed without an active transaction, is automatically committed after the statement successfully completes. For more information, see [Transactions](https://docs.snowflake.com/en/sql-reference/transactions). For more information, check [AUTOCOMMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#autocommit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#autocommit ServiceUser#autocommit}
    */
    readonly autocommit?: boolean | cdktf.IResolvable;
    /**
    * The format of VARCHAR values passed as input to VARCHAR-to-BINARY conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#binary_input_format ServiceUser#binary_input_format}
    */
    readonly binaryInputFormat?: string;
    /**
    * The format for VARCHAR values returned as output by BINARY-to-VARCHAR conversion functions. For more information, see [Binary input and output](https://docs.snowflake.com/en/sql-reference/binary-input-output). For more information, check [BINARY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#binary-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#binary_output_format ServiceUser#binary_output_format}
    */
    readonly binaryOutputFormat?: string;
    /**
    * Parameter that specifies the maximum amount of memory the JDBC driver or ODBC driver should use for the result set from queries (in MB). For more information, check [CLIENT_MEMORY_LIMIT docs](https://docs.snowflake.com/en/sql-reference/parameters#client-memory-limit).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_memory_limit ServiceUser#client_memory_limit}
    */
    readonly clientMemoryLimit?: number;
    /**
    * For specific ODBC functions and JDBC methods, this parameter can change the default search scope from all databases/schemas to the current database/schema. The narrower search typically returns fewer rows and executes more quickly. For more information, check [CLIENT_METADATA_REQUEST_USE_CONNECTION_CTX docs](https://docs.snowflake.com/en/sql-reference/parameters#client-metadata-request-use-connection-ctx).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_metadata_request_use_connection_ctx ServiceUser#client_metadata_request_use_connection_ctx}
    */
    readonly clientMetadataRequestUseConnectionCtx?: boolean | cdktf.IResolvable;
    /**
    * Parameter that specifies the number of threads used by the client to pre-fetch large result sets. The driver will attempt to honor the parameter value, but defines the minimum and maximum values (depending on your system’s resources) to improve performance. For more information, check [CLIENT_PREFETCH_THREADS docs](https://docs.snowflake.com/en/sql-reference/parameters#client-prefetch-threads).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_prefetch_threads ServiceUser#client_prefetch_threads}
    */
    readonly clientPrefetchThreads?: number;
    /**
    * Parameter that specifies the maximum size of each set (or chunk) of query results to download (in MB). The JDBC driver downloads query results in chunks. For more information, check [CLIENT_RESULT_CHUNK_SIZE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-chunk-size).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_result_chunk_size ServiceUser#client_result_chunk_size}
    */
    readonly clientResultChunkSize?: number;
    /**
    * Parameter that indicates whether to match column name case-insensitively in ResultSet.get* methods in JDBC. For more information, check [CLIENT_RESULT_COLUMN_CASE_INSENSITIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-result-column-case-insensitive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_result_column_case_insensitive ServiceUser#client_result_column_case_insensitive}
    */
    readonly clientResultColumnCaseInsensitive?: boolean | cdktf.IResolvable;
    /**
    * Parameter that indicates whether to force a user to log in again after a period of inactivity in the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_session_keep_alive ServiceUser#client_session_keep_alive}
    */
    readonly clientSessionKeepAlive?: boolean | cdktf.IResolvable;
    /**
    * Number of seconds in-between client attempts to update the token for the session. For more information, check [CLIENT_SESSION_KEEP_ALIVE_HEARTBEAT_FREQUENCY docs](https://docs.snowflake.com/en/sql-reference/parameters#client-session-keep-alive-heartbeat-frequency).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_session_keep_alive_heartbeat_frequency ServiceUser#client_session_keep_alive_heartbeat_frequency}
    */
    readonly clientSessionKeepAliveHeartbeatFrequency?: number;
    /**
    * Specifies the [TIMESTAMP_* variation](https://docs.snowflake.com/en/sql-reference/data-types-datetime.html#label-datatypes-timestamp-variations) to use when binding timestamp variables for JDBC or ODBC applications that use the bind API to load data. For more information, check [CLIENT_TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#client-timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#client_timestamp_type_mapping ServiceUser#client_timestamp_type_mapping}
    */
    readonly clientTimestampTypeMapping?: string;
    /**
    * Specifies a comment for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#comment ServiceUser#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the input format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#date_input_format ServiceUser#date_input_format}
    */
    readonly dateInputFormat?: string;
    /**
    * Specifies the display format for the DATE data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [DATE_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#date-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#date_output_format ServiceUser#date_output_format}
    */
    readonly dateOutputFormat?: string;
    /**
    * Specifies the number of days after which the user status is set to `Expired` and the user is no longer allowed to log in. This is useful for defining temporary users (i.e. users who should only have access to Snowflake for a limited time period). In general, you should not set this property for [account administrators](https://docs.snowflake.com/en/user-guide/security-access-control-considerations.html#label-accountadmin-users) (i.e. users with the `ACCOUNTADMIN` role) because Snowflake locks them out when they become `Expired`. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#days_to_expiry ServiceUser#days_to_expiry}
    */
    readonly daysToExpiry?: number;
    /**
    * Specifies the namespace (database only or database and schema) that is active by default for the user’s session upon login. Note that the CREATE USER operation does not verify that the namespace exists.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#default_namespace ServiceUser#default_namespace}
    */
    readonly defaultNamespace?: string;
    /**
    * Specifies the role that is active by default for the user’s session upon login. Note that specifying a default role for a user does **not** grant the role to the user. The role must be granted explicitly to the user using the [GRANT ROLE](https://docs.snowflake.com/en/sql-reference/sql/grant-role) command. In addition, the CREATE USER operation does not verify that the role exists. For more information about this resource, see [docs](./account_role).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#default_role ServiceUser#default_role}
    */
    readonly defaultRole?: string;
    /**
    * (Default: `DEFAULT`) Specifies the secondary roles that are active for the user’s session upon login. Valid values are (case-insensitive): `DEFAULT` | `NONE` | `ALL`. More information can be found in [doc](https://docs.snowflake.com/en/sql-reference/sql/create-user#optional-object-properties-objectproperties).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#default_secondary_roles_option ServiceUser#default_secondary_roles_option}
    */
    readonly defaultSecondaryRolesOption?: string;
    /**
    * Specifies the virtual warehouse that is active by default for the user’s session upon login. Note that the CREATE USER operation does not verify that the warehouse exists. For more information about this resource, see [docs](./warehouse).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#default_warehouse ServiceUser#default_warehouse}
    */
    readonly defaultWarehouse?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether the user is disabled, which prevents logging in and aborts all the currently-running queries for the user. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#disabled ServiceUser#disabled}
    */
    readonly disabled?: string;
    /**
    * Name displayed for the user in the Snowflake web interface.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#display_name ServiceUser#display_name}
    */
    readonly displayName?: string;
    /**
    * Email address for the user.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#email ServiceUser#email}
    */
    readonly email?: string;
    /**
    * Specifies whether to set the schema for unloaded Parquet files based on the logical column data types (i.e. the types in the unload SQL query or source table) or on the unloaded column values (i.e. the smallest data types and precision that support the values in the output columns of the unload SQL statement or source table). For more information, check [ENABLE_UNLOAD_PHYSICAL_TYPE_OPTIMIZATION docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unload-physical-type-optimization).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#enable_unload_physical_type_optimization ServiceUser#enable_unload_physical_type_optimization}
    */
    readonly enableUnloadPhysicalTypeOptimization?: boolean | cdktf.IResolvable;
    /**
    * Controls whether query text is redacted if a SQL query fails due to a syntax or parsing error. If `FALSE`, the content of a failed query is redacted in the views, pages, and functions that provide a query history. Only users with a role that is granted or inherits the AUDIT privilege can set the ENABLE_UNREDACTED_QUERY_SYNTAX_ERROR parameter. When using the ALTER USER command to set the parameter to `TRUE` for a particular user, modify the user that you want to see the query text, not the user who executed the query (if those are different users). For more information, check [ENABLE_UNREDACTED_QUERY_SYNTAX_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#enable-unredacted-query-syntax-error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#enable_unredacted_query_syntax_error ServiceUser#enable_unredacted_query_syntax_error}
    */
    readonly enableUnredactedQuerySyntaxError?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to return an error when the [MERGE](https://docs.snowflake.com/en/sql-reference/sql/merge) command is used to update or delete a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_MERGE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-merge).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#error_on_nondeterministic_merge ServiceUser#error_on_nondeterministic_merge}
    */
    readonly errorOnNondeterministicMerge?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to return an error when the [UPDATE](https://docs.snowflake.com/en/sql-reference/sql/update) command is used to update a target row that joins multiple source rows and the system cannot determine the action to perform on the target row. For more information, check [ERROR_ON_NONDETERMINISTIC_UPDATE docs](https://docs.snowflake.com/en/sql-reference/parameters#error-on-nondeterministic-update).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#error_on_nondeterministic_update ServiceUser#error_on_nondeterministic_update}
    */
    readonly errorOnNondeterministicUpdate?: boolean | cdktf.IResolvable;
    /**
    * Display format for [GEOGRAPHY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geography). For more information, check [GEOGRAPHY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geography-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#geography_output_format ServiceUser#geography_output_format}
    */
    readonly geographyOutputFormat?: string;
    /**
    * Display format for [GEOMETRY values](https://docs.snowflake.com/en/sql-reference/data-types-geospatial.html#label-data-types-geometry). For more information, check [GEOMETRY_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#geometry-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#geometry_output_format ServiceUser#geometry_output_format}
    */
    readonly geometryOutputFormat?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#id ServiceUser#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies how JDBC processes columns that have a scale of zero (0). For more information, check [JDBC_TREAT_DECIMAL_AS_INT docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-decimal-as-int).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#jdbc_treat_decimal_as_int ServiceUser#jdbc_treat_decimal_as_int}
    */
    readonly jdbcTreatDecimalAsInt?: boolean | cdktf.IResolvable;
    /**
    * Specifies how JDBC processes TIMESTAMP_NTZ values. For more information, check [JDBC_TREAT_TIMESTAMP_NTZ_AS_UTC docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-treat-timestamp-ntz-as-utc).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#jdbc_treat_timestamp_ntz_as_utc ServiceUser#jdbc_treat_timestamp_ntz_as_utc}
    */
    readonly jdbcTreatTimestampNtzAsUtc?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether the JDBC Driver uses the time zone of the JVM or the time zone of the session (specified by the [TIMEZONE](https://docs.snowflake.com/en/sql-reference/parameters#label-timezone) parameter) for the getDate(), getTime(), and getTimestamp() methods of the ResultSet class. For more information, check [JDBC_USE_SESSION_TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#jdbc-use-session-timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#jdbc_use_session_timezone ServiceUser#jdbc_use_session_timezone}
    */
    readonly jdbcUseSessionTimezone?: boolean | cdktf.IResolvable;
    /**
    * Specifies the number of blank spaces to indent each new element in JSON output in the session. Also specifies whether to insert newline characters after each element. For more information, check [JSON_INDENT docs](https://docs.snowflake.com/en/sql-reference/parameters#json-indent).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#json_indent ServiceUser#json_indent}
    */
    readonly jsonIndent?: number;
    /**
    * Number of seconds to wait while trying to lock a resource, before timing out and aborting the statement. For more information, check [LOCK_TIMEOUT docs](https://docs.snowflake.com/en/sql-reference/parameters#lock-timeout).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#lock_timeout ServiceUser#lock_timeout}
    */
    readonly lockTimeout?: number;
    /**
    * Specifies the severity level of messages that should be ingested and made available in the active event table. Messages at the specified level (and at more severe levels) are ingested. For more information about log levels, see [Setting log level](https://docs.snowflake.com/en/developer-guide/logging-tracing/logging-log-level). For more information, check [LOG_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#log-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#log_level ServiceUser#log_level}
    */
    readonly logLevel?: string;
    /**
    * The name users use to log in. If not supplied, snowflake will use name instead. Login names are always case-insensitive.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#login_name ServiceUser#login_name}
    */
    readonly loginName?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of minutes until the temporary lock on the user login is cleared. To protect against unauthorized user login, Snowflake places a temporary lock on a user after five consecutive unsuccessful login attempts. When creating a user, this property can be set to prevent them from logging in until the specified amount of time passes. To remove a lock immediately for a user, specify a value of 0 for this parameter. **Note** because this value changes continuously after setting it, the provider is currently NOT handling the external changes to it. External changes for this field won't be detected. In case you want to apply external changes, you can re-create the resource manually using "terraform taint".
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#mins_to_unlock ServiceUser#mins_to_unlock}
    */
    readonly minsToUnlock?: number;
    /**
    * Number of statements to execute when using the multi-statement capability. For more information, check [MULTI_STATEMENT_COUNT docs](https://docs.snowflake.com/en/sql-reference/parameters#multi-statement-count).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#multi_statement_count ServiceUser#multi_statement_count}
    */
    readonly multiStatementCount?: number;
    /**
    * Name of the user. Note that if you do not supply login_name this will be used as login_name. Check the [docs](https://docs.snowflake.net/manuals/sql-reference/sql/create-user.html#required-parameters). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#name ServiceUser#name}
    */
    readonly name: string;
    /**
    * Specifies the network policy to enforce for your account. Network policies enable restricting access to your account based on users’ IP address. For more details, see [Controlling network traffic with network policies](https://docs.snowflake.com/en/user-guide/network-policies). Any existing network policy (created using [CREATE NETWORK POLICY](https://docs.snowflake.com/en/sql-reference/sql/create-network-policy)). For more information, check [NETWORK_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#network-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#network_policy ServiceUser#network_policy}
    */
    readonly networkPolicy?: string;
    /**
    * Specifies whether the ORDER or NOORDER property is set by default when you create a new sequence or add a new table column. The ORDER and NOORDER properties determine whether or not the values are generated for the sequence or auto-incremented column in [increasing or decreasing order](https://docs.snowflake.com/en/user-guide/querying-sequences.html#label-querying-sequences-increasing-values). For more information, check [NOORDER_SEQUENCE_AS_DEFAULT docs](https://docs.snowflake.com/en/sql-reference/parameters#noorder-sequence-as-default).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#noorder_sequence_as_default ServiceUser#noorder_sequence_as_default}
    */
    readonly noorderSequenceAsDefault?: boolean | cdktf.IResolvable;
    /**
    * Specifies how ODBC processes columns that have a scale of zero (0). For more information, check [ODBC_TREAT_DECIMAL_AS_INT docs](https://docs.snowflake.com/en/sql-reference/parameters#odbc-treat-decimal-as-int).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#odbc_treat_decimal_as_int ServiceUser#odbc_treat_decimal_as_int}
    */
    readonly odbcTreatDecimalAsInt?: boolean | cdktf.IResolvable;
    /**
    * Specifies whether to prevent data unload operations to internal (Snowflake) stages using [COPY INTO <location>](https://docs.snowflake.com/en/sql-reference/sql/copy-into-location) statements. For more information, check [PREVENT_UNLOAD_TO_INTERNAL_STAGES docs](https://docs.snowflake.com/en/sql-reference/parameters#prevent-unload-to-internal-stages).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#prevent_unload_to_internal_stages ServiceUser#prevent_unload_to_internal_stages}
    */
    readonly preventUnloadToInternalStages?: boolean | cdktf.IResolvable;
    /**
    * Optional string that can be used to tag queries and other SQL statements executed within a session. The tags are displayed in the output of the [QUERY_HISTORY, QUERY_HISTORY_BY_*](https://docs.snowflake.com/en/sql-reference/functions/query_history) functions. For more information, check [QUERY_TAG docs](https://docs.snowflake.com/en/sql-reference/parameters#query-tag).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#query_tag ServiceUser#query_tag}
    */
    readonly queryTag?: string;
    /**
    * Specifies whether letters in double-quoted object identifiers are stored and resolved as uppercase letters. By default, Snowflake preserves the case of alphabetic characters when storing and resolving double-quoted identifiers (see [Identifier resolution](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing)). You can use this parameter in situations in which [third-party applications always use double quotes around identifiers](https://docs.snowflake.com/en/sql-reference/identifiers-syntax.html#label-identifier-casing-parameter). For more information, check [QUOTED_IDENTIFIERS_IGNORE_CASE docs](https://docs.snowflake.com/en/sql-reference/parameters#quoted-identifiers-ignore-case).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#quoted_identifiers_ignore_case ServiceUser#quoted_identifiers_ignore_case}
    */
    readonly quotedIdentifiersIgnoreCase?: boolean | cdktf.IResolvable;
    /**
    * Specifies the maximum number of rows returned in a result set. A value of 0 specifies no maximum. For more information, check [ROWS_PER_RESULTSET docs](https://docs.snowflake.com/en/sql-reference/parameters#rows-per-resultset).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#rows_per_resultset ServiceUser#rows_per_resultset}
    */
    readonly rowsPerResultset?: number;
    /**
    * Specifies the user’s RSA public key; used for key-pair authentication. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#rsa_public_key ServiceUser#rsa_public_key}
    */
    readonly rsaPublicKey?: string;
    /**
    * Specifies the user’s second RSA public key; used to rotate the public and private keys for key-pair authentication based on an expiration schedule set by your organization. Must be on 1 line without header and trailer.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#rsa_public_key_2 ServiceUser#rsa_public_key_2}
    */
    readonly rsaPublicKey2?: string;
    /**
    * Specifies the DNS name of an Amazon S3 interface endpoint. Requests sent to the internal stage of an account via [AWS PrivateLink for Amazon S3](https://docs.aws.amazon.com/AmazonS3/latest/userguide/privatelink-interface-endpoints.html) use this endpoint to connect. For more information, see [Accessing Internal stages with dedicated interface endpoints](https://docs.snowflake.com/en/user-guide/private-internal-stages-aws.html#label-aws-privatelink-internal-stage-network-isolation). For more information, check [S3_STAGE_VPCE_DNS_NAME docs](https://docs.snowflake.com/en/sql-reference/parameters#s3-stage-vpce-dns-name).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#s3_stage_vpce_dns_name ServiceUser#s3_stage_vpce_dns_name}
    */
    readonly s3StageVpceDnsName?: string;
    /**
    * Specifies the path to search to resolve unqualified object names in queries. For more information, see [Name resolution in queries](https://docs.snowflake.com/en/sql-reference/name-resolution.html#label-object-name-resolution-search-path). Comma-separated list of identifiers. An identifier can be a fully or partially qualified schema name. For more information, check [SEARCH_PATH docs](https://docs.snowflake.com/en/sql-reference/parameters#search-path).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#search_path ServiceUser#search_path}
    */
    readonly searchPath?: string;
    /**
    * Specifies the name of a consumer account to simulate for testing/validating shared data, particularly shared secure views. When this parameter is set in a session, shared views return rows as if executed in the specified consumer account rather than the provider account. For more information, see [Introduction to Secure Data Sharing](https://docs.snowflake.com/en/user-guide/data-sharing-intro) and [Working with shares](https://docs.snowflake.com/en/user-guide/data-sharing-provider). For more information, check [SIMULATED_DATA_SHARING_CONSUMER docs](https://docs.snowflake.com/en/sql-reference/parameters#simulated-data-sharing-consumer).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#simulated_data_sharing_consumer ServiceUser#simulated_data_sharing_consumer}
    */
    readonly simulatedDataSharingConsumer?: string;
    /**
    * Amount of time, in seconds, a SQL statement (query, DDL, DML, etc.) remains queued for a warehouse before it is canceled by the system. This parameter can be used in conjunction with the [MAX_CONCURRENCY_LEVEL](https://docs.snowflake.com/en/sql-reference/parameters#label-max-concurrency-level) parameter to ensure a warehouse is never backlogged. For more information, check [STATEMENT_QUEUED_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-queued-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#statement_queued_timeout_in_seconds ServiceUser#statement_queued_timeout_in_seconds}
    */
    readonly statementQueuedTimeoutInSeconds?: number;
    /**
    * Amount of time, in seconds, after which a running SQL statement (query, DDL, DML, etc.) is canceled by the system. For more information, check [STATEMENT_TIMEOUT_IN_SECONDS docs](https://docs.snowflake.com/en/sql-reference/parameters#statement-timeout-in-seconds).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#statement_timeout_in_seconds ServiceUser#statement_timeout_in_seconds}
    */
    readonly statementTimeoutInSeconds?: number;
    /**
    * This parameter specifies whether JSON output in a session is compatible with the general standard (as described by [http://json.org](http://json.org)). By design, Snowflake allows JSON input that contains non-standard values; however, these non-standard values might result in Snowflake outputting JSON that is incompatible with other platforms and languages. This parameter, when enabled, ensures that Snowflake outputs valid/compatible JSON. For more information, check [STRICT_JSON_OUTPUT docs](https://docs.snowflake.com/en/sql-reference/parameters#strict-json-output).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#strict_json_output ServiceUser#strict_json_output}
    */
    readonly strictJsonOutput?: boolean | cdktf.IResolvable;
    /**
    * Specifies the input format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported time format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of times stored in the system during the session). For more information, check [TIME_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#time_input_format ServiceUser#time_input_format}
    */
    readonly timeInputFormat?: string;
    /**
    * Specifies the display format for the TIME data type. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIME_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#time-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#time_output_format ServiceUser#time_output_format}
    */
    readonly timeOutputFormat?: string;
    /**
    * Specifies whether the [DATEADD](https://docs.snowflake.com/en/sql-reference/functions/dateadd) function (and its aliases) always consider a day to be exactly 24 hours for expressions that span multiple days. For more information, check [TIMESTAMP_DAY_IS_ALWAYS_24H docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-day-is-always-24h).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timestamp_day_is_always_24h ServiceUser#timestamp_day_is_always_24h}
    */
    readonly timestampDayIsAlways24H?: boolean | cdktf.IResolvable;
    /**
    * Specifies the input format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). Any valid, supported timestamp format or AUTO (AUTO specifies that Snowflake attempts to automatically detect the format of timestamps stored in the system during the session). For more information, check [TIMESTAMP_INPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-input-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timestamp_input_format ServiceUser#timestamp_input_format}
    */
    readonly timestampInputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_LTZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_LTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ltz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timestamp_ltz_output_format ServiceUser#timestamp_ltz_output_format}
    */
    readonly timestampLtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP_NTZ data type. For more information, check [TIMESTAMP_NTZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-ntz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timestamp_ntz_output_format ServiceUser#timestamp_ntz_output_format}
    */
    readonly timestampNtzOutputFormat?: string;
    /**
    * Specifies the display format for the TIMESTAMP data type alias. For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timestamp_output_format ServiceUser#timestamp_output_format}
    */
    readonly timestampOutputFormat?: string;
    /**
    * Specifies the TIMESTAMP_* variation that the TIMESTAMP data type alias maps to. For more information, check [TIMESTAMP_TYPE_MAPPING docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-type-mapping).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timestamp_type_mapping ServiceUser#timestamp_type_mapping}
    */
    readonly timestampTypeMapping?: string;
    /**
    * Specifies the display format for the TIMESTAMP_TZ data type. If no format is specified, defaults to [TIMESTAMP_OUTPUT_FORMAT](https://docs.snowflake.com/en/sql-reference/parameters#label-timestamp-output-format). For more information, see [Date and time input and output formats](https://docs.snowflake.com/en/sql-reference/date-time-input-output). For more information, check [TIMESTAMP_TZ_OUTPUT_FORMAT docs](https://docs.snowflake.com/en/sql-reference/parameters#timestamp-tz-output-format).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timestamp_tz_output_format ServiceUser#timestamp_tz_output_format}
    */
    readonly timestampTzOutputFormat?: string;
    /**
    * Specifies the time zone for the session. You can specify a [time zone name](https://data.iana.org/time-zones/tzdb-2021a/zone1970.tab) or a [link name](https://data.iana.org/time-zones/tzdb-2021a/backward) from release 2021a of the [IANA Time Zone Database](https://www.iana.org/time-zones) (e.g. America/Los_Angeles, Europe/London, UTC, Etc/GMT, etc.). For more information, check [TIMEZONE docs](https://docs.snowflake.com/en/sql-reference/parameters#timezone).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#timezone ServiceUser#timezone}
    */
    readonly timezone?: string;
    /**
    * Controls how trace events are ingested into the event table. For more information about trace levels, see [Setting trace level](https://docs.snowflake.com/en/developer-guide/logging-tracing/tracing-trace-level). For more information, check [TRACE_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#trace-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#trace_level ServiceUser#trace_level}
    */
    readonly traceLevel?: string;
    /**
    * Specifies the action to perform when a statement issued within a non-autocommit transaction returns with an error. For more information, check [TRANSACTION_ABORT_ON_ERROR docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-abort-on-error).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#transaction_abort_on_error ServiceUser#transaction_abort_on_error}
    */
    readonly transactionAbortOnError?: boolean | cdktf.IResolvable;
    /**
    * Specifies the isolation level for transactions in the user session. For more information, check [TRANSACTION_DEFAULT_ISOLATION_LEVEL docs](https://docs.snowflake.com/en/sql-reference/parameters#transaction-default-isolation-level).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#transaction_default_isolation_level ServiceUser#transaction_default_isolation_level}
    */
    readonly transactionDefaultIsolationLevel?: string;
    /**
    * Specifies the “century start” year for 2-digit years (i.e. the earliest year such dates can represent). This parameter prevents ambiguous dates when importing or converting data with the `YY` date format component (i.e. years represented as 2 digits). For more information, check [TWO_DIGIT_CENTURY_START docs](https://docs.snowflake.com/en/sql-reference/parameters#two-digit-century-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#two_digit_century_start ServiceUser#two_digit_century_start}
    */
    readonly twoDigitCenturyStart?: number;
    /**
    * Determines if an unsupported (i.e. non-default) value specified for a constraint property returns an error. For more information, check [UNSUPPORTED_DDL_ACTION docs](https://docs.snowflake.com/en/sql-reference/parameters#unsupported-ddl-action).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#unsupported_ddl_action ServiceUser#unsupported_ddl_action}
    */
    readonly unsupportedDdlAction?: string;
    /**
    * Specifies whether to reuse persisted query results, if available, when a matching query is submitted. For more information, check [USE_CACHED_RESULT docs](https://docs.snowflake.com/en/sql-reference/parameters#use-cached-result).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#use_cached_result ServiceUser#use_cached_result}
    */
    readonly useCachedResult?: boolean | cdktf.IResolvable;
    /**
    * Specifies how the weeks in a given year are computed. `0`: The semantics used are equivalent to the ISO semantics, in which a week belongs to a given year if at least 4 days of that week are in that year. `1`: January 1 is included in the first week of the year and December 31 is included in the last week of the year. For more information, check [WEEK_OF_YEAR_POLICY docs](https://docs.snowflake.com/en/sql-reference/parameters#week-of-year-policy).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#week_of_year_policy ServiceUser#week_of_year_policy}
    */
    readonly weekOfYearPolicy?: number;
    /**
    * Specifies the first day of the week (used by week-related date functions). `0`: Legacy Snowflake behavior is used (i.e. ISO-like semantics). `1` (Monday) to `7` (Sunday): All the week-related functions use weeks that start on the specified day of the week. For more information, check [WEEK_START docs](https://docs.snowflake.com/en/sql-reference/parameters#week-start).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#week_start ServiceUser#week_start}
    */
    readonly weekStart?: number;
}
export interface ServiceUserParametersAbortDetachedQuery {
}
export declare function serviceUserParametersAbortDetachedQueryToTerraform(struct?: ServiceUserParametersAbortDetachedQuery): any;
export declare function serviceUserParametersAbortDetachedQueryToHclTerraform(struct?: ServiceUserParametersAbortDetachedQuery): any;
export declare class ServiceUserParametersAbortDetachedQueryOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersAbortDetachedQuery | undefined;
    set internalValue(value: ServiceUserParametersAbortDetachedQuery | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersAbortDetachedQueryList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersAbortDetachedQueryOutputReference;
}
export interface ServiceUserParametersAutocommit {
}
export declare function serviceUserParametersAutocommitToTerraform(struct?: ServiceUserParametersAutocommit): any;
export declare function serviceUserParametersAutocommitToHclTerraform(struct?: ServiceUserParametersAutocommit): any;
export declare class ServiceUserParametersAutocommitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersAutocommit | undefined;
    set internalValue(value: ServiceUserParametersAutocommit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersAutocommitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersAutocommitOutputReference;
}
export interface ServiceUserParametersBinaryInputFormat {
}
export declare function serviceUserParametersBinaryInputFormatToTerraform(struct?: ServiceUserParametersBinaryInputFormat): any;
export declare function serviceUserParametersBinaryInputFormatToHclTerraform(struct?: ServiceUserParametersBinaryInputFormat): any;
export declare class ServiceUserParametersBinaryInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersBinaryInputFormat | undefined;
    set internalValue(value: ServiceUserParametersBinaryInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersBinaryInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersBinaryInputFormatOutputReference;
}
export interface ServiceUserParametersBinaryOutputFormat {
}
export declare function serviceUserParametersBinaryOutputFormatToTerraform(struct?: ServiceUserParametersBinaryOutputFormat): any;
export declare function serviceUserParametersBinaryOutputFormatToHclTerraform(struct?: ServiceUserParametersBinaryOutputFormat): any;
export declare class ServiceUserParametersBinaryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersBinaryOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersBinaryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersBinaryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersBinaryOutputFormatOutputReference;
}
export interface ServiceUserParametersClientMemoryLimit {
}
export declare function serviceUserParametersClientMemoryLimitToTerraform(struct?: ServiceUserParametersClientMemoryLimit): any;
export declare function serviceUserParametersClientMemoryLimitToHclTerraform(struct?: ServiceUserParametersClientMemoryLimit): any;
export declare class ServiceUserParametersClientMemoryLimitOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientMemoryLimit | undefined;
    set internalValue(value: ServiceUserParametersClientMemoryLimit | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientMemoryLimitList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientMemoryLimitOutputReference;
}
export interface ServiceUserParametersClientMetadataRequestUseConnectionCtx {
}
export declare function serviceUserParametersClientMetadataRequestUseConnectionCtxToTerraform(struct?: ServiceUserParametersClientMetadataRequestUseConnectionCtx): any;
export declare function serviceUserParametersClientMetadataRequestUseConnectionCtxToHclTerraform(struct?: ServiceUserParametersClientMetadataRequestUseConnectionCtx): any;
export declare class ServiceUserParametersClientMetadataRequestUseConnectionCtxOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientMetadataRequestUseConnectionCtx | undefined;
    set internalValue(value: ServiceUserParametersClientMetadataRequestUseConnectionCtx | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientMetadataRequestUseConnectionCtxList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientMetadataRequestUseConnectionCtxOutputReference;
}
export interface ServiceUserParametersClientPrefetchThreads {
}
export declare function serviceUserParametersClientPrefetchThreadsToTerraform(struct?: ServiceUserParametersClientPrefetchThreads): any;
export declare function serviceUserParametersClientPrefetchThreadsToHclTerraform(struct?: ServiceUserParametersClientPrefetchThreads): any;
export declare class ServiceUserParametersClientPrefetchThreadsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientPrefetchThreads | undefined;
    set internalValue(value: ServiceUserParametersClientPrefetchThreads | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientPrefetchThreadsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientPrefetchThreadsOutputReference;
}
export interface ServiceUserParametersClientResultChunkSize {
}
export declare function serviceUserParametersClientResultChunkSizeToTerraform(struct?: ServiceUserParametersClientResultChunkSize): any;
export declare function serviceUserParametersClientResultChunkSizeToHclTerraform(struct?: ServiceUserParametersClientResultChunkSize): any;
export declare class ServiceUserParametersClientResultChunkSizeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientResultChunkSize | undefined;
    set internalValue(value: ServiceUserParametersClientResultChunkSize | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientResultChunkSizeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientResultChunkSizeOutputReference;
}
export interface ServiceUserParametersClientResultColumnCaseInsensitive {
}
export declare function serviceUserParametersClientResultColumnCaseInsensitiveToTerraform(struct?: ServiceUserParametersClientResultColumnCaseInsensitive): any;
export declare function serviceUserParametersClientResultColumnCaseInsensitiveToHclTerraform(struct?: ServiceUserParametersClientResultColumnCaseInsensitive): any;
export declare class ServiceUserParametersClientResultColumnCaseInsensitiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientResultColumnCaseInsensitive | undefined;
    set internalValue(value: ServiceUserParametersClientResultColumnCaseInsensitive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientResultColumnCaseInsensitiveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientResultColumnCaseInsensitiveOutputReference;
}
export interface ServiceUserParametersClientSessionKeepAlive {
}
export declare function serviceUserParametersClientSessionKeepAliveToTerraform(struct?: ServiceUserParametersClientSessionKeepAlive): any;
export declare function serviceUserParametersClientSessionKeepAliveToHclTerraform(struct?: ServiceUserParametersClientSessionKeepAlive): any;
export declare class ServiceUserParametersClientSessionKeepAliveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientSessionKeepAlive | undefined;
    set internalValue(value: ServiceUserParametersClientSessionKeepAlive | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientSessionKeepAliveList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientSessionKeepAliveOutputReference;
}
export interface ServiceUserParametersClientSessionKeepAliveHeartbeatFrequency {
}
export declare function serviceUserParametersClientSessionKeepAliveHeartbeatFrequencyToTerraform(struct?: ServiceUserParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare function serviceUserParametersClientSessionKeepAliveHeartbeatFrequencyToHclTerraform(struct?: ServiceUserParametersClientSessionKeepAliveHeartbeatFrequency): any;
export declare class ServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientSessionKeepAliveHeartbeatFrequency | undefined;
    set internalValue(value: ServiceUserParametersClientSessionKeepAliveHeartbeatFrequency | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyOutputReference;
}
export interface ServiceUserParametersClientTimestampTypeMapping {
}
export declare function serviceUserParametersClientTimestampTypeMappingToTerraform(struct?: ServiceUserParametersClientTimestampTypeMapping): any;
export declare function serviceUserParametersClientTimestampTypeMappingToHclTerraform(struct?: ServiceUserParametersClientTimestampTypeMapping): any;
export declare class ServiceUserParametersClientTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersClientTimestampTypeMapping | undefined;
    set internalValue(value: ServiceUserParametersClientTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersClientTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersClientTimestampTypeMappingOutputReference;
}
export interface ServiceUserParametersDateInputFormat {
}
export declare function serviceUserParametersDateInputFormatToTerraform(struct?: ServiceUserParametersDateInputFormat): any;
export declare function serviceUserParametersDateInputFormatToHclTerraform(struct?: ServiceUserParametersDateInputFormat): any;
export declare class ServiceUserParametersDateInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersDateInputFormat | undefined;
    set internalValue(value: ServiceUserParametersDateInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersDateInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersDateInputFormatOutputReference;
}
export interface ServiceUserParametersDateOutputFormat {
}
export declare function serviceUserParametersDateOutputFormatToTerraform(struct?: ServiceUserParametersDateOutputFormat): any;
export declare function serviceUserParametersDateOutputFormatToHclTerraform(struct?: ServiceUserParametersDateOutputFormat): any;
export declare class ServiceUserParametersDateOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersDateOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersDateOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersDateOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersDateOutputFormatOutputReference;
}
export interface ServiceUserParametersEnableUnloadPhysicalTypeOptimization {
}
export declare function serviceUserParametersEnableUnloadPhysicalTypeOptimizationToTerraform(struct?: ServiceUserParametersEnableUnloadPhysicalTypeOptimization): any;
export declare function serviceUserParametersEnableUnloadPhysicalTypeOptimizationToHclTerraform(struct?: ServiceUserParametersEnableUnloadPhysicalTypeOptimization): any;
export declare class ServiceUserParametersEnableUnloadPhysicalTypeOptimizationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersEnableUnloadPhysicalTypeOptimization | undefined;
    set internalValue(value: ServiceUserParametersEnableUnloadPhysicalTypeOptimization | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersEnableUnloadPhysicalTypeOptimizationList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersEnableUnloadPhysicalTypeOptimizationOutputReference;
}
export interface ServiceUserParametersEnableUnredactedQuerySyntaxError {
}
export declare function serviceUserParametersEnableUnredactedQuerySyntaxErrorToTerraform(struct?: ServiceUserParametersEnableUnredactedQuerySyntaxError): any;
export declare function serviceUserParametersEnableUnredactedQuerySyntaxErrorToHclTerraform(struct?: ServiceUserParametersEnableUnredactedQuerySyntaxError): any;
export declare class ServiceUserParametersEnableUnredactedQuerySyntaxErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersEnableUnredactedQuerySyntaxError | undefined;
    set internalValue(value: ServiceUserParametersEnableUnredactedQuerySyntaxError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersEnableUnredactedQuerySyntaxErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersEnableUnredactedQuerySyntaxErrorOutputReference;
}
export interface ServiceUserParametersErrorOnNondeterministicMerge {
}
export declare function serviceUserParametersErrorOnNondeterministicMergeToTerraform(struct?: ServiceUserParametersErrorOnNondeterministicMerge): any;
export declare function serviceUserParametersErrorOnNondeterministicMergeToHclTerraform(struct?: ServiceUserParametersErrorOnNondeterministicMerge): any;
export declare class ServiceUserParametersErrorOnNondeterministicMergeOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersErrorOnNondeterministicMerge | undefined;
    set internalValue(value: ServiceUserParametersErrorOnNondeterministicMerge | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersErrorOnNondeterministicMergeList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersErrorOnNondeterministicMergeOutputReference;
}
export interface ServiceUserParametersErrorOnNondeterministicUpdate {
}
export declare function serviceUserParametersErrorOnNondeterministicUpdateToTerraform(struct?: ServiceUserParametersErrorOnNondeterministicUpdate): any;
export declare function serviceUserParametersErrorOnNondeterministicUpdateToHclTerraform(struct?: ServiceUserParametersErrorOnNondeterministicUpdate): any;
export declare class ServiceUserParametersErrorOnNondeterministicUpdateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersErrorOnNondeterministicUpdate | undefined;
    set internalValue(value: ServiceUserParametersErrorOnNondeterministicUpdate | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersErrorOnNondeterministicUpdateList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersErrorOnNondeterministicUpdateOutputReference;
}
export interface ServiceUserParametersGeographyOutputFormat {
}
export declare function serviceUserParametersGeographyOutputFormatToTerraform(struct?: ServiceUserParametersGeographyOutputFormat): any;
export declare function serviceUserParametersGeographyOutputFormatToHclTerraform(struct?: ServiceUserParametersGeographyOutputFormat): any;
export declare class ServiceUserParametersGeographyOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersGeographyOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersGeographyOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersGeographyOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersGeographyOutputFormatOutputReference;
}
export interface ServiceUserParametersGeometryOutputFormat {
}
export declare function serviceUserParametersGeometryOutputFormatToTerraform(struct?: ServiceUserParametersGeometryOutputFormat): any;
export declare function serviceUserParametersGeometryOutputFormatToHclTerraform(struct?: ServiceUserParametersGeometryOutputFormat): any;
export declare class ServiceUserParametersGeometryOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersGeometryOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersGeometryOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersGeometryOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersGeometryOutputFormatOutputReference;
}
export interface ServiceUserParametersJdbcTreatDecimalAsInt {
}
export declare function serviceUserParametersJdbcTreatDecimalAsIntToTerraform(struct?: ServiceUserParametersJdbcTreatDecimalAsInt): any;
export declare function serviceUserParametersJdbcTreatDecimalAsIntToHclTerraform(struct?: ServiceUserParametersJdbcTreatDecimalAsInt): any;
export declare class ServiceUserParametersJdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersJdbcTreatDecimalAsInt | undefined;
    set internalValue(value: ServiceUserParametersJdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersJdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersJdbcTreatDecimalAsIntOutputReference;
}
export interface ServiceUserParametersJdbcTreatTimestampNtzAsUtc {
}
export declare function serviceUserParametersJdbcTreatTimestampNtzAsUtcToTerraform(struct?: ServiceUserParametersJdbcTreatTimestampNtzAsUtc): any;
export declare function serviceUserParametersJdbcTreatTimestampNtzAsUtcToHclTerraform(struct?: ServiceUserParametersJdbcTreatTimestampNtzAsUtc): any;
export declare class ServiceUserParametersJdbcTreatTimestampNtzAsUtcOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersJdbcTreatTimestampNtzAsUtc | undefined;
    set internalValue(value: ServiceUserParametersJdbcTreatTimestampNtzAsUtc | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersJdbcTreatTimestampNtzAsUtcList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersJdbcTreatTimestampNtzAsUtcOutputReference;
}
export interface ServiceUserParametersJdbcUseSessionTimezone {
}
export declare function serviceUserParametersJdbcUseSessionTimezoneToTerraform(struct?: ServiceUserParametersJdbcUseSessionTimezone): any;
export declare function serviceUserParametersJdbcUseSessionTimezoneToHclTerraform(struct?: ServiceUserParametersJdbcUseSessionTimezone): any;
export declare class ServiceUserParametersJdbcUseSessionTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersJdbcUseSessionTimezone | undefined;
    set internalValue(value: ServiceUserParametersJdbcUseSessionTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersJdbcUseSessionTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersJdbcUseSessionTimezoneOutputReference;
}
export interface ServiceUserParametersJsonIndent {
}
export declare function serviceUserParametersJsonIndentToTerraform(struct?: ServiceUserParametersJsonIndent): any;
export declare function serviceUserParametersJsonIndentToHclTerraform(struct?: ServiceUserParametersJsonIndent): any;
export declare class ServiceUserParametersJsonIndentOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersJsonIndent | undefined;
    set internalValue(value: ServiceUserParametersJsonIndent | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersJsonIndentList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersJsonIndentOutputReference;
}
export interface ServiceUserParametersLockTimeout {
}
export declare function serviceUserParametersLockTimeoutToTerraform(struct?: ServiceUserParametersLockTimeout): any;
export declare function serviceUserParametersLockTimeoutToHclTerraform(struct?: ServiceUserParametersLockTimeout): any;
export declare class ServiceUserParametersLockTimeoutOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersLockTimeout | undefined;
    set internalValue(value: ServiceUserParametersLockTimeout | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersLockTimeoutList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersLockTimeoutOutputReference;
}
export interface ServiceUserParametersLogLevel {
}
export declare function serviceUserParametersLogLevelToTerraform(struct?: ServiceUserParametersLogLevel): any;
export declare function serviceUserParametersLogLevelToHclTerraform(struct?: ServiceUserParametersLogLevel): any;
export declare class ServiceUserParametersLogLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersLogLevel | undefined;
    set internalValue(value: ServiceUserParametersLogLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersLogLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersLogLevelOutputReference;
}
export interface ServiceUserParametersMultiStatementCount {
}
export declare function serviceUserParametersMultiStatementCountToTerraform(struct?: ServiceUserParametersMultiStatementCount): any;
export declare function serviceUserParametersMultiStatementCountToHclTerraform(struct?: ServiceUserParametersMultiStatementCount): any;
export declare class ServiceUserParametersMultiStatementCountOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersMultiStatementCount | undefined;
    set internalValue(value: ServiceUserParametersMultiStatementCount | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersMultiStatementCountList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersMultiStatementCountOutputReference;
}
export interface ServiceUserParametersNetworkPolicy {
}
export declare function serviceUserParametersNetworkPolicyToTerraform(struct?: ServiceUserParametersNetworkPolicy): any;
export declare function serviceUserParametersNetworkPolicyToHclTerraform(struct?: ServiceUserParametersNetworkPolicy): any;
export declare class ServiceUserParametersNetworkPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersNetworkPolicy | undefined;
    set internalValue(value: ServiceUserParametersNetworkPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersNetworkPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersNetworkPolicyOutputReference;
}
export interface ServiceUserParametersNoorderSequenceAsDefault {
}
export declare function serviceUserParametersNoorderSequenceAsDefaultToTerraform(struct?: ServiceUserParametersNoorderSequenceAsDefault): any;
export declare function serviceUserParametersNoorderSequenceAsDefaultToHclTerraform(struct?: ServiceUserParametersNoorderSequenceAsDefault): any;
export declare class ServiceUserParametersNoorderSequenceAsDefaultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersNoorderSequenceAsDefault | undefined;
    set internalValue(value: ServiceUserParametersNoorderSequenceAsDefault | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersNoorderSequenceAsDefaultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersNoorderSequenceAsDefaultOutputReference;
}
export interface ServiceUserParametersOdbcTreatDecimalAsInt {
}
export declare function serviceUserParametersOdbcTreatDecimalAsIntToTerraform(struct?: ServiceUserParametersOdbcTreatDecimalAsInt): any;
export declare function serviceUserParametersOdbcTreatDecimalAsIntToHclTerraform(struct?: ServiceUserParametersOdbcTreatDecimalAsInt): any;
export declare class ServiceUserParametersOdbcTreatDecimalAsIntOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersOdbcTreatDecimalAsInt | undefined;
    set internalValue(value: ServiceUserParametersOdbcTreatDecimalAsInt | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersOdbcTreatDecimalAsIntList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersOdbcTreatDecimalAsIntOutputReference;
}
export interface ServiceUserParametersPreventUnloadToInternalStages {
}
export declare function serviceUserParametersPreventUnloadToInternalStagesToTerraform(struct?: ServiceUserParametersPreventUnloadToInternalStages): any;
export declare function serviceUserParametersPreventUnloadToInternalStagesToHclTerraform(struct?: ServiceUserParametersPreventUnloadToInternalStages): any;
export declare class ServiceUserParametersPreventUnloadToInternalStagesOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersPreventUnloadToInternalStages | undefined;
    set internalValue(value: ServiceUserParametersPreventUnloadToInternalStages | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersPreventUnloadToInternalStagesList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersPreventUnloadToInternalStagesOutputReference;
}
export interface ServiceUserParametersQueryTag {
}
export declare function serviceUserParametersQueryTagToTerraform(struct?: ServiceUserParametersQueryTag): any;
export declare function serviceUserParametersQueryTagToHclTerraform(struct?: ServiceUserParametersQueryTag): any;
export declare class ServiceUserParametersQueryTagOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersQueryTag | undefined;
    set internalValue(value: ServiceUserParametersQueryTag | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersQueryTagList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersQueryTagOutputReference;
}
export interface ServiceUserParametersQuotedIdentifiersIgnoreCase {
}
export declare function serviceUserParametersQuotedIdentifiersIgnoreCaseToTerraform(struct?: ServiceUserParametersQuotedIdentifiersIgnoreCase): any;
export declare function serviceUserParametersQuotedIdentifiersIgnoreCaseToHclTerraform(struct?: ServiceUserParametersQuotedIdentifiersIgnoreCase): any;
export declare class ServiceUserParametersQuotedIdentifiersIgnoreCaseOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersQuotedIdentifiersIgnoreCase | undefined;
    set internalValue(value: ServiceUserParametersQuotedIdentifiersIgnoreCase | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersQuotedIdentifiersIgnoreCaseList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersQuotedIdentifiersIgnoreCaseOutputReference;
}
export interface ServiceUserParametersRowsPerResultset {
}
export declare function serviceUserParametersRowsPerResultsetToTerraform(struct?: ServiceUserParametersRowsPerResultset): any;
export declare function serviceUserParametersRowsPerResultsetToHclTerraform(struct?: ServiceUserParametersRowsPerResultset): any;
export declare class ServiceUserParametersRowsPerResultsetOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersRowsPerResultset | undefined;
    set internalValue(value: ServiceUserParametersRowsPerResultset | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersRowsPerResultsetList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersRowsPerResultsetOutputReference;
}
export interface ServiceUserParametersS3StageVpceDnsName {
}
export declare function serviceUserParametersS3StageVpceDnsNameToTerraform(struct?: ServiceUserParametersS3StageVpceDnsName): any;
export declare function serviceUserParametersS3StageVpceDnsNameToHclTerraform(struct?: ServiceUserParametersS3StageVpceDnsName): any;
export declare class ServiceUserParametersS3StageVpceDnsNameOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersS3StageVpceDnsName | undefined;
    set internalValue(value: ServiceUserParametersS3StageVpceDnsName | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersS3StageVpceDnsNameList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersS3StageVpceDnsNameOutputReference;
}
export interface ServiceUserParametersSearchPath {
}
export declare function serviceUserParametersSearchPathToTerraform(struct?: ServiceUserParametersSearchPath): any;
export declare function serviceUserParametersSearchPathToHclTerraform(struct?: ServiceUserParametersSearchPath): any;
export declare class ServiceUserParametersSearchPathOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersSearchPath | undefined;
    set internalValue(value: ServiceUserParametersSearchPath | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersSearchPathList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersSearchPathOutputReference;
}
export interface ServiceUserParametersSimulatedDataSharingConsumer {
}
export declare function serviceUserParametersSimulatedDataSharingConsumerToTerraform(struct?: ServiceUserParametersSimulatedDataSharingConsumer): any;
export declare function serviceUserParametersSimulatedDataSharingConsumerToHclTerraform(struct?: ServiceUserParametersSimulatedDataSharingConsumer): any;
export declare class ServiceUserParametersSimulatedDataSharingConsumerOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersSimulatedDataSharingConsumer | undefined;
    set internalValue(value: ServiceUserParametersSimulatedDataSharingConsumer | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersSimulatedDataSharingConsumerList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersSimulatedDataSharingConsumerOutputReference;
}
export interface ServiceUserParametersStatementQueuedTimeoutInSeconds {
}
export declare function serviceUserParametersStatementQueuedTimeoutInSecondsToTerraform(struct?: ServiceUserParametersStatementQueuedTimeoutInSeconds): any;
export declare function serviceUserParametersStatementQueuedTimeoutInSecondsToHclTerraform(struct?: ServiceUserParametersStatementQueuedTimeoutInSeconds): any;
export declare class ServiceUserParametersStatementQueuedTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersStatementQueuedTimeoutInSeconds | undefined;
    set internalValue(value: ServiceUserParametersStatementQueuedTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersStatementQueuedTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersStatementQueuedTimeoutInSecondsOutputReference;
}
export interface ServiceUserParametersStatementTimeoutInSeconds {
}
export declare function serviceUserParametersStatementTimeoutInSecondsToTerraform(struct?: ServiceUserParametersStatementTimeoutInSeconds): any;
export declare function serviceUserParametersStatementTimeoutInSecondsToHclTerraform(struct?: ServiceUserParametersStatementTimeoutInSeconds): any;
export declare class ServiceUserParametersStatementTimeoutInSecondsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersStatementTimeoutInSeconds | undefined;
    set internalValue(value: ServiceUserParametersStatementTimeoutInSeconds | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersStatementTimeoutInSecondsList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersStatementTimeoutInSecondsOutputReference;
}
export interface ServiceUserParametersStrictJsonOutput {
}
export declare function serviceUserParametersStrictJsonOutputToTerraform(struct?: ServiceUserParametersStrictJsonOutput): any;
export declare function serviceUserParametersStrictJsonOutputToHclTerraform(struct?: ServiceUserParametersStrictJsonOutput): any;
export declare class ServiceUserParametersStrictJsonOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersStrictJsonOutput | undefined;
    set internalValue(value: ServiceUserParametersStrictJsonOutput | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersStrictJsonOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersStrictJsonOutputOutputReference;
}
export interface ServiceUserParametersTimeInputFormat {
}
export declare function serviceUserParametersTimeInputFormatToTerraform(struct?: ServiceUserParametersTimeInputFormat): any;
export declare function serviceUserParametersTimeInputFormatToHclTerraform(struct?: ServiceUserParametersTimeInputFormat): any;
export declare class ServiceUserParametersTimeInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimeInputFormat | undefined;
    set internalValue(value: ServiceUserParametersTimeInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimeInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimeInputFormatOutputReference;
}
export interface ServiceUserParametersTimeOutputFormat {
}
export declare function serviceUserParametersTimeOutputFormatToTerraform(struct?: ServiceUserParametersTimeOutputFormat): any;
export declare function serviceUserParametersTimeOutputFormatToHclTerraform(struct?: ServiceUserParametersTimeOutputFormat): any;
export declare class ServiceUserParametersTimeOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimeOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersTimeOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimeOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimeOutputFormatOutputReference;
}
export interface ServiceUserParametersTimestampDayIsAlways24H {
}
export declare function serviceUserParametersTimestampDayIsAlways24HToTerraform(struct?: ServiceUserParametersTimestampDayIsAlways24H): any;
export declare function serviceUserParametersTimestampDayIsAlways24HToHclTerraform(struct?: ServiceUserParametersTimestampDayIsAlways24H): any;
export declare class ServiceUserParametersTimestampDayIsAlways24HOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimestampDayIsAlways24H | undefined;
    set internalValue(value: ServiceUserParametersTimestampDayIsAlways24H | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimestampDayIsAlways24HList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimestampDayIsAlways24HOutputReference;
}
export interface ServiceUserParametersTimestampInputFormat {
}
export declare function serviceUserParametersTimestampInputFormatToTerraform(struct?: ServiceUserParametersTimestampInputFormat): any;
export declare function serviceUserParametersTimestampInputFormatToHclTerraform(struct?: ServiceUserParametersTimestampInputFormat): any;
export declare class ServiceUserParametersTimestampInputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimestampInputFormat | undefined;
    set internalValue(value: ServiceUserParametersTimestampInputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimestampInputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimestampInputFormatOutputReference;
}
export interface ServiceUserParametersTimestampLtzOutputFormat {
}
export declare function serviceUserParametersTimestampLtzOutputFormatToTerraform(struct?: ServiceUserParametersTimestampLtzOutputFormat): any;
export declare function serviceUserParametersTimestampLtzOutputFormatToHclTerraform(struct?: ServiceUserParametersTimestampLtzOutputFormat): any;
export declare class ServiceUserParametersTimestampLtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimestampLtzOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersTimestampLtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimestampLtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimestampLtzOutputFormatOutputReference;
}
export interface ServiceUserParametersTimestampNtzOutputFormat {
}
export declare function serviceUserParametersTimestampNtzOutputFormatToTerraform(struct?: ServiceUserParametersTimestampNtzOutputFormat): any;
export declare function serviceUserParametersTimestampNtzOutputFormatToHclTerraform(struct?: ServiceUserParametersTimestampNtzOutputFormat): any;
export declare class ServiceUserParametersTimestampNtzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimestampNtzOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersTimestampNtzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimestampNtzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimestampNtzOutputFormatOutputReference;
}
export interface ServiceUserParametersTimestampOutputFormat {
}
export declare function serviceUserParametersTimestampOutputFormatToTerraform(struct?: ServiceUserParametersTimestampOutputFormat): any;
export declare function serviceUserParametersTimestampOutputFormatToHclTerraform(struct?: ServiceUserParametersTimestampOutputFormat): any;
export declare class ServiceUserParametersTimestampOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimestampOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersTimestampOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimestampOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimestampOutputFormatOutputReference;
}
export interface ServiceUserParametersTimestampTypeMapping {
}
export declare function serviceUserParametersTimestampTypeMappingToTerraform(struct?: ServiceUserParametersTimestampTypeMapping): any;
export declare function serviceUserParametersTimestampTypeMappingToHclTerraform(struct?: ServiceUserParametersTimestampTypeMapping): any;
export declare class ServiceUserParametersTimestampTypeMappingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimestampTypeMapping | undefined;
    set internalValue(value: ServiceUserParametersTimestampTypeMapping | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimestampTypeMappingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimestampTypeMappingOutputReference;
}
export interface ServiceUserParametersTimestampTzOutputFormat {
}
export declare function serviceUserParametersTimestampTzOutputFormatToTerraform(struct?: ServiceUserParametersTimestampTzOutputFormat): any;
export declare function serviceUserParametersTimestampTzOutputFormatToHclTerraform(struct?: ServiceUserParametersTimestampTzOutputFormat): any;
export declare class ServiceUserParametersTimestampTzOutputFormatOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimestampTzOutputFormat | undefined;
    set internalValue(value: ServiceUserParametersTimestampTzOutputFormat | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimestampTzOutputFormatList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimestampTzOutputFormatOutputReference;
}
export interface ServiceUserParametersTimezone {
}
export declare function serviceUserParametersTimezoneToTerraform(struct?: ServiceUserParametersTimezone): any;
export declare function serviceUserParametersTimezoneToHclTerraform(struct?: ServiceUserParametersTimezone): any;
export declare class ServiceUserParametersTimezoneOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTimezone | undefined;
    set internalValue(value: ServiceUserParametersTimezone | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTimezoneList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTimezoneOutputReference;
}
export interface ServiceUserParametersTraceLevel {
}
export declare function serviceUserParametersTraceLevelToTerraform(struct?: ServiceUserParametersTraceLevel): any;
export declare function serviceUserParametersTraceLevelToHclTerraform(struct?: ServiceUserParametersTraceLevel): any;
export declare class ServiceUserParametersTraceLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTraceLevel | undefined;
    set internalValue(value: ServiceUserParametersTraceLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTraceLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTraceLevelOutputReference;
}
export interface ServiceUserParametersTransactionAbortOnError {
}
export declare function serviceUserParametersTransactionAbortOnErrorToTerraform(struct?: ServiceUserParametersTransactionAbortOnError): any;
export declare function serviceUserParametersTransactionAbortOnErrorToHclTerraform(struct?: ServiceUserParametersTransactionAbortOnError): any;
export declare class ServiceUserParametersTransactionAbortOnErrorOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTransactionAbortOnError | undefined;
    set internalValue(value: ServiceUserParametersTransactionAbortOnError | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTransactionAbortOnErrorList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTransactionAbortOnErrorOutputReference;
}
export interface ServiceUserParametersTransactionDefaultIsolationLevel {
}
export declare function serviceUserParametersTransactionDefaultIsolationLevelToTerraform(struct?: ServiceUserParametersTransactionDefaultIsolationLevel): any;
export declare function serviceUserParametersTransactionDefaultIsolationLevelToHclTerraform(struct?: ServiceUserParametersTransactionDefaultIsolationLevel): any;
export declare class ServiceUserParametersTransactionDefaultIsolationLevelOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTransactionDefaultIsolationLevel | undefined;
    set internalValue(value: ServiceUserParametersTransactionDefaultIsolationLevel | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTransactionDefaultIsolationLevelList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTransactionDefaultIsolationLevelOutputReference;
}
export interface ServiceUserParametersTwoDigitCenturyStart {
}
export declare function serviceUserParametersTwoDigitCenturyStartToTerraform(struct?: ServiceUserParametersTwoDigitCenturyStart): any;
export declare function serviceUserParametersTwoDigitCenturyStartToHclTerraform(struct?: ServiceUserParametersTwoDigitCenturyStart): any;
export declare class ServiceUserParametersTwoDigitCenturyStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersTwoDigitCenturyStart | undefined;
    set internalValue(value: ServiceUserParametersTwoDigitCenturyStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersTwoDigitCenturyStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersTwoDigitCenturyStartOutputReference;
}
export interface ServiceUserParametersUnsupportedDdlAction {
}
export declare function serviceUserParametersUnsupportedDdlActionToTerraform(struct?: ServiceUserParametersUnsupportedDdlAction): any;
export declare function serviceUserParametersUnsupportedDdlActionToHclTerraform(struct?: ServiceUserParametersUnsupportedDdlAction): any;
export declare class ServiceUserParametersUnsupportedDdlActionOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersUnsupportedDdlAction | undefined;
    set internalValue(value: ServiceUserParametersUnsupportedDdlAction | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersUnsupportedDdlActionList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersUnsupportedDdlActionOutputReference;
}
export interface ServiceUserParametersUseCachedResult {
}
export declare function serviceUserParametersUseCachedResultToTerraform(struct?: ServiceUserParametersUseCachedResult): any;
export declare function serviceUserParametersUseCachedResultToHclTerraform(struct?: ServiceUserParametersUseCachedResult): any;
export declare class ServiceUserParametersUseCachedResultOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersUseCachedResult | undefined;
    set internalValue(value: ServiceUserParametersUseCachedResult | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersUseCachedResultList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersUseCachedResultOutputReference;
}
export interface ServiceUserParametersWeekOfYearPolicy {
}
export declare function serviceUserParametersWeekOfYearPolicyToTerraform(struct?: ServiceUserParametersWeekOfYearPolicy): any;
export declare function serviceUserParametersWeekOfYearPolicyToHclTerraform(struct?: ServiceUserParametersWeekOfYearPolicy): any;
export declare class ServiceUserParametersWeekOfYearPolicyOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersWeekOfYearPolicy | undefined;
    set internalValue(value: ServiceUserParametersWeekOfYearPolicy | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersWeekOfYearPolicyList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersWeekOfYearPolicyOutputReference;
}
export interface ServiceUserParametersWeekStart {
}
export declare function serviceUserParametersWeekStartToTerraform(struct?: ServiceUserParametersWeekStart): any;
export declare function serviceUserParametersWeekStartToHclTerraform(struct?: ServiceUserParametersWeekStart): any;
export declare class ServiceUserParametersWeekStartOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParametersWeekStart | undefined;
    set internalValue(value: ServiceUserParametersWeekStart | undefined);
    get default(): string;
    get description(): string;
    get key(): string;
    get level(): string;
    get value(): string;
}
export declare class ServiceUserParametersWeekStartList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersWeekStartOutputReference;
}
export interface ServiceUserParameters {
}
export declare function serviceUserParametersToTerraform(struct?: ServiceUserParameters): any;
export declare function serviceUserParametersToHclTerraform(struct?: ServiceUserParameters): any;
export declare class ServiceUserParametersOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserParameters | undefined;
    set internalValue(value: ServiceUserParameters | undefined);
    private _abortDetachedQuery;
    get abortDetachedQuery(): ServiceUserParametersAbortDetachedQueryList;
    private _autocommit;
    get autocommit(): ServiceUserParametersAutocommitList;
    private _binaryInputFormat;
    get binaryInputFormat(): ServiceUserParametersBinaryInputFormatList;
    private _binaryOutputFormat;
    get binaryOutputFormat(): ServiceUserParametersBinaryOutputFormatList;
    private _clientMemoryLimit;
    get clientMemoryLimit(): ServiceUserParametersClientMemoryLimitList;
    private _clientMetadataRequestUseConnectionCtx;
    get clientMetadataRequestUseConnectionCtx(): ServiceUserParametersClientMetadataRequestUseConnectionCtxList;
    private _clientPrefetchThreads;
    get clientPrefetchThreads(): ServiceUserParametersClientPrefetchThreadsList;
    private _clientResultChunkSize;
    get clientResultChunkSize(): ServiceUserParametersClientResultChunkSizeList;
    private _clientResultColumnCaseInsensitive;
    get clientResultColumnCaseInsensitive(): ServiceUserParametersClientResultColumnCaseInsensitiveList;
    private _clientSessionKeepAlive;
    get clientSessionKeepAlive(): ServiceUserParametersClientSessionKeepAliveList;
    private _clientSessionKeepAliveHeartbeatFrequency;
    get clientSessionKeepAliveHeartbeatFrequency(): ServiceUserParametersClientSessionKeepAliveHeartbeatFrequencyList;
    private _clientTimestampTypeMapping;
    get clientTimestampTypeMapping(): ServiceUserParametersClientTimestampTypeMappingList;
    private _dateInputFormat;
    get dateInputFormat(): ServiceUserParametersDateInputFormatList;
    private _dateOutputFormat;
    get dateOutputFormat(): ServiceUserParametersDateOutputFormatList;
    private _enableUnloadPhysicalTypeOptimization;
    get enableUnloadPhysicalTypeOptimization(): ServiceUserParametersEnableUnloadPhysicalTypeOptimizationList;
    private _enableUnredactedQuerySyntaxError;
    get enableUnredactedQuerySyntaxError(): ServiceUserParametersEnableUnredactedQuerySyntaxErrorList;
    private _errorOnNondeterministicMerge;
    get errorOnNondeterministicMerge(): ServiceUserParametersErrorOnNondeterministicMergeList;
    private _errorOnNondeterministicUpdate;
    get errorOnNondeterministicUpdate(): ServiceUserParametersErrorOnNondeterministicUpdateList;
    private _geographyOutputFormat;
    get geographyOutputFormat(): ServiceUserParametersGeographyOutputFormatList;
    private _geometryOutputFormat;
    get geometryOutputFormat(): ServiceUserParametersGeometryOutputFormatList;
    private _jdbcTreatDecimalAsInt;
    get jdbcTreatDecimalAsInt(): ServiceUserParametersJdbcTreatDecimalAsIntList;
    private _jdbcTreatTimestampNtzAsUtc;
    get jdbcTreatTimestampNtzAsUtc(): ServiceUserParametersJdbcTreatTimestampNtzAsUtcList;
    private _jdbcUseSessionTimezone;
    get jdbcUseSessionTimezone(): ServiceUserParametersJdbcUseSessionTimezoneList;
    private _jsonIndent;
    get jsonIndent(): ServiceUserParametersJsonIndentList;
    private _lockTimeout;
    get lockTimeout(): ServiceUserParametersLockTimeoutList;
    private _logLevel;
    get logLevel(): ServiceUserParametersLogLevelList;
    private _multiStatementCount;
    get multiStatementCount(): ServiceUserParametersMultiStatementCountList;
    private _networkPolicy;
    get networkPolicy(): ServiceUserParametersNetworkPolicyList;
    private _noorderSequenceAsDefault;
    get noorderSequenceAsDefault(): ServiceUserParametersNoorderSequenceAsDefaultList;
    private _odbcTreatDecimalAsInt;
    get odbcTreatDecimalAsInt(): ServiceUserParametersOdbcTreatDecimalAsIntList;
    private _preventUnloadToInternalStages;
    get preventUnloadToInternalStages(): ServiceUserParametersPreventUnloadToInternalStagesList;
    private _queryTag;
    get queryTag(): ServiceUserParametersQueryTagList;
    private _quotedIdentifiersIgnoreCase;
    get quotedIdentifiersIgnoreCase(): ServiceUserParametersQuotedIdentifiersIgnoreCaseList;
    private _rowsPerResultset;
    get rowsPerResultset(): ServiceUserParametersRowsPerResultsetList;
    private _s3StageVpceDnsName;
    get s3StageVpceDnsName(): ServiceUserParametersS3StageVpceDnsNameList;
    private _searchPath;
    get searchPath(): ServiceUserParametersSearchPathList;
    private _simulatedDataSharingConsumer;
    get simulatedDataSharingConsumer(): ServiceUserParametersSimulatedDataSharingConsumerList;
    private _statementQueuedTimeoutInSeconds;
    get statementQueuedTimeoutInSeconds(): ServiceUserParametersStatementQueuedTimeoutInSecondsList;
    private _statementTimeoutInSeconds;
    get statementTimeoutInSeconds(): ServiceUserParametersStatementTimeoutInSecondsList;
    private _strictJsonOutput;
    get strictJsonOutput(): ServiceUserParametersStrictJsonOutputList;
    private _timeInputFormat;
    get timeInputFormat(): ServiceUserParametersTimeInputFormatList;
    private _timeOutputFormat;
    get timeOutputFormat(): ServiceUserParametersTimeOutputFormatList;
    private _timestampDayIsAlways24H;
    get timestampDayIsAlways24H(): ServiceUserParametersTimestampDayIsAlways24HList;
    private _timestampInputFormat;
    get timestampInputFormat(): ServiceUserParametersTimestampInputFormatList;
    private _timestampLtzOutputFormat;
    get timestampLtzOutputFormat(): ServiceUserParametersTimestampLtzOutputFormatList;
    private _timestampNtzOutputFormat;
    get timestampNtzOutputFormat(): ServiceUserParametersTimestampNtzOutputFormatList;
    private _timestampOutputFormat;
    get timestampOutputFormat(): ServiceUserParametersTimestampOutputFormatList;
    private _timestampTypeMapping;
    get timestampTypeMapping(): ServiceUserParametersTimestampTypeMappingList;
    private _timestampTzOutputFormat;
    get timestampTzOutputFormat(): ServiceUserParametersTimestampTzOutputFormatList;
    private _timezone;
    get timezone(): ServiceUserParametersTimezoneList;
    private _traceLevel;
    get traceLevel(): ServiceUserParametersTraceLevelList;
    private _transactionAbortOnError;
    get transactionAbortOnError(): ServiceUserParametersTransactionAbortOnErrorList;
    private _transactionDefaultIsolationLevel;
    get transactionDefaultIsolationLevel(): ServiceUserParametersTransactionDefaultIsolationLevelList;
    private _twoDigitCenturyStart;
    get twoDigitCenturyStart(): ServiceUserParametersTwoDigitCenturyStartList;
    private _unsupportedDdlAction;
    get unsupportedDdlAction(): ServiceUserParametersUnsupportedDdlActionList;
    private _useCachedResult;
    get useCachedResult(): ServiceUserParametersUseCachedResultList;
    private _weekOfYearPolicy;
    get weekOfYearPolicy(): ServiceUserParametersWeekOfYearPolicyList;
    private _weekStart;
    get weekStart(): ServiceUserParametersWeekStartList;
}
export declare class ServiceUserParametersList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserParametersOutputReference;
}
export interface ServiceUserShowOutput {
}
export declare function serviceUserShowOutputToTerraform(struct?: ServiceUserShowOutput): any;
export declare function serviceUserShowOutputToHclTerraform(struct?: ServiceUserShowOutput): any;
export declare class ServiceUserShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceUserShowOutput | undefined;
    set internalValue(value: ServiceUserShowOutput | undefined);
    get comment(): string;
    get createdOn(): string;
    get daysToExpiry(): string;
    get defaultNamespace(): string;
    get defaultRole(): string;
    get defaultSecondaryRoles(): string;
    get defaultWarehouse(): string;
    get disabled(): cdktf.IResolvable;
    get displayName(): string;
    get email(): string;
    get expiresAtTime(): string;
    get extAuthnDuo(): cdktf.IResolvable;
    get extAuthnUid(): string;
    get firstName(): string;
    get hasMfa(): cdktf.IResolvable;
    get hasPassword(): cdktf.IResolvable;
    get hasRsaPublicKey(): cdktf.IResolvable;
    get lastName(): string;
    get lastSuccessLogin(): string;
    get lockedUntilTime(): string;
    get loginName(): string;
    get minsToBypassMfa(): string;
    get minsToUnlock(): string;
    get mustChangePassword(): cdktf.IResolvable;
    get name(): string;
    get owner(): string;
    get snowflakeLock(): cdktf.IResolvable;
    get type(): string;
}
export declare class ServiceUserShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceUserShowOutputOutputReference;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user snowflake_service_user}
*/
export declare class ServiceUser extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_service_user";
    /**
    * Generates CDKTF code for importing a ServiceUser resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the ServiceUser to import
    * @param importFromId The id of the existing ServiceUser that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the ServiceUser to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service_user snowflake_service_user} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceUserConfig
    */
    constructor(scope: Construct, id: string, config: ServiceUserConfig);
    private _abortDetachedQuery?;
    get abortDetachedQuery(): boolean | cdktf.IResolvable;
    set abortDetachedQuery(value: boolean | cdktf.IResolvable);
    resetAbortDetachedQuery(): void;
    get abortDetachedQueryInput(): boolean | cdktf.IResolvable | undefined;
    private _autocommit?;
    get autocommit(): boolean | cdktf.IResolvable;
    set autocommit(value: boolean | cdktf.IResolvable);
    resetAutocommit(): void;
    get autocommitInput(): boolean | cdktf.IResolvable | undefined;
    private _binaryInputFormat?;
    get binaryInputFormat(): string;
    set binaryInputFormat(value: string);
    resetBinaryInputFormat(): void;
    get binaryInputFormatInput(): string | undefined;
    private _binaryOutputFormat?;
    get binaryOutputFormat(): string;
    set binaryOutputFormat(value: string);
    resetBinaryOutputFormat(): void;
    get binaryOutputFormatInput(): string | undefined;
    private _clientMemoryLimit?;
    get clientMemoryLimit(): number;
    set clientMemoryLimit(value: number);
    resetClientMemoryLimit(): void;
    get clientMemoryLimitInput(): number | undefined;
    private _clientMetadataRequestUseConnectionCtx?;
    get clientMetadataRequestUseConnectionCtx(): boolean | cdktf.IResolvable;
    set clientMetadataRequestUseConnectionCtx(value: boolean | cdktf.IResolvable);
    resetClientMetadataRequestUseConnectionCtx(): void;
    get clientMetadataRequestUseConnectionCtxInput(): boolean | cdktf.IResolvable | undefined;
    private _clientPrefetchThreads?;
    get clientPrefetchThreads(): number;
    set clientPrefetchThreads(value: number);
    resetClientPrefetchThreads(): void;
    get clientPrefetchThreadsInput(): number | undefined;
    private _clientResultChunkSize?;
    get clientResultChunkSize(): number;
    set clientResultChunkSize(value: number);
    resetClientResultChunkSize(): void;
    get clientResultChunkSizeInput(): number | undefined;
    private _clientResultColumnCaseInsensitive?;
    get clientResultColumnCaseInsensitive(): boolean | cdktf.IResolvable;
    set clientResultColumnCaseInsensitive(value: boolean | cdktf.IResolvable);
    resetClientResultColumnCaseInsensitive(): void;
    get clientResultColumnCaseInsensitiveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAlive?;
    get clientSessionKeepAlive(): boolean | cdktf.IResolvable;
    set clientSessionKeepAlive(value: boolean | cdktf.IResolvable);
    resetClientSessionKeepAlive(): void;
    get clientSessionKeepAliveInput(): boolean | cdktf.IResolvable | undefined;
    private _clientSessionKeepAliveHeartbeatFrequency?;
    get clientSessionKeepAliveHeartbeatFrequency(): number;
    set clientSessionKeepAliveHeartbeatFrequency(value: number);
    resetClientSessionKeepAliveHeartbeatFrequency(): void;
    get clientSessionKeepAliveHeartbeatFrequencyInput(): number | undefined;
    private _clientTimestampTypeMapping?;
    get clientTimestampTypeMapping(): string;
    set clientTimestampTypeMapping(value: string);
    resetClientTimestampTypeMapping(): void;
    get clientTimestampTypeMappingInput(): string | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _dateInputFormat?;
    get dateInputFormat(): string;
    set dateInputFormat(value: string);
    resetDateInputFormat(): void;
    get dateInputFormatInput(): string | undefined;
    private _dateOutputFormat?;
    get dateOutputFormat(): string;
    set dateOutputFormat(value: string);
    resetDateOutputFormat(): void;
    get dateOutputFormatInput(): string | undefined;
    private _daysToExpiry?;
    get daysToExpiry(): number;
    set daysToExpiry(value: number);
    resetDaysToExpiry(): void;
    get daysToExpiryInput(): number | undefined;
    private _defaultNamespace?;
    get defaultNamespace(): string;
    set defaultNamespace(value: string);
    resetDefaultNamespace(): void;
    get defaultNamespaceInput(): string | undefined;
    private _defaultRole?;
    get defaultRole(): string;
    set defaultRole(value: string);
    resetDefaultRole(): void;
    get defaultRoleInput(): string | undefined;
    private _defaultSecondaryRolesOption?;
    get defaultSecondaryRolesOption(): string;
    set defaultSecondaryRolesOption(value: string);
    resetDefaultSecondaryRolesOption(): void;
    get defaultSecondaryRolesOptionInput(): string | undefined;
    private _defaultWarehouse?;
    get defaultWarehouse(): string;
    set defaultWarehouse(value: string);
    resetDefaultWarehouse(): void;
    get defaultWarehouseInput(): string | undefined;
    private _disabled?;
    get disabled(): string;
    set disabled(value: string);
    resetDisabled(): void;
    get disabledInput(): string | undefined;
    private _displayName?;
    get displayName(): string;
    set displayName(value: string);
    resetDisplayName(): void;
    get displayNameInput(): string | undefined;
    private _email?;
    get email(): string;
    set email(value: string);
    resetEmail(): void;
    get emailInput(): string | undefined;
    private _enableUnloadPhysicalTypeOptimization?;
    get enableUnloadPhysicalTypeOptimization(): boolean | cdktf.IResolvable;
    set enableUnloadPhysicalTypeOptimization(value: boolean | cdktf.IResolvable);
    resetEnableUnloadPhysicalTypeOptimization(): void;
    get enableUnloadPhysicalTypeOptimizationInput(): boolean | cdktf.IResolvable | undefined;
    private _enableUnredactedQuerySyntaxError?;
    get enableUnredactedQuerySyntaxError(): boolean | cdktf.IResolvable;
    set enableUnredactedQuerySyntaxError(value: boolean | cdktf.IResolvable);
    resetEnableUnredactedQuerySyntaxError(): void;
    get enableUnredactedQuerySyntaxErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _errorOnNondeterministicMerge?;
    get errorOnNondeterministicMerge(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicMerge(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicMerge(): void;
    get errorOnNondeterministicMergeInput(): boolean | cdktf.IResolvable | undefined;
    private _errorOnNondeterministicUpdate?;
    get errorOnNondeterministicUpdate(): boolean | cdktf.IResolvable;
    set errorOnNondeterministicUpdate(value: boolean | cdktf.IResolvable);
    resetErrorOnNondeterministicUpdate(): void;
    get errorOnNondeterministicUpdateInput(): boolean | cdktf.IResolvable | undefined;
    get fullyQualifiedName(): string;
    private _geographyOutputFormat?;
    get geographyOutputFormat(): string;
    set geographyOutputFormat(value: string);
    resetGeographyOutputFormat(): void;
    get geographyOutputFormatInput(): string | undefined;
    private _geometryOutputFormat?;
    get geometryOutputFormat(): string;
    set geometryOutputFormat(value: string);
    resetGeometryOutputFormat(): void;
    get geometryOutputFormatInput(): string | undefined;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _jdbcTreatDecimalAsInt?;
    get jdbcTreatDecimalAsInt(): boolean | cdktf.IResolvable;
    set jdbcTreatDecimalAsInt(value: boolean | cdktf.IResolvable);
    resetJdbcTreatDecimalAsInt(): void;
    get jdbcTreatDecimalAsIntInput(): boolean | cdktf.IResolvable | undefined;
    private _jdbcTreatTimestampNtzAsUtc?;
    get jdbcTreatTimestampNtzAsUtc(): boolean | cdktf.IResolvable;
    set jdbcTreatTimestampNtzAsUtc(value: boolean | cdktf.IResolvable);
    resetJdbcTreatTimestampNtzAsUtc(): void;
    get jdbcTreatTimestampNtzAsUtcInput(): boolean | cdktf.IResolvable | undefined;
    private _jdbcUseSessionTimezone?;
    get jdbcUseSessionTimezone(): boolean | cdktf.IResolvable;
    set jdbcUseSessionTimezone(value: boolean | cdktf.IResolvable);
    resetJdbcUseSessionTimezone(): void;
    get jdbcUseSessionTimezoneInput(): boolean | cdktf.IResolvable | undefined;
    private _jsonIndent?;
    get jsonIndent(): number;
    set jsonIndent(value: number);
    resetJsonIndent(): void;
    get jsonIndentInput(): number | undefined;
    private _lockTimeout?;
    get lockTimeout(): number;
    set lockTimeout(value: number);
    resetLockTimeout(): void;
    get lockTimeoutInput(): number | undefined;
    private _logLevel?;
    get logLevel(): string;
    set logLevel(value: string);
    resetLogLevel(): void;
    get logLevelInput(): string | undefined;
    private _loginName?;
    get loginName(): string;
    set loginName(value: string);
    resetLoginName(): void;
    get loginNameInput(): string | undefined;
    private _minsToUnlock?;
    get minsToUnlock(): number;
    set minsToUnlock(value: number);
    resetMinsToUnlock(): void;
    get minsToUnlockInput(): number | undefined;
    private _multiStatementCount?;
    get multiStatementCount(): number;
    set multiStatementCount(value: number);
    resetMultiStatementCount(): void;
    get multiStatementCountInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _networkPolicy?;
    get networkPolicy(): string;
    set networkPolicy(value: string);
    resetNetworkPolicy(): void;
    get networkPolicyInput(): string | undefined;
    private _noorderSequenceAsDefault?;
    get noorderSequenceAsDefault(): boolean | cdktf.IResolvable;
    set noorderSequenceAsDefault(value: boolean | cdktf.IResolvable);
    resetNoorderSequenceAsDefault(): void;
    get noorderSequenceAsDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _odbcTreatDecimalAsInt?;
    get odbcTreatDecimalAsInt(): boolean | cdktf.IResolvable;
    set odbcTreatDecimalAsInt(value: boolean | cdktf.IResolvable);
    resetOdbcTreatDecimalAsInt(): void;
    get odbcTreatDecimalAsIntInput(): boolean | cdktf.IResolvable | undefined;
    private _parameters;
    get parameters(): ServiceUserParametersList;
    private _preventUnloadToInternalStages?;
    get preventUnloadToInternalStages(): boolean | cdktf.IResolvable;
    set preventUnloadToInternalStages(value: boolean | cdktf.IResolvable);
    resetPreventUnloadToInternalStages(): void;
    get preventUnloadToInternalStagesInput(): boolean | cdktf.IResolvable | undefined;
    private _queryTag?;
    get queryTag(): string;
    set queryTag(value: string);
    resetQueryTag(): void;
    get queryTagInput(): string | undefined;
    private _quotedIdentifiersIgnoreCase?;
    get quotedIdentifiersIgnoreCase(): boolean | cdktf.IResolvable;
    set quotedIdentifiersIgnoreCase(value: boolean | cdktf.IResolvable);
    resetQuotedIdentifiersIgnoreCase(): void;
    get quotedIdentifiersIgnoreCaseInput(): boolean | cdktf.IResolvable | undefined;
    private _rowsPerResultset?;
    get rowsPerResultset(): number;
    set rowsPerResultset(value: number);
    resetRowsPerResultset(): void;
    get rowsPerResultsetInput(): number | undefined;
    private _rsaPublicKey?;
    get rsaPublicKey(): string;
    set rsaPublicKey(value: string);
    resetRsaPublicKey(): void;
    get rsaPublicKeyInput(): string | undefined;
    private _rsaPublicKey2?;
    get rsaPublicKey2(): string;
    set rsaPublicKey2(value: string);
    resetRsaPublicKey2(): void;
    get rsaPublicKey2Input(): string | undefined;
    private _s3StageVpceDnsName?;
    get s3StageVpceDnsName(): string;
    set s3StageVpceDnsName(value: string);
    resetS3StageVpceDnsName(): void;
    get s3StageVpceDnsNameInput(): string | undefined;
    private _searchPath?;
    get searchPath(): string;
    set searchPath(value: string);
    resetSearchPath(): void;
    get searchPathInput(): string | undefined;
    private _showOutput;
    get showOutput(): ServiceUserShowOutputList;
    private _simulatedDataSharingConsumer?;
    get simulatedDataSharingConsumer(): string;
    set simulatedDataSharingConsumer(value: string);
    resetSimulatedDataSharingConsumer(): void;
    get simulatedDataSharingConsumerInput(): string | undefined;
    private _statementQueuedTimeoutInSeconds?;
    get statementQueuedTimeoutInSeconds(): number;
    set statementQueuedTimeoutInSeconds(value: number);
    resetStatementQueuedTimeoutInSeconds(): void;
    get statementQueuedTimeoutInSecondsInput(): number | undefined;
    private _statementTimeoutInSeconds?;
    get statementTimeoutInSeconds(): number;
    set statementTimeoutInSeconds(value: number);
    resetStatementTimeoutInSeconds(): void;
    get statementTimeoutInSecondsInput(): number | undefined;
    private _strictJsonOutput?;
    get strictJsonOutput(): boolean | cdktf.IResolvable;
    set strictJsonOutput(value: boolean | cdktf.IResolvable);
    resetStrictJsonOutput(): void;
    get strictJsonOutputInput(): boolean | cdktf.IResolvable | undefined;
    private _timeInputFormat?;
    get timeInputFormat(): string;
    set timeInputFormat(value: string);
    resetTimeInputFormat(): void;
    get timeInputFormatInput(): string | undefined;
    private _timeOutputFormat?;
    get timeOutputFormat(): string;
    set timeOutputFormat(value: string);
    resetTimeOutputFormat(): void;
    get timeOutputFormatInput(): string | undefined;
    private _timestampDayIsAlways24H?;
    get timestampDayIsAlways24H(): boolean | cdktf.IResolvable;
    set timestampDayIsAlways24H(value: boolean | cdktf.IResolvable);
    resetTimestampDayIsAlways24H(): void;
    get timestampDayIsAlways24HInput(): boolean | cdktf.IResolvable | undefined;
    private _timestampInputFormat?;
    get timestampInputFormat(): string;
    set timestampInputFormat(value: string);
    resetTimestampInputFormat(): void;
    get timestampInputFormatInput(): string | undefined;
    private _timestampLtzOutputFormat?;
    get timestampLtzOutputFormat(): string;
    set timestampLtzOutputFormat(value: string);
    resetTimestampLtzOutputFormat(): void;
    get timestampLtzOutputFormatInput(): string | undefined;
    private _timestampNtzOutputFormat?;
    get timestampNtzOutputFormat(): string;
    set timestampNtzOutputFormat(value: string);
    resetTimestampNtzOutputFormat(): void;
    get timestampNtzOutputFormatInput(): string | undefined;
    private _timestampOutputFormat?;
    get timestampOutputFormat(): string;
    set timestampOutputFormat(value: string);
    resetTimestampOutputFormat(): void;
    get timestampOutputFormatInput(): string | undefined;
    private _timestampTypeMapping?;
    get timestampTypeMapping(): string;
    set timestampTypeMapping(value: string);
    resetTimestampTypeMapping(): void;
    get timestampTypeMappingInput(): string | undefined;
    private _timestampTzOutputFormat?;
    get timestampTzOutputFormat(): string;
    set timestampTzOutputFormat(value: string);
    resetTimestampTzOutputFormat(): void;
    get timestampTzOutputFormatInput(): string | undefined;
    private _timezone?;
    get timezone(): string;
    set timezone(value: string);
    resetTimezone(): void;
    get timezoneInput(): string | undefined;
    private _traceLevel?;
    get traceLevel(): string;
    set traceLevel(value: string);
    resetTraceLevel(): void;
    get traceLevelInput(): string | undefined;
    private _transactionAbortOnError?;
    get transactionAbortOnError(): boolean | cdktf.IResolvable;
    set transactionAbortOnError(value: boolean | cdktf.IResolvable);
    resetTransactionAbortOnError(): void;
    get transactionAbortOnErrorInput(): boolean | cdktf.IResolvable | undefined;
    private _transactionDefaultIsolationLevel?;
    get transactionDefaultIsolationLevel(): string;
    set transactionDefaultIsolationLevel(value: string);
    resetTransactionDefaultIsolationLevel(): void;
    get transactionDefaultIsolationLevelInput(): string | undefined;
    private _twoDigitCenturyStart?;
    get twoDigitCenturyStart(): number;
    set twoDigitCenturyStart(value: number);
    resetTwoDigitCenturyStart(): void;
    get twoDigitCenturyStartInput(): number | undefined;
    private _unsupportedDdlAction?;
    get unsupportedDdlAction(): string;
    set unsupportedDdlAction(value: string);
    resetUnsupportedDdlAction(): void;
    get unsupportedDdlActionInput(): string | undefined;
    private _useCachedResult?;
    get useCachedResult(): boolean | cdktf.IResolvable;
    set useCachedResult(value: boolean | cdktf.IResolvable);
    resetUseCachedResult(): void;
    get useCachedResultInput(): boolean | cdktf.IResolvable | undefined;
    get userType(): string;
    private _weekOfYearPolicy?;
    get weekOfYearPolicy(): number;
    set weekOfYearPolicy(value: number);
    resetWeekOfYearPolicy(): void;
    get weekOfYearPolicyInput(): number | undefined;
    private _weekStart?;
    get weekStart(): number;
    set weekStart(value: number);
    resetWeekStart(): void;
    get weekStartInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
