/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceConfig extends cdktf.TerraformMetaArguments {
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`default`)) Specifies whether to automatically resume a service. Available options are: "true" or "false". When the value is not set in the configuration the provider will put "default" there which means to use the Snowflake default for this value.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#auto_resume Service#auto_resume}
    */
    readonly autoResume?: string;
    /**
    * (Default: fallback to Snowflake default - uses special value that cannot be set in the configuration manually (`-1`)) Specifies the number of seconds of inactivity (service is idle) after which Snowflake automatically suspends the service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#auto_suspend_secs Service#auto_suspend_secs}
    */
    readonly autoSuspendSecs?: number;
    /**
    * Specifies a comment for the service.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#comment Service#comment}
    */
    readonly comment?: string;
    /**
    * Specifies the name of the compute pool in your account on which to run the service. Identifiers with special or lower-case characters are not supported. This limitation in the provider follows the limitation in Snowflake (see [docs](https://docs.snowflake.com/en/sql-reference/sql/create-compute-pool)). Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#compute_pool Service#compute_pool}
    */
    readonly computePool: string;
    /**
    * The database in which to create the service. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#database Service#database}
    */
    readonly database: string;
    /**
    * Specifies the names of the external access integrations that allow your service to access external sites.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#external_access_integrations Service#external_access_integrations}
    */
    readonly externalAccessIntegrations?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#id Service#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Specifies the maximum number of service instances to run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#max_instances Service#max_instances}
    */
    readonly maxInstances?: number;
    /**
    * Specifies the minimum number of service instances to run.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#min_instances Service#min_instances}
    */
    readonly minInstances?: number;
    /**
    * Indicates the minimum service instances that must be ready for Snowflake to consider the service is ready to process requests.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#min_ready_instances Service#min_ready_instances}
    */
    readonly minReadyInstances?: number;
    /**
    * Specifies the identifier for the service; must be unique for the schema in which the service is created. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#name Service#name}
    */
    readonly name: string;
    /**
    * Warehouse to use if a service container connects to Snowflake to execute a query but does not explicitly specify a warehouse to use. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#query_warehouse Service#query_warehouse}
    */
    readonly queryWarehouse?: string;
    /**
    * The schema in which to create the service. Due to technical limitations (read more [here](../guides/identifiers_rework_design_decisions#known-limitations-and-identifier-recommendations)), avoid using the following characters: `|`, `.`, `"`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#schema Service#schema}
    */
    readonly schema: string;
    /**
    * from_specification block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#from_specification Service#from_specification}
    */
    readonly fromSpecification?: ServiceFromSpecification;
    /**
    * from_specification_template block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#from_specification_template Service#from_specification_template}
    */
    readonly fromSpecificationTemplate?: ServiceFromSpecificationTemplate;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#timeouts Service#timeouts}
    */
    readonly timeouts?: ServiceTimeouts;
}
export interface ServiceDescribeOutput {
}
export declare function serviceDescribeOutputToTerraform(struct?: ServiceDescribeOutput): any;
export declare function serviceDescribeOutputToHclTerraform(struct?: ServiceDescribeOutput): any;
export declare class ServiceDescribeOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceDescribeOutput | undefined;
    set internalValue(value: ServiceDescribeOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get computePool(): string;
    get createdOn(): string;
    get currentInstances(): number;
    get databaseName(): string;
    get dnsName(): string;
    get externalAccessIntegrations(): string[];
    get isAsyncJob(): cdktf.IResolvable;
    get isJob(): cdktf.IResolvable;
    get isUpgrading(): cdktf.IResolvable;
    get managingObjectDomain(): string;
    get managingObjectName(): string;
    get maxInstances(): number;
    get minInstances(): number;
    get minReadyInstances(): number;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get resumedOn(): string;
    get schemaName(): string;
    get spec(): string;
    get specDigest(): string;
    get status(): string;
    get suspendedOn(): string;
    get targetInstances(): number;
    get updatedOn(): string;
}
export declare class ServiceDescribeOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceDescribeOutputOutputReference;
}
export interface ServiceShowOutput {
}
export declare function serviceShowOutputToTerraform(struct?: ServiceShowOutput): any;
export declare function serviceShowOutputToHclTerraform(struct?: ServiceShowOutput): any;
export declare class ServiceShowOutputOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceShowOutput | undefined;
    set internalValue(value: ServiceShowOutput | undefined);
    get autoResume(): cdktf.IResolvable;
    get autoSuspendSecs(): number;
    get comment(): string;
    get computePool(): string;
    get createdOn(): string;
    get currentInstances(): number;
    get databaseName(): string;
    get dnsName(): string;
    get externalAccessIntegrations(): string[];
    get isAsyncJob(): cdktf.IResolvable;
    get isJob(): cdktf.IResolvable;
    get isUpgrading(): cdktf.IResolvable;
    get managingObjectDomain(): string;
    get managingObjectName(): string;
    get maxInstances(): number;
    get minInstances(): number;
    get minReadyInstances(): number;
    get name(): string;
    get owner(): string;
    get ownerRoleType(): string;
    get queryWarehouse(): string;
    get resumedOn(): string;
    get schemaName(): string;
    get specDigest(): string;
    get status(): string;
    get suspendedOn(): string;
    get targetInstances(): number;
    get updatedOn(): string;
}
export declare class ServiceShowOutputList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceShowOutputOutputReference;
}
export interface ServiceFromSpecification {
    /**
    * The file name of the service specification. Example: `spec.yaml`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#file Service#file}
    */
    readonly file?: string;
    /**
    * The path to the service specification file on the given stage. When the path is specified, the `/` character is automatically added as a path prefix. Example: `path/to/spec`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#path Service#path}
    */
    readonly path?: string;
    /**
    * The fully qualified name of the stage containing the service specification file. At symbol (`@`) is added automatically. Example: `"\"<db_name>\".\"<schema_name>\".\"<stage_name>\""`. For more information about this resource, see [docs](./stage).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#stage Service#stage}
    */
    readonly stage?: string;
    /**
    * The embedded text of the service specification.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#text Service#text}
    */
    readonly text?: string;
}
export declare function serviceFromSpecificationToTerraform(struct?: ServiceFromSpecificationOutputReference | ServiceFromSpecification): any;
export declare function serviceFromSpecificationToHclTerraform(struct?: ServiceFromSpecificationOutputReference | ServiceFromSpecification): any;
export declare class ServiceFromSpecificationOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFromSpecification | undefined;
    set internalValue(value: ServiceFromSpecification | undefined);
    private _file?;
    get file(): string;
    set file(value: string);
    resetFile(): void;
    get fileInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _stage?;
    get stage(): string;
    set stage(value: string);
    resetStage(): void;
    get stageInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
}
export interface ServiceFromSpecificationTemplateUsing {
    /**
    * The name of the template variable. The provider wraps it in double quotes by default, so be aware of that while referencing the argument in the spec definition.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#key Service#key}
    */
    readonly key: string;
    /**
    * The value to assign to the variable in the template. The provider wraps it in `$$` by default, so be aware of that while referencing the argument in the spec definition. The value must either be alphanumeric or valid JSON.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#value Service#value}
    */
    readonly value: string;
}
export declare function serviceFromSpecificationTemplateUsingToTerraform(struct?: ServiceFromSpecificationTemplateUsing | cdktf.IResolvable): any;
export declare function serviceFromSpecificationTemplateUsingToHclTerraform(struct?: ServiceFromSpecificationTemplateUsing | cdktf.IResolvable): any;
export declare class ServiceFromSpecificationTemplateUsingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param complexObjectIndex the index of this item in the list
    * @param complexObjectIsFromSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, complexObjectIndex: number, complexObjectIsFromSet: boolean);
    get internalValue(): ServiceFromSpecificationTemplateUsing | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceFromSpecificationTemplateUsing | cdktf.IResolvable | undefined);
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
}
export declare class ServiceFromSpecificationTemplateUsingList extends cdktf.ComplexList {
    protected terraformResource: cdktf.IInterpolatingParent;
    protected terraformAttribute: string;
    protected wrapsSet: boolean;
    internalValue?: ServiceFromSpecificationTemplateUsing[] | cdktf.IResolvable;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param wrapsSet whether the list is wrapping a set (will add tolist() to be able to access an item via an index)
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, wrapsSet: boolean);
    /**
    * @param index the index of the item to return
    */
    get(index: number): ServiceFromSpecificationTemplateUsingOutputReference;
}
export interface ServiceFromSpecificationTemplate {
    /**
    * The file name of the service specification template. Example: `spec.yaml`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#file Service#file}
    */
    readonly file?: string;
    /**
    * The path to the service specification template file on the given stage. When the path is specified, the `/` character is automatically added as a path prefix. Example: `path/to/spec`.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#path Service#path}
    */
    readonly path?: string;
    /**
    * The fully qualified name of the stage containing the service specification template file. At symbol (`@`) is added automatically. Example: `"\"<db_name>\".\"<schema_name>\".\"<stage_name>\""`. For more information about this resource, see [docs](./stage).
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#stage Service#stage}
    */
    readonly stage?: string;
    /**
    * The embedded text of the service specification template.
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#text Service#text}
    */
    readonly text?: string;
    /**
    * using block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#using Service#using}
    */
    readonly using: ServiceFromSpecificationTemplateUsing[] | cdktf.IResolvable;
}
export declare function serviceFromSpecificationTemplateToTerraform(struct?: ServiceFromSpecificationTemplateOutputReference | ServiceFromSpecificationTemplate): any;
export declare function serviceFromSpecificationTemplateToHclTerraform(struct?: ServiceFromSpecificationTemplateOutputReference | ServiceFromSpecificationTemplate): any;
export declare class ServiceFromSpecificationTemplateOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceFromSpecificationTemplate | undefined;
    set internalValue(value: ServiceFromSpecificationTemplate | undefined);
    private _file?;
    get file(): string;
    set file(value: string);
    resetFile(): void;
    get fileInput(): string | undefined;
    private _path?;
    get path(): string;
    set path(value: string);
    resetPath(): void;
    get pathInput(): string | undefined;
    private _stage?;
    get stage(): string;
    set stage(value: string);
    resetStage(): void;
    get stageInput(): string | undefined;
    private _text?;
    get text(): string;
    set text(value: string);
    resetText(): void;
    get textInput(): string | undefined;
    private _using;
    get using(): ServiceFromSpecificationTemplateUsingList;
    putUsing(value: ServiceFromSpecificationTemplateUsing[] | cdktf.IResolvable): void;
    get usingInput(): cdktf.IResolvable | ServiceFromSpecificationTemplateUsing[] | undefined;
}
export interface ServiceTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#create Service#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#delete Service#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#read Service#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#update Service#update}
    */
    readonly update?: string;
}
export declare function serviceTimeoutsToTerraform(struct?: ServiceTimeouts | cdktf.IResolvable): any;
export declare function serviceTimeoutsToHclTerraform(struct?: ServiceTimeouts | cdktf.IResolvable): any;
export declare class ServiceTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): ServiceTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: ServiceTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service snowflake_service}
*/
export declare class Service extends cdktf.TerraformResource {
    static readonly tfResourceType = "snowflake_service";
    /**
    * Generates CDKTF code for importing a Service resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the Service to import
    * @param importFromId The id of the existing Service that should be imported. Refer to the {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the Service to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/snowflakedb/snowflake/2.2.0/docs/resources/service snowflake_service} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceConfig
    */
    constructor(scope: Construct, id: string, config: ServiceConfig);
    private _autoResume?;
    get autoResume(): string;
    set autoResume(value: string);
    resetAutoResume(): void;
    get autoResumeInput(): string | undefined;
    private _autoSuspendSecs?;
    get autoSuspendSecs(): number;
    set autoSuspendSecs(value: number);
    resetAutoSuspendSecs(): void;
    get autoSuspendSecsInput(): number | undefined;
    private _comment?;
    get comment(): string;
    set comment(value: string);
    resetComment(): void;
    get commentInput(): string | undefined;
    private _computePool?;
    get computePool(): string;
    set computePool(value: string);
    get computePoolInput(): string | undefined;
    private _database?;
    get database(): string;
    set database(value: string);
    get databaseInput(): string | undefined;
    private _describeOutput;
    get describeOutput(): ServiceDescribeOutputList;
    private _externalAccessIntegrations?;
    get externalAccessIntegrations(): string[];
    set externalAccessIntegrations(value: string[]);
    resetExternalAccessIntegrations(): void;
    get externalAccessIntegrationsInput(): string[] | undefined;
    get fullyQualifiedName(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _maxInstances?;
    get maxInstances(): number;
    set maxInstances(value: number);
    resetMaxInstances(): void;
    get maxInstancesInput(): number | undefined;
    private _minInstances?;
    get minInstances(): number;
    set minInstances(value: number);
    resetMinInstances(): void;
    get minInstancesInput(): number | undefined;
    private _minReadyInstances?;
    get minReadyInstances(): number;
    set minReadyInstances(value: number);
    resetMinReadyInstances(): void;
    get minReadyInstancesInput(): number | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _queryWarehouse?;
    get queryWarehouse(): string;
    set queryWarehouse(value: string);
    resetQueryWarehouse(): void;
    get queryWarehouseInput(): string | undefined;
    private _schema?;
    get schema(): string;
    set schema(value: string);
    get schemaInput(): string | undefined;
    get serviceType(): string;
    private _showOutput;
    get showOutput(): ServiceShowOutputList;
    private _fromSpecification;
    get fromSpecification(): ServiceFromSpecificationOutputReference;
    putFromSpecification(value: ServiceFromSpecification): void;
    resetFromSpecification(): void;
    get fromSpecificationInput(): ServiceFromSpecification | undefined;
    private _fromSpecificationTemplate;
    get fromSpecificationTemplate(): ServiceFromSpecificationTemplateOutputReference;
    putFromSpecificationTemplate(value: ServiceFromSpecificationTemplate): void;
    resetFromSpecificationTemplate(): void;
    get fromSpecificationTemplateInput(): ServiceFromSpecificationTemplate | undefined;
    private _timeouts;
    get timeouts(): ServiceTimeoutsOutputReference;
    putTimeouts(value: ServiceTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | ServiceTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
