/*
 * Decompiled with CFR 0.152.
 */
package io.ray.serve.deployment;

import io.ray.serve.api.Serve;
import io.ray.serve.config.DeploymentConfig;
import io.ray.serve.deployment.DeploymentCreator;
import io.ray.serve.handle.RayServeHandle;
import io.ray.shaded.com.google.common.base.Preconditions;
import java.util.Map;

public class Deployment {
    private final String deploymentDef;
    private final String name;
    private final DeploymentConfig config;
    private final String version;
    private final String prevVersion;
    private final Object[] initArgs;
    private final String routePrefix;
    private final Map<String, Object> rayActorOptions;
    private final String url;

    public Deployment(String deploymentDef, String name, DeploymentConfig config, String version, String prevVersion, Object[] initArgs, String routePrefix, Map<String, Object> rayActorOptions) {
        if (routePrefix != null) {
            Preconditions.checkArgument(routePrefix.startsWith("/"), "route_prefix must start with '/'.");
            Preconditions.checkArgument(routePrefix.equals("/") || !routePrefix.endsWith("/"), "route_prefix must not end with '/' unless it's the root.");
            Preconditions.checkArgument(!routePrefix.contains("{") && !routePrefix.contains("}"), "route_prefix may not contain wildcards.");
        }
        Preconditions.checkArgument(version != null || config.getAutoscalingConfig() == null, "Currently autoscaling is only supported for versioned deployments. Try Serve.deployment.setVersion.");
        this.deploymentDef = deploymentDef;
        this.name = name;
        this.version = version;
        this.prevVersion = prevVersion;
        this.config = config;
        this.initArgs = initArgs != null ? initArgs : new Object[]{};
        this.routePrefix = routePrefix;
        this.rayActorOptions = rayActorOptions;
        this.url = routePrefix != null ? Serve.getGlobalClient().getRootUrl() + routePrefix : null;
    }

    public void deploy(boolean blocking) {
        Serve.getGlobalClient().deploy(this.name, this.deploymentDef, this.initArgs, this.rayActorOptions, this.config, this.version, this.prevVersion, this.routePrefix, this.url, blocking);
    }

    public void delete() {
        Serve.getGlobalClient().deleteDeployment(this.name, true);
    }

    public RayServeHandle getHandle() {
        return Serve.getGlobalClient().getHandle(this.name, true);
    }

    public DeploymentCreator options() {
        return new DeploymentCreator().setDeploymentDef(this.deploymentDef).setName(this.name).setVersion(this.version).setPrevVersion(this.prevVersion).setNumReplicas(this.config.getNumReplicas()).setInitArgs(this.initArgs).setRoutePrefix(this.routePrefix).setRayActorOptions(this.rayActorOptions).setUserConfig(this.config.getUserConfig()).setMaxConcurrentQueries(this.config.getMaxConcurrentQueries()).setAutoscalingConfig(this.config.getAutoscalingConfig()).setGracefulShutdownWaitLoopS(this.config.getGracefulShutdownWaitLoopS()).setGracefulShutdownTimeoutS(this.config.getGracefulShutdownTimeoutS()).setHealthCheckPeriodS(this.config.getHealthCheckPeriodS()).setHealthCheckTimeoutS(this.config.getHealthCheckTimeoutS()).setLanguage(this.config.getDeploymentLanguage());
    }

    public String getDeploymentDef() {
        return this.deploymentDef;
    }

    public String getName() {
        return this.name;
    }

    public DeploymentConfig getConfig() {
        return this.config;
    }

    public String getVersion() {
        return this.version;
    }

    public String getPrevVersion() {
        return this.prevVersion;
    }

    public Object[] getInitArgs() {
        return this.initArgs;
    }

    public String getRoutePrefix() {
        return this.routePrefix;
    }

    public Map<String, Object> getRayActorOptions() {
        return this.rayActorOptions;
    }

    public String getUrl() {
        return this.url;
    }
}

