"""

Copyright (c) 2023, Benjamin D. Killeen. MIT License.

"""
from .core import (
    HomogeneousObject,
    PointOrVector,
    get_data,
    Point,
    Vector,
    Point2D,
    Point3D,
    Vector2D,
    Vector3D,
    point,
    vector,
    F,
    p,
    v,
    f,
    Transform,
    FrameTransform,
    frame_transform,
    RAS_from_LPS,
    LPS_from_RAS,
    mm_from_m,
    m_from_mm,
    cm_from_m,
    m_from_cm,
    cm_from_mm,
    mm_from_cm,
    unity_from_slicer,
    slicer_from_unity,
    CameraProjection,
    CameraIntrinsicTransform,
)
from .hyperplane import HyperPlane, Line, Line2D, Line3D, Plane, line, l, pl, plane
from .ray import Ray, Ray2D, Ray3D, ray
from .segment import Segment, Segment2D, Segment3D, segment
from .exceptions import JoinError, MeetError
from scipy.spatial.transform import Rotation
from .random import spherical_uniform

__all__ = [
    "HomogeneousObject",
    "PointOrVector",
    "get_data",
    "Point",
    "Point2D",
    "Point3D",
    "Vector",
    "Vector2D",
    "Vector3D",
    "Line",
    "HyperPlane",
    "Line2D",
    "Line3D",
    "Segment",
    "Segment2D",
    "Segment3D",
    "Plane",
    "Ray",
    "Ray",
    "Ray3D",
    "point",
    "vector",
    "line",
    "plane",
    "ray",
    "segment",
    "F",
    "p",
    "v",
    "l",
    "pl",
    "f",
    "Transform",
    "FrameTransform",
    "frame_transform",
    "RAS_from_LPS",
    "LPS_from_RAS",
    "mm_from_m",
    "m_from_mm",
    "cm_from_m",
    "m_from_cm",
    "cm_from_mm",
    "mm_from_cm",
    "unity_from_slicer",
    "slicer_from_unity",
    "JoinError",
    "MeetError",
    "CameraIntrinsicTransform",
    "CameraProjection",
    "Rotation",
    "spherical_uniform",
]

__version__ = "0.0.3"
