
# Autogenerated by mlir-tblgen; don't manually edit.

from enum import IntEnum, auto, IntFlag
from ._ods_common import _cext as _ods_cext
from ..ir import register_attribute_builder
_ods_ir = _ods_cext.ir

class AsmDialect(IntEnum):
    """ATT (0) or Intel (1) asm dialect"""

    AD_ATT = 0
    AD_Intel = 1

    def __str__(self):
        if self is AsmDialect.AD_ATT:
            return "att"
        if self is AsmDialect.AD_Intel:
            return "intel"
        raise ValueError("Unknown AsmDialect enum entry.")



@register_attribute_builder("AsmATTOrIntel")
def _asmattorintel(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class AtomicBinOp(IntEnum):
    """llvm.atomicrmw binary operations"""

    xchg = 0
    add = 1
    sub = 2
    _and = 3
    nand = 4
    _or = 5
    _xor = 6
    max = 7
    min = 8
    umax = 9
    umin = 10
    fadd = 11
    fsub = 12
    fmax = 13
    fmin = 14
    uinc_wrap = 15
    udec_wrap = 16
    usub_cond = 17
    usub_sat = 18

    def __str__(self):
        if self is AtomicBinOp.xchg:
            return "xchg"
        if self is AtomicBinOp.add:
            return "add"
        if self is AtomicBinOp.sub:
            return "sub"
        if self is AtomicBinOp._and:
            return "_and"
        if self is AtomicBinOp.nand:
            return "nand"
        if self is AtomicBinOp._or:
            return "_or"
        if self is AtomicBinOp._xor:
            return "_xor"
        if self is AtomicBinOp.max:
            return "max"
        if self is AtomicBinOp.min:
            return "min"
        if self is AtomicBinOp.umax:
            return "umax"
        if self is AtomicBinOp.umin:
            return "umin"
        if self is AtomicBinOp.fadd:
            return "fadd"
        if self is AtomicBinOp.fsub:
            return "fsub"
        if self is AtomicBinOp.fmax:
            return "fmax"
        if self is AtomicBinOp.fmin:
            return "fmin"
        if self is AtomicBinOp.uinc_wrap:
            return "uinc_wrap"
        if self is AtomicBinOp.udec_wrap:
            return "udec_wrap"
        if self is AtomicBinOp.usub_cond:
            return "usub_cond"
        if self is AtomicBinOp.usub_sat:
            return "usub_sat"
        raise ValueError("Unknown AtomicBinOp enum entry.")



@register_attribute_builder("AtomicBinOp")
def _atomicbinop(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class AtomicOrdering(IntEnum):
    """Atomic ordering for LLVM's memory model"""

    not_atomic = 0
    unordered = 1
    monotonic = 2
    acquire = 4
    release = 5
    acq_rel = 6
    seq_cst = 7

    def __str__(self):
        if self is AtomicOrdering.not_atomic:
            return "not_atomic"
        if self is AtomicOrdering.unordered:
            return "unordered"
        if self is AtomicOrdering.monotonic:
            return "monotonic"
        if self is AtomicOrdering.acquire:
            return "acquire"
        if self is AtomicOrdering.release:
            return "release"
        if self is AtomicOrdering.acq_rel:
            return "acq_rel"
        if self is AtomicOrdering.seq_cst:
            return "seq_cst"
        raise ValueError("Unknown AtomicOrdering enum entry.")



@register_attribute_builder("AtomicOrdering")
def _atomicordering(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class CConv(IntEnum):
    """Calling Conventions"""

    C = 0
    Fast = 8
    Cold = 9
    GHC = 10
    HiPE = 11
    AnyReg = 13
    PreserveMost = 14
    PreserveAll = 15
    Swift = 16
    CXX_FAST_TLS = 17
    Tail = 18
    CFGuard_Check = 19
    SwiftTail = 20
    X86_StdCall = 64
    X86_FastCall = 65
    ARM_APCS = 66
    ARM_AAPCS = 67
    ARM_AAPCS_VFP = 68
    MSP430_INTR = 69
    X86_ThisCall = 70
    PTX_Kernel = 71
    PTX_Device = 72
    SPIR_FUNC = 75
    SPIR_KERNEL = 76
    Intel_OCL_BI = 77
    X86_64_SysV = 78
    Win64 = 79
    X86_VectorCall = 80
    DUMMY_HHVM = 81
    DUMMY_HHVM_C = 82
    X86_INTR = 83
    AVR_INTR = 84
    AVR_BUILTIN = 86
    AMDGPU_VS = 87
    AMDGPU_GS = 88
    AMDGPU_CS = 90
    AMDGPU_KERNEL = 91
    X86_RegCall = 92
    AMDGPU_HS = 93
    MSP430_BUILTIN = 94
    AMDGPU_LS = 95
    AMDGPU_ES = 96
    AArch64_VectorCall = 97
    AArch64_SVE_VectorCall = 98
    WASM_EmscriptenInvoke = 99
    AMDGPU_Gfx = 100
    M68k_INTR = 101

    def __str__(self):
        if self is CConv.C:
            return "ccc"
        if self is CConv.Fast:
            return "fastcc"
        if self is CConv.Cold:
            return "coldcc"
        if self is CConv.GHC:
            return "cc_10"
        if self is CConv.HiPE:
            return "cc_11"
        if self is CConv.AnyReg:
            return "anyregcc"
        if self is CConv.PreserveMost:
            return "preserve_mostcc"
        if self is CConv.PreserveAll:
            return "preserve_allcc"
        if self is CConv.Swift:
            return "swiftcc"
        if self is CConv.CXX_FAST_TLS:
            return "cxx_fast_tlscc"
        if self is CConv.Tail:
            return "tailcc"
        if self is CConv.CFGuard_Check:
            return "cfguard_checkcc"
        if self is CConv.SwiftTail:
            return "swifttailcc"
        if self is CConv.X86_StdCall:
            return "x86_stdcallcc"
        if self is CConv.X86_FastCall:
            return "x86_fastcallcc"
        if self is CConv.ARM_APCS:
            return "arm_apcscc"
        if self is CConv.ARM_AAPCS:
            return "arm_aapcscc"
        if self is CConv.ARM_AAPCS_VFP:
            return "arm_aapcs_vfpcc"
        if self is CConv.MSP430_INTR:
            return "msp430_intrcc"
        if self is CConv.X86_ThisCall:
            return "x86_thiscallcc"
        if self is CConv.PTX_Kernel:
            return "ptx_kernelcc"
        if self is CConv.PTX_Device:
            return "ptx_devicecc"
        if self is CConv.SPIR_FUNC:
            return "spir_funccc"
        if self is CConv.SPIR_KERNEL:
            return "spir_kernelcc"
        if self is CConv.Intel_OCL_BI:
            return "intel_ocl_bicc"
        if self is CConv.X86_64_SysV:
            return "x86_64_sysvcc"
        if self is CConv.Win64:
            return "win64cc"
        if self is CConv.X86_VectorCall:
            return "x86_vectorcallcc"
        if self is CConv.DUMMY_HHVM:
            return "hhvmcc"
        if self is CConv.DUMMY_HHVM_C:
            return "hhvm_ccc"
        if self is CConv.X86_INTR:
            return "x86_intrcc"
        if self is CConv.AVR_INTR:
            return "avr_intrcc"
        if self is CConv.AVR_BUILTIN:
            return "avr_builtincc"
        if self is CConv.AMDGPU_VS:
            return "amdgpu_vscc"
        if self is CConv.AMDGPU_GS:
            return "amdgpu_gscc"
        if self is CConv.AMDGPU_CS:
            return "amdgpu_cscc"
        if self is CConv.AMDGPU_KERNEL:
            return "amdgpu_kernelcc"
        if self is CConv.X86_RegCall:
            return "x86_regcallcc"
        if self is CConv.AMDGPU_HS:
            return "amdgpu_hscc"
        if self is CConv.MSP430_BUILTIN:
            return "msp430_builtincc"
        if self is CConv.AMDGPU_LS:
            return "amdgpu_lscc"
        if self is CConv.AMDGPU_ES:
            return "amdgpu_escc"
        if self is CConv.AArch64_VectorCall:
            return "aarch64_vectorcallcc"
        if self is CConv.AArch64_SVE_VectorCall:
            return "aarch64_sve_vectorcallcc"
        if self is CConv.WASM_EmscriptenInvoke:
            return "wasm_emscripten_invokecc"
        if self is CConv.AMDGPU_Gfx:
            return "amdgpu_gfxcc"
        if self is CConv.M68k_INTR:
            return "m68k_intrcc"
        raise ValueError("Unknown CConv enum entry.")



@register_attribute_builder("CConvEnum")
def _cconvenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class Comdat(IntEnum):
    """LLVM Comdat Types"""

    Any = 0
    ExactMatch = 1
    Largest = 2
    NoDeduplicate = 3
    SameSize = 4

    def __str__(self):
        if self is Comdat.Any:
            return "any"
        if self is Comdat.ExactMatch:
            return "exactmatch"
        if self is Comdat.Largest:
            return "largest"
        if self is Comdat.NoDeduplicate:
            return "nodeduplicate"
        if self is Comdat.SameSize:
            return "samesize"
        raise ValueError("Unknown Comdat enum entry.")



@register_attribute_builder("Comdat")
def _comdat(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class DIFlags(IntFlag):
    """LLVM DI flags"""

    Zero = 0
    Bit0 = 1
    Bit1 = 2
    Private = 1
    Protected = 2
    Public = 3
    FwdDecl = 4
    AppleBlock = 8
    ReservedBit4 = 16
    Virtual = 32
    Artificial = 64
    Explicit = 128
    Prototyped = 256
    ObjcClassComplete = 512
    ObjectPointer = 1024
    Vector = 2048
    StaticMember = 4096
    LValueReference = 8192
    RValueReference = 16384
    ExportSymbols = 32768
    SingleInheritance = 65536
    MultipleInheritance = 65536
    VirtualInheritance = 65536
    IntroducedVirtual = 262144
    BitField = 524288
    NoReturn = 1048576
    TypePassByValue = 4194304
    TypePassByReference = 8388608
    EnumClass = 16777216
    Thunk = 33554432
    NonTrivial = 67108864
    BigEndian = 134217728
    LittleEndian = 268435456
    AllCallsDescribed = 536870912

    def __iter__(self):
        return iter([case for case in type(self) if (self & case) is case])
    def __len__(self):
        return bin(self).count("1")

    def __str__(self):
        if len(self) > 1:
            return "|".join(map(str, self))
        if self is DIFlags.Zero:
            return "Zero"
        if self is DIFlags.Bit0:
            return "Bit0"
        if self is DIFlags.Bit1:
            return "Bit1"
        if self is DIFlags.Private:
            return "Private"
        if self is DIFlags.Protected:
            return "Protected"
        if self is DIFlags.Public:
            return "Public"
        if self is DIFlags.FwdDecl:
            return "FwdDecl"
        if self is DIFlags.AppleBlock:
            return "AppleBlock"
        if self is DIFlags.ReservedBit4:
            return "ReservedBit4"
        if self is DIFlags.Virtual:
            return "Virtual"
        if self is DIFlags.Artificial:
            return "Artificial"
        if self is DIFlags.Explicit:
            return "Explicit"
        if self is DIFlags.Prototyped:
            return "Prototyped"
        if self is DIFlags.ObjcClassComplete:
            return "ObjcClassComplete"
        if self is DIFlags.ObjectPointer:
            return "ObjectPointer"
        if self is DIFlags.Vector:
            return "Vector"
        if self is DIFlags.StaticMember:
            return "StaticMember"
        if self is DIFlags.LValueReference:
            return "LValueReference"
        if self is DIFlags.RValueReference:
            return "RValueReference"
        if self is DIFlags.ExportSymbols:
            return "ExportSymbols"
        if self is DIFlags.SingleInheritance:
            return "SingleInheritance"
        if self is DIFlags.MultipleInheritance:
            return "MultipleInheritance"
        if self is DIFlags.VirtualInheritance:
            return "VirtualInheritance"
        if self is DIFlags.IntroducedVirtual:
            return "IntroducedVirtual"
        if self is DIFlags.BitField:
            return "BitField"
        if self is DIFlags.NoReturn:
            return "NoReturn"
        if self is DIFlags.TypePassByValue:
            return "TypePassByValue"
        if self is DIFlags.TypePassByReference:
            return "TypePassByReference"
        if self is DIFlags.EnumClass:
            return "EnumClass"
        if self is DIFlags.Thunk:
            return "Thunk"
        if self is DIFlags.NonTrivial:
            return "NonTrivial"
        if self is DIFlags.BigEndian:
            return "BigEndian"
        if self is DIFlags.LittleEndian:
            return "LittleEndian"
        if self is DIFlags.AllCallsDescribed:
            return "AllCallsDescribed"
        raise ValueError("Unknown DIFlags enum entry.")



@register_attribute_builder("DIFlags")
def _diflags(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class DISubprogramFlags(IntFlag):
    """LLVM DISubprogram flags"""

    Virtual = 1
    PureVirtual = 2
    LocalToUnit = 4
    Definition = 8
    Optimized = 16
    Pure = 32
    Elemental = 64
    Recursive = 128
    MainSubprogram = 256
    Deleted = 512
    ObjCDirect = 2048

    def __iter__(self):
        return iter([case for case in type(self) if (self & case) is case])
    def __len__(self):
        return bin(self).count("1")

    def __str__(self):
        if len(self) > 1:
            return "|".join(map(str, self))
        if self is DISubprogramFlags.Virtual:
            return "Virtual"
        if self is DISubprogramFlags.PureVirtual:
            return "PureVirtual"
        if self is DISubprogramFlags.LocalToUnit:
            return "LocalToUnit"
        if self is DISubprogramFlags.Definition:
            return "Definition"
        if self is DISubprogramFlags.Optimized:
            return "Optimized"
        if self is DISubprogramFlags.Pure:
            return "Pure"
        if self is DISubprogramFlags.Elemental:
            return "Elemental"
        if self is DISubprogramFlags.Recursive:
            return "Recursive"
        if self is DISubprogramFlags.MainSubprogram:
            return "MainSubprogram"
        if self is DISubprogramFlags.Deleted:
            return "Deleted"
        if self is DISubprogramFlags.ObjCDirect:
            return "ObjCDirect"
        raise ValueError("Unknown DISubprogramFlags enum entry.")



@register_attribute_builder("DISubprogramFlags")
def _disubprogramflags(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class FCmpPredicate(IntEnum):
    """llvm.fcmp comparison predicate"""

    _false = 0
    oeq = 1
    ogt = 2
    oge = 3
    olt = 4
    ole = 5
    one = 6
    ord = 7
    ueq = 8
    ugt = 9
    uge = 10
    ult = 11
    ule = 12
    une = 13
    uno = 14
    _true = 15

    def __str__(self):
        if self is FCmpPredicate._false:
            return "_false"
        if self is FCmpPredicate.oeq:
            return "oeq"
        if self is FCmpPredicate.ogt:
            return "ogt"
        if self is FCmpPredicate.oge:
            return "oge"
        if self is FCmpPredicate.olt:
            return "olt"
        if self is FCmpPredicate.ole:
            return "ole"
        if self is FCmpPredicate.one:
            return "one"
        if self is FCmpPredicate.ord:
            return "ord"
        if self is FCmpPredicate.ueq:
            return "ueq"
        if self is FCmpPredicate.ugt:
            return "ugt"
        if self is FCmpPredicate.uge:
            return "uge"
        if self is FCmpPredicate.ult:
            return "ult"
        if self is FCmpPredicate.ule:
            return "ule"
        if self is FCmpPredicate.une:
            return "une"
        if self is FCmpPredicate.uno:
            return "uno"
        if self is FCmpPredicate._true:
            return "_true"
        raise ValueError("Unknown FCmpPredicate enum entry.")



@register_attribute_builder("FCmpPredicate")
def _fcmppredicate(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class FPExceptionBehavior(IntEnum):
    """LLVM Exception Behavior"""

    Ignore = 0
    MayTrap = 1
    Strict = 2

    def __str__(self):
        if self is FPExceptionBehavior.Ignore:
            return "ignore"
        if self is FPExceptionBehavior.MayTrap:
            return "maytrap"
        if self is FPExceptionBehavior.Strict:
            return "strict"
        raise ValueError("Unknown FPExceptionBehavior enum entry.")



@register_attribute_builder("FPExceptionBehaviorAttr")
def _fpexceptionbehaviorattr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class FastmathFlags(IntFlag):
    """LLVM fastmath flags"""

    none = 0
    nnan = 1
    ninf = 2
    nsz = 4
    arcp = 8
    contract = 16
    afn = 32
    reassoc = 64
    fast = 127

    def __iter__(self):
        return iter([case for case in type(self) if (self & case) is case])
    def __len__(self):
        return bin(self).count("1")

    def __str__(self):
        if len(self) > 1:
            return ", ".join(map(str, self))
        if self is FastmathFlags.none:
            return "none"
        if self is FastmathFlags.nnan:
            return "nnan"
        if self is FastmathFlags.ninf:
            return "ninf"
        if self is FastmathFlags.nsz:
            return "nsz"
        if self is FastmathFlags.arcp:
            return "arcp"
        if self is FastmathFlags.contract:
            return "contract"
        if self is FastmathFlags.afn:
            return "afn"
        if self is FastmathFlags.reassoc:
            return "reassoc"
        if self is FastmathFlags.fast:
            return "fast"
        raise ValueError("Unknown FastmathFlags enum entry.")



@register_attribute_builder("FastmathFlags")
def _fastmathflags(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class FramePointerKind(IntEnum):
    """LLVM FramePointerKind"""

    None_ = 0
    NonLeaf = 1
    All = 2
    Reserved = 3

    def __str__(self):
        if self is FramePointerKind.None_:
            return "none"
        if self is FramePointerKind.NonLeaf:
            return "non-leaf"
        if self is FramePointerKind.All:
            return "all"
        if self is FramePointerKind.Reserved:
            return "reserved"
        raise ValueError("Unknown FramePointerKind enum entry.")



@register_attribute_builder("FramePointerKindEnum")
def _framepointerkindenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class ICmpPredicate(IntEnum):
    """lvm.icmp comparison predicate"""

    eq = 0
    ne = 1
    slt = 2
    sle = 3
    sgt = 4
    sge = 5
    ult = 6
    ule = 7
    ugt = 8
    uge = 9

    def __str__(self):
        if self is ICmpPredicate.eq:
            return "eq"
        if self is ICmpPredicate.ne:
            return "ne"
        if self is ICmpPredicate.slt:
            return "slt"
        if self is ICmpPredicate.sle:
            return "sle"
        if self is ICmpPredicate.sgt:
            return "sgt"
        if self is ICmpPredicate.sge:
            return "sge"
        if self is ICmpPredicate.ult:
            return "ult"
        if self is ICmpPredicate.ule:
            return "ule"
        if self is ICmpPredicate.ugt:
            return "ugt"
        if self is ICmpPredicate.uge:
            return "uge"
        raise ValueError("Unknown ICmpPredicate enum entry.")



@register_attribute_builder("ICmpPredicate")
def _icmppredicate(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class IntegerOverflowFlags(IntFlag):
    """LLVM integer overflow flags"""

    none = 0
    nsw = 1
    nuw = 2

    def __iter__(self):
        return iter([case for case in type(self) if (self & case) is case])
    def __len__(self):
        return bin(self).count("1")

    def __str__(self):
        if len(self) > 1:
            return ", ".join(map(str, self))
        if self is IntegerOverflowFlags.none:
            return "none"
        if self is IntegerOverflowFlags.nsw:
            return "nsw"
        if self is IntegerOverflowFlags.nuw:
            return "nuw"
        raise ValueError("Unknown IntegerOverflowFlags enum entry.")



@register_attribute_builder("IntegerOverflowFlags")
def _integeroverflowflags(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(32, context=context), int(x))

class DIEmissionKind(IntEnum):
    """LLVM debug emission kind"""

    None_ = 0
    Full = 1
    LineTablesOnly = 2
    DebugDirectivesOnly = 3

    def __str__(self):
        if self is DIEmissionKind.None_:
            return "None"
        if self is DIEmissionKind.Full:
            return "Full"
        if self is DIEmissionKind.LineTablesOnly:
            return "LineTablesOnly"
        if self is DIEmissionKind.DebugDirectivesOnly:
            return "DebugDirectivesOnly"
        raise ValueError("Unknown DIEmissionKind enum entry.")



@register_attribute_builder("LLVM_DIEmissionKind")
def _llvm_diemissionkind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class DINameTableKind(IntEnum):
    """LLVM debug name table kind"""

    Default = 0
    GNU = 1
    None_ = 2
    Apple = 3

    def __str__(self):
        if self is DINameTableKind.Default:
            return "Default"
        if self is DINameTableKind.GNU:
            return "GNU"
        if self is DINameTableKind.None_:
            return "None"
        if self is DINameTableKind.Apple:
            return "Apple"
        raise ValueError("Unknown DINameTableKind enum entry.")



@register_attribute_builder("LLVM_DINameTableKind")
def _llvm_dinametablekind(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class Linkage(IntEnum):
    """LLVM linkage types"""

    External = 0
    AvailableExternally = 1
    Linkonce = 2
    LinkonceODR = 3
    Weak = 4
    WeakODR = 5
    Appending = 6
    Internal = 7
    Private = 8
    ExternWeak = 9
    Common = 10

    def __str__(self):
        if self is Linkage.External:
            return "external"
        if self is Linkage.AvailableExternally:
            return "available_externally"
        if self is Linkage.Linkonce:
            return "linkonce"
        if self is Linkage.LinkonceODR:
            return "linkonce_odr"
        if self is Linkage.Weak:
            return "weak"
        if self is Linkage.WeakODR:
            return "weak_odr"
        if self is Linkage.Appending:
            return "appending"
        if self is Linkage.Internal:
            return "internal"
        if self is Linkage.Private:
            return "private"
        if self is Linkage.ExternWeak:
            return "extern_weak"
        if self is Linkage.Common:
            return "common"
        raise ValueError("Unknown Linkage enum entry.")



@register_attribute_builder("LinkageEnum")
def _linkageenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class ModFlagBehavior(IntEnum):
    """LLVM Module Flag Behavior"""

    Error = 1
    Warning = 2
    Require = 3
    Override = 4
    Append = 5
    AppendUnique = 6
    Max = 7
    Min = 8

    def __str__(self):
        if self is ModFlagBehavior.Error:
            return "error"
        if self is ModFlagBehavior.Warning:
            return "warning"
        if self is ModFlagBehavior.Require:
            return "require"
        if self is ModFlagBehavior.Override:
            return "override"
        if self is ModFlagBehavior.Append:
            return "append"
        if self is ModFlagBehavior.AppendUnique:
            return "append_unique"
        if self is ModFlagBehavior.Max:
            return "max"
        if self is ModFlagBehavior.Min:
            return "min"
        raise ValueError("Unknown ModFlagBehavior enum entry.")



@register_attribute_builder("ModFlagBehaviorAttr")
def _modflagbehaviorattr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class ModRefInfo(IntEnum):
    """LLVM ModRefInfo"""

    NoModRef = 0
    Ref = 1
    Mod = 2
    ModRef = 3

    def __str__(self):
        if self is ModRefInfo.NoModRef:
            return "none"
        if self is ModRefInfo.Ref:
            return "read"
        if self is ModRefInfo.Mod:
            return "write"
        if self is ModRefInfo.ModRef:
            return "readwrite"
        raise ValueError("Unknown ModRefInfo enum entry.")



@register_attribute_builder("ModRefInfoEnum")
def _modrefinfoenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class RoundingMode(IntEnum):
    """LLVM Rounding Mode"""

    TowardZero = 0
    NearestTiesToEven = 1
    TowardPositive = 2
    TowardNegative = 3
    NearestTiesToAway = 4
    Dynamic = 7
    Invalid = auto()

    def __str__(self):
        if self is RoundingMode.TowardZero:
            return "towardzero"
        if self is RoundingMode.NearestTiesToEven:
            return "tonearest"
        if self is RoundingMode.TowardPositive:
            return "upward"
        if self is RoundingMode.TowardNegative:
            return "downward"
        if self is RoundingMode.NearestTiesToAway:
            return "tonearestaway"
        if self is RoundingMode.Dynamic:
            return "dynamic"
        if self is RoundingMode.Invalid:
            return "invalid"
        raise ValueError("Unknown RoundingMode enum entry.")



@register_attribute_builder("RoundingModeAttr")
def _roundingmodeattr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class TailCallKind(IntEnum):
    """Tail Call Kind"""

    None_ = 0
    NoTail = 3
    MustTail = 2
    Tail = 1

    def __str__(self):
        if self is TailCallKind.None_:
            return "none"
        if self is TailCallKind.NoTail:
            return "notail"
        if self is TailCallKind.MustTail:
            return "musttail"
        if self is TailCallKind.Tail:
            return "tail"
        raise ValueError("Unknown TailCallKind enum entry.")



@register_attribute_builder("TailCallKindEnum")
def _tailcallkindenum(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class UnnamedAddr(IntEnum):
    """LLVM GlobalValue UnnamedAddr"""

    None_ = 0
    Local = 1
    Global = 2

    def __str__(self):
        if self is UnnamedAddr.None_:
            return ""
        if self is UnnamedAddr.Local:
            return "local_unnamed_addr"
        if self is UnnamedAddr.Global:
            return "unnamed_addr"
        raise ValueError("Unknown UnnamedAddr enum entry.")



@register_attribute_builder("UnnamedAddr")
def _unnamedaddr(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

class Visibility(IntEnum):
    """LLVM GlobalValue Visibility"""

    Default = 0
    Hidden = 1
    Protected = 2

    def __str__(self):
        if self is Visibility.Default:
            return ""
        if self is Visibility.Hidden:
            return "hidden"
        if self is Visibility.Protected:
            return "protected"
        raise ValueError("Unknown Visibility enum entry.")



@register_attribute_builder("Visibility")
def _visibility(x, context):
    return _ods_ir.IntegerAttr.get(_ods_ir.IntegerType.get_signless(64, context=context), int(x))

@register_attribute_builder("LLVM_FastmathFlagsAttr")
def _llvm_fastmathflagsattr(x, context):
    return _ods_ir.Attribute.parse(f'#llvm.fastmath<{str(x)}>', context=context)

@register_attribute_builder("LLVM_IntegerOverflowFlagsAttr")
def _llvm_integeroverflowflagsattr(x, context):
    return _ods_ir.Attribute.parse(f'#llvm.overflow<{str(x)}>', context=context)

