"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from abc import abstractmethod

from friendli_core.friendlicore_container_chat import (
    AsyncFriendliCoreContainerChat,
    SyncFriendliCoreContainerChat,
)
from friendli_core.friendlicore_container_completions import (
    AsyncFriendliCoreContainerCompletions,
    SyncFriendliCoreContainerCompletions,
)
from friendli_core.friendlicore_container_token import (
    AsyncFriendliCoreContainerToken,
    SyncFriendliCoreContainerToken,
)
from friendli_core.friendlicore_image import (
    AsyncFriendliCoreImage,
    SyncFriendliCoreImage,
)

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseContainer(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    @abstractmethod
    def _init_sdks(self):
        pass


class SyncContainer(BaseContainer, SyncSDK):
    chat: SyncFriendliCoreContainerChat
    completions: SyncFriendliCoreContainerCompletions
    token: SyncFriendliCoreContainerToken
    image: SyncFriendliCoreImage

    def _init_sdks(self):
        self.chat = SyncFriendliCoreContainerChat(self.sdk_configuration)
        self.completions = SyncFriendliCoreContainerCompletions(self.sdk_configuration)
        self.token = SyncFriendliCoreContainerToken(self.sdk_configuration)
        self.image = SyncFriendliCoreImage(self.sdk_configuration)


class AsyncContainer(BaseContainer, AsyncSDK):
    chat: AsyncFriendliCoreContainerChat
    completions: AsyncFriendliCoreContainerCompletions
    token: AsyncFriendliCoreContainerToken
    image: AsyncFriendliCoreImage

    def _init_sdks(self):
        self.chat = AsyncFriendliCoreContainerChat(self.sdk_configuration)
        self.completions = AsyncFriendliCoreContainerCompletions(self.sdk_configuration)
        self.token = AsyncFriendliCoreContainerToken(self.sdk_configuration)
        self.image = AsyncFriendliCoreImage(self.sdk_configuration)
