"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from abc import abstractmethod

from friendli_core.endpoint import AsyncEndpoint, SyncEndpoint
from friendli_core.friendlicore_chat import AsyncFriendliCoreChat, SyncFriendliCoreChat
from friendli_core.friendlicore_completions import (
    AsyncFriendliCoreCompletions,
    SyncFriendliCoreCompletions,
)
from friendli_core.friendlicore_token import (
    AsyncFriendliCoreToken,
    SyncFriendliCoreToken,
)
from friendli_core.image import AsyncImage, SyncImage

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseDedicated(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    @abstractmethod
    def _init_sdks(self):
        pass


class SyncDedicated(BaseDedicated, SyncSDK):
    chat: SyncFriendliCoreChat
    completions: SyncFriendliCoreCompletions
    token: SyncFriendliCoreToken
    image: SyncImage
    endpoint: SyncEndpoint

    def _init_sdks(self):
        self.chat = SyncFriendliCoreChat(self.sdk_configuration)
        self.completions = SyncFriendliCoreCompletions(self.sdk_configuration)
        self.token = SyncFriendliCoreToken(self.sdk_configuration)
        self.image = SyncImage(self.sdk_configuration)
        self.endpoint = SyncEndpoint(self.sdk_configuration)


class AsyncDedicated(BaseDedicated, AsyncSDK):
    chat: AsyncFriendliCoreChat
    completions: AsyncFriendliCoreCompletions
    token: AsyncFriendliCoreToken
    image: AsyncImage
    endpoint: AsyncEndpoint

    def _init_sdks(self):
        self.chat = AsyncFriendliCoreChat(self.sdk_configuration)
        self.completions = AsyncFriendliCoreCompletions(self.sdk_configuration)
        self.token = AsyncFriendliCoreToken(self.sdk_configuration)
        self.image = AsyncImage(self.sdk_configuration)
        self.endpoint = AsyncEndpoint(self.sdk_configuration)
