"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from abc import abstractmethod
from typing import Mapping, Optional

from friendli_core import models, utils
from friendli_core._hooks import HookContext
from friendli_core.types import UNSET, OptionalNullable
from friendli_core.utils import get_security_from_env

from .basesdk import AsyncSDK, BaseSDK, SyncSDK


class BaseFriendliCoreImage(BaseSDK):
    pass


class SyncFriendliCoreImage(BaseFriendliCoreImage, SyncSDK):
    def generate(
        self,
        *,
        guidance_scale: float,
        num_inference_steps: int,
        prompt: str,
        model: OptionalNullable[str] = UNSET,
        response_format: OptionalNullable[
            models.ContainerImageGenerationBodyResponseFormat
        ] = "jpeg",
        seed: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ContainerImageGenerateSuccess:
        """Image generations

        Given a description, the model generates image.

        :param guidance_scale: Adjusts the alignment of the generated image with the input prompt. Higher values (e.g., 8-10) make the output more faithful to the prompt, while lower values (e.g., 1-5) encourage more creative freedom. This parameter may be irrelevant for certain models, such as `FLUX.Schnell`.
        :param num_inference_steps: The number of inference steps to use during image generation. Supported range: [1, 50].
        :param prompt: A text description of the desired image.
        :param model: Routes the request to a specific adapter.
        :param response_format: The format in which the generated image will be returned. One of `raw` and `jpeg`.
        :param seed: The seed to use for image generation.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.CONTAINER_IMAGES_GENERATE_OP_SERVERS[0]
        request = models.ContainerImageGenerationBody(
            guidance_scale=guidance_scale,
            num_inference_steps=num_inference_steps,
            prompt=prompt,
            model=model,
            response_format=response_format,
            seed=seed,
        )
        req = self._build_request(
            method="POST",
            path="/v1/images/generations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ContainerImageGenerationBody
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="containerImagesGenerate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, models.ContainerImageGenerateSuccess
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        content_type = http_res.headers.get("Content-Type")
        http_res_text = utils.stream_to_text(http_res)
        raise models.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )


class AsyncFriendliCoreImage(BaseFriendliCoreImage, AsyncSDK):
    async def generate(
        self,
        *,
        guidance_scale: float,
        num_inference_steps: int,
        prompt: str,
        model: OptionalNullable[str] = UNSET,
        response_format: OptionalNullable[
            models.ContainerImageGenerationBodyResponseFormat
        ] = "jpeg",
        seed: OptionalNullable[int] = UNSET,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.ContainerImageGenerateSuccess:
        """Image generations

        Given a description, the model generates image.

        :param guidance_scale: Adjusts the alignment of the generated image with the input prompt. Higher values (e.g., 8-10) make the output more faithful to the prompt, while lower values (e.g., 1-5) encourage more creative freedom. This parameter may be irrelevant for certain models, such as `FLUX.Schnell`.
        :param num_inference_steps: The number of inference steps to use during image generation. Supported range: [1, 50].
        :param prompt: A text description of the desired image.
        :param model: Routes the request to a specific adapter.
        :param response_format: The format in which the generated image will be returned. One of `raw` and `jpeg`.
        :param seed: The seed to use for image generation.
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms
        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.CONTAINER_IMAGES_GENERATE_OP_SERVERS[0]
        request = models.ContainerImageGenerationBody(
            guidance_scale=guidance_scale,
            num_inference_steps=num_inference_steps,
            prompt=prompt,
            model=model,
            response_format=response_format,
            seed=seed,
        )
        req = self._build_request(
            method="POST",
            path="/v1/images/generations",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request, False, False, "json", models.ContainerImageGenerationBody
            ),
            timeout_ms=timeout_ms,
        )
        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(500, 60000, 1.5, 3600000), True
                )
        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["429", "500", "502", "503", "504"])
        http_res = await self.do_request(
            hook_ctx=HookContext(
                base_url=base_url or "",
                operation_id="containerImagesGenerate",
                oauth2_scopes=[],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["422", "4XX", "5XX"],
            retry_config=retry_config,
        )
        if utils.match_response(http_res, "200", "application/json"):
            return utils.unmarshal_json(
                http_res.text, models.ContainerImageGenerateSuccess
            )
        if utils.match_response(http_res, ["422", "4XX"], "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError(
                "API error occurred", http_res.status_code, http_res_text, http_res
            )
        content_type = http_res.headers.get("Content-Type")
        http_res_text = await utils.stream_to_text_async(http_res)
        raise models.SDKError(
            f"Unexpected response received (code: {http_res.status_code}, type: {content_type})",
            http_res.status_code,
            http_res_text,
            http_res,
        )
