"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

import io
from typing import IO, Literal, Optional, Union

import pydantic
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import BaseModel
from friendli_core.utils import FieldMetadata, MultipartFormMetadata


class FileTypedDict(TypedDict):
    file_name: str
    content: Union[bytes, IO[bytes], io.BufferedReader]
    content_type: NotRequired[str]


class File(BaseModel):
    file_name: Annotated[
        str, pydantic.Field(alias="fileName"), FieldMetadata(multipart=True)
    ]

    content: Annotated[
        Union[bytes, IO[bytes], io.BufferedReader],
        pydantic.Field(alias=""),
        FieldMetadata(multipart=MultipartFormMetadata(content=True)),
    ]

    content_type: Annotated[
        Optional[str],
        pydantic.Field(alias="Content-Type"),
        FieldMetadata(multipart=True),
    ] = None


Purpose = Literal["batch", "model"]
r"""The intended purpose of the uploaded file. One of `batch` or `model`."""


class PlatformFilesUploadBodyTypedDict(TypedDict):
    file: FileTypedDict
    r"""The File object (not file name) to be uploaded."""
    purpose: Purpose
    r"""The intended purpose of the uploaded file. One of `batch` or `model`."""


class PlatformFilesUploadBody(BaseModel):
    file: Annotated[File, FieldMetadata(multipart=MultipartFormMetadata(file=True))]
    r"""The File object (not file name) to be uploaded."""

    purpose: Annotated[Purpose, FieldMetadata(multipart=True)]
    r"""The intended purpose of the uploaded file. One of `batch` or `model`."""
