"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import Literal

import pydantic
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, TypedDict

from friendli_core.types import BaseModel
from friendli_core.utils import validate_const

PlatformFilesUploadResultPurpose = Literal["batch", "model"]
r"""The intended purpose of the uploaded file. One of `batch` or `model`."""


class PlatformFilesUploadResultTypedDict(TypedDict):
    bytes_: int
    r"""The size of the file in bytes."""
    created: int
    r"""The Unix timestamp (in seconds) for when the file was created."""
    expires: int
    r"""The Unix timestamp (in seconds) for when the file will expire."""
    filename: str
    r"""The name of the file."""
    id: str
    r"""The ID of uploaded file."""
    purpose: PlatformFilesUploadResultPurpose
    r"""The intended purpose of the uploaded file. One of `batch` or `model`."""
    object: Literal["file"]
    r"""The object type, which is always `file`."""


class PlatformFilesUploadResult(BaseModel):
    bytes_: Annotated[int, pydantic.Field(alias="bytes")]
    r"""The size of the file in bytes."""

    created: int
    r"""The Unix timestamp (in seconds) for when the file was created."""

    expires: int
    r"""The Unix timestamp (in seconds) for when the file will expire."""

    filename: str
    r"""The name of the file."""

    id: str
    r"""The ID of uploaded file."""

    purpose: PlatformFilesUploadResultPurpose
    r"""The intended purpose of the uploaded file. One of `batch` or `model`."""

    OBJECT: Annotated[
        Annotated[Literal["file"], AfterValidator(validate_const("file"))],
        pydantic.Field(alias="object"),
    ] = "file"
    r"""The object type, which is always `file`."""
