"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations

from typing import List, Literal

import pydantic
from pydantic import model_serializer
from pydantic.functional_validators import AfterValidator
from typing_extensions import Annotated, NotRequired, TypedDict

from friendli_core.types import (
    UNSET,
    UNSET_SENTINEL,
    BaseModel,
    Nullable,
    OptionalNullable,
)
from friendli_core.utils import validate_const

from .completionschoice import CompletionsChoice, CompletionsChoiceTypedDict
from .usage import Usage, UsageTypedDict


class ServerlessCompletionsSuccessTypedDict(TypedDict):
    choices: List[CompletionsChoiceTypedDict]
    id: str
    r"""A unique ID of the completion."""
    usage: UsageTypedDict
    object: Literal["text_completion"]
    r"""The object type, which is always set to `text_completion`."""
    model: NotRequired[Nullable[str]]
    r"""The model to generate the completion. For dedicated endpoints, it returns the endpoint id."""


class ServerlessCompletionsSuccess(BaseModel):
    choices: List[CompletionsChoice]

    id: str
    r"""A unique ID of the completion."""

    usage: Usage

    OBJECT: Annotated[
        Annotated[
            Literal["text_completion"],
            AfterValidator(validate_const("text_completion")),
        ],
        pydantic.Field(alias="object"),
    ] = "text_completion"
    r"""The object type, which is always set to `text_completion`."""

    model: OptionalNullable[str] = UNSET
    r"""The model to generate the completion. For dedicated endpoints, it returns the endpoint id."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["model"]
        nullable_fields = ["model"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
