"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from abc import abstractmethod

from friendli_core.chat import AsyncChat, SyncChat
from friendli_core.completions import AsyncCompletions, SyncCompletions
from friendli_core.knowledge import AsyncKnowledge, SyncKnowledge
from friendli_core.model import AsyncModel, SyncModel
from friendli_core.token import AsyncToken, SyncToken
from friendli_core.toolassistedchat import AsyncToolAssistedChat, SyncToolAssistedChat

from .basesdk import AsyncSDK, BaseSDK, SyncSDK
from .sdkconfiguration import SDKConfiguration


class BaseServerless(BaseSDK):
    def __init__(self, sdk_config: SDKConfiguration) -> None:
        BaseSDK.__init__(self, sdk_config)
        self.sdk_configuration = sdk_config
        self._init_sdks()

    @abstractmethod
    def _init_sdks(self):
        pass


class SyncServerless(BaseServerless, SyncSDK):
    chat: SyncChat
    completions: SyncCompletions
    token: SyncToken
    knowledge: SyncKnowledge
    model: SyncModel
    tool_assisted_chat: SyncToolAssistedChat

    def _init_sdks(self):
        self.chat = SyncChat(self.sdk_configuration)
        self.completions = SyncCompletions(self.sdk_configuration)
        self.token = SyncToken(self.sdk_configuration)
        self.knowledge = SyncKnowledge(self.sdk_configuration)
        self.model = SyncModel(self.sdk_configuration)
        self.tool_assisted_chat = SyncToolAssistedChat(self.sdk_configuration)


class AsyncServerless(BaseServerless, AsyncSDK):
    chat: AsyncChat
    completions: AsyncCompletions
    token: AsyncToken
    knowledge: AsyncKnowledge
    model: AsyncModel
    tool_assisted_chat: AsyncToolAssistedChat

    def _init_sdks(self):
        self.chat = AsyncChat(self.sdk_configuration)
        self.completions = AsyncCompletions(self.sdk_configuration)
        self.token = AsyncToken(self.sdk_configuration)
        self.knowledge = AsyncKnowledge(self.sdk_configuration)
        self.model = AsyncModel(self.sdk_configuration)
        self.tool_assisted_chat = AsyncToolAssistedChat(self.sdk_configuration)
