from enum import Enum
from matplotlib.colors  import ListedColormap
import numpy as np

class Units(Enum):
    SECONDS = 0
    MILLISECONDS = 1
    MICROSECONDS = 2
    DEGREES = 3
    RADIANS = 4
    
class SequenceGeneratorType(Enum):
    PERLIN = 0
    DAN_MA_PERLIN = 1
    SINUSOID = 2
    BITREVERSE = 3

class SequenceType(Enum):
    FISP = 0
    TRUEFISP = 1

class SyntheticSequenceType(Enum):
    FSE = 0
    IR = 1
    DIR = 2

class KMeansModes(Enum):
    EUCLIDEAN = 0
    COSINE = 1

T1_COLORMAP_MIN = 0
T1_COLORMAP_MAX = 3.000

T2_COLORMAP_MIN = 0
T2_COLORMAP_MAX = 0.300

B0_COLORMAP_MIN = 0.600
B0_COLORMAP_MAX = 1.000

T1_COLORMAP = ListedColormap([[3.10125424e-95,0.00000000e+00,4.55677854e-50],
[1.69765536e-11,3.93760667e-12,6.71920783e-11],
[1.75661022e-09,8.76397914e-10,3.92544731e-09],
[1.81982775e-08,1.21276203e-08,3.27466245e-08],
[8.20496835e-08,6.37383414e-08,1.32030482e-07],
[2.43207714e-07,2.07688388e-07,3.66288035e-07],
[5.62072976e-07,5.11645783e-07,8.11434284e-07],
[1.10358712e-06,1.05151565e-06,1.54867964e-06],
[1.93302357e-06,1.90548782e-06,2.66029779e-06],
[3.11332085e-06,3.14995359e-06,4.22688280e-06],
[4.70353394e-06,4.85696509e-06,6.32565966e-06],
[6.75803656e-06,7.09280909e-06,9.02950820e-06],
[9.32620731e-06,9.91733554e-06,1.24064598e-05],
[1.24524175e-05,1.33837762e-05,1.65195033e-05],
[1.61761997e-05,1.75388692e-05,2.14265884e-05],
[2.05325189e-05,2.24231646e-05,2.71807549e-05],
[2.55520952e-05,2.80714309e-05,3.38303363e-05],
[3.12617463e-05,3.45131068e-05,4.14192060e-05],
[3.76847312e-05,4.17727661e-05,4.99870445e-05],
[4.48410809e-05,4.98705744e-05,5.95696128e-05],
[5.27479113e-05,5.88227248e-05,7.01990235e-05],
[6.14197150e-05,6.86418462e-05,8.19040031e-05],
[7.08686283e-05,7.93373811e-05,9.47101428e-05],
[8.11046771e-05,9.09159310e-05,1.08640135e-04],
[9.21359991e-05,1.03381572e-04,1.23713994e-04],
[1.03969045e-04,1.16736138e-04,1.39949266e-04],
[1.16608763e-04,1.30979481e-04,1.57361219e-04],
[1.30058757e-04,1.46109701e-04,1.75963020e-04],
[1.44321442e-04,1.62123352e-04,1.95765903e-04],
[1.59398171e-04,1.79015632e-04,2.16779320e-04],
[1.75289356e-04,1.96780547e-04,2.39011078e-04],
[1.91994575e-04,2.15411064e-04,2.62467473e-04],
[2.09512669e-04,2.34899240e-04,2.87153407e-04],
[2.09344065e-04,2.53218246e-04,3.95767269e-04],
[2.24393950e-04,2.73942141e-04,4.42863191e-04],
[2.39721092e-04,2.95435059e-04,4.94304502e-04],
[2.55296634e-04,3.17683191e-04,5.50358119e-04],
[2.71092435e-04,3.40672398e-04,6.11296373e-04],
[4.38311953e-04,2.91546739e-04,6.84775297e-04],
[4.32526091e-04,4.70535959e-04,7.41690626e-04],
[4.71275101e-04,5.10941859e-04,8.17464849e-04],
[5.12569324e-04,5.53769893e-04,8.99051690e-04],
[5.56508824e-04,5.99092786e-04,9.86726477e-04],
[6.03194161e-04,6.46981994e-04,1.08076621e-03],
[6.52726281e-04,6.97507606e-04,1.18144900e-03],
[7.05206416e-04,7.50738240e-04,1.28905351e-03],
[7.60735972e-04,8.06740958e-04,1.40385841e-03],
[8.19416437e-04,8.65581180e-04,1.52614183e-03],
[8.81349275e-04,9.27322612e-04,1.65618080e-03],
[9.46635839e-04,9.92027172e-04,1.79425077e-03],
[1.01537727e-03,1.05975493e-03,1.94062507e-03],
[1.08767442e-03,1.13056404e-03,2.09557440e-03],
[1.16362776e-03,1.20451072e-03,2.25936637e-03],
[1.24333729e-03,1.28164915e-03,2.43226503e-03],
[1.32690248e-03,1.36203151e-03,2.61453040e-03],
[1.41442218e-03,1.44570786e-03,2.80641809e-03],
[1.50599455e-03,1.53272619e-03,3.00817885e-03],
[1.60171699e-03,1.62313234e-03,3.22005817e-03],
[1.70168609e-03,1.71697000e-03,3.44229599e-03],
[1.80599755e-03,1.81428073e-03,3.67512626e-03],
[1.91474612e-03,1.91510388e-03,3.91877668e-03],
[2.02802557e-03,2.01947665e-03,4.17346841e-03],
[2.14592861e-03,2.12743406e-03,4.43941571e-03],
[2.26854685e-03,2.23900895e-03,4.71682580e-03],
[2.39597074e-03,2.35423200e-03,5.00589853e-03],
[2.52828958e-03,2.47313171e-03,5.30682623e-03],
[2.66559141e-03,2.59573448e-03,5.61979347e-03],
[2.80796301e-03,2.72206453e-03,5.94497695e-03],
[2.95548986e-03,2.85214400e-03,6.28254530e-03],
[3.10825611e-03,2.98599294e-03,6.63265901e-03],
[3.26634455e-03,3.12362932e-03,6.99547024e-03],
[3.42983658e-03,3.26506909e-03,7.37112282e-03],
[3.59881216e-03,3.41032617e-03,7.75975213e-03],
[3.77334986e-03,3.55941250e-03,8.16148507e-03],
[3.95352674e-03,3.71233808e-03,8.57643999e-03],
[4.13941843e-03,3.86911098e-03,9.00472675e-03],
[4.33109905e-03,4.02973740e-03,9.44644662e-03],
[4.52864121e-03,4.19422167e-03,9.90169239e-03],
[4.73211600e-03,4.36256633e-03,1.03705483e-02],
[4.94159300e-03,4.53477213e-03,1.08530902e-02],
[5.15714024e-03,4.71083810e-03,1.13493855e-02],
[5.37882421e-03,4.89076155e-03,1.18594934e-02],
[5.60670985e-03,5.07453816e-03,1.23834645e-02],
[5.84086055e-03,5.26216196e-03,1.29213417e-02],
[6.08133815e-03,5.45362545e-03,1.34731595e-02],
[6.32820290e-03,5.64891956e-03,1.40389446e-02],
[6.58151355e-03,5.84803373e-03,1.46187158e-02],
[6.84132724e-03,6.05095595e-03,1.52124844e-02],
[7.10769960e-03,6.25767282e-03,1.58202538e-02],
[7.38068468e-03,6.46816954e-03,1.64420202e-02],
[7.66033500e-03,6.68243001e-03,1.70777724e-02],
[7.94670155e-03,6.90043681e-03,1.77274921e-02],
[8.23983375e-03,7.12217131e-03,1.83911542e-02],
[8.53977954e-03,7.34761365e-03,1.90687264e-02],
[8.84658531e-03,7.57674282e-03,1.97601702e-02],
[9.16029596e-03,7.80953668e-03,2.04654403e-02],
[9.48095487e-03,8.04597202e-03,2.11844852e-02],
[9.80860395e-03,8.28602456e-03,2.19172474e-02],
[1.01432836e-02,8.52966903e-03,2.26636631e-02],
[1.04850329e-02,8.77687920e-03,2.34236632e-02],
[1.08338891e-02,9.02762790e-03,2.41971725e-02],
[1.11898885e-02,9.28188706e-03,2.49841108e-02],
[1.15530656e-02,9.53962778e-03,2.57843925e-02],
[1.19234536e-02,9.80082032e-03,2.65979268e-02],
[1.23010844e-02,1.00654342e-02,2.74246183e-02],
[1.26859882e-02,1.03334381e-02,2.82643668e-02],
[1.30781943e-02,1.06048000e-02,2.91170674e-02],
[1.34777301e-02,1.08794874e-02,2.99826111e-02],
[1.38846222e-02,1.11574669e-02,3.08608846e-02],
[1.42988953e-02,1.14387045e-02,3.17517708e-02],
[1.47205732e-02,1.17231659e-02,3.26551486e-02],
[1.51496783e-02,1.20108159e-02,3.35708932e-02],
[1.55862316e-02,1.23016189e-02,3.44988765e-02],
[1.60302529e-02,1.25955390e-02,3.54389671e-02],
[1.64817608e-02,1.28925395e-02,3.63910303e-02],
[1.69407724e-02,1.31925835e-02,3.73549286e-02],
[1.74073040e-02,1.34956337e-02,3.83305215e-02],
[1.78813703e-02,1.38016523e-02,3.93176659e-02],
[1.83629851e-02,1.41106011e-02,4.03162164e-02],
[1.88521607e-02,1.44224419e-02,4.13260249e-02],
[1.93489084e-02,1.47371357e-02,4.23469414e-02],
[1.98532385e-02,1.50546437e-02,4.33788135e-02],
[2.03651600e-02,1.53749265e-02,4.44214871e-02],
[2.08846807e-02,1.56979446e-02,4.54748064e-02],
[2.14118075e-02,1.60236584e-02,4.65386137e-02],
[2.19465461e-02,1.63520279e-02,4.76127500e-02],
[2.24889010e-02,1.66830131e-02,4.86970547e-02],
[2.30388759e-02,1.70165737e-02,4.97913661e-02],
[2.35964734e-02,1.73526694e-02,5.08955214e-02],
[2.41616948e-02,1.76912598e-02,5.20093565e-02],
[2.47345408e-02,1.80323042e-02,5.31327067e-02],
[2.53150107e-02,1.83757622e-02,5.42654062e-02],
[2.59031032e-02,1.87215929e-02,5.54072889e-02],
[2.64988158e-02,1.90697558e-02,5.65581878e-02],
[2.71021450e-02,1.94202100e-02,5.77179355e-02],
[2.77130865e-02,1.97729148e-02,5.88863643e-02],
[2.83316350e-02,2.01278295e-02,6.00633060e-02],
[2.89577844e-02,2.04849134e-02,6.12485924e-02],
[2.95915276e-02,2.08441258e-02,6.24420553e-02],
[3.02328565e-02,2.12054261e-02,6.36435262e-02],
[3.08817623e-02,2.15687738e-02,6.48528367e-02],
[3.15382354e-02,2.19341282e-02,6.60698188e-02],
[3.22022653e-02,2.23014492e-02,6.72943045e-02],
[3.28738404e-02,2.26706963e-02,6.85261262e-02],
[3.35529488e-02,2.30418294e-02,6.97651166e-02],
[3.42395773e-02,2.34148084e-02,7.10111088e-02],
[3.49337122e-02,2.37895935e-02,7.22639365e-02],
[3.56353389e-02,2.41661447e-02,7.35234340e-02],
[3.63444422e-02,2.45444226e-02,7.47894362e-02],
[3.70610059e-02,2.49243875e-02,7.60617785e-02],
[3.77850133e-02,2.53060003e-02,7.73402973e-02],
[3.85164467e-02,2.56892218e-02,7.86248297e-02],
[3.92552880e-02,2.60740131e-02,7.99152136e-02],
[4.00015182e-02,2.64603354e-02,8.12112878e-02],
[4.07551175e-02,2.68481502e-02,8.25128922e-02],
[4.15160658e-02,2.72374191e-02,8.38198675e-02],
[4.22843419e-02,2.76281041e-02,8.51320555e-02],
[4.30599243e-02,2.80201673e-02,8.64492990e-02],
[4.38427905e-02,2.84135709e-02,8.77714421e-02],
[4.46329177e-02,2.88082776e-02,8.90983298e-02],
[4.54302823e-02,2.92042502e-02,9.04298084e-02],
[4.62348601e-02,2.96014517e-02,9.17657254e-02],
[4.70466263e-02,2.99998454e-02,9.31059296e-02],
[4.78655556e-02,3.03993949e-02,9.44502709e-02],
[4.86916219e-02,3.08000640e-02,9.57986006e-02],
[4.95247987e-02,3.12018167e-02,9.71507714e-02],
[5.03650589e-02,3.16046174e-02,9.85066371e-02],
[5.12123750e-02,3.20084307e-02,9.98660531e-02],
[5.20667186e-02,3.24132216e-02,1.01228876e-01],
[5.29280610e-02,3.28189550e-02,1.02594964e-01],
[5.37963731e-02,3.32255965e-02,1.03964176e-01],
[5.46716250e-02,3.36331119e-02,1.05336374e-01],
[5.55537865e-02,3.40414670e-02,1.06711420e-01],
[5.64428268e-02,3.44506282e-02,1.08089178e-01],
[5.73387147e-02,3.48605621e-02,1.09469512e-01],
[5.82414185e-02,3.52712356e-02,1.10852290e-01],
[5.91509059e-02,3.56826157e-02,1.12237381e-01],
[6.00671443e-02,3.60946700e-02,1.13624653e-01],
[6.09901007e-02,3.65073662e-02,1.15013978e-01],
[6.19197414e-02,3.69206723e-02,1.16405229e-01],
[6.28560326e-02,3.73345567e-02,1.17798281e-01],
[6.37989397e-02,3.77489881e-02,1.19193009e-01],
[6.47484281e-02,3.81639354e-02,1.20589290e-01],
[6.57044626e-02,3.85793678e-02,1.21987003e-01],
[6.66670074e-02,3.89952549e-02,1.23386029e-01],
[6.76360266e-02,3.94115665e-02,1.24786250e-01],
[6.86114838e-02,3.98282729e-02,1.26187550e-01],
[6.95933422e-02,4.02453443e-02,1.27589812e-01],
[7.05815648e-02,4.06627517e-02,1.28992925e-01],
[7.15761140e-02,4.10804661e-02,1.30396775e-01],
[7.25769521e-02,4.14984588e-02,1.31801253e-01],
[7.35840407e-02,4.19167014e-02,1.33206249e-01],
[7.45973415e-02,4.23351661e-02,1.34611657e-01],
[7.56168156e-02,4.27538250e-02,1.36017369e-01],
[7.66424238e-02,4.31726507e-02,1.37423283e-01],
[7.76741266e-02,4.35916161e-02,1.38829295e-01],
[7.87118842e-02,4.40106943e-02,1.40235304e-01],
[7.97556567e-02,4.44298589e-02,1.41641209e-01],
[8.08054035e-02,4.48490836e-02,1.43046913e-01],
[8.18610841e-02,4.52683425e-02,1.44452319e-01],
[8.29226575e-02,4.56876099e-02,1.45857330e-01],
[8.39900825e-02,4.61068605e-02,1.47261854e-01],
[8.50633176e-02,4.65260693e-02,1.48665797e-01],
[8.61423211e-02,4.69452115e-02,1.50069068e-01],
[8.72270511e-02,4.73642627e-02,1.51471578e-01],
[8.83174652e-02,4.77831987e-02,1.52873238e-01],
[8.94135211e-02,4.82019956e-02,1.54273961e-01],
[9.05151761e-02,4.86206299e-02,1.55673662e-01],
[9.16223871e-02,4.90390782e-02,1.57072257e-01],
[9.27351112e-02,4.94573176e-02,1.58469663e-01],
[9.38533049e-02,4.98753253e-02,1.59865799e-01],
[9.49769247e-02,5.02930789e-02,1.61260584e-01],
[9.61059268e-02,5.07105562e-02,1.62653940e-01],
[9.72402673e-02,5.11277353e-02,1.64045789e-01],
[9.83799021e-02,5.15445947e-02,1.65436056e-01],
[9.95247869e-02,5.19611131e-02,1.66824665e-01],
[1.00674877e-01,5.23772693e-02,1.68211544e-01],
[1.01830128e-01,5.27930426e-02,1.69596620e-01],
[1.02990495e-01,5.32084125e-02,1.70979822e-01],
[1.04155933e-01,5.36233587e-02,1.72361080e-01],
[1.05326397e-01,5.40378614e-02,1.73740326e-01],
[1.06501841e-01,5.44519008e-02,1.75117493e-01],
[1.07682221e-01,5.48654575e-02,1.76492515e-01],
[1.08867490e-01,5.52785123e-02,1.77865327e-01],
[1.10057604e-01,5.56910462e-02,1.79235866e-01],
[1.11252515e-01,5.61030408e-02,1.80604069e-01],
[1.12452179e-01,5.65144775e-02,1.81969874e-01],
[1.13656548e-01,5.69253383e-02,1.83333222e-01],
[1.14865578e-01,5.73356052e-02,1.84694054e-01],
[1.16079222e-01,5.77452606e-02,1.86052312e-01],
[1.17297433e-01,5.81542872e-02,1.87407939e-01],
[1.18520165e-01,5.85626678e-02,1.88760880e-01],
[1.19747372e-01,5.89703856e-02,1.90111079e-01],
[1.20979007e-01,5.93774238e-02,1.91458485e-01],
[1.22215023e-01,5.97837662e-02,1.92803043e-01],
[1.23455373e-01,6.01893965e-02,1.94144703e-01],
[1.24700011e-01,6.05942988e-02,1.95483415e-01],
[1.25948890e-01,6.09984575e-02,1.96819128e-01],
[1.27201963e-01,6.14018571e-02,1.98151796e-01],
[1.28459182e-01,6.18044823e-02,1.99481370e-01],
[1.29720502e-01,6.22063183e-02,2.00807804e-01],
[1.30985874e-01,6.26073502e-02,2.02131052e-01],
[1.32255252e-01,6.30075635e-02,2.03451072e-01],
[1.33528589e-01,6.34069439e-02,2.04767818e-01],
[1.34805837e-01,6.38054774e-02,2.06081248e-01],
[1.36086949e-01,6.42031500e-02,2.07391321e-01],
[1.37371878e-01,6.45999482e-02,2.08697997e-01],
[1.38660578e-01,6.49958585e-02,2.10001234e-01],
[1.39952999e-01,6.53908676e-02,2.11300995e-01],
[1.41249096e-01,6.57849627e-02,2.12597241e-01],
[1.42548821e-01,6.61781309e-02,2.13889934e-01],
[1.43852127e-01,6.65703596e-02,2.15179040e-01],
[1.45158967e-01,6.69616365e-02,2.16464521e-01],
[1.46469293e-01,6.73519495e-02,2.17746344e-01],
[1.47783058e-01,6.77412865e-02,2.19024474e-01],
[1.49100216e-01,6.81296357e-02,2.20298878e-01],
[1.50420718e-01,6.85169858e-02,2.21569525e-01],
[1.51744518e-01,6.89033252e-02,2.22836382e-01],
[1.53071569e-01,6.92886428e-02,2.24099418e-01],
[1.54401824e-01,6.96729277e-02,2.25358604e-01],
[1.55735235e-01,7.00561690e-02,2.26613910e-01],
[1.57071756e-01,7.04383563e-02,2.27865308e-01],
[1.58411340e-01,7.08194790e-02,2.29112770e-01],
[1.59753940e-01,7.11995271e-02,2.30356268e-01],
[1.61099509e-01,7.15784904e-02,2.31595777e-01],
[1.62448001e-01,7.19563591e-02,2.32831270e-01],
[1.63799368e-01,7.23331236e-02,2.34062722e-01],
[1.65153564e-01,7.27087744e-02,2.35290110e-01],
[1.66510543e-01,7.30833022e-02,2.36513408e-01],
[1.67870258e-01,7.34566978e-02,2.37732595e-01],
[1.69232663e-01,7.38289523e-02,2.38947647e-01],
[1.70597712e-01,7.42000570e-02,2.40158543e-01],
[1.71965357e-01,7.45700033e-02,2.41365261e-01],
[1.73335554e-01,7.49387826e-02,2.42567781e-01],
[1.74708256e-01,7.53063868e-02,2.43766083e-01],
[1.76083417e-01,7.56728077e-02,2.44960147e-01],
[1.77460991e-01,7.60380374e-02,2.46149954e-01],
[1.78840933e-01,7.64020681e-02,2.47335487e-01],
[1.80223197e-01,7.67648922e-02,2.48516726e-01],
[1.81607737e-01,7.71265023e-02,2.49693656e-01],
[1.82994508e-01,7.74868911e-02,2.50866258e-01],
[1.84383465e-01,7.78460514e-02,2.52034518e-01],
[1.85774563e-01,7.82039763e-02,2.53198420e-01],
[1.87167756e-01,7.85606589e-02,2.54357948e-01],
[1.88562999e-01,7.89160925e-02,2.55513087e-01],
[1.89960249e-01,7.92702707e-02,2.56663825e-01],
[1.91359459e-01,7.96231870e-02,2.57810146e-01],
[1.92760586e-01,7.99748352e-02,2.58952038e-01],
[1.94163585e-01,8.03252093e-02,2.60089488e-01],
[1.95568412e-01,8.06743033e-02,2.61222484e-01],
[1.96975023e-01,8.10221113e-02,2.62351015e-01],
[1.98383374e-01,8.13686279e-02,2.63475068e-01],
[1.99793420e-01,8.17138473e-02,2.64594633e-01],
[2.01205119e-01,8.20577644e-02,2.65709699e-01],
[2.02618426e-01,8.24003737e-02,2.66820257e-01],
[2.04033299e-01,8.27416703e-02,2.67926297e-01],
[2.05449694e-01,8.30816491e-02,2.69027809e-01],
[2.06867568e-01,8.34203054e-02,2.70124785e-01],
[2.08286878e-01,8.37576344e-02,2.71217217e-01],
[2.09707581e-01,8.40936315e-02,2.72305096e-01],
[2.11129636e-01,8.44282923e-02,2.73388414e-01],
[2.12552999e-01,8.47616126e-02,2.74467165e-01],
[2.13977627e-01,8.50935880e-02,2.75541342e-01],
[2.15403481e-01,8.54242146e-02,2.76610937e-01],
[2.16830516e-01,8.57534884e-02,2.77675945e-01],
[2.18258692e-01,8.60814056e-02,2.78736361e-01],
[2.19687967e-01,8.64079625e-02,2.79792177e-01],
[2.21118299e-01,8.67331555e-02,2.80843390e-01],
[2.22549648e-01,8.70569812e-02,2.81889994e-01],
[2.23981973e-01,8.73794362e-02,2.82931985e-01],
[2.25415232e-01,8.77005174e-02,2.83969358e-01],
[2.26849385e-01,8.80202215e-02,2.85002110e-01],
[2.28284392e-01,8.83385457e-02,2.86030238e-01],
[2.29720213e-01,8.86554870e-02,2.87053737e-01],
[2.31156807e-01,8.89710427e-02,2.88072605e-01],
[2.32594135e-01,8.92852101e-02,2.89086839e-01],
[2.34032156e-01,8.95979867e-02,2.90096437e-01],
[2.35470832e-01,8.99093701e-02,2.91101396e-01],
[2.36910124e-01,9.02193579e-02,2.92101715e-01],
[2.38349992e-01,9.05279479e-02,2.93097391e-01],
[2.39790397e-01,9.08351379e-02,2.94088425e-01],
[2.41231302e-01,9.11409261e-02,2.95074813e-01],
[2.42672666e-01,9.14453104e-02,2.96056556e-01],
[2.44114453e-01,9.17482890e-02,2.97033654e-01],
[2.45556624e-01,9.20498603e-02,2.98006104e-01],
[2.46999142e-01,9.23500227e-02,2.98973908e-01],
[2.48441969e-01,9.26487746e-02,2.99937066e-01],
[2.49885067e-01,9.29461147e-02,3.00895577e-01],
[2.51328400e-01,9.32420416e-02,3.01849443e-01],
[2.52771930e-01,9.35365541e-02,3.02798663e-01],
[2.54215621e-01,9.38296511e-02,3.03743240e-01],
[2.55659436e-01,9.41213316e-02,3.04683173e-01],
[2.57103340e-01,9.44115947e-02,3.05618466e-01],
[2.58547295e-01,9.47004395e-02,3.06549118e-01],
[2.59991267e-01,9.49878652e-02,3.07475132e-01],
[2.61435219e-01,9.52738713e-02,3.08396509e-01],
[2.62879116e-01,9.55584571e-02,3.09313253e-01],
[2.64322924e-01,9.58416222e-02,3.10225364e-01],
[2.65766607e-01,9.61233663e-02,3.11132846e-01],
[2.67210130e-01,9.64036889e-02,3.12035702e-01],
[2.68653459e-01,9.66825898e-02,3.12933933e-01],
[2.70096560e-01,9.69600691e-02,3.13827544e-01],
[2.71539399e-01,9.72361265e-02,3.14716536e-01],
[2.72981941e-01,9.75107623e-02,3.15600915e-01],
[2.74424154e-01,9.77839764e-02,3.16480682e-01],
[2.75866004e-01,9.80557691e-02,3.17355842e-01],
[2.77307458e-01,9.83261406e-02,3.18226398e-01],
[2.78748484e-01,9.85950915e-02,3.19092355e-01],
[2.80189047e-01,9.88626220e-02,3.19953716e-01],
[2.81629117e-01,9.91287328e-02,3.20810485e-01],
[2.83068661e-01,9.93934244e-02,3.21662667e-01],
[2.84507647e-01,9.96566975e-02,3.22510267e-01],
[2.85946043e-01,9.99185529e-02,3.23353289e-01],
[2.87383818e-01,1.00178991e-01,3.24191737e-01],
[2.88820941e-01,1.00438014e-01,3.25025616e-01],
[2.90257381e-01,1.00695622e-01,3.25854932e-01],
[2.91693107e-01,1.00951815e-01,3.26679690e-01],
[2.93128088e-01,1.01206596e-01,3.27499894e-01],
[2.94562294e-01,1.01459966e-01,3.28315550e-01],
[2.95995695e-01,1.01711925e-01,3.29126663e-01],
[2.97428262e-01,1.01962475e-01,3.29933239e-01],
[2.98859965e-01,1.02211618e-01,3.30735284e-01],
[3.00290774e-01,1.02459355e-01,3.31532803e-01],
[3.01720661e-01,1.02705687e-01,3.32325802e-01],
[3.03149596e-01,1.02950617e-01,3.33114286e-01],
[3.04577551e-01,1.03194145e-01,3.33898263e-01],
[3.06004498e-01,1.03436275e-01,3.34677737e-01],
[3.07430408e-01,1.03677006e-01,3.35452715e-01],
[3.08855254e-01,1.03916343e-01,3.36223204e-01],
[3.10279008e-01,1.04154285e-01,3.36989209e-01],
[3.11701642e-01,1.04390836e-01,3.37750738e-01],
[3.13123130e-01,1.04625998e-01,3.38507796e-01],
[3.14543444e-01,1.04859772e-01,3.39260390e-01],
[3.15962558e-01,1.05092162e-01,3.40008527e-01],
[3.17380445e-01,1.05323168e-01,3.40752213e-01],
[3.18797079e-01,1.05552794e-01,3.41491456e-01],
[3.20212435e-01,1.05781043e-01,3.42226262e-01],
[3.21626485e-01,1.06007915e-01,3.42956637e-01],
[3.23039205e-01,1.06233415e-01,3.43682590e-01],
[3.24450570e-01,1.06457544e-01,3.44404127e-01],
[3.25860554e-01,1.06680306e-01,3.45121255e-01],
[3.27269133e-01,1.06901703e-01,3.45833981e-01],
[3.28676282e-01,1.07121737e-01,3.46542312e-01],
[3.30081977e-01,1.07340413e-01,3.47246257e-01],
[3.31486193e-01,1.07557731e-01,3.47945821e-01],
[3.32888907e-01,1.07773697e-01,3.48641013e-01],
[3.34290096e-01,1.07988311e-01,3.49331839e-01],
[3.35689735e-01,1.08201579e-01,3.50018308e-01],
[3.37087801e-01,1.08413502e-01,3.50700426e-01],
[3.38484273e-01,1.08624084e-01,3.51378202e-01],
[3.39879126e-01,1.08833328e-01,3.52051642e-01],
[3.41272339e-01,1.09041238e-01,3.52720755e-01],
[3.42663889e-01,1.09247816e-01,3.53385548e-01],
[3.44053754e-01,1.09453066e-01,3.54046029e-01],
[3.45441913e-01,1.09656992e-01,3.54702206e-01],
[3.46828344e-01,1.09859598e-01,3.55354085e-01],
[3.48213025e-01,1.10060886e-01,3.56001676e-01],
[3.49595936e-01,1.10260860e-01,3.56644986e-01],
[3.50977055e-01,1.10459524e-01,3.57284023e-01],
[3.52356363e-01,1.10656882e-01,3.57918794e-01],
[3.53733838e-01,1.10852937e-01,3.58549308e-01],
[3.55109461e-01,1.11047694e-01,3.59175572e-01],
[3.56483211e-01,1.11241156e-01,3.59797595e-01],
[3.57855069e-01,1.11433326e-01,3.60415384e-01],
[3.59225015e-01,1.11624210e-01,3.61028947e-01],
[3.60593030e-01,1.11813811e-01,3.61638293e-01],
[3.61959095e-01,1.12002133e-01,3.62243430e-01],
[3.63323190e-01,1.12189180e-01,3.62844365e-01],
[3.64685299e-01,1.12374957e-01,3.63441107e-01],
[3.66045401e-01,1.12559467e-01,3.64033664e-01],
[3.67403479e-01,1.12742715e-01,3.64622043e-01],
[3.68759515e-01,1.12924705e-01,3.65206253e-01],
[3.70113491e-01,1.13105442e-01,3.65786303e-01],
[3.71465390e-01,1.13284929e-01,3.66362199e-01],
[3.72815194e-01,1.13463172e-01,3.66933951e-01],
[3.74162886e-01,1.13640175e-01,3.67501567e-01],
[3.75508450e-01,1.13815942e-01,3.68065054e-01],
[3.76851867e-01,1.13990478e-01,3.68624421e-01],
[3.78193124e-01,1.14163788e-01,3.69179676e-01],
[3.79532201e-01,1.14335876e-01,3.69730828e-01],
[3.80869085e-01,1.14506747e-01,3.70277884e-01],
[3.82203759e-01,1.14676405e-01,3.70820852e-01],
[3.83536207e-01,1.14844857e-01,3.71359742e-01],
[3.84866414e-01,1.15012105e-01,3.71894560e-01],
[3.86194365e-01,1.15178156e-01,3.72425316e-01],
[3.87520044e-01,1.15343014e-01,3.72952017e-01],
[3.88843437e-01,1.15506684e-01,3.73474672e-01],
[3.90164530e-01,1.15669172e-01,3.73993289e-01],
[3.91483308e-01,1.15830481e-01,3.74507876e-01],
[3.92799756e-01,1.15990618e-01,3.75018441e-01],
[3.94113861e-01,1.16149588e-01,3.75524992e-01],
[3.95425609e-01,1.16307395e-01,3.76027538e-01],
[3.96734986e-01,1.16464045e-01,3.76526087e-01],
[3.98041979e-01,1.16619543e-01,3.77020647e-01],
[3.99346575e-01,1.16773895e-01,3.77511227e-01],
[4.00648760e-01,1.16927105e-01,3.77997833e-01],
[4.01948522e-01,1.17079180e-01,3.78480475e-01],
[4.03245849e-01,1.17230124e-01,3.78959161e-01],
[4.04540727e-01,1.17379944e-01,3.79433898e-01],
[4.05833145e-01,1.17528644e-01,3.79904696e-01],
[4.07123090e-01,1.17676230e-01,3.80371561e-01],
[4.08410552e-01,1.17822708e-01,3.80834503e-01],
[4.09695517e-01,1.17968083e-01,3.81293529e-01],
[4.10977974e-01,1.18112361e-01,3.81748647e-01],
[4.12257913e-01,1.18255548e-01,3.82199866e-01],
[4.13535321e-01,1.18397649e-01,3.82647193e-01],
[4.14810189e-01,1.18538671e-01,3.83090637e-01],
[4.16082505e-01,1.18678618e-01,3.83530206e-01],
[4.17352259e-01,1.18817497e-01,3.83965907e-01],
[4.18619441e-01,1.18955314e-01,3.84397748e-01],
[4.19884039e-01,1.19092075e-01,3.84825739e-01],
[4.21146045e-01,1.19227785e-01,3.85249886e-01],
[4.22405448e-01,1.19362451e-01,3.85670197e-01],
[4.23662238e-01,1.19496079e-01,3.86086681e-01],
[4.24916407e-01,1.19628674e-01,3.86499345e-01],
[4.26167944e-01,1.19760243e-01,3.86908198e-01],
[4.27416840e-01,1.19890792e-01,3.87313247e-01],
[4.28663088e-01,1.20020327e-01,3.87714501e-01],
[4.29906677e-01,1.20148854e-01,3.88111966e-01],
[4.31147599e-01,1.20276380e-01,3.88505651e-01],
[4.32385845e-01,1.20402910e-01,3.88895563e-01],
[4.33621408e-01,1.20528452e-01,3.89281711e-01],
[4.34854279e-01,1.20653011e-01,3.89664103e-01],
[4.36084449e-01,1.20776594e-01,3.90042745e-01],
[4.37311913e-01,1.20899208e-01,3.90417646e-01],
[4.38536660e-01,1.21020857e-01,3.90788814e-01],
[4.39758685e-01,1.21141551e-01,3.91156256e-01],
[4.40977979e-01,1.21261293e-01,3.91519980e-01],
[4.42194536e-01,1.21380092e-01,3.91879993e-01],
[4.43408348e-01,1.21497954e-01,3.92236303e-01],
[4.44619408e-01,1.21614885e-01,3.92588918e-01],
[4.45827710e-01,1.21730893e-01,3.92937846e-01],
[4.47033248e-01,1.21845983e-01,3.93283093e-01],
[4.48236014e-01,1.21960162e-01,3.93624668e-01],
[4.49436003e-01,1.22073438e-01,3.93962578e-01],
[4.50633208e-01,1.22185816e-01,3.94296831e-01],
[4.51827624e-01,1.22297305e-01,3.94627433e-01],
[4.53019244e-01,1.22407909e-01,3.94954393e-01],
[4.54208062e-01,1.22517638e-01,3.95277718e-01],
[4.55394075e-01,1.22626496e-01,3.95597416e-01],
[4.56577275e-01,1.22734492e-01,3.95913493e-01],
[4.57757657e-01,1.22841633e-01,3.96225957e-01],
[4.58935217e-01,1.22947924e-01,3.96534815e-01],
[4.60109950e-01,1.23053374e-01,3.96840075e-01],
[4.61281851e-01,1.23157989e-01,3.97141744e-01],
[4.62450914e-01,1.23261776e-01,3.97439830e-01],
[4.63617136e-01,1.23364743e-01,3.97734339e-01],
[4.64780512e-01,1.23466897e-01,3.98025278e-01],
[4.65941038e-01,1.23568244e-01,3.98312656e-01],
[4.67098709e-01,1.23668792e-01,3.98596479e-01],
[4.68253522e-01,1.23768549e-01,3.98876754e-01],
[4.69405472e-01,1.23867521e-01,3.99153488e-01],
[4.70554556e-01,1.23965716e-01,3.99426689e-01],
[4.71700771e-01,1.24063141e-01,3.99696363e-01],
[4.72844112e-01,1.24159804e-01,3.99962518e-01],
[4.73984576e-01,1.24255711e-01,4.00225160e-01],
[4.75122161e-01,1.24350871e-01,4.00484297e-01],
[4.76256863e-01,1.24445290e-01,4.00739935e-01],
[4.77388678e-01,1.24538976e-01,4.00992082e-01],
[4.78517605e-01,1.24631937e-01,4.01240744e-01],
[4.79643640e-01,1.24724181e-01,4.01485928e-01],
[4.80766780e-01,1.24815714e-01,4.01727641e-01],
[4.81887024e-01,1.24906544e-01,4.01965890e-01],
[4.83004369e-01,1.24996679e-01,4.02200682e-01],
[4.84118811e-01,1.25086126e-01,4.02432024e-01],
[4.85230350e-01,1.25174894e-01,4.02659921e-01],
[4.86338984e-01,1.25262990e-01,4.02884382e-01],
[4.87444709e-01,1.25350421e-01,4.03105412e-01],
[4.88547525e-01,1.25437195e-01,4.03323019e-01],
[4.89647429e-01,1.25523321e-01,4.03537208e-01],
[4.90744421e-01,1.25608805e-01,4.03747987e-01],
[4.91838498e-01,1.25693656e-01,4.03955362e-01],
[4.92929659e-01,1.25777882e-01,4.04159340e-01],
[4.94017903e-01,1.25861490e-01,4.04359928e-01],
[4.95103228e-01,1.25944488e-01,4.04557131e-01],
[4.96185634e-01,1.26026885e-01,4.04750956e-01],
[4.97265120e-01,1.26108687e-01,4.04941410e-01],
[4.98341685e-01,1.26189904e-01,4.05128499e-01],
[4.99415327e-01,1.26270543e-01,4.05312230e-01],
[5.00486046e-01,1.26350612e-01,4.05492609e-01],
[5.01553843e-01,1.26430119e-01,4.05669642e-01],
[5.02618715e-01,1.26509073e-01,4.05843336e-01],
[5.03680663e-01,1.26587481e-01,4.06013697e-01],
[5.04739687e-01,1.26665351e-01,4.06180731e-01],
[5.05795786e-01,1.26742692e-01,4.06344444e-01],
[5.06848961e-01,1.26819512e-01,4.06504843e-01],
[5.07899210e-01,1.26895819e-01,4.06661934e-01],
[5.08946535e-01,1.26971622e-01,4.06815723e-01],
[5.09990936e-01,1.27046927e-01,4.06966217e-01],
[5.11032412e-01,1.27121745e-01,4.07113420e-01],
[5.12070964e-01,1.27196083e-01,4.07257341e-01],
[5.13106593e-01,1.27269949e-01,4.07397983e-01],
[5.14139299e-01,1.27343352e-01,4.07535354e-01],
[5.15169083e-01,1.27416299e-01,4.07669460e-01],
[5.16195945e-01,1.27488801e-01,4.07800307e-01],
[5.17219887e-01,1.27560864e-01,4.07927900e-01],
[5.18240909e-01,1.27632498e-01,4.08052245e-01],
[5.19259012e-01,1.27703710e-01,4.08173349e-01],
[5.20274197e-01,1.27774510e-01,4.08291217e-01],
[5.21286465e-01,1.27844906e-01,4.08405855e-01],
[5.22295818e-01,1.27914906e-01,4.08517269e-01],
[5.23302257e-01,1.27984518e-01,4.08625466e-01],
[5.24305783e-01,1.28053753e-01,4.08730449e-01],
[5.25306397e-01,1.28122617e-01,4.08832226e-01],
[5.26304101e-01,1.28191120e-01,4.08930803e-01],
[5.27298897e-01,1.28259270e-01,4.09026184e-01],
[5.28290787e-01,1.28327077e-01,4.09118375e-01],
[5.29279771e-01,1.28394548e-01,4.09207383e-01],
[5.30265853e-01,1.28461692e-01,4.09293213e-01],
[5.31249033e-01,1.28528518e-01,4.09375870e-01],
[5.32229314e-01,1.28595036e-01,4.09455361e-01],
[5.33206698e-01,1.28661252e-01,4.09531690e-01],
[5.34181186e-01,1.28727178e-01,4.09604863e-01],
[5.35152782e-01,1.28792820e-01,4.09674886e-01],
[5.36121487e-01,1.28858188e-01,4.09741765e-01],
[5.37087303e-01,1.28923292e-01,4.09805504e-01],
[5.38050233e-01,1.28988139e-01,4.09866109e-01],
[5.39010279e-01,1.29052738e-01,4.09923586e-01],
[5.39967445e-01,1.29117100e-01,4.09977940e-01],
[5.40921731e-01,1.29181232e-01,4.10029177e-01],
[5.41873142e-01,1.29245143e-01,4.10077301e-01],
[5.42821679e-01,1.29308842e-01,4.10122319e-01],
[5.43767346e-01,1.29372339e-01,4.10164235e-01],
[5.44710145e-01,1.29435643e-01,4.10203055e-01],
[5.45650079e-01,1.29498762e-01,4.10238784e-01],
[5.46587150e-01,1.29561705e-01,4.10271428e-01],
[5.47521363e-01,1.29624482e-01,4.10300991e-01],
[5.48452720e-01,1.29687102e-01,4.10327479e-01],
[5.49381224e-01,1.29749573e-01,4.10350897e-01],
[5.50306878e-01,1.29811906e-01,4.10371250e-01],
[5.51229685e-01,1.29874108e-01,4.10388544e-01],
[5.52149649e-01,1.29936190e-01,4.10402783e-01],
[5.53066773e-01,1.29998159e-01,4.10413972e-01],
[5.53981060e-01,1.30060027e-01,4.10422118e-01],
[5.54892514e-01,1.30121801e-01,4.10427224e-01],
[5.55801138e-01,1.30183492e-01,4.10429296e-01],
[5.56706936e-01,1.30245107e-01,4.10428339e-01],
[5.57609911e-01,1.30306657e-01,4.10424358e-01],
[5.58510066e-01,1.30368151e-01,4.10417358e-01],
[5.59407407e-01,1.30429599e-01,4.10407344e-01],
[5.60301935e-01,1.30491008e-01,4.10394321e-01],
[5.61193655e-01,1.30552390e-01,4.10378293e-01],
[5.62082571e-01,1.30613752e-01,4.10359266e-01],
[5.62968687e-01,1.30675105e-01,4.10337245e-01],
[5.63852006e-01,1.30736459e-01,4.10312235e-01],
[5.64732533e-01,1.30797821e-01,4.10284239e-01],
[5.65610270e-01,1.30859202e-01,4.10253264e-01],
[5.66485223e-01,1.30920611e-01,4.10219314e-01],
[5.67357396e-01,1.30982058e-01,4.10182394e-01],
[5.68226792e-01,1.31043552e-01,4.10142509e-01],
[5.69093415e-01,1.31105103e-01,4.10099663e-01],
[5.69957271e-01,1.31166720e-01,4.10053861e-01],
[5.70818362e-01,1.31228412e-01,4.10005109e-01],
[5.71676694e-01,1.31290190e-01,4.09953410e-01],
[5.72532270e-01,1.31352062e-01,4.09898769e-01],
[5.73385096e-01,1.31414039e-01,4.09841192e-01],
[5.74235174e-01,1.31476129e-01,4.09780682e-01],
[5.75082510e-01,1.31538343e-01,4.09717245e-01],
[5.75927108e-01,1.31600689e-01,4.09650885e-01],
[5.76768973e-01,1.31663179e-01,4.09581607e-01],
[5.77608109e-01,1.31725820e-01,4.09509415e-01],
[5.78444520e-01,1.31788624e-01,4.09434314e-01],
[5.79278212e-01,1.31851599e-01,4.09356309e-01],
[5.80109188e-01,1.31914756e-01,4.09275404e-01],
[5.80937454e-01,1.31978103e-01,4.09191604e-01],
[5.81763014e-01,1.32041651e-01,4.09104913e-01],
[5.82585873e-01,1.32105409e-01,4.09015336e-01],
[5.83406035e-01,1.32169388e-01,4.08922877e-01],
[5.84223506e-01,1.32233596e-01,4.08827541e-01],
[5.85038289e-01,1.32298044e-01,4.08729333e-01],
[5.85850391e-01,1.32362741e-01,4.08628256e-01],
[5.86659815e-01,1.32427698e-01,4.08524316e-01],
[5.87466567e-01,1.32492923e-01,4.08417517e-01],
[5.88270651e-01,1.32558427e-01,4.08307863e-01],
[5.89072073e-01,1.32624220e-01,4.08195358e-01],
[5.89870837e-01,1.32690311e-01,4.08080008e-01],
[5.90666948e-01,1.32756710e-01,4.07961816e-01],
[5.91460412e-01,1.32823427e-01,4.07840787e-01],
[5.92251233e-01,1.32890472e-01,4.07716925e-01],
[5.93039416e-01,1.32957855e-01,4.07590236e-01],
[5.93824967e-01,1.33025586e-01,4.07460722e-01],
[5.94607891e-01,1.33093674e-01,4.07328389e-01],
[5.95388192e-01,1.33162130e-01,4.07193240e-01],
[5.96165876e-01,1.33230963e-01,4.07055281e-01],
[5.96940949e-01,1.33300183e-01,4.06914515e-01],
[5.97713414e-01,1.33369801e-01,4.06770947e-01],
[5.98483278e-01,1.33439826e-01,4.06624581e-01],
[5.99250545e-01,1.33510268e-01,4.06475422e-01],
[6.00015221e-01,1.33581137e-01,4.06323473e-01],
[6.00777312e-01,1.33652443e-01,4.06168739e-01],
[6.01536821e-01,1.33724196e-01,4.06011225e-01],
[6.02293756e-01,1.33796407e-01,4.05850934e-01],
[6.03048120e-01,1.33869084e-01,4.05687871e-01],
[6.03799920e-01,1.33942239e-01,4.05522040e-01],
[6.04549160e-01,1.34015880e-01,4.05353446e-01],
[6.05295847e-01,1.34090019e-01,4.05182092e-01],
[6.06039985e-01,1.34164665e-01,4.05007983e-01],
[6.06781579e-01,1.34239828e-01,4.04831123e-01],
[6.07520636e-01,1.34315519e-01,4.04651516e-01],
[6.08257161e-01,1.34391746e-01,4.04469167e-01],
[6.08991159e-01,1.34468521e-01,4.04284080e-01],
[6.09722635e-01,1.34545854e-01,4.04096258e-01],
[6.10451595e-01,1.34623754e-01,4.03905707e-01],
[6.11178045e-01,1.34702232e-01,4.03712430e-01],
[6.11901990e-01,1.34781297e-01,4.03516432e-01],
[6.12623435e-01,1.34860960e-01,4.03317717e-01],
[6.13342387e-01,1.34941231e-01,4.03116288e-01],
[6.14058850e-01,1.35022120e-01,4.02912151e-01],
[6.14772830e-01,1.35103638e-01,4.02705309e-01],
[6.15484333e-01,1.35185793e-01,4.02495767e-01],
[6.16193364e-01,1.35268597e-01,4.02283528e-01],
[6.16899928e-01,1.35352060e-01,4.02068597e-01],
[6.17604033e-01,1.35436191e-01,4.01850979e-01],
[6.18305682e-01,1.35521001e-01,4.01630676e-01],
[6.19004881e-01,1.35606500e-01,4.01407694e-01],
[6.19701637e-01,1.35692699e-01,4.01182036e-01],
[6.20395955e-01,1.35779606e-01,4.00953707e-01],
[6.21087840e-01,1.35867233e-01,4.00722712e-01],
[6.21777298e-01,1.35955590e-01,4.00489053e-01],
[6.22464335e-01,1.36044686e-01,4.00252735e-01],
[6.23148957e-01,1.36134533e-01,4.00013763e-01],
[6.23831168e-01,1.36225139e-01,3.99772140e-01],
[6.24510975e-01,1.36316516e-01,3.99527871e-01],
[6.25188383e-01,1.36408673e-01,3.99280960e-01],
[6.25863398e-01,1.36501621e-01,3.99031411e-01],
[6.26536026e-01,1.36595370e-01,3.98779229e-01],
[6.27206273e-01,1.36689930e-01,3.98524416e-01],
[6.27874143e-01,1.36785312e-01,3.98266979e-01],
[6.28539644e-01,1.36881524e-01,3.98006920e-01],
[6.29202779e-01,1.36978579e-01,3.97744244e-01],
[6.29863556e-01,1.37076485e-01,3.97478955e-01],
[6.30521980e-01,1.37175254e-01,3.97211058e-01],
[6.31178056e-01,1.37274894e-01,3.96940556e-01],
[6.31831791e-01,1.37375417e-01,3.96667453e-01],
[6.32483189e-01,1.37476833e-01,3.96391755e-01],
[6.33132258e-01,1.37579151e-01,3.96113465e-01],
[6.33779001e-01,1.37682383e-01,3.95832587e-01],
[6.34423426e-01,1.37786538e-01,3.95549125e-01],
[6.35065538e-01,1.37891626e-01,3.95263084e-01],
[6.35705343e-01,1.37997658e-01,3.94974468e-01],
[6.36342845e-01,1.38104644e-01,3.94683282e-01],
[6.36978052e-01,1.38212594e-01,3.94389528e-01],
[6.37610969e-01,1.38321518e-01,3.94093213e-01],
[6.38241601e-01,1.38431426e-01,3.93794339e-01],
[6.38869954e-01,1.38542329e-01,3.93492911e-01],
[6.39496035e-01,1.38654237e-01,3.93188934e-01],
[6.40119848e-01,1.38767160e-01,3.92882411e-01],
[6.40741399e-01,1.38881108e-01,3.92573348e-01],
[6.41360695e-01,1.38996092e-01,3.92261747e-01],
[6.41977741e-01,1.39112121e-01,3.91947614e-01],
[6.42592542e-01,1.39229205e-01,3.91630953e-01],
[6.43205104e-01,1.39347356e-01,3.91311767e-01],
[6.43815434e-01,1.39466582e-01,3.90990063e-01],
[6.44423536e-01,1.39586895e-01,3.90665843e-01],
[6.45029417e-01,1.39708304e-01,3.90339111e-01],
[6.45633082e-01,1.39830820e-01,3.90009874e-01],
[6.46234537e-01,1.39954452e-01,3.89678134e-01],
[6.46833788e-01,1.40079211e-01,3.89343896e-01],
[6.47430840e-01,1.40205107e-01,3.89007165e-01],
[6.48025699e-01,1.40332150e-01,3.88667945e-01],
[6.48618371e-01,1.40460350e-01,3.88326239e-01],
[6.49208861e-01,1.40589717e-01,3.87982054e-01],
[6.49797176e-01,1.40720262e-01,3.87635393e-01],
[6.50383320e-01,1.40851994e-01,3.87286260e-01],
[6.50967300e-01,1.40984924e-01,3.86934660e-01],
[6.51549121e-01,1.41119062e-01,3.86580598e-01],
[6.52128788e-01,1.41254417e-01,3.86224077e-01],
[6.52706309e-01,1.41391000e-01,3.85865103e-01],
[6.53281688e-01,1.41528821e-01,3.85503680e-01],
[6.53854930e-01,1.41667890e-01,3.85139813e-01],
[6.54426042e-01,1.41808216e-01,3.84773505e-01],
[6.54995029e-01,1.41949811e-01,3.84404761e-01],
[6.55561898e-01,1.42092684e-01,3.84033587e-01],
[6.56126652e-01,1.42236844e-01,3.83659987e-01],
[6.56689299e-01,1.42382303e-01,3.83283964e-01],
[6.57249844e-01,1.42529069e-01,3.82905525e-01],
[6.57808291e-01,1.42677154e-01,3.82524672e-01],
[6.58364648e-01,1.42826567e-01,3.82141412e-01],
[6.58918920e-01,1.42977317e-01,3.81755749e-01],
[6.59471111e-01,1.43129415e-01,3.81367687e-01],
[6.60021229e-01,1.43282871e-01,3.80977231e-01],
[6.60569278e-01,1.43437695e-01,3.80584385e-01],
[6.61115264e-01,1.43593896e-01,3.80189156e-01],
[6.61659192e-01,1.43751484e-01,3.79791546e-01],
[6.62201069e-01,1.43910470e-01,3.79391562e-01],
[6.62740899e-01,1.44070863e-01,3.78989207e-01],
[6.63278688e-01,1.44232673e-01,3.78584487e-01],
[6.63814443e-01,1.44395910e-01,3.78177406e-01],
[6.64348167e-01,1.44560584e-01,3.77767970e-01],
[6.64879868e-01,1.44726704e-01,3.77356182e-01],
[6.65409550e-01,1.44894280e-01,3.76942049e-01],
[6.65937218e-01,1.45063322e-01,3.76525574e-01],
[6.66462880e-01,1.45233840e-01,3.76106764e-01],
[6.66986539e-01,1.45405843e-01,3.75685621e-01],
[6.67508201e-01,1.45579341e-01,3.75262153e-01],
[6.68027872e-01,1.45754345e-01,3.74836363e-01],
[6.68545558e-01,1.45930862e-01,3.74408257e-01],
[6.69061263e-01,1.46108904e-01,3.73977840e-01],
[6.69574994e-01,1.46288480e-01,3.73545116e-01],
[6.70086756e-01,1.46469599e-01,3.73110091e-01],
[6.70596553e-01,1.46652271e-01,3.72672770e-01],
[6.71104392e-01,1.46836506e-01,3.72233158e-01],
[6.71610278e-01,1.47022313e-01,3.71791261e-01],
[6.72114217e-01,1.47209701e-01,3.71347082e-01],
[6.72616213e-01,1.47398681e-01,3.70900628e-01],
[6.73116272e-01,1.47589261e-01,3.70451904e-01],
[6.73614400e-01,1.47781451e-01,3.70000915e-01],
[6.74110602e-01,1.47975261e-01,3.69547666e-01],
[6.74604883e-01,1.48170700e-01,3.69092163e-01],
[6.75097248e-01,1.48367777e-01,3.68634410e-01],
[6.75587704e-01,1.48566501e-01,3.68174414e-01],
[6.76076255e-01,1.48766883e-01,3.67712179e-01],
[6.76562906e-01,1.48968931e-01,3.67247712e-01],
[6.77047663e-01,1.49172655e-01,3.66781016e-01],
[6.77530532e-01,1.49378063e-01,3.66312099e-01],
[6.78011517e-01,1.49585166e-01,3.65840965e-01],
[6.78490624e-01,1.49793971e-01,3.65367619e-01],
[6.78967857e-01,1.50004490e-01,3.64892069e-01],
[6.79443223e-01,1.50216730e-01,3.64414318e-01],
[6.79916726e-01,1.50430700e-01,3.63934372e-01],
[6.80388372e-01,1.50646411e-01,3.63452238e-01],
[6.80858166e-01,1.50863870e-01,3.62967920e-01],
[6.81326114e-01,1.51083087e-01,3.62481425e-01],
[6.81792219e-01,1.51304071e-01,3.61992758e-01],
[6.82256488e-01,1.51526831e-01,3.61501925e-01],
[6.82718926e-01,1.51751376e-01,3.61008932e-01],
[6.83179537e-01,1.51977714e-01,3.60513784e-01],
[6.83638328e-01,1.52205855e-01,3.60016488e-01],
[6.84095302e-01,1.52435807e-01,3.59517049e-01],
[6.84550466e-01,1.52667580e-01,3.59015472e-01],
[6.85003824e-01,1.52901181e-01,3.58511765e-01],
[6.85455382e-01,1.53136620e-01,3.58005933e-01],
[6.85905144e-01,1.53373905e-01,3.57497982e-01],
[6.86353116e-01,1.53613046e-01,3.56987917e-01],
[6.86799302e-01,1.53854050e-01,3.56475746e-01],
[6.87243709e-01,1.54096926e-01,3.55961474e-01],
[6.87686340e-01,1.54341683e-01,3.55445107e-01],
[6.88127200e-01,1.54588329e-01,3.54926652e-01],
[6.88566296e-01,1.54836873e-01,3.54406114e-01],
[6.89003632e-01,1.55087322e-01,3.53883500e-01],
[6.89439212e-01,1.55339687e-01,3.53358816e-01],
[6.89873042e-01,1.55593974e-01,3.52832068e-01],
[6.90305127e-01,1.55850193e-01,3.52303263e-01],
[6.90735472e-01,1.56108350e-01,3.51772407e-01],
[6.91164081e-01,1.56368456e-01,3.51239507e-01],
[6.91590960e-01,1.56630517e-01,3.50704568e-01],
[6.92016113e-01,1.56894542e-01,3.50167598e-01],
[6.92439546e-01,1.57160540e-01,3.49628603e-01],
[6.92861263e-01,1.57428517e-01,3.49087589e-01],
[6.93281269e-01,1.57698482e-01,3.48544563e-01],
[6.93699570e-01,1.57970443e-01,3.47999532e-01],
[6.94116169e-01,1.58244409e-01,3.47452502e-01],
[6.94531072e-01,1.58520386e-01,3.46903479e-01],
[6.94944284e-01,1.58798382e-01,3.46352472e-01],
[6.95355809e-01,1.59078406e-01,3.45799486e-01],
[6.95765652e-01,1.59360465e-01,3.45244528e-01],
[6.96173818e-01,1.59644566e-01,3.44687605e-01],
[6.96580312e-01,1.59930718e-01,3.44128725e-01],
[6.96985138e-01,1.60218928e-01,3.43567893e-01],
[6.97388302e-01,1.60509203e-01,3.43005117e-01],
[6.97789807e-01,1.60801551e-01,3.42440403e-01],
[6.98189660e-01,1.61095979e-01,3.41873760e-01],
[6.98587864e-01,1.61392494e-01,3.41305194e-01],
[6.98984423e-01,1.61691105e-01,3.40734711e-01],
[6.99379344e-01,1.61991817e-01,3.40162320e-01],
[6.99772630e-01,1.62294639e-01,3.39588028e-01],
[7.00164287e-01,1.62599578e-01,3.39011841e-01],
[7.00554318e-01,1.62906639e-01,3.38433767e-01],
[7.00942728e-01,1.63215832e-01,3.37853813e-01],
[7.01329523e-01,1.63527161e-01,3.37271987e-01],
[7.01714706e-01,1.63840635e-01,3.36688295e-01],
[7.02098282e-01,1.64156260e-01,3.36102747e-01],
[7.02480257e-01,1.64474043e-01,3.35515348e-01],
[7.02860633e-01,1.64793991e-01,3.34926107e-01],
[7.03239417e-01,1.65116110e-01,3.34335030e-01],
[7.03616612e-01,1.65440407e-01,3.33742127e-01],
[7.03992222e-01,1.65766889e-01,3.33147404e-01],
[7.04366254e-01,1.66095561e-01,3.32550868e-01],
[7.04738710e-01,1.66426431e-01,3.31952529e-01],
[7.05109596e-01,1.66759504e-01,3.31352393e-01],
[7.05478916e-01,1.67094787e-01,3.30750469e-01],
[7.05846674e-01,1.67432287e-01,3.30146763e-01],
[7.06212875e-01,1.67772009e-01,3.29541285e-01],
[7.06577523e-01,1.68113959e-01,3.28934042e-01],
[7.06940623e-01,1.68458143e-01,3.28325042e-01],
[7.07302179e-01,1.68804568e-01,3.27714293e-01],
[7.07662195e-01,1.69153239e-01,3.27101804e-01],
[7.08020677e-01,1.69504162e-01,3.26487582e-01],
[7.08377627e-01,1.69857342e-01,3.25871635e-01],
[7.08733051e-01,1.70212786e-01,3.25253973e-01],
[7.09086953e-01,1.70570499e-01,3.24634602e-01],
[7.09439337e-01,1.70930487e-01,3.24013532e-01],
[7.09790208e-01,1.71292754e-01,3.23390770e-01],
[7.10139570e-01,1.71657307e-01,3.22766326e-01],
[7.10487426e-01,1.72024150e-01,3.22140207e-01],
[7.10833782e-01,1.72393289e-01,3.21512422e-01],
[7.11178642e-01,1.72764728e-01,3.20882980e-01],
[7.11522009e-01,1.73138474e-01,3.20251889e-01],
[7.11863888e-01,1.73514531e-01,3.19619158e-01],
[7.12204284e-01,1.73892904e-01,3.18984796e-01],
[7.12543200e-01,1.74273598e-01,3.18348811e-01],
[7.12880641e-01,1.74656617e-01,3.17711212e-01],
[7.13216611e-01,1.75041966e-01,3.17072007e-01],
[7.13551114e-01,1.75429650e-01,3.16431207e-01],
[7.13884154e-01,1.75819673e-01,3.15788819e-01],
[7.14215735e-01,1.76212040e-01,3.15144853e-01],
[7.14545862e-01,1.76606755e-01,3.14499317e-01],
[7.14874538e-01,1.77003822e-01,3.13852221e-01],
[7.15201768e-01,1.77403246e-01,3.13203574e-01],
[7.15527555e-01,1.77805030e-01,3.12553385e-01],
[7.15851904e-01,1.78209179e-01,3.11901663e-01],
[7.16174819e-01,1.78615697e-01,3.11248417e-01],
[7.16496304e-01,1.79024587e-01,3.10593657e-01],
[7.16816363e-01,1.79435853e-01,3.09937392e-01],
[7.17134999e-01,1.79849499e-01,3.09279631e-01],
[7.17452218e-01,1.80265529e-01,3.08620384e-01],
[7.17768022e-01,1.80683945e-01,3.07959660e-01],
[7.18082416e-01,1.81104752e-01,3.07297470e-01],
[7.18395404e-01,1.81527953e-01,3.06633821e-01],
[7.18706989e-01,1.81953550e-01,3.05968725e-01],
[7.19017176e-01,1.82381547e-01,3.05302190e-01],
[7.19325969e-01,1.82811948e-01,3.04634227e-01],
[7.19633371e-01,1.83244754e-01,3.03964845e-01],
[7.19939387e-01,1.83679970e-01,3.03294054e-01],
[7.20244020e-01,1.84117597e-01,3.02621864e-01],
[7.20547274e-01,1.84557638e-01,3.01948284e-01],
[7.20849152e-01,1.85000096e-01,3.01273326e-01],
[7.21149660e-01,1.85444974e-01,3.00596998e-01],
[7.21448800e-01,1.85892274e-01,2.99919311e-01],
[7.21746577e-01,1.86341997e-01,2.99240275e-01],
[7.22042994e-01,1.86794147e-01,2.98559900e-01],
[7.22338055e-01,1.87248726e-01,2.97878196e-01],
[7.22631764e-01,1.87705734e-01,2.97195174e-01],
[7.22924124e-01,1.88165175e-01,2.96510843e-01],
[7.23215139e-01,1.88627051e-01,2.95825215e-01],
[7.23504814e-01,1.89091362e-01,2.95138299e-01],
[7.23793151e-01,1.89558110e-01,2.94450107e-01],
[7.24080155e-01,1.90027298e-01,2.93760648e-01],
[7.24365829e-01,1.90498926e-01,2.93069933e-01],
[7.24650176e-01,1.90972995e-01,2.92377972e-01],
[7.24933201e-01,1.91449508e-01,2.91684777e-01],
[7.25214907e-01,1.91928465e-01,2.90990358e-01],
[7.25495298e-01,1.92409866e-01,2.90294725e-01],
[7.25774378e-01,1.92893714e-01,2.89597890e-01],
[7.26052149e-01,1.93380009e-01,2.88899864e-01],
[7.26328616e-01,1.93868750e-01,2.88200656e-01],
[7.26603782e-01,1.94359940e-01,2.87500278e-01],
[7.26877651e-01,1.94853579e-01,2.86798742e-01],
[7.27150226e-01,1.95349667e-01,2.86096057e-01],
[7.27421512e-01,1.95848203e-01,2.85392236e-01],
[7.27691510e-01,1.96349189e-01,2.84687289e-01],
[7.27960226e-01,1.96852625e-01,2.83981227e-01],
[7.28227662e-01,1.97358510e-01,2.83274062e-01],
[7.28493821e-01,1.97866845e-01,2.82565805e-01],
[7.28758709e-01,1.98377628e-01,2.81856467e-01],
[7.29022327e-01,1.98890861e-01,2.81146059e-01],
[7.29284680e-01,1.99406541e-01,2.80434593e-01],
[7.29545770e-01,1.99924670e-01,2.79722081e-01],
[7.29805602e-01,2.00445245e-01,2.79008533e-01],
[7.30064178e-01,2.00968266e-01,2.78293961e-01],
[7.30321503e-01,2.01493733e-01,2.77578378e-01],
[7.30577579e-01,2.02021645e-01,2.76861794e-01],
[7.30832410e-01,2.02551999e-01,2.76144221e-01],
[7.31085999e-01,2.03084796e-01,2.75425671e-01],
[7.31338349e-01,2.03620033e-01,2.74706155e-01],
[7.31589465e-01,2.04157710e-01,2.73985687e-01],
[7.31839349e-01,2.04697824e-01,2.73264276e-01],
[7.32088005e-01,2.05240375e-01,2.72541935e-01],
[7.32335435e-01,2.05785360e-01,2.71818677e-01],
[7.32581644e-01,2.06332777e-01,2.71094512e-01],
[7.32826634e-01,2.06882625e-01,2.70369454e-01],
[7.33070409e-01,2.07434901e-01,2.69643514e-01],
[7.33312972e-01,2.07989603e-01,2.68916704e-01],
[7.33554326e-01,2.08546729e-01,2.68189037e-01],
[7.33794475e-01,2.09106277e-01,2.67460524e-01],
[7.34033421e-01,2.09668243e-01,2.66731178e-01],
[7.34271169e-01,2.10232626e-01,2.66001011e-01],
[7.34507721e-01,2.10799422e-01,2.65270036e-01],
[7.34743080e-01,2.11368628e-01,2.64538264e-01],
[7.34977249e-01,2.11940242e-01,2.63805709e-01],
[7.35210232e-01,2.12514261e-01,2.63072382e-01],
[7.35442033e-01,2.13090681e-01,2.62338297e-01],
[7.35672653e-01,2.13669499e-01,2.61603465e-01],
[7.35902096e-01,2.14250711e-01,2.60867900e-01],
[7.36130365e-01,2.14834315e-01,2.60131613e-01],
[7.36357464e-01,2.15420305e-01,2.59394618e-01],
[7.36583395e-01,2.16008679e-01,2.58656927e-01],
[7.36808162e-01,2.16599433e-01,2.57918553e-01],
[7.37031767e-01,2.17192563e-01,2.57179509e-01],
[7.37254214e-01,2.17788064e-01,2.56439807e-01],
[7.37475505e-01,2.18385932e-01,2.55699460e-01],
[7.37695644e-01,2.18986164e-01,2.54958482e-01],
[7.37914634e-01,2.19588754e-01,2.54216885e-01],
[7.38132478e-01,2.20193698e-01,2.53474682e-01],
[7.38349178e-01,2.20800991e-01,2.52731887e-01],
[7.38564738e-01,2.21410629e-01,2.51988511e-01],
[7.38779161e-01,2.22022607e-01,2.51244569e-01],
[7.38992450e-01,2.22636920e-01,2.50500073e-01],
[7.39204607e-01,2.23253562e-01,2.49755037e-01],
[7.39415636e-01,2.23872528e-01,2.49009473e-01],
[7.39625539e-01,2.24493813e-01,2.48263395e-01],
[7.39834319e-01,2.25117413e-01,2.47516816e-01],
[7.40041980e-01,2.25743320e-01,2.46769750e-01],
[7.40248524e-01,2.26371529e-01,2.46022209e-01],
[7.40453954e-01,2.27002036e-01,2.45274207e-01],
[7.40658273e-01,2.27634833e-01,2.44525758e-01],
[7.40861484e-01,2.28269914e-01,2.43776875e-01],
[7.41063590e-01,2.28907275e-01,2.43027570e-01],
[7.41264593e-01,2.29546908e-01,2.42277859e-01],
[7.41464496e-01,2.30188807e-01,2.41527754e-01],
[7.41663303e-01,2.30832966e-01,2.40777269e-01],
[7.41861016e-01,2.31479379e-01,2.40026417e-01],
[7.42057637e-01,2.32128038e-01,2.39275212e-01],
[7.42253170e-01,2.32778936e-01,2.38523668e-01],
[7.42447617e-01,2.33432068e-01,2.37771798e-01],
[7.42640981e-01,2.34087426e-01,2.37019615e-01],
[7.42833265e-01,2.34745004e-01,2.36267135e-01],
[7.43024472e-01,2.35404792e-01,2.35514370e-01],
[7.43214604e-01,2.36066786e-01,2.34761334e-01],
[7.43403664e-01,2.36730977e-01,2.34008041e-01],
[7.43591654e-01,2.37397358e-01,2.33254505e-01],
[7.43778578e-01,2.38065921e-01,2.32500739e-01],
[7.43964439e-01,2.38736658e-01,2.31746758e-01],
[7.44149238e-01,2.39409562e-01,2.30992575e-01],
[7.44332978e-01,2.40084625e-01,2.30238204e-01],
[7.44515662e-01,2.40761839e-01,2.29483660e-01],
[7.44697294e-01,2.41441196e-01,2.28728955e-01],
[7.44877874e-01,2.42122688e-01,2.27974105e-01],
[7.45057407e-01,2.42806306e-01,2.27219123e-01],
[7.45235894e-01,2.43492042e-01,2.26464023e-01],
[7.45413338e-01,2.44179887e-01,2.25708820e-01],
[7.45589743e-01,2.44869833e-01,2.24953526e-01],
[7.45765109e-01,2.45561872e-01,2.24198157e-01],
[7.45939441e-01,2.46255994e-01,2.23442726e-01],
[7.46112740e-01,2.46952190e-01,2.22687248e-01],
[7.46285009e-01,2.47650453e-01,2.21931737e-01],
[7.46456250e-01,2.48350771e-01,2.21176206e-01],
[7.46626467e-01,2.49053138e-01,2.20420671e-01],
[7.46795662e-01,2.49757542e-01,2.19665145e-01],
[7.46963836e-01,2.50463975e-01,2.18909642e-01],
[7.47130993e-01,2.51172428e-01,2.18154176e-01],
[7.47297136e-01,2.51882891e-01,2.17398763e-01],
[7.47462266e-01,2.52595354e-01,2.16643415e-01],
[7.47626386e-01,2.53309807e-01,2.15888148e-01],
[7.47789498e-01,2.54026241e-01,2.15132975e-01],
[7.47951606e-01,2.54744647e-01,2.14377912e-01],
[7.48112711e-01,2.55465013e-01,2.13622971e-01],
[7.48272816e-01,2.56187330e-01,2.12868168e-01],
[7.48431923e-01,2.56911587e-01,2.12113517e-01],
[7.48590035e-01,2.57637775e-01,2.11359031e-01],
[7.48747154e-01,2.58365884e-01,2.10604726e-01],
[7.48903282e-01,2.59095902e-01,2.09850616e-01],
[7.49058423e-01,2.59827819e-01,2.09096714e-01],
[7.49212577e-01,2.60561626e-01,2.08343036e-01],
[7.49365748e-01,2.61297310e-01,2.07589596e-01],
[7.49517938e-01,2.62034861e-01,2.06836408e-01],
[7.49669149e-01,2.62774270e-01,2.06083486e-01],
[7.49819384e-01,2.63515524e-01,2.05330844e-01],
[7.49968645e-01,2.64258612e-01,2.04578498e-01],
[7.50116934e-01,2.65003524e-01,2.03826461e-01],
[7.50264254e-01,2.65750249e-01,2.03074748e-01],
[7.50410606e-01,2.66498775e-01,2.02323374e-01],
[7.50555994e-01,2.67249091e-01,2.01572351e-01],
[7.50700419e-01,2.68001186e-01,2.00821696e-01],
[7.50843883e-01,2.68755049e-01,2.00071422e-01],
[7.50986390e-01,2.69510667e-01,1.99321543e-01],
[7.51127940e-01,2.70268029e-01,1.98572074e-01],
[7.51268538e-01,2.71027124e-01,1.97823029e-01],
[7.51408183e-01,2.71787940e-01,1.97074423e-01],
[7.51546880e-01,2.72550465e-01,1.96326270e-01],
[7.51684629e-01,2.73314687e-01,1.95578584e-01],
[7.51821434e-01,2.74080595e-01,1.94831379e-01],
[7.51957297e-01,2.74848176e-01,1.94084670e-01],
[7.52092218e-01,2.75617419e-01,1.93338472e-01],
[7.52226202e-01,2.76388311e-01,1.92592797e-01],
[7.52359250e-01,2.77160840e-01,1.91847662e-01],
[7.52491364e-01,2.77934994e-01,1.91103079e-01],
[7.52622546e-01,2.78710761e-01,1.90359063e-01],
[7.52752799e-01,2.79488128e-01,1.89615629e-01],
[7.52882124e-01,2.80267083e-01,1.88872790e-01],
[7.53010523e-01,2.81047614e-01,1.88130561e-01],
[7.53138000e-01,2.81829707e-01,1.87388957e-01],
[7.53264555e-01,2.82613351e-01,1.86647990e-01],
[7.53390192e-01,2.83398532e-01,1.85907675e-01],
[7.53514911e-01,2.84185238e-01,1.85168028e-01],
[7.53638716e-01,2.84973457e-01,1.84429060e-01],
[7.53761608e-01,2.85763175e-01,1.83690787e-01],
[7.53883589e-01,2.86554380e-01,1.82953224e-01],
[7.54004661e-01,2.87347059e-01,1.82216382e-01],
[7.54124827e-01,2.88141199e-01,1.81480278e-01],
[7.54244088e-01,2.88936786e-01,1.80744925e-01],
[7.54362446e-01,2.89733808e-01,1.80010336e-01],
[7.54479904e-01,2.90532252e-01,1.79276526e-01],
[7.54596464e-01,2.91332105e-01,1.78543509e-01],
[7.54712127e-01,2.92133353e-01,1.77811299e-01],
[7.54826895e-01,2.92935983e-01,1.77079909e-01],
[7.54940771e-01,2.93739982e-01,1.76349354e-01],
[7.55053756e-01,2.94545337e-01,1.75619647e-01],
[7.55165853e-01,2.95352035e-01,1.74890801e-01],
[7.55277063e-01,2.96160061e-01,1.74162832e-01],
[7.55387388e-01,2.96969403e-01,1.73435752e-01],
[7.55496830e-01,2.97780047e-01,1.72709575e-01],
[7.55605392e-01,2.98591979e-01,1.71984316e-01],
[7.55713074e-01,2.99405187e-01,1.71259986e-01],
[7.55819880e-01,3.00219657e-01,1.70536601e-01],
[7.55925811e-01,3.01035374e-01,1.69814174e-01],
[7.56030868e-01,3.01852326e-01,1.69092718e-01],
[7.56135054e-01,3.02670498e-01,1.68372246e-01],
[7.56238371e-01,3.03489878e-01,1.67652773e-01],
[7.56340820e-01,3.04310451e-01,1.66934311e-01],
[7.56442404e-01,3.05132203e-01,1.66216874e-01],
[7.56543124e-01,3.05955122e-01,1.65500476e-01],
[7.56642982e-01,3.06779192e-01,1.64785129e-01],
[7.56741980e-01,3.07604401e-01,1.64070847e-01],
[7.56840120e-01,3.08430734e-01,1.63357643e-01],
[7.56937403e-01,3.09258178e-01,1.62645531e-01],
[7.57033832e-01,3.10086719e-01,1.61934522e-01],
[7.57129408e-01,3.10916342e-01,1.61224631e-01],
[7.57224133e-01,3.11747035e-01,1.60515871e-01],
[7.57318009e-01,3.12578782e-01,1.59808254e-01],
[7.57411037e-01,3.13411571e-01,1.59101793e-01],
[7.57503221e-01,3.14245387e-01,1.58396502e-01],
[7.57594560e-01,3.15080215e-01,1.57692393e-01],
[7.57685057e-01,3.15916043e-01,1.56989478e-01],
[7.57774714e-01,3.16752856e-01,1.56287771e-01],
[7.57863533e-01,3.17590641e-01,1.55587285e-01],
[7.57951515e-01,3.18429382e-01,1.54888031e-01],
[7.58038662e-01,3.19269066e-01,1.54190023e-01],
[7.58124976e-01,3.20109680e-01,1.53493273e-01],
[7.58210459e-01,3.20951208e-01,1.52797793e-01],
[7.58295111e-01,3.21793638e-01,1.52103597e-01],
[7.58378936e-01,3.22636954e-01,1.51410695e-01],
[7.58461934e-01,3.23481143e-01,1.50719101e-01],
[7.58544108e-01,3.24326191e-01,1.50028827e-01],
[7.58625458e-01,3.25172083e-01,1.49339884e-01],
[7.58705988e-01,3.26018806e-01,1.48652286e-01],
[7.58785697e-01,3.26866345e-01,1.47966044e-01],
[7.58864589e-01,3.27714687e-01,1.47281170e-01],
[7.58942665e-01,3.28563817e-01,1.46597676e-01],
[7.59019926e-01,3.29413722e-01,1.45915574e-01],
[7.59096375e-01,3.30264386e-01,1.45234875e-01],
[7.59172012e-01,3.31115797e-01,1.44555592e-01],
[7.59246839e-01,3.31967940e-01,1.43877737e-01],
[7.59320858e-01,3.32820801e-01,1.43201319e-01],
[7.59394071e-01,3.33674365e-01,1.42526352e-01],
[7.59466480e-01,3.34528620e-01,1.41852847e-01],
[7.59538085e-01,3.35383551e-01,1.41180815e-01],
[7.59608889e-01,3.36239143e-01,1.40510267e-01],
[7.59678892e-01,3.37095383e-01,1.39841216e-01],
[7.59748098e-01,3.37952257e-01,1.39173671e-01],
[7.59816506e-01,3.38809751e-01,1.38507644e-01],
[7.59884120e-01,3.39667851e-01,1.37843146e-01],
[7.59950940e-01,3.40526543e-01,1.37180188e-01],
[7.60016968e-01,3.41385812e-01,1.36518781e-01],
[7.60082205e-01,3.42245646e-01,1.35858936e-01],
[7.60146654e-01,3.43106029e-01,1.35200663e-01],
[7.60210315e-01,3.43966949e-01,1.34543974e-01],
[7.60273191e-01,3.44828392e-01,1.33888878e-01],
[7.60335282e-01,3.45690342e-01,1.33235387e-01],
[7.60396590e-01,3.46552788e-01,1.32583510e-01],
[7.60457118e-01,3.47415714e-01,1.31933259e-01],
[7.60516865e-01,3.48279107e-01,1.31284643e-01],
[7.60575834e-01,3.49142953e-01,1.30637672e-01],
[7.60634027e-01,3.50007239e-01,1.29992358e-01],
[7.60691445e-01,3.50871950e-01,1.29348709e-01],
[7.60748089e-01,3.51737074e-01,1.28706736e-01],
[7.60803960e-01,3.52602596e-01,1.28066448e-01],
[7.60859061e-01,3.53468502e-01,1.27427856e-01],
[7.60913393e-01,3.54334780e-01,1.26790969e-01],
[7.60966957e-01,3.55201415e-01,1.26155797e-01],
[7.61019755e-01,3.56068394e-01,1.25522349e-01],
[7.61071787e-01,3.56935703e-01,1.24890635e-01],
[7.61123057e-01,3.57803329e-01,1.24260663e-01],
[7.61173564e-01,3.58671259e-01,1.23632445e-01],
[7.61223311e-01,3.59539478e-01,1.23005988e-01],
[7.61272299e-01,3.60407974e-01,1.22381301e-01],
[7.61320530e-01,3.61276734e-01,1.21758395e-01],
[7.61368004e-01,3.62145743e-01,1.21137277e-01],
[7.61414723e-01,3.63014988e-01,1.20517956e-01],
[7.61460689e-01,3.63884457e-01,1.19900442e-01],
[7.61505903e-01,3.64754135e-01,1.19284743e-01],
[7.61550366e-01,3.65624010e-01,1.18670867e-01],
[7.61594081e-01,3.66494069e-01,1.18058824e-01],
[7.61637047e-01,3.67364299e-01,1.17448620e-01],
[7.61679267e-01,3.68234685e-01,1.16840265e-01],
[7.61720742e-01,3.69105216e-01,1.16233768e-01],
[7.61761473e-01,3.69975879e-01,1.15629135e-01],
[7.61801463e-01,3.70846659e-01,1.15026375e-01],
[7.61840711e-01,3.71717545e-01,1.14425496e-01],
[7.61879219e-01,3.72588524e-01,1.13826505e-01],
[7.61916990e-01,3.73459582e-01,1.13229411e-01],
[7.61954023e-01,3.74330707e-01,1.12634221e-01],
[7.61990321e-01,3.75201886e-01,1.12040943e-01],
[7.62025885e-01,3.76073107e-01,1.11449584e-01],
[7.62060716e-01,3.76944356e-01,1.10860151e-01],
[7.62094816e-01,3.77815622e-01,1.10272652e-01],
[7.62128185e-01,3.78686890e-01,1.09687094e-01],
[7.62160826e-01,3.79558150e-01,1.09103484e-01],
[7.62192739e-01,3.80429389e-01,1.08521828e-01],
[7.62223925e-01,3.81300593e-01,1.07942134e-01],
[7.62254387e-01,3.82171751e-01,1.07364408e-01],
[7.62284125e-01,3.83042850e-01,1.06788658e-01],
[7.62313141e-01,3.83913879e-01,1.06214889e-01],
[7.62341435e-01,3.84784824e-01,1.05643108e-01],
[7.62369010e-01,3.85655673e-01,1.05073322e-01],
[7.62395866e-01,3.86526415e-01,1.04505536e-01],
[7.62422005e-01,3.87397038e-01,1.03939758e-01],
[7.62447428e-01,3.88267529e-01,1.03375992e-01],
[7.62472136e-01,3.89137876e-01,1.02814245e-01],
[7.62496131e-01,3.90008067e-01,1.02254522e-01],
[7.62519414e-01,3.90878091e-01,1.01696830e-01],
[7.62541986e-01,3.91747936e-01,1.01141175e-01],
[7.62563848e-01,3.92617589e-01,1.00587560e-01],
[7.62585001e-01,3.93487039e-01,1.00035993e-01],
[7.62605447e-01,3.94356275e-01,9.94864787e-02],
[7.62625188e-01,3.95225285e-01,9.89390217e-02],
[7.62644223e-01,3.96094057e-01,9.83936275e-02],
[7.62662555e-01,3.96962580e-01,9.78503011e-02],
[7.62680185e-01,3.97830843e-01,9.73090475e-02],
[7.62697113e-01,3.98698833e-01,9.67698714e-02],
[7.62713341e-01,3.99566540e-01,9.62327777e-02],
[7.62728871e-01,4.00433952e-01,9.56977708e-02],
[7.62743703e-01,4.01301058e-01,9.51648554e-02],
[7.62757839e-01,4.02167847e-01,9.46340358e-02],
[7.62771280e-01,4.03034308e-01,9.41053163e-02],
[7.62784027e-01,4.03900430e-01,9.35787012e-02],
[7.62796081e-01,4.04766201e-01,9.30541945e-02],
[7.62807444e-01,4.05631612e-01,9.25318003e-02],
[7.62818116e-01,4.06496650e-01,9.20115224e-02],
[7.62828099e-01,4.07361306e-01,9.14933646e-02],
[7.62837393e-01,4.08225568e-01,9.09773305e-02],
[7.62846001e-01,4.09089425e-01,9.04634239e-02],
[7.62853923e-01,4.09952868e-01,8.99516481e-02],
[7.62861161e-01,4.10815885e-01,8.94420064e-02],
[7.62867715e-01,4.11678466e-01,8.89345023e-02],
[7.62873587e-01,4.12540601e-01,8.84291388e-02],
[7.62878777e-01,4.13402279e-01,8.79259191e-02],
[7.62883288e-01,4.14263489e-01,8.74248459e-02],
[7.62887120e-01,4.15124223e-01,8.69259223e-02],
[7.62890274e-01,4.15984468e-01,8.64291509e-02],
[7.62892751e-01,4.16844216e-01,8.59345345e-02],
[7.62894553e-01,4.17703456e-01,8.54420754e-02],
[7.62895680e-01,4.18562178e-01,8.49517763e-02],
[7.62896134e-01,4.19420372e-01,8.44636394e-02],
[7.62895916e-01,4.20278028e-01,8.39776669e-02],
[7.62895027e-01,4.21135137e-01,8.34938610e-02],
[7.62893468e-01,4.21991688e-01,8.30122236e-02],
[7.62891240e-01,4.22847672e-01,8.25327569e-02],
[7.62888344e-01,4.23703080e-01,8.20554624e-02],
[7.62884782e-01,4.24557901e-01,8.15803421e-02],
[7.62880554e-01,4.25412126e-01,8.11073974e-02],
[7.62875661e-01,4.26265746e-01,8.06366299e-02],
[7.62870105e-01,4.27118752e-01,8.01680411e-02],
[7.62863887e-01,4.27971133e-01,7.97016322e-02],
[7.62857008e-01,4.28822882e-01,7.92374045e-02],
[7.62849468e-01,4.29673987e-01,7.87753591e-02],
[7.62841269e-01,4.30524442e-01,7.83154969e-02],
[7.62832412e-01,4.31374235e-01,7.78578190e-02],
[7.62822899e-01,4.32223359e-01,7.74023260e-02],
[7.62812729e-01,4.33071805e-01,7.69490189e-02],
[7.62801904e-01,4.33919563e-01,7.64978980e-02],
[7.62790426e-01,4.34766624e-01,7.60489641e-02],
[7.62778295e-01,4.35612981e-01,7.56022175e-02],
[7.62765512e-01,4.36458624e-01,7.51576584e-02],
[7.62752078e-01,4.37303545e-01,7.47152873e-02],
[7.62737995e-01,4.38147735e-01,7.42751041e-02],
[7.62723263e-01,4.38991185e-01,7.38371090e-02],
[7.62707883e-01,4.39833888e-01,7.34013018e-02],
[7.62691858e-01,4.40675834e-01,7.29676824e-02],
[7.62675186e-01,4.41517017e-01,7.25362506e-02],
[7.62657870e-01,4.42357426e-01,7.21070059e-02],
[7.62639911e-01,4.43197055e-01,7.16799481e-02],
[7.62621309e-01,4.44035895e-01,7.12550764e-02],
[7.62602065e-01,4.44873938e-01,7.08323904e-02],
[7.62582182e-01,4.45711176e-01,7.04118892e-02],
[7.62561658e-01,4.46547601e-01,6.99935721e-02],
[7.62540497e-01,4.47383206e-01,6.95774381e-02],
[7.62518698e-01,4.48217982e-01,6.91634864e-02],
[7.62496263e-01,4.49051922e-01,6.87517156e-02],
[7.62473192e-01,4.49885018e-01,6.83421248e-02],
[7.62449487e-01,4.50717263e-01,6.79347126e-02],
[7.62425148e-01,4.51548649e-01,6.75294777e-02],
[7.62400177e-01,4.52379169e-01,6.71264186e-02],
[7.62374574e-01,4.53208815e-01,6.67255339e-02],
[7.62348342e-01,4.54037580e-01,6.63268217e-02],
[7.62321479e-01,4.54865457e-01,6.59302806e-02],
[7.62293988e-01,4.55692438e-01,6.55359086e-02],
[7.62265870e-01,4.56518517e-01,6.51437040e-02],
[7.62237125e-01,4.57343686e-01,6.47536646e-02],
[7.62207754e-01,4.58167938e-01,6.43657886e-02],
[7.62177759e-01,4.58991267e-01,6.39800737e-02],
[7.62147141e-01,4.59813665e-01,6.35965177e-02],
[7.62115899e-01,4.60635126e-01,6.32151184e-02],
[7.62084036e-01,4.61455643e-01,6.28358733e-02],
[7.62051553e-01,4.62275209e-01,6.24587800e-02],
[7.62018449e-01,4.63093818e-01,6.20838360e-02],
[7.61984727e-01,4.63911463e-01,6.17110387e-02],
[7.61950386e-01,4.64728138e-01,6.13403852e-02],
[7.61915429e-01,4.65543836e-01,6.09718730e-02],
[7.61879856e-01,4.66358550e-01,6.06054990e-02],
[7.61843668e-01,4.67172275e-01,6.02412605e-02],
[7.61806866e-01,4.67985005e-01,5.98791543e-02],
[7.61769450e-01,4.68796732e-01,5.95191773e-02],
[7.61731423e-01,4.69607452e-01,5.91613265e-02],
[7.61692784e-01,4.70417157e-01,5.88055986e-02],
[7.61653535e-01,4.71225842e-01,5.84519903e-02],
[7.61613676e-01,4.72033501e-01,5.81004982e-02],
[7.61573209e-01,4.72840129e-01,5.77511189e-02],
[7.61532135e-01,4.73645718e-01,5.74038488e-02],
[7.61490454e-01,4.74450265e-01,5.70586843e-02],
[7.61448167e-01,4.75253762e-01,5.67156219e-02],
[7.61405275e-01,4.76056204e-01,5.63746577e-02],
[7.61361780e-01,4.76857586e-01,5.60357880e-02],
[7.61317682e-01,4.77657902e-01,5.56990088e-02],
[7.61272982e-01,4.78457147e-01,5.53643164e-02],
[7.61227680e-01,4.79255315e-01,5.50317066e-02],
[7.61181779e-01,4.80052401e-01,5.47011755e-02],
[7.61135278e-01,4.80848400e-01,5.43727188e-02],
[7.61088179e-01,4.81643307e-01,5.40463325e-02],
[7.61040483e-01,4.82437116e-01,5.37220122e-02],
[7.60992190e-01,4.83229822e-01,5.33997537e-02],
[7.60943301e-01,4.84021420e-01,5.30795526e-02],
[7.60893818e-01,4.84811906e-01,5.27614044e-02],
[7.60843741e-01,4.85601274e-01,5.24453048e-02],
[7.60793071e-01,4.86389520e-01,5.21312490e-02],
[7.60741810e-01,4.87176639e-01,5.18192326e-02],
[7.60689957e-01,4.87962625e-01,5.15092508e-02],
[7.60637514e-01,4.88747475e-01,5.12012990e-02],
[7.60584481e-01,4.89531184e-01,5.08953725e-02],
[7.60530861e-01,4.90313747e-01,5.05914662e-02],
[7.60476652e-01,4.91095159e-01,5.02895755e-02],
[7.60421857e-01,4.91875417e-01,4.99896954e-02],
[7.60366477e-01,4.92654515e-01,4.96918209e-02],
[7.60310511e-01,4.93432450e-01,4.93959469e-02],
[7.60253962e-01,4.94209217e-01,4.91020685e-02],
[7.60196829e-01,4.94984812e-01,4.88101805e-02],
[7.60139115e-01,4.95759231e-01,4.85202777e-02],
[7.60080819e-01,4.96532470e-01,4.82323548e-02],
[7.60021943e-01,4.97304524e-01,4.79464068e-02],
[7.59962487e-01,4.98075390e-01,4.76624282e-02],
[7.59902452e-01,4.98845064e-01,4.73804137e-02],
[7.59841840e-01,4.99613541e-01,4.71003579e-02],
[7.59780651e-01,5.00380819e-01,4.68222553e-02],
[7.59718886e-01,5.01146892e-01,4.65461006e-02],
[7.59656546e-01,5.01911758e-01,4.62718882e-02],
[7.59593631e-01,5.02675413e-01,4.59996126e-02],
[7.59530143e-01,5.03437853e-01,4.57292681e-02],
[7.59466083e-01,5.04199074e-01,4.54608491e-02],
[7.59401451e-01,5.04959073e-01,4.51943501e-02],
[7.59336248e-01,5.05717847e-01,4.49297652e-02],
[7.59270476e-01,5.06475393e-01,4.46670887e-02],
[7.59204134e-01,5.07231705e-01,4.44063150e-02],
[7.59137224e-01,5.07986783e-01,4.41474382e-02],
[7.59069747e-01,5.08740622e-01,4.38904524e-02],
[7.59001703e-01,5.09493218e-01,4.36353519e-02],
[7.58933094e-01,5.10244570e-01,4.33821307e-02],
[7.58863921e-01,5.10994673e-01,4.31307829e-02],
[7.58794183e-01,5.11743525e-01,4.28813026e-02],
[7.58723883e-01,5.12491122e-01,4.26336838e-02],
[7.58653020e-01,5.13237463e-01,4.23879206e-02],
[7.58581596e-01,5.13982543e-01,4.21440069e-02],
[7.58509612e-01,5.14726360e-01,4.19019366e-02],
[7.58437068e-01,5.15468911e-01,4.16617037e-02],
[7.58363966e-01,5.16210194e-01,4.14233022e-02],
[7.58290306e-01,5.16950205e-01,4.11867258e-02],
[7.58216089e-01,5.17688942e-01,4.09519686e-02],
[7.58141315e-01,5.18426403e-01,4.07190243e-02],
[7.58065987e-01,5.19162584e-01,4.04878867e-02],
[7.57990104e-01,5.19897484e-01,4.02585498e-02],
[7.57913668e-01,5.20631100e-01,4.00310073e-02],
[7.57836680e-01,5.21363429e-01,3.98052529e-02],
[7.57759139e-01,5.22094469e-01,3.95812806e-02],
[7.57681048e-01,5.22824217e-01,3.93590840e-02],
[7.57602406e-01,5.23552672e-01,3.91386568e-02],
[7.57523215e-01,5.24279832e-01,3.89199929e-02],
[7.57443476e-01,5.25005693e-01,3.87030859e-02],
[7.57363190e-01,5.25730254e-01,3.84879296e-02],
[7.57282357e-01,5.26453512e-01,3.82745177e-02],
[7.57200978e-01,5.27175466e-01,3.80628439e-02],
[7.57119054e-01,5.27896114e-01,3.78529018e-02],
[7.57036586e-01,5.28615454e-01,3.76446852e-02],
[7.56953575e-01,5.29333483e-01,3.74381878e-02],
[7.56870021e-01,5.30050200e-01,3.72334031e-02],
[7.56785926e-01,5.30765603e-01,3.70303250e-02],
[7.56701291e-01,5.31479690e-01,3.68289471e-02],
[7.56616115e-01,5.32192459e-01,3.66292631e-02],
[7.56530401e-01,5.32903909e-01,3.64312665e-02],
[7.56444148e-01,5.33614038e-01,3.62349512e-02],
[7.56357359e-01,5.34322845e-01,3.60403108e-02],
[7.56270033e-01,5.35030327e-01,3.58473390e-02],
[7.56182171e-01,5.35736483e-01,3.56560294e-02],
[7.56093775e-01,5.36441312e-01,3.54663757e-02],
[7.56004845e-01,5.37144813e-01,3.52783717e-02],
[7.55915382e-01,5.37846983e-01,3.50920111e-02],
[7.55825387e-01,5.38547822e-01,3.49072874e-02],
[7.55734861e-01,5.39247327e-01,3.47241945e-02],
[7.55643804e-01,5.39945499e-01,3.45427261e-02],
[7.55552218e-01,5.40642335e-01,3.43628759e-02],
[7.55460103e-01,5.41337834e-01,3.41846377e-02],
[7.55367461e-01,5.42031995e-01,3.40080052e-02],
[7.55274291e-01,5.42724817e-01,3.38329721e-02],
[7.55180595e-01,5.43416299e-01,3.36595323e-02],
[7.55086374e-01,5.44106440e-01,3.34876796e-02],
[7.54991629e-01,5.44795238e-01,3.33174077e-02],
[7.54896360e-01,5.45482693e-01,3.31487105e-02],
[7.54800569e-01,5.46168804e-01,3.29815819e-02],
[7.54704256e-01,5.46853569e-01,3.28160156e-02],
[7.54607422e-01,5.47536989e-01,3.26520056e-02],
[7.54510067e-01,5.48219061e-01,3.24895458e-02],
[7.54412194e-01,5.48899786e-01,3.23286300e-02],
[7.54313802e-01,5.49579162e-01,3.21692523e-02],
[7.54214893e-01,5.50257188e-01,3.20114066e-02],
[7.54115467e-01,5.50933865e-01,3.18550868e-02],
[7.54015525e-01,5.51609191e-01,3.17002870e-02],
[7.53915069e-01,5.52283166e-01,3.15470012e-02],
[7.53814098e-01,5.52955788e-01,3.13952235e-02],
[7.53712614e-01,5.53627058e-01,3.12449480e-02],
[7.53610618e-01,5.54296975e-01,3.10961687e-02],
[7.53508111e-01,5.54965538e-01,3.09488797e-02],
[7.53405093e-01,5.55632747e-01,3.08030754e-02],
[7.53301565e-01,5.56298602e-01,3.06587498e-02],
[7.53197528e-01,5.56963102e-01,3.05158972e-02],
[7.53092984e-01,5.57626246e-01,3.03745118e-02],
[7.52987932e-01,5.58288035e-01,3.02345880e-02],
[7.52882374e-01,5.58948467e-01,3.00961200e-02],
[7.52776311e-01,5.59607544e-01,2.99591022e-02],
[7.52669744e-01,5.60265264e-01,2.98235290e-02],
[7.52562672e-01,5.60921627e-01,2.96893948e-02],
[7.52455099e-01,5.61576633e-01,2.95566941e-02],
[7.52347023e-01,5.62230282e-01,2.94254213e-02],
[7.52238446e-01,5.62882574e-01,2.92955711e-02],
[7.52129369e-01,5.63533509e-01,2.91671379e-02],
[7.52019794e-01,5.64183086e-01,2.90401164e-02],
[7.51909719e-01,5.64831306e-01,2.89145013e-02],
[7.51799148e-01,5.65478168e-01,2.87902871e-02],
[7.51688079e-01,5.66123673e-01,2.86674687e-02],
[7.51576516e-01,5.66767821e-01,2.85460409e-02],
[7.51464457e-01,5.67410611e-01,2.84259983e-02],
[7.51351904e-01,5.68052044e-01,2.83073360e-02],
[7.51238859e-01,5.68692120e-01,2.81900488e-02],
[7.51125321e-01,5.69330840e-01,2.80741316e-02],
[7.51011293e-01,5.69968202e-01,2.79595795e-02],
[7.50896773e-01,5.70604208e-01,2.78463874e-02],
[7.50781765e-01,5.71238858e-01,2.77345506e-02],
[7.50666268e-01,5.71872152e-01,2.76240640e-02],
[7.50550283e-01,5.72504090e-01,2.75149229e-02],
[7.50433812e-01,5.73134673e-01,2.74071225e-02],
[7.50316854e-01,5.73763900e-01,2.73006581e-02],
[7.50199412e-01,5.74391774e-01,2.71955251e-02],
[7.50081486e-01,5.75018293e-01,2.70917187e-02],
[7.49963077e-01,5.75643458e-01,2.69892346e-02],
[7.49844185e-01,5.76267269e-01,2.68880680e-02],
[7.49724812e-01,5.76889728e-01,2.67882147e-02],
[7.49604959e-01,5.77510835e-01,2.66896701e-02],
[7.49484626e-01,5.78130590e-01,2.65924300e-02],
[7.49363814e-01,5.78748993e-01,2.64964900e-02],
[7.49242525e-01,5.79366046e-01,2.64018459e-02],
[7.49120760e-01,5.79981748e-01,2.63084935e-02],
[7.48998518e-01,5.80596102e-01,2.62164288e-02],
[7.48875801e-01,5.81209106e-01,2.61256476e-02],
[7.48752611e-01,5.81820762e-01,2.60361459e-02],
[7.48628947e-01,5.82431070e-01,2.59479198e-02],
[7.48504811e-01,5.83040032e-01,2.58609655e-02],
[7.48380204e-01,5.83647648e-01,2.57752790e-02],
[7.48255127e-01,5.84253918e-01,2.56908566e-02],
[7.48129580e-01,5.84858844e-01,2.56076947e-02],
[7.48003565e-01,5.85462426e-01,2.55257896e-02],
[7.47877082e-01,5.86064666e-01,2.54451376e-02],
[7.47750133e-01,5.86665563e-01,2.53657354e-02],
[7.47622718e-01,5.87265119e-01,2.52875795e-02],
[7.47494839e-01,5.87863335e-01,2.52106665e-02],
[7.47366495e-01,5.88460211e-01,2.51349931e-02],
[7.47237689e-01,5.89055749e-01,2.50605560e-02],
[7.47108421e-01,5.89649949e-01,2.49873520e-02],
[7.46978692e-01,5.90242813e-01,2.49153782e-02],
[7.46848503e-01,5.90834341e-01,2.48446313e-02],
[7.46717855e-01,5.91424535e-01,2.47751085e-02],
[7.46586749e-01,5.92013395e-01,2.47068069e-02],
[7.46455186e-01,5.92600923e-01,2.46397236e-02],
[7.46323167e-01,5.93187119e-01,2.45738559e-02],
[7.46190692e-01,5.93771985e-01,2.45092011e-02],
[7.46057763e-01,5.94355522e-01,2.44457566e-02],
[7.45924381e-01,5.94937731e-01,2.43835198e-02],
[7.45790547e-01,5.95518612e-01,2.43224883e-02],
[7.45656261e-01,5.96098168e-01,2.42626597e-02],
[7.45521525e-01,5.96676399e-01,2.42040317e-02],
[7.45386339e-01,5.97253307e-01,2.41466021e-02],
[7.45250705e-01,5.97828892e-01,2.40903686e-02],
[7.45114624e-01,5.98403157e-01,2.40353292e-02],
[7.44978096e-01,5.98976101e-01,2.39814820e-02],
[7.44841122e-01,5.99547728e-01,2.39288249e-02],
[7.44703704e-01,6.00118036e-01,2.38773562e-02],
[7.44565843e-01,6.00687029e-01,2.38270741e-02],
[7.44427539e-01,6.01254708e-01,2.37779768e-02],
[7.44288793e-01,6.01821072e-01,2.37300628e-02],
[7.44149607e-01,6.02386125e-01,2.36833306e-02],
[7.44009981e-01,6.02949868e-01,2.36377787e-02],
[7.43869917e-01,6.03512301e-01,2.35934057e-02],
[7.43729415e-01,6.04073426e-01,2.35502105e-02],
[7.43588476e-01,6.04633245e-01,2.35081917e-02],
[7.43447102e-01,6.05191758e-01,2.34673483e-02],
[7.43305294e-01,6.05748968e-01,2.34276793e-02],
[7.43163052e-01,6.06304876e-01,2.33891837e-02],
[7.43020377e-01,6.06859483e-01,2.33518607e-02],
[7.42877271e-01,6.07412791e-01,2.33157096e-02],
[7.42733734e-01,6.07964801e-01,2.32807296e-02],
[7.42589768e-01,6.08515515e-01,2.32469202e-02],
[7.42445373e-01,6.09064934e-01,2.32142808e-02],
[7.42300551e-01,6.09613060e-01,2.31828112e-02],
[7.42155303e-01,6.10159894e-01,2.31525109e-02],
[7.42009629e-01,6.10705439e-01,2.31233797e-02],
[7.41863531e-01,6.11249694e-01,2.30954176e-02],
[7.41717009e-01,6.11792663e-01,2.30686244e-02],
[7.41570065e-01,6.12334346e-01,2.30430003e-02],
[7.41422700e-01,6.12874746e-01,2.30185453e-02],
[7.41274915e-01,6.13413863e-01,2.29952597e-02],
[7.41126711e-01,6.13951700e-01,2.29731439e-02],
[7.40978089e-01,6.14488258e-01,2.29521983e-02],
[7.40829049e-01,6.15023538e-01,2.29324234e-02],
[7.40679594e-01,6.15557544e-01,2.29138198e-02],
[7.40529724e-01,6.16090275e-01,2.28963882e-02],
[7.40379440e-01,6.16621734e-01,2.28801296e-02],
[7.40228743e-01,6.17151923e-01,2.28650447e-02],
[7.40077634e-01,6.17680843e-01,2.28511346e-02],
[7.39926115e-01,6.18208495e-01,2.28384004e-02],
[7.39774186e-01,6.18734883e-01,2.28268434e-02],
[7.39621849e-01,6.19260007e-01,2.28164649e-02],
[7.39469104e-01,6.19783869e-01,2.28072662e-02],
[7.39315953e-01,6.20306471e-01,2.27992489e-02],
[7.39162397e-01,6.20827815e-01,2.27924146e-02],
[7.39008436e-01,6.21347902e-01,2.27867650e-02],
[7.38854073e-01,6.21866734e-01,2.27823020e-02],
[7.38699307e-01,6.22384314e-01,2.27790275e-02],
[7.38544141e-01,6.22900643e-01,2.27769436e-02],
[7.38388575e-01,6.23415722e-01,2.27760523e-02],
[7.38232610e-01,6.23929554e-01,2.27763560e-02],
[7.38076248e-01,6.24442140e-01,2.27778570e-02],
[7.37919489e-01,6.24953482e-01,2.27805578e-02],
[7.37762335e-01,6.25463583e-01,2.27844608e-02],
[7.37604787e-01,6.25972443e-01,2.27895689e-02],
[7.37446845e-01,6.26480066e-01,2.27958848e-02],
[7.37288512e-01,6.26986452e-01,2.28034115e-02],
[7.37129788e-01,6.27491604e-01,2.28121518e-02],
[7.36970674e-01,6.27995523e-01,2.28221090e-02],
[7.36811171e-01,6.28498212e-01,2.28332863e-02],
[7.36651281e-01,6.28999672e-01,2.28456870e-02],
[7.36491005e-01,6.29499905e-01,2.28593146e-02],
[7.36330344e-01,6.29998914e-01,2.28741727e-02],
[7.36169298e-01,6.30496699e-01,2.28902649e-02],
[7.36007870e-01,6.30993264e-01,2.29075950e-02],
[7.35846060e-01,6.31488610e-01,2.29261671e-02],
[7.35683869e-01,6.31982739e-01,2.29459850e-02],
[7.35521299e-01,6.32475652e-01,2.29670530e-02],
[7.35358351e-01,6.32967353e-01,2.29893754e-02],
[7.35195026e-01,6.33457843e-01,2.30129564e-02],
[7.35031325e-01,6.33947123e-01,2.30378006e-02],
[7.34867249e-01,6.34435197e-01,2.30639127e-02],
[7.34702799e-01,6.34922065e-01,2.30912974e-02],
[7.34537978e-01,6.35407730e-01,2.31199594e-02],
[7.34372785e-01,6.35892195e-01,2.31499039e-02],
[7.34207222e-01,6.36375460e-01,2.31811359e-02],
[7.34041290e-01,6.36857528e-01,2.32136607e-02],
[7.33874991e-01,6.37338401e-01,2.32474835e-02],
[7.33708325e-01,6.37818081e-01,2.32826099e-02],
[7.33541294e-01,6.38296571e-01,2.33190454e-02],
[7.33373899e-01,6.38773871e-01,2.33567958e-02],
[7.33206141e-01,6.39249984e-01,2.33958669e-02],
[7.33038022e-01,6.39724913e-01,2.34362646e-02],
[7.32869542e-01,6.40198659e-01,2.34779951e-02],
[7.32700704e-01,6.40671225e-01,2.35210646e-02],
[7.32531507e-01,6.41142612e-01,2.35654794e-02],
[7.32361953e-01,6.41612822e-01,2.36112459e-02],
[7.32192045e-01,6.42081858e-01,2.36583708e-02],
[7.32021781e-01,6.42549722e-01,2.37068608e-02],
[7.31851165e-01,6.43016415e-01,2.37567228e-02],
[7.31680198e-01,6.43481940e-01,2.38079637e-02],
[7.31508879e-01,6.43946300e-01,2.38605906e-02],
[7.31337212e-01,6.44409495e-01,2.39146108e-02],
[7.31165196e-01,6.44871529e-01,2.39700316e-02],
[7.30992834e-01,6.45332402e-01,2.40268606e-02],
[7.30820126e-01,6.45792119e-01,2.40851053e-02],
[7.30647074e-01,6.46250679e-01,2.41447736e-02],
[7.30473679e-01,6.46708087e-01,2.42058733e-02],
[7.30299943e-01,6.47164343e-01,2.42684125e-02],
[7.30125866e-01,6.47619450e-01,2.43323993e-02],
[7.29951450e-01,6.48073410e-01,2.43978420e-02],
[7.29776696e-01,6.48526225e-01,2.44647490e-02],
[7.29601605e-01,6.48977898e-01,2.45331289e-02],
[7.29426179e-01,6.49428430e-01,2.46029904e-02],
[7.29250420e-01,6.49877824e-01,2.46743423e-02],
[7.29074327e-01,6.50326081e-01,2.47471936e-02],
[7.28897904e-01,6.50773205e-01,2.48215534e-02],
[7.28721150e-01,6.51219196e-01,2.48974309e-02],
[7.28544068e-01,6.51664058e-01,2.49748355e-02],
[7.28366658e-01,6.52107791e-01,2.50537766e-02],
[7.28188922e-01,6.52550400e-01,2.51342640e-02],
[7.28010861e-01,6.52991885e-01,2.52163073e-02],
[7.27832477e-01,6.53432249e-01,2.52999166e-02],
[7.27653771e-01,6.53871494e-01,2.53851019e-02],
[7.27474744e-01,6.54309623e-01,2.54718733e-02],
[7.27295397e-01,6.54746636e-01,2.55602412e-02],
[7.27115732e-01,6.55182538e-01,2.56502161e-02],
[7.26935751e-01,6.55617329e-01,2.57418086e-02],
[7.26755454e-01,6.56051012e-01,2.58350293e-02],
[7.26574843e-01,6.56483588e-01,2.59298892e-02],
[7.26393920e-01,6.56915062e-01,2.60263993e-02],
[7.26212685e-01,6.57345433e-01,2.61245707e-02],
[7.26031140e-01,6.57774706e-01,2.62244148e-02],
[7.25849287e-01,6.58202881e-01,2.63259430e-02],
[7.25667126e-01,6.58629961e-01,2.64291668e-02],
[7.25484660e-01,6.59055949e-01,2.65340980e-02],
[7.25301889e-01,6.59480845e-01,2.66407484e-02],
[7.25118815e-01,6.59904654e-01,2.67491300e-02],
[7.24935440e-01,6.60327376e-01,2.68592549e-02],
[7.24751764e-01,6.60749014e-01,2.69711353e-02],
[7.24567789e-01,6.61169570e-01,2.70847838e-02],
[7.24383517e-01,6.61589047e-01,2.72002128e-02],
[7.24198949e-01,6.62007446e-01,2.73174350e-02],
[7.24014086e-01,6.62424770e-01,2.74364632e-02],
[7.23828930e-01,6.62841021e-01,2.75573104e-02],
[7.23643482e-01,6.63256201e-01,2.76799896e-02],
[7.23457743e-01,6.63670313e-01,2.78045141e-02],
[7.23271716e-01,6.64083358e-01,2.79308973e-02],
[7.23085401e-01,6.64495339e-01,2.80591527e-02],
[7.22898800e-01,6.64906257e-01,2.81892939e-02],
[7.22711915e-01,6.65316116e-01,2.83213346e-02],
[7.22524746e-01,6.65724917e-01,2.84552888e-02],
[7.22337296e-01,6.66132663e-01,2.85911706e-02],
[7.22149565e-01,6.66539355e-01,2.87289941e-02],
[7.21961556e-01,6.66944997e-01,2.88687736e-02],
[7.21773269e-01,6.67349590e-01,2.90105236e-02],
[7.21584706e-01,6.67753135e-01,2.91542587e-02],
[7.21395869e-01,6.68155637e-01,2.92999936e-02],
[7.21206759e-01,6.68557096e-01,2.94477431e-02],
[7.21017377e-01,6.68957515e-01,2.95975222e-02],
[7.20827726e-01,6.69356897e-01,2.97493461e-02],
[7.20637805e-01,6.69755242e-01,2.99032299e-02],
[7.20447618e-01,6.70152555e-01,3.00591891e-02],
[7.20257166e-01,6.70548836e-01,3.02172392e-02],
[7.20066449e-01,6.70944087e-01,3.03773958e-02],
[7.19875470e-01,6.71338312e-01,3.05396746e-02],
[7.19684230e-01,6.71731513e-01,3.07040915e-02],
[7.19492731e-01,6.72123691e-01,3.08706626e-02],
[7.19300973e-01,6.72514848e-01,3.10394040e-02],
[7.19108959e-01,6.72904988e-01,3.12103319e-02],
[7.18916691e-01,6.73294111e-01,3.13834628e-02],
[7.18724169e-01,6.73682221e-01,3.15588131e-02],
[7.18531395e-01,6.74069320e-01,3.17363995e-02],
[7.18338371e-01,6.74455409e-01,3.19162387e-02],
[7.18145098e-01,6.74840491e-01,3.20983476e-02],
[7.17951578e-01,6.75224568e-01,3.22827433e-02],
[7.17757812e-01,6.75607642e-01,3.24694426e-02],
[7.17563802e-01,6.75989716e-01,3.26584631e-02],
[7.17369550e-01,6.76370791e-01,3.28498218e-02],
[7.17175057e-01,6.76750870e-01,3.30435363e-02],
[7.16980324e-01,6.77129955e-01,3.32396242e-02],
[7.16785354e-01,6.77508048e-01,3.34381031e-02],
[7.16590147e-01,6.77885151e-01,3.36389909e-02],
[7.16394706e-01,6.78261267e-01,3.38423053e-02],
[7.16199032e-01,6.78636398e-01,3.40480643e-02],
[7.16003126e-01,6.79010545e-01,3.42562862e-02],
[7.15806990e-01,6.79383712e-01,3.44669890e-02],
[7.15610627e-01,6.79755900e-01,3.46801911e-02],
[7.15414036e-01,6.80127111e-01,3.48959109e-02],
[7.15217221e-01,6.80497347e-01,3.51141669e-02],
[7.15020182e-01,6.80866611e-01,3.53349777e-02],
[7.14822922e-01,6.81234905e-01,3.55583619e-02],
[7.14625441e-01,6.81602231e-01,3.57843384e-02],
[7.14427742e-01,6.81968592e-01,3.60129260e-02],
[7.14229826e-01,6.82333988e-01,3.62441437e-02],
[7.14031695e-01,6.82698423e-01,3.64780105e-02],
[7.13833350e-01,6.83061899e-01,3.67145457e-02],
[7.13634793e-01,6.83424417e-01,3.69537683e-02],
[7.13436026e-01,6.83785980e-01,3.71956977e-02],
[7.13237050e-01,6.84146591e-01,3.74403533e-02],
[7.13037867e-01,6.84506250e-01,3.76877545e-02],
[7.12838479e-01,6.84864961e-01,3.79379209e-02],
[7.12638888e-01,6.85222726e-01,3.81908721e-02],
[7.12439094e-01,6.85579546e-01,3.84466277e-02],
[7.12239100e-01,6.85935424e-01,3.87052075e-02],
[7.12038908e-01,6.86290361e-01,3.89666313e-02],
[7.11838518e-01,6.86644361e-01,3.92309189e-02],
[7.11637934e-01,6.86997425e-01,3.94980903e-02],
[7.11437155e-01,6.87349555e-01,3.97681655e-02],
[7.11236186e-01,6.87700754e-01,4.00411646e-02],
[7.11035025e-01,6.88051023e-01,4.03171075e-02],
[7.10833677e-01,6.88400365e-01,4.05960145e-02],
[7.10632142e-01,6.88748781e-01,4.08779057e-02],
[7.10430422e-01,6.89096274e-01,4.11628015e-02],
[7.10228518e-01,6.89442847e-01,4.14507220e-02],
[7.10026434e-01,6.89788500e-01,4.17416877e-02],
[7.09824169e-01,6.90133237e-01,4.20357188e-02],
[7.09621726e-01,6.90477058e-01,4.23328358e-02],
[7.09419108e-01,6.90819968e-01,4.26330590e-02],
[7.09216314e-01,6.91161966e-01,4.29364090e-02],
[7.09013348e-01,6.91503056e-01,4.32429061e-02],
[7.08810211e-01,6.91843240e-01,4.35525710e-02],
[7.08606904e-01,6.92182520e-01,4.38654241e-02],
[7.08403430e-01,6.92520897e-01,4.41814860e-02],
[7.08199790e-01,6.92858375e-01,4.45007771e-02],
[7.07995987e-01,6.93194954e-01,4.48233182e-02],
[7.07792021e-01,6.93530637e-01,4.51491296e-02],
[7.07587895e-01,6.93865427e-01,4.54782320e-02],
[7.07383610e-01,6.94199324e-01,4.58106460e-02],
[7.07179168e-01,6.94532332e-01,4.61463921e-02],
[7.06974571e-01,6.94864453e-01,4.64854909e-02],
[7.06769821e-01,6.95195687e-01,4.68279629e-02],
[7.06564920e-01,6.95526038e-01,4.71738286e-02],
[7.06359869e-01,6.95855508e-01,4.75231086e-02],
[7.06154671e-01,6.96184098e-01,4.78758233e-02],
[7.05949326e-01,6.96511811e-01,4.82319933e-02],
[7.05743838e-01,6.96838648e-01,4.85916390e-02],
[7.05538207e-01,6.97164612e-01,4.89547807e-02],
[7.05332435e-01,6.97489705e-01,4.93214389e-02],
[7.05126525e-01,6.97813928e-01,4.96916339e-02],
[7.04920478e-01,6.98137284e-01,5.00653859e-02],
[7.04714297e-01,6.98459775e-01,5.04427154e-02],
[7.04507982e-01,6.98781403e-01,5.08236423e-02],
[7.04301536e-01,6.99102169e-01,5.12081870e-02],
[7.04094960e-01,6.99422077e-01,5.15963695e-02],
[7.03888257e-01,6.99741127e-01,5.19882098e-02],
[7.03681429e-01,7.00059322e-01,5.23837278e-02],
[7.03474477e-01,7.00376665e-01,5.27829436e-02],
[7.03267403e-01,7.00693156e-01,5.31858769e-02],
[7.03060209e-01,7.01008797e-01,5.35925474e-02],
[7.02852897e-01,7.01323592e-01,5.40029749e-02],
[7.02645468e-01,7.01637542e-01,5.44171789e-02],
[7.02437926e-01,7.01950648e-01,5.48351790e-02],
[7.02230271e-01,7.02262913e-01,5.52569945e-02],
[7.02022505e-01,7.02574340e-01,5.56826447e-02],
[7.01814631e-01,7.02884928e-01,5.61121489e-02],
[7.01606651e-01,7.03194682e-01,5.65455262e-02],
[7.01398565e-01,7.03503603e-01,5.69827955e-02],
[7.01190377e-01,7.03811692e-01,5.74239759e-02],
[7.00982088e-01,7.04118951e-01,5.78690859e-02],
[7.00773700e-01,7.04425384e-01,5.83181444e-02],
[7.00565215e-01,7.04730991e-01,5.87711698e-02],
[7.00356635e-01,7.05035774e-01,5.92281806e-02],
[7.00147962e-01,7.05339737e-01,5.96891950e-02],
[6.99939197e-01,7.05642879e-01,6.01542311e-02],
[6.99730344e-01,7.05945204e-01,6.06233070e-02],
[6.99521403e-01,7.06246713e-01,6.10964405e-02],
[6.99312377e-01,7.06547408e-01,6.15736494e-02],
[6.99103268e-01,7.06847292e-01,6.20549511e-02],
[6.98894077e-01,7.07146366e-01,6.25403631e-02],
[6.98684807e-01,7.07444631e-01,6.30299026e-02],
[6.98475460e-01,7.07742091e-01,6.35235868e-02],
[6.98266037e-01,7.08038747e-01,6.40214324e-02],
[6.98056542e-01,7.08334600e-01,6.45234563e-02],
[6.97846974e-01,7.08629653e-01,6.50296750e-02],
[6.97637337e-01,7.08923907e-01,6.55401049e-02],
[6.97427633e-01,7.09217365e-01,6.60547622e-02],
[6.97217864e-01,7.09510028e-01,6.65736629e-02],
[6.97008031e-01,7.09801899e-01,6.70968229e-02],
[6.96798137e-01,7.10092979e-01,6.76242577e-02],
[6.96588184e-01,7.10383269e-01,6.81559828e-02],
[6.96378173e-01,7.10672773e-01,6.86920133e-02],
[6.96168108e-01,7.10961491e-01,6.92323644e-02],
[6.95957989e-01,7.11249426e-01,6.97770508e-02],
[6.95747819e-01,7.11536580e-01,7.03260871e-02],
[6.95537600e-01,7.11822954e-01,7.08794877e-02],
[6.95327334e-01,7.12108550e-01,7.14372667e-02],
[6.95117022e-01,7.12393370e-01,7.19994381e-02],
[6.94906668e-01,7.12677416e-01,7.25660154e-02],
[6.94696274e-01,7.12960690e-01,7.31370123e-02],
[6.94485840e-01,7.13243194e-01,7.37124419e-02],
[6.94275370e-01,7.13524929e-01,7.42923171e-02],
[6.94064865e-01,7.13805897e-01,7.48766508e-02],
[6.93854327e-01,7.14086101e-01,7.54654554e-02],
[6.93643760e-01,7.14365541e-01,7.60587431e-02],
[6.93433163e-01,7.14644221e-01,7.66565259e-02],
[6.93222541e-01,7.14922140e-01,7.72588155e-02],
[6.93011894e-01,7.15199303e-01,7.78656234e-02],
[6.92801226e-01,7.15475709e-01,7.84769608e-02],
[6.92590537e-01,7.15751362e-01,7.90928386e-02],
[6.92379831e-01,7.16026262e-01,7.97132674e-02],
[6.92169109e-01,7.16300412e-01,8.03382576e-02],
[6.91958373e-01,7.16573814e-01,8.09678193e-02],
[6.91747626e-01,7.16846468e-01,8.16019623e-02],
[6.91536870e-01,7.17118378e-01,8.22406962e-02],
[6.91326107e-01,7.17389544e-01,8.28840301e-02],
[6.91115338e-01,7.17659969e-01,8.35319730e-02],
[6.90904567e-01,7.17929655e-01,8.41845336e-02],
[6.90693795e-01,7.18198602e-01,8.48417202e-02],
[6.90483024e-01,7.18466814e-01,8.55035409e-02],
[6.90272258e-01,7.18734290e-01,8.61700034e-02],
[6.90061496e-01,7.19001035e-01,8.68411151e-02],
[6.89850743e-01,7.19267048e-01,8.75168833e-02],
[6.89640000e-01,7.19532333e-01,8.81973146e-02],
[6.89429269e-01,7.19796890e-01,8.88824157e-02],
[6.89218553e-01,7.20060721e-01,8.95721926e-02],
[6.89007853e-01,7.20323829e-01,9.02666514e-02],
[6.88797172e-01,7.20586214e-01,9.09657974e-02],
[6.88586513e-01,7.20847879e-01,9.16696360e-02],
[6.88375876e-01,7.21108825e-01,9.23781721e-02],
[6.88165265e-01,7.21369055e-01,9.30914102e-02],
[6.87954682e-01,7.21628569e-01,9.38093545e-02],
[6.87744128e-01,7.21887369e-01,9.45320090e-02],
[6.87533607e-01,7.22145458e-01,9.52593772e-02],
[6.87323120e-01,7.22402836e-01,9.59914624e-02],
[6.87112670e-01,7.22659506e-01,9.67282674e-02],
[6.86902258e-01,7.22915469e-01,9.74697949e-02],
[6.86691887e-01,7.23170728e-01,9.82160469e-02],
[6.86481560e-01,7.23425282e-01,9.89670255e-02],
[6.86271278e-01,7.23679136e-01,9.97227320e-02],
[6.86061044e-01,7.23932289e-01,1.00483168e-01],
[6.85850860e-01,7.24184744e-01,1.01248333e-01],
[6.85640728e-01,7.24436502e-01,1.02018229e-01],
[6.85430651e-01,7.24687565e-01,1.02792856e-01],
[6.85220631e-01,7.24937935e-01,1.03572213e-01],
[6.85010669e-01,7.25187613e-01,1.04356300e-01],
[6.84800770e-01,7.25436601e-01,1.05145115e-01],
[6.84590933e-01,7.25684900e-01,1.05938659e-01],
[6.84381163e-01,7.25932513e-01,1.06736927e-01],
[6.84171461e-01,7.26179441e-01,1.07539920e-01],
[6.83961829e-01,7.26425686e-01,1.08347634e-01],
[6.83752270e-01,7.26671248e-01,1.09160067e-01],
[6.83542786e-01,7.26916131e-01,1.09977215e-01],
[6.83333380e-01,7.27160334e-01,1.10799075e-01],
[6.83124054e-01,7.27403861e-01,1.11625644e-01],
[6.82914809e-01,7.27646713e-01,1.12456916e-01],
[6.82705649e-01,7.27888890e-01,1.13292888e-01],
[6.82496575e-01,7.28130396e-01,1.14133555e-01],
[6.82287591e-01,7.28371231e-01,1.14978911e-01],
[6.82078698e-01,7.28611397e-01,1.15828950e-01],
[6.81869898e-01,7.28850896e-01,1.16683667e-01],
[6.81661195e-01,7.29089729e-01,1.17543056e-01],
[6.81452590e-01,7.29327898e-01,1.18407108e-01],
[6.81244086e-01,7.29565404e-01,1.19275818e-01],
[6.81035685e-01,7.29802250e-01,1.20149178e-01],
[6.80827389e-01,7.30038436e-01,1.21027180e-01],
[6.80619201e-01,7.30273964e-01,1.21909815e-01],
[6.80411123e-01,7.30508836e-01,1.22797076e-01],
[6.80203158e-01,7.30743053e-01,1.23688952e-01],
[6.79995308e-01,7.30976617e-01,1.24585436e-01],
[6.79787575e-01,7.31209529e-01,1.25486517e-01],
[6.79579962e-01,7.31441791e-01,1.26392185e-01],
[6.79372471e-01,7.31673405e-01,1.27302430e-01],
[6.79165104e-01,7.31904372e-01,1.28217241e-01],
[6.78957864e-01,7.32134693e-01,1.29136607e-01],
[6.78750754e-01,7.32364370e-01,1.30060517e-01],
[6.78543775e-01,7.32593406e-01,1.30988958e-01],
[6.78336930e-01,7.32821800e-01,1.31921918e-01],
[6.78130222e-01,7.33049554e-01,1.32859386e-01],
[6.77923653e-01,7.33276671e-01,1.33801347e-01],
[6.77717225e-01,7.33503152e-01,1.34747789e-01],
[6.77510941e-01,7.33728998e-01,1.35698698e-01],
[6.77304803e-01,7.33954211e-01,1.36654060e-01],
[6.77098814e-01,7.34178791e-01,1.37613861e-01],
[6.76892976e-01,7.34402742e-01,1.38578086e-01],
[6.76687291e-01,7.34626063e-01,1.39546721e-01],
[6.76481763e-01,7.34848758e-01,1.40519749e-01],
[6.76276393e-01,7.35070826e-01,1.41497155e-01],
[6.76071184e-01,7.35292270e-01,1.42478923e-01],
[6.75866138e-01,7.35513091e-01,1.43465038e-01],
[6.75661258e-01,7.35733291e-01,1.44455481e-01],
[6.75456546e-01,7.35952871e-01,1.45450236e-01],
[6.75252006e-01,7.36171832e-01,1.46449285e-01],
[6.75047638e-01,7.36390176e-01,1.47452612e-01],
[6.74843446e-01,7.36607905e-01,1.48460197e-01],
[6.74639433e-01,7.36825020e-01,1.49472023e-01],
[6.74435600e-01,7.37041522e-01,1.50488071e-01],
[6.74231951e-01,7.37257412e-01,1.51508321e-01],
[6.74028487e-01,7.37472693e-01,1.52532755e-01],
[6.73825211e-01,7.37687365e-01,1.53561353e-01],
[6.73622127e-01,7.37901431e-01,1.54594095e-01],
[6.73419235e-01,7.38114891e-01,1.55630960e-01],
[6.73216539e-01,7.38327747e-01,1.56671928e-01],
[6.73014042e-01,7.38540000e-01,1.57716978e-01],
[6.72811745e-01,7.38751652e-01,1.58766090e-01],
[6.72609652e-01,7.38962704e-01,1.59819240e-01],
[6.72407765e-01,7.39173157e-01,1.60876409e-01],
[6.72206086e-01,7.39383014e-01,1.61937573e-01],
[6.72004618e-01,7.39592275e-01,1.63002710e-01],
[6.71803364e-01,7.39800942e-01,1.64071798e-01],
[6.71602326e-01,7.40009015e-01,1.65144813e-01],
[6.71401507e-01,7.40216498e-01,1.66221732e-01],
[6.71200908e-01,7.40423390e-01,1.67302533e-01],
[6.71000534e-01,7.40629693e-01,1.68387190e-01],
[6.70800386e-01,7.40835410e-01,1.69475680e-01],
[6.70600466e-01,7.41040540e-01,1.70567980e-01],
[6.70400779e-01,7.41245085e-01,1.71664063e-01],
[6.70201325e-01,7.41449048e-01,1.72763905e-01],
[6.70002108e-01,7.41652428e-01,1.73867481e-01],
[6.69803130e-01,7.41855228e-01,1.74974766e-01],
[6.69604395e-01,7.42057449e-01,1.76085734e-01],
[6.69405903e-01,7.42259092e-01,1.77200359e-01],
[6.69207659e-01,7.42460158e-01,1.78318615e-01],
[6.69009664e-01,7.42660649e-01,1.79440476e-01],
[6.68811922e-01,7.42860566e-01,1.80565914e-01],
[6.68614434e-01,7.43059911e-01,1.81694904e-01],
[6.68417204e-01,7.43258685e-01,1.82827418e-01],
[6.68220235e-01,7.43456889e-01,1.83963428e-01],
[6.68023528e-01,7.43654524e-01,1.85102908e-01],
[6.67827086e-01,7.43851592e-01,1.86245829e-01],
[6.67630912e-01,7.44048095e-01,1.87392164e-01],
[6.67435009e-01,7.44244032e-01,1.88541884e-01],
[6.67239380e-01,7.44439407e-01,1.89694961e-01],
[6.67044026e-01,7.44634219e-01,1.90851366e-01],
[6.66848951e-01,7.44828471e-01,1.92011070e-01],
[6.66654157e-01,7.45022163e-01,1.93174045e-01],
[6.66459647e-01,7.45215297e-01,1.94340262e-01],
[6.66265424e-01,7.45407875e-01,1.95509690e-01],
[6.66071490e-01,7.45599896e-01,1.96682300e-01],
[6.65877848e-01,7.45791364e-01,1.97858063e-01],
[6.65684501e-01,7.45982279e-01,1.99036948e-01],
[6.65491450e-01,7.46172641e-01,2.00218926e-01],
[6.65298700e-01,7.46362454e-01,2.01403966e-01],
[6.65106253e-01,7.46551717e-01,2.02592037e-01],
[6.64914111e-01,7.46740432e-01,2.03783110e-01],
[6.64722277e-01,7.46928601e-01,2.04977153e-01],
[6.64530754e-01,7.47116224e-01,2.06174135e-01],
[6.64339544e-01,7.47303303e-01,2.07374025e-01],
[6.64148650e-01,7.47489839e-01,2.08576793e-01],
[6.63958076e-01,7.47675833e-01,2.09782406e-01],
[6.63767823e-01,7.47861287e-01,2.10990833e-01],
[6.63577894e-01,7.48046201e-01,2.12202042e-01],
[6.63388293e-01,7.48230578e-01,2.13416003e-01],
[6.63199021e-01,7.48414417e-01,2.14632682e-01],
[6.63010081e-01,7.48597722e-01,2.15852047e-01],
[6.62821478e-01,7.48780492e-01,2.17074067e-01],
[6.62633212e-01,7.48962728e-01,2.18298710e-01],
[6.62445286e-01,7.49144433e-01,2.19525942e-01],
[6.62257705e-01,7.49325607e-01,2.20755732e-01],
[6.62070469e-01,7.49506252e-01,2.21988046e-01],
[6.61883583e-01,7.49686368e-01,2.23222853e-01],
[6.61697048e-01,7.49865957e-01,2.24460119e-01],
[6.61510868e-01,7.50045020e-01,2.25699811e-01],
[6.61325045e-01,7.50223559e-01,2.26941896e-01],
[6.61139582e-01,7.50401573e-01,2.28186342e-01],
[6.60954483e-01,7.50579066e-01,2.29433116e-01],
[6.60769748e-01,7.50756037e-01,2.30682183e-01],
[6.60585383e-01,7.50932489e-01,2.31933511e-01],
[6.60401388e-01,7.51108421e-01,2.33187066e-01],
[6.60217768e-01,7.51283836e-01,2.34442815e-01],
[6.60034524e-01,7.51458734e-01,2.35700725e-01],
[6.59851660e-01,7.51633117e-01,2.36960762e-01],
[6.59669178e-01,7.51806985e-01,2.38222892e-01],
[6.59487082e-01,7.51980341e-01,2.39487081e-01],
[6.59305373e-01,7.52153185e-01,2.40753297e-01],
[6.59124056e-01,7.52325518e-01,2.42021505e-01],
[6.58943132e-01,7.52497341e-01,2.43291671e-01],
[6.58762605e-01,7.52668656e-01,2.44563763e-01],
[6.58582477e-01,7.52839463e-01,2.45837745e-01],
[6.58402751e-01,7.53009764e-01,2.47113584e-01],
[6.58223430e-01,7.53179560e-01,2.48391246e-01],
[6.58044517e-01,7.53348853e-01,2.49670698e-01],
[6.57866014e-01,7.53517642e-01,2.50951904e-01],
[6.57687925e-01,7.53685929e-01,2.52234833e-01],
[6.57510253e-01,7.53853716e-01,2.53519448e-01],
[6.57333000e-01,7.54021004e-01,2.54805718e-01],
[6.57156168e-01,7.54187793e-01,2.56093607e-01],
[6.56979762e-01,7.54354085e-01,2.57383081e-01],
[6.56803784e-01,7.54519880e-01,2.58674107e-01],
[6.56628236e-01,7.54685181e-01,2.59966651e-01],
[6.56453121e-01,7.54849987e-01,2.61260679e-01],
[6.56278443e-01,7.55014301e-01,2.62556157e-01],
[6.56104205e-01,7.55178123e-01,2.63853051e-01],
[6.55930408e-01,7.55341453e-01,2.65151327e-01],
[6.55757057e-01,7.55504295e-01,2.66450952e-01],
[6.55584153e-01,7.55666648e-01,2.67751891e-01],
[6.55411701e-01,7.55828513e-01,2.69054111e-01],
[6.55239702e-01,7.55989892e-01,2.70357579e-01],
[6.55068160e-01,7.56150785e-01,2.71662259e-01],
[6.54897077e-01,7.56311194e-01,2.72968120e-01],
[6.54726457e-01,7.56471120e-01,2.74275126e-01],
[6.54556302e-01,7.56630563e-01,2.75583245e-01],
[6.54386615e-01,7.56789526e-01,2.76892444e-01],
[6.54217400e-01,7.56948008e-01,2.78202687e-01],
[6.54048658e-01,7.57106012e-01,2.79513944e-01],
[6.53880394e-01,7.57263537e-01,2.80826179e-01],
[6.53712609e-01,7.57420585e-01,2.82139359e-01],
[6.53545308e-01,7.57577158e-01,2.83453452e-01],
[6.53378492e-01,7.57733255e-01,2.84768425e-01],
[6.53212165e-01,7.57888879e-01,2.86084244e-01],
[6.53046330e-01,7.58044030e-01,2.87400875e-01],
[6.52880989e-01,7.58198709e-01,2.88718288e-01],
[6.52716146e-01,7.58352917e-01,2.90036447e-01],
[6.52551803e-01,7.58506656e-01,2.91355322e-01],
[6.52387964e-01,7.58659925e-01,2.92674878e-01],
[6.52224631e-01,7.58812727e-01,2.93995084e-01],
[6.52061808e-01,7.58965062e-01,2.95315907e-01],
[6.51899497e-01,7.59116932e-01,2.96637315e-01],
[6.51737701e-01,7.59268337e-01,2.97959275e-01],
[6.51576424e-01,7.59419278e-01,2.99281755e-01],
[6.51415667e-01,7.59569756e-01,3.00604723e-01],
[6.51255435e-01,7.59719772e-01,3.01928147e-01],
[6.51095731e-01,7.59869328e-01,3.03251996e-01],
[6.50936556e-01,7.60018424e-01,3.04576236e-01],
[6.50777915e-01,7.60167061e-01,3.05900838e-01],
[6.50619809e-01,7.60315241e-01,3.07225768e-01],
[6.50462243e-01,7.60462963e-01,3.08550996e-01],
[6.50305219e-01,7.60610230e-01,3.09876491e-01],
[6.50148740e-01,7.60757042e-01,3.11202220e-01],
[6.49992809e-01,7.60903400e-01,3.12528154e-01],
[6.49837429e-01,7.61049304e-01,3.13854261e-01],
[6.49682604e-01,7.61194757e-01,3.15180510e-01],
[6.49528335e-01,7.61339759e-01,3.16506870e-01],
[6.49374627e-01,7.61484311e-01,3.17833312e-01],
[6.49221481e-01,7.61628414e-01,3.19159804e-01],
[6.49068902e-01,7.61772068e-01,3.20486316e-01],
[6.48916892e-01,7.61915276e-01,3.21812818e-01],
[6.48765454e-01,7.62058037e-01,3.23139281e-01],
[6.48614591e-01,7.62200352e-01,3.24465673e-01],
[6.48464306e-01,7.62342223e-01,3.25791965e-01],
[6.48314603e-01,7.62483651e-01,3.27118129e-01],
[6.48165484e-01,7.62624636e-01,3.28444133e-01],
[6.48016952e-01,7.62765180e-01,3.29769949e-01],
[6.47869011e-01,7.62905283e-01,3.31095548e-01],
[6.47721662e-01,7.63044946e-01,3.32420901e-01],
[6.47574910e-01,7.63184170e-01,3.33745978e-01],
[6.47428758e-01,7.63322957e-01,3.35070751e-01],
[6.47283208e-01,7.63461306e-01,3.36395192e-01],
[6.47138263e-01,7.63599219e-01,3.37719271e-01],
[6.46993927e-01,7.63736697e-01,3.39042961e-01],
[6.46850203e-01,7.63873741e-01,3.40366234e-01],
[6.46707093e-01,7.64010351e-01,3.41689061e-01],
[6.46564601e-01,7.64146529e-01,3.43011416e-01],
[6.46422729e-01,7.64282275e-01,3.44333269e-01],
[6.46281482e-01,7.64417591e-01,3.45654594e-01],
[6.46140861e-01,7.64552477e-01,3.46975363e-01],
[6.46000870e-01,7.64686934e-01,3.48295550e-01],
[6.45861512e-01,7.64820963e-01,3.49615127e-01],
[6.45722790e-01,7.64954564e-01,3.50934067e-01],
[6.45584706e-01,7.65087740e-01,3.52252344e-01],
[6.45447265e-01,7.65220490e-01,3.53569932e-01],
[6.45310470e-01,7.65352815e-01,3.54886803e-01],
[6.45174322e-01,7.65484717e-01,3.56202932e-01],
[6.45038826e-01,7.65616196e-01,3.57518293e-01],
[6.44903984e-01,7.65747253e-01,3.58832860e-01],
[6.44769799e-01,7.65877889e-01,3.60146608e-01],
[6.44636275e-01,7.66008105e-01,3.61459511e-01],
[6.44503415e-01,7.66137902e-01,3.62771543e-01],
[6.44371221e-01,7.66267280e-01,3.64082680e-01],
[6.44239697e-01,7.66396241e-01,3.65392897e-01],
[6.44108846e-01,7.66524784e-01,3.66702169e-01],
[6.43978670e-01,7.66652912e-01,3.68010471e-01],
[6.43849174e-01,7.66780625e-01,3.69317780e-01],
[6.43720360e-01,7.66907924e-01,3.70624070e-01],
[6.43592230e-01,7.67034809e-01,3.71929318e-01],
[6.43464789e-01,7.67161281e-01,3.73233500e-01],
[6.43338039e-01,7.67287342e-01,3.74536593e-01],
[6.43211983e-01,7.67412992e-01,3.75838572e-01],
[6.43086625e-01,7.67538232e-01,3.77139415e-01],
[6.42961967e-01,7.67663063e-01,3.78439098e-01],
[6.42838013e-01,7.67787485e-01,3.79737599e-01],
[6.42714766e-01,7.67911500e-01,3.81034894e-01],
[6.42592228e-01,7.68035107e-01,3.82330962e-01],
[6.42470403e-01,7.68158309e-01,3.83625780e-01],
[6.42349294e-01,7.68281106e-01,3.84919325e-01],
[6.42228904e-01,7.68403499e-01,3.86211576e-01],
[6.42109235e-01,7.68525488e-01,3.87502510e-01],
[6.41990292e-01,7.68647074e-01,3.88792107e-01],
[6.41872078e-01,7.68768258e-01,3.90080344e-01],
[6.41754594e-01,7.68889041e-01,3.91367201e-01],
[6.41637845e-01,7.69009424e-01,3.92652656e-01],
[6.41521833e-01,7.69129407e-01,3.93936688e-01],
[6.41406562e-01,7.69248992e-01,3.95219278e-01],
[6.41292035e-01,7.69368179e-01,3.96500403e-01],
[6.41178254e-01,7.69486968e-01,3.97780044e-01],
[6.41065223e-01,7.69605361e-01,3.99058181e-01],
[6.40952945e-01,7.69723359e-01,4.00334794e-01],
[6.40841423e-01,7.69840962e-01,4.01609862e-01],
[6.40730659e-01,7.69958171e-01,4.02883367e-01],
[6.40620658e-01,7.70074986e-01,4.04155289e-01],
[6.40511422e-01,7.70191409e-01,4.05425608e-01],
[6.40402954e-01,7.70307441e-01,4.06694306e-01],
[6.40295258e-01,7.70423081e-01,4.07961364e-01],
[6.40188335e-01,7.70538331e-01,4.09226763e-01],
[6.40082191e-01,7.70653192e-01,4.10490485e-01],
[6.39976826e-01,7.70767664e-01,4.11752511e-01],
[6.39872246e-01,7.70881749e-01,4.13012823e-01],
[6.39768452e-01,7.70995446e-01,4.14271403e-01],
[6.39665447e-01,7.71108757e-01,4.15528234e-01],
[6.39563236e-01,7.71221682e-01,4.16783299e-01],
[6.39461820e-01,7.71334223e-01,4.18036578e-01],
[6.39361203e-01,7.71446379e-01,4.19288056e-01],
[6.39261388e-01,7.71558152e-01,4.20537716e-01],
[6.39162378e-01,7.71669542e-01,4.21785540e-01],
[6.39064176e-01,7.71780550e-01,4.23031512e-01],
[6.38966785e-01,7.71891178e-01,4.24275615e-01],
[6.38870208e-01,7.72001425e-01,4.25517834e-01],
[6.38774449e-01,7.72111292e-01,4.26758151e-01],
[6.38679509e-01,7.72220780e-01,4.27996552e-01],
[6.38585393e-01,7.72329890e-01,4.29233020e-01],
[6.38492104e-01,7.72438623e-01,4.30467541e-01],
[6.38399643e-01,7.72546978e-01,4.31700097e-01],
[6.38308015e-01,7.72654958e-01,4.32930675e-01],
[6.38217222e-01,7.72762563e-01,4.34159259e-01],
[6.38127268e-01,7.72869792e-01,4.35385835e-01],
[6.38038155e-01,7.72976648e-01,4.36610388e-01],
[6.37949887e-01,7.73083131e-01,4.37832902e-01],
[6.37862466e-01,7.73189241e-01,4.39053365e-01],
[6.37775895e-01,7.73294980e-01,4.40271762e-01],
[6.37690178e-01,7.73400347e-01,4.41488078e-01],
[6.37605317e-01,7.73505345e-01,4.42702301e-01],
[6.37521316e-01,7.73609972e-01,4.43914416e-01],
[6.37438178e-01,7.73714231e-01,4.45124410e-01],
[6.37355905e-01,7.73818121e-01,4.46332270e-01],
[6.37274500e-01,7.73921644e-01,4.47537982e-01],
[6.37193967e-01,7.74024800e-01,4.48741535e-01],
[6.37114308e-01,7.74127590e-01,4.49942914e-01],
[6.37035527e-01,7.74230015e-01,4.51142108e-01],
[6.36957626e-01,7.74332074e-01,4.52339104e-01],
[6.36880608e-01,7.74433770e-01,4.53533890e-01],
[6.36804477e-01,7.74535102e-01,4.54726453e-01],
[6.36729235e-01,7.74636072e-01,4.55916782e-01],
[6.36654885e-01,7.74736679e-01,4.57104866e-01],
[6.36581431e-01,7.74836925e-01,4.58290692e-01],
[6.36508874e-01,7.74936811e-01,4.59474249e-01],
[6.36437219e-01,7.75036336e-01,4.60655525e-01],
[6.36366467e-01,7.75135502e-01,4.61834511e-01],
[6.36296623e-01,7.75234310e-01,4.63011195e-01],
[6.36227688e-01,7.75332759e-01,4.64185565e-01],
[6.36159666e-01,7.75430851e-01,4.65357612e-01],
[6.36092559e-01,7.75528587e-01,4.66527326e-01],
[6.36026371e-01,7.75625966e-01,4.67694695e-01],
[6.35961105e-01,7.75722990e-01,4.68859710e-01],
[6.35896763e-01,7.75819660e-01,4.70022360e-01],
[6.35833348e-01,7.75915975e-01,4.71182637e-01],
[6.35770863e-01,7.76011937e-01,4.72340530e-01],
[6.35709311e-01,7.76107547e-01,4.73496030e-01],
[6.35648695e-01,7.76202804e-01,4.74649127e-01],
[6.35589018e-01,7.76297710e-01,4.75799812e-01],
[6.35530282e-01,7.76392265e-01,4.76948077e-01],
[6.35472490e-01,7.76486470e-01,4.78093913e-01],
[6.35415646e-01,7.76580326e-01,4.79237310e-01],
[6.35359752e-01,7.76673833e-01,4.80378260e-01],
[6.35304810e-01,7.76766991e-01,4.81516755e-01],
[6.35250825e-01,7.76859802e-01,4.82652786e-01],
[6.35197797e-01,7.76952266e-01,4.83786346e-01],
[6.35145731e-01,7.77044384e-01,4.84917426e-01],
[6.35094629e-01,7.77136156e-01,4.86046019e-01],
[6.35044494e-01,7.77227583e-01,4.87172116e-01],
[6.34995329e-01,7.77318666e-01,4.88295711e-01],
[6.34947135e-01,7.77409405e-01,4.89416796e-01],
[6.34899917e-01,7.77499801e-01,4.90535363e-01],
[6.34853677e-01,7.77589854e-01,4.91651406e-01],
[6.34808418e-01,7.77679566e-01,4.92764918e-01],
[6.34764141e-01,7.77768936e-01,4.93875891e-01],
[6.34720851e-01,7.77857965e-01,4.94984319e-01],
[6.34678550e-01,7.77946655e-01,4.96090196e-01],
[6.34637240e-01,7.78035005e-01,4.97193514e-01],
[6.34596924e-01,7.78123016e-01,4.98294269e-01],
[6.34557605e-01,7.78210689e-01,4.99392453e-01],
[6.34519285e-01,7.78298025e-01,5.00488061e-01],
[6.34481968e-01,7.78385023e-01,5.01581086e-01],
[6.34445656e-01,7.78471685e-01,5.02671524e-01],
[6.34410351e-01,7.78558012e-01,5.03759367e-01],
[6.34376056e-01,7.78644003e-01,5.04844612e-01],
[6.34342773e-01,7.78729660e-01,5.05927252e-01],
[6.34310507e-01,7.78814982e-01,5.07007283e-01],
[6.34279258e-01,7.78899972e-01,5.08084698e-01],
[6.34249029e-01,7.78984628e-01,5.09159494e-01],
[6.34219824e-01,7.79068953e-01,5.10231665e-01],
[6.34191644e-01,7.79152946e-01,5.11301207e-01],
[6.34164493e-01,7.79236607e-01,5.12368114e-01],
[6.34138372e-01,7.79319939e-01,5.13432383e-01],
[6.34113284e-01,7.79402940e-01,5.14494010e-01],
[6.34089233e-01,7.79485613e-01,5.15552989e-01],
[6.34066219e-01,7.79567957e-01,5.16609317e-01],
[6.34044247e-01,7.79649972e-01,5.17662990e-01],
[6.34023318e-01,7.79731661e-01,5.18714003e-01],
[6.34003434e-01,7.79813022e-01,5.19762354e-01],
[6.33984599e-01,7.79894057e-01,5.20808039e-01],
[6.33966814e-01,7.79974767e-01,5.21851053e-01],
[6.33950083e-01,7.80055151e-01,5.22891393e-01],
[6.33934406e-01,7.80135210e-01,5.23929057e-01],
[6.33919788e-01,7.80214946e-01,5.24964041e-01],
[6.33906230e-01,7.80294358e-01,5.25996342e-01],
[6.33893735e-01,7.80373448e-01,5.27025957e-01],
[6.33882305e-01,7.80452215e-01,5.28052883e-01],
[6.33871942e-01,7.80530660e-01,5.29077117e-01],
[6.33862649e-01,7.80608784e-01,5.30098657e-01],
[6.33854429e-01,7.80686588e-01,5.31117500e-01],
[6.33847282e-01,7.80764071e-01,5.32133644e-01],
[6.33841212e-01,7.80841235e-01,5.33147086e-01],
[6.33836221e-01,7.80918081e-01,5.34157824e-01],
[6.33832311e-01,7.80994607e-01,5.35165857e-01],
[6.33829485e-01,7.81070817e-01,5.36171181e-01],
[6.33827744e-01,7.81146708e-01,5.37173795e-01],
[6.33827091e-01,7.81222284e-01,5.38173698e-01],
[6.33827529e-01,7.81297543e-01,5.39170887e-01],
[6.33829058e-01,7.81372486e-01,5.40165360e-01],
[6.33831682e-01,7.81447114e-01,5.41157117e-01],
[6.33835403e-01,7.81521428e-01,5.42146156e-01],
[6.33840223e-01,7.81595428e-01,5.43132476e-01],
[6.33846143e-01,7.81669115e-01,5.44116075e-01],
[6.33853166e-01,7.81742489e-01,5.45096952e-01],
[6.33861295e-01,7.81815551e-01,5.46075106e-01],
[6.33870530e-01,7.81888300e-01,5.47050536e-01],
[6.33880875e-01,7.81960739e-01,5.48023242e-01],
[6.33892331e-01,7.82032867e-01,5.48993222e-01],
[6.33904900e-01,7.82104685e-01,5.49960476e-01],
[6.33918585e-01,7.82176193e-01,5.50925003e-01],
[6.33933387e-01,7.82247392e-01,5.51886802e-01],
[6.33949308e-01,7.82318283e-01,5.52845874e-01],
[6.33966350e-01,7.82388866e-01,5.53802218e-01],
[6.33984515e-01,7.82459141e-01,5.54755833e-01],
[6.34003806e-01,7.82529109e-01,5.55706719e-01],
[6.34024223e-01,7.82598771e-01,5.56654877e-01],
[6.34045769e-01,7.82668127e-01,5.57600307e-01],
[6.34068446e-01,7.82737178e-01,5.58543007e-01],
[6.34092255e-01,7.82805924e-01,5.59482979e-01],
[6.34117199e-01,7.82874366e-01,5.60420223e-01],
[6.34143279e-01,7.82942504e-01,5.61354739e-01],
[6.34170497e-01,7.83010339e-01,5.62286527e-01],
[6.34198854e-01,7.83077871e-01,5.63215588e-01],
[6.34228353e-01,7.83145101e-01,5.64141922e-01],
[6.34258995e-01,7.83212029e-01,5.65065531e-01],
[6.34290782e-01,7.83278656e-01,5.65986414e-01],
[6.34323715e-01,7.83344982e-01,5.66904573e-01],
[6.34357797e-01,7.83411009e-01,5.67820007e-01],
[6.34393028e-01,7.83476735e-01,5.68732719e-01],
[6.34429411e-01,7.83542163e-01,5.69642710e-01],
[6.34466947e-01,7.83607292e-01,5.70549979e-01],
[6.34505638e-01,7.83672123e-01,5.71454529e-01],
[6.34545485e-01,7.83736657e-01,5.72356360e-01],
[6.34586489e-01,7.83800893e-01,5.73255474e-01],
[6.34628653e-01,7.83864833e-01,5.74151872e-01],
[6.34671978e-01,7.83928477e-01,5.75045555e-01],
[6.34716465e-01,7.83991826e-01,5.75936525e-01],
[6.34762115e-01,7.84054879e-01,5.76824784e-01],
[6.34808931e-01,7.84117638e-01,5.77710333e-01],
[6.34856913e-01,7.84180104e-01,5.78593173e-01],
[6.34906064e-01,7.84242275e-01,5.79473306e-01],
[6.34956383e-01,7.84304154e-01,5.80350735e-01],
[6.35007873e-01,7.84365740e-01,5.81225461e-01],
[6.35060535e-01,7.84427034e-01,5.82097485e-01],
[6.35114371e-01,7.84488036e-01,5.82966810e-01],
[6.35169380e-01,7.84548748e-01,5.83833438e-01],
[6.35225566e-01,7.84609169e-01,5.84697370e-01],
[6.35282928e-01,7.84669300e-01,5.85558610e-01],
[6.35341469e-01,7.84729142e-01,5.86417159e-01],
[6.35401189e-01,7.84788695e-01,5.87273019e-01],
[6.35462090e-01,7.84847959e-01,5.88126192e-01],
[6.35524172e-01,7.84906935e-01,5.88976682e-01],
[6.35587437e-01,7.84965624e-01,5.89824490e-01],
[6.35651886e-01,7.85024026e-01,5.90669619e-01],
[6.35717519e-01,7.85082141e-01,5.91512071e-01],
[6.35784339e-01,7.85139970e-01,5.92351849e-01],
[6.35852345e-01,7.85197513e-01,5.93188955e-01],
[6.35921539e-01,7.85254772e-01,5.94023392e-01],
[6.35991923e-01,7.85311746e-01,5.94855164e-01],
[6.36063496e-01,7.85368435e-01,5.95684272e-01],
[6.36136259e-01,7.85424842e-01,5.96510719e-01],
[6.36210215e-01,7.85480965e-01,5.97334509e-01],
[6.36285362e-01,7.85536805e-01,5.98155643e-01],
[6.36361703e-01,7.85592363e-01,5.98974126e-01],
[6.36439238e-01,7.85647640e-01,5.99789960e-01],
[6.36517968e-01,7.85702635e-01,6.00603148e-01],
[6.36597893e-01,7.85757350e-01,6.01413693e-01],
[6.36679015e-01,7.85811784e-01,6.02221598e-01],
[6.36761333e-01,7.85865939e-01,6.03026866e-01],
[6.36844850e-01,7.85919814e-01,6.03829502e-01],
[6.36929564e-01,7.85973411e-01,6.04629507e-01],
[6.37015478e-01,7.86026729e-01,6.05426885e-01],
[6.37102591e-01,7.86079770e-01,6.06221640e-01],
[6.37190904e-01,7.86132533e-01,6.07013775e-01],
[6.37280418e-01,7.86185019e-01,6.07803293e-01],
[6.37371133e-01,7.86237229e-01,6.08590198e-01],
[6.37463049e-01,7.86289163e-01,6.09374493e-01],
[6.37556168e-01,7.86340821e-01,6.10156182e-01],
[6.37650489e-01,7.86392205e-01,6.10935268e-01],
[6.37746013e-01,7.86443314e-01,6.11711754e-01],
[6.37842740e-01,7.86494148e-01,6.12485646e-01],
[6.37940670e-01,7.86544710e-01,6.13256945e-01],
[6.38039805e-01,7.86594998e-01,6.14025657e-01],
[6.38140144e-01,7.86645013e-01,6.14791784e-01],
[6.38241687e-01,7.86694757e-01,6.15555330e-01],
[6.38344435e-01,7.86744228e-01,6.16316300e-01],
[6.38448387e-01,7.86793429e-01,6.17074696e-01],
[6.38553545e-01,7.86842358e-01,6.17830524e-01],
[6.38659908e-01,7.86891017e-01,6.18583786e-01],
[6.38767476e-01,7.86939407e-01,6.19334487e-01],
[6.38876249e-01,7.86987527e-01,6.20082631e-01],
[6.38986228e-01,7.87035378e-01,6.20828221e-01],
[6.39097412e-01,7.87082961e-01,6.21571262e-01],
[6.39209802e-01,7.87130276e-01,6.22311757e-01],
[6.39323397e-01,7.87177323e-01,6.23049712e-01],
[6.39438197e-01,7.87224103e-01,6.23785129e-01],
[6.39554203e-01,7.87270617e-01,6.24518013e-01],
[6.39671413e-01,7.87316864e-01,6.25248369e-01],
[6.39789829e-01,7.87362846e-01,6.25976199e-01],
[6.39909449e-01,7.87408563e-01,6.26701510e-01],
[6.40030274e-01,7.87454015e-01,6.27424304e-01],
[6.40152303e-01,7.87499202e-01,6.28144586e-01],
[6.40275536e-01,7.87544126e-01,6.28862360e-01],
[6.40399972e-01,7.87588787e-01,6.29577631e-01],
[6.40525612e-01,7.87633184e-01,6.30290403e-01],
[6.40652455e-01,7.87677319e-01,6.31000680e-01],
[6.40780501e-01,7.87721192e-01,6.31708467e-01],
[6.40909748e-01,7.87764804e-01,6.32413767e-01],
[6.41040198e-01,7.87808154e-01,6.33116587e-01],
[6.41171848e-01,7.87851244e-01,6.33816929e-01],
[6.41304699e-01,7.87894074e-01,6.34514798e-01],
[6.41438750e-01,7.87936644e-01,6.35210199e-01],
[6.41574001e-01,7.87978955e-01,6.35903137e-01],
[6.41710450e-01,7.88021007e-01,6.36593615e-01],
[6.41848098e-01,7.88062800e-01,6.37281639e-01],
[6.41986943e-01,7.88104336e-01,6.37967213e-01],
[6.42126985e-01,7.88145615e-01,6.38650341e-01],
[6.42268223e-01,7.88186636e-01,6.39331028e-01],
[6.42410657e-01,7.88227401e-01,6.40009279e-01],
[6.42554285e-01,7.88267910e-01,6.40685098e-01],
[6.42699106e-01,7.88308163e-01,6.41358490e-01],
[6.42845121e-01,7.88348161e-01,6.42029460e-01],
[6.42992327e-01,7.88387904e-01,6.42698012e-01],
[6.43140724e-01,7.88427393e-01,6.43364151e-01],
[6.43290311e-01,7.88466629e-01,6.44027881e-01],
[6.43441087e-01,7.88505611e-01,6.44689208e-01],
[6.43593051e-01,7.88544340e-01,6.45348135e-01],
[6.43746202e-01,7.88582816e-01,6.46004669e-01],
[6.43900538e-01,7.88621041e-01,6.46658813e-01],
[6.44056059e-01,7.88659014e-01,6.47310572e-01],
[6.44212764e-01,7.88696736e-01,6.47959952e-01],
[6.44370651e-01,7.88734208e-01,6.48606956e-01],
[6.44529719e-01,7.88771429e-01,6.49251590e-01],
[6.44689966e-01,7.88808400e-01,6.49893858e-01],
[6.44851393e-01,7.88845122e-01,6.50533766e-01],
[6.45013996e-01,7.88881596e-01,6.51171318e-01],
[6.45177775e-01,7.88917821e-01,6.51806519e-01],
[6.45342729e-01,7.88953798e-01,6.52439373e-01],
[6.45508855e-01,7.88989528e-01,6.53069887e-01],
[6.45676153e-01,7.89025010e-01,6.53698063e-01],
[6.45844621e-01,7.89060246e-01,6.54323909e-01],
[6.46014258e-01,7.89095236e-01,6.54947427e-01],
[6.46185061e-01,7.89129980e-01,6.55568624e-01],
[6.46357030e-01,7.89164479e-01,6.56187504e-01],
[6.46530163e-01,7.89198734e-01,6.56804072e-01],
[6.46704458e-01,7.89232744e-01,6.57418332e-01],
[6.46879913e-01,7.89266510e-01,6.58030291e-01],
[6.47056527e-01,7.89300032e-01,6.58639953e-01],
[6.47234298e-01,7.89333312e-01,6.59247322e-01],
[6.47413224e-01,7.89366349e-01,6.59852404e-01],
[6.47593303e-01,7.89399144e-01,6.60455203e-01],
[6.47774534e-01,7.89431698e-01,6.61055725e-01],
[6.47956915e-01,7.89464010e-01,6.61653975e-01],
[6.48140443e-01,7.89496081e-01,6.62249957e-01],
[6.48325117e-01,7.89527913e-01,6.62843677e-01],
[6.48510935e-01,7.89559504e-01,6.63435139e-01],
[6.48697895e-01,7.89590856e-01,6.64024348e-01],
[6.48885994e-01,7.89621969e-01,6.64611310e-01],
[6.49075231e-01,7.89652844e-01,6.65196030e-01],
[6.49265604e-01,7.89683481e-01,6.65778511e-01],
[6.49457110e-01,7.89713880e-01,6.66358760e-01],
[6.49649748e-01,7.89744042e-01,6.66936782e-01],
[6.49843514e-01,7.89773967e-01,6.67512581e-01],
[6.50038407e-01,7.89803656e-01,6.68086162e-01],
[6.50234425e-01,7.89833110e-01,6.68657530e-01],
[6.50431565e-01,7.89862328e-01,6.69226691e-01],
[6.50629825e-01,7.89891311e-01,6.69793649e-01],
[6.50829202e-01,7.89920060e-01,6.70358410e-01],
[6.51029695e-01,7.89948575e-01,6.70920978e-01],
[6.51231300e-01,7.89976856e-01,6.71481358e-01],
[6.51434016e-01,7.90004904e-01,6.72039556e-01],
[6.51637839e-01,7.90032720e-01,6.72595576e-01],
[6.51842768e-01,7.90060303e-01,6.73149424e-01],
[6.52048799e-01,7.90087655e-01,6.73701104e-01],
[6.52255931e-01,7.90114776e-01,6.74250621e-01],
[6.52464160e-01,7.90141666e-01,6.74797981e-01],
[6.52673483e-01,7.90168325e-01,6.75343188e-01],
[6.52883899e-01,7.90194755e-01,6.75886247e-01],
[6.53095404e-01,7.90220955e-01,6.76427164e-01],
[6.53307996e-01,7.90246926e-01,6.76965944e-01],
[6.53521672e-01,7.90272669e-01,6.77502591e-01],
[6.53736429e-01,7.90298183e-01,6.78037110e-01],
[6.53952264e-01,7.90323471e-01,6.78569506e-01],
[6.54169174e-01,7.90348530e-01,6.79099785e-01],
[6.54387157e-01,7.90373364e-01,6.79627952e-01],
[6.54606210e-01,7.90397971e-01,6.80154010e-01],
[6.54826329e-01,7.90422352e-01,6.80677966e-01],
[6.55047511e-01,7.90446508e-01,6.81199825e-01],
[6.55269754e-01,7.90470439e-01,6.81719591e-01],
[6.55493055e-01,7.90494145e-01,6.82237268e-01],
[6.55717410e-01,7.90517628e-01,6.82752864e-01],
[6.55942816e-01,7.90540887e-01,6.83266381e-01],
[6.56169271e-01,7.90563923e-01,6.83777825e-01],
[6.56396770e-01,7.90586737e-01,6.84287202e-01],
[6.56625311e-01,7.90609328e-01,6.84794516e-01],
[6.56854891e-01,7.90631698e-01,6.85299771e-01],
[6.57085506e-01,7.90653847e-01,6.85802974e-01],
[6.57317153e-01,7.90675775e-01,6.86304128e-01],
[6.57549828e-01,7.90697482e-01,6.86803240e-01],
[6.57783529e-01,7.90718970e-01,6.87300313e-01],
[6.58018252e-01,7.90740239e-01,6.87795352e-01],
[6.58253993e-01,7.90761288e-01,6.88288364e-01],
[6.58490749e-01,7.90782119e-01,6.88779351e-01],
[6.58728516e-01,7.90802733e-01,6.89268320e-01],
[6.58967292e-01,7.90823129e-01,6.89755276e-01],
[6.59207072e-01,7.90843307e-01,6.90240222e-01],
[6.59447854e-01,7.90863270e-01,6.90723165e-01],
[6.59689632e-01,7.90883016e-01,6.91204108e-01],
[6.59932405e-01,7.90902546e-01,6.91683058e-01],
[6.60176167e-01,7.90921862e-01,6.92160018e-01],
[6.60420916e-01,7.90940962e-01,6.92634993e-01],
[6.60666648e-01,7.90959849e-01,6.93107989e-01],
[6.60913358e-01,7.90978521e-01,6.93579010e-01],
[6.61161044e-01,7.90996981e-01,6.94048061e-01],
[6.61409702e-01,7.91015228e-01,6.94515147e-01],
[6.61659327e-01,7.91033262e-01,6.94980272e-01],
[6.61909916e-01,7.91051084e-01,6.95443442e-01],
[6.62161465e-01,7.91068695e-01,6.95904662e-01],
[6.62413970e-01,7.91086096e-01,6.96363935e-01],
[6.62667427e-01,7.91103285e-01,6.96821267e-01],
[6.62921833e-01,7.91120265e-01,6.97276663e-01],
[6.63177183e-01,7.91137035e-01,6.97730128e-01],
[6.63433473e-01,7.91153597e-01,6.98181665e-01],
[6.63690699e-01,7.91169949e-01,6.98631281e-01],
[6.63948858e-01,7.91186094e-01,6.99078979e-01],
[6.64207945e-01,7.91202031e-01,6.99524764e-01],
[6.64467955e-01,7.91217761e-01,6.99968642e-01],
[6.64728886e-01,7.91233284e-01,7.00410616e-01],
[6.64990733e-01,7.91248602e-01,7.00850692e-01],
[6.65253491e-01,7.91263713e-01,7.01288875e-01],
[6.65517157e-01,7.91278619e-01,7.01725168e-01],
[6.65781725e-01,7.91293321e-01,7.02159577e-01],
[6.66047193e-01,7.91307819e-01,7.02592106e-01],
[6.66313556e-01,7.91322112e-01,7.03022760e-01],
[6.66580808e-01,7.91336203e-01,7.03451544e-01],
[6.66848947e-01,7.91350090e-01,7.03878461e-01],
[6.67117968e-01,7.91363776e-01,7.04303518e-01],
[6.67387866e-01,7.91377260e-01,7.04726719e-01],
[6.67658637e-01,7.91390542e-01,7.05148067e-01],
[6.67930277e-01,7.91403623e-01,7.05567568e-01],
[6.68202781e-01,7.91416505e-01,7.05985226e-01],
[6.68476145e-01,7.91429186e-01,7.06401046e-01],
[6.68750364e-01,7.91441668e-01,7.06815033e-01],
[6.69025434e-01,7.91453951e-01,7.07227191e-01],
[6.69301349e-01,7.91466036e-01,7.07637524e-01],
[6.69578107e-01,7.91477923e-01,7.08046037e-01],
[6.69855702e-01,7.91489613e-01,7.08452734e-01],
[6.70134129e-01,7.91501106e-01,7.08857621e-01],
[6.70413385e-01,7.91512402e-01,7.09260702e-01],
[6.70693463e-01,7.91523503e-01,7.09661980e-01],
[6.70974361e-01,7.91534408e-01,7.10061461e-01],
[6.71256072e-01,7.91545118e-01,7.10459149e-01],
[6.71538593e-01,7.91555634e-01,7.10855049e-01],
[6.71821918e-01,7.91565956e-01,7.11249165e-01],
[6.72106044e-01,7.91576085e-01,7.11641500e-01],
[6.72390964e-01,7.91586021e-01,7.12032061e-01],
[6.72676675e-01,7.91595765e-01,7.12420851e-01],
[6.72963172e-01,7.91605316e-01,7.12807874e-01],
[6.73250449e-01,7.91614677e-01,7.13193136e-01],
[6.73538503e-01,7.91623846e-01,7.13576640e-01],
[6.73827328e-01,7.91632825e-01,7.13958390e-01],
[6.74116919e-01,7.91641615e-01,7.14338392e-01],
[6.74407271e-01,7.91650215e-01,7.14716649e-01],
[6.74698380e-01,7.91658626e-01,7.15093166e-01],
[6.74990241e-01,7.91666849e-01,7.15467947e-01],
[6.75282849e-01,7.91674884e-01,7.15840996e-01],
[6.75576198e-01,7.91682732e-01,7.16212318e-01],
[6.75870285e-01,7.91690394e-01,7.16581917e-01],
[6.76165103e-01,7.91697869e-01,7.16949797e-01],
[6.76460648e-01,7.91705158e-01,7.17315962e-01],
[6.76756915e-01,7.91712263e-01,7.17680417e-01],
[6.77053899e-01,7.91719182e-01,7.18043166e-01],
[6.77351595e-01,7.91725918e-01,7.18404214e-01],
[6.77649997e-01,7.91732470e-01,7.18763563e-01],
[6.77949102e-01,7.91738838e-01,7.19121219e-01],
[6.78248903e-01,7.91745025e-01,7.19477186e-01],
[6.78549396e-01,7.91751029e-01,7.19831468e-01],
[6.78850575e-01,7.91756852e-01,7.20184068e-01],
[6.79152435e-01,7.91762494e-01,7.20534992e-01],
[6.79454972e-01,7.91767955e-01,7.20884243e-01],
[6.79758180e-01,7.91773236e-01,7.21231826e-01],
[6.80062054e-01,7.91778339e-01,7.21577744e-01],
[6.80366588e-01,7.91783262e-01,7.21922002e-01],
[6.80671778e-01,7.91788007e-01,7.22264603e-01],
[6.80977619e-01,7.91792574e-01,7.22605552e-01],
[6.81284104e-01,7.91796964e-01,7.22944853e-01],
[6.81591230e-01,7.91801177e-01,7.23282510e-01],
[6.81898990e-01,7.91805215e-01,7.23618527e-01],
[6.82207380e-01,7.91809076e-01,7.23952907e-01],
[6.82516394e-01,7.91812763e-01,7.24285655e-01],
[6.82826026e-01,7.91816275e-01,7.24616775e-01],
[6.83136273e-01,7.91819613e-01,7.24946271e-01],
[6.83447128e-01,7.91822778e-01,7.25274147e-01],
[6.83758586e-01,7.91825770e-01,7.25600407e-01],
[6.84070642e-01,7.91828589e-01,7.25925054e-01],
[6.84383290e-01,7.91831237e-01,7.26248092e-01],
[6.84696526e-01,7.91833714e-01,7.26569526e-01],
[6.85010343e-01,7.91836020e-01,7.26889360e-01],
[6.85324737e-01,7.91838156e-01,7.27207597e-01],
[6.85639701e-01,7.91840122e-01,7.27524240e-01],
[6.85955232e-01,7.91841920e-01,7.27839295e-01],
[6.86271323e-01,7.91843549e-01,7.28152765e-01],
[6.86587969e-01,7.91845010e-01,7.28464653e-01],
[6.86905165e-01,7.91846304e-01,7.28774963e-01],
[6.87222905e-01,7.91847431e-01,7.29083700e-01],
[6.87541184e-01,7.91848392e-01,7.29390867e-01],
[6.87859996e-01,7.91849187e-01,7.29696467e-01],
[6.88179337e-01,7.91849817e-01,7.30000505e-01],
[6.88499200e-01,7.91850283e-01,7.30302985e-01],
[6.88819580e-01,7.91850585e-01,7.30603909e-01],
[6.89140472e-01,7.91850724e-01,7.30903282e-01],
[6.89461870e-01,7.91850700e-01,7.31201107e-01],
[6.89783770e-01,7.91850514e-01,7.31497389e-01],
[6.90106165e-01,7.91850167e-01,7.31792130e-01],
[6.90429050e-01,7.91849658e-01,7.32085335e-01],
[6.90752419e-01,7.91848989e-01,7.32377006e-01],
[6.91076268e-01,7.91848160e-01,7.32667149e-01],
[6.91400590e-01,7.91847172e-01,7.32955766e-01],
[6.91725381e-01,7.91846025e-01,7.33242860e-01],
[6.92050635e-01,7.91844720e-01,7.33528437e-01],
[6.92376345e-01,7.91843258e-01,7.33812498e-01],
[6.92702508e-01,7.91841639e-01,7.34095048e-01],
[6.93029117e-01,7.91839864e-01,7.34376090e-01],
[6.93356167e-01,7.91837932e-01,7.34655628e-01],
[6.93683652e-01,7.91835846e-01,7.34933665e-01],
[6.94011568e-01,7.91833605e-01,7.35210205e-01],
[6.94339907e-01,7.91831211e-01,7.35485251e-01],
[6.94668666e-01,7.91828663e-01,7.35758807e-01],
[6.94997838e-01,7.91825962e-01,7.36030877e-01],
[6.95327419e-01,7.91823110e-01,7.36301462e-01],
[6.95657401e-01,7.91820105e-01,7.36570568e-01],
[6.95987781e-01,7.91816950e-01,7.36838198e-01],
[6.96318553e-01,7.91813645e-01,7.37104354e-01],
[6.96649711e-01,7.91810190e-01,7.37369041e-01],
[6.96981249e-01,7.91806586e-01,7.37632262e-01],
[6.97313162e-01,7.91802834e-01,7.37894020e-01],
[6.97645445e-01,7.91798933e-01,7.38154318e-01],
[6.97978093e-01,7.91794886e-01,7.38413160e-01],
[6.98311099e-01,7.91790692e-01,7.38670549e-01],
[6.98644458e-01,7.91786352e-01,7.38926488e-01],
[6.98978165e-01,7.91781866e-01,7.39180982e-01],
[6.99312214e-01,7.91777236e-01,7.39434032e-01],
[6.99646600e-01,7.91772462e-01,7.39685643e-01],
[6.99981318e-01,7.91767545e-01,7.39935817e-01],
[7.00316361e-01,7.91762485e-01,7.40184558e-01],
[7.00651725e-01,7.91757282e-01,7.40431869e-01],
[7.00987404e-01,7.91751938e-01,7.40677753e-01],
[7.01323392e-01,7.91746453e-01,7.40922214e-01],
[7.01659685e-01,7.91740828e-01,7.41165255e-01],
[7.01996276e-01,7.91735063e-01,7.41406878e-01],
[7.02333160e-01,7.91729159e-01,7.41647088e-01],
[7.02670332e-01,7.91723117e-01,7.41885886e-01],
[7.03007787e-01,7.91716937e-01,7.42123277e-01],
[7.03345518e-01,7.91710620e-01,7.42359263e-01],
[7.03683521e-01,7.91704166e-01,7.42593848e-01],
[7.04021790e-01,7.91697577e-01,7.42827035e-01],
[7.04360320e-01,7.91690853e-01,7.43058826e-01],
[7.04699105e-01,7.91683994e-01,7.43289225e-01],
[7.05038140e-01,7.91677002e-01,7.43518234e-01],
[7.05377419e-01,7.91669876e-01,7.43745858e-01],
[7.05716938e-01,7.91662618e-01,7.43972098e-01],
[7.06056690e-01,7.91655228e-01,7.44196959e-01],
[7.06396671e-01,7.91647707e-01,7.44420442e-01],
[7.06736875e-01,7.91640055e-01,7.44642552e-01],
[7.07077296e-01,7.91632274e-01,7.44863290e-01],
[7.07417930e-01,7.91624363e-01,7.45082660e-01],
[7.07758770e-01,7.91616324e-01,7.45300664e-01],
[7.08099813e-01,7.91608157e-01,7.45517307e-01],
[7.08441051e-01,7.91599864e-01,7.45732590e-01],
[7.08782481e-01,7.91591443e-01,7.45946517e-01],
[7.09124096e-01,7.91582897e-01,7.46159090e-01],
[7.09465892e-01,7.91574226e-01,7.46370312e-01],
[7.09807863e-01,7.91565430e-01,7.46580186e-01],
[7.10150004e-01,7.91556511e-01,7.46788716e-01],
[7.10492309e-01,7.91547469e-01,7.46995903e-01],
[7.10834774e-01,7.91538304e-01,7.47201751e-01],
[7.11177392e-01,7.91529018e-01,7.47406263e-01],
[7.11520160e-01,7.91519610e-01,7.47609441e-01],
[7.11863071e-01,7.91510083e-01,7.47811288e-01],
[7.12206121e-01,7.91500436e-01,7.48011807e-01],
[7.12549304e-01,7.91490670e-01,7.48211000e-01],
[7.12892615e-01,7.91480786e-01,7.48408871e-01],
[7.13236049e-01,7.91470784e-01,7.48605421e-01],
[7.13579600e-01,7.91460666e-01,7.48800655e-01],
[7.13923264e-01,7.91450432e-01,7.48994574e-01],
[7.14267035e-01,7.91440082e-01,7.49187181e-01],
[7.14610908e-01,7.91429618e-01,7.49378479e-01],
[7.14954879e-01,7.91419040e-01,7.49568471e-01],
[7.15298941e-01,7.91408349e-01,7.49757159e-01],
[7.15643091e-01,7.91397545e-01,7.49944546e-01],
[7.15987322e-01,7.91386629e-01,7.50130634e-01],
[7.16331630e-01,7.91375603e-01,7.50315426e-01],
[7.16676009e-01,7.91364466e-01,7.50498925e-01],
[7.17020455e-01,7.91353220e-01,7.50681133e-01],
[7.17364963e-01,7.91341865e-01,7.50862053e-01],
[7.17709527e-01,7.91330402e-01,7.51041687e-01],
[7.18054143e-01,7.91318831e-01,7.51220038e-01],
[7.18398805e-01,7.91307154e-01,7.51397109e-01],
[7.18743509e-01,7.91295371e-01,7.51572901e-01],
[7.19088250e-01,7.91283482e-01,7.51747418e-01],
[7.19433022e-01,7.91271490e-01,7.51920662e-01],
[7.19777821e-01,7.91259393e-01,7.52092636e-01],
[7.20122641e-01,7.91247194e-01,7.52263341e-01],
[7.20467479e-01,7.91234893e-01,7.52432781e-01],
[7.20812328e-01,7.91222490e-01,7.52600957e-01],
[7.21157185e-01,7.91209986e-01,7.52767873e-01],
[7.21502044e-01,7.91197383e-01,7.52933531e-01],
[7.21846900e-01,7.91184680e-01,7.53097932e-01],
[7.22191749e-01,7.91171879e-01,7.53261080e-01],
[7.22536585e-01,7.91158981e-01,7.53422977e-01],
[7.22881405e-01,7.91145985e-01,7.53583625e-01],
[7.23226203e-01,7.91132894e-01,7.53743027e-01],
[7.23570974e-01,7.91119707e-01,7.53901184e-01],
[7.23915713e-01,7.91106425e-01,7.54058100e-01],
[7.24260417e-01,7.91093050e-01,7.54213777e-01],
[7.24605080e-01,7.91079582e-01,7.54368216e-01],
[7.24949697e-01,7.91066022e-01,7.54521420e-01],
[7.25294264e-01,7.91052370e-01,7.54673392e-01],
[7.25638776e-01,7.91038627e-01,7.54824133e-01],
[7.25983229e-01,7.91024795e-01,7.54973646e-01],
[7.26327617e-01,7.91010873e-01,7.55121934e-01],
[7.26671937e-01,7.90996863e-01,7.55268998e-01],
[7.27016183e-01,7.90982766e-01,7.55414840e-01],
[7.27360351e-01,7.90968582e-01,7.55559463e-01],
[7.27704437e-01,7.90954312e-01,7.55702870e-01],
[7.28048436e-01,7.90939957e-01,7.55845061e-01],
[7.28392343e-01,7.90925517e-01,7.55986040e-01],
[7.28736154e-01,7.90910994e-01,7.56125808e-01],
[7.29079864e-01,7.90896389e-01,7.56264368e-01],
[7.29423469e-01,7.90881701e-01,7.56401722e-01],
[7.29766965e-01,7.90866932e-01,7.56537872e-01],
[7.30110346e-01,7.90852083e-01,7.56672819e-01],
[7.30453609e-01,7.90837155e-01,7.56806567e-01],
[7.30796750e-01,7.90822148e-01,7.56939117e-01],
[7.31139763e-01,7.90807062e-01,7.57070471e-01],
[7.31482644e-01,7.90791900e-01,7.57200631e-01],
[7.31825390e-01,7.90776662e-01,7.57329600e-01],
[7.32167995e-01,7.90761349e-01,7.57457379e-01],
[7.32510455e-01,7.90745960e-01,7.57583971e-01],
[7.32852767e-01,7.90730499e-01,7.57709376e-01],
[7.33194926e-01,7.90714964e-01,7.57833599e-01],
[7.33536927e-01,7.90699357e-01,7.57956639e-01],
[7.33878767e-01,7.90683679e-01,7.58078500e-01],
[7.34220440e-01,7.90667930e-01,7.58199184e-01],
[7.34561944e-01,7.90652112e-01,7.58318691e-01],
[7.34903274e-01,7.90636226e-01,7.58437025e-01],
[7.35244425e-01,7.90620271e-01,7.58554187e-01],
[7.35585393e-01,7.90604250e-01,7.58670179e-01],
[7.35926175e-01,7.90588162e-01,7.58785002e-01],
[7.36266767e-01,7.90572009e-01,7.58898660e-01],
[7.36607163e-01,7.90555792e-01,7.59011153e-01],
[7.36947361e-01,7.90539511e-01,7.59122484e-01],
[7.37287355e-01,7.90523167e-01,7.59232655e-01],
[7.37627143e-01,7.90506762e-01,7.59341666e-01],
[7.37966720e-01,7.90490295e-01,7.59449521e-01],
[7.38306082e-01,7.90473769e-01,7.59556220e-01],
[7.38645225e-01,7.90457183e-01,7.59661767e-01],
[7.38984146e-01,7.90440538e-01,7.59766161e-01],
[7.39322839e-01,7.90423837e-01,7.59869407e-01],
[7.39661302e-01,7.90407078e-01,7.59971504e-01],
[7.39999531e-01,7.90390264e-01,7.60072455e-01],
[7.40337521e-01,7.90373395e-01,7.60172261e-01],
[7.40675269e-01,7.90356472e-01,7.60270925e-01],
[7.41012772e-01,7.90339495e-01,7.60368448e-01],
[7.41350024e-01,7.90322467e-01,7.60464832e-01],
[7.41687023e-01,7.90305387e-01,7.60560078e-01],
[7.42023764e-01,7.90288257e-01,7.60654189e-01],
[7.42360245e-01,7.90271077e-01,7.60747165e-01],
[7.42696461e-01,7.90253849e-01,7.60839009e-01],
[7.43032408e-01,7.90236573e-01,7.60929722e-01],
[7.43368084e-01,7.90219250e-01,7.61019306e-01],
[7.43703484e-01,7.90201881e-01,7.61107763e-01],
[7.44038604e-01,7.90184467e-01,7.61195093e-01],
[7.44373441e-01,7.90167009e-01,7.61281300e-01],
[7.44707992e-01,7.90149507e-01,7.61366383e-01],
[7.45042253e-01,7.90131963e-01,7.61450346e-01],
[7.45376220e-01,7.90114378e-01,7.61533189e-01],
[7.45709890e-01,7.90096753e-01,7.61614914e-01],
[7.46043259e-01,7.90079088e-01,7.61695523e-01],
[7.46376325e-01,7.90061384e-01,7.61775017e-01],
[7.46709082e-01,7.90043643e-01,7.61853398e-01],
[7.47041529e-01,7.90025864e-01,7.61930668e-01],
[7.47373661e-01,7.90008050e-01,7.62006827e-01],
[7.47705475e-01,7.89990201e-01,7.62081877e-01],
[7.48036968e-01,7.89972318e-01,7.62155820e-01],
[7.48368137e-01,7.89954402e-01,7.62228658e-01],
[7.48698978e-01,7.89936454e-01,7.62300391e-01],
[7.49029487e-01,7.89918474e-01,7.62371022e-01],
[7.49359662e-01,7.89900465e-01,7.62440551e-01],
[7.49689499e-01,7.89882426e-01,7.62508980e-01],
[7.50018996e-01,7.89864359e-01,7.62576311e-01],
[7.50348148e-01,7.89846264e-01,7.62642546e-01],
[7.50676952e-01,7.89828143e-01,7.62707684e-01],
[7.51005406e-01,7.89809996e-01,7.62771728e-01],
[7.51333507e-01,7.89791825e-01,7.62834680e-01],
[7.51661250e-01,7.89773630e-01,7.62896540e-01],
[7.51988634e-01,7.89755413e-01,7.62957311e-01],
[7.52315654e-01,7.89737174e-01,7.63016992e-01],
[7.52642308e-01,7.89718914e-01,7.63075587e-01],
[7.52968593e-01,7.89700635e-01,7.63133095e-01],
[7.53294506e-01,7.89682336e-01,7.63189519e-01],
[7.53620043e-01,7.89664020e-01,7.63244860e-01],
[7.53945203e-01,7.89645688e-01,7.63299118e-01],
[7.54269981e-01,7.89627339e-01,7.63352296e-01],
[7.54594374e-01,7.89608975e-01,7.63404395e-01],
[7.54918381e-01,7.89590598e-01,7.63455415e-01],
[7.55241998e-01,7.89572208e-01,7.63505359e-01],
[7.55565222e-01,7.89553805e-01,7.63554227e-01],
[7.55888050e-01,7.89535392e-01,7.63602021e-01],
[7.56210480e-01,7.89516969e-01,7.63648742e-01],
[7.56532508e-01,7.89498537e-01,7.63694391e-01],
[7.56854132e-01,7.89480097e-01,7.63738970e-01],
[7.57175349e-01,7.89461650e-01,7.63782479e-01],
[7.57496156e-01,7.89443197e-01,7.63824920e-01],
[7.57816551e-01,7.89424739e-01,7.63866294e-01],
[7.58136531e-01,7.89406277e-01,7.63906602e-01],
[7.58456093e-01,7.89387812e-01,7.63945846e-01],
[7.58775234e-01,7.89369345e-01,7.63984026e-01],
[7.59093953e-01,7.89350878e-01,7.64021144e-01],
[7.59412245e-01,7.89332410e-01,7.64057201e-01],
[7.59730109e-01,7.89313943e-01,7.64092198e-01],
[7.60047542e-01,7.89295478e-01,7.64126136e-01],
[7.60364541e-01,7.89277017e-01,7.64159016e-01],
[7.60681105e-01,7.89258559e-01,7.64190840e-01],
[7.60997229e-01,7.89240107e-01,7.64221608e-01],
[7.61312913e-01,7.89221661e-01,7.64251322e-01],
[7.61628153e-01,7.89203222e-01,7.64279982e-01],
[7.61942947e-01,7.89184791e-01,7.64307590e-01],
[7.62257292e-01,7.89166369e-01,7.64334147e-01],
[7.62571186e-01,7.89147958e-01,7.64359654e-01],
[7.62884627e-01,7.89129558e-01,7.64384111e-01],
[7.63197612e-01,7.89111170e-01,7.64407521e-01],
[7.63510140e-01,7.89092796e-01,7.64429884e-01],
[7.63822206e-01,7.89074436e-01,7.64451200e-01],
[7.64133810e-01,7.89056091e-01,7.64471472e-01],
[7.64444949e-01,7.89037763e-01,7.64490699e-01],
[7.64755621e-01,7.89019452e-01,7.64508884e-01],
[7.65065823e-01,7.89001160e-01,7.64526026e-01],
[7.65375553e-01,7.88982887e-01,7.64542128e-01],
[7.65684809e-01,7.88964636e-01,7.64557189e-01],
[7.65993589e-01,7.88946405e-01,7.64571211e-01],
[7.66301891e-01,7.88928198e-01,7.64584195e-01],
[7.66609712e-01,7.88910014e-01,7.64596142e-01],
[7.66917050e-01,7.88891856e-01,7.64607053e-01],
[7.67223903e-01,7.88873723e-01,7.64616928e-01],
[7.67530269e-01,7.88855617e-01,7.64625768e-01],
[7.67836147e-01,7.88837539e-01,7.64633575e-01],
[7.68141533e-01,7.88819490e-01,7.64640350e-01],
[7.68446426e-01,7.88801471e-01,7.64646093e-01],
[7.68750824e-01,7.88783484e-01,7.64650804e-01],
[7.69054725e-01,7.88765529e-01,7.64654486e-01],
[7.69358127e-01,7.88747607e-01,7.64657139e-01],
[7.69661028e-01,7.88729720e-01,7.64658763e-01],
[7.69963426e-01,7.88711868e-01,7.64659360e-01],
[7.70265318e-01,7.88694052e-01,7.64658930e-01],
[7.70566704e-01,7.88676275e-01,7.64657474e-01],
[7.70867581e-01,7.88658536e-01,7.64654994e-01],
[7.71167948e-01,7.88640837e-01,7.64651489e-01],
[7.71467802e-01,7.88623179e-01,7.64646961e-01],
[7.71767142e-01,7.88605562e-01,7.64641411e-01],
[7.72065966e-01,7.88587989e-01,7.64634838e-01],
[7.72364272e-01,7.88570460e-01,7.64627245e-01],
[7.72662058e-01,7.88552976e-01,7.64618632e-01],
[7.72959323e-01,7.88535538e-01,7.64608999e-01],
[7.73256065e-01,7.88518148e-01,7.64598347e-01],
[7.73552282e-01,7.88500807e-01,7.64586678e-01],
[7.73847972e-01,7.88483515e-01,7.64573991e-01],
[7.74143134e-01,7.88466273e-01,7.64560288e-01],
[7.74437766e-01,7.88449083e-01,7.64545569e-01],
[7.74731867e-01,7.88431947e-01,7.64529836e-01],
[7.75025435e-01,7.88414864e-01,7.64513088e-01],
[7.75318468e-01,7.88397836e-01,7.64495326e-01],
[7.75610964e-01,7.88380865e-01,7.64476552e-01],
[7.75902923e-01,7.88363950e-01,7.64456765e-01],
[7.76194342e-01,7.88347094e-01,7.64435967e-01]])

T2_COLORMAP = ListedColormap([[4.18192112e-002,2.26614113e-002,1.08472805e-001],
[4.15267212e-002,2.88677284e-002,1.50080676e-001],
[4.07010868e-002,3.05474908e-002,1.63690897e-001],
[3.99052561e-002,3.17397855e-002,1.73983715e-001],
[4.06287980e-002,3.19886815e-002,1.82685193e-001],
[4.06651326e-002,3.24181100e-002,1.90328787e-001],
[4.07597382e-002,3.27238583e-002,1.97252725e-001],
[4.08930402e-002,3.29407201e-002,2.03636466e-001],
[4.10531857e-002,3.30905456e-002,2.09595246e-001],
[4.12324717e-002,3.31880309e-002,2.15208179e-001],
[4.14256248e-002,3.32435718e-002,2.20532315e-001],
[4.16288884e-002,3.32648122e-002,2.25610374e-001],
[4.18395008e-002,3.32575474e-002,2.30475318e-001],
[4.20553792e-002,3.32262824e-002,2.35153207e-001],
[4.22749194e-002,3.31745916e-002,2.39665060e-001],
[4.24968638e-002,3.31053610e-002,2.44028123e-001],
[4.27202119e-002,3.30209557e-002,2.48256755e-001],
[4.29441575e-002,3.29233387e-002,2.52363059e-001],
[4.31680438e-002,3.28141576e-002,2.56357350e-001],
[4.33913305e-002,3.26948090e-002,2.60248509e-001],
[4.36135699e-002,3.25664868e-002,2.64044240e-001],
[4.38343879e-002,3.24302200e-002,2.67751285e-001],
[4.40534705e-002,3.22869013e-002,2.71375582e-001],
[4.42705524e-002,3.21373101e-002,2.74922393e-001],
[4.44854086e-002,3.19821308e-002,2.78396409e-001],
[4.46978475e-002,3.18219676e-002,2.81801833e-001],
[4.49077057e-002,3.16573562e-002,2.85142448e-001],
[4.51148432e-002,3.14887736e-002,2.88421677e-001],
[4.53191401e-002,3.13166465e-002,2.91642625e-001],
[4.55204934e-002,3.11413576e-002,2.94808122e-001],
[4.57188148e-002,3.09632518e-002,2.97920759e-001],
[4.59140287e-002,3.07826403e-002,3.00982908e-001],
[4.61060701e-002,3.05998051e-002,3.03996756e-001],
[4.62948837e-002,3.04150025e-002,3.06964320e-001],
[4.64804223e-002,3.02284656e-002,3.09887464e-001],
[4.62328104e-002,3.14139134e-002,3.12676029e-001],
[4.63548526e-002,3.14021888e-002,3.15504053e-001],
[4.64708733e-002,3.13969327e-002,3.18292112e-001],
[4.65809615e-002,3.13979311e-002,3.21041638e-001],
[4.66852032e-002,3.14049850e-002,3.23753970e-001],
[4.67836820e-002,3.14179089e-002,3.26430363e-001],
[4.68764793e-002,3.14365300e-002,3.29071996e-001],
[4.69636742e-002,3.14606866e-002,3.31679977e-001],
[4.70453439e-002,3.14902276e-002,3.34255349e-001],
[4.71215633e-002,3.15250114e-002,3.36799097e-001],
[4.71924059e-002,3.15649053e-002,3.39312152e-001],
[4.72579431e-002,3.16097846e-002,3.41795393e-001],
[4.73182450e-002,3.16595322e-002,3.44249654e-001],
[4.73733798e-002,3.17140381e-002,3.46675725e-001],
[4.74234144e-002,3.17731983e-002,3.49074359e-001],
[4.74684142e-002,3.18369153e-002,3.51446268e-001],
[4.75084436e-002,3.19050968e-002,3.53792133e-001],
[4.75435652e-002,3.19776557e-002,3.56112601e-001],
[4.75738409e-002,3.20545098e-002,3.58408290e-001],
[4.75993312e-002,3.21355815e-002,3.60679790e-001],
[4.76200954e-002,3.22207972e-002,3.62927665e-001],
[4.76361921e-002,3.23100872e-002,3.65152455e-001],
[4.76476786e-002,3.24033857e-002,3.67354676e-001],
[4.76546114e-002,3.25006301e-002,3.69534824e-001],
[4.76570461e-002,3.26017612e-002,3.71693372e-001],
[4.76550373e-002,3.27067228e-002,3.73830777e-001],
[4.76486391e-002,3.28154613e-002,3.75947477e-001],
[4.76379044e-002,3.29279262e-002,3.78043893e-001],
[4.76228855e-002,3.30440692e-002,3.80120430e-001],
[4.76036342e-002,3.31638445e-002,3.82177478e-001],
[4.75802012e-002,3.32872084e-002,3.84215412e-001],
[4.75526368e-002,3.34141196e-002,3.86234596e-001],
[4.75209907e-002,3.35445385e-002,3.88235378e-001],
[4.74853117e-002,3.36784274e-002,3.90218095e-001],
[4.74456483e-002,3.38157506e-002,3.92183074e-001],
[4.74020483e-002,3.39564739e-002,3.94130629e-001],
[4.73545589e-002,3.41005647e-002,3.96061065e-001],
[4.73032270e-002,3.42479919e-002,3.97974676e-001],
[4.72480987e-002,3.43987260e-002,3.99871748e-001],
[4.71892197e-002,3.45527385e-002,4.01752556e-001],
[4.71266354e-002,3.47100024e-002,4.03617369e-001],
[4.70603906e-002,3.48704921e-002,4.05466445e-001],
[4.69905297e-002,3.50341827e-002,4.07300036e-001],
[4.69170965e-002,3.52010507e-002,4.09118387e-001],
[4.68401348e-002,3.53710736e-002,4.10921735e-001],
[4.67596876e-002,3.55442298e-002,4.12710309e-001],
[4.66757977e-002,3.57204987e-002,4.14484334e-001],
[4.65885075e-002,3.58998605e-002,4.16244027e-001],
[4.64978592e-002,3.60822963e-002,4.17989600e-001],
[4.64038944e-002,3.62677880e-002,4.19721257e-001],
[4.63066545e-002,3.64563182e-002,4.21439200e-001],
[4.62061806e-002,3.66478704e-002,4.23143624e-001],
[4.61025135e-002,3.68424285e-002,4.24834718e-001],
[4.59956935e-002,3.70399773e-002,4.26512667e-001],
[4.58857610e-002,3.72405020e-002,4.28177651e-001],
[4.57727557e-002,3.74439886e-002,4.29829847e-001],
[4.56567173e-002,3.76504235e-002,4.31469426e-001],
[4.55376852e-002,3.78597938e-002,4.33096555e-001],
[4.54156985e-002,3.80720868e-002,4.34711396e-001],
[4.52907960e-002,3.82872905e-002,4.36314111e-001],
[4.51630163e-002,3.85053935e-002,4.37904853e-001],
[4.50323978e-002,3.87263844e-002,4.39483776e-001],
[4.48989788e-002,3.89502526e-002,4.41051027e-001],
[4.47627970e-002,3.91769877e-002,4.42606752e-001],
[4.46238903e-002,3.94065797e-002,4.44151092e-001],
[4.44822962e-002,3.96390190e-002,4.45684186e-001],
[4.43380519e-002,3.98742962e-002,4.47206171e-001],
[4.41911947e-002,4.01124023e-002,4.48717178e-001],
[4.40417615e-002,4.03533287e-002,4.50217338e-001],
[4.38897889e-002,4.05970668e-002,4.51706777e-001],
[4.37353137e-002,4.08436086e-002,4.53185621e-001],
[4.35783722e-002,4.10929461e-002,4.54653991e-001],
[4.34190006e-002,4.13450716e-002,4.56112007e-001],
[4.32572351e-002,4.15999776e-002,4.57559786e-001],
[4.30931114e-002,4.18576569e-002,4.58997441e-001],
[4.29266655e-002,4.21181025e-002,4.60425087e-001],
[4.27579328e-002,4.23813074e-002,4.61842833e-001],
[4.25869489e-002,4.26472649e-002,4.63250786e-001],
[4.24137490e-002,4.29159686e-002,4.64649054e-001],
[4.22383684e-002,4.31874120e-002,4.66037740e-001],
[4.20608421e-002,4.34615889e-002,4.67416945e-001],
[4.18812049e-002,4.37384931e-002,4.68786771e-001],
[4.16994917e-002,4.40181187e-002,4.70147316e-001],
[4.15157371e-002,4.43004598e-002,4.71498675e-001],
[4.13299756e-002,4.45855106e-002,4.72840944e-001],
[4.11422417e-002,4.48732654e-002,4.74174216e-001],
[4.09525695e-002,4.51637187e-002,4.75498581e-001],
[4.07609934e-002,4.54568649e-002,4.76814131e-001],
[4.05675472e-002,4.57526986e-002,4.78120953e-001],
[4.03722650e-002,4.60512144e-002,4.79419133e-001],
[4.01751807e-002,4.63524071e-002,4.80708758e-001],
[3.99763278e-002,4.66562713e-002,4.81989910e-001],
[3.97757401e-002,4.69628020e-002,4.83262672e-001],
[3.95734510e-002,4.72719938e-002,4.84527125e-001],
[3.93694941e-002,4.75838417e-002,4.85783349e-001],
[3.91639025e-002,4.78983406e-002,4.87031423e-001],
[3.89567095e-002,4.82154854e-002,4.88271422e-001],
[3.87479482e-002,4.85352710e-002,4.89503423e-001],
[3.85376517e-002,4.88576925e-002,4.90727501e-001],
[3.83258529e-002,4.91827448e-002,4.91943729e-001],
[3.81125846e-002,4.95104229e-002,4.93152179e-001],
[3.78978795e-002,4.98407218e-002,4.94352923e-001],
[3.76817704e-002,5.01736364e-002,4.95546030e-001],
[3.74642898e-002,5.05091617e-002,4.96731570e-001],
[3.72454702e-002,5.08472927e-002,4.97909611e-001],
[3.70253439e-002,5.11880243e-002,4.99080218e-001],
[3.68039433e-002,5.15313515e-002,5.00243460e-001],
[3.65813005e-002,5.18772692e-002,5.01399399e-001],
[3.63574479e-002,5.22257723e-002,5.02548101e-001],
[3.61324172e-002,5.25768556e-002,5.03689628e-001],
[3.59062406e-002,5.29305140e-002,5.04824043e-001],
[3.56789500e-002,5.32867422e-002,5.05951406e-001],
[3.54505770e-002,5.36455350e-002,5.07071778e-001],
[3.52211535e-002,5.40068872e-002,5.08185219e-001],
[3.49907110e-002,5.43707935e-002,5.09291787e-001],
[3.47592811e-002,5.47372484e-002,5.10391541e-001],
[3.45268953e-002,5.51062465e-002,5.11484536e-001],
[3.42935849e-002,5.54777825e-002,5.12570830e-001],
[3.40593813e-002,5.58518509e-002,5.13650478e-001],
[3.38243156e-002,5.62284459e-002,5.14723534e-001],
[3.35884190e-002,5.66075622e-002,5.15790053e-001],
[3.33517225e-002,5.69891939e-002,5.16850088e-001],
[3.31142571e-002,5.73733355e-002,5.17903691e-001],
[3.28760536e-002,5.77599810e-002,5.18950915e-001],
[3.26371429e-002,5.81491248e-002,5.19991810e-001],
[3.23975557e-002,5.85407608e-002,5.21026427e-001],
[3.21573224e-002,5.89348831e-002,5.22054816e-001],
[3.19164738e-002,5.93314858e-002,5.23077026e-001],
[3.16750402e-002,5.97305626e-002,5.24093105e-001],
[3.14330519e-002,6.01321075e-002,5.25103102e-001],
[3.11905393e-002,6.05361143e-002,5.26107064e-001],
[3.09475325e-002,6.09425766e-002,5.27105038e-001],
[3.07040615e-002,6.13514881e-002,5.28097070e-001],
[3.04601564e-002,6.17628424e-002,5.29083205e-001],
[3.02158470e-002,6.21766330e-002,5.30063489e-001],
[2.99711632e-002,6.25928533e-002,5.31037965e-001],
[2.97261346e-002,6.30114966e-002,5.32006679e-001],
[2.94807908e-002,6.34325563e-002,5.32969672e-001],
[2.92351613e-002,6.38560256e-002,5.33926989e-001],
[2.89892756e-002,6.42818976e-002,5.34878672e-001],
[2.87431628e-002,6.47101654e-002,5.35824762e-001],
[2.84968523e-002,6.51408219e-002,5.36765300e-001],
[2.82503730e-002,6.55738602e-002,5.37700328e-001],
[2.80037539e-002,6.60092729e-002,5.38629887e-001],
[2.77570240e-002,6.64470530e-002,5.39554015e-001],
[2.75102120e-002,6.68871931e-002,5.40472752e-001],
[2.72633464e-002,6.73296858e-002,5.41386138e-001],
[2.70164560e-002,6.77745236e-002,5.42294211e-001],
[2.67695689e-002,6.82216991e-002,5.43197009e-001],
[2.65227136e-002,6.86712046e-002,5.44094569e-001],
[2.62759182e-002,6.91230324e-002,5.44986930e-001],
[2.60292108e-002,6.95771748e-002,5.45874127e-001],
[2.57826193e-002,7.00336240e-002,5.46756197e-001],
[2.55361714e-002,7.04923719e-002,5.47633177e-001],
[2.52898949e-002,7.09534107e-002,5.48505101e-001],
[2.50438172e-002,7.14167323e-002,5.49372006e-001],
[2.47979659e-002,7.18823285e-002,5.50233925e-001],
[2.45523680e-002,7.23501912e-002,5.51090894e-001],
[2.43070509e-002,7.28203120e-002,5.51942946e-001],
[2.40620414e-002,7.32926826e-002,5.52790115e-001],
[2.38173663e-002,7.37672945e-002,5.53632434e-001],
[2.35730524e-002,7.42441393e-002,5.54469937e-001],
[2.33291263e-002,7.47232084e-002,5.55302656e-001],
[2.30856142e-002,7.52044932e-002,5.56130623e-001],
[2.28425425e-002,7.56879848e-002,5.56953870e-001],
[2.25999372e-002,7.61736745e-002,5.57772429e-001],
[2.23578242e-002,7.66615535e-002,5.58586332e-001],
[2.21162292e-002,7.71516128e-002,5.59395608e-001],
[2.18751780e-002,7.76438435e-002,5.60200289e-001],
[2.16346958e-002,7.81382363e-002,5.61000405e-001],
[2.13948079e-002,7.86347823e-002,5.61795986e-001],
[2.11555394e-002,7.91334722e-002,5.62587062e-001],
[2.09169152e-002,7.96342967e-002,5.63373662e-001],
[2.06789600e-002,8.01372465e-002,5.64155815e-001],
[2.04416983e-002,8.06423122e-002,5.64933550e-001],
[2.02051544e-002,8.11494842e-002,5.65706895e-001],
[1.99693525e-002,8.16587532e-002,5.66475879e-001],
[1.97343165e-002,8.21701094e-002,5.67240530e-001],
[1.95000702e-002,8.26835431e-002,5.68000875e-001],
[1.92666372e-002,8.31990448e-002,5.68756941e-001],
[1.90340407e-002,8.37166046e-002,5.69508756e-001],
[1.88023039e-002,8.42362126e-002,5.70256347e-001],
[1.85714498e-002,8.47578589e-002,5.70999740e-001],
[1.83415010e-002,8.52815336e-002,5.71738961e-001],
[1.81124800e-002,8.58072267e-002,5.72474037e-001],
[1.78844092e-002,8.63349280e-002,5.73204993e-001],
[1.76573105e-002,8.68646274e-002,5.73931855e-001],
[1.74312058e-002,8.73963148e-002,5.74654648e-001],
[1.72061166e-002,8.79299798e-002,5.75373397e-001],
[1.69820643e-002,8.84656122e-002,5.76088128e-001],
[1.67590701e-002,8.90032016e-002,5.76798864e-001],
[1.65371547e-002,8.95427377e-002,5.77505630e-001],
[1.63163388e-002,9.00842099e-002,5.78208450e-001],
[1.60966428e-002,9.06276077e-002,5.78907349e-001],
[1.58780867e-002,9.11729206e-002,5.79602349e-001],
[1.56606905e-002,9.17201380e-002,5.80293474e-001],
[1.54444737e-002,9.22692492e-002,5.80980747e-001],
[1.52294557e-002,9.28202436e-002,5.81664192e-001],
[1.50156555e-002,9.33731103e-002,5.82343832e-001],
[1.48030919e-002,9.39278385e-002,5.83019688e-001],
[1.45917834e-002,9.44844175e-002,5.83691783e-001],
[1.43817482e-002,9.50428364e-002,5.84360140e-001],
[1.41730044e-002,9.56030842e-002,5.85024780e-001],
[1.39655695e-002,9.61651500e-002,5.85685725e-001],
[1.37594609e-002,9.67290228e-002,5.86342998e-001],
[1.35546957e-002,9.72946915e-002,5.86996618e-001],
[1.33512908e-002,9.78621451e-002,5.87646607e-001],
[1.31492624e-002,9.84313724e-002,5.88292987e-001],
[1.29486270e-002,9.90023622e-002,5.88935778e-001],
[1.27494002e-002,9.95751035e-002,5.89575001e-001],
[1.25515976e-002,1.00149585e-001,5.90210675e-001],
[1.23552345e-002,1.00725795e-001,5.90842823e-001],
[1.21603258e-002,1.01303723e-001,5.91471463e-001],
[1.19668861e-002,1.01883358e-001,5.92096615e-001],
[1.17749297e-002,1.02464687e-001,5.92718300e-001],
[1.15844704e-002,1.03047700e-001,5.93336536e-001],
[1.13955219e-002,1.03632385e-001,5.93951343e-001],
[1.12080974e-002,1.04218730e-001,5.94562741e-001],
[1.10222100e-002,1.04806725e-001,5.95170748e-001],
[1.08378720e-002,1.05396358e-001,5.95775383e-001],
[1.06550959e-002,1.05987617e-001,5.96376666e-001],
[1.04738934e-002,1.06580491e-001,5.96974614e-001],
[1.02942762e-002,1.07174968e-001,5.97569245e-001],
[1.01162553e-002,1.07771036e-001,5.98160579e-001],
[9.93984164e-003,1.08368685e-001,5.98748634e-001],
[9.76504563e-003,1.08967902e-001,5.99333426e-001],
[9.59187738e-003,1.09568675e-001,5.99914975e-001],
[9.42034660e-003,1.10170994e-001,6.00493297e-001],
[9.25046266e-003,1.10774846e-001,6.01068410e-001],
[9.08223453e-003,1.11380220e-001,6.01640331e-001],
[8.91567083e-003,1.11987104e-001,6.02209078e-001],
[8.75077978e-003,1.12595486e-001,6.02774668e-001],
[8.58756923e-003,1.13205354e-001,6.03337117e-001],
[8.42604664e-003,1.13816698e-001,6.03896443e-001],
[8.26621910e-003,1.14429504e-001,6.04452661e-001],
[8.10809331e-003,1.15043761e-001,6.05005789e-001],
[7.95167556e-003,1.15659458e-001,6.05555842e-001],
[7.79697178e-003,1.16276583e-001,6.06102838e-001],
[7.64398748e-003,1.16895124e-001,6.06646791e-001],
[7.49272778e-003,1.17515068e-001,6.07187718e-001],
[7.34319743e-003,1.18136405e-001,6.07725635e-001],
[7.19540076e-003,1.18759122e-001,6.08260558e-001],
[7.04934169e-003,1.19383208e-001,6.08792501e-001],
[6.90502375e-003,1.20008651e-001,6.09321481e-001],
[6.76245009e-003,1.20635439e-001,6.09847512e-001],
[6.62162343e-003,1.21263559e-001,6.10370611e-001],
[6.48254608e-003,1.21893001e-001,6.10890791e-001],
[6.34521998e-003,1.22523753e-001,6.11408068e-001],
[6.20964664e-003,1.23155802e-001,6.11922457e-001],
[6.07582715e-003,1.23789137e-001,6.12433972e-001],
[5.94376224e-003,1.24423746e-001,6.12942628e-001],
[5.81345218e-003,1.25059617e-001,6.13448439e-001],
[5.68489688e-003,1.25696738e-001,6.13951420e-001],
[5.55809580e-003,1.26335098e-001,6.14451585e-001],
[5.43304804e-003,1.26974684e-001,6.14948947e-001],
[5.30975225e-003,1.27615486e-001,6.15443522e-001],
[5.18820671e-003,1.28257490e-001,6.15935323e-001],
[5.06840927e-003,1.28900686e-001,6.16424364e-001],
[4.95035738e-003,1.29545061e-001,6.16910658e-001],
[4.83404810e-003,1.30190604e-001,6.17394218e-001],
[4.71947808e-003,1.30837302e-001,6.17875060e-001],
[4.60664357e-003,1.31485145e-001,6.18353195e-001],
[4.49554041e-003,1.32134121e-001,6.18828636e-001],
[4.38616406e-003,1.32784217e-001,6.19301398e-001],
[4.27850957e-003,1.33435421e-001,6.19771494e-001],
[4.17257161e-003,1.34087724e-001,6.20238935e-001],
[4.06834445e-003,1.34741111e-001,6.20703735e-001],
[3.96582196e-003,1.35395573e-001,6.21165907e-001],
[3.86499765e-003,1.36051097e-001,6.21625463e-001],
[3.76586462e-003,1.36707671e-001,6.22082416e-001],
[3.66841561e-003,1.37365284e-001,6.22536779e-001],
[3.57264297e-003,1.38023925e-001,6.22988563e-001],
[3.47853866e-003,1.38683581e-001,6.23437780e-001],
[3.38609431e-003,1.39344242e-001,6.23884444e-001],
[3.29530115e-003,1.40005895e-001,6.24328566e-001],
[3.20615005e-003,1.40668529e-001,6.24770159e-001],
[3.11863153e-003,1.41332132e-001,6.25209233e-001],
[3.03273575e-003,1.41996693e-001,6.25645801e-001],
[2.94845252e-003,1.42662201e-001,6.26079874e-001],
[2.86577130e-003,1.43328644e-001,6.26511465e-001],
[2.78468122e-003,1.43996011e-001,6.26940584e-001],
[2.70517105e-003,1.44664290e-001,6.27367244e-001],
[2.62722927e-003,1.45333469e-001,6.27791454e-001],
[2.55084399e-003,1.46003538e-001,6.28213228e-001],
[2.47600303e-003,1.46674485e-001,6.28632575e-001],
[2.40269387e-003,1.47346299e-001,6.29049507e-001],
[2.33090371e-003,1.48018969e-001,6.29464036e-001],
[2.26061944e-003,1.48692482e-001,6.29876171e-001],
[2.19182764e-003,1.49366829e-001,6.30285924e-001],
[2.12451461e-003,1.50041997e-001,6.30693306e-001],
[2.05866636e-003,1.50717976e-001,6.31098326e-001],
[1.99426866e-003,1.51394755e-001,6.31500997e-001],
[1.93130695e-003,1.52072321e-001,6.31901328e-001],
[1.86976647e-003,1.52750665e-001,6.32299330e-001],
[1.80963217e-003,1.53429775e-001,6.32695014e-001],
[1.75088875e-003,1.54109641e-001,6.33088388e-001],
[1.69352071e-003,1.54790250e-001,6.33479465e-001],
[1.63751228e-003,1.55471593e-001,6.33868254e-001],
[1.58284749e-003,1.56153658e-001,6.34254764e-001],
[1.52951014e-003,1.56836434e-001,6.34639006e-001],
[1.47748383e-003,1.57519910e-001,6.35020991e-001],
[1.42675199e-003,1.58204076e-001,6.35400727e-001],
[1.37729781e-003,1.58888921e-001,6.35778225e-001],
[1.32910434e-003,1.59574434e-001,6.36153494e-001],
[1.28215445e-003,1.60260604e-001,6.36526544e-001],
[1.23643085e-003,1.60947421e-001,6.36897384e-001],
[1.19191608e-003,1.61634873e-001,6.37266025e-001],
[1.14859256e-003,1.62322951e-001,6.37632475e-001],
[1.10644257e-003,1.63011643e-001,6.37996743e-001],
[1.06544825e-003,1.63700940e-001,6.38358840e-001],
[1.02559165e-003,1.64390830e-001,6.38718774e-001],
[9.86854699e-004,1.65081303e-001,6.39076555e-001],
[9.49219233e-004,1.65772348e-001,6.39432191e-001],
[9.12667005e-004,1.66463956e-001,6.39785692e-001],
[8.77179693e-004,1.67156116e-001,6.40137066e-001],
[8.42738906e-004,1.67848816e-001,6.40486323e-001],
[8.09326199e-004,1.68542048e-001,6.40833472e-001],
[7.76923081e-004,1.69235801e-001,6.41178520e-001],
[7.45511025e-004,1.69930065e-001,6.41521477e-001],
[7.15071477e-004,1.70624829e-001,6.41862352e-001],
[6.85585870e-004,1.71320083e-001,6.42201152e-001],
[6.57035628e-004,1.72015817e-001,6.42537888e-001],
[6.29402180e-004,1.72712021e-001,6.42872566e-001],
[6.02666970e-004,1.73408686e-001,6.43205196e-001],
[5.76811465e-004,1.74105800e-001,6.43535785e-001],
[5.51817166e-004,1.74803355e-001,6.43864343e-001],
[5.27665617e-004,1.75501340e-001,6.44190877e-001],
[5.04338417e-004,1.76199745e-001,6.44515396e-001],
[4.81817227e-004,1.76898560e-001,6.44837907e-001],
[4.60083781e-004,1.77597777e-001,6.45158419e-001],
[4.39119896e-004,1.78297384e-001,6.45476939e-001],
[4.18907478e-004,1.78997372e-001,6.45793476e-001],
[3.99428536e-004,1.79697732e-001,6.46108038e-001],
[3.80665190e-004,1.80398454e-001,6.46420632e-001],
[3.62599678e-004,1.81099529e-001,6.46731266e-001],
[3.45214364e-004,1.81800946e-001,6.47039948e-001],
[3.28491752e-004,1.82502697e-001,6.47346685e-001],
[3.12414489e-004,1.83204771e-001,6.47651486e-001],
[2.96965376e-004,1.83907160e-001,6.47954357e-001],
[2.82127377e-004,1.84609854e-001,6.48255306e-001],
[2.67883624e-004,1.85312844e-001,6.48554341e-001],
[2.54217428e-004,1.86016121e-001,6.48851469e-001],
[2.41112284e-004,1.86719675e-001,6.49146698e-001],
[2.28551879e-004,1.87423497e-001,6.49440034e-001],
[2.16520102e-004,1.88127578e-001,6.49731485e-001],
[2.05001046e-004,1.88831908e-001,6.50021058e-001],
[1.93979018e-004,1.89536480e-001,6.50308761e-001],
[1.83438544e-004,1.90241283e-001,6.50594600e-001],
[1.73364375e-004,1.90946310e-001,6.50878582e-001],
[1.63741495e-004,1.91651550e-001,6.51160715e-001],
[1.54555122e-004,1.92356995e-001,6.51441006e-001],
[1.45790718e-004,1.93062636e-001,6.51719460e-001],
[1.37433993e-004,1.93768465e-001,6.51996086e-001],
[1.29470905e-004,1.94474473e-001,6.52270890e-001],
[1.21887672e-004,1.95180650e-001,6.52543878e-001],
[1.14670767e-004,1.95886989e-001,6.52815059e-001],
[1.07806933e-004,1.96593480e-001,6.53084437e-001],
[1.01283174e-004,1.97300116e-001,6.53352020e-001],
[9.50867681e-005,1.98006887e-001,6.53617814e-001],
[8.92052645e-005,1.98713785e-001,6.53881826e-001],
[8.36264883e-005,1.99420802e-001,6.54144063e-001],
[7.83385418e-005,2.00127930e-001,6.54404530e-001],
[7.33298067e-005,2.00835159e-001,6.54663235e-001],
[6.85889450e-005,2.01542482e-001,6.54920183e-001],
[6.41049009e-005,2.02249891e-001,6.55175382e-001],
[5.98669006e-005,2.02957377e-001,6.55428836e-001],
[5.58644537e-005,2.03664932e-001,6.55680553e-001],
[5.20873528e-005,2.04372547e-001,6.55930538e-001],
[4.85256734e-005,2.05080216e-001,6.56178798e-001],
[4.51697735e-005,2.05787930e-001,6.56425339e-001],
[4.20102928e-005,2.06495681e-001,6.56670167e-001],
[3.90381513e-005,2.07203461e-001,6.56913288e-001],
[3.62445485e-005,2.07911262e-001,6.57154708e-001],
[3.36209608e-005,2.08619076e-001,6.57394432e-001],
[3.11591404e-005,2.09326896e-001,6.57632467e-001],
[2.88511122e-005,2.10034713e-001,6.57868819e-001],
[2.66891719e-005,2.10742521e-001,6.58103494e-001],
[2.46658827e-005,2.11450311e-001,6.58336496e-001],
[2.27740723e-005,2.12158075e-001,6.58567833e-001],
[2.10068298e-005,2.12865808e-001,6.58797509e-001],
[1.93575017e-005,2.13573499e-001,6.59025530e-001],
[1.78196886e-005,2.14281143e-001,6.59251903e-001],
[1.63872406e-005,2.14988732e-001,6.59476631e-001],
[1.50542535e-005,2.15696259e-001,6.59699722e-001],
[1.38150640e-005,2.16403715e-001,6.59921181e-001],
[1.26642455e-005,2.17111095e-001,6.60141012e-001],
[1.15966027e-005,2.17818390e-001,6.60359223e-001],
[1.06071674e-005,2.18525593e-001,6.60575816e-001],
[9.69119276e-006,2.19232698e-001,6.60790800e-001],
[8.84414824e-006,2.19939697e-001,6.61004178e-001],
[8.06171438e-006,2.20646583e-001,6.61215955e-001],
[7.33977721e-006,2.21353349e-001,6.61426138e-001],
[6.67442266e-006,2.22059988e-001,6.61634731e-001],
[6.06193098e-006,2.22766493e-001,6.61841740e-001],
[5.49877097e-006,2.23472858e-001,6.62047169e-001],
[4.98159420e-006,2.24179075e-001,6.62251025e-001],
[4.50722926e-006,2.24885138e-001,6.62453311e-001],
[4.07267582e-006,2.25591039e-001,6.62654033e-001],
[3.67509884e-006,2.26296773e-001,6.62853196e-001],
[3.31182266e-006,2.27002333e-001,6.63050805e-001],
[2.98032517e-006,2.27707711e-001,6.63246865e-001],
[2.67823194e-006,2.28412902e-001,6.63441380e-001],
[2.40331046e-006,2.29117899e-001,6.63634357e-001],
[2.15346433e-006,2.29822695e-001,6.63825799e-001],
[1.92672759e-006,2.30527284e-001,6.64015711e-001],
[1.72125904e-006,2.31231659e-001,6.64204098e-001],
[1.53533672e-006,2.31935815e-001,6.64390966e-001],
[1.36735241e-006,2.32639745e-001,6.64576318e-001],
[1.21580622e-006,2.33343442e-001,6.64760159e-001],
[1.07930135e-006,2.34046901e-001,6.64942494e-001],
[9.56538872e-007,2.34750115e-001,6.65123328e-001],
[8.46312716e-007,2.35453078e-001,6.65302665e-001],
[7.47504712e-007,2.36155784e-001,6.65480510e-001],
[6.59079802e-007,2.36858227e-001,6.65656867e-001],
[5.80081374e-007,2.37560402e-001,6.65831741e-001],
[5.09626742e-007,2.38262301e-001,6.66005136e-001],
[4.46902770e-007,2.38963919e-001,6.66177057e-001],
[3.91161644e-007,2.39665251e-001,6.66347508e-001],
[3.41716794e-007,2.40366290e-001,6.66516493e-001],
[2.97938981e-007,2.41067031e-001,6.66684018e-001],
[2.59252522e-007,2.41767467e-001,6.66850086e-001],
[2.25131692e-007,2.42467594e-001,6.67014701e-001],
[1.95097265e-007,2.43167405e-001,6.67177868e-001],
[1.68713228e-007,2.43866896e-001,6.67339591e-001],
[1.45583638e-007,2.44566059e-001,6.67499874e-001],
[1.25349648e-007,2.45264891e-001,6.67658721e-001],
[1.07686676e-007,2.45963384e-001,6.67816138e-001],
[9.23017290e-008,2.46661535e-001,6.67972127e-001],
[7.89308813e-008,2.47359337e-001,6.68126692e-001],
[6.73368902e-008,2.48056785e-001,6.68279839e-001],
[5.73069608e-008,2.48753874e-001,6.68431571e-001],
[4.86506468e-008,2.49450599e-001,6.68581891e-001],
[4.11978870e-008,2.50146953e-001,6.68730805e-001],
[3.47971720e-008,2.50842933e-001,6.68878315e-001],
[2.93138370e-008,2.51538533e-001,6.69024427e-001],
[2.46284757e-008,2.52233747e-001,6.69169143e-001],
[2.06354700e-008,2.52928571e-001,6.69312468e-001],
[1.72416313e-008,2.53623000e-001,6.69454405e-001],
[1.43649474e-008,2.54317028e-001,6.69594959e-001],
[1.19334301e-008,2.55010651e-001,6.69734133e-001],
[9.88405804e-009,2.55703864e-001,6.69871931e-001],
[8.16181002e-009,2.56396661e-001,6.70008357e-001],
[6.71878276e-009,2.57089039e-001,6.70143414e-001],
[5.51338856e-009,2.57780991e-001,6.70277107e-001],
[4.50962740e-009,2.58472515e-001,6.70409438e-001],
[3.67642862e-009,2.59163604e-001,6.70540412e-001],
[2.98705733e-009,2.59854253e-001,6.70670032e-001],
[2.41858066e-009,2.60544460e-001,6.70798302e-001],
[1.95138945e-009,2.61234218e-001,6.70925226e-001],
[1.56877088e-009,2.61923523e-001,6.71050806e-001],
[1.25652797e-009,2.62612371e-001,6.71175047e-001],
[1.00264170e-009,2.63300757e-001,6.71297952e-001],
[7.96972245e-010,2.63988677e-001,6.71419525e-001],
[6.30995513e-010,2.64676126e-001,6.71539768e-001],
[4.97571736e-010,2.65363100e-001,6.71658686e-001],
[3.90742885e-010,2.66049595e-001,6.71776282e-001],
[3.05555999e-010,2.66735605e-001,6.71892560e-001],
[2.37909681e-010,2.67421128e-001,6.72007521e-001],
[1.84421236e-010,2.68106159e-001,6.72121171e-001],
[1.42312127e-010,2.68790693e-001,6.72233513e-001],
[1.09309615e-010,2.69474726e-001,6.72344549e-001],
[8.35626514e-011,2.70158255e-001,6.72454283e-001],
[6.35702499e-011,2.70841275e-001,6.72562718e-001],
[4.81207588e-011,2.71523782e-001,6.72669858e-001],
[3.62405920e-011,2.72205772e-001,6.72775706e-001],
[2.71511476e-011,2.72887241e-001,6.72880265e-001],
[2.02327701e-011,2.73568185e-001,6.72983537e-001],
[1.49947484e-011,2.74248601e-001,6.73085527e-001],
[1.10504594e-011,2.74928484e-001,6.73186238e-001],
[8.09687781e-012,2.75607831e-001,6.73285672e-001],
[5.89776937e-012,2.76286637e-001,6.73383833e-001],
[4.26997944e-012,2.76964899e-001,6.73480723e-001],
[3.07230517e-012,2.77642614e-001,6.73576347e-001],
[2.19651462e-012,2.78319777e-001,6.73670706e-001],
[1.56013935e-012,2.78996384e-001,6.73763804e-001],
[1.10072358e-012,2.79672434e-001,6.73855644e-001],
[7.71262744e-013,2.80347920e-001,6.73946229e-001],
[5.36607498e-013,2.81022841e-001,6.74035562e-001],
[3.70646500e-013,2.81697193e-001,6.74123645e-001],
[2.54113425e-013,2.82370971e-001,6.74210482e-001],
[1.72891159e-013,2.83044173e-001,6.74296076e-001],
[1.16709285e-013,2.83716795e-001,6.74380429e-001],
[7.81506136e-014,2.84388834e-001,6.74463545e-001],
[5.18988162e-014,2.85060286e-001,6.74545426e-001],
[3.41728326e-014,2.85731149e-001,6.74626074e-001],
[2.23048806e-014,2.86401418e-001,6.74705494e-001],
[1.44280466e-014,2.87071090e-001,6.74783687e-001],
[9.24684188e-015,2.87740163e-001,6.74860657e-001],
[5.87006916e-015,2.88408633e-001,6.74936405e-001],
[3.69010252e-015,2.89076497e-001,6.75010936e-001],
[2.29644654e-015,2.89743751e-001,6.75084251e-001],
[1.41439188e-015,2.90410393e-001,6.75156353e-001],
[8.61880063e-016,2.91076420e-001,6.75227246e-001],
[5.19458538e-016,2.91741828e-001,6.75296931e-001],
[3.09556659e-016,2.92406615e-001,6.75365411e-001],
[1.82333955e-016,2.93070777e-001,6.75432689e-001],
[1.06115908e-016,2.93734311e-001,6.75498767e-001],
[6.09986993e-017,2.94397215e-001,6.75563649e-001],
[3.46197036e-017,2.95059486e-001,6.75627336e-001],
[1.93917953e-017,2.95721121e-001,6.75689831e-001],
[1.07158635e-017,2.96382117e-001,6.75751137e-001],
[5.83937605e-018,2.97042471e-001,6.75811257e-001],
[3.13649213e-018,2.97702180e-001,6.75870192e-001],
[1.65982076e-018,2.98361243e-001,6.75927945e-001],
[8.64988191e-019,2.99019655e-001,6.75984519e-001],
[4.43685825e-019,2.99677414e-001,6.76039916e-001],
[2.23889090e-019,3.00334518e-001,6.76094139e-001],
[1.11083284e-019,3.00990964e-001,6.76147189e-001],
[5.41601203e-020,3.01646749e-001,6.76199071e-001],
[2.59341632e-020,3.02301872e-001,6.76249785e-001],
[1.21888428e-020,3.02956328e-001,6.76299334e-001],
[5.61920697e-021,3.03610117e-001,6.76347720e-001],
[2.53935146e-021,3.04263234e-001,6.76394947e-001],
[1.12410362e-021,3.04915679e-001,6.76441016e-001],
[4.87094363e-022,3.05567447e-001,6.76485929e-001],
[2.06450923e-022,3.06218538e-001,6.76529689e-001],
[8.55217937e-023,3.06868949e-001,6.76572298e-001],
[3.45968906e-023,3.07518676e-001,6.76613758e-001],
[1.36560661e-023,3.08167719e-001,6.76654072e-001],
[5.25476716e-024,3.08816074e-001,6.76693242e-001],
[1.96930886e-024,3.09463740e-001,6.76731270e-001],
[7.18093491e-025,3.10110713e-001,6.76768158e-001],
[2.54512618e-025,3.10756993e-001,6.76803908e-001],
[8.75854859e-026,3.11402576e-001,6.76838523e-001],
[2.92321342e-026,3.12047461e-001,6.76872005e-001],
[9.45109162e-027,3.12691645e-001,6.76904356e-001],
[2.95637202e-027,3.13335127e-001,6.76935577e-001],
[8.93568928e-028,3.13977904e-001,6.76965672e-001],
[2.60613640e-028,3.14619973e-001,6.76994642e-001],
[7.32394278e-029,3.15261334e-001,6.77022489e-001],
[1.98024364e-029,3.15901985e-001,6.77049216e-001],
[5.14318325e-030,3.16541922e-001,6.77074824e-001],
[1.28104218e-030,3.17181144e-001,6.77099315e-001],
[3.05459507e-031,3.17819650e-001,6.77122692e-001],
[6.95990541e-032,3.18457436e-001,6.77144957e-001],
[1.51241371e-032,3.19094503e-001,6.77166111e-001],
[3.12801060e-033,3.19730846e-001,6.77186156e-001],
[6.14413323e-034,3.20366466e-001,6.77205095e-001],
[1.14356485e-034,3.21001359e-001,6.77222929e-001],
[2.01199445e-035,3.21635525e-001,6.77239661e-001],
[3.33778196e-036,3.22268960e-001,6.77255292e-001],
[5.20704235e-037,3.22901665e-001,6.77269824e-001],
[7.61721138e-038,3.23533636e-001,6.77283260e-001],
[1.04176748e-038,3.24164872e-001,6.77295600e-001],
[1.32781298e-039,3.24795372e-001,6.77306847e-001],
[1.57193134e-040,3.25425133e-001,6.77317003e-001],
[1.72231214e-041,3.26054155e-001,6.77326070e-001],
[1.73991586e-042,3.26682436e-001,6.77334049e-001],
[1.61412647e-043,3.27309973e-001,6.77340943e-001],
[1.36925828e-044,3.27936766e-001,6.77346752e-001],
[1.05730356e-045,3.28562812e-001,6.77351479e-001],
[7.39574411e-047,3.29188111e-001,6.77355126e-001],
[4.66226305e-048,3.29812661e-001,6.77357695e-001],
[2.63427994e-049,3.30436460e-001,6.77359187e-001],
[1.32628164e-050,3.31059507e-001,6.77359604e-001],
[5.91295626e-052,3.31681801e-001,6.77358947e-001],
[2.31882966e-053,3.32303339e-001,6.77357219e-001],
[7.94194288e-055,3.32924122e-001,6.77354421e-001],
[2.35753447e-056,3.33544146e-001,6.77350555e-001],
[6.01595774e-058,3.34163412e-001,6.77345623e-001],
[1.30812936e-059,3.34781917e-001,6.77339626e-001],
[2.40103473e-061,3.35399661e-001,6.77332566e-001],
[3.68251333e-063,3.36016641e-001,6.77324444e-001],
[4.66821046e-065,3.36632858e-001,6.77315263e-001],
[4.83407837e-067,3.37248308e-001,6.77305023e-001],
[4.03767750e-069,3.37862993e-001,6.77293727e-001],
[2.68326921e-071,3.38476909e-001,6.77281376e-001],
[1.39794990e-073,3.39090056e-001,6.77267972e-001],
[5.61909707e-076,3.39702433e-001,6.77253516e-001],
[1.71262320e-078,3.40314038e-001,6.77238011e-001],
[3.88428540e-081,3.40924871e-001,6.77221456e-001],
[6.42307147e-084,3.41534930e-001,6.77203855e-001],
[7.57365005e-087,3.42144214e-001,6.77185208e-001],
[6.21560881e-090,3.42752722e-001,6.77165517e-001],
[3.45784376e-093,3.43360454e-001,6.77144783e-001],
[1.26687328e-096,3.43967407e-001,6.77123009e-001],
[2.96172554e-100,3.44573582e-001,6.77100196e-001],
[4.26771896e-104,3.45178976e-001,6.77076345e-001],
[3.64891474e-108,3.45783590e-001,6.77051457e-001],
[1.77529422e-112,3.46387422e-001,6.77025534e-001],
[4.69330350e-117,3.46990471e-001,6.76998578e-001],
[6.40707637e-122,3.47592736e-001,6.76970590e-001],
[4.26900008e-127,3.48194216e-001,6.76941571e-001],
[1.30413294e-132,3.48794911e-001,6.76911523e-001],
[1.70399149e-138,3.49394819e-001,6.76880448e-001],
[8.81345063e-145,3.49993940e-001,6.76848346e-001],
[1.65509436e-151,3.50592273e-001,6.76815219e-001],
[1.02443437e-158,3.51189816e-001,6.76781069e-001],
[1.87491135e-166,3.51786570e-001,6.76745897e-001],
[8.97956481e-175,3.52382534e-001,6.76709704e-001],
[9.80463987e-184,3.52977706e-001,6.76672491e-001],
[2.08802434e-193,3.53572085e-001,6.76634261e-001],
[7.26458493e-204,3.54165672e-001,6.76595013e-001],
[3.37431095e-215,3.54758466e-001,6.76554751e-001],
[1.66122483e-227,3.55350465e-001,6.76513474e-001],
[6.65167745e-241,3.55941669e-001,6.76471185e-001],
[1.59665112e-255,3.56532077e-001,6.76427884e-001],
[1.61444239e-271,3.57121689e-001,6.76383573e-001],
[4.56392280e-289,3.57710504e-001,6.76338253e-001],
[2.23546032e-308,3.58298521e-001,6.76291926e-001],
[0.00000000e+000,3.58885740e-001,6.76244592e-001],
[0.00000000e+000,3.59472160e-001,6.76196254e-001],
[0.00000000e+000,3.60057781e-001,6.76146911e-001],
[0.00000000e+000,3.60642602e-001,6.76096566e-001],
[0.00000000e+000,3.61226622e-001,6.76045220e-001],
[0.00000000e+000,3.61809841e-001,6.75992874e-001],
[0.00000000e+000,3.62392259e-001,6.75939528e-001],
[0.00000000e+000,3.62973874e-001,6.75885185e-001],
[0.00000000e+000,3.63554687e-001,6.75829846e-001],
[0.00000000e+000,3.64134697e-001,6.75773511e-001],
[0.00000000e+000,3.64713903e-001,6.75716183e-001],
[0.00000000e+000,3.65292305e-001,6.75657861e-001],
[0.00000000e+000,3.65869902e-001,6.75598547e-001],
[0.00000000e+000,3.66446695e-001,6.75538243e-001],
[0.00000000e+000,3.67022683e-001,6.75476950e-001],
[0.00000000e+000,3.67597864e-001,6.75414668e-001],
[0.00000000e+000,3.68172240e-001,6.75351399e-001],
[0.00000000e+000,3.68745809e-001,6.75287144e-001],
[0.00000000e+000,3.69318572e-001,6.75221904e-001],
[0.00000000e+000,3.69890527e-001,6.75155680e-001],
[0.00000000e+000,3.70461675e-001,6.75088473e-001],
[0.00000000e+000,3.71032014e-001,6.75020285e-001],
[0.00000000e+000,3.71601546e-001,6.74951116e-001],
[0.00000000e+000,3.72170270e-001,6.74880968e-001],
[0.00000000e+000,3.72738185e-001,6.74809841e-001],
[0.00000000e+000,3.73305290e-001,6.74737737e-001],
[0.00000000e+000,3.73871587e-001,6.74664657e-001],
[0.00000000e+000,3.74437074e-001,6.74590601e-001],
[0.00000000e+000,3.75001752e-001,6.74515571e-001],
[0.00000000e+000,3.75565620e-001,6.74439568e-001],
[0.00000000e+000,3.76128677e-001,6.74362593e-001],
[0.00000000e+000,3.76690924e-001,6.74284647e-001],
[0.00000000e+000,3.77252361e-001,6.74205730e-001],
[0.00000000e+000,3.77812988e-001,6.74125844e-001],
[0.00000000e+000,3.78372803e-001,6.74044990e-001],
[0.00000000e+000,3.78931808e-001,6.73963169e-001],
[0.00000000e+000,3.79490001e-001,6.73880382e-001],
[0.00000000e+000,3.80047383e-001,6.73796630e-001],
[0.00000000e+000,3.80603954e-001,6.73711913e-001],
[0.00000000e+000,3.81159714e-001,6.73626233e-001],
[0.00000000e+000,3.81714662e-001,6.73539591e-001],
[0.00000000e+000,3.82268799e-001,6.73451987e-001],
[0.00000000e+000,3.82822124e-001,6.73363423e-001],
[0.00000000e+000,3.83374637e-001,6.73273900e-001],
[0.00000000e+000,3.83926339e-001,6.73183418e-001],
[0.00000000e+000,3.84477229e-001,6.73091978e-001],
[0.00000000e+000,3.85027307e-001,6.72999581e-001],
[0.00000000e+000,3.85576573e-001,6.72906229e-001],
[0.00000000e+000,3.86125028e-001,6.72811921e-001],
[0.00000000e+000,3.86672671e-001,6.72716660e-001],
[0.00000000e+000,3.87219502e-001,6.72620445e-001],
[0.00000000e+000,3.87765521e-001,6.72523278e-001],
[0.00000000e+000,3.88310729e-001,6.72425160e-001],
[0.00000000e+000,3.88855125e-001,6.72326091e-001],
[0.00000000e+000,3.89398709e-001,6.72226073e-001],
[0.00000000e+000,3.89941482e-001,6.72125105e-001],
[0.00000000e+000,3.90483443e-001,6.72023190e-001],
[0.00000000e+000,3.91024594e-001,6.71920328e-001],
[0.00000000e+000,3.91564932e-001,6.71816519e-001],
[0.00000000e+000,3.92104460e-001,6.71711765e-001],
[4.54621431e-308,3.92643177e-001,6.71606066e-001],
[5.64520178e-289,3.93181083e-001,6.71499423e-001],
[1.30608788e-271,3.93718178e-001,6.71391837e-001],
[8.98280057e-256,3.94254463e-001,6.71283310e-001],
[2.74143895e-241,3.94789937e-001,6.71173840e-001],
[5.24271227e-228,3.95324601e-001,6.71063431e-001],
[8.46889915e-216,3.95858454e-001,6.70952081e-001],
[1.49780539e-204,3.96391498e-001,6.70839792e-001],
[3.63662243e-194,3.96923732e-001,6.70726566e-001],
[1.47761426e-184,3.97455157e-001,6.70612401e-001],
[1.19560286e-175,3.97985772e-001,6.70497301e-001],
[2.24567726e-167,3.98515578e-001,6.70381264e-001],
[1.12122112e-159,3.99044575e-001,6.70264292e-001],
[1.67801552e-152,3.99572764e-001,6.70146385e-001],
[8.37634431e-146,4.00100144e-001,6.70027545e-001],
[1.53401166e-139,4.00626716e-001,6.69907773e-001],
[1.12225034e-133,4.01152480e-001,6.69787068e-001],
[3.53969946e-128,4.01677437e-001,6.69665431e-001],
[5.15482649e-123,4.02201586e-001,6.69542864e-001],
[3.68654036e-118,4.02724928e-001,6.69419367e-001],
[1.36882176e-113,4.03247463e-001,6.69294941e-001],
[2.77488297e-109,4.03769191e-001,6.69169586e-001],
[3.21441847e-105,4.04290114e-001,6.69043303e-001],
[2.21759146e-101,4.04810230e-001,6.68916093e-001],
[9.46049563e-098,4.05329541e-001,6.68787957e-001],
[2.58271213e-094,4.05848047e-001,6.68658895e-001],
[4.65523946e-091,4.06365748e-001,6.68528908e-001],
[5.70056901e-088,4.06882644e-001,6.68397997e-001],
[4.86812193e-085,4.07398737e-001,6.68266162e-001],
[2.96950492e-082,4.07914025e-001,6.68133404e-001],
[1.32265466e-079,4.08428510e-001,6.67999724e-001],
[4.38974818e-077,4.08942191e-001,6.67865123e-001],
[1.10600728e-074,4.09455070e-001,6.67729600e-001],
[2.15211216e-072,4.09967147e-001,6.67593157e-001],
[3.28587185e-070,4.10478421e-001,6.67455794e-001],
[3.99470184e-068,4.10988894e-001,6.67317513e-001],
[3.91977303e-066,4.11498566e-001,6.67178313e-001],
[3.14370936e-064,4.12007438e-001,6.67038195e-001],
[2.08495074e-062,4.12515508e-001,6.66897161e-001],
[1.15591762e-060,4.13022779e-001,6.66755209e-001],
[5.41141177e-059,4.13529251e-001,6.66612343e-001],
[2.15932767e-057,4.14034923e-001,6.66468561e-001],
[7.40873483e-056,4.14539797e-001,6.66323864e-001],
[2.20355807e-054,4.15043873e-001,6.66178254e-001],
[5.72482071e-053,4.15547151e-001,6.66031730e-001],
[1.30840248e-051,4.16049632e-001,6.65884294e-001],
[2.64818335e-050,4.16551316e-001,6.65735945e-001],
[4.77619982e-049,4.17052204e-001,6.65586685e-001],
[7.72101800e-048,4.17552296e-001,6.65436515e-001],
[1.12485444e-046,4.18051593e-001,6.65285434e-001],
[1.48447760e-045,4.18550095e-001,6.65133443e-001],
[1.78318707e-044,4.19047803e-001,6.64980544e-001],
[1.95853243e-043,4.19544717e-001,6.64826735e-001],
[1.97525491e-042,4.20040837e-001,6.64672019e-001],
[1.83659524e-041,4.20536165e-001,6.64516396e-001],
[1.58030214e-040,4.21030701e-001,6.64359866e-001],
[1.26283789e-039,4.21524445e-001,6.64202430e-001],
[9.40356900e-039,4.22017397e-001,6.64044088e-001],
[6.54561696e-038,4.22509559e-001,6.63884841e-001],
[4.27189015e-037,4.23000931e-001,6.63724690e-001],
[2.62137282e-036,4.23491514e-001,6.63563635e-001],
[1.51648366e-035,4.23981307e-001,6.63401677e-001],
[8.29173843e-035,4.24470312e-001,6.63238816e-001],
[4.29529217e-034,4.24958529e-001,6.63075052e-001],
[2.11283102e-033,4.25445959e-001,6.62910387e-001],
[9.88999748e-033,4.25932602e-001,6.62744821e-001],
[4.41441645e-032,4.26418459e-001,6.62578355e-001],
[1.88251011e-031,4.26903530e-001,6.62410988e-001],
[7.68399388e-031,4.27387817e-001,6.62242722e-001],
[3.00733137e-030,4.27871319e-001,6.62073557e-001],
[1.13042444e-029,4.28354037e-001,6.61903493e-001],
[4.08746333e-029,4.28835972e-001,6.61732532e-001],
[1.42387255e-028,4.29317124e-001,6.61560673e-001],
[4.78536198e-028,4.29797495e-001,6.61387918e-001],
[1.55373469e-027,4.30277084e-001,6.61214266e-001],
[4.88001779e-027,4.30755892e-001,6.61039719e-001],
[1.48452049e-026,4.31233920e-001,6.60864276e-001],
[4.37909278e-026,4.31711169e-001,6.60687938e-001],
[1.25402064e-025,4.32187639e-001,6.60510707e-001],
[3.48991641e-025,4.32663331e-001,6.60332581e-001],
[9.44846748e-025,4.33138245e-001,6.60153563e-001],
[2.49097888e-024,4.33612382e-001,6.59973652e-001],
[6.40101036e-024,4.34085743e-001,6.59792848e-001],
[1.60467272e-023,4.34558329e-001,6.59611153e-001],
[3.92786537e-023,4.35030139e-001,6.59428567e-001],
[9.39540690e-023,4.35501176e-001,6.59245090e-001],
[2.19788489e-022,4.35971438e-001,6.59060723e-001],
[5.03212792e-022,4.36440928e-001,6.58875466e-001],
[1.12841562e-021,4.36909646e-001,6.58689320e-001],
[2.48003309e-021,4.37377591e-001,6.58502286e-001],
[5.34570167e-021,4.37844766e-001,6.58314363e-001],
[1.13080294e-020,4.38311171e-001,6.58125553e-001],
[2.34892429e-020,4.38776806e-001,6.57935855e-001],
[4.79407943e-020,4.39241673e-001,6.57745271e-001],
[9.61921520e-020,4.39705771e-001,6.57553800e-001],
[1.89848288e-019,4.40169102e-001,6.57361444e-001],
[3.68749608e-019,4.40631666e-001,6.57168202e-001],
[7.05229887e-019,4.41093464e-001,6.56974076e-001],
[1.32865480e-018,4.41554497e-001,6.56779065e-001],
[2.46703885e-018,4.42014765e-001,6.56583171e-001],
[4.51663119e-018,4.42474270e-001,6.56386393e-001],
[8.15667660e-018,4.42933011e-001,6.56188732e-001],
[1.45361718e-017,4.43390990e-001,6.55990189e-001],
[2.55738793e-017,4.43848207e-001,6.55790764e-001],
[4.44342824e-017,4.44304663e-001,6.55590457e-001],
[7.62735379e-017,4.44760359e-001,6.55389270e-001],
[1.29394895e-016,4.45215296e-001,6.55187202e-001],
[2.17017992e-016,4.45669473e-001,6.54984253e-001],
[3.59958309e-016,4.46122893e-001,6.54780426e-001],
[5.90641501e-016,4.46575555e-001,6.54575719e-001],
[9.59055138e-016,4.47027461e-001,6.54370133e-001],
[1.54148379e-015,4.47478611e-001,6.54163669e-001],
[2.45320341e-015,4.47929006e-001,6.53956328e-001],
[3.86675389e-015,4.48378647e-001,6.53748109e-001],
[6.03799767e-015,4.48827535e-001,6.53539013e-001],
[9.34294767e-015,4.49275669e-001,6.53329042e-001],
[1.43293606e-014,4.49723052e-001,6.53118194e-001],
[2.17884013e-014,4.50169684e-001,6.52906470e-001],
[3.28533632e-014,4.50615565e-001,6.52693872e-001],
[4.91345683e-014,4.51060696e-001,6.52480399e-001],
[7.29022640e-014,4.51505079e-001,6.52266052e-001],
[1.07332709e-013,4.51948713e-001,6.52050832e-001],
[1.56836830e-013,4.52391600e-001,6.51834738e-001],
[2.27495994e-013,4.52833741e-001,6.51617772e-001],
[3.27635762e-013,4.53275136e-001,6.51399934e-001],
[4.68576148e-013,4.53715786e-001,6.51181223e-001],
[6.65606181e-013,4.54155692e-001,6.50961642e-001],
[9.39241629e-013,4.54594854e-001,6.50741189e-001],
[1.31683793e-012,4.55033274e-001,6.50519866e-001],
[1.83464593e-012,4.55470952e-001,6.50297673e-001],
[2.54041641e-012,4.55907889e-001,6.50074611e-001],
[3.49668048e-012,4.56344086e-001,6.49850679e-001],
[4.78485796e-012,4.56779544e-001,6.49625879e-001],
[6.51037410e-012,4.57214263e-001,6.49400211e-001],
[8.80899775e-012,4.57648244e-001,6.49173675e-001],
[1.18546511e-011,4.58081488e-001,6.48946272e-001],
[1.58689835e-011,4.58513996e-001,6.48718002e-001],
[2.11330486e-011,4.58945769e-001,6.48488866e-001],
[2.80014775e-011,4.59376807e-001,6.48258864e-001],
[3.69195996e-011,4.59807112e-001,6.48027996e-001],
[4.84440271e-011,4.60236684e-001,6.47796264e-001],
[6.32672924e-011,4.60665524e-001,6.47563667e-001],
[8.22472044e-011,4.61093632e-001,6.47330206e-001],
[1.06441677e-010,4.61521010e-001,6.47095881e-001],
[1.37149875e-010,4.61947659e-001,6.46860693e-001],
[1.75960619e-010,4.62373579e-001,6.46624643e-001],
[2.24809105e-010,4.62798771e-001,6.46387730e-001],
[2.86043105e-010,4.63223236e-001,6.46149955e-001],
[3.62499927e-010,4.63646974e-001,6.45911320e-001],
[4.57595552e-010,4.64069987e-001,6.45671823e-001],
[5.75427502e-010,4.64492276e-001,6.45431466e-001],
[7.20893105e-010,4.64913841e-001,6.45190249e-001],
[8.99825006e-010,4.65334683e-001,6.44948173e-001],
[1.11914589e-009,4.65754803e-001,6.44705237e-001],
[1.38704455e-009,4.66174202e-001,6.44461443e-001],
[1.71317557e-009,4.66592880e-001,6.44216792e-001],
[2.10888510e-009,4.67010839e-001,6.43971282e-001],
[2.58746524e-009,4.67428079e-001,6.43724915e-001],
[3.16443993e-009,4.67844602e-001,6.43477692e-001],
[3.85788505e-009,4.68260407e-001,6.43229612e-001],
[4.68878596e-009,4.68675497e-001,6.42980677e-001],
[5.68143562e-009,4.69089871e-001,6.42730887e-001],
[6.86387662e-009,4.69503530e-001,6.42480241e-001],
[8.26839061e-009,4.69916476e-001,6.42228742e-001],
[9.93203873e-009,4.70328710e-001,6.41976388e-001],
[1.18972568e-008,4.70740231e-001,6.41723181e-001],
[1.42125089e-008,4.71151042e-001,6.41469122e-001],
[1.69330038e-008,4.71561142e-001,6.41214210e-001],
[2.01214771e-008,4.71970534e-001,6.40958446e-001],
[2.38490446e-008,4.72379216e-001,6.40701830e-001],
[2.81961300e-008,4.72787192e-001,6.40444364e-001],
[3.32534709e-008,4.73194460e-001,6.40186047e-001],
[3.91232078e-008,4.73601023e-001,6.39926880e-001],
[4.59200605e-008,4.74006881e-001,6.39666864e-001],
[5.37725945e-008,4.74412034e-001,6.39405998e-001],
[6.28245830e-008,4.74816485e-001,6.39144285e-001],
[7.32364679e-008,4.75220233e-001,6.38881723e-001],
[8.51869226e-008,4.75623280e-001,6.38618313e-001],
[9.88745223e-008,4.76025626e-001,6.38354057e-001],
[1.14519523e-007,4.76427272e-001,6.38088954e-001],
[1.32365756e-007,4.76828220e-001,6.37823005e-001],
[1.52682635e-007,4.77228469e-001,6.37556211e-001],
[1.75767286e-007,4.77628022e-001,6.37288571e-001],
[2.01946799e-007,4.78026878e-001,6.37020087e-001],
[2.31580604e-007,4.78425039e-001,6.36750760e-001],
[2.65062970e-007,4.78822505e-001,6.36480588e-001],
[3.02825638e-007,4.79219278e-001,6.36209574e-001],
[3.45340583e-007,4.79615358e-001,6.35937717e-001],
[3.93122902e-007,4.80010746e-001,6.35665018e-001],
[4.46733844e-007,4.80405443e-001,6.35391478e-001],
[5.06783962e-007,4.80799450e-001,6.35117097e-001],
[5.73936402e-007,4.81192768e-001,6.34841876e-001],
[6.48910331e-007,4.81585397e-001,6.34565815e-001],
[7.32484481e-007,4.81977339e-001,6.34288914e-001],
[8.25500840e-007,4.82368595e-001,6.34011175e-001],
[9.28868460e-007,4.82759164e-001,6.33732597e-001],
[1.04356740e-006,4.83149049e-001,6.33453182e-001],
[1.17065279e-006,4.83538250e-001,6.33172930e-001],
[1.31125899e-006,4.83926768e-001,6.32891841e-001],
[1.46660396e-006,4.84314604e-001,6.32609916e-001],
[1.63799359e-006,4.84701758e-001,6.32327155e-001],
[1.82682629e-006,4.85088232e-001,6.32043560e-001],
[2.03459760e-006,4.85474027e-001,6.31759130e-001],
[2.26290494e-006,4.85859143e-001,6.31473866e-001],
[2.51345241e-006,4.86243581e-001,6.31187769e-001],
[2.78805573e-006,4.86627342e-001,6.30900840e-001],
[3.08864724e-006,4.87010428e-001,6.30613078e-001],
[3.41728097e-006,4.87392838e-001,6.30324485e-001],
[3.77613780e-006,4.87774574e-001,6.30035060e-001],
[4.16753066e-006,4.88155637e-001,6.29744805e-001],
[4.59390980e-006,4.88536027e-001,6.29453721e-001],
[5.05786811e-006,4.88915746e-001,6.29161807e-001],
[5.56214645e-006,4.89294794e-001,6.28869064e-001],
[6.10963909e-006,4.89673172e-001,6.28575493e-001],
[6.70339902e-006,4.90050882e-001,6.28281095e-001],
[7.34664349e-006,4.90427923e-001,6.27985870e-001],
[8.04275933e-006,4.90804297e-001,6.27689819e-001],
[8.79530842e-006,4.91180006e-001,6.27392942e-001],
[9.60803312e-006,4.91555048e-001,6.27095239e-001],
[1.04848616e-005,4.91929427e-001,6.26796713e-001],
[1.14299132e-005,4.92303142e-001,6.26497362e-001],
[1.24475039e-005,4.92676194e-001,6.26197188e-001],
[1.35421513e-005,4.93048584e-001,6.25896192e-001],
[1.47185799e-005,4.93420314e-001,6.25594374e-001],
[1.59817266e-005,4.93791383e-001,6.25291734e-001],
[1.73367451e-005,4.94161794e-001,6.24988273e-001],
[1.87890116e-005,4.94531546e-001,6.24683993e-001],
[2.03441290e-005,4.94900641e-001,6.24378893e-001],
[2.20079320e-005,4.95269079e-001,6.24072974e-001],
[2.37864919e-005,4.95636862e-001,6.23766237e-001],
[2.56861207e-005,4.96003990e-001,6.23458682e-001],
[2.77133760e-005,4.96370464e-001,6.23150311e-001],
[2.98750647e-005,4.96736286e-001,6.22841123e-001],
[3.21782476e-005,4.97101455e-001,6.22531120e-001],
[3.46302431e-005,4.97465973e-001,6.22220302e-001],
[3.72386310e-005,4.97829842e-001,6.21908670e-001],
[4.00112562e-005,4.98193060e-001,6.21596224e-001],
[4.29562321e-005,4.98555631e-001,6.21282966e-001],
[4.60819439e-005,4.98917553e-001,6.20968895e-001],
[4.93970516e-005,4.99278829e-001,6.20654013e-001],
[5.29104928e-005,4.99639459e-001,6.20338320e-001],
[5.66314857e-005,4.99999445e-001,6.20021817e-001],
[6.05695311e-005,5.00358786e-001,6.19704505e-001],
[6.47344151e-005,5.00717484e-001,6.19386384e-001],
[6.91362108e-005,5.01075540e-001,6.19067455e-001],
[7.37852804e-005,5.01432954e-001,6.18747719e-001],
[7.86922764e-005,5.01789728e-001,6.18427176e-001],
[8.38681434e-005,5.02145863e-001,6.18105828e-001],
[8.93241190e-005,5.02501358e-001,6.17783675e-001],
[9.50717348e-005,5.02856216e-001,6.17460717e-001],
[1.01122817e-004,5.03210437e-001,6.17136956e-001],
[1.07489487e-004,5.03564022e-001,6.16812392e-001],
[1.14184161e-004,5.03916971e-001,6.16487026e-001],
[1.21219551e-004,5.04269286e-001,6.16160858e-001],
[1.28608663e-004,5.04620968e-001,6.15833891e-001],
[1.36364799e-004,5.04972017e-001,6.15506123e-001],
[1.44501553e-004,5.05322435e-001,6.15177556e-001],
[1.53032812e-004,5.05672222e-001,6.14848191e-001],
[1.61972756e-004,5.06021379e-001,6.14518029e-001],
[1.71335853e-004,5.06369906e-001,6.14187070e-001],
[1.81136859e-004,5.06717806e-001,6.13855315e-001],
[1.91390818e-004,5.07065079e-001,6.13522765e-001],
[2.02113057e-004,5.07411725e-001,6.13189421e-001],
[2.13319185e-004,5.07757745e-001,6.12855284e-001],
[2.25025090e-004,5.08103141e-001,6.12520353e-001],
[2.37246935e-004,5.08447913e-001,6.12184631e-001],
[2.50001158e-004,5.08792062e-001,6.11848118e-001],
[2.63304467e-004,5.09135589e-001,6.11510815e-001],
[2.77173833e-004,5.09478495e-001,6.11172723e-001],
[2.91626493e-004,5.09820781e-001,6.10833842e-001],
[3.06679942e-004,5.10162447e-001,6.10494173e-001],
[3.22351928e-004,5.10503495e-001,6.10153717e-001],
[3.38660451e-004,5.10843925e-001,6.09812476e-001],
[3.55623755e-004,5.11183739e-001,6.09470450e-001],
[3.73260327e-004,5.11522936e-001,6.09127639e-001],
[3.91588888e-004,5.11861519e-001,6.08784045e-001],
[4.10628392e-004,5.12199487e-001,6.08439669e-001],
[4.30398018e-004,5.12536842e-001,6.08094511e-001],
[4.50917166e-004,5.12873584e-001,6.07748572e-001],
[4.72205450e-004,5.13209715e-001,6.07401854e-001],
[4.94282695e-004,5.13545236e-001,6.07054357e-001],
[5.17168927e-004,5.13880146e-001,6.06706082e-001],
[5.40884372e-004,5.14214448e-001,6.06357029e-001],
[5.65449446e-004,5.14548141e-001,6.06007201e-001],
[5.90884751e-004,5.14881227e-001,6.05656598e-001],
[6.17211067e-004,5.15213707e-001,6.05305220e-001],
[6.44449348e-004,5.15545581e-001,6.04953069e-001],
[6.72620712e-004,5.15876851e-001,6.04600146e-001],
[7.01746438e-004,5.16207517e-001,6.04246451e-001],
[7.31847956e-004,5.16537580e-001,6.03891986e-001],
[7.62946842e-004,5.16867041e-001,6.03536752e-001],
[7.95064811e-004,5.17195900e-001,6.03180749e-001],
[8.28223710e-004,5.17524159e-001,6.02823978e-001],
[8.62445510e-004,5.17851819e-001,6.02466441e-001],
[8.97752301e-004,5.18178880e-001,6.02108139e-001],
[9.34166282e-004,5.18505344e-001,6.01749071e-001],
[9.71709755e-004,5.18831210e-001,6.01389241e-001],
[1.01040512e-003,5.19156481e-001,6.01028648e-001],
[1.05027486e-003,5.19481156e-001,6.00667293e-001],
[1.09134155e-003,5.19805237e-001,6.00305178e-001],
[1.13362782e-003,5.20128724e-001,5.99942304e-001],
[1.17715640e-003,5.20451619e-001,5.99578671e-001],
[1.22195004e-003,5.20773922e-001,5.99214281e-001],
[1.26803157e-003,5.21095633e-001,5.98849134e-001],
[1.31542384e-003,5.21416755e-001,5.98483233e-001],
[1.36414977e-003,5.21737288e-001,5.98116577e-001],
[1.41423229e-003,5.22057232e-001,5.97749168e-001],
[1.46569434e-003,5.22376588e-001,5.97381007e-001],
[1.51855889e-003,5.22695358e-001,5.97012096e-001],
[1.57284893e-003,5.23013542e-001,5.96642434e-001],
[1.62858743e-003,5.23331141e-001,5.96272024e-001],
[1.68579736e-003,5.23648156e-001,5.95900866e-001],
[1.74450168e-003,5.23964587e-001,5.95528962e-001],
[1.80472332e-003,5.24280436e-001,5.95156312e-001],
[1.86648519e-003,5.24595703e-001,5.94782919e-001],
[1.92981016e-003,5.24910389e-001,5.94408782e-001],
[1.99472106e-003,5.25224496e-001,5.94033903e-001],
[2.06124068e-003,5.25538023e-001,5.93658283e-001],
[2.12939173e-003,5.25850972e-001,5.93281924e-001],
[2.19919688e-003,5.26163343e-001,5.92904827e-001],
[2.27067872e-003,5.26475138e-001,5.92526992e-001],
[2.34385977e-003,5.26786356e-001,5.92148421e-001],
[2.41876247e-003,5.27097000e-001,5.91769115e-001],
[2.49540915e-003,5.27407070e-001,5.91389076e-001],
[2.57382207e-003,5.27716566e-001,5.91008304e-001],
[2.65402337e-003,5.28025490e-001,5.90626800e-001],
[2.73603511e-003,5.28333842e-001,5.90244567e-001],
[2.81987919e-003,5.28641624e-001,5.89861605e-001],
[2.90557743e-003,5.28948835e-001,5.89477915e-001],
[2.99315151e-003,5.29255477e-001,5.89093500e-001],
[3.08262298e-003,5.29561551e-001,5.88708359e-001],
[3.17401325e-003,5.29867057e-001,5.88322494e-001],
[3.26734358e-003,5.30171997e-001,5.87935906e-001],
[3.36263510e-003,5.30476370e-001,5.87548598e-001],
[3.45990878e-003,5.30780179e-001,5.87160569e-001],
[3.55918541e-003,5.31083423e-001,5.86771822e-001],
[3.66048565e-003,5.31386104e-001,5.86382357e-001],
[3.76382997e-003,5.31688222e-001,5.85992177e-001],
[3.86923866e-003,5.31989778e-001,5.85601281e-001],
[3.97673185e-003,5.32290774e-001,5.85209672e-001],
[4.08632948e-003,5.32591209e-001,5.84817351e-001],
[4.19805129e-003,5.32891084e-001,5.84424320e-001],
[4.31191684e-003,5.33190402e-001,5.84030579e-001],
[4.42794550e-003,5.33489161e-001,5.83636129e-001],
[4.54615641e-003,5.33787364e-001,5.83240974e-001],
[4.66656854e-003,5.34085010e-001,5.82845112e-001],
[4.78920062e-003,5.34382101e-001,5.82448547e-001],
[4.91407120e-003,5.34678637e-001,5.82051280e-001],
[5.04119857e-003,5.34974620e-001,5.81653311e-001],
[5.17060085e-003,5.35270050e-001,5.81254643e-001],
[5.30229590e-003,5.35564928e-001,5.80855276e-001],
[5.43630136e-003,5.35859254e-001,5.80455213e-001],
[5.57263465e-003,5.36153030e-001,5.80054454e-001],
[5.71131294e-003,5.36446256e-001,5.79653001e-001],
[5.85235319e-003,5.36738934e-001,5.79250855e-001],
[5.99577209e-003,5.37031063e-001,5.78848019e-001],
[6.14158611e-003,5.37322645e-001,5.78444493e-001],
[6.28981147e-003,5.37613680e-001,5.78040278e-001],
[6.44046413e-003,5.37904170e-001,5.77635377e-001],
[6.59355982e-003,5.38194115e-001,5.77229791e-001],
[6.74911401e-003,5.38483515e-001,5.76823522e-001],
[6.90714191e-003,5.38772372e-001,5.76416570e-001],
[7.06765848e-003,5.39060687e-001,5.76008937e-001],
[7.23067842e-003,5.39348460e-001,5.75600626e-001],
[7.39621618e-003,5.39635692e-001,5.75191637e-001],
[7.56428593e-003,5.39922383e-001,5.74781971e-001],
[7.73490159e-003,5.40208536e-001,5.74371632e-001],
[7.90807681e-003,5.40494149e-001,5.73960619e-001],
[8.08382498e-003,5.40779225e-001,5.73548936e-001],
[8.26215921e-003,5.41063764e-001,5.73136582e-001],
[8.44309236e-003,5.41347766e-001,5.72723561e-001],
[8.62663701e-003,5.41631233e-001,5.72309873e-001],
[8.81280547e-003,5.41914165e-001,5.71895520e-001],
[9.00160977e-003,5.42196563e-001,5.71480503e-001],
[9.19306168e-003,5.42478428e-001,5.71064825e-001],
[9.38717270e-003,5.42759761e-001,5.70648487e-001],
[9.58395404e-003,5.43040562e-001,5.70231491e-001],
[9.78341666e-003,5.43320832e-001,5.69813838e-001],
[9.98557121e-003,5.43600572e-001,5.69395529e-001],
[1.01904281e-002,5.43879783e-001,5.68976568e-001],
[1.03979975e-002,5.44158465e-001,5.68556955e-001],
[1.06082891e-002,5.44436619e-001,5.68136691e-001],
[1.08213127e-002,5.44714246e-001,5.67715780e-001],
[1.10370774e-002,5.44991348e-001,5.67294222e-001],
[1.12555923e-002,5.45267923e-001,5.66872019e-001],
[1.14768662e-002,5.45543974e-001,5.66449172e-001],
[1.17009075e-002,5.45819501e-001,5.66025685e-001],
[1.19277244e-002,5.46094504e-001,5.65601558e-001],
[1.21573249e-002,5.46368986e-001,5.65176792e-001],
[1.23897166e-002,5.46642945e-001,5.64751391e-001],
[1.26249069e-002,5.46916384e-001,5.64325356e-001],
[1.28629028e-002,5.47189302e-001,5.63898687e-001],
[1.31037113e-002,5.47461701e-001,5.63471388e-001],
[1.33473389e-002,5.47733581e-001,5.63043461e-001],
[1.35937919e-002,5.48004944e-001,5.62614905e-001],
[1.38430763e-002,5.48275789e-001,5.62185725e-001],
[1.40951979e-002,5.48546118e-001,5.61755921e-001],
[1.43501622e-002,5.48815931e-001,5.61325496e-001],
[1.46079744e-002,5.49085229e-001,5.60894451e-001],
[1.48686395e-002,5.49354013e-001,5.60462787e-001],
[1.51321622e-002,5.49622283e-001,5.60030508e-001],
[1.53985469e-002,5.49890041e-001,5.59597615e-001],
[1.56677979e-002,5.50157287e-001,5.59164109e-001],
[1.59399191e-002,5.50424022e-001,5.58729993e-001],
[1.62149140e-002,5.50690246e-001,5.58295268e-001],
[1.64927862e-002,5.50955960e-001,5.57859937e-001],
[1.67735388e-002,5.51221166e-001,5.57424002e-001],
[1.70571747e-002,5.51485863e-001,5.56987464e-001],
[1.73436965e-002,5.51750053e-001,5.56550325e-001],
[1.76331067e-002,5.52013736e-001,5.56112587e-001],
[1.79254074e-002,5.52276912e-001,5.55674252e-001],
[1.82206006e-002,5.52539584e-001,5.55235323e-001],
[1.85186879e-002,5.52801751e-001,5.54795801e-001],
[1.88196707e-002,5.53063414e-001,5.54355688e-001],
[1.91235503e-002,5.53324573e-001,5.53914986e-001],
[1.94303275e-002,5.53585231e-001,5.53473698e-001],
[1.97400031e-002,5.53845386e-001,5.53031824e-001],
[2.00525776e-002,5.54105041e-001,5.52589368e-001],
[2.03680512e-002,5.54364195e-001,5.52146332e-001],
[2.06864240e-002,5.54622850e-001,5.51702717e-001],
[2.10076957e-002,5.54881006e-001,5.51258525e-001],
[2.13318658e-002,5.55138664e-001,5.50813759e-001],
[2.16589338e-002,5.55395825e-001,5.50368420e-001],
[2.19888988e-002,5.55652489e-001,5.49922511e-001],
[2.23217596e-002,5.55908657e-001,5.49476034e-001],
[2.26575150e-002,5.56164329e-001,5.49028991e-001],
[2.29961633e-002,5.56419507e-001,5.48581385e-001],
[2.33377029e-002,5.56674192e-001,5.48133216e-001],
[2.36821318e-002,5.56928383e-001,5.47684488e-001],
[2.40294478e-002,5.57182082e-001,5.47235202e-001],
[2.43796486e-002,5.57435289e-001,5.46785361e-001],
[2.47327316e-002,5.57688005e-001,5.46334967e-001],
[2.50886940e-002,5.57940231e-001,5.45884022e-001],
[2.54475328e-002,5.58191967e-001,5.45432529e-001],
[2.58092449e-002,5.58443215e-001,5.44980489e-001],
[2.61738269e-002,5.58693974e-001,5.44527904e-001],
[2.65412752e-002,5.58944246e-001,5.44074778e-001],
[2.69115861e-002,5.59194031e-001,5.43621111e-001],
[2.72847556e-002,5.59443329e-001,5.43166908e-001],
[2.76607797e-002,5.59692143e-001,5.42712169e-001],
[2.80396540e-002,5.59940472e-001,5.42256896e-001],
[2.84213740e-002,5.60188316e-001,5.41801094e-001],
[2.88059351e-002,5.60435678e-001,5.41344762e-001],
[2.91933325e-002,5.60682557e-001,5.40887905e-001],
[2.95835611e-002,5.60928953e-001,5.40430524e-001],
[2.99766157e-002,5.61174869e-001,5.39972621e-001],
[3.03724910e-002,5.61420304e-001,5.39514199e-001],
[3.07711815e-002,5.61665259e-001,5.39055260e-001],
[3.11726815e-002,5.61909735e-001,5.38595807e-001],
[3.15769852e-002,5.62153733e-001,5.38135842e-001],
[3.19840865e-002,5.62397252e-001,5.37675366e-001],
[3.23939794e-002,5.62640295e-001,5.37214384e-001],
[3.28066574e-002,5.62882861e-001,5.36752896e-001],
[3.32221142e-002,5.63124951e-001,5.36290906e-001],
[3.36403430e-002,5.63366566e-001,5.35828416e-001],
[3.40613373e-002,5.63607707e-001,5.35365428e-001],
[3.44850900e-002,5.63848374e-001,5.34901945e-001],
[3.49115941e-002,5.64088568e-001,5.34437969e-001],
[3.53408425e-002,5.64328289e-001,5.33973502e-001],
[3.57728278e-002,5.64567539e-001,5.33508548e-001],
[3.62075425e-002,5.64806317e-001,5.33043108e-001],
[3.66449791e-002,5.65044625e-001,5.32577185e-001],
[3.70851299e-002,5.65282464e-001,5.32110782e-001],
[3.75279869e-002,5.65519833e-001,5.31643900e-001],
[3.79735423e-002,5.65756734e-001,5.31176544e-001],
[3.84217879e-002,5.65993167e-001,5.30708714e-001],
[3.88727155e-002,5.66229133e-001,5.30240414e-001],
[3.93263167e-002,5.66464633e-001,5.29771646e-001],
[3.97825832e-002,5.66699666e-001,5.29302412e-001],
[4.02415063e-002,5.66934235e-001,5.28832716e-001],
[4.07030774e-002,5.67168339e-001,5.28362560e-001],
[4.11672876e-002,5.67401980e-001,5.27891946e-001],
[4.16341281e-002,5.67635157e-001,5.27420877e-001],
[4.21035898e-002,5.67867872e-001,5.26949356e-001],
[4.25756637e-002,5.68100125e-001,5.26477385e-001],
[4.30503405e-002,5.68331916e-001,5.26004967e-001],
[4.35276110e-002,5.68563247e-001,5.25532104e-001],
[4.40074656e-002,5.68794119e-001,5.25058800e-001],
[4.44898949e-002,5.69024530e-001,5.24585056e-001],
[4.49748894e-002,5.69254484e-001,5.24110876e-001],
[4.54624393e-002,5.69483979e-001,5.23636262e-001],
[4.59525348e-002,5.69713017e-001,5.23161217e-001],
[4.64451660e-002,5.69941598e-001,5.22685743e-001],
[4.69403231e-002,5.70169724e-001,5.22209843e-001],
[4.74379961e-002,5.70397394e-001,5.21733521e-001],
[4.79381746e-002,5.70624609e-001,5.21256778e-001],
[4.84408487e-002,5.70851370e-001,5.20779617e-001],
[4.89460080e-002,5.71077677e-001,5.20302042e-001],
[4.94536421e-002,5.71303532e-001,5.19824054e-001],
[4.99637407e-002,5.71528934e-001,5.19345658e-001],
[5.04762933e-002,5.71753885e-001,5.18866854e-001],
[5.09912893e-002,5.71978384e-001,5.18387647e-001],
[5.15087181e-002,5.72202434e-001,5.17908039e-001],
[5.20285689e-002,5.72426034e-001,5.17428033e-001],
[5.25508311e-002,5.72649184e-001,5.16947631e-001],
[5.30754938e-002,5.72871886e-001,5.16466837e-001],
[5.36025461e-002,5.73094140e-001,5.15985653e-001],
[5.41319772e-002,5.73315948e-001,5.15504082e-001],
[5.46637759e-002,5.73537308e-001,5.15022127e-001],
[5.51979313e-002,5.73758222e-001,5.14539791e-001],
[5.57344323e-002,5.73978691e-001,5.14057077e-001],
[5.62732677e-002,5.74198716e-001,5.13573988e-001],
[5.68144263e-002,5.74418296e-001,5.13090526e-001],
[5.73578968e-002,5.74637433e-001,5.12606694e-001],
[5.79036680e-002,5.74856126e-001,5.12122496e-001],
[5.84517285e-002,5.75074378e-001,5.11637933e-001],
[5.90020669e-002,5.75292188e-001,5.11153011e-001],
[5.95546719e-002,5.75509556e-001,5.10667730e-001],
[6.01095319e-002,5.75726485e-001,5.10182094e-001],
[6.06666354e-002,5.75942973e-001,5.09696106e-001],
[6.12259708e-002,5.76159022e-001,5.09209769e-001],
[6.17875267e-002,5.76374633e-001,5.08723087e-001],
[6.23512914e-002,5.76589805e-001,5.08236061e-001],
[6.29172532e-002,5.76804540e-001,5.07748695e-001],
[6.34854005e-002,5.77018839e-001,5.07260992e-001],
[6.40557216e-002,5.77232701e-001,5.06772955e-001],
[6.46282047e-002,5.77446127e-001,5.06284587e-001],
[6.52028381e-002,5.77659118e-001,5.05795891e-001],
[6.57796099e-002,5.77871675e-001,5.05306870e-001],
[6.63585084e-002,5.78083798e-001,5.04817527e-001],
[6.69395218e-002,5.78295488e-001,5.04327866e-001],
[6.75226381e-002,5.78506745e-001,5.03837889e-001],
[6.81078456e-002,5.78717570e-001,5.03347599e-001],
[6.86951322e-002,5.78927964e-001,5.02856999e-001],
[6.92844862e-002,5.79137926e-001,5.02366093e-001],
[6.98758956e-002,5.79347459e-001,5.01874884e-001],
[7.04693483e-002,5.79556561e-001,5.01383374e-001],
[7.10648326e-002,5.79765235e-001,5.00891567e-001],
[7.16623363e-002,5.79973480e-001,5.00399467e-001],
[7.22618476e-002,5.80181297e-001,4.99907075e-001],
[7.28633544e-002,5.80388687e-001,4.99414396e-001],
[7.34668447e-002,5.80595650e-001,4.98921432e-001],
[7.40723066e-002,5.80802186e-001,4.98428187e-001],
[7.46797280e-002,5.81008297e-001,4.97934663e-001],
[7.52890968e-002,5.81213983e-001,4.97440865e-001],
[7.59004012e-002,5.81419245e-001,4.96946795e-001],
[7.65136289e-002,5.81624082e-001,4.96452456e-001],
[7.71287681e-002,5.81828496e-001,4.95957852e-001],
[7.77458066e-002,5.82032488e-001,4.95462986e-001],
[7.83647324e-002,5.82236057e-001,4.94967860e-001],
[7.89855336e-002,5.82439205e-001,4.94472479e-001],
[7.96081980e-002,5.82641931e-001,4.93976846e-001],
[8.02327137e-002,5.82844237e-001,4.93480964e-001],
[8.08590685e-002,5.83046124e-001,4.92984835e-001],
[8.14872506e-002,5.83247590e-001,4.92488464e-001],
[8.21172478e-002,5.83448638e-001,4.91991853e-001],
[8.27490482e-002,5.83649268e-001,4.91495007e-001],
[8.33826397e-002,5.83849480e-001,4.90997928e-001],
[8.40180104e-002,5.84049275e-001,4.90500619e-001],
[8.46551483e-002,5.84248654e-001,4.90003084e-001],
[8.52940414e-002,5.84447617e-001,4.89505326e-001],
[8.59346777e-002,5.84646164e-001,4.89007349e-001],
[8.65770452e-002,5.84844296e-001,4.88509155e-001],
[8.72211321e-002,5.85042014e-001,4.88010749e-001],
[8.78669264e-002,5.85239318e-001,4.87512133e-001],
[8.85144162e-002,5.85436209e-001,4.87013312e-001],
[8.91635896e-002,5.85632687e-001,4.86514287e-001],
[8.98144346e-002,5.85828753e-001,4.86015063e-001],
[9.04669395e-002,5.86024408e-001,4.85515643e-001],
[9.11210923e-002,5.86219651e-001,4.85016031e-001],
[9.17768812e-002,5.86414484e-001,4.84516229e-001],
[9.24342945e-002,5.86608908e-001,4.84016242e-001],
[9.30933202e-002,5.86802921e-001,4.83516072e-001],
[9.37539466e-002,5.86996526e-001,4.83015723e-001],
[9.44161620e-002,5.87189723e-001,4.82515199e-001],
[9.50799546e-002,5.87382512e-001,4.82014503e-001],
[9.57453127e-002,5.87574894e-001,4.81513638e-001],
[9.64122246e-002,5.87766869e-001,4.81012608e-001],
[9.70806786e-002,5.87958438e-001,4.80511417e-001],
[9.77506630e-002,5.88149601e-001,4.80010067e-001],
[9.84221663e-002,5.88340359e-001,4.79508563e-001],
[9.90951768e-002,5.88530713e-001,4.79006907e-001],
[9.97696829e-002,5.88720663e-001,4.78505103e-001],
[1.00445673e-001,5.88910209e-001,4.78003155e-001],
[1.01123136e-001,5.89099353e-001,4.77501067e-001],
[1.01802060e-001,5.89288094e-001,4.76998841e-001],
[1.02482433e-001,5.89476433e-001,4.76496481e-001],
[1.03164244e-001,5.89664370e-001,4.75993992e-001],
[1.03847482e-001,5.89851907e-001,4.75491375e-001],
[1.04532136e-001,5.90039044e-001,4.74988636e-001],
[1.05218193e-001,5.90225781e-001,4.74485777e-001],
[1.05905643e-001,5.90412118e-001,4.73982801e-001],
[1.06594474e-001,5.90598057e-001,4.73479714e-001],
[1.07284675e-001,5.90783598e-001,4.72976517e-001],
[1.07976235e-001,5.90968741e-001,4.72473215e-001],
[1.08669143e-001,5.91153487e-001,4.71969812e-001],
[1.09363386e-001,5.91337836e-001,4.71466310e-001],
[1.10058955e-001,5.91521789e-001,4.70962713e-001],
[1.10755838e-001,5.91705347e-001,4.70459026e-001],
[1.11454024e-001,5.91888509e-001,4.69955251e-001],
[1.12153502e-001,5.92071277e-001,4.69451392e-001],
[1.12854260e-001,5.92253651e-001,4.68947454e-001],
[1.13556289e-001,5.92435631e-001,4.68443438e-001],
[1.14259576e-001,5.92617218e-001,4.67939350e-001],
[1.14964112e-001,5.92798412e-001,4.67435193e-001],
[1.15669884e-001,5.92979215e-001,4.66930970e-001],
[1.16376883e-001,5.93159626e-001,4.66426684e-001],
[1.17085097e-001,5.93339646e-001,4.65922341e-001],
[1.17794516e-001,5.93519275e-001,4.65417943e-001],
[1.18505129e-001,5.93698515e-001,4.64913494e-001],
[1.19216924e-001,5.93877365e-001,4.64408997e-001],
[1.19929893e-001,5.94055825e-001,4.63904457e-001],
[1.20644023e-001,5.94233898e-001,4.63399877e-001],
[1.21359304e-001,5.94411582e-001,4.62895260e-001],
[1.22075726e-001,5.94588879e-001,4.62390611e-001],
[1.22793278e-001,5.94765789e-001,4.61885933e-001],
[1.23511949e-001,5.94942312e-001,4.61381229e-001],
[1.24231730e-001,5.95118449e-001,4.60876504e-001],
[1.24952609e-001,5.95294201e-001,4.60371762e-001],
[1.25674577e-001,5.95469568e-001,4.59867005e-001],
[1.26397622e-001,5.95644550e-001,4.59362237e-001],
[1.27121735e-001,5.95819148e-001,4.58857464e-001],
[1.27846906e-001,5.95993363e-001,4.58352687e-001],
[1.28573124e-001,5.96167194e-001,4.57847911e-001],
[1.29300378e-001,5.96340643e-001,4.57343139e-001],
[1.30028660e-001,5.96513710e-001,4.56838376e-001],
[1.30757958e-001,5.96686395e-001,4.56333624e-001],
[1.31488262e-001,5.96858699e-001,4.55828889e-001],
[1.32219563e-001,5.97030622e-001,4.55324173e-001],
[1.32951851e-001,5.97202166e-001,4.54819480e-001],
[1.33685115e-001,5.97373329e-001,4.54314815e-001],
[1.34419346e-001,5.97544113e-001,4.53810180e-001],
[1.35154533e-001,5.97714519e-001,4.53305580e-001],
[1.35890667e-001,5.97884546e-001,4.52801018e-001],
[1.36627738e-001,5.98054196e-001,4.52296498e-001],
[1.37365737e-001,5.98223468e-001,4.51792024e-001],
[1.38104653e-001,5.98392364e-001,4.51287600e-001],
[1.38844477e-001,5.98560883e-001,4.50783230e-001],
[1.39585199e-001,5.98729026e-001,4.50278916e-001],
[1.40326810e-001,5.98896794e-001,4.49774664e-001],
[1.41069300e-001,5.99064187e-001,4.49270477e-001],
[1.41812659e-001,5.99231205e-001,4.48766358e-001],
[1.42556879e-001,5.99397850e-001,4.48262312e-001],
[1.43301949e-001,5.99564121e-001,4.47758343e-001],
[1.44047860e-001,5.99730018e-001,4.47254453e-001],
[1.44794602e-001,5.99895544e-001,4.46750648e-001],
[1.45542167e-001,6.00060697e-001,4.46246930e-001],
[1.46290546e-001,6.00225478e-001,4.45743304e-001],
[1.47039728e-001,6.00389889e-001,4.45239773e-001],
[1.47789705e-001,6.00553928e-001,4.44736342e-001],
[1.48540467e-001,6.00717598e-001,4.44233013e-001],
[1.49292006e-001,6.00880897e-001,4.43729792e-001],
[1.50044312e-001,6.01043828e-001,4.43226681e-001],
[1.50797376e-001,6.01206389e-001,4.42723685e-001],
[1.51551190e-001,6.01368582e-001,4.42220808e-001],
[1.52305743e-001,6.01530407e-001,4.41718053e-001],
[1.53061028e-001,6.01691864e-001,4.41215424e-001],
[1.53817036e-001,6.01852954e-001,4.40712925e-001],
[1.54573757e-001,6.02013678e-001,4.40210560e-001],
[1.55331183e-001,6.02174036e-001,4.39708332e-001],
[1.56089305e-001,6.02334028e-001,4.39206246e-001],
[1.56848114e-001,6.02493654e-001,4.38704306e-001],
[1.57607601e-001,6.02652916e-001,4.38202515e-001],
[1.58367759e-001,6.02811814e-001,4.37700877e-001],
[1.59128578e-001,6.02970347e-001,4.37199396e-001],
[1.59890050e-001,6.03128517e-001,4.36698076e-001],
[1.60652166e-001,6.03286324e-001,4.36196921e-001],
[1.61414917e-001,6.03443769e-001,4.35695934e-001],
[1.62178296e-001,6.03600851e-001,4.35195120e-001],
[1.62942294e-001,6.03757572e-001,4.34694483e-001],
[1.63706902e-001,6.03913932e-001,4.34194025e-001],
[1.64472113e-001,6.04069930e-001,4.33693752e-001],
[1.65237917e-001,6.04225569e-001,4.33193667e-001],
[1.66004307e-001,6.04380847e-001,4.32693773e-001],
[1.66771274e-001,6.04535766e-001,4.32194075e-001],
[1.67538811e-001,6.04690326e-001,4.31694577e-001],
[1.68306909e-001,6.04844527e-001,4.31195283e-001],
[1.69075560e-001,6.04998370e-001,4.30696196e-001],
[1.69844755e-001,6.05151856e-001,4.30197320e-001],
[1.70614488e-001,6.05304984e-001,4.29698659e-001],
[1.71384750e-001,6.05457755e-001,4.29200217e-001],
[1.72155532e-001,6.05610170e-001,4.28701998e-001],
[1.72926828e-001,6.05762229e-001,4.28204007e-001],
[1.73698629e-001,6.05913932e-001,4.27706245e-001],
[1.74470928e-001,6.06065281e-001,4.27208718e-001],
[1.75243716e-001,6.06216274e-001,4.26711430e-001],
[1.76016986e-001,6.06366913e-001,4.26214384e-001],
[1.76790730e-001,6.06517199e-001,4.25717584e-001],
[1.77564941e-001,6.06667131e-001,4.25221035e-001],
[1.78339611e-001,6.06816709e-001,4.24724739e-001],
[1.79114732e-001,6.06965936e-001,4.24228701e-001],
[1.79890296e-001,6.07114810e-001,4.23732925e-001],
[1.80666297e-001,6.07263332e-001,4.23237415e-001],
[1.81442727e-001,6.07411504e-001,4.22742174e-001],
[1.82219578e-001,6.07559324e-001,4.22247206e-001],
[1.82996843e-001,6.07706794e-001,4.21752516e-001],
[1.83774515e-001,6.07853914e-001,4.21258106e-001],
[1.84552585e-001,6.08000684e-001,4.20763982e-001],
[1.85331048e-001,6.08147105e-001,4.20270147e-001],
[1.86109895e-001,6.08293177e-001,4.19776604e-001],
[1.86889120e-001,6.08438901e-001,4.19283359e-001],
[1.87668715e-001,6.08584277e-001,4.18790413e-001],
[1.88448673e-001,6.08729305e-001,4.18297772e-001],
[1.89228987e-001,6.08873986e-001,4.17805439e-001],
[1.90009650e-001,6.09018321e-001,4.17313419e-001],
[1.90790655e-001,6.09162309e-001,4.16821714e-001],
[1.91571994e-001,6.09305951e-001,4.16330330e-001],
[1.92353662e-001,6.09449248e-001,4.15839269e-001],
[1.93135650e-001,6.09592199e-001,4.15348535e-001],
[1.93917953e-001,6.09734806e-001,4.14858133e-001],
[1.94700563e-001,6.09877069e-001,4.14368066e-001],
[1.95483473e-001,6.10018988e-001,4.13878339e-001],
[1.96266677e-001,6.10160564e-001,4.13388954e-001],
[1.97050168e-001,6.10301796e-001,4.12899917e-001],
[1.97833939e-001,6.10442686e-001,4.12411230e-001],
[1.98617984e-001,6.10583234e-001,4.11922898e-001],
[1.99402295e-001,6.10723439e-001,4.11434924e-001],
[2.00186866e-001,6.10863304e-001,4.10947312e-001],
[2.00971691e-001,6.11002827e-001,4.10460066e-001],
[2.01756763e-001,6.11142010e-001,4.09973191e-001],
[2.02542076e-001,6.11280852e-001,4.09486689e-001],
[2.03327623e-001,6.11419355e-001,4.09000565e-001],
[2.04113397e-001,6.11557518e-001,4.08514822e-001],
[2.04899393e-001,6.11695342e-001,4.08029464e-001],
[2.05685604e-001,6.11832828e-001,4.07544496e-001],
[2.06472023e-001,6.11969975e-001,4.07059920e-001],
[2.07258644e-001,6.12106785e-001,4.06575741e-001],
[2.08045461e-001,6.12243257e-001,4.06091963e-001],
[2.08832468e-001,6.12379392e-001,4.05608589e-001],
[2.09619659e-001,6.12515190e-001,4.05125623e-001],
[2.10407027e-001,6.12650652e-001,4.04643069e-001],
[2.11194566e-001,6.12785778e-001,4.04160931e-001],
[2.11982270e-001,6.12920569e-001,4.03679213e-001],
[2.12770133e-001,6.13055025e-001,4.03197918e-001],
[2.13558149e-001,6.13189146e-001,4.02717049e-001],
[2.14346312e-001,6.13322932e-001,4.02236612e-001],
[2.15134615e-001,6.13456385e-001,4.01756610e-001],
[2.15923054e-001,6.13589504e-001,4.01277046e-001],
[2.16711622e-001,6.13722290e-001,4.00797924e-001],
[2.17500313e-001,6.13854743e-001,4.00319248e-001],
[2.18289122e-001,6.13986864e-001,3.99841023e-001],
[2.19078042e-001,6.14118653e-001,3.99363250e-001],
[2.19867067e-001,6.14250110e-001,3.98885935e-001],
[2.20656193e-001,6.14381236e-001,3.98409081e-001],
[2.21445413e-001,6.14512031e-001,3.97932692e-001],
[2.22234721e-001,6.14642496e-001,3.97456771e-001],
[2.23024113e-001,6.14772631e-001,3.96981323e-001],
[2.23813581e-001,6.14902435e-001,3.96506350e-001],
[2.24603121e-001,6.15031911e-001,3.96031858e-001],
[2.25392727e-001,6.15161057e-001,3.95557849e-001],
[2.26182394e-001,6.15289875e-001,3.95084326e-001],
[2.26972116e-001,6.15418365e-001,3.94611295e-001],
[2.27761887e-001,6.15546527e-001,3.94138759e-001],
[2.28551702e-001,6.15674362e-001,3.93666721e-001],
[2.29341555e-001,6.15801869e-001,3.93195184e-001],
[2.30131442e-001,6.15929050e-001,3.92724154e-001],
[2.30921357e-001,6.16055904e-001,3.92253633e-001],
[2.31711294e-001,6.16182433e-001,3.91783625e-001],
[2.32501248e-001,6.16308635e-001,3.91314133e-001],
[2.33291214e-001,6.16434513e-001,3.90845162e-001],
[2.34081187e-001,6.16560066e-001,3.90376715e-001],
[2.34871161e-001,6.16685294e-001,3.89908796e-001],
[2.35661132e-001,6.16810198e-001,3.89441408e-001],
[2.36451093e-001,6.16934779e-001,3.88974555e-001],
[2.37241040e-001,6.17059036e-001,3.88508241e-001],
[2.38030968e-001,6.17182970e-001,3.88042469e-001],
[2.38820871e-001,6.17306582e-001,3.87577243e-001],
[2.39610746e-001,6.17429871e-001,3.87112567e-001],
[2.40400585e-001,6.17552838e-001,3.86648444e-001],
[2.41190386e-001,6.17675484e-001,3.86184877e-001],
[2.41980141e-001,6.17797809e-001,3.85721871e-001],
[2.42769848e-001,6.17919812e-001,3.85259429e-001],
[2.43559500e-001,6.18041496e-001,3.84797554e-001],
[2.44349093e-001,6.18162859e-001,3.84336251e-001],
[2.45138622e-001,6.18283903e-001,3.83875522e-001],
[2.45928082e-001,6.18404627e-001,3.83415371e-001],
[2.46717468e-001,6.18525032e-001,3.82955802e-001],
[2.47506775e-001,6.18645119e-001,3.82496819e-001],
[2.48296000e-001,6.18764887e-001,3.82038425e-001],
[2.49085136e-001,6.18884337e-001,3.81580623e-001],
[2.49874179e-001,6.19003470e-001,3.81123417e-001],
[2.50663126e-001,6.19122286e-001,3.80666811e-001],
[2.51451969e-001,6.19240785e-001,3.80210807e-001],
[2.52240707e-001,6.19358967e-001,3.79755411e-001],
[2.53029332e-001,6.19476833e-001,3.79300624e-001],
[2.53817842e-001,6.19594383e-001,3.78846451e-001],
[2.54606231e-001,6.19711618e-001,3.78392895e-001],
[2.55394496e-001,6.19828538e-001,3.77939959e-001],
[2.56182630e-001,6.19945143e-001,3.77487648e-001],
[2.56970631e-001,6.20061434e-001,3.77035964e-001],
[2.57758493e-001,6.20177411e-001,3.76584911e-001],
[2.58546212e-001,6.20293074e-001,3.76134492e-001],
[2.59333783e-001,6.20408423e-001,3.75684711e-001],
[2.60121203e-001,6.20523460e-001,3.75235572e-001],
[2.60908466e-001,6.20638184e-001,3.74787077e-001],
[2.61695570e-001,6.20752596e-001,3.74339230e-001],
[2.62482508e-001,6.20866696e-001,3.73892035e-001],
[2.63269277e-001,6.20980485e-001,3.73445495e-001],
[2.64055873e-001,6.21093962e-001,3.72999613e-001],
[2.64842291e-001,6.21207128e-001,3.72554393e-001],
[2.65628527e-001,6.21319984e-001,3.72109837e-001],
[2.66414577e-001,6.21432530e-001,3.71665951e-001],
[2.67200436e-001,6.21544765e-001,3.71222736e-001],
[2.67986102e-001,6.21656692e-001,3.70780196e-001],
[2.68771568e-001,6.21768309e-001,3.70338335e-001],
[2.69556832e-001,6.21879617e-001,3.69897156e-001],
[2.70341890e-001,6.21990617e-001,3.69456662e-001],
[2.71126736e-001,6.22101308e-001,3.69016856e-001],
[2.71911367e-001,6.22211692e-001,3.68577742e-001],
[2.72695780e-001,6.22321769e-001,3.68139323e-001],
[2.73479969e-001,6.22431538e-001,3.67701603e-001],
[2.74263932e-001,6.22541001e-001,3.67264585e-001],
[2.75047664e-001,6.22650157e-001,3.66828271e-001],
[2.75831160e-001,6.22759007e-001,3.66392665e-001],
[2.76614419e-001,6.22867552e-001,3.65957771e-001],
[2.77397434e-001,6.22975791e-001,3.65523592e-001],
[2.78180203e-001,6.23083725e-001,3.65090131e-001],
[2.78962722e-001,6.23191354e-001,3.64657391e-001],
[2.79744986e-001,6.23298679e-001,3.64225375e-001],
[2.80526993e-001,6.23405699e-001,3.63794087e-001],
[2.81308737e-001,6.23512416e-001,3.63363530e-001],
[2.82090216e-001,6.23618830e-001,3.62933706e-001],
[2.82871426e-001,6.23724941e-001,3.62504620e-001],
[2.83652362e-001,6.23830749e-001,3.62076274e-001],
[2.84433022e-001,6.23936254e-001,3.61648672e-001],
[2.85213402e-001,6.24041458e-001,3.61221817e-001],
[2.85993497e-001,6.24146360e-001,3.60795711e-001],
[2.86773304e-001,6.24250960e-001,3.60370358e-001],
[2.87552820e-001,6.24355259e-001,3.59945761e-001],
[2.88332041e-001,6.24459258e-001,3.59521924e-001],
[2.89110964e-001,6.24562956e-001,3.59098848e-001],
[2.89889584e-001,6.24666354e-001,3.58676538e-001],
[2.90667899e-001,6.24769453e-001,3.58254997e-001],
[2.91445904e-001,6.24872252e-001,3.57834227e-001],
[2.92223596e-001,6.24974752e-001,3.57414232e-001],
[2.93000973e-001,6.25076953e-001,3.56995014e-001],
[2.93778029e-001,6.25178856e-001,3.56576577e-001],
[2.94554762e-001,6.25280461e-001,3.56158924e-001],
[2.95331169e-001,6.25381768e-001,3.55742057e-001],
[2.96107246e-001,6.25482778e-001,3.55325980e-001],
[2.96882989e-001,6.25583490e-001,3.54910696e-001],
[2.97658395e-001,6.25683906e-001,3.54496208e-001],
[2.98433461e-001,6.25784025e-001,3.54082519e-001],
[2.99208184e-001,6.25883849e-001,3.53669631e-001],
[2.99982560e-001,6.25983376e-001,3.53257548e-001],
[3.00756585e-001,6.26082608e-001,3.52846272e-001],
[3.01530257e-001,6.26181545e-001,3.52435807e-001],
[3.02303573e-001,6.26280187e-001,3.52026155e-001],
[3.03076528e-001,6.26378534e-001,3.51617320e-001],
[3.03849120e-001,6.26476588e-001,3.51209305e-001],
[3.04621346e-001,6.26574347e-001,3.50802111e-001],
[3.05393202e-001,6.26671813e-001,3.50395743e-001],
[3.06164685e-001,6.26768986e-001,3.49990202e-001],
[3.06935792e-001,6.26865866e-001,3.49585492e-001],
[3.07706521e-001,6.26962453e-001,3.49181616e-001],
[3.08476866e-001,6.27058748e-001,3.48778577e-001],
[3.09246827e-001,6.27154751e-001,3.48376377e-001],
[3.10016399e-001,6.27250462e-001,3.47975019e-001],
[3.10785579e-001,6.27345883e-001,3.47574506e-001],
[3.11554365e-001,6.27441012e-001,3.47174841e-001],
[3.12322754e-001,6.27535851e-001,3.46776027e-001],
[3.13090741e-001,6.27630399e-001,3.46378066e-001],
[3.13858325e-001,6.27724657e-001,3.45980961e-001],
[3.14625502e-001,6.27818626e-001,3.45584715e-001],
[3.15392269e-001,6.27912305e-001,3.45189330e-001],
[3.16158624e-001,6.28005695e-001,3.44794810e-001],
[3.16924563e-001,6.28098796e-001,3.44401157e-001],
[3.17690084e-001,6.28191609e-001,3.44008374e-001],
[3.18455183e-001,6.28284134e-001,3.43616464e-001],
[3.19219858e-001,6.28376371e-001,3.43225428e-001],
[3.19984105e-001,6.28468321e-001,3.42835271e-001],
[3.20747923e-001,6.28559984e-001,3.42445994e-001],
[3.21511308e-001,6.28651359e-001,3.42057600e-001],
[3.22274256e-001,6.28742448e-001,3.41670092e-001],
[3.23036767e-001,6.28833251e-001,3.41283473e-001],
[3.23798835e-001,6.28923768e-001,3.40897745e-001],
[3.24560460e-001,6.29013999e-001,3.40512910e-001],
[3.25321638e-001,6.29103946e-001,3.40128972e-001],
[3.26082366e-001,6.29193607e-001,3.39745933e-001],
[3.26842641e-001,6.29282983e-001,3.39363795e-001],
[3.27602461e-001,6.29372075e-001,3.38982562e-001],
[3.28361824e-001,6.29460884e-001,3.38602235e-001],
[3.29120725e-001,6.29549408e-001,3.38222817e-001],
[3.29879164e-001,6.29637649e-001,3.37844311e-001],
[3.30637136e-001,6.29725607e-001,3.37466719e-001],
[3.31394640e-001,6.29813282e-001,3.37090044e-001],
[3.32151673e-001,6.29900675e-001,3.36714288e-001],
[3.32908231e-001,6.29987785e-001,3.36339453e-001],
[3.33664314e-001,6.30074614e-001,3.35965543e-001],
[3.34419917e-001,6.30161161e-001,3.35592560e-001],
[3.35175038e-001,6.30247427e-001,3.35220506e-001],
[3.35929676e-001,6.30333412e-001,3.34849383e-001],
[3.36683826e-001,6.30419116e-001,3.34479194e-001],
[3.37437487e-001,6.30504540e-001,3.34109942e-001],
[3.38190657e-001,6.30589685e-001,3.33741629e-001],
[3.38943331e-001,6.30674549e-001,3.33374256e-001],
[3.39695510e-001,6.30759134e-001,3.33007828e-001],
[3.40447188e-001,6.30843440e-001,3.32642345e-001],
[3.41198365e-001,6.30927467e-001,3.32277810e-001],
[3.41949038e-001,6.31011216e-001,3.31914227e-001],
[3.42699204e-001,6.31094687e-001,3.31551596e-001],
[3.43448861e-001,6.31177879e-001,3.31189921e-001],
[3.44198006e-001,6.31260795e-001,3.30829203e-001],
[3.44946637e-001,6.31343433e-001,3.30469445e-001],
[3.45694752e-001,6.31425794e-001,3.30110650e-001],
[3.46442349e-001,6.31507878e-001,3.29752819e-001],
[3.47189424e-001,6.31589686e-001,3.29395955e-001],
[3.47935976e-001,6.31671219e-001,3.29040059e-001],
[3.48682002e-001,6.31752475e-001,3.28685136e-001],
[3.49427500e-001,6.31833456e-001,3.28331185e-001],
[3.50172468e-001,6.31914162e-001,3.27978211e-001],
[3.50916903e-001,6.31994593e-001,3.27626214e-001],
[3.51660803e-001,6.32074750e-001,3.27275198e-001],
[3.52404166e-001,6.32154633e-001,3.26925164e-001],
[3.53146989e-001,6.32234241e-001,3.26576114e-001],
[3.53889271e-001,6.32313577e-001,3.26228052e-001],
[3.54631009e-001,6.32392638e-001,3.25880978e-001],
[3.55372200e-001,6.32471427e-001,3.25534895e-001],
[3.56112843e-001,6.32549944e-001,3.25189805e-001],
[3.56852936e-001,6.32628188e-001,3.24845710e-001],
[3.57592476e-001,6.32706160e-001,3.24502613e-001],
[3.58331461e-001,6.32783860e-001,3.24160516e-001],
[3.59069889e-001,6.32861289e-001,3.23819419e-001],
[3.59807758e-001,6.32938446e-001,3.23479327e-001],
[3.60545065e-001,6.33015333e-001,3.23140240e-001],
[3.61281809e-001,6.33091949e-001,3.22802161e-001],
[3.62017988e-001,6.33168295e-001,3.22465091e-001],
[3.62753598e-001,6.33244371e-001,3.22129033e-001],
[3.63488640e-001,6.33320178e-001,3.21793990e-001],
[3.64223109e-001,6.33395715e-001,3.21459961e-001],
[3.64957004e-001,6.33470983e-001,3.21126951e-001],
[3.65690324e-001,6.33545982e-001,3.20794961e-001],
[3.66423065e-001,6.33620713e-001,3.20463992e-001],
[3.67155227e-001,6.33695176e-001,3.20134047e-001],
[3.67886806e-001,6.33769371e-001,3.19805127e-001],
[3.68617802e-001,6.33843299e-001,3.19477236e-001],
[3.69348212e-001,6.33916959e-001,3.19150373e-001],
[3.70078034e-001,6.33990353e-001,3.18824542e-001],
[3.70807265e-001,6.34063480e-001,3.18499745e-001],
[3.71535906e-001,6.34136340e-001,3.18175983e-001],
[3.72263952e-001,6.34208935e-001,3.17853257e-001],
[3.72991402e-001,6.34281264e-001,3.17531571e-001],
[3.73718255e-001,6.34353327e-001,3.17210926e-001],
[3.74444509e-001,6.34425126e-001,3.16891323e-001],
[3.75170160e-001,6.34496659e-001,3.16572765e-001],
[3.75895209e-001,6.34567928e-001,3.16255253e-001],
[3.76619652e-001,6.34638933e-001,3.15938789e-001],
[3.77343489e-001,6.34709674e-001,3.15623375e-001],
[3.78066716e-001,6.34780151e-001,3.15309013e-001],
[3.78789333e-001,6.34850366e-001,3.14995704e-001],
[3.79511337e-001,6.34920317e-001,3.14683450e-001],
[3.80232727e-001,6.34990005e-001,3.14372254e-001],
[3.80953500e-001,6.35059431e-001,3.14062116e-001],
[3.81673656e-001,6.35128595e-001,3.13753039e-001],
[3.82393191e-001,6.35197497e-001,3.13445024e-001],
[3.83112106e-001,6.35266138e-001,3.13138073e-001],
[3.83830396e-001,6.35334517e-001,3.12832188e-001],
[3.84548062e-001,6.35402635e-001,3.12527370e-001],
[3.85265101e-001,6.35470493e-001,3.12223621e-001],
[3.85981511e-001,6.35538091e-001,3.11920943e-001],
[3.86697292e-001,6.35605429e-001,3.11619337e-001],
[3.87412440e-001,6.35672506e-001,3.11318805e-001],
[3.88126954e-001,6.35739325e-001,3.11019348e-001],
[3.88840833e-001,6.35805884e-001,3.10720969e-001],
[3.89554075e-001,6.35872185e-001,3.10423669e-001],
[3.90266679e-001,6.35938227e-001,3.10127449e-001],
[3.90978641e-001,6.36004011e-001,3.09832311e-001],
[3.91689962e-001,6.36069537e-001,3.09538257e-001],
[3.92400639e-001,6.36134805e-001,3.09245288e-001],
[3.93110671e-001,6.36199817e-001,3.08953405e-001],
[3.93820056e-001,6.36264571e-001,3.08662611e-001],
[3.94528793e-001,6.36329068e-001,3.08372907e-001],
[3.95236879e-001,6.36393309e-001,3.08084294e-001],
[3.95944314e-001,6.36457294e-001,3.07796774e-001],
[3.96651095e-001,6.36521023e-001,3.07510349e-001],
[3.97357222e-001,6.36584497e-001,3.07225019e-001],
[3.98062692e-001,6.36647715e-001,3.06940787e-001],
[3.98767504e-001,6.36710679e-001,3.06657654e-001],
[3.99471656e-001,6.36773388e-001,3.06375620e-001],
[4.00175148e-001,6.36835842e-001,3.06094689e-001],
[4.00877977e-001,6.36898043e-001,3.05814861e-001],
[4.01580142e-001,6.36959990e-001,3.05536137e-001],
[4.02281641e-001,6.37021684e-001,3.05258520e-001],
[4.02982474e-001,6.37083124e-001,3.04982010e-001],
[4.03682638e-001,6.37144312e-001,3.04706609e-001],
[4.04382131e-001,6.37205247e-001,3.04432318e-001],
[4.05080954e-001,6.37265930e-001,3.04159139e-001],
[4.05779103e-001,6.37326361e-001,3.03887073e-001],
[4.06476578e-001,6.37386540e-001,3.03616121e-001],
[4.07173378e-001,6.37446468e-001,3.03346285e-001],
[4.07869500e-001,6.37506146e-001,3.03077566e-001],
[4.08564943e-001,6.37565572e-001,3.02809966e-001],
[4.09259707e-001,6.37624748e-001,3.02543485e-001],
[4.09953789e-001,6.37683674e-001,3.02278125e-001],
[4.10647188e-001,6.37742350e-001,3.02013888e-001],
[4.11339903e-001,6.37800777e-001,3.01750774e-001],
[4.12031933e-001,6.37858955e-001,3.01488785e-001],
[4.12723275e-001,6.37916883e-001,3.01227923e-001],
[4.13413930e-001,6.37974563e-001,3.00968188e-001],
[4.14103894e-001,6.38031995e-001,3.00709581e-001],
[4.14793168e-001,6.38089179e-001,3.00452105e-001],
[4.15481750e-001,6.38146115e-001,3.00195759e-001],
[4.16169638e-001,6.38202804e-001,2.99940547e-001],
[4.16856831e-001,6.38259246e-001,2.99686467e-001],
[4.17543328e-001,6.38315441e-001,2.99433523e-001],
[4.18229127e-001,6.38371389e-001,2.99181714e-001],
[4.18914228e-001,6.38427091e-001,2.98931043e-001],
[4.19598629e-001,6.38482548e-001,2.98681511e-001],
[4.20282329e-001,6.38537759e-001,2.98433117e-001],
[4.20965326e-001,6.38592724e-001,2.98185865e-001],
[4.21647619e-001,6.38647445e-001,2.97939754e-001],
[4.22329208e-001,6.38701921e-001,2.97694786e-001],
[4.23010090e-001,6.38756153e-001,2.97450963e-001],
[4.23690265e-001,6.38810141e-001,2.97208285e-001],
[4.24369731e-001,6.38863884e-001,2.96966753e-001],
[4.25048487e-001,6.38917385e-001,2.96726368e-001],
[4.25726533e-001,6.38970642e-001,2.96487132e-001],
[4.26403866e-001,6.39023657e-001,2.96249046e-001],
[4.27080486e-001,6.39076429e-001,2.96012111e-001],
[4.27756391e-001,6.39128959e-001,2.95776327e-001],
[4.28431581e-001,6.39181247e-001,2.95541696e-001],
[4.29106053e-001,6.39233293e-001,2.95308219e-001],
[4.29779808e-001,6.39285098e-001,2.95075897e-001],
[4.30452844e-001,6.39336662e-001,2.94844731e-001],
[4.31125160e-001,6.39387985e-001,2.94614721e-001],
[4.31796754e-001,6.39439068e-001,2.94385870e-001],
[4.32467626e-001,6.39489911e-001,2.94158178e-001],
[4.33137774e-001,6.39540514e-001,2.93931646e-001],
[4.33807198e-001,6.39590878e-001,2.93706275e-001],
[4.34475896e-001,6.39641002e-001,2.93482065e-001],
[4.35143867e-001,6.39690888e-001,2.93259019e-001],
[4.35811111e-001,6.39740535e-001,2.93037136e-001],
[4.36477625e-001,6.39789944e-001,2.92816419e-001],
[4.37143410e-001,6.39839115e-001,2.92596867e-001],
[4.37808463e-001,6.39888049e-001,2.92378482e-001],
[4.38472785e-001,6.39936745e-001,2.92161264e-001],
[4.39136374e-001,6.39985204e-001,2.91945215e-001],
[4.39799228e-001,6.40033426e-001,2.91730336e-001],
[4.40461348e-001,6.40081412e-001,2.91516627e-001],
[4.41122732e-001,6.40129162e-001,2.91304089e-001],
[4.41783378e-001,6.40176676e-001,2.91092723e-001],
[4.42443287e-001,6.40223955e-001,2.90882530e-001],
[4.43102456e-001,6.40270999e-001,2.90673511e-001],
[4.43760886e-001,6.40317807e-001,2.90465667e-001],
[4.44418575e-001,6.40364382e-001,2.90258999e-001],
[4.45075521e-001,6.40410722e-001,2.90053507e-001],
[4.45731725e-001,6.40456828e-001,2.89849193e-001],
[4.46387186e-001,6.40502701e-001,2.89646056e-001],
[4.47041901e-001,6.40548340e-001,2.89444098e-001],
[4.47695871e-001,6.40593746e-001,2.89243321e-001],
[4.48349095e-001,6.40638920e-001,2.89043724e-001],
[4.49001571e-001,6.40683862e-001,2.88845308e-001],
[4.49653299e-001,6.40728571e-001,2.88648074e-001],
[4.50304278e-001,6.40773049e-001,2.88452023e-001],
[4.50954506e-001,6.40817295e-001,2.88257156e-001],
[4.51603984e-001,6.40861310e-001,2.88063474e-001],
[4.52252710e-001,6.40905095e-001,2.87870977e-001],
[4.52900683e-001,6.40948649e-001,2.87679665e-001],
[4.53547902e-001,6.40991973e-001,2.87489541e-001],
[4.54194368e-001,6.41035067e-001,2.87300604e-001],
[4.54840078e-001,6.41077931e-001,2.87112855e-001],
[4.55485032e-001,6.41120567e-001,2.86926296e-001],
[4.56129229e-001,6.41162973e-001,2.86740925e-001],
[4.56772669e-001,6.41205151e-001,2.86556746e-001],
[4.57415350e-001,6.41247101e-001,2.86373757e-001],
[4.58057272e-001,6.41288823e-001,2.86191960e-001],
[4.58698433e-001,6.41330317e-001,2.86011356e-001],
[4.59338834e-001,6.41371584e-001,2.85831945e-001],
[4.59978473e-001,6.41412624e-001,2.85653727e-001],
[4.60617350e-001,6.41453438e-001,2.85476704e-001],
[4.61255464e-001,6.41494025e-001,2.85300877e-001],
[4.61892814e-001,6.41534386e-001,2.85126245e-001],
[4.62529399e-001,6.41574521e-001,2.84952809e-001],
[4.63165219e-001,6.41614431e-001,2.84780571e-001],
[4.63800272e-001,6.41654117e-001,2.84609530e-001],
[4.64434559e-001,6.41693577e-001,2.84439688e-001],
[4.65068078e-001,6.41732813e-001,2.84271045e-001],
[4.65700829e-001,6.41771825e-001,2.84103601e-001],
[4.66332811e-001,6.41810613e-001,2.83937357e-001],
[4.66964023e-001,6.41849177e-001,2.83772315e-001],
[4.67594465e-001,6.41887519e-001,2.83608473e-001],
[4.68224136e-001,6.41925638e-001,2.83445834e-001],
[4.68853035e-001,6.41963534e-001,2.83284397e-001],
[4.69481162e-001,6.42001209e-001,2.83124164e-001],
[4.70108515e-001,6.42038661e-001,2.82965134e-001],
[4.70735095e-001,6.42075892e-001,2.82807308e-001],
[4.71360900e-001,6.42112902e-001,2.82650688e-001],
[4.71985931e-001,6.42149691e-001,2.82495272e-001],
[4.72610185e-001,6.42186259e-001,2.82341063e-001],
[4.73233664e-001,6.42222608e-001,2.82188060e-001],
[4.73856365e-001,6.42258736e-001,2.82036264e-001],
[4.74478289e-001,6.42294645e-001,2.81885675e-001],
[4.75099435e-001,6.42330335e-001,2.81736295e-001],
[4.75719802e-001,6.42365806e-001,2.81588123e-001],
[4.76339390e-001,6.42401058e-001,2.81441160e-001],
[4.76958197e-001,6.42436093e-001,2.81295407e-001],
[4.77576225e-001,6.42470909e-001,2.81150864e-001],
[4.78193471e-001,6.42505508e-001,2.81007531e-001],
[4.78809935e-001,6.42539890e-001,2.80865410e-001],
[4.79425618e-001,6.42574055e-001,2.80724500e-001],
[4.80040517e-001,6.42608003e-001,2.80584802e-001],
[4.80654633e-001,6.42641735e-001,2.80446316e-001],
[4.81267966e-001,6.42675251e-001,2.80309043e-001],
[4.81880514e-001,6.42708552e-001,2.80172984e-001],
[4.82492277e-001,6.42741637e-001,2.80038138e-001],
[4.83103254e-001,6.42774508e-001,2.79904507e-001],
[4.83713446e-001,6.42807164e-001,2.79772091e-001],
[4.84322851e-001,6.42839606e-001,2.79640889e-001],
[4.84931469e-001,6.42871834e-001,2.79510903e-001],
[4.85539300e-001,6.42903849e-001,2.79382134e-001],
[4.86146343e-001,6.42935650e-001,2.79254580e-001],
[4.86752597e-001,6.42967238e-001,2.79128244e-001],
[4.87358063e-001,6.42998614e-001,2.79003124e-001],
[4.87962739e-001,6.43029778e-001,2.78879223e-001],
[4.88566625e-001,6.43060730e-001,2.78756539e-001],
[4.89169721e-001,6.43091471e-001,2.78635074e-001],
[4.89772026e-001,6.43122000e-001,2.78514827e-001],
[4.90373540e-001,6.43152319e-001,2.78395800e-001],
[4.90974262e-001,6.43182427e-001,2.78277993e-001],
[4.91574192e-001,6.43212325e-001,2.78161405e-001],
[4.92173330e-001,6.43242014e-001,2.78046038e-001],
[4.92771674e-001,6.43271492e-001,2.77931891e-001],
[4.93369226e-001,6.43300762e-001,2.77818965e-001],
[4.93965983e-001,6.43329823e-001,2.77707261e-001],
[4.94561946e-001,6.43358676e-001,2.77596778e-001],
[4.95157115e-001,6.43387321e-001,2.77487518e-001],
[4.95751489e-001,6.43415758e-001,2.77379480e-001],
[4.96345068e-001,6.43443987e-001,2.77272664e-001],
[4.96937851e-001,6.43472010e-001,2.77167072e-001],
[4.97529837e-001,6.43499826e-001,2.77062703e-001],
[4.98121028e-001,6.43527435e-001,2.76959558e-001],
[4.98711421e-001,6.43554839e-001,2.76857637e-001],
[4.99301018e-001,6.43582037e-001,2.76756940e-001],
[4.99889816e-001,6.43609030e-001,2.76657468e-001],
[5.00477817e-001,6.43635818e-001,2.76559221e-001],
[5.01065020e-001,6.43662401e-001,2.76462199e-001],
[5.01651425e-001,6.43688780e-001,2.76366402e-001],
[5.02237030e-001,6.43714956e-001,2.76271832e-001],
[5.02821836e-001,6.43740928e-001,2.76178487e-001],
[5.03405843e-001,6.43766696e-001,2.76086369e-001],
[5.03989050e-001,6.43792262e-001,2.75995477e-001],
[5.04571457e-001,6.43817626e-001,2.75905813e-001],
[5.05153064e-001,6.43842787e-001,2.75817375e-001],
[5.05733869e-001,6.43867747e-001,2.75730165e-001],
[5.06313874e-001,6.43892505e-001,2.75644183e-001],
[5.06893078e-001,6.43917063e-001,2.75559429e-001],
[5.07471480e-001,6.43941419e-001,2.75475902e-001],
[5.08049081e-001,6.43965576e-001,2.75393605e-001],
[5.08625879e-001,6.43989533e-001,2.75312536e-001],
[5.09201875e-001,6.44013290e-001,2.75232696e-001],
[5.09777069e-001,6.44036847e-001,2.75154085e-001],
[5.10351459e-001,6.44060206e-001,2.75076703e-001],
[5.10925047e-001,6.44083367e-001,2.75000551e-001],
[5.11497832e-001,6.44106329e-001,2.74925629e-001],
[5.12069813e-001,6.44129094e-001,2.74851937e-001],
[5.12640990e-001,6.44151662e-001,2.74779475e-001],
[5.13211363e-001,6.44174032e-001,2.74708244e-001],
[5.13780933e-001,6.44196206e-001,2.74638243e-001],
[5.14349697e-001,6.44218183e-001,2.74569473e-001],
[5.14917658e-001,6.44239965e-001,2.74501934e-001],
[5.15484813e-001,6.44261551e-001,2.74435627e-001],
[5.16051164e-001,6.44282942e-001,2.74370550e-001],
[5.16616710e-001,6.44304138e-001,2.74306706e-001],
[5.17181450e-001,6.44325139e-001,2.74244093e-001],
[5.17745385e-001,6.44345947e-001,2.74182712e-001],
[5.18308514e-001,6.44366561e-001,2.74122564e-001],
[5.18870837e-001,6.44386981e-001,2.74063647e-001],
[5.19432355e-001,6.44407209e-001,2.74005964e-001],
[5.19993066e-001,6.44427244e-001,2.73949512e-001],
[5.20552971e-001,6.44447087e-001,2.73894294e-001],
[5.21112070e-001,6.44466738e-001,2.73840309e-001],
[5.21670362e-001,6.44486198e-001,2.73787556e-001],
[5.22227848e-001,6.44505467e-001,2.73736037e-001],
[5.22784526e-001,6.44524545e-001,2.73685752e-001],
[5.23340398e-001,6.44543433e-001,2.73636700e-001],
[5.23895463e-001,6.44562131e-001,2.73588881e-001],
[5.24449721e-001,6.44580639e-001,2.73542296e-001],
[5.25003171e-001,6.44598958e-001,2.73496946e-001],
[5.25555814e-001,6.44617088e-001,2.73452829e-001],
[5.26107650e-001,6.44635030e-001,2.73409947e-001],
[5.26658678e-001,6.44652784e-001,2.73368299e-001],
[5.27208898e-001,6.44670351e-001,2.73327885e-001],
[5.27758311e-001,6.44687730e-001,2.73288706e-001],
[5.28306916e-001,6.44704922e-001,2.73250761e-001],
[5.28854713e-001,6.44721928e-001,2.73214051e-001],
[5.29401703e-001,6.44738748e-001,2.73178576e-001],
[5.29947884e-001,6.44755382e-001,2.73144336e-001],
[5.30493257e-001,6.44771831e-001,2.73111331e-001],
[5.31037823e-001,6.44788095e-001,2.73079561e-001],
[5.31581580e-001,6.44804174e-001,2.73049027e-001],
[5.32124529e-001,6.44820070e-001,2.73019728e-001],
[5.32666670e-001,6.44835781e-001,2.72991664e-001],
[5.33208002e-001,6.44851309e-001,2.72964835e-001],
[5.33748527e-001,6.44866655e-001,2.72939242e-001],
[5.34288243e-001,6.44881818e-001,2.72914885e-001],
[5.34827150e-001,6.44896798e-001,2.72891763e-001],
[5.35365250e-001,6.44911597e-001,2.72869877e-001],
[5.35902541e-001,6.44926215e-001,2.72849227e-001],
[5.36439024e-001,6.44940651e-001,2.72829813e-001],
[5.36974698e-001,6.44954907e-001,2.72811635e-001],
[5.37509565e-001,6.44968983e-001,2.72794692e-001],
[5.38043623e-001,6.44982879e-001,2.72778986e-001],
[5.38576872e-001,6.44996596e-001,2.72764516e-001],
[5.39109314e-001,6.45010134e-001,2.72751282e-001],
[5.39640947e-001,6.45023493e-001,2.72739284e-001],
[5.40171772e-001,6.45036674e-001,2.72728522e-001],
[5.40701789e-001,6.45049678e-001,2.72718996e-001],
[5.41230998e-001,6.45062504e-001,2.72710707e-001],
[5.41759398e-001,6.45075153e-001,2.72703654e-001],
[5.42286991e-001,6.45087626e-001,2.72697837e-001],
[5.42813776e-001,6.45099922e-001,2.72693257e-001],
[5.43339752e-001,6.45112043e-001,2.72689912e-001],
[5.43864921e-001,6.45123989e-001,2.72687805e-001],
[5.44389282e-001,6.45135759e-001,2.72686933e-001],
[5.44912835e-001,6.45147356e-001,2.72687298e-001],
[5.45435581e-001,6.45158778e-001,2.72688899e-001],
[5.45957519e-001,6.45170026e-001,2.72691737e-001],
[5.46478650e-001,6.45181102e-001,2.72695811e-001],
[5.46998973e-001,6.45192004e-001,2.72701122e-001],
[5.47518489e-001,6.45202734e-001,2.72707668e-001],
[5.48037198e-001,6.45213293e-001,2.72715451e-001],
[5.48555099e-001,6.45223679e-001,2.72724471e-001],
[5.49072194e-001,6.45233895e-001,2.72734727e-001],
[5.49588482e-001,6.45243940e-001,2.72746219e-001],
[5.50103962e-001,6.45253814e-001,2.72758947e-001],
[5.50618637e-001,6.45263519e-001,2.72772911e-001],
[5.51132504e-001,6.45273054e-001,2.72788112e-001],
[5.51645566e-001,6.45282420e-001,2.72804549e-001],
[5.52157821e-001,6.45291618e-001,2.72822222e-001],
[5.52669269e-001,6.45300647e-001,2.72841131e-001],
[5.53179912e-001,6.45309509e-001,2.72861276e-001],
[5.53689749e-001,6.45318204e-001,2.72882657e-001],
[5.54198780e-001,6.45326731e-001,2.72905274e-001],
[5.54707006e-001,6.45335092e-001,2.72929128e-001],
[5.55214426e-001,6.45343287e-001,2.72954216e-001],
[5.55721041e-001,6.45351317e-001,2.72980541e-001],
[5.56226851e-001,6.45359181e-001,2.73008101e-001],
[5.56731856e-001,6.45366881e-001,2.73036897e-001],
[5.57236056e-001,6.45374416e-001,2.73066929e-001],
[5.57739452e-001,6.45381787e-001,2.73098196e-001],
[5.58242043e-001,6.45388996e-001,2.73130699e-001],
[5.58743830e-001,6.45396041e-001,2.73164437e-001],
[5.59244813e-001,6.45402923e-001,2.73199410e-001],
[5.59744992e-001,6.45409644e-001,2.73235619e-001],
[5.60244367e-001,6.45416202e-001,2.73273062e-001],
[5.60742939e-001,6.45422600e-001,2.73311741e-001],
[5.61240708e-001,6.45428837e-001,2.73351654e-001],
[5.61737674e-001,6.45434913e-001,2.73392802e-001],
[5.62233837e-001,6.45440830e-001,2.73435186e-001],
[5.62729197e-001,6.45446587e-001,2.73478803e-001],
[5.63223755e-001,6.45452185e-001,2.73523655e-001],
[5.63717510e-001,6.45457625e-001,2.73569742e-001],
[5.64210464e-001,6.45462907e-001,2.73617063e-001],
[5.64702616e-001,6.45468030e-001,2.73665618e-001],
[5.65193966e-001,6.45472997e-001,2.73715407e-001],
[5.65684516e-001,6.45477807e-001,2.73766430e-001],
[5.66174264e-001,6.45482461e-001,2.73818687e-001],
[5.66663211e-001,6.45486959e-001,2.73872178e-001],
[5.67151358e-001,6.45491301e-001,2.73926902e-001],
[5.67638705e-001,6.45495489e-001,2.73982859e-001],
[5.68125251e-001,6.45499522e-001,2.74040050e-001],
[5.68610998e-001,6.45503401e-001,2.74098473e-001],
[5.69095945e-001,6.45507126e-001,2.74158130e-001],
[5.69580093e-001,6.45510699e-001,2.74219020e-001],
[5.70063443e-001,6.45514119e-001,2.74281142e-001],
[5.70545993e-001,6.45517386e-001,2.74344497e-001],
[5.71027745e-001,6.45520502e-001,2.74409084e-001],
[5.71508699e-001,6.45523467e-001,2.74474903e-001],
[5.71988855e-001,6.45526281e-001,2.74541954e-001],
[5.72468213e-001,6.45528944e-001,2.74610237e-001],
[5.72946774e-001,6.45531458e-001,2.74679752e-001],
[5.73424538e-001,6.45533823e-001,2.74750498e-001],
[5.73901505e-001,6.45536038e-001,2.74822476e-001],
[5.74377676e-001,6.45538105e-001,2.74895684e-001],
[5.74853051e-001,6.45540024e-001,2.74970124e-001],
[5.75327630e-001,6.45541796e-001,2.75045794e-001],
[5.75801414e-001,6.45543421e-001,2.75122695e-001],
[5.76274402e-001,6.45544899e-001,2.75200826e-001],
[5.76746596e-001,6.45546231e-001,2.75280187e-001],
[5.77217995e-001,6.45547417e-001,2.75360778e-001],
[5.77688600e-001,6.45548458e-001,2.75442599e-001],
[5.78158410e-001,6.45549355e-001,2.75525649e-001],
[5.78627428e-001,6.45550108e-001,2.75609929e-001],
[5.79095652e-001,6.45550717e-001,2.75695437e-001],
[5.79563083e-001,6.45551182e-001,2.75782174e-001],
[5.80029722e-001,6.45551505e-001,2.75870140e-001],
[5.80495568e-001,6.45551686e-001,2.75959334e-001],
[5.80960623e-001,6.45551725e-001,2.76049757e-001],
[5.81424886e-001,6.45551623e-001,2.76141407e-001],
[5.81888358e-001,6.45551380e-001,2.76234285e-001],
[5.82351039e-001,6.45550997e-001,2.76328390e-001],
[5.82812929e-001,6.45550474e-001,2.76423722e-001],
[5.83274030e-001,6.45549812e-001,2.76520281e-001],
[5.83734341e-001,6.45549011e-001,2.76618067e-001],
[5.84193862e-001,6.45548072e-001,2.76717078e-001],
[5.84652594e-001,6.45546995e-001,2.76817316e-001],
[5.85110538e-001,6.45545780e-001,2.76918780e-001],
[5.85567693e-001,6.45544429e-001,2.77021469e-001],
[5.86024061e-001,6.45542942e-001,2.77125383e-001],
[5.86479641e-001,6.45541318e-001,2.77230523e-001],
[5.86934434e-001,6.45539560e-001,2.77336887e-001],
[5.87388440e-001,6.45537666e-001,2.77444475e-001],
[5.87841660e-001,6.45535638e-001,2.77553287e-001],
[5.88294094e-001,6.45533477e-001,2.77663323e-001],
[5.88745743e-001,6.45531182e-001,2.77774582e-001],
[5.89196606e-001,6.45528755e-001,2.77887064e-001],
[5.89646684e-001,6.45526195e-001,2.78000769e-001],
[5.90095979e-001,6.45523503e-001,2.78115697e-001],
[5.90544489e-001,6.45520680e-001,2.78231846e-001],
[5.90992215e-001,6.45517726e-001,2.78349218e-001],
[5.91439159e-001,6.45514643e-001,2.78467811e-001],
[5.91885320e-001,6.45511429e-001,2.78587625e-001],
[5.92330698e-001,6.45508086e-001,2.78708659e-001],
[5.92775295e-001,6.45504615e-001,2.78830914e-001],
[5.93219110e-001,6.45501015e-001,2.78954389e-001],
[5.93662144e-001,6.45497288e-001,2.79079084e-001],
[5.94104398e-001,6.45493433e-001,2.79204998e-001],
[5.94545871e-001,6.45489452e-001,2.79332131e-001],
[5.94986565e-001,6.45485345e-001,2.79460483e-001],
[5.95426480e-001,6.45481112e-001,2.79590053e-001],
[5.95865615e-001,6.45476754e-001,2.79720840e-001],
[5.96303972e-001,6.45472272e-001,2.79852846e-001],
[5.96741551e-001,6.45467665e-001,2.79986068e-001],
[5.97178353e-001,6.45462936e-001,2.80120506e-001],
[5.97614378e-001,6.45458083e-001,2.80256161e-001],
[5.98049625e-001,6.45453108e-001,2.80393032e-001],
[5.98484097e-001,6.45448011e-001,2.80531118e-001],
[5.98917793e-001,6.45442792e-001,2.80670420e-001],
[5.99350714e-001,6.45437453e-001,2.80810935e-001],
[5.99782860e-001,6.45431993e-001,2.80952665e-001],
[6.00214231e-001,6.45426414e-001,2.81095609e-001],
[6.00644829e-001,6.45420716e-001,2.81239766e-001],
[6.01074653e-001,6.45414899e-001,2.81385135e-001],
[6.01503705e-001,6.45408963e-001,2.81531717e-001],
[6.01931984e-001,6.45402910e-001,2.81679511e-001],
[6.02359491e-001,6.45396740e-001,2.81828517e-001],
[6.02786226e-001,6.45390454e-001,2.81978733e-001],
[6.03212190e-001,6.45384052e-001,2.82130160e-001],
[6.03637384e-001,6.45377534e-001,2.82282797e-001],
[6.04061808e-001,6.45370901e-001,2.82436644e-001],
[6.04485462e-001,6.45364154e-001,2.82591699e-001],
[6.04908347e-001,6.45357293e-001,2.82747964e-001],
[6.05330464e-001,6.45350319e-001,2.82905436e-001],
[6.05751812e-001,6.45343233e-001,2.83064116e-001],
[6.06172393e-001,6.45336034e-001,2.83224003e-001],
[6.06592206e-001,6.45328723e-001,2.83385096e-001],
[6.07011253e-001,6.45321302e-001,2.83547396e-001],
[6.07429534e-001,6.45313770e-001,2.83710901e-001],
[6.07847049e-001,6.45306128e-001,2.83875611e-001],
[6.08263800e-001,6.45298377e-001,2.84041525e-001],
[6.08679785e-001,6.45290518e-001,2.84208644e-001],
[6.09095007e-001,6.45282549e-001,2.84376965e-001],
[6.09509465e-001,6.45274474e-001,2.84546490e-001],
[6.09923159e-001,6.45266291e-001,2.84717217e-001],
[6.10336092e-001,6.45258002e-001,2.84889145e-001],
[6.10748262e-001,6.45249606e-001,2.85062275e-001],
[6.11159671e-001,6.45241106e-001,2.85236605e-001],
[6.11570319e-001,6.45232500e-001,2.85412135e-001],
[6.11980206e-001,6.45223790e-001,2.85588864e-001],
[6.12389333e-001,6.45214977e-001,2.85766792e-001],
[6.12797701e-001,6.45206060e-001,2.85945918e-001],
[6.13205310e-001,6.45197041e-001,2.86126241e-001],
[6.13612161e-001,6.45187920e-001,2.86307762e-001],
[6.14018254e-001,6.45178698e-001,2.86490479e-001],
[6.14423589e-001,6.45169374e-001,2.86674391e-001],
[6.14828168e-001,6.45159951e-001,2.86859499e-001],
[6.15231991e-001,6.45150428e-001,2.87045800e-001],
[6.15635058e-001,6.45140806e-001,2.87233296e-001],
[6.16037370e-001,6.45131085e-001,2.87421984e-001],
[6.16438927e-001,6.45121266e-001,2.87611865e-001],
[6.16839731e-001,6.45111350e-001,2.87802938e-001],
[6.17239781e-001,6.45101338e-001,2.87995202e-001],
[6.17639077e-001,6.45091229e-001,2.88188656e-001],
[6.18037622e-001,6.45081025e-001,2.88383300e-001],
[6.18435415e-001,6.45070725e-001,2.88579133e-001],
[6.18832456e-001,6.45060332e-001,2.88776154e-001],
[6.19228747e-001,6.45049844e-001,2.88974362e-001],
[6.19624287e-001,6.45039264e-001,2.89173758e-001],
[6.20019078e-001,6.45028590e-001,2.89374339e-001],
[6.20413120e-001,6.45017825e-001,2.89576106e-001],
[6.20806414e-001,6.45006968e-001,2.89779058e-001],
[6.21198960e-001,6.44996021e-001,2.89983193e-001],
[6.21590758e-001,6.44984983e-001,2.90188512e-001],
[6.21981809e-001,6.44973856e-001,2.90395013e-001],
[6.22372115e-001,6.44962640e-001,2.90602696e-001],
[6.22761674e-001,6.44951335e-001,2.90811560e-001],
[6.23150489e-001,6.44939943e-001,2.91021603e-001],
[6.23538559e-001,6.44928463e-001,2.91232827e-001],
[6.23925886e-001,6.44916897e-001,2.91445228e-001],
[6.24312469e-001,6.44905245e-001,2.91658807e-001],
[6.24698309e-001,6.44893507e-001,2.91873563e-001],
[6.25083407e-001,6.44881685e-001,2.92089496e-001],
[6.25467763e-001,6.44869779e-001,2.92306603e-001],
[6.25851379e-001,6.44857789e-001,2.92524885e-001],
[6.26234254e-001,6.44845716e-001,2.92744340e-001],
[6.26616389e-001,6.44833561e-001,2.92964968e-001],
[6.26997785e-001,6.44821324e-001,2.93186768e-001],
[6.27378443e-001,6.44809006e-001,2.93409739e-001],
[6.27758362e-001,6.44796608e-001,2.93633880e-001],
[6.28137544e-001,6.44784130e-001,2.93859191e-001],
[6.28515989e-001,6.44771572e-001,2.94085670e-001],
[6.28893698e-001,6.44758937e-001,2.94313316e-001],
[6.29270671e-001,6.44746223e-001,2.94542129e-001],
[6.29646909e-001,6.44733432e-001,2.94772107e-001],
[6.30022413e-001,6.44720564e-001,2.95003250e-001],
[6.30397182e-001,6.44707620e-001,2.95235557e-001],
[6.30771219e-001,6.44694601e-001,2.95469027e-001],
[6.31144522e-001,6.44681507e-001,2.95703659e-001],
[6.31517094e-001,6.44668338e-001,2.95939452e-001],
[6.31888934e-001,6.44655097e-001,2.96176405e-001],
[6.32260044e-001,6.44641782e-001,2.96414517e-001],
[6.32630423e-001,6.44628395e-001,2.96653787e-001],
[6.33000072e-001,6.44614937e-001,2.96894214e-001],
[6.33368993e-001,6.44601407e-001,2.97135797e-001],
[6.33737185e-001,6.44587807e-001,2.97378535e-001],
[6.34104649e-001,6.44574138e-001,2.97622428e-001],
[6.34471386e-001,6.44560399e-001,2.97867473e-001],
[6.34837396e-001,6.44546592e-001,2.98113671e-001],
[6.35202681e-001,6.44532717e-001,2.98361020e-001],
[6.35567240e-001,6.44518775e-001,2.98609518e-001],
[6.35931075e-001,6.44504767e-001,2.98859166e-001],
[6.36294185e-001,6.44490692e-001,2.99109961e-001],
[6.36656572e-001,6.44476553e-001,2.99361904e-001],
[6.37018236e-001,6.44462349e-001,2.99614992e-001],
[6.37379178e-001,6.44448081e-001,2.99869224e-001],
[6.37739398e-001,6.44433750e-001,3.00124600e-001],
[6.38098897e-001,6.44419357e-001,3.00381119e-001],
[6.38457676e-001,6.44404901e-001,3.00638779e-001],
[6.38815735e-001,6.44390384e-001,3.00897579e-001],
[6.39173075e-001,6.44375807e-001,3.01157518e-001],
[6.39529696e-001,6.44361170e-001,3.01418595e-001],
[6.39885600e-001,6.44346473e-001,3.01680809e-001],
[6.40240786e-001,6.44331718e-001,3.01944159e-001],
[6.40595256e-001,6.44316905e-001,3.02208643e-001],
[6.40949010e-001,6.44302034e-001,3.02474260e-001],
[6.41302049e-001,6.44287107e-001,3.02741010e-001],
[6.41654372e-001,6.44272124e-001,3.03008890e-001],
[6.42005982e-001,6.44257086e-001,3.03277900e-001],
[6.42356879e-001,6.44241993e-001,3.03548039e-001],
[6.42707062e-001,6.44226847e-001,3.03819305e-001],
[6.43056534e-001,6.44211647e-001,3.04091696e-001],
[6.43405294e-001,6.44196394e-001,3.04365213e-001],
[6.43753343e-001,6.44181089e-001,3.04639853e-001],
[6.44100682e-001,6.44165734e-001,3.04915616e-001],
[6.44447311e-001,6.44150327e-001,3.05192500e-001],
[6.44793231e-001,6.44134871e-001,3.05470503e-001],
[6.45138444e-001,6.44119366e-001,3.05749625e-001],
[6.45482948e-001,6.44103812e-001,3.06029864e-001],
[6.45826745e-001,6.44088210e-001,3.06311219e-001],
[6.46169836e-001,6.44072561e-001,3.06593688e-001],
[6.46512222e-001,6.44056865e-001,3.06877271e-001],
[6.46853902e-001,6.44041124e-001,3.07161965e-001],
[6.47194878e-001,6.44025338e-001,3.07447770e-001],
[6.47535150e-001,6.44009507e-001,3.07734684e-001],
[6.47874719e-001,6.43993633e-001,3.08022706e-001],
[6.48213585e-001,6.43977715e-001,3.08311835e-001],
[6.48551750e-001,6.43961756e-001,3.08602068e-001],
[6.48889213e-001,6.43945754e-001,3.08893406e-001],
[6.49225976e-001,6.43929712e-001,3.09185845e-001],
[6.49562039e-001,6.43913629e-001,3.09479385e-001],
[6.49897403e-001,6.43897507e-001,3.09774025e-001],
[6.50232069e-001,6.43881346e-001,3.10069763e-001],
[6.50566036e-001,6.43865146e-001,3.10366597e-001],
[6.50899306e-001,6.43848910e-001,3.10664526e-001],
[6.51231879e-001,6.43832636e-001,3.10963549e-001],
[6.51563757e-001,6.43816327e-001,3.11263664e-001],
[6.51894939e-001,6.43799982e-001,3.11564870e-001],
[6.52225427e-001,6.43783602e-001,3.11867165e-001],
[6.52555220e-001,6.43767189e-001,3.12170548e-001],
[6.52884321e-001,6.43750742e-001,3.12475017e-001],
[6.53212728e-001,6.43734263e-001,3.12780570e-001],
[6.53540444e-001,6.43717752e-001,3.13087207e-001],
[6.53867468e-001,6.43701210e-001,3.13394925e-001],
[6.54193802e-001,6.43684637e-001,3.13703723e-001],
[6.54519445e-001,6.43668035e-001,3.14013599e-001],
[6.54844400e-001,6.43651403e-001,3.14324552e-001],
[6.55168665e-001,6.43634744e-001,3.14636581e-001],
[6.55492242e-001,6.43618057e-001,3.14949683e-001],
[6.55815132e-001,6.43601343e-001,3.15263858e-001],
[6.56137336e-001,6.43584603e-001,3.15579102e-001],
[6.56458853e-001,6.43567838e-001,3.15895416e-001],
[6.56779685e-001,6.43551048e-001,3.16212797e-001],
[6.57099832e-001,6.43534234e-001,3.16531243e-001],
[6.57419295e-001,6.43517397e-001,3.16850753e-001],
[6.57738075e-001,6.43500537e-001,3.17171325e-001],
[6.58056172e-001,6.43483656e-001,3.17492958e-001],
[6.58373587e-001,6.43466753e-001,3.17815650e-001],
[6.58690320e-001,6.43449831e-001,3.18139398e-001],
[6.59006373e-001,6.43432888e-001,3.18464202e-001],
[6.59321745e-001,6.43415927e-001,3.18790060e-001],
[6.59636438e-001,6.43398948e-001,3.19116970e-001],
[6.59950453e-001,6.43381951e-001,3.19444930e-001],
[6.60263789e-001,6.43364938e-001,3.19773938e-001],
[6.60576448e-001,6.43347909e-001,3.20103993e-001],
[6.60888430e-001,6.43330864e-001,3.20435093e-001],
[6.61199737e-001,6.43313805e-001,3.20767236e-001],
[6.61510367e-001,6.43296733e-001,3.21100421e-001],
[6.61820323e-001,6.43279647e-001,3.21434644e-001],
[6.62129605e-001,6.43262549e-001,3.21769906e-001],
[6.62438214e-001,6.43245440e-001,3.22106203e-001],
[6.62746149e-001,6.43228320e-001,3.22443535e-001],
[6.63053413e-001,6.43211190e-001,3.22781898e-001],
[6.63360005e-001,6.43194050e-001,3.23121292e-001],
[6.63665927e-001,6.43176903e-001,3.23461714e-001],
[6.63971178e-001,6.43159747e-001,3.23803163e-001],
[6.64275760e-001,6.43142584e-001,3.24145636e-001],
[6.64579674e-001,6.43125416e-001,3.24489132e-001],
[6.64882919e-001,6.43108241e-001,3.24833649e-001],
[6.65185497e-001,6.43091062e-001,3.25179184e-001],
[6.65487408e-001,6.43073879e-001,3.25525737e-001],
[6.65788653e-001,6.43056692e-001,3.25873305e-001],
[6.66089233e-001,6.43039503e-001,3.26221885e-001],
[6.66389148e-001,6.43022312e-001,3.26571477e-001],
[6.66688399e-001,6.43005121e-001,3.26922077e-001],
[6.66986987e-001,6.42987929e-001,3.27273685e-001],
[6.67284912e-001,6.42970737e-001,3.27626298e-001],
[6.67582175e-001,6.42953547e-001,3.27979914e-001],
[6.67878777e-001,6.42936359e-001,3.28334531e-001],
[6.68174718e-001,6.42919173e-001,3.28690146e-001],
[6.68469999e-001,6.42901991e-001,3.29046759e-001],
[6.68764620e-001,6.42884814e-001,3.29404366e-001],
[6.69058583e-001,6.42867641e-001,3.29762967e-001],
[6.69351888e-001,6.42850475e-001,3.30122558e-001],
[6.69644536e-001,6.42833315e-001,3.30483137e-001],
[6.69936527e-001,6.42816162e-001,3.30844703e-001],
[6.70227862e-001,6.42799017e-001,3.31207254e-001],
[6.70518541e-001,6.42781882e-001,3.31570786e-001],
[6.70808566e-001,6.42764756e-001,3.31935299e-001],
[6.71097938e-001,6.42747640e-001,3.32300790e-001],
[6.71386655e-001,6.42730536e-001,3.32667256e-001],
[6.71674720e-001,6.42713444e-001,3.33034697e-001],
[6.71962134e-001,6.42696364e-001,3.33403108e-001],
[6.72248895e-001,6.42679298e-001,3.33772489e-001],
[6.72535007e-001,6.42662247e-001,3.34142837e-001],
[6.72820468e-001,6.42645210e-001,3.34514149e-001],
[6.73105280e-001,6.42628189e-001,3.34886425e-001],
[6.73389443e-001,6.42611185e-001,3.35259660e-001],
[6.73672959e-001,6.42594199e-001,3.35633854e-001],
[6.73955827e-001,6.42577230e-001,3.36009003e-001],
[6.74238048e-001,6.42560281e-001,3.36385106e-001],
[6.74519624e-001,6.42543351e-001,3.36762161e-001],
[6.74800554e-001,6.42526442e-001,3.37140164e-001],
[6.75080840e-001,6.42509554e-001,3.37519114e-001],
[6.75360482e-001,6.42492688e-001,3.37899008e-001],
[6.75639480e-001,6.42475845e-001,3.38279844e-001],
[6.75917836e-001,6.42459026e-001,3.38661620e-001],
[6.76195550e-001,6.42442232e-001,3.39044334e-001],
[6.76472623e-001,6.42425462e-001,3.39427982e-001],
[6.76749055e-001,6.42408719e-001,3.39812563e-001],
[6.77024848e-001,6.42392002e-001,3.40198074e-001],
[6.77300001e-001,6.42375313e-001,3.40584513e-001],
[6.77574515e-001,6.42358653e-001,3.40971878e-001],
[6.77848392e-001,6.42342022e-001,3.41360165e-001],
[6.78121631e-001,6.42325420e-001,3.41749373e-001],
[6.78394233e-001,6.42308850e-001,3.42139499e-001],
[6.78666200e-001,6.42292311e-001,3.42530541e-001],
[6.78937532e-001,6.42275804e-001,3.42922496e-001],
[6.79208228e-001,6.42259331e-001,3.43315361e-001],
[6.79478291e-001,6.42242892e-001,3.43709135e-001],
[6.79747721e-001,6.42226487e-001,3.44103815e-001],
[6.80016518e-001,6.42210118e-001,3.44499398e-001],
[6.80284683e-001,6.42193785e-001,3.44895882e-001],
[6.80552217e-001,6.42177490e-001,3.45293264e-001],
[6.80819121e-001,6.42161232e-001,3.45691542e-001],
[6.81085394e-001,6.42145014e-001,3.46090713e-001],
[6.81351038e-001,6.42128834e-001,3.46490774e-001],
[6.81616053e-001,6.42112696e-001,3.46891724e-001],
[6.81880441e-001,6.42096598e-001,3.47293559e-001],
[6.82144201e-001,6.42080542e-001,3.47696277e-001],
[6.82407335e-001,6.42064529e-001,3.48099875e-001],
[6.82669842e-001,6.42048560e-001,3.48504350e-001],
[6.82931724e-001,6.42032635e-001,3.48909701e-001],
[6.83192982e-001,6.42016755e-001,3.49315924e-001],
[6.83453616e-001,6.42000922e-001,3.49723017e-001],
[6.83713626e-001,6.41985135e-001,3.50130977e-001],
[6.83973013e-001,6.41969395e-001,3.50539801e-001],
[6.84231779e-001,6.41953705e-001,3.50949487e-001],
[6.84489923e-001,6.41938063e-001,3.51360032e-001],
[6.84747447e-001,6.41922471e-001,3.51771433e-001],
[6.85004350e-001,6.41906931e-001,3.52183688e-001],
[6.85260634e-001,6.41891442e-001,3.52596794e-001],
[6.85516300e-001,6.41876005e-001,3.53010748e-001],
[6.85771347e-001,6.41860622e-001,3.53425548e-001],
[6.86025777e-001,6.41845293e-001,3.53841190e-001],
[6.86279590e-001,6.41830018e-001,3.54257672e-001],
[6.86532787e-001,6.41814800e-001,3.54674992e-001],
[6.86785369e-001,6.41799638e-001,3.55093146e-001],
[6.87037335e-001,6.41784534e-001,3.55512131e-001],
[6.87288688e-001,6.41769487e-001,3.55931945e-001],
[6.87539427e-001,6.41754500e-001,3.56352585e-001],
[6.87789553e-001,6.41739572e-001,3.56774049e-001],
[6.88039067e-001,6.41724705e-001,3.57196332e-001],
[6.88287970e-001,6.41709900e-001,3.57619434e-001],
[6.88536261e-001,6.41695157e-001,3.58043349e-001],
[6.88783943e-001,6.41680477e-001,3.58468077e-001],
[6.89031015e-001,6.41665861e-001,3.58893613e-001],
[6.89277477e-001,6.41651309e-001,3.59319956e-001],
[6.89523332e-001,6.41636823e-001,3.59747101e-001],
[6.89768579e-001,6.41622404e-001,3.60175047e-001],
[6.90013219e-001,6.41608052e-001,3.60603790e-001],
[6.90257252e-001,6.41593767e-001,3.61033328e-001],
[6.90500680e-001,6.41579552e-001,3.61463657e-001],
[6.90743503e-001,6.41565406e-001,3.61894774e-001],
[6.90985721e-001,6.41551331e-001,3.62326677e-001],
[6.91227336e-001,6.41537327e-001,3.62759363e-001],
[6.91468347e-001,6.41523395e-001,3.63192828e-001],
[6.91708756e-001,6.41509536e-001,3.63627070e-001],
[6.91948563e-001,6.41495751e-001,3.64062085e-001],
[6.92187769e-001,6.41482041e-001,3.64497871e-001],
[6.92426374e-001,6.41468406e-001,3.64934425e-001],
[6.92664380e-001,6.41454847e-001,3.65371744e-001],
[6.92901786e-001,6.41441366e-001,3.65809823e-001],
[6.93138593e-001,6.41427962e-001,3.66248662e-001],
[6.93374802e-001,6.41414637e-001,3.66688256e-001],
[6.93610414e-001,6.41401392e-001,3.67128602e-001],
[6.93845430e-001,6.41388227e-001,3.67569698e-001],
[6.94079849e-001,6.41375143e-001,3.68011540e-001],
[6.94313673e-001,6.41362142e-001,3.68454125e-001],
[6.94546902e-001,6.41349223e-001,3.68897451e-001],
[6.94779536e-001,6.41336388e-001,3.69341513e-001],
[6.95011577e-001,6.41323638e-001,3.69786310e-001],
[6.95243026e-001,6.41310973e-001,3.70231837e-001],
[6.95473881e-001,6.41298394e-001,3.70678091e-001],
[6.95704146e-001,6.41285902e-001,3.71125071e-001],
[6.95933819e-001,6.41273498e-001,3.71572771e-001],
[6.96162902e-001,6.41261183e-001,3.72021190e-001],
[6.96391395e-001,6.41248957e-001,3.72470324e-001],
[6.96619299e-001,6.41236822e-001,3.72920169e-001],
[6.96846614e-001,6.41224778e-001,3.73370723e-001],
[6.97073341e-001,6.41212826e-001,3.73821983e-001],
[6.97299482e-001,6.41200967e-001,3.74273945e-001],
[6.97525035e-001,6.41189202e-001,3.74726606e-001],
[6.97750003e-001,6.41177531e-001,3.75179963e-001],
[6.97974385e-001,6.41165955e-001,3.75634013e-001],
[6.98198182e-001,6.41154476e-001,3.76088751e-001],
[6.98421395e-001,6.41143094e-001,3.76544177e-001],
[6.98644025e-001,6.41131809e-001,3.77000284e-001],
[6.98866072e-001,6.41120623e-001,3.77457072e-001],
[6.99087536e-001,6.41109537e-001,3.77914536e-001],
[6.99308419e-001,6.41098551e-001,3.78372673e-001],
[6.99528721e-001,6.41087667e-001,3.78831479e-001],
[6.99748442e-001,6.41076884e-001,3.79290952e-001],
[6.99967584e-001,6.41066205e-001,3.79751089e-001],
[7.00186146e-001,6.41055629e-001,3.80211885e-001],
[7.00404130e-001,6.41045157e-001,3.80673338e-001],
[7.00621535e-001,6.41034791e-001,3.81135444e-001],
[7.00838364e-001,6.41024531e-001,3.81598200e-001],
[7.01054616e-001,6.41014378e-001,3.82061602e-001],
[7.01270291e-001,6.41004333e-001,3.82525648e-001],
[7.01485391e-001,6.40994397e-001,3.82990334e-001],
[7.01699916e-001,6.40984571e-001,3.83455656e-001],
[7.01913867e-001,6.40974854e-001,3.83921611e-001],
[7.02127244e-001,6.40965249e-001,3.84388196e-001],
[7.02340048e-001,6.40955756e-001,3.84855407e-001],
[7.02552280e-001,6.40946376e-001,3.85323241e-001],
[7.02763939e-001,6.40937109e-001,3.85791695e-001],
[7.02975028e-001,6.40927958e-001,3.86260765e-001],
[7.03185546e-001,6.40918921e-001,3.86730447e-001],
[7.03395493e-001,6.40910001e-001,3.87200739e-001],
[7.03604871e-001,6.40901197e-001,3.87671637e-001],
[7.03813681e-001,6.40892512e-001,3.88143137e-001],
[7.04021922e-001,6.40883945e-001,3.88615237e-001],
[7.04229595e-001,6.40875498e-001,3.89087932e-001],
[7.04436702e-001,6.40867172e-001,3.89561219e-001],
[7.04643242e-001,6.40858966e-001,3.90035094e-001],
[7.04849216e-001,6.40850883e-001,3.90509555e-001],
[7.05054625e-001,6.40842922e-001,3.90984597e-001],
[7.05259469e-001,6.40835085e-001,3.91460218e-001],
[7.05463749e-001,6.40827373e-001,3.91936413e-001],
[7.05667465e-001,6.40819786e-001,3.92413180e-001],
[7.05870619e-001,6.40812325e-001,3.92890514e-001],
[7.06073210e-001,6.40804992e-001,3.93368412e-001],
[7.06275240e-001,6.40797786e-001,3.93846871e-001],
[7.06476709e-001,6.40790709e-001,3.94325888e-001],
[7.06677617e-001,6.40783761e-001,3.94805458e-001],
[7.06877965e-001,6.40776944e-001,3.95285578e-001],
[7.07077753e-001,6.40770258e-001,3.95766244e-001],
[7.07276983e-001,6.40763704e-001,3.96247454e-001],
[7.07475655e-001,6.40757283e-001,3.96729203e-001],
[7.07673769e-001,6.40750996e-001,3.97211488e-001],
[7.07871326e-001,6.40744843e-001,3.97694305e-001],
[7.08068327e-001,6.40738825e-001,3.98177652e-001],
[7.08264772e-001,6.40732944e-001,3.98661523e-001],
[7.08460661e-001,6.40727200e-001,3.99145916e-001],
[7.08655996e-001,6.40721593e-001,3.99630827e-001],
[7.08850777e-001,6.40716125e-001,4.00116252e-001],
[7.09045004e-001,6.40710797e-001,4.00602189e-001],
[7.09238678e-001,6.40705609e-001,4.01088632e-001],
[7.09431800e-001,6.40700562e-001,4.01575579e-001],
[7.09624370e-001,6.40695657e-001,4.02063027e-001],
[7.09816389e-001,6.40690895e-001,4.02550970e-001],
[7.10007857e-001,6.40686276e-001,4.03039407e-001],
[7.10198774e-001,6.40681802e-001,4.03528333e-001],
[7.10389143e-001,6.40677473e-001,4.04017744e-001],
[7.10578962e-001,6.40673290e-001,4.04507637e-001],
[7.10768233e-001,6.40669255e-001,4.04998008e-001],
[7.10956956e-001,6.40665366e-001,4.05488855e-001],
[7.11145132e-001,6.40661627e-001,4.05980172e-001],
[7.11332761e-001,6.40658037e-001,4.06471956e-001],
[7.11519844e-001,6.40654597e-001,4.06964204e-001],
[7.11706382e-001,6.40651308e-001,4.07456912e-001],
[7.11892374e-001,6.40648171e-001,4.07950076e-001],
[7.12077822e-001,6.40645186e-001,4.08443694e-001],
[7.12262726e-001,6.40642355e-001,4.08937760e-001],
[7.12447087e-001,6.40639678e-001,4.09432271e-001],
[7.12630905e-001,6.40637157e-001,4.09927224e-001],
[7.12814181e-001,6.40634791e-001,4.10422615e-001],
[7.12996915e-001,6.40632582e-001,4.10918441e-001],
[7.13179108e-001,6.40630530e-001,4.11414696e-001],
[7.13360760e-001,6.40628637e-001,4.11911379e-001],
[7.13541872e-001,6.40626903e-001,4.12408485e-001],
[7.13722445e-001,6.40625330e-001,4.12906011e-001],
[7.13902479e-001,6.40623916e-001,4.13403952e-001],
[7.14081975e-001,6.40622665e-001,4.13902305e-001],
[7.14260932e-001,6.40621576e-001,4.14401067e-001]])

B0_COLORMAP = ListedColormap([[7.92635733e-01,8.70389957e-01,1.00000000e+00],
[7.91946723e-01,8.70046665e-01,9.99312062e-01],
[7.91258420e-01,8.69702818e-01,9.98623184e-01],
[7.90570823e-01,8.69358415e-01,9.97933369e-01],
[7.89883931e-01,8.69013455e-01,9.97242620e-01],
[7.89197744e-01,8.68667938e-01,9.96550939e-01],
[7.88512261e-01,8.68321863e-01,9.95858329e-01],
[7.87827481e-01,8.67975229e-01,9.95164794e-01],
[7.87143403e-01,8.67628036e-01,9.94470335e-01],
[7.86460027e-01,8.67280283e-01,9.93774956e-01],
[7.85777351e-01,8.66931970e-01,9.93078659e-01],
[7.85095376e-01,8.66583094e-01,9.92381448e-01],
[7.84414099e-01,8.66233657e-01,9.91683324e-01],
[7.83733521e-01,8.65883657e-01,9.90984290e-01],
[7.83053641e-01,8.65533093e-01,9.90284350e-01],
[7.82374458e-01,8.65181965e-01,9.89583506e-01],
[7.81695970e-01,8.64830273e-01,9.88881761e-01],
[7.81018178e-01,8.64478014e-01,9.88179117e-01],
[7.80341080e-01,8.64125190e-01,9.87475577e-01],
[7.79664675e-01,8.63771798e-01,9.86771145e-01],
[7.78988963e-01,8.63417839e-01,9.86065823e-01],
[7.78313943e-01,8.63063312e-01,9.85359613e-01],
[7.77639614e-01,8.62708215e-01,9.84652518e-01],
[7.76965976e-01,8.62352549e-01,9.83944542e-01],
[7.76293026e-01,8.61996313e-01,9.83235687e-01],
[7.75620765e-01,8.61639506e-01,9.82525955e-01],
[7.74949191e-01,8.61282127e-01,9.81815349e-01],
[7.74278304e-01,8.60924175e-01,9.81103873e-01],
[7.73608102e-01,8.60565651e-01,9.80391529e-01],
[7.72938586e-01,8.60206553e-01,9.79678319e-01],
[7.72269753e-01,8.59846881e-01,9.78964247e-01],
[7.71601604e-01,8.59486634e-01,9.78249316e-01],
[7.70934136e-01,8.59125811e-01,9.77533527e-01],
[7.70267350e-01,8.58764412e-01,9.76816884e-01],
[7.69601244e-01,8.58402436e-01,9.76099389e-01],
[7.68935818e-01,8.58039882e-01,9.75381046e-01],
[7.68271070e-01,8.57676750e-01,9.74661857e-01],
[7.67606999e-01,8.57313039e-01,9.73941825e-01],
[7.66943605e-01,8.56948749e-01,9.73220952e-01],
[7.66280887e-01,8.56583878e-01,9.72499241e-01],
[7.65618844e-01,8.56218427e-01,9.71776696e-01],
[7.64957474e-01,8.55852394e-01,9.71053319e-01],
[7.64296776e-01,8.55485779e-01,9.70329112e-01],
[7.63636751e-01,8.55118581e-01,9.69604079e-01],
[7.62977396e-01,8.54750799e-01,9.68878221e-01],
[7.62318711e-01,8.54382434e-01,9.68151543e-01],
[7.61660695e-01,8.54013483e-01,9.67424046e-01],
[7.61003347e-01,8.53643948e-01,9.66695734e-01],
[7.60346666e-01,8.53273826e-01,9.65966609e-01],
[7.59690650e-01,8.52903118e-01,9.65236674e-01],
[7.59035299e-01,8.52531822e-01,9.64505932e-01],
[7.58380612e-01,8.52159939e-01,9.63774385e-01],
[7.57726587e-01,8.51787467e-01,9.63042037e-01],
[7.57073225e-01,8.51414406e-01,9.62308889e-01],
[7.56420523e-01,8.51040755e-01,9.61574946e-01],
[7.55768480e-01,8.50666513e-01,9.60840209e-01],
[7.55117097e-01,8.50291681e-01,9.60104681e-01],
[7.54466370e-01,8.49916257e-01,9.59368365e-01],
[7.53816301e-01,8.49540241e-01,9.58631264e-01],
[7.53166886e-01,8.49163631e-01,9.57893380e-01],
[7.52518126e-01,8.48786428e-01,9.57154717e-01],
[7.51870020e-01,8.48408631e-01,9.56415277e-01],
[7.51222565e-01,8.48030240e-01,9.55675063e-01],
[7.50575762e-01,8.47651253e-01,9.54934077e-01],
[7.49929608e-01,8.47271669e-01,9.54192323e-01],
[7.49284104e-01,8.46891490e-01,9.53449802e-01],
[7.48639247e-01,8.46510713e-01,9.52706519e-01],
[7.47995037e-01,8.46129338e-01,9.51962475e-01],
[7.47351473e-01,8.45747364e-01,9.51217673e-01],
[7.46708553e-01,8.45364792e-01,9.50472117e-01],
[7.46066276e-01,8.44981620e-01,9.49725808e-01],
[7.45424642e-01,8.44597848e-01,9.48978750e-01],
[7.44783648e-01,8.44213475e-01,9.48230945e-01],
[7.44143295e-01,8.43828500e-01,9.47482396e-01],
[7.43503580e-01,8.43442923e-01,9.46733106e-01],
[7.42864503e-01,8.43056744e-01,9.45983077e-01],
[7.42226063e-01,8.42669961e-01,9.45232313e-01],
[7.41588258e-01,8.42282574e-01,9.44480815e-01],
[7.40951087e-01,8.41894583e-01,9.43728588e-01],
[7.40314549e-01,8.41505987e-01,9.42975633e-01],
[7.39678642e-01,8.41116786e-01,9.42221953e-01],
[7.39043367e-01,8.40726978e-01,9.41467551e-01],
[7.38408720e-01,8.40336563e-01,9.40712429e-01],
[7.37774702e-01,8.39945540e-01,9.39956591e-01],
[7.37141311e-01,8.39553910e-01,9.39200040e-01],
[7.36508546e-01,8.39161671e-01,9.38442777e-01],
[7.35876406e-01,8.38768823e-01,9.37684805e-01],
[7.35244888e-01,8.38375365e-01,9.36926128e-01],
[7.34613993e-01,8.37981297e-01,9.36166748e-01],
[7.33983719e-01,8.37586618e-01,9.35406667e-01],
[7.33354065e-01,8.37191327e-01,9.34645890e-01],
[7.32725029e-01,8.36795424e-01,9.33884417e-01],
[7.32096610e-01,8.36398909e-01,9.33122252e-01],
[7.31468807e-01,8.36001780e-01,9.32359398e-01],
[7.30841619e-01,8.35604037e-01,9.31595857e-01],
[7.30215045e-01,8.35205680e-01,9.30831632e-01],
[7.29589082e-01,8.34806708e-01,9.30066725e-01],
[7.28963731e-01,8.34407121e-01,9.29301141e-01],
[7.28338989e-01,8.34006917e-01,9.28534880e-01],
[7.27714856e-01,8.33606097e-01,9.27767946e-01],
[7.27091329e-01,8.33204659e-01,9.27000342e-01],
[7.26468409e-01,8.32802604e-01,9.26232070e-01],
[7.25846093e-01,8.32399930e-01,9.25463133e-01],
[7.25224380e-01,8.31996637e-01,9.24693533e-01],
[7.24603269e-01,8.31592724e-01,9.23923274e-01],
[7.23982758e-01,8.31188192e-01,9.23152358e-01],
[7.23362847e-01,8.30783039e-01,9.22380787e-01],
[7.22743534e-01,8.30377264e-01,9.21608565e-01],
[7.22124817e-01,8.29970868e-01,9.20835694e-01],
[7.21506696e-01,8.29563850e-01,9.20062177e-01],
[7.20889169e-01,8.29156208e-01,9.19288016e-01],
[7.20272234e-01,8.28747943e-01,9.18513214e-01],
[7.19655890e-01,8.28339054e-01,9.17737774e-01],
[7.19040136e-01,8.27929541e-01,9.16961699e-01],
[7.18424971e-01,8.27519402e-01,9.16184990e-01],
[7.17810393e-01,8.27108638e-01,9.15407652e-01],
[7.17196401e-01,8.26697248e-01,9.14629685e-01],
[7.16582993e-01,8.26285230e-01,9.13851094e-01],
[7.15970169e-01,8.25872586e-01,9.13071881e-01],
[7.15357926e-01,8.25459313e-01,9.12292048e-01],
[7.14746263e-01,8.25045413e-01,9.11511598e-01],
[7.14135179e-01,8.24630883e-01,9.10730534e-01],
[7.13524673e-01,8.24215724e-01,9.09948859e-01],
[7.12914742e-01,8.23799934e-01,9.09166574e-01],
[7.12305387e-01,8.23383514e-01,9.08383683e-01],
[7.11696605e-01,8.22966463e-01,9.07600189e-01],
[7.11088394e-01,8.22548780e-01,9.06816093e-01],
[7.10480754e-01,8.22130465e-01,9.06031399e-01],
[7.09873683e-01,8.21711518e-01,9.05246109e-01],
[7.09267179e-01,8.21291937e-01,9.04460226e-01],
[7.08661242e-01,8.20871722e-01,9.03673753e-01],
[7.08055869e-01,8.20450873e-01,9.02886692e-01],
[7.07451060e-01,8.20029389e-01,9.02099045e-01],
[7.06846812e-01,8.19607269e-01,9.01310816e-01],
[7.06243125e-01,8.19184513e-01,9.00522007e-01],
[7.05639996e-01,8.18761121e-01,8.99732620e-01],
[7.05037425e-01,8.18337092e-01,8.98942658e-01],
[7.04435410e-01,8.17912426e-01,8.98152125e-01],
[7.03833949e-01,8.17487121e-01,8.97361022e-01],
[7.03233041e-01,8.17061178e-01,8.96569351e-01],
[7.02632685e-01,8.16634595e-01,8.95777117e-01],
[7.02032878e-01,8.16207373e-01,8.94984320e-01],
[7.01433620e-01,8.15779511e-01,8.94190965e-01],
[7.00834909e-01,8.15351008e-01,8.93397053e-01],
[7.00236744e-01,8.14921864e-01,8.92602587e-01],
[6.99639122e-01,8.14492078e-01,8.91807569e-01],
[6.99042043e-01,8.14061649e-01,8.91012002e-01],
[6.98445505e-01,8.13630578e-01,8.90215890e-01],
[6.97849506e-01,8.13198864e-01,8.89419233e-01],
[6.97254045e-01,8.12766505e-01,8.88622036e-01],
[6.96659120e-01,8.12333503e-01,8.87824299e-01],
[6.96064730e-01,8.11899855e-01,8.87026027e-01],
[6.95470874e-01,8.11465562e-01,8.86227221e-01],
[6.94877549e-01,8.11030623e-01,8.85427885e-01],
[6.94284754e-01,8.10595038e-01,8.84628020e-01],
[6.93692487e-01,8.10158806e-01,8.83827629e-01],
[6.93100748e-01,8.09721926e-01,8.83026715e-01],
[6.92509534e-01,8.09284398e-01,8.82225281e-01],
[6.91918844e-01,8.08846222e-01,8.81423328e-01],
[6.91328676e-01,8.08407397e-01,8.80620859e-01],
[6.90739029e-01,8.07967922e-01,8.79817878e-01],
[6.90149901e-01,8.07527797e-01,8.79014385e-01],
[6.89561291e-01,8.07087022e-01,8.78210385e-01],
[6.88973196e-01,8.06645596e-01,8.77405879e-01],
[6.88385616e-01,8.06203518e-01,8.76600870e-01],
[6.87798548e-01,8.05760788e-01,8.75795361e-01],
[6.87211992e-01,8.05317405e-01,8.74989354e-01],
[6.86625945e-01,8.04873370e-01,8.74182851e-01],
[6.86040405e-01,8.04428681e-01,8.73375855e-01],
[6.85455372e-01,8.03983337e-01,8.72568369e-01],
[6.84870844e-01,8.03537340e-01,8.71760394e-01],
[6.84286819e-01,8.03090687e-01,8.70951934e-01],
[6.83703294e-01,8.02643378e-01,8.70142991e-01],
[6.83120270e-01,8.02195414e-01,8.69333568e-01],
[6.82537743e-01,8.01746793e-01,8.68523666e-01],
[6.81955713e-01,8.01297515e-01,8.67713289e-01],
[6.81374178e-01,8.00847579e-01,8.66902439e-01],
[6.80793135e-01,8.00396985e-01,8.66091118e-01],
[6.80212584e-01,7.99945733e-01,8.65279328e-01],
[6.79632523e-01,7.99493821e-01,8.64467073e-01],
[6.79052950e-01,7.99041250e-01,8.63654355e-01],
[6.78473863e-01,7.98588019e-01,8.62841176e-01],
[6.77895260e-01,7.98134128e-01,8.62027538e-01],
[6.77317141e-01,7.97679575e-01,8.61213445e-01],
[6.76739503e-01,7.97224361e-01,8.60398898e-01],
[6.76162344e-01,7.96768484e-01,8.59583899e-01],
[6.75585663e-01,7.96311945e-01,8.58768452e-01],
[6.75009458e-01,7.95854743e-01,8.57952559e-01],
[6.74433728e-01,7.95396878e-01,8.57136222e-01],
[6.73858471e-01,7.94938349e-01,8.56319443e-01],
[6.73283684e-01,7.94479155e-01,8.55502226e-01],
[6.72709367e-01,7.94019296e-01,8.54684571e-01],
[6.72135517e-01,7.93558771e-01,8.53866483e-01],
[6.71562133e-01,7.93097581e-01,8.53047963e-01],
[6.70989213e-01,7.92635724e-01,8.52229013e-01],
[6.70416755e-01,7.92173200e-01,8.51409636e-01],
[6.69844758e-01,7.91710009e-01,8.50589834e-01],
[6.69273220e-01,7.91246149e-01,8.49769610e-01],
[6.68702139e-01,7.90781622e-01,8.48948967e-01],
[6.68131513e-01,7.90316425e-01,8.48127905e-01],
[6.67561340e-01,7.89850559e-01,8.47306429e-01],
[6.66991619e-01,7.89384023e-01,8.46484539e-01],
[6.66422348e-01,7.88916817e-01,8.45662239e-01],
[6.65853525e-01,7.88448940e-01,8.44839531e-01],
[6.65285149e-01,7.87980392e-01,8.44016417e-01],
[6.64717217e-01,7.87511172e-01,8.43192900e-01],
[6.64149728e-01,7.87041279e-01,8.42368981e-01],
[6.63582680e-01,7.86570714e-01,8.41544664e-01],
[6.63016071e-01,7.86099475e-01,8.40719950e-01],
[6.62449900e-01,7.85627563e-01,8.39894841e-01],
[6.61884164e-01,7.85154976e-01,8.39069341e-01],
[6.61318861e-01,7.84681715e-01,8.38243452e-01],
[6.60753991e-01,7.84207778e-01,8.37417175e-01],
[6.60189551e-01,7.83733166e-01,8.36590513e-01],
[6.59625539e-01,7.83257878e-01,8.35763469e-01],
[6.59061953e-01,7.82781913e-01,8.34936044e-01],
[6.58498792e-01,7.82305270e-01,8.34108241e-01],
[6.57936054e-01,7.81827951e-01,8.33280062e-01],
[6.57373736e-01,7.81349953e-01,8.32451510e-01],
[6.56811838e-01,7.80871276e-01,8.31622586e-01],
[6.56250357e-01,7.80391921e-01,8.30793293e-01],
[6.55689291e-01,7.79911886e-01,8.29963634e-01],
[6.55128638e-01,7.79431171e-01,8.29133610e-01],
[6.54568397e-01,7.78949775e-01,8.28303223e-01],
[6.54008566e-01,7.78467699e-01,8.27472477e-01],
[6.53449143e-01,7.77984941e-01,8.26641373e-01],
[6.52890125e-01,7.77501501e-01,8.25809913e-01],
[6.52331512e-01,7.77017379e-01,8.24978100e-01],
[6.51773300e-01,7.76532574e-01,8.24145936e-01],
[6.51215489e-01,7.76047085e-01,8.23313423e-01],
[6.50658077e-01,7.75560913e-01,8.22480563e-01],
[6.50101060e-01,7.75074056e-01,8.21647358e-01],
[6.49544438e-01,7.74586515e-01,8.20813811e-01],
[6.48988209e-01,7.74098288e-01,8.19979924e-01],
[6.48432371e-01,7.73609375e-01,8.19145699e-01],
[6.47876921e-01,7.73119777e-01,8.18311139e-01],
[6.47321858e-01,7.72629491e-01,8.17476244e-01],
[6.46767180e-01,7.72138518e-01,8.16641019e-01],
[6.46212885e-01,7.71646858e-01,8.15805464e-01],
[6.45658971e-01,7.71154510e-01,8.14969582e-01],
[6.45105436e-01,7.70661473e-01,8.14133374e-01],
[6.44552278e-01,7.70167746e-01,8.13296844e-01],
[6.43999495e-01,7.69673331e-01,8.12459994e-01],
[6.43447086e-01,7.69178225e-01,8.11622824e-01],
[6.42895048e-01,7.68682429e-01,8.10785339e-01],
[6.42343379e-01,7.68185941e-01,8.09947539e-01],
[6.41792077e-01,7.67688762e-01,8.09109427e-01],
[6.41241141e-01,7.67190892e-01,8.08271004e-01],
[6.40690568e-01,7.66692328e-01,8.07432274e-01],
[6.40140356e-01,7.66193072e-01,8.06593238e-01],
[6.39590504e-01,7.65693123e-01,8.05753898e-01],
[6.39041009e-01,7.65192479e-01,8.04914256e-01],
[6.38491870e-01,7.64691142e-01,8.04074315e-01],
[6.37943084e-01,7.64189109e-01,8.03234075e-01],
[6.37394649e-01,7.63686381e-01,8.02393541e-01],
[6.36846564e-01,7.63182957e-01,8.01552713e-01],
[6.36298826e-01,7.62678837e-01,8.00711594e-01],
[6.35751433e-01,7.62174021e-01,7.99870185e-01],
[6.35204384e-01,7.61668507e-01,7.99028489e-01],
[6.34657676e-01,7.61162295e-01,7.98186507e-01],
[6.34111307e-01,7.60655385e-01,7.97344243e-01],
[6.33565276e-01,7.60147777e-01,7.96501697e-01],
[6.33019579e-01,7.59639469e-01,7.95658872e-01],
[6.32474216e-01,7.59130462e-01,7.94815770e-01],
[6.31929184e-01,7.58620754e-01,7.93972392e-01],
[6.31384480e-01,7.58110346e-01,7.93128742e-01],
[6.30840104e-01,7.57599237e-01,7.92284820e-01],
[6.30296053e-01,7.57087427e-01,7.91440628e-01],
[6.29752324e-01,7.56574914e-01,7.90596170e-01],
[6.29208917e-01,7.56061699e-01,7.89751446e-01],
[6.28665827e-01,7.55547781e-01,7.88906459e-01],
[6.28123055e-01,7.55033159e-01,7.88061211e-01],
[6.27580597e-01,7.54517834e-01,7.87215703e-01],
[6.27038451e-01,7.54001803e-01,7.86369938e-01],
[6.26496616e-01,7.53485068e-01,7.85523917e-01],
[6.25955089e-01,7.52967628e-01,7.84677642e-01],
[6.25413868e-01,7.52449482e-01,7.83831116e-01],
[6.24872952e-01,7.51930629e-01,7.82984340e-01],
[6.24332337e-01,7.51411069e-01,7.82137316e-01],
[6.23792022e-01,7.50890803e-01,7.81290046e-01],
[6.23252004e-01,7.50369828e-01,7.80442532e-01],
[6.22712283e-01,7.49848145e-01,7.79594776e-01],
[6.22172854e-01,7.49325753e-01,7.78746780e-01],
[6.21633717e-01,7.48802651e-01,7.77898545e-01],
[6.21094869e-01,7.48278840e-01,7.77050074e-01],
[6.20556309e-01,7.47754319e-01,7.76201368e-01],
[6.20018033e-01,7.47229087e-01,7.75352429e-01],
[6.19480039e-01,7.46703144e-01,7.74503259e-01],
[6.18942327e-01,7.46176488e-01,7.73653860e-01],
[6.18404893e-01,7.45649121e-01,7.72804234e-01],
[6.17867735e-01,7.45121041e-01,7.71954382e-01],
[6.17330851e-01,7.44592247e-01,7.71104306e-01],
[6.16794239e-01,7.44062740e-01,7.70254009e-01],
[6.16257897e-01,7.43532519e-01,7.69403491e-01],
[6.15721823e-01,7.43001583e-01,7.68552756e-01],
[6.15186013e-01,7.42469932e-01,7.67701804e-01],
[6.14650467e-01,7.41937565e-01,7.66850637e-01],
[6.14115183e-01,7.41404481e-01,7.65999257e-01],
[6.13580157e-01,7.40870681e-01,7.65147666e-01],
[6.13045387e-01,7.40336164e-01,7.64295866e-01],
[6.12510872e-01,7.39800929e-01,7.63443858e-01],
[6.11976609e-01,7.39264976e-01,7.62591644e-01],
[6.11442596e-01,7.38728304e-01,7.61739226e-01],
[6.10908831e-01,7.38190913e-01,7.60886606e-01],
[6.10375312e-01,7.37652803e-01,7.60033785e-01],
[6.09842036e-01,7.37113972e-01,7.59180765e-01],
[6.09309001e-01,7.36574420e-01,7.58327548e-01],
[6.08776204e-01,7.36034147e-01,7.57474135e-01],
[6.08243645e-01,7.35493153e-01,7.56620528e-01],
[6.07711320e-01,7.34951436e-01,7.55766730e-01],
[6.07179227e-01,7.34408996e-01,7.54912740e-01],
[6.06647363e-01,7.33865833e-01,7.54058562e-01],
[6.06115728e-01,7.33321947e-01,7.53204197e-01],
[6.05584318e-01,7.32777336e-01,7.52349646e-01],
[6.05053131e-01,7.32232000e-01,7.51494912e-01],
[6.04522164e-01,7.31685939e-01,7.50639995e-01],
[6.03991417e-01,7.31139152e-01,7.49784897e-01],
[6.03460885e-01,7.30591639e-01,7.48929621e-01],
[6.02930568e-01,7.30043399e-01,7.48074167e-01],
[6.02400462e-01,7.29494431e-01,7.47218538e-01],
[6.01870566e-01,7.28944736e-01,7.46362734e-01],
[6.01340877e-01,7.28394312e-01,7.45506758e-01],
[6.00811392e-01,7.27843159e-01,7.44650611e-01],
[6.00282110e-01,7.27291277e-01,7.43794295e-01],
[5.99753029e-01,7.26738665e-01,7.42937811e-01],
[5.99224145e-01,7.26185323e-01,7.42081161e-01],
[5.98695457e-01,7.25631249e-01,7.41224346e-01],
[5.98166962e-01,7.25076444e-01,7.40367368e-01],
[5.97638658e-01,7.24520906e-01,7.39510228e-01],
[5.97110542e-01,7.23964637e-01,7.38652928e-01],
[5.96582613e-01,7.23407634e-01,7.37795470e-01],
[5.96054868e-01,7.22849897e-01,7.36937855e-01],
[5.95527304e-01,7.22291426e-01,7.36080084e-01],
[5.94999920e-01,7.21732220e-01,7.35222159e-01],
[5.94472712e-01,7.21172279e-01,7.34364082e-01],
[5.93945679e-01,7.20611603e-01,7.33505853e-01],
[5.93418818e-01,7.20050190e-01,7.32647475e-01],
[5.92892127e-01,7.19488040e-01,7.31788949e-01],
[5.92365603e-01,7.18925152e-01,7.30930277e-01],
[5.91839245e-01,7.18361527e-01,7.30071459e-01],
[5.91313049e-01,7.17797163e-01,7.29212497e-01],
[5.90787013e-01,7.17232060e-01,7.28353393e-01],
[5.90261135e-01,7.16666217e-01,7.27494148e-01],
[5.89735413e-01,7.16099634e-01,7.26634764e-01],
[5.89209843e-01,7.15532311e-01,7.25775242e-01],
[5.88684425e-01,7.14964246e-01,7.24915582e-01],
[5.88159154e-01,7.14395440e-01,7.24055788e-01],
[5.87634030e-01,7.13825891e-01,7.23195860e-01],
[5.87109049e-01,7.13255599e-01,7.22335799e-01],
[5.86584209e-01,7.12684563e-01,7.21475607e-01],
[5.86059508e-01,7.12112784e-01,7.20615285e-01],
[5.85534942e-01,7.11540260e-01,7.19754835e-01],
[5.85010511e-01,7.10966990e-01,7.18894258e-01],
[5.84486211e-01,7.10392975e-01,7.18033554e-01],
[5.83962039e-01,7.09818214e-01,7.17172727e-01],
[5.83437995e-01,7.09242706e-01,7.16311776e-01],
[5.82914074e-01,7.08666450e-01,7.15450703e-01],
[5.82390274e-01,7.08089447e-01,7.14589510e-01],
[5.81866594e-01,7.07511694e-01,7.13728198e-01],
[5.81343030e-01,7.06933193e-01,7.12866767e-01],
[5.80819580e-01,7.06353942e-01,7.12005220e-01],
[5.80296242e-01,7.05773940e-01,7.11143557e-01],
[5.79773013e-01,7.05193188e-01,7.10281780e-01],
[5.79249891e-01,7.04611684e-01,7.09419890e-01],
[5.78726873e-01,7.04029428e-01,7.08557888e-01],
[5.78203956e-01,7.03446419e-01,7.07695776e-01],
[5.77681139e-01,7.02862657e-01,7.06833555e-01],
[5.77158418e-01,7.02278141e-01,7.05971225e-01],
[5.76635792e-01,7.01692871e-01,7.05108788e-01],
[5.76113257e-01,7.01106846e-01,7.04246246e-01],
[5.75590811e-01,7.00520065e-01,7.03383599e-01],
[5.75068452e-01,6.99932527e-01,7.02520849e-01],
[5.74546177e-01,6.99344233e-01,7.01657997e-01],
[5.74023984e-01,6.98755182e-01,7.00795043e-01],
[5.73501869e-01,6.98165372e-01,6.99931990e-01],
[5.72979831e-01,6.97574804e-01,6.99068837e-01],
[5.72457867e-01,6.96983476e-01,6.98205587e-01],
[5.71935975e-01,6.96391389e-01,6.97342241e-01],
[5.71414151e-01,6.95798541e-01,6.96478799e-01],
[5.70892393e-01,6.95204932e-01,6.95615263e-01],
[5.70370699e-01,6.94610561e-01,6.94751633e-01],
[5.69849066e-01,6.94015428e-01,6.93887911e-01],
[5.69327492e-01,6.93419532e-01,6.93024099e-01],
[5.68805973e-01,6.92822872e-01,6.92160196e-01],
[5.68284508e-01,6.92225448e-01,6.91296204e-01],
[5.67763094e-01,6.91627259e-01,6.90432124e-01],
[5.67241728e-01,6.91028304e-01,6.89567957e-01],
[5.66720407e-01,6.90428583e-01,6.88703704e-01],
[5.66199130e-01,6.89828096e-01,6.87839366e-01],
[5.65677893e-01,6.89226841e-01,6.86974944e-01],
[5.65156693e-01,6.88624818e-01,6.86110440e-01],
[5.64635529e-01,6.88022026e-01,6.85245853e-01],
[5.64114397e-01,6.87418465e-01,6.84381185e-01],
[5.63593295e-01,6.86814134e-01,6.83516437e-01],
[5.63072220e-01,6.86209032e-01,6.82651611e-01],
[5.62551170e-01,6.85603159e-01,6.81786706e-01],
[5.62030142e-01,6.84996513e-01,6.80921724e-01],
[5.61509133e-01,6.84389095e-01,6.80056665e-01],
[5.60988141e-01,6.83780904e-01,6.79191531e-01],
[5.60467163e-01,6.83171939e-01,6.78326323e-01],
[5.59946196e-01,6.82562199e-01,6.77461041e-01],
[5.59425237e-01,6.81951683e-01,6.76595686e-01],
[5.58904285e-01,6.81340392e-01,6.75730260e-01],
[5.58383336e-01,6.80728324e-01,6.74864762e-01],
[5.57862387e-01,6.80115478e-01,6.73999195e-01],
[5.57341437e-01,6.79501854e-01,6.73133558e-01],
[5.56820481e-01,6.78887452e-01,6.72267853e-01],
[5.56299518e-01,6.78272269e-01,6.71402080e-01],
[5.55778545e-01,6.77656307e-01,6.70536240e-01],
[5.55257559e-01,6.77039564e-01,6.69670334e-01],
[5.54736558e-01,6.76422039e-01,6.68804363e-01],
[5.54215537e-01,6.75803732e-01,6.67938328e-01],
[5.53694496e-01,6.75184642e-01,6.67072228e-01],
[5.53173431e-01,6.74564768e-01,6.66206066e-01],
[5.52652340e-01,6.73944110e-01,6.65339842e-01],
[5.52131219e-01,6.73322667e-01,6.64473556e-01],
[5.51610066e-01,6.72700437e-01,6.63607210e-01],
[5.51088878e-01,6.72077422e-01,6.62740803e-01],
[5.50567653e-01,6.71453618e-01,6.61874337e-01],
[5.50046387e-01,6.70829027e-01,6.61007813e-01],
[5.49525078e-01,6.70203647e-01,6.60141231e-01],
[5.49003724e-01,6.69577477e-01,6.59274591e-01],
[5.48482320e-01,6.68950517e-01,6.58407895e-01],
[5.47960865e-01,6.68322766e-01,6.57541143e-01],
[5.47439356e-01,6.67694223e-01,6.56674336e-01],
[5.46917790e-01,6.67064888e-01,6.55807474e-01],
[5.46396164e-01,6.66434759e-01,6.54940558e-01],
[5.45874475e-01,6.65803836e-01,6.54073588e-01],
[5.45352721e-01,6.65172119e-01,6.53206566e-01],
[5.44830898e-01,6.64539605e-01,6.52339492e-01],
[5.44309004e-01,6.63906296e-01,6.51472365e-01],
[5.43787036e-01,6.63272189e-01,6.50605188e-01],
[5.43264992e-01,6.62637284e-01,6.49737960e-01],
[5.42742867e-01,6.62001581e-01,6.48870683e-01],
[5.42220661e-01,6.61365078e-01,6.48003355e-01],
[5.41698368e-01,6.60727774e-01,6.47135979e-01],
[5.41175988e-01,6.60089670e-01,6.46268555e-01],
[5.40653516e-01,6.59450764e-01,6.45401082e-01],
[5.40130951e-01,6.58811055e-01,6.44533562e-01],
[5.39608288e-01,6.58170542e-01,6.43665995e-01],
[5.39085526e-01,6.57529225e-01,6.42798382e-01],
[5.38562661e-01,6.56887103e-01,6.41930722e-01],
[5.38039690e-01,6.56244175e-01,6.41063017e-01],
[5.37516611e-01,6.55600440e-01,6.40195267e-01],
[5.36993421e-01,6.54955898e-01,6.39327472e-01],
[5.36470116e-01,6.54310547e-01,6.38459633e-01],
[5.35946694e-01,6.53664386e-01,6.37591749e-01],
[5.35423152e-01,6.53017416e-01,6.36723822e-01],
[5.34899487e-01,6.52369634e-01,6.35855852e-01],
[5.34375696e-01,6.51721041e-01,6.34987840e-01],
[5.33851776e-01,6.51071635e-01,6.34119784e-01],
[5.33327724e-01,6.50421415e-01,6.33251687e-01],
[5.32803537e-01,6.49770381e-01,6.32383548e-01],
[5.32279212e-01,6.49118532e-01,6.31515367e-01],
[5.31754746e-01,6.48465866e-01,6.30647145e-01],
[5.31230137e-01,6.47812384e-01,6.29778882e-01],
[5.30705380e-01,6.47158083e-01,6.28910579e-01],
[5.30180474e-01,6.46502964e-01,6.28042235e-01],
[5.29655415e-01,6.45847024e-01,6.27173851e-01],
[5.29130201e-01,6.45190264e-01,6.26305427e-01],
[5.28604827e-01,6.44532683e-01,6.25436964e-01],
[5.28079292e-01,6.43874279e-01,6.24568461e-01],
[5.27553592e-01,6.43215052e-01,6.23699920e-01],
[5.27027724e-01,6.42555000e-01,6.22831339e-01],
[5.26501685e-01,6.41894123e-01,6.21962719e-01],
[5.25975472e-01,6.41232420e-01,6.21094061e-01],
[5.25449082e-01,6.40569890e-01,6.20225364e-01],
[5.24922512e-01,6.39906532e-01,6.19356629e-01],
[5.24395758e-01,6.39242345e-01,6.18487856e-01],
[5.23868819e-01,6.38577328e-01,6.17619044e-01],
[5.23341690e-01,6.37911480e-01,6.16750195e-01],
[5.22814369e-01,6.37244800e-01,6.15881308e-01],
[5.22286852e-01,6.36577287e-01,6.15012383e-01],
[5.21759137e-01,6.35908941e-01,6.14143420e-01],
[5.21231220e-01,6.35239759e-01,6.13274420e-01],
[5.20703098e-01,6.34569742e-01,6.12405382e-01],
[5.20174769e-01,6.33898888e-01,6.11536307e-01],
[5.19646228e-01,6.33227197e-01,6.10667194e-01],
[5.19117473e-01,6.32554666e-01,6.09798043e-01],
[5.18588501e-01,6.31881296e-01,6.08928855e-01],
[5.18059308e-01,6.31207085e-01,6.08059630e-01],
[5.17529892e-01,6.30532033e-01,6.07190367e-01],
[5.17000249e-01,6.29856137e-01,6.06321066e-01],
[5.16470376e-01,6.29179398e-01,6.05451727e-01],
[5.15940270e-01,6.28501813e-01,6.04582351e-01],
[5.15409927e-01,6.27823383e-01,6.03712937e-01],
[5.14879345e-01,6.27144106e-01,6.02843485e-01],
[5.14348520e-01,6.26463980e-01,6.01973995e-01],
[5.13817450e-01,6.25783006e-01,6.01104467e-01],
[5.13286130e-01,6.25101181e-01,6.00234901e-01],
[5.12754557e-01,6.24418505e-01,5.99365296e-01],
[5.12222729e-01,6.23734976e-01,5.98495652e-01],
[5.11690643e-01,6.23050595e-01,5.97625970e-01],
[5.11158294e-01,6.22365358e-01,5.96756248e-01],
[5.10625680e-01,6.21679266e-01,5.95886488e-01],
[5.10092797e-01,6.20992317e-01,5.95016688e-01],
[5.09559642e-01,6.20304511e-01,5.94146849e-01],
[5.09026212e-01,6.19615845e-01,5.93276969e-01],
[5.08492504e-01,6.18926319e-01,5.92407050e-01],
[5.07958514e-01,6.18235932e-01,5.91537090e-01],
[5.07424238e-01,6.17544683e-01,5.90667090e-01],
[5.06889675e-01,6.16852570e-01,5.89797048e-01],
[5.06354820e-01,6.16159592e-01,5.88926966e-01],
[5.05819670e-01,6.15465748e-01,5.88056841e-01],
[5.05284221e-01,6.14771037e-01,5.87186675e-01],
[5.04748471e-01,6.14075458e-01,5.86316466e-01],
[5.04212415e-01,6.13379010e-01,5.85446215e-01],
[5.03676052e-01,6.12681691e-01,5.84575921e-01],
[5.03139376e-01,6.11983500e-01,5.83705583e-01],
[5.02602386e-01,6.11284436e-01,5.82835201e-01],
[5.02065077e-01,6.10584498e-01,5.81964775e-01],
[5.01527446e-01,6.09883684e-01,5.81094305e-01],
[5.00989489e-01,6.09181994e-01,5.80223789e-01],
[5.00451204e-01,6.08479425e-01,5.79353227e-01],
[4.99912587e-01,6.07775978e-01,5.78482620e-01],
[4.99373634e-01,6.07071650e-01,5.77611965e-01],
[4.98834342e-01,6.06366440e-01,5.76741264e-01],
[4.98294707e-01,6.05660347e-01,5.75870515e-01],
[4.97754727e-01,6.04953370e-01,5.74999717e-01],
[4.97214397e-01,6.04245508e-01,5.74128871e-01],
[4.96673715e-01,6.03536758e-01,5.73257976e-01],
[4.96132676e-01,6.02827120e-01,5.72387030e-01],
[4.95591277e-01,6.02116593e-01,5.71516034e-01],
[4.95049514e-01,6.01405175e-01,5.70644987e-01],
[4.94507385e-01,6.00692865e-01,5.69773888e-01],
[4.93964886e-01,5.99979661e-01,5.68902737e-01],
[4.93422012e-01,5.99265563e-01,5.68031532e-01],
[4.92878762e-01,5.98550568e-01,5.67160274e-01],
[4.92335130e-01,5.97834676e-01,5.66288961e-01],
[4.91791113e-01,5.97117884e-01,5.65417593e-01],
[4.91246708e-01,5.96400193e-01,5.64546169e-01],
[4.90701912e-01,5.95681599e-01,5.63674688e-01],
[4.90156720e-01,5.94962103e-01,5.62803150e-01],
[4.89611130e-01,5.94241702e-01,5.61931553e-01],
[4.89065137e-01,5.93520395e-01,5.61059898e-01],
[4.88518737e-01,5.92798181e-01,5.60188183e-01],
[4.87971928e-01,5.92075058e-01,5.59316407e-01],
[4.87424706e-01,5.91351024e-01,5.58444570e-01],
[4.86877066e-01,5.90626079e-01,5.57572671e-01],
[4.86329006e-01,5.89900220e-01,5.56700708e-01],
[4.85780522e-01,5.89173447e-01,5.55828681e-01],
[4.85231609e-01,5.88445758e-01,5.54956589e-01],
[4.84682264e-01,5.87717151e-01,5.54084432e-01],
[4.84132484e-01,5.86987625e-01,5.53212207e-01],
[4.83582265e-01,5.86257178e-01,5.52339915e-01],
[4.83031603e-01,5.85525809e-01,5.51467554e-01],
[4.82480495e-01,5.84793516e-01,5.50595123e-01],
[4.81928936e-01,5.84060297e-01,5.49722621e-01],
[4.81376922e-01,5.83326152e-01,5.48850048e-01],
[4.80824451e-01,5.82591079e-01,5.47977402e-01],
[4.80271518e-01,5.81855075e-01,5.47104682e-01],
[4.79718120e-01,5.81118139e-01,5.46231887e-01],
[4.79164252e-01,5.80380271e-01,5.45359016e-01],
[4.78609912e-01,5.79641467e-01,5.44486068e-01],
[4.78055094e-01,5.78901727e-01,5.43613041e-01],
[4.77499796e-01,5.78161049e-01,5.42739936e-01],
[4.76944013e-01,5.77419431e-01,5.41866749e-01],
[4.76387741e-01,5.76676872e-01,5.40993481e-01],
[4.75830978e-01,5.75933369e-01,5.40120130e-01],
[4.75273718e-01,5.75188922e-01,5.39246695e-01],
[4.74715957e-01,5.74443528e-01,5.38373175e-01],
[4.74157693e-01,5.73697186e-01,5.37499568e-01],
[4.73598921e-01,5.72949894e-01,5.36625873e-01],
[4.73039637e-01,5.72201651e-01,5.35752089e-01],
[4.72479837e-01,5.71452454e-01,5.34878214e-01],
[4.71919518e-01,5.70702301e-01,5.34004248e-01],
[4.71358674e-01,5.69951192e-01,5.33130188e-01],
[4.70797303e-01,5.69199124e-01,5.32256034e-01],
[4.70235401e-01,5.68446096e-01,5.31381785e-01],
[4.69672962e-01,5.67692106e-01,5.30507438e-01],
[4.69109984e-01,5.66937151e-01,5.29632992e-01],
[4.68546462e-01,5.66181230e-01,5.28758446e-01],
[4.67982392e-01,5.65424342e-01,5.27883799e-01],
[4.67417770e-01,5.64666483e-01,5.27009048e-01],
[4.66852592e-01,5.63907654e-01,5.26134193e-01],
[4.66286854e-01,5.63147851e-01,5.25259232e-01],
[4.65720552e-01,5.62387072e-01,5.24384163e-01],
[4.65153682e-01,5.61625317e-01,5.23508986e-01],
[4.64586239e-01,5.60862582e-01,5.22633697e-01],
[4.64018220e-01,5.60098866e-01,5.21758297e-01],
[4.63449620e-01,5.59334167e-01,5.20882782e-01],
[4.62880435e-01,5.58568483e-01,5.20007152e-01],
[4.62310661e-01,5.57801812e-01,5.19131405e-01],
[4.61740294e-01,5.57034152e-01,5.18255539e-01],
[4.61169329e-01,5.56265502e-01,5.17379552e-01],
[4.60597763e-01,5.55495858e-01,5.16503444e-01],
[4.60025591e-01,5.54725219e-01,5.15627211e-01],
[4.59452808e-01,5.53953583e-01,5.14750853e-01],
[4.58879411e-01,5.53180948e-01,5.13874367e-01],
[4.58305395e-01,5.52407311e-01,5.12997752e-01],
[4.57730756e-01,5.51632671e-01,5.12121005e-01],
[4.57155490e-01,5.50857026e-01,5.11244126e-01],
[4.56579592e-01,5.50080373e-01,5.10367112e-01],
[4.56003058e-01,5.49302710e-01,5.09489962e-01],
[4.55425884e-01,5.48524036e-01,5.08612672e-01],
[4.54848065e-01,5.47744347e-01,5.07735243e-01],
[4.54269596e-01,5.46963642e-01,5.06857671e-01],
[4.53690474e-01,5.46181919e-01,5.05979954e-01],
[4.53110694e-01,5.45399175e-01,5.05102091e-01],
[4.52530251e-01,5.44615408e-01,5.04224080e-01],
[4.51949141e-01,5.43830616e-01,5.03345919e-01],
[4.51367360e-01,5.43044796e-01,5.02467605e-01],
[4.50784903e-01,5.42257946e-01,5.01589136e-01],
[4.50201766e-01,5.41470065e-01,5.00710511e-01],
[4.49617943e-01,5.40681148e-01,4.99831727e-01],
[4.49033432e-01,5.39891196e-01,4.98952782e-01],
[4.48448225e-01,5.39100204e-01,4.98073674e-01],
[4.47862321e-01,5.38308170e-01,4.97194401e-01],
[4.47275713e-01,5.37515093e-01,4.96314960e-01],
[4.46688397e-01,5.36720969e-01,4.95435350e-01],
[4.46100368e-01,5.35925796e-01,4.94555567e-01],
[4.45511623e-01,5.35129573e-01,4.93675610e-01],
[4.44922155e-01,5.34332295e-01,4.92795477e-01],
[4.44331961e-01,5.33533962e-01,4.91915165e-01],
[4.43741036e-01,5.32734569e-01,4.91034672e-01],
[4.43149375e-01,5.31934116e-01,4.90153995e-01],
[4.42556973e-01,5.31132599e-01,4.89273132e-01],
[4.41963825e-01,5.30330015e-01,4.88392080e-01],
[4.41369928e-01,5.29526363e-01,4.87510837e-01],
[4.40775275e-01,5.28721639e-01,4.86629401e-01],
[4.40179862e-01,5.27915841e-01,4.85747770e-01],
[4.39583685e-01,5.27108966e-01,4.84865939e-01],
[4.38986738e-01,5.26301011e-01,4.83983908e-01],
[4.38389016e-01,5.25491974e-01,4.83101673e-01],
[4.37790515e-01,5.24681853e-01,4.82219232e-01],
[4.37191230e-01,5.23870644e-01,4.81336582e-01],
[4.36591155e-01,5.23058344e-01,4.80453720e-01],
[4.35990286e-01,5.22244952e-01,4.79570644e-01],
[4.35388618e-01,5.21430463e-01,4.78687352e-01],
[4.34786146e-01,5.20614876e-01,4.77803839e-01],
[4.34182865e-01,5.19798187e-01,4.76920105e-01],
[4.33578769e-01,5.18980394e-01,4.76036145e-01],
[4.32973854e-01,5.18161494e-01,4.75151957e-01],
[4.32368114e-01,5.17341483e-01,4.74267538e-01],
[4.31761545e-01,5.16520359e-01,4.73382885e-01],
[4.31154141e-01,5.15698119e-01,4.72497995e-01],
[4.30545897e-01,5.14874760e-01,4.71612866e-01],
[4.29936808e-01,5.14050278e-01,4.70727495e-01],
[4.29326868e-01,5.13224672e-01,4.69841877e-01],
[4.28716073e-01,5.12397938e-01,4.68956012e-01],
[4.28104418e-01,5.11570072e-01,4.68069894e-01],
[4.27491896e-01,5.10741072e-01,4.67183522e-01],
[4.26878503e-01,5.09910934e-01,4.66296892e-01],
[4.26264233e-01,5.09079656e-01,4.65410001e-01],
[4.25649081e-01,5.08247234e-01,4.64522846e-01],
[4.25033042e-01,5.07413665e-01,4.63635423e-01],
[4.24416110e-01,5.06578946e-01,4.62747730e-01],
[4.23798279e-01,5.05743074e-01,4.61859763e-01],
[4.23179545e-01,5.04906045e-01,4.60971519e-01],
[4.22559902e-01,5.04067855e-01,4.60082994e-01],
[4.21939344e-01,5.03228503e-01,4.59194186e-01],
[4.21317866e-01,5.02387983e-01,4.58305090e-01],
[4.20695462e-01,5.01546294e-01,4.57415704e-01],
[4.20072126e-01,5.00703431e-01,4.56526024e-01],
[4.19447854e-01,4.99859391e-01,4.55636046e-01],
[4.18822639e-01,4.99014171e-01,4.54745767e-01],
[4.18196475e-01,4.98167767e-01,4.53855184e-01],
[4.17569358e-01,4.97320175e-01,4.52964292e-01],
[4.16941281e-01,4.96471392e-01,4.52073089e-01],
[4.16312239e-01,4.95621415e-01,4.51181570e-01],
[4.15682225e-01,4.94770240e-01,4.50289732e-01],
[4.15051234e-01,4.93917862e-01,4.49397571e-01],
[4.14419260e-01,4.93064280e-01,4.48505084e-01],
[4.13786298e-01,4.92209488e-01,4.47612266e-01],
[4.13152341e-01,4.91353483e-01,4.46719114e-01],
[4.12517383e-01,4.90496261e-01,4.45825624e-01],
[4.11881419e-01,4.89637819e-01,4.44931792e-01],
[4.11244442e-01,4.88778152e-01,4.44037615e-01],
[4.10606447e-01,4.87917258e-01,4.43143087e-01],
[4.09967427e-01,4.87055131e-01,4.42248206e-01],
[4.09327377e-01,4.86191768e-01,4.41352967e-01],
[4.08686289e-01,4.85327165e-01,4.40457366e-01],
[4.08044159e-01,4.84461318e-01,4.39561398e-01],
[4.07400980e-01,4.83594223e-01,4.38665061e-01],
[4.06756745e-01,4.82725876e-01,4.37768350e-01],
[4.06111449e-01,4.81856273e-01,4.36871259e-01],
[4.05465085e-01,4.80985409e-01,4.35973786e-01],
[4.04817646e-01,4.80113281e-01,4.35075926e-01],
[4.04169127e-01,4.79239884e-01,4.34177675e-01],
[4.03519522e-01,4.78365214e-01,4.33279027e-01],
[4.02868822e-01,4.77489267e-01,4.32379980e-01],
[4.02217024e-01,4.76612039e-01,4.31480527e-01],
[4.01564118e-01,4.75733524e-01,4.30580665e-01],
[4.00910100e-01,4.74853719e-01,4.29680390e-01],
[4.00254963e-01,4.73972620e-01,4.28779696e-01],
[3.99598700e-01,4.73090221e-01,4.27878579e-01],
[3.98941304e-01,4.72206519e-01,4.26977035e-01],
[3.98282769e-01,4.71321508e-01,4.26075058e-01],
[3.97623088e-01,4.70435184e-01,4.25172644e-01],
[3.96962254e-01,4.69547543e-01,4.24269789e-01],
[3.96300260e-01,4.68658580e-01,4.23366486e-01],
[3.95637100e-01,4.67768290e-01,4.22462732e-01],
[3.94972767e-01,4.66876668e-01,4.21558521e-01],
[3.94307254e-01,4.65983710e-01,4.20653849e-01],
[3.93640554e-01,4.65089411e-01,4.19748710e-01],
[3.92972659e-01,4.64193765e-01,4.18843100e-01],
[3.92303564e-01,4.63296769e-01,4.17937013e-01],
[3.91633260e-01,4.62398416e-01,4.17030444e-01],
[3.90961740e-01,4.61498702e-01,4.16123388e-01],
[3.90288999e-01,4.60597622e-01,4.15215839e-01],
[3.89615027e-01,4.59695171e-01,4.14307793e-01],
[3.88939819e-01,4.58791344e-01,4.13399244e-01],
[3.88263366e-01,4.57886135e-01,4.12490187e-01],
[3.87585661e-01,4.56979539e-01,4.11580615e-01],
[3.86906698e-01,4.56071551e-01,4.10670525e-01],
[3.86226468e-01,4.55162165e-01,4.09759909e-01],
[3.85544964e-01,4.54251377e-01,4.08848763e-01],
[3.84862178e-01,4.53339180e-01,4.07937081e-01],
[3.84178104e-01,4.52425570e-01,4.07024857e-01],
[3.83492732e-01,4.51510540e-01,4.06112085e-01],
[3.82806057e-01,4.50594085e-01,4.05198760e-01],
[3.82118069e-01,4.49676200e-01,4.04284876e-01],
[3.81428761e-01,4.48756878e-01,4.03370426e-01],
[3.80738125e-01,4.47836115e-01,4.02455405e-01],
[3.80046154e-01,4.46913903e-01,4.01539807e-01],
[3.79352840e-01,4.45990238e-01,4.00623626e-01],
[3.78658173e-01,4.45065113e-01,3.99706855e-01],
[3.77962148e-01,4.44138522e-01,3.98789488e-01],
[3.77264754e-01,4.43210460e-01,3.97871520e-01],
[3.76565985e-01,4.42280920e-01,3.96952943e-01],
[3.75865831e-01,4.41349896e-01,3.96033752e-01],
[3.75164285e-01,4.40417382e-01,3.95113940e-01],
[3.74461339e-01,4.39483371e-01,3.94193500e-01],
[3.73756983e-01,4.38547858e-01,3.93272427e-01],
[3.73051211e-01,4.37610836e-01,3.92350712e-01],
[3.72344012e-01,4.36672298e-01,3.91428350e-01],
[3.71635378e-01,4.35732238e-01,3.90505334e-01],
[3.70925302e-01,4.34790650e-01,3.89581657e-01],
[3.70213773e-01,4.33847526e-01,3.88657312e-01],
[3.69500784e-01,4.32902860e-01,3.87732293e-01],
[3.68786326e-01,4.31956646e-01,3.86806591e-01],
[3.68070390e-01,4.31008875e-01,3.85880201e-01],
[3.67352966e-01,4.30059543e-01,3.84953115e-01],
[3.66634046e-01,4.29108641e-01,3.84025326e-01],
[3.65913621e-01,4.28156162e-01,3.83096826e-01],
[3.65191682e-01,4.27202100e-01,3.82167608e-01],
[3.64468219e-01,4.26246447e-01,3.81237665e-01],
[3.63743223e-01,4.25289196e-01,3.80306990e-01],
[3.63016685e-01,4.24330339e-01,3.79375574e-01],
[3.62288595e-01,4.23369870e-01,3.78443410e-01],
[3.61558945e-01,4.22407781e-01,3.77510491e-01],
[3.60827723e-01,4.21444063e-01,3.76576808e-01],
[3.60094922e-01,4.20478710e-01,3.75642354e-01],
[3.59360530e-01,4.19511714e-01,3.74707121e-01],
[3.58624539e-01,4.18543067e-01,3.73771101e-01],
[3.57886939e-01,4.17572761e-01,3.72834285e-01],
[3.57147718e-01,4.16600789e-01,3.71896666e-01],
[3.56406869e-01,4.15627141e-01,3.70958235e-01],
[3.55664379e-01,4.14651811e-01,3.70018984e-01],
[3.54920240e-01,4.13674790e-01,3.69078905e-01],
[3.54174441e-01,4.12696069e-01,3.68137988e-01],
[3.53426971e-01,4.11715640e-01,3.67196226e-01],
[3.52677821e-01,4.10733495e-01,3.66253610e-01],
[3.51926979e-01,4.09749626e-01,3.65310131e-01],
[3.51174436e-01,4.08764022e-01,3.64365780e-01],
[3.50420180e-01,4.07776677e-01,3.63420548e-01],
[3.49664201e-01,4.06787581e-01,3.62474426e-01],
[3.48906487e-01,4.05796725e-01,3.61527405e-01],
[3.48147028e-01,4.04804100e-01,3.60579477e-01],
[3.47385813e-01,4.03809697e-01,3.59630631e-01],
[3.46622831e-01,4.02813507e-01,3.58680858e-01],
[3.45858070e-01,4.01815520e-01,3.57730148e-01],
[3.45091520e-01,4.00815727e-01,3.56778493e-01],
[3.44323168e-01,3.99814119e-01,3.55825882e-01],
[3.43553003e-01,3.98810686e-01,3.54872306e-01],
[3.42781014e-01,3.97805418e-01,3.53917754e-01],
[3.42007189e-01,3.96798306e-01,3.52962217e-01],
[3.41231515e-01,3.95789339e-01,3.52005685e-01],
[3.40453982e-01,3.94778507e-01,3.51048147e-01],
[3.39674576e-01,3.93765801e-01,3.50089593e-01],
[3.38893287e-01,3.92751210e-01,3.49130013e-01],
[3.38110101e-01,3.91734723e-01,3.48169396e-01],
[3.37325006e-01,3.90716331e-01,3.47207731e-01],
[3.36537990e-01,3.89696022e-01,3.46245008e-01],
[3.35749040e-01,3.88673785e-01,3.45281216e-01],
[3.34958144e-01,3.87649611e-01,3.44316344e-01],
[3.34165288e-01,3.86623488e-01,3.43350380e-01],
[3.33370459e-01,3.85595404e-01,3.42383314e-01],
[3.32573645e-01,3.84565349e-01,3.41415134e-01],
[3.31774833e-01,3.83533311e-01,3.40445829e-01],
[3.30974008e-01,3.82499279e-01,3.39475387e-01],
[3.30171158e-01,3.81463241e-01,3.38503796e-01],
[3.29366268e-01,3.80425185e-01,3.37531045e-01],
[3.28559326e-01,3.79385100e-01,3.36557122e-01],
[3.27750317e-01,3.78342973e-01,3.35582013e-01],
[3.26939228e-01,3.77298792e-01,3.34605708e-01],
[3.26126043e-01,3.76252545e-01,3.33628194e-01],
[3.25310750e-01,3.75204219e-01,3.32649458e-01],
[3.24493333e-01,3.74153802e-01,3.31669488e-01],
[3.23673778e-01,3.73101281e-01,3.30688270e-01],
[3.22852070e-01,3.72046643e-01,3.29705792e-01],
[3.22028194e-01,3.70989875e-01,3.28722041e-01],
[3.21202136e-01,3.69930964e-01,3.27737003e-01],
[3.20373880e-01,3.68869896e-01,3.26750665e-01],
[3.19543411e-01,3.67806657e-01,3.25763014e-01],
[3.18710713e-01,3.66741235e-01,3.24774036e-01],
[3.17875771e-01,3.65673614e-01,3.23783716e-01],
[3.17038568e-01,3.64603781e-01,3.22792042e-01],
[3.16199090e-01,3.63531723e-01,3.21798998e-01],
[3.15357319e-01,3.62457423e-01,3.20804570e-01],
[3.14513240e-01,3.61380868e-01,3.19808744e-01],
[3.13666836e-01,3.60302043e-01,3.18811505e-01],
[3.12818089e-01,3.59220932e-01,3.17812838e-01],
[3.11966985e-01,3.58137521e-01,3.16812728e-01],
[3.11113504e-01,3.57051795e-01,3.15811160e-01],
[3.10257631e-01,3.55963737e-01,3.14808119e-01],
[3.09399347e-01,3.54873332e-01,3.13803588e-01],
[3.08538635e-01,3.53780564e-01,3.12797552e-01],
[3.07675477e-01,3.52685417e-01,3.11789996e-01],
[3.06809856e-01,3.51587874e-01,3.10780902e-01],
[3.05941752e-01,3.50487919e-01,3.09770254e-01],
[3.05071148e-01,3.49385535e-01,3.08758036e-01],
[3.04198024e-01,3.48280705e-01,3.07744231e-01],
[3.03322363e-01,3.47173411e-01,3.06728822e-01],
[3.02444144e-01,3.46063637e-01,3.05711792e-01],
[3.01563348e-01,3.44951364e-01,3.04693123e-01],
[3.00679957e-01,3.43836574e-01,3.03672797e-01],
[2.99793949e-01,3.42719249e-01,3.02650797e-01],
[2.98905305e-01,3.41599371e-01,3.01627105e-01],
[2.98014005e-01,3.40476921e-01,3.00601702e-01],
[2.97120029e-01,3.39351879e-01,2.99574569e-01],
[2.96223355e-01,3.38224227e-01,2.98545688e-01],
[2.95323962e-01,3.37093946e-01,2.97515040e-01],
[2.94421829e-01,3.35961015e-01,2.96482605e-01],
[2.93516935e-01,3.34825414e-01,2.95448363e-01],
[2.92609257e-01,3.33687123e-01,2.94412295e-01],
[2.91698774e-01,3.32546121e-01,2.93374381e-01],
[2.90785463e-01,3.31402387e-01,2.92334601e-01],
[2.89869302e-01,3.30255901e-01,2.91292932e-01],
[2.88950267e-01,3.29106640e-01,2.90249356e-01],
[2.88028335e-01,3.27954583e-01,2.89203849e-01],
[2.87103483e-01,3.26799707e-01,2.88156392e-01],
[2.86175687e-01,3.25641990e-01,2.87106961e-01],
[2.85244922e-01,3.24481410e-01,2.86055535e-01],
[2.84311164e-01,3.23317942e-01,2.85002091e-01],
[2.83374388e-01,3.22151564e-01,2.83946607e-01],
[2.82434569e-01,3.20982252e-01,2.82889060e-01],
[2.81491681e-01,3.19809980e-01,2.81829425e-01],
[2.80545699e-01,3.18634726e-01,2.80767680e-01],
[2.79596595e-01,3.17456464e-01,2.79703800e-01],
[2.78644344e-01,3.16275168e-01,2.78637760e-01],
[2.77688919e-01,3.15090812e-01,2.77569537e-01],
[2.76730291e-01,3.13903372e-01,2.76499104e-01],
[2.75768434e-01,3.12712819e-01,2.75426436e-01],
[2.74803319e-01,3.11519128e-01,2.74351507e-01],
[2.73834918e-01,3.10322270e-01,2.73274292e-01],
[2.72863200e-01,3.09122218e-01,2.72194762e-01],
[2.71888138e-01,3.07918944e-01,2.71112892e-01],
[2.70909701e-01,3.06712418e-01,2.70028653e-01],
[2.69927859e-01,3.05502613e-01,2.68942017e-01],
[2.68942581e-01,3.04289497e-01,2.67852957e-01],
[2.67953835e-01,3.03073041e-01,2.66761443e-01],
[2.66961591e-01,3.01853215e-01,2.65667446e-01],
[2.65965816e-01,3.00629987e-01,2.64570936e-01],
[2.64966476e-01,2.99403325e-01,2.63471883e-01],
[2.63963540e-01,2.98173198e-01,2.62370257e-01],
[2.62956973e-01,2.96939572e-01,2.61266025e-01],
[2.61946740e-01,2.95702415e-01,2.60159158e-01],
[2.60932808e-01,2.94461692e-01,2.59049621e-01],
[2.59915141e-01,2.93217369e-01,2.57937383e-01],
[2.58893702e-01,2.91969411e-01,2.56822410e-01],
[2.57868456e-01,2.90717782e-01,2.55704668e-01],
[2.56839365e-01,2.89462446e-01,2.54584123e-01],
[2.55806391e-01,2.88203367e-01,2.53460740e-01],
[2.54769496e-01,2.86940506e-01,2.52334484e-01],
[2.53728642e-01,2.85673826e-01,2.51205317e-01],
[2.52683787e-01,2.84403287e-01,2.50073204e-01],
[2.51634892e-01,2.83128849e-01,2.48938107e-01],
[2.50581917e-01,2.81850474e-01,2.47799987e-01],
[2.49524818e-01,2.80568118e-01,2.46658806e-01],
[2.48463554e-01,2.79281741e-01,2.45514525e-01],
[2.47398081e-01,2.77991300e-01,2.44367103e-01],
[2.46328356e-01,2.76696752e-01,2.43216499e-01],
[2.45254333e-01,2.75398051e-01,2.42062672e-01],
[2.44175967e-01,2.74095154e-01,2.40905578e-01],
[2.43093211e-01,2.72788014e-01,2.39745176e-01],
[2.42006018e-01,2.71476584e-01,2.38581421e-01],
[2.40914341e-01,2.70160817e-01,2.37414268e-01],
[2.39818129e-01,2.68840663e-01,2.36243672e-01],
[2.38717332e-01,2.67516073e-01,2.35069585e-01],
[2.37611901e-01,2.66186997e-01,2.33891961e-01],
[2.36501782e-01,2.64853382e-01,2.32710750e-01],
[2.35386923e-01,2.63515176e-01,2.31525905e-01],
[2.34267270e-01,2.62172326e-01,2.30337373e-01],
[2.33142768e-01,2.60824775e-01,2.29145105e-01],
[2.32013361e-01,2.59472469e-01,2.27949047e-01],
[2.30878990e-01,2.58115349e-01,2.26749147e-01],
[2.29739599e-01,2.56753358e-01,2.25545349e-01],
[2.28595127e-01,2.55386436e-01,2.24337599e-01],
[2.27445513e-01,2.54014521e-01,2.23125839e-01],
[2.26290695e-01,2.52637552e-01,2.21910012e-01],
[2.25130610e-01,2.51255464e-01,2.20690057e-01],
[2.23965193e-01,2.49868193e-01,2.19465916e-01],
[2.22794378e-01,2.48475672e-01,2.18237526e-01],
[2.21618097e-01,2.47077833e-01,2.17004823e-01],
[2.20436280e-01,2.45674607e-01,2.15767744e-01],
[2.19248859e-01,2.44265922e-01,2.14526223e-01],
[2.18055759e-01,2.42851706e-01,2.13280192e-01],
[2.16856908e-01,2.41431884e-01,2.12029581e-01],
[2.15652229e-01,2.40006379e-01,2.10774322e-01],
[2.14441646e-01,2.38575115e-01,2.09514341e-01],
[2.13225080e-01,2.37138010e-01,2.08249565e-01],
[2.12002449e-01,2.35694984e-01,2.06979918e-01],
[2.10773672e-01,2.34245952e-01,2.05705324e-01],
[2.09538662e-01,2.32790828e-01,2.04425702e-01],
[2.08297333e-01,2.31329524e-01,2.03140971e-01],
[2.07049597e-01,2.29861951e-01,2.01851049e-01],
[2.05795362e-01,2.28388015e-01,2.00555851e-01],
[2.04534535e-01,2.26907621e-01,1.99255288e-01],
[2.03267019e-01,2.25420673e-01,1.97949272e-01],
[2.01992717e-01,2.23927070e-01,1.96637711e-01],
[2.00711528e-01,2.22426709e-01,1.95320511e-01],
[1.99423349e-01,2.20919486e-01,1.93997575e-01],
[1.98128073e-01,2.19405292e-01,1.92668803e-01],
[1.96825591e-01,2.17884016e-01,1.91334095e-01],
[1.95515792e-01,2.16355543e-01,1.89993345e-01],
[1.94198560e-01,2.14819757e-01,1.88646445e-01],
[1.92873778e-01,2.13276536e-01,1.87293287e-01],
[1.91541323e-01,2.11725757e-01,1.85933755e-01],
[1.90201071e-01,2.10167291e-01,1.84567734e-01],
[1.88852894e-01,2.08601007e-01,1.83195103e-01],
[1.87496659e-01,2.07026770e-01,1.81815738e-01],
[1.86132229e-01,2.05444439e-01,1.80429513e-01],
[1.84759466e-01,2.03853872e-01,1.79036295e-01],
[1.83378224e-01,2.02254919e-01,1.77635951e-01],
[1.81988355e-01,2.00647429e-01,1.76228342e-01],
[1.80589705e-01,1.99031244e-01,1.74813323e-01],
[1.79182115e-01,1.97406200e-01,1.73390746e-01],
[1.77765424e-01,1.95772130e-01,1.71960460e-01],
[1.76339461e-01,1.94128861e-01,1.70522306e-01],
[1.74904053e-01,1.92476212e-01,1.69076122e-01],
[1.73459019e-01,1.90814000e-01,1.67621739e-01],
[1.72004175e-01,1.89142032e-01,1.66158985e-01],
[1.70539327e-01,1.87460110e-01,1.64687678e-01],
[1.69064278e-01,1.85768028e-01,1.63207633e-01],
[1.67578819e-01,1.84065574e-01,1.61718657e-01],
[1.66082739e-01,1.82352529e-01,1.60220551e-01],
[1.64575817e-01,1.80628662e-01,1.58713109e-01],
[1.63057822e-01,1.78893738e-01,1.57196116e-01],
[1.61528518e-01,1.77147510e-01,1.55669349e-01],
[1.59987657e-01,1.75389723e-01,1.54132578e-01],
[1.58434982e-01,1.73620112e-01,1.52585564e-01],
[1.56870229e-01,1.71838400e-01,1.51028057e-01],
[1.55293118e-01,1.70044300e-01,1.49459797e-01],
[1.53703363e-01,1.68237514e-01,1.47880516e-01],
[1.52100662e-01,1.66417729e-01,1.46289933e-01],
[1.50484702e-01,1.64584621e-01,1.44687755e-01],
[1.48855158e-01,1.62737851e-01,1.43073677e-01],
[1.47211688e-01,1.60877066e-01,1.41447380e-01],
[1.45553936e-01,1.59001895e-01,1.39808532e-01],
[1.43881531e-01,1.57111951e-01,1.38156785e-01],
[1.42194084e-01,1.55206831e-01,1.36491775e-01],
[1.40491186e-01,1.53286109e-01,1.34813122e-01],
[1.38772410e-01,1.51349342e-01,1.33120425e-01],
[1.37037310e-01,1.49396062e-01,1.31413266e-01],
[1.35285412e-01,1.47425779e-01,1.29691205e-01],
[1.33516224e-01,1.45437977e-01,1.27953779e-01],
[1.31729224e-01,1.43432114e-01,1.26200502e-01],
[1.29923864e-01,1.41407618e-01,1.24430860e-01],
[1.28099565e-01,1.39363883e-01,1.22644313e-01],
[1.26255715e-01,1.37300272e-01,1.20840289e-01],
[1.24391669e-01,1.35216111e-01,1.19018184e-01],
[1.22506742e-01,1.33110683e-01,1.17177358e-01],
[1.20600209e-01,1.30983231e-01,1.15317133e-01],
[1.18671299e-01,1.28832949e-01,1.13436787e-01],
[1.16719191e-01,1.26658978e-01,1.11535555e-01],
[1.14743014e-01,1.24460404e-01,1.09612619e-01],
[1.12741834e-01,1.22236252e-01,1.07667109e-01],
[1.10714655e-01,1.19985478e-01,1.05698091e-01],
[1.08660409e-01,1.17706962e-01,1.03704567e-01],
[1.06577950e-01,1.15399503e-01,1.01685465e-01],
[1.04466045e-01,1.13061808e-01,9.96396317e-02],
[1.02323364e-01,1.10692480e-01,9.75658227e-02],
[1.00148470e-01,1.08290011e-01,9.54626932e-02],
[9.79398024e-02,1.05852765e-01,9.33287849e-02],
[9.56956688e-02,1.03378961e-01,9.11625128e-02],
[9.34142217e-02,1.00866658e-01,8.89621483e-02],
[9.10934403e-02,9.83137313e-02,8.67258003e-02],
[8.87311063e-02,9.57178477e-02,8.44513926e-02],
[8.63247748e-02,9.30764344e-02,8.21366367e-02],
[8.38717402e-02,9.03866430e-02,7.97789998e-02],
[8.13689949e-02,8.76453057e-02,7.73756659e-02],
[7.88131783e-02,8.48488818e-02,7.49234884e-02],
[7.62005155e-02,8.19933921e-02,7.24189321e-02],
[7.35267402e-02,7.90743375e-02,6.98580009e-02],
[7.07869984e-02,7.60865967e-02,6.72361479e-02],
[6.79757258e-02,7.30242966e-02,6.45481597e-02],
[6.50864900e-02,6.98806448e-02,6.17880087e-02],
[6.21117839e-02,6.66477105e-02,5.89486591e-02],
[5.90427503e-02,6.33161319e-02,5.60218081e-02],
[5.58688068e-02,5.98747187e-02,5.29975336e-02],
[5.25771234e-02,5.63098972e-02,4.98638036e-02],
[4.91518730e-02,5.26049147e-02,4.66057723e-02],
[4.55731213e-02,4.87386607e-02,4.32047369e-02],
[4.18151132e-02,4.46838459e-02,3.96365273e-02],
[3.78434942e-02,4.04040499e-02,3.58688942e-02],
[3.36105079e-02,3.58486162e-02,3.18569948e-02],
[2.90459749e-02,3.09430604e-02,2.75349106e-02],
[2.40382585e-02,2.55688241e-02,2.27977465e-02],
[1.83864288e-02,1.95123767e-02,1.74566338e-02],
[1.16369737e-02,1.22914023e-02,1.10850923e-02],
[1.23926834e-04,0.00000000e+00,2.31730955e-04],
[1.16521906e-02,1.22835548e-02,1.10855544e-02],
[1.84298156e-02,1.94900219e-02,1.74578487e-02],
[2.41176259e-02,2.55279670e-02,2.27997813e-02],
[2.91673925e-02,3.08806124e-02,2.75377371e-02],
[3.37790723e-02,3.57619970e-02,3.18605219e-02],
[3.80636625e-02,4.02910142e-02,3.58729832e-02],
[4.20908831e-02,4.45423904e-02,3.96410013e-02],
[4.59081412e-02,4.85669663e-02,4.32093865e-02],
[4.95495151e-02,5.24013088e-02,4.66103599e-02],
[5.30405345e-02,5.60728268e-02,4.98680664e-02],
[5.64009459e-02,5.96027310e-02,5.30011861e-02],
[5.96464169e-02,6.30078596e-02,5.60245442e-02],
[6.27896399e-02,6.63018601e-02,5.89501534e-02],
[6.58410776e-02,6.94959873e-02,6.17879178e-02],
[6.88094813e-02,7.25996603e-02,6.45461236e-02],
[7.17022639e-02,7.56208608e-02,6.72317909e-02],
[7.45257735e-02,7.85664273e-02,6.98509324e-02],
[7.72854982e-02,8.14422746e-02,7.24087471e-02],
[7.99862228e-02,8.42535616e-02,7.49097687e-02],
[8.26321504e-02,8.70048223e-02,7.73579802e-02],
[8.52269980e-02,8.97000679e-02,7.97569044e-02],
[8.77740726e-02,9.23428687e-02,8.21096759e-02],
[9.02763325e-02,9.49364198e-02,8.44190994e-02],
[9.27364373e-02,9.74835953e-02,8.66876966e-02],
[9.51567891e-02,9.99869916e-02,8.89177452e-02],
[9.75395664e-02,1.02448965e-01,9.11113111e-02],
[9.98867524e-02,1.04871660e-01,9.32702753e-02],
[1.02200159e-01,1.07257040e-01,9.53963566e-02],
[1.04481447e-01,1.09606901e-01,9.74911307e-02],
[1.06732144e-01,1.11922899e-01,9.95560464e-02],
[1.08953659e-01,1.14206560e-01,1.01592440e-01],
[1.11147292e-01,1.16459294e-01,1.03601546e-01],
[1.13314250e-01,1.18682411e-01,1.05584510e-01],
[1.15455655e-01,1.20877128e-01,1.07542396e-01],
[1.17572549e-01,1.23044575e-01,1.09476194e-01],
[1.19665908e-01,1.25185812e-01,1.11386828e-01],
[1.21736640e-01,1.27301827e-01,1.13275163e-01],
[1.23785598e-01,1.29393546e-01,1.15142006e-01],
[1.25813582e-01,1.31461838e-01,1.16988118e-01],
[1.27821343e-01,1.33507522e-01,1.18814212e-01],
[1.29809588e-01,1.35531365e-01,1.20620958e-01],
[1.31778983e-01,1.37534095e-01,1.22408990e-01],
[1.33730159e-01,1.39516395e-01,1.24178905e-01],
[1.35663708e-01,1.41478915e-01,1.25931268e-01],
[1.37580195e-01,1.43422267e-01,1.27666612e-01],
[1.39480152e-01,1.45347033e-01,1.29385445e-01],
[1.41364084e-01,1.47253764e-01,1.31088246e-01],
[1.43232473e-01,1.49142985e-01,1.32775471e-01],
[1.45085776e-01,1.51015195e-01,1.34447555e-01],
[1.46924425e-01,1.52870868e-01,1.36104911e-01],
[1.48748837e-01,1.54710457e-01,1.37747930e-01],
[1.50559405e-01,1.56534394e-01,1.39376989e-01],
[1.52356507e-01,1.58343091e-01,1.40992446e-01],
[1.54140502e-01,1.60136942e-01,1.42594642e-01],
[1.55911734e-01,1.61916323e-01,1.44183904e-01],
[1.57670534e-01,1.63681596e-01,1.45760545e-01],
[1.59417215e-01,1.65433107e-01,1.47324865e-01],
[1.61152082e-01,1.67171185e-01,1.48877150e-01],
[1.62875422e-01,1.68896150e-01,1.50417677e-01],
[1.64587515e-01,1.70608307e-01,1.51946709e-01],
[1.66288628e-01,1.72307949e-01,1.53464501e-01],
[1.67979017e-01,1.73995357e-01,1.54971295e-01],
[1.69658930e-01,1.75670805e-01,1.56467327e-01],
[1.71328603e-01,1.77334552e-01,1.57952822e-01],
[1.72988265e-01,1.78986849e-01,1.59427998e-01],
[1.74638137e-01,1.80627941e-01,1.60893064e-01],
[1.76278432e-01,1.82258060e-01,1.62348222e-01],
[1.77909353e-01,1.83877432e-01,1.63793666e-01],
[1.79531098e-01,1.85486276e-01,1.65229584e-01],
[1.81143858e-01,1.87084800e-01,1.66656158e-01],
[1.82747818e-01,1.88673209e-01,1.68073562e-01],
[1.84343156e-01,1.90251700e-01,1.69481966e-01],
[1.85930042e-01,1.91820462e-01,1.70881533e-01],
[1.87508645e-01,1.93379679e-01,1.72272421e-01],
[1.89079124e-01,1.94929531e-01,1.73654785e-01],
[1.90641637e-01,1.96470188e-01,1.75028771e-01],
[1.92196333e-01,1.98001819e-01,1.76394524e-01],
[1.93743360e-01,1.99524585e-01,1.77752183e-01],
[1.95282859e-01,2.01038644e-01,1.79101882e-01],
[1.96814968e-01,2.02544149e-01,1.80443753e-01],
[1.98339819e-01,2.04041247e-01,1.81777922e-01],
[1.99857543e-01,2.05530082e-01,1.83104513e-01],
[2.01368265e-01,2.07010794e-01,1.84423644e-01],
[2.02872107e-01,2.08483518e-01,1.85735432e-01],
[2.04369187e-01,2.09948387e-01,1.87039990e-01],
[2.05859621e-01,2.11405528e-01,1.88337427e-01],
[2.07343521e-01,2.12855067e-01,1.89627850e-01],
[2.08820995e-01,2.14297124e-01,1.90911363e-01],
[2.10292150e-01,2.15731817e-01,1.92188065e-01],
[2.11757087e-01,2.17159263e-01,1.93458056e-01],
[2.13215908e-01,2.18579572e-01,1.94721431e-01],
[2.14668710e-01,2.19992853e-01,1.95978281e-01],
[2.16115588e-01,2.21399213e-01,1.97228699e-01],
[2.17556634e-01,2.22798756e-01,1.98472772e-01],
[2.18991938e-01,2.24191582e-01,1.99710586e-01],
[2.20421590e-01,2.25577790e-01,2.00942225e-01],
[2.21845673e-01,2.26957476e-01,2.02167770e-01],
[2.23264271e-01,2.28330734e-01,2.03387302e-01],
[2.24677467e-01,2.29697655e-01,2.04600896e-01],
[2.26085339e-01,2.31058329e-01,2.05808630e-01],
[2.27487965e-01,2.32412842e-01,2.07010577e-01],
[2.28885420e-01,2.33761280e-01,2.08206810e-01],
[2.30277779e-01,2.35103726e-01,2.09397399e-01],
[2.31665113e-01,2.36440262e-01,2.10582412e-01],
[2.33047492e-01,2.37770966e-01,2.11761917e-01],
[2.34424986e-01,2.39095917e-01,2.12935980e-01],
[2.35797662e-01,2.40415191e-01,2.14104664e-01],
[2.37165586e-01,2.41728861e-01,2.15268033e-01],
[2.38528821e-01,2.43037002e-01,2.16426148e-01],
[2.39887430e-01,2.44339683e-01,2.17579069e-01],
[2.41241475e-01,2.45636974e-01,2.18726854e-01],
[2.42591015e-01,2.46928943e-01,2.19869561e-01],
[2.43936110e-01,2.48215658e-01,2.21007246e-01],
[2.45276816e-01,2.49497183e-01,2.22139964e-01],
[2.46613191e-01,2.50773583e-01,2.23267769e-01],
[2.47945288e-01,2.52044919e-01,2.24390713e-01],
[2.49273162e-01,2.53311255e-01,2.25508849e-01],
[2.50596865e-01,2.54572648e-01,2.26622226e-01],
[2.51916449e-01,2.55829160e-01,2.27730893e-01],
[2.53231965e-01,2.57080847e-01,2.28834901e-01],
[2.54543461e-01,2.58327766e-01,2.29934295e-01],
[2.55850987e-01,2.59569972e-01,2.31029123e-01],
[2.57154590e-01,2.60807521e-01,2.32119429e-01],
[2.58454316e-01,2.62040465e-01,2.33205260e-01],
[2.59750212e-01,2.63268858e-01,2.34286658e-01],
[2.61042321e-01,2.64492750e-01,2.35363667e-01],
[2.62330688e-01,2.65712192e-01,2.36436329e-01],
[2.63615356e-01,2.66927234e-01,2.37504686e-01],
[2.64896366e-01,2.68137924e-01,2.38568777e-01],
[2.66173761e-01,2.69344310e-01,2.39628643e-01],
[2.67447580e-01,2.70546439e-01,2.40684322e-01],
[2.68717864e-01,2.71744358e-01,2.41735854e-01],
[2.69984651e-01,2.72938111e-01,2.42783276e-01],
[2.71247980e-01,2.74127743e-01,2.43826625e-01],
[2.72507889e-01,2.75313298e-01,2.44865936e-01],
[2.73764413e-01,2.76494818e-01,2.45901247e-01],
[2.75017591e-01,2.77672346e-01,2.46932592e-01],
[2.76267457e-01,2.78845923e-01,2.47960005e-01],
[2.77514045e-01,2.80015591e-01,2.48983520e-01],
[2.78757391e-01,2.81181388e-01,2.50003171e-01],
[2.79997528e-01,2.82343356e-01,2.51018989e-01],
[2.81234489e-01,2.83501531e-01,2.52031008e-01],
[2.82468307e-01,2.84655954e-01,2.53039259e-01],
[2.83699014e-01,2.85806660e-01,2.54043772e-01],
[2.84926640e-01,2.86953687e-01,2.55044579e-01],
[2.86151217e-01,2.88097072e-01,2.56041709e-01],
[2.87372775e-01,2.89236850e-01,2.57035192e-01],
[2.88591344e-01,2.90373056e-01,2.58025056e-01],
[2.89806953e-01,2.91505724e-01,2.59011331e-01],
[2.91019630e-01,2.92634890e-01,2.59994045e-01],
[2.92229405e-01,2.93760586e-01,2.60973224e-01],
[2.93436305e-01,2.94882846e-01,2.61948897e-01],
[2.94640357e-01,2.96001702e-01,2.62921090e-01],
[2.95841589e-01,2.97117186e-01,2.63889829e-01],
[2.97040026e-01,2.98229329e-01,2.64855140e-01],
[2.98235694e-01,2.99338163e-01,2.65817050e-01],
[2.99428620e-01,3.00443719e-01,2.66775582e-01],
[3.00618828e-01,3.01546026e-01,2.67730762e-01],
[3.01806344e-01,3.02645114e-01,2.68682614e-01],
[3.02991191e-01,3.03741013e-01,2.69631162e-01],
[3.04173394e-01,3.04833751e-01,2.70576430e-01],
[3.05352975e-01,3.05923357e-01,2.71518441e-01],
[3.06529960e-01,3.07009858e-01,2.72457218e-01],
[3.07704369e-01,3.08093283e-01,2.73392784e-01],
[3.08876226e-01,3.09173659e-01,2.74325160e-01],
[3.10045553e-01,3.10251013e-01,2.75254369e-01],
[3.11212372e-01,3.11325370e-01,2.76180433e-01],
[3.12376704e-01,3.12396758e-01,2.77103372e-01],
[3.13538570e-01,3.13465201e-01,2.78023208e-01],
[3.14697991e-01,3.14530726e-01,2.78939962e-01],
[3.15854988e-01,3.15593357e-01,2.79853653e-01],
[3.17009581e-01,3.16653120e-01,2.80764303e-01],
[3.18161790e-01,3.17710038e-01,2.81671930e-01],
[3.19311633e-01,3.18764136e-01,2.82576555e-01],
[3.20459132e-01,3.19815437e-01,2.83478197e-01],
[3.21604304e-01,3.20863964e-01,2.84376875e-01],
[3.22747168e-01,3.21909742e-01,2.85272608e-01],
[3.23887743e-01,3.22952793e-01,2.86165413e-01],
[3.25026047e-01,3.23993139e-01,2.87055311e-01],
[3.26162097e-01,3.25030802e-01,2.87942318e-01],
[3.27295912e-01,3.26065805e-01,2.88826452e-01],
[3.28427509e-01,3.27098169e-01,2.89707732e-01],
[3.29556905e-01,3.28127915e-01,2.90586173e-01],
[3.30684117e-01,3.29155066e-01,2.91461794e-01],
[3.31809162e-01,3.30179640e-01,2.92334612e-01],
[3.32932055e-01,3.31201660e-01,2.93204643e-01],
[3.34052813e-01,3.32221146e-01,2.94071903e-01],
[3.35171453e-01,3.33238117e-01,2.94936409e-01],
[3.36287989e-01,3.34252594e-01,2.95798177e-01],
[3.37402438e-01,3.35264596e-01,2.96657222e-01],
[3.38514814e-01,3.36274143e-01,2.97513561e-01],
[3.39625132e-01,3.37281253e-01,2.98367209e-01],
[3.40733408e-01,3.38285946e-01,2.99218181e-01],
[3.41839657e-01,3.39288240e-01,3.00066493e-01],
[3.42943892e-01,3.40288154e-01,3.00912158e-01],
[3.44046127e-01,3.41285705e-01,3.01755192e-01],
[3.45146378e-01,3.42280913e-01,3.02595610e-01],
[3.46244657e-01,3.43273795e-01,3.03433425e-01],
[3.47340978e-01,3.44264369e-01,3.04268653e-01],
[3.48435356e-01,3.45252652e-01,3.05101306e-01],
[3.49527802e-01,3.46238660e-01,3.05931400e-01],
[3.50618331e-01,3.47222413e-01,3.06758947e-01],
[3.51706955e-01,3.48203925e-01,3.07583961e-01],
[3.52793688e-01,3.49183214e-01,3.08406456e-01],
[3.53878540e-01,3.50160296e-01,3.09226445e-01],
[3.54961526e-01,3.51135188e-01,3.10043941e-01],
[3.56042657e-01,3.52107905e-01,3.10858956e-01],
[3.57121945e-01,3.53078464e-01,3.11671505e-01],
[3.58199403e-01,3.54046881e-01,3.12481598e-01],
[3.59275042e-01,3.55013170e-01,3.13289250e-01],
[3.60348873e-01,3.55977348e-01,3.14094471e-01],
[3.61420909e-01,3.56939429e-01,3.14897275e-01],
[3.62491160e-01,3.57899429e-01,3.15697674e-01],
[3.63559638e-01,3.58857363e-01,3.16495680e-01],
[3.64626354e-01,3.59813244e-01,3.17291303e-01],
[3.65691318e-01,3.60767089e-01,3.18084557e-01],
[3.66754541e-01,3.61718912e-01,3.18875453e-01],
[3.67816035e-01,3.62668726e-01,3.19664002e-01],
[3.68875809e-01,3.63616546e-01,3.20450215e-01],
[3.69933874e-01,3.64562386e-01,3.21234104e-01],
[3.70990239e-01,3.65506260e-01,3.22015680e-01],
[3.72044916e-01,3.66448182e-01,3.22794954e-01],
[3.73097914e-01,3.67388164e-01,3.23571937e-01],
[3.74149242e-01,3.68326222e-01,3.24346640e-01],
[3.75198911e-01,3.69262367e-01,3.25119072e-01],
[3.76246930e-01,3.70196613e-01,3.25889246e-01],
[3.77293308e-01,3.71128973e-01,3.26657170e-01],
[3.78338055e-01,3.72059461e-01,3.27422857e-01],
[3.79381181e-01,3.72988088e-01,3.28186315e-01],
[3.80422693e-01,3.73914868e-01,3.28947555e-01],
[3.81462601e-01,3.74839813e-01,3.29706587e-01],
[3.82500915e-01,3.75762936e-01,3.30463422e-01],
[3.83537642e-01,3.76684248e-01,3.31218068e-01],
[3.84572791e-01,3.77603763e-01,3.31970535e-01],
[3.85606372e-01,3.78521491e-01,3.32720834e-01],
[3.86638391e-01,3.79437446e-01,3.33468974e-01],
[3.87668859e-01,3.80351639e-01,3.34214964e-01],
[3.88697782e-01,3.81264081e-01,3.34958814e-01],
[3.89725169e-01,3.82174784e-01,3.35700533e-01],
[3.90751028e-01,3.83083760e-01,3.36440130e-01],
[3.91775367e-01,3.83991021e-01,3.37177614e-01],
[3.92798194e-01,3.84896576e-01,3.37912995e-01],
[3.93819516e-01,3.85800439e-01,3.38646281e-01],
[3.94839342e-01,3.86702619e-01,3.39377481e-01],
[3.95857678e-01,3.87603128e-01,3.40106605e-01],
[3.96874532e-01,3.88501977e-01,3.40833660e-01],
[3.97889912e-01,3.89399176e-01,3.41558655e-01],
[3.98903824e-01,3.90294736e-01,3.42281600e-01],
[3.99916276e-01,3.91188668e-01,3.43002502e-01],
[4.00927276e-01,3.92080982e-01,3.43721370e-01],
[4.01936829e-01,3.92971689e-01,3.44438212e-01],
[4.02944943e-01,3.93860799e-01,3.45153036e-01],
[4.03951625e-01,3.94748322e-01,3.45865852e-01],
[4.04956881e-01,3.95634268e-01,3.46576666e-01],
[4.05960719e-01,3.96518648e-01,3.47285487e-01],
[4.06963144e-01,3.97401471e-01,3.47992323e-01],
[4.07964164e-01,3.98282748e-01,3.48697181e-01],
[4.08963784e-01,3.99162487e-01,3.49400071e-01],
[4.09962011e-01,4.00040699e-01,3.50100998e-01],
[4.10958852e-01,4.00917394e-01,3.50799972e-01],
[4.11954312e-01,4.01792580e-01,3.51497000e-01],
[4.12948398e-01,4.02666268e-01,3.52192090e-01],
[4.13941116e-01,4.03538467e-01,3.52885248e-01],
[4.14932471e-01,4.04409186e-01,3.53576483e-01],
[4.15922470e-01,4.05278434e-01,3.54265802e-01],
[4.16911118e-01,4.06146220e-01,3.54953212e-01],
[4.17898422e-01,4.07012554e-01,3.55638720e-01],
[4.18884386e-01,4.07877445e-01,3.56322334e-01],
[4.19869017e-01,4.08740901e-01,3.57004062e-01],
[4.20852320e-01,4.09602931e-01,3.57683909e-01],
[4.21834301e-01,4.10463545e-01,3.58361884e-01],
[4.22814965e-01,4.11322750e-01,3.59037993e-01],
[4.23794317e-01,4.12180556e-01,3.59712243e-01],
[4.24772363e-01,4.13036971e-01,3.60384642e-01],
[4.25749108e-01,4.13892003e-01,3.61055195e-01],
[4.26724557e-01,4.14745662e-01,3.61723910e-01],
[4.27698715e-01,4.15597954e-01,3.62390794e-01],
[4.28671587e-01,4.16448890e-01,3.63055853e-01],
[4.29643179e-01,4.17298476e-01,3.63719094e-01],
[4.30613495e-01,4.18146722e-01,3.64380523e-01],
[4.31582540e-01,4.18993634e-01,3.65040148e-01],
[4.32550318e-01,4.19839222e-01,3.65697974e-01],
[4.33516836e-01,4.20683493e-01,3.66354009e-01],
[4.34482097e-01,4.21526455e-01,3.67008258e-01],
[4.35446106e-01,4.22368117e-01,3.67660728e-01],
[4.36408867e-01,4.23208485e-01,3.68311425e-01],
[4.37370386e-01,4.24047567e-01,3.68960356e-01],
[4.38330666e-01,4.24885372e-01,3.69607526e-01],
[4.39289713e-01,4.25721907e-01,3.70252943e-01],
[4.40247530e-01,4.26557179e-01,3.70896612e-01],
[4.41204121e-01,4.27391196e-01,3.71538539e-01],
[4.42159492e-01,4.28223966e-01,3.72178730e-01],
[4.43113645e-01,4.29055495e-01,3.72817192e-01],
[4.44066587e-01,4.29885792e-01,3.73453930e-01],
[4.45018320e-01,4.30714863e-01,3.74088951e-01],
[4.45968848e-01,4.31542716e-01,3.74722260e-01],
[4.46918176e-01,4.32369358e-01,3.75353864e-01],
[4.47866308e-01,4.33194796e-01,3.75983767e-01],
[4.48813247e-01,4.34019037e-01,3.76611976e-01],
[4.49758997e-01,4.34842088e-01,3.77238497e-01],
[4.50703563e-01,4.35663956e-01,3.77863335e-01],
[4.51646948e-01,4.36484649e-01,3.78486496e-01],
[4.52589156e-01,4.37304172e-01,3.79107986e-01],
[4.53530190e-01,4.38122534e-01,3.79727810e-01],
[4.54470054e-01,4.38939739e-01,3.80345974e-01],
[4.55408753e-01,4.39755797e-01,3.80962483e-01],
[4.56346288e-01,4.40570712e-01,3.81577344e-01],
[4.57282664e-01,4.41384492e-01,3.82190561e-01],
[4.58217885e-01,4.42197143e-01,3.82802139e-01],
[4.59151953e-01,4.43008672e-01,3.83412086e-01],
[4.60084873e-01,4.43819086e-01,3.84020404e-01],
[4.61016646e-01,4.44628390e-01,3.84627101e-01],
[4.61947278e-01,4.45436591e-01,3.85232182e-01],
[4.62876771e-01,4.46243696e-01,3.85835651e-01],
[4.63805128e-01,4.47049711e-01,3.86437514e-01],
[4.64732353e-01,4.47854643e-01,3.87037776e-01],
[4.65658449e-01,4.48658496e-01,3.87636443e-01],
[4.66583418e-01,4.49461279e-01,3.88233519e-01],
[4.67507264e-01,4.50262996e-01,3.88829010e-01],
[4.68429990e-01,4.51063655e-01,3.89422921e-01],
[4.69351599e-01,4.51863260e-01,3.90015256e-01],
[4.70272094e-01,4.52661818e-01,3.90606022e-01],
[4.71191478e-01,4.53459336e-01,3.91195223e-01],
[4.72109753e-01,4.54255818e-01,3.91782863e-01],
[4.73026923e-01,4.55051272e-01,3.92368949e-01],
[4.73942990e-01,4.55845703e-01,3.92953484e-01],
[4.74857958e-01,4.56639116e-01,3.93536475e-01],
[4.75771829e-01,4.57431517e-01,3.94117925e-01],
[4.76684605e-01,4.58222914e-01,3.94697840e-01],
[4.77596289e-01,4.59013310e-01,3.95276224e-01],
[4.78506885e-01,4.59802711e-01,3.95853083e-01],
[4.79416394e-01,4.60591125e-01,3.96428420e-01],
[4.80324820e-01,4.61378555e-01,3.97002242e-01],
[4.81232164e-01,4.62165008e-01,3.97574552e-01],
[4.82138430e-01,4.62950489e-01,3.98145355e-01],
[4.83043619e-01,4.63735003e-01,3.98714657e-01],
[4.83947734e-01,4.64518557e-01,3.99282461e-01],
[4.84850779e-01,4.65301156e-01,3.99848772e-01],
[4.85752754e-01,4.66082804e-01,4.00413596e-01],
[4.86653663e-01,4.66863508e-01,4.00976936e-01],
[4.87553507e-01,4.67643273e-01,4.01538797e-01],
[4.88452290e-01,4.68422104e-01,4.02099184e-01],
[4.89350013e-01,4.69200006e-01,4.02658101e-01],
[4.90246679e-01,4.69976984e-01,4.03215553e-01],
[4.91142289e-01,4.70753045e-01,4.03771544e-01],
[4.92036847e-01,4.71528193e-01,4.04326079e-01],
[4.92930353e-01,4.72302432e-01,4.04879162e-01],
[4.93822811e-01,4.73075770e-01,4.05430798e-01],
[4.94714223e-01,4.73848209e-01,4.05980991e-01],
[4.95604589e-01,4.74619756e-01,4.06529746e-01],
[4.96493914e-01,4.75390415e-01,4.07077066e-01],
[4.97382198e-01,4.76160192e-01,4.07622956e-01],
[4.98269443e-01,4.76929092e-01,4.08167421e-01],
[4.99155653e-01,4.77697119e-01,4.08710465e-01],
[5.00040827e-01,4.78464278e-01,4.09252092e-01],
[5.00924969e-01,4.79230574e-01,4.09792306e-01],
[5.01808080e-01,4.79996012e-01,4.10331112e-01],
[5.02690163e-01,4.80760598e-01,4.10868514e-01],
[5.03571218e-01,4.81524335e-01,4.11404516e-01],
[5.04451249e-01,4.82287228e-01,4.11939123e-01],
[5.05330256e-01,4.83049283e-01,4.12472338e-01],
[5.06208241e-01,4.83810504e-01,4.13004166e-01],
[5.07085206e-01,4.84570895e-01,4.13534610e-01],
[5.07961154e-01,4.85330461e-01,4.14063676e-01],
[5.08836084e-01,4.86089208e-01,4.14591367e-01],
[5.09710000e-01,4.86847139e-01,4.15117687e-01],
[5.10582903e-01,4.87604259e-01,4.15642640e-01],
[5.11454795e-01,4.88360573e-01,4.16166231e-01],
[5.12325676e-01,4.89116085e-01,4.16688463e-01],
[5.13195549e-01,4.89870799e-01,4.17209341e-01],
[5.14064416e-01,4.90624721e-01,4.17728868e-01],
[5.14932277e-01,4.91377855e-01,4.18247049e-01],
[5.15799134e-01,4.92130204e-01,4.18763887e-01],
[5.16664990e-01,4.92881774e-01,4.19279387e-01],
[5.17529844e-01,4.93632569e-01,4.19793552e-01],
[5.18393699e-01,4.94382593e-01,4.20306387e-01],
[5.19256557e-01,4.95131851e-01,4.20817895e-01],
[5.20118418e-01,4.95880347e-01,4.21328080e-01],
[5.20979284e-01,4.96628085e-01,4.21836947e-01],
[5.21839156e-01,4.97375069e-01,4.22344499e-01],
[5.22698035e-01,4.98121304e-01,4.22850739e-01],
[5.23555924e-01,4.98866793e-01,4.23355673e-01],
[5.24412823e-01,4.99611542e-01,4.23859303e-01],
[5.25268734e-01,5.00355554e-01,4.24361633e-01],
[5.26123657e-01,5.01098833e-01,4.24862668e-01],
[5.26977595e-01,5.01841384e-01,4.25362411e-01],
[5.27830547e-01,5.02583211e-01,4.25860866e-01],
[5.28682517e-01,5.03324317e-01,4.26358037e-01],
[5.29533504e-01,5.04064707e-01,4.26853927e-01],
[5.30383510e-01,5.04804385e-01,4.27348540e-01],
[5.31232536e-01,5.05543354e-01,4.27841881e-01],
[5.32080583e-01,5.06281620e-01,4.28333952e-01],
[5.32927652e-01,5.07019185e-01,4.28824757e-01],
[5.33773745e-01,5.07756054e-01,4.29314301e-01],
[5.34618863e-01,5.08492230e-01,4.29802587e-01],
[5.35463005e-01,5.09227719e-01,4.30289618e-01],
[5.36306175e-01,5.09962522e-01,4.30775398e-01],
[5.37148372e-01,5.10696645e-01,4.31259932e-01],
[5.37989598e-01,5.11430091e-01,4.31743222e-01],
[5.38829853e-01,5.12162865e-01,4.32225272e-01],
[5.39669139e-01,5.12894969e-01,4.32706085e-01],
[5.40507456e-01,5.13626408e-01,4.33185667e-01],
[5.41344806e-01,5.14357185e-01,4.33664019e-01],
[5.42181190e-01,5.15087304e-01,4.34141146e-01],
[5.43016608e-01,5.15816769e-01,4.34617051e-01],
[5.43851061e-01,5.16545584e-01,4.35091738e-01],
[5.44684550e-01,5.17273752e-01,4.35565211e-01],
[5.45517076e-01,5.18001277e-01,4.36037472e-01],
[5.46348641e-01,5.18728163e-01,4.36508526e-01],
[5.47179243e-01,5.19454413e-01,4.36978375e-01],
[5.48008886e-01,5.20180031e-01,4.37447025e-01],
[5.48837568e-01,5.20905021e-01,4.37914477e-01],
[5.49665292e-01,5.21629386e-01,4.38380736e-01],
[5.50492058e-01,5.22353129e-01,4.38845805e-01],
[5.51317866e-01,5.23076254e-01,4.39309687e-01],
[5.52142718e-01,5.23798766e-01,4.39772387e-01],
[5.52966614e-01,5.24520666e-01,4.40233907e-01],
[5.53789555e-01,5.25241960e-01,4.40694251e-01],
[5.54611541e-01,5.25962649e-01,4.41153422e-01],
[5.55432574e-01,5.26682739e-01,4.41611424e-01],
[5.56252653e-01,5.27402231e-01,4.42068261e-01],
[5.57071780e-01,5.28121130e-01,4.42523935e-01],
[5.57889955e-01,5.28839440e-01,4.42978450e-01],
[5.58707180e-01,5.29557162e-01,4.43431809e-01],
[5.59523453e-01,5.30274301e-01,4.43884017e-01],
[5.60338777e-01,5.30990861e-01,4.44335076e-01],
[5.61153152e-01,5.31706844e-01,4.44784989e-01],
[5.61966577e-01,5.32422254e-01,4.45233761e-01],
[5.62779055e-01,5.33137094e-01,4.45681394e-01],
[5.63590585e-01,5.33851367e-01,4.46127892e-01],
[5.64401168e-01,5.34565077e-01,4.46573258e-01],
[5.65210804e-01,5.35278228e-01,4.47017495e-01],
[5.66019495e-01,5.35990821e-01,4.47460607e-01],
[5.66827240e-01,5.36702861e-01,4.47902597e-01],
[5.67634040e-01,5.37414351e-01,4.48343469e-01],
[5.68439895e-01,5.38125293e-01,4.48783225e-01],
[5.69244807e-01,5.38835692e-01,4.49221870e-01],
[5.70048775e-01,5.39545550e-01,4.49659405e-01],
[5.70851800e-01,5.40254870e-01,4.50095836e-01],
[5.71653882e-01,5.40963656e-01,4.50531164e-01],
[5.72455022e-01,5.41671911e-01,4.50965393e-01],
[5.73255220e-01,5.42379637e-01,4.51398527e-01],
[5.74054476e-01,5.43086839e-01,4.51830569e-01],
[5.74852792e-01,5.43793518e-01,4.52261521e-01],
[5.75650167e-01,5.44499679e-01,4.52691388e-01],
[5.76446601e-01,5.45205323e-01,4.53120172e-01],
[5.77242096e-01,5.45910455e-01,4.53547877e-01],
[5.78036651e-01,5.46615077e-01,4.53974505e-01],
[5.78830267e-01,5.47319193e-01,4.54400061e-01],
[5.79622943e-01,5.48022805e-01,4.54824547e-01],
[5.80414682e-01,5.48725915e-01,4.55247966e-01],
[5.81205482e-01,5.49428529e-01,4.55670323e-01],
[5.81995344e-01,5.50130647e-01,4.56091619e-01],
[5.82784268e-01,5.50832273e-01,4.56511858e-01],
[5.83572255e-01,5.51533411e-01,4.56931044e-01],
[5.84359305e-01,5.52234062e-01,4.57349179e-01],
[5.85145417e-01,5.52934231e-01,4.57766266e-01],
[5.85930593e-01,5.53633919e-01,4.58182310e-01],
[5.86714833e-01,5.54333129e-01,4.58597312e-01],
[5.87498137e-01,5.55031866e-01,4.59011276e-01],
[5.88280504e-01,5.55730131e-01,4.59424206e-01],
[5.89061936e-01,5.56427926e-01,4.59836104e-01],
[5.89842432e-01,5.57125256e-01,4.60246973e-01],
[5.90621993e-01,5.57822123e-01,4.60656817e-01],
[5.91400618e-01,5.58518530e-01,4.61065639e-01],
[5.92178309e-01,5.59214479e-01,4.61473442e-01],
[5.92955065e-01,5.59909973e-01,4.61880228e-01],
[5.93730886e-01,5.60605015e-01,4.62286002e-01],
[5.94505772e-01,5.61299608e-01,4.62690766e-01],
[5.95279725e-01,5.61993755e-01,4.63094523e-01],
[5.96052742e-01,5.62687458e-01,4.63497277e-01],
[5.96824826e-01,5.63380719e-01,4.63899030e-01],
[5.97595976e-01,5.64073543e-01,4.64299785e-01],
[5.98366191e-01,5.64765930e-01,4.64699546e-01],
[5.99135473e-01,5.65457885e-01,4.65098316e-01],
[5.99903821e-01,5.66149410e-01,4.65496097e-01],
[6.00671236e-01,5.66840506e-01,4.65892894e-01],
[6.01437717e-01,5.67531178e-01,4.66288708e-01],
[6.02203264e-01,5.68221428e-01,4.66683543e-01],
[6.02967878e-01,5.68911258e-01,4.67077401e-01],
[6.03731558e-01,5.69600670e-01,4.67470287e-01],
[6.04494305e-01,5.70289668e-01,4.67862203e-01],
[6.05256119e-01,5.70978254e-01,4.68253152e-01],
[6.06016999e-01,5.71666431e-01,4.68643137e-01],
[6.06776947e-01,5.72354201e-01,4.69032161e-01],
[6.07535960e-01,5.73041567e-01,4.69420227e-01],
[6.08294041e-01,5.73728531e-01,4.69807339e-01],
[6.09051188e-01,5.74415096e-01,4.70193498e-01],
[6.09807402e-01,5.75101264e-01,4.70578709e-01],
[6.10562683e-01,5.75787038e-01,4.70962973e-01],
[6.11317030e-01,5.76472421e-01,4.71346295e-01],
[6.12070444e-01,5.77157414e-01,4.71728677e-01],
[6.12822925e-01,5.77842021e-01,4.72110122e-01],
[6.13574472e-01,5.78526244e-01,4.72490633e-01],
[6.14325085e-01,5.79210084e-01,4.72870213e-01],
[6.15074765e-01,5.79893546e-01,4.73248866e-01],
[6.15823512e-01,5.80576631e-01,4.73626593e-01],
[6.16571325e-01,5.81259341e-01,4.74003398e-01],
[6.17318204e-01,5.81941679e-01,4.74379284e-01],
[6.18064149e-01,5.82623648e-01,4.74754254e-01],
[6.18809160e-01,5.83305249e-01,4.75128311e-01],
[6.19553238e-01,5.83986485e-01,4.75501458e-01],
[6.20296381e-01,5.84667360e-01,4.75873697e-01],
[6.21038590e-01,5.85347873e-01,4.76245032e-01],
[6.21779865e-01,5.86028030e-01,4.76615466e-01],
[6.22520205e-01,5.86707831e-01,4.76985001e-01],
[6.23259610e-01,5.87387278e-01,4.77353641e-01],
[6.23998081e-01,5.88066375e-01,4.77721388e-01],
[6.24735618e-01,5.88745124e-01,4.78088246e-01],
[6.25472219e-01,5.89423526e-01,4.78454217e-01],
[6.26207885e-01,5.90101585e-01,4.78819304e-01],
[6.26942615e-01,5.90779302e-01,4.79183510e-01],
[6.27676411e-01,5.91456680e-01,4.79546838e-01],
[6.28409270e-01,5.92133721e-01,4.79909291e-01],
[6.29141194e-01,5.92810427e-01,4.80270872e-01],
[6.29872182e-01,5.93486800e-01,4.80631583e-01],
[6.30602234e-01,5.94162844e-01,4.80991429e-01],
[6.31331350e-01,5.94838559e-01,4.81350410e-01],
[6.32059529e-01,5.95513948e-01,4.81708532e-01],
[6.32786772e-01,5.96189014e-01,4.82065795e-01],
[6.33513077e-01,5.96863759e-01,4.82422204e-01],
[6.34238446e-01,5.97538184e-01,4.82777761e-01],
[6.34962877e-01,5.98212292e-01,4.83132468e-01],
[6.35686371e-01,5.98886085e-01,4.83486330e-01],
[6.36408927e-01,5.99559566e-01,4.83839348e-01],
[6.37130545e-01,6.00232736e-01,4.84191526e-01],
[6.37851225e-01,6.00905597e-01,4.84542866e-01],
[6.38570966e-01,6.01578152e-01,4.84893372e-01],
[6.39289769e-01,6.02250403e-01,4.85243045e-01],
[6.40007633e-01,6.02922353e-01,4.85591890e-01],
[6.40724558e-01,6.03594002e-01,4.85939908e-01],
[6.41440544e-01,6.04265353e-01,4.86287104e-01],
[6.42155590e-01,6.04936409e-01,4.86633478e-01],
[6.42869696e-01,6.05607171e-01,4.86979036e-01],
[6.43582862e-01,6.06277641e-01,4.87323778e-01],
[6.44295088e-01,6.06947822e-01,4.87667709e-01],
[6.45006373e-01,6.07617715e-01,4.88010830e-01],
[6.45716717e-01,6.08287323e-01,4.88353146e-01],
[6.46426119e-01,6.08956648e-01,4.88694657e-01],
[6.47134581e-01,6.09625691e-01,4.89035369e-01],
[6.47842100e-01,6.10294455e-01,4.89375282e-01],
[6.48548678e-01,6.10962941e-01,4.89714401e-01],
[6.49254313e-01,6.11631153e-01,4.90052728e-01],
[6.49959005e-01,6.12299091e-01,4.90390265e-01],
[6.50662755e-01,6.12966757e-01,4.90727016e-01],
[6.51365561e-01,6.13634155e-01,4.91062983e-01],
[6.52067423e-01,6.14301285e-01,4.91398169e-01],
[6.52768342e-01,6.14968149e-01,4.91732578e-01],
[6.53468317e-01,6.15634750e-01,4.92066211e-01],
[6.54167347e-01,6.16301090e-01,4.92399071e-01],
[6.54865432e-01,6.16967170e-01,4.92731162e-01],
[6.55562572e-01,6.17632992e-01,4.93062487e-01],
[6.56258767e-01,6.18298559e-01,4.93393047e-01],
[6.56954016e-01,6.18963872e-01,4.93722846e-01],
[6.57648319e-01,6.19628933e-01,4.94051886e-01],
[6.58341675e-01,6.20293744e-01,4.94380171e-01],
[6.59034084e-01,6.20958307e-01,4.94707704e-01],
[6.59725547e-01,6.21622624e-01,4.95034486e-01],
[6.60416061e-01,6.22286696e-01,4.95360520e-01],
[6.61105628e-01,6.22950526e-01,4.95685810e-01],
[6.61794247e-01,6.23614115e-01,4.96010359e-01],
[6.62481917e-01,6.24277466e-01,4.96334169e-01],
[6.63168639e-01,6.24940580e-01,4.96657242e-01],
[6.63854411e-01,6.25603458e-01,4.96979582e-01],
[6.64539233e-01,6.26266104e-01,4.97301191e-01],
[6.65223105e-01,6.26928518e-01,4.97622073e-01],
[6.65906028e-01,6.27590702e-01,4.97942229e-01],
[6.66587999e-01,6.28252658e-01,4.98261663e-01],
[6.67269019e-01,6.28914389e-01,4.98580378e-01],
[6.67949088e-01,6.29575895e-01,4.98898375e-01],
[6.68628205e-01,6.30237179e-01,4.99215659e-01],
[6.69306370e-01,6.30898242e-01,4.99532231e-01],
[6.69983582e-01,6.31559087e-01,4.99848095e-01],
[6.70659841e-01,6.32219714e-01,5.00163253e-01],
[6.71335147e-01,6.32880126e-01,5.00477708e-01],
[6.72009499e-01,6.33540324e-01,5.00791462e-01],
[6.72682897e-01,6.34200311e-01,5.01104519e-01],
[6.73355340e-01,6.34860087e-01,5.01416881e-01],
[6.74026829e-01,6.35519655e-01,5.01728551e-01],
[6.74697362e-01,6.36179016e-01,5.02039532e-01],
[6.75366939e-01,6.36838172e-01,5.02349826e-01],
[6.76035560e-01,6.37497125e-01,5.02659437e-01],
[6.76703225e-01,6.38155877e-01,5.02968366e-01],
[6.77369933e-01,6.38814428e-01,5.03276617e-01],
[6.78035683e-01,6.39472781e-01,5.03584192e-01],
[6.78700476e-01,6.40130938e-01,5.03891094e-01],
[6.79364310e-01,6.40788900e-01,5.04197326e-01],
[6.80027186e-01,6.41446668e-01,5.04502890e-01],
[6.80689103e-01,6.42104245e-01,5.04807790e-01],
[6.81350061e-01,6.42761632e-01,5.05112028e-01],
[6.82010059e-01,6.43418831e-01,5.05415606e-01],
[6.82669096e-01,6.44075844e-01,5.05718528e-01],
[6.83327173e-01,6.44732671e-01,5.06020795e-01],
[6.83984289e-01,6.45389315e-01,5.06322412e-01],
[6.84640443e-01,6.46045777e-01,5.06623380e-01],
[6.85295636e-01,6.46702059e-01,5.06923703e-01],
[6.85949866e-01,6.47358162e-01,5.07223382e-01],
[6.86603133e-01,6.48014089e-01,5.07522421e-01],
[6.87255437e-01,6.48669840e-01,5.07820822e-01],
[6.87906778e-01,6.49325417e-01,5.08118589e-01],
[6.88557155e-01,6.49980822e-01,5.08415723e-01],
[6.89206567e-01,6.50636056e-01,5.08712228e-01],
[6.89855014e-01,6.51291122e-01,5.09008105e-01],
[6.90502496e-01,6.51946019e-01,5.09303359e-01],
[6.91149012e-01,6.52600751e-01,5.09597991e-01],
[6.91794562e-01,6.53255318e-01,5.09892005e-01],
[6.92439145e-01,6.53909722e-01,5.10185402e-01],
[6.93082761e-01,6.54563965e-01,5.10478186e-01],
[6.93725410e-01,6.55218048e-01,5.10770360e-01],
[6.94367090e-01,6.55871973e-01,5.11061925e-01],
[6.95007803e-01,6.56525741e-01,5.11352885e-01],
[6.95647546e-01,6.57179353e-01,5.11643242e-01],
[6.96286320e-01,6.57832812e-01,5.11933000e-01],
[6.96924125e-01,6.58486118e-01,5.12222160e-01],
[6.97560959e-01,6.59139273e-01,5.12510726e-01],
[6.98196823e-01,6.59792279e-01,5.12798700e-01],
[6.98831716e-01,6.60445137e-01,5.13086084e-01],
[6.99465637e-01,6.61097848e-01,5.13372882e-01],
[7.00098586e-01,6.61750415e-01,5.13659096e-01],
[7.00730563e-01,6.62402838e-01,5.13944729e-01],
[7.01361567e-01,6.63055118e-01,5.14229784e-01],
[7.01991598e-01,6.63707258e-01,5.14514262e-01],
[7.02620655e-01,6.64359259e-01,5.14798167e-01],
[7.03248738e-01,6.65011122e-01,5.15081502e-01],
[7.03875846e-01,6.65662848e-01,5.15364269e-01],
[7.04501979e-01,6.66314440e-01,5.15646471e-01],
[7.05127137e-01,6.66965898e-01,5.15928110e-01],
[7.05751319e-01,6.67617223e-01,5.16209189e-01],
[7.06374524e-01,6.68268418e-01,5.16489712e-01],
[7.06996753e-01,6.68919483e-01,5.16769679e-01],
[7.07618004e-01,6.69570421e-01,5.17049095e-01],
[7.08238277e-01,6.70221231e-01,5.17327961e-01],
[7.08857573e-01,6.70871917e-01,5.17606281e-01],
[7.09475889e-01,6.71522478e-01,5.17884057e-01],
[7.10093227e-01,6.72172917e-01,5.18161291e-01],
[7.10709585e-01,6.72823235e-01,5.18437987e-01],
[7.11324963e-01,6.73473433e-01,5.18714147e-01],
[7.11939360e-01,6.74123512e-01,5.18989774e-01],
[7.12552777e-01,6.74773474e-01,5.19264870e-01],
[7.13165212e-01,6.75423320e-01,5.19539437e-01],
[7.13776665e-01,6.76073052e-01,5.19813480e-01],
[7.14387136e-01,6.76722670e-01,5.20086999e-01],
[7.14996625e-01,6.77372177e-01,5.20359999e-01],
[7.15605130e-01,6.78021573e-01,5.20632481e-01],
[7.16212652e-01,6.78670859e-01,5.20904448e-01],
[7.16819189e-01,6.79320038e-01,5.21175903e-01],
[7.17424742e-01,6.79969110e-01,5.21446848e-01],
[7.18029310e-01,6.80618076e-01,5.21717287e-01],
[7.18632893e-01,6.81266939e-01,5.21987221e-01],
[7.19235490e-01,6.81915698e-01,5.22256653e-01],
[7.19837101e-01,6.82564356e-01,5.22525586e-01],
[7.20437724e-01,6.83212913e-01,5.22794023e-01],
[7.21037361e-01,6.83861371e-01,5.23061966e-01],
[7.21636010e-01,6.84509732e-01,5.23329418e-01],
[7.22233671e-01,6.85157995e-01,5.23596381e-01],
[7.22830343e-01,6.85806164e-01,5.23862859e-01],
[7.23426027e-01,6.86454238e-01,5.24128853e-01],
[7.24020721e-01,6.87102219e-01,5.24394366e-01],
[7.24614425e-01,6.87750108e-01,5.24659402e-01],
[7.25207138e-01,6.88397907e-01,5.24923962e-01],
[7.25798861e-01,6.89045617e-01,5.25188049e-01],
[7.26389593e-01,6.89693239e-01,5.25451666e-01],
[7.26979334e-01,6.90340773e-01,5.25714815e-01],
[7.27568082e-01,6.90988222e-01,5.25977499e-01],
[7.28155837e-01,6.91635587e-01,5.26239721e-01],
[7.28742600e-01,6.92282868e-01,5.26501483e-01],
[7.29328369e-01,6.92930067e-01,5.26762788e-01],
[7.29913144e-01,6.93577185e-01,5.27023639e-01],
[7.30496926e-01,6.94224223e-01,5.27284037e-01],
[7.31079712e-01,6.94871182e-01,5.27543986e-01],
[7.31661503e-01,6.95518064e-01,5.27803489e-01],
[7.32242299e-01,6.96164870e-01,5.28062547e-01],
[7.32822099e-01,6.96811600e-01,5.28321164e-01],
[7.33400902e-01,6.97458256e-01,5.28579342e-01],
[7.33978708e-01,6.98104840e-01,5.28837084e-01],
[7.34555517e-01,6.98751351e-01,5.29094391e-01],
[7.35131329e-01,6.99397792e-01,5.29351268e-01],
[7.35706142e-01,7.00044163e-01,5.29607717e-01],
[7.36279956e-01,7.00690465e-01,5.29863739e-01],
[7.36852772e-01,7.01336701e-01,5.30119338e-01],
[7.37424588e-01,7.01982870e-01,5.30374516e-01],
[7.37995404e-01,7.02628973e-01,5.30629276e-01],
[7.38565220e-01,7.03275013e-01,5.30883621e-01],
[7.39134035e-01,7.03920990e-01,5.31137553e-01],
[7.39701849e-01,7.04566905e-01,5.31391074e-01],
[7.40268662e-01,7.05212758e-01,5.31644187e-01],
[7.40834472e-01,7.05858552e-01,5.31896896e-01],
[7.41399280e-01,7.06504288e-01,5.32149201e-01],
[7.41963086e-01,7.07149965e-01,5.32401107e-01],
[7.42525888e-01,7.07795587e-01,5.32652615e-01],
[7.43087686e-01,7.08441152e-01,5.32903728e-01],
[7.43648481e-01,7.09086663e-01,5.33154450e-01],
[7.44208271e-01,7.09732120e-01,5.33404781e-01],
[7.44767056e-01,7.10377525e-01,5.33654725e-01],
[7.45324836e-01,7.11022879e-01,5.33904285e-01],
[7.45881610e-01,7.11668182e-01,5.34153463e-01],
[7.46437378e-01,7.12313436e-01,5.34402261e-01],
[7.46992140e-01,7.12958641e-01,5.34650682e-01],
[7.47545894e-01,7.13603799e-01,5.34898730e-01],
[7.48098642e-01,7.14248911e-01,5.35146405e-01],
[7.48650382e-01,7.14893977e-01,5.35393712e-01],
[7.49201113e-01,7.15538999e-01,5.35640652e-01],
[7.49750836e-01,7.16183977e-01,5.35887228e-01],
[7.50299551e-01,7.16828913e-01,5.36133443e-01],
[7.50847256e-01,7.17473808e-01,5.36379298e-01],
[7.51393951e-01,7.18118662e-01,5.36624798e-01],
[7.51939636e-01,7.18763476e-01,5.36869944e-01],
[7.52484311e-01,7.19408252e-01,5.37114739e-01],
[7.53027975e-01,7.20052991e-01,5.37359185e-01],
[7.53570628e-01,7.20697693e-01,5.37603285e-01],
[7.54112270e-01,7.21342359e-01,5.37847042e-01],
[7.54652899e-01,7.21986990e-01,5.38090458e-01],
[7.55192516e-01,7.22631587e-01,5.38333535e-01],
[7.55731120e-01,7.23276152e-01,5.38576277e-01],
[7.56268711e-01,7.23920685e-01,5.38818685e-01],
[7.56805289e-01,7.24565186e-01,5.39060763e-01],
[7.57340853e-01,7.25209658e-01,5.39302513e-01],
[7.57875402e-01,7.25854100e-01,5.39543937e-01],
[7.58408937e-01,7.26498514e-01,5.39785038e-01],
[7.58941457e-01,7.27142901e-01,5.40025819e-01],
[7.59472962e-01,7.27787261e-01,5.40266282e-01],
[7.60003451e-01,7.28431595e-01,5.40506429e-01],
[7.60532924e-01,7.29075905e-01,5.40746264e-01],
[7.61061381e-01,7.29720191e-01,5.40985788e-01],
[7.61588821e-01,7.30364454e-01,5.41225005e-01],
[7.62115244e-01,7.31008695e-01,5.41463917e-01],
[7.62640649e-01,7.31652914e-01,5.41702526e-01],
[7.63165037e-01,7.32297114e-01,5.41940834e-01],
[7.63688406e-01,7.32941293e-01,5.42178846e-01],
[7.64210757e-01,7.33585455e-01,5.42416562e-01],
[7.64732089e-01,7.34229598e-01,5.42653986e-01],
[7.65252402e-01,7.34873724e-01,5.42891120e-01],
[7.65771696e-01,7.35517835e-01,5.43127966e-01],
[7.66289969e-01,7.36161930e-01,5.43364528e-01],
[7.66807222e-01,7.36806010e-01,5.43600807e-01],
[7.67323455e-01,7.37450077e-01,5.43836806e-01],
[7.67838667e-01,7.38094131e-01,5.44072529e-01],
[7.68352858e-01,7.38738173e-01,5.44307976e-01],
[7.68866027e-01,7.39382204e-01,5.44543151e-01],
[7.69378174e-01,7.40026225e-01,5.44778057e-01],
[7.69889300e-01,7.40670236e-01,5.45012695e-01],
[7.70399402e-01,7.41314238e-01,5.45247069e-01],
[7.70908482e-01,7.41958233e-01,5.45481181e-01],
[7.71416539e-01,7.42602220e-01,5.45715033e-01],
[7.71923573e-01,7.43246200e-01,5.45948629e-01],
[7.72429582e-01,7.43890176e-01,5.46181969e-01],
[7.72934568e-01,7.44534146e-01,5.46415058e-01],
[7.73438529e-01,7.45178112e-01,5.46647897e-01],
[7.73941466e-01,7.45822075e-01,5.46880489e-01],
[7.74443377e-01,7.46466035e-01,5.47112837e-01],
[7.74944264e-01,7.47109994e-01,5.47344943e-01],
[7.75444125e-01,7.47753951e-01,5.47576810e-01],
[7.75942960e-01,7.48397908e-01,5.47808439e-01],
[7.76440768e-01,7.49041866e-01,5.48039835e-01],
[7.76937551e-01,7.49685825e-01,5.48270998e-01],
[7.77433307e-01,7.50329786e-01,5.48501932e-01],
[7.77928035e-01,7.50973749e-01,5.48732639e-01],
[7.78421737e-01,7.51617716e-01,5.48963122e-01],
[7.78914411e-01,7.52261687e-01,5.49193383e-01],
[7.79406057e-01,7.52905662e-01,5.49423425e-01],
[7.79896675e-01,7.53549644e-01,5.49653250e-01],
[7.80386264e-01,7.54193631e-01,5.49882861e-01],
[7.80874825e-01,7.54837625e-01,5.50112260e-01],
[7.81362357e-01,7.55481627e-01,5.50341449e-01],
[7.81848860e-01,7.56125637e-01,5.50570432e-01],
[7.82334333e-01,7.56769657e-01,5.50799211e-01],
[7.82818777e-01,7.57413686e-01,5.51027788e-01],
[7.83302191e-01,7.58057725e-01,5.51256165e-01],
[7.83784574e-01,7.58701775e-01,5.51484346e-01],
[7.84265928e-01,7.59345838e-01,5.51712332e-01],
[7.84746250e-01,7.59989912e-01,5.51940127e-01],
[7.85225541e-01,7.60634000e-01,5.52167732e-01],
[7.85703802e-01,7.61278101e-01,5.52395151e-01],
[7.86181030e-01,7.61922216e-01,5.52622385e-01],
[7.86657228e-01,7.62566347e-01,5.52849438e-01],
[7.87132393e-01,7.63210493e-01,5.53076311e-01],
[7.87606526e-01,7.63854656e-01,5.53303007e-01],
[7.88079627e-01,7.64498835e-01,5.53529529e-01],
[7.88551695e-01,7.65143032e-01,5.53755880e-01],
[7.89022731e-01,7.65787247e-01,5.53982060e-01],
[7.89492733e-01,7.66431481e-01,5.54208074e-01],
[7.89961702e-01,7.67075735e-01,5.54433924e-01],
[7.90429638e-01,7.67720008e-01,5.54659611e-01],
[7.90896540e-01,7.68364302e-01,5.54885140e-01],
[7.91362408e-01,7.69008617e-01,5.55110511e-01],
[7.91827242e-01,7.69652954e-01,5.55335728e-01],
[7.92291042e-01,7.70297314e-01,5.55560793e-01],
[7.92753807e-01,7.70941697e-01,5.55785708e-01],
[7.93215538e-01,7.71586103e-01,5.56010476e-01],
[7.93676234e-01,7.72230534e-01,5.56235100e-01],
[7.94135894e-01,7.72874989e-01,5.56459582e-01],
[7.94594520e-01,7.73519469e-01,5.56683924e-01],
[7.95052110e-01,7.74163976e-01,5.56908129e-01],
[7.95508664e-01,7.74808509e-01,5.57132199e-01],
[7.95964183e-01,7.75453069e-01,5.57356137e-01],
[7.96418665e-01,7.76097657e-01,5.57579945e-01],
[7.96872112e-01,7.76742273e-01,5.57803627e-01],
[7.97324522e-01,7.77386918e-01,5.58027183e-01],
[7.97775895e-01,7.78031592e-01,5.58250617e-01],
[7.98226232e-01,7.78676296e-01,5.58473931e-01],
[7.98675533e-01,7.79321030e-01,5.58697128e-01],
[7.99123796e-01,7.79965795e-01,5.58920210e-01],
[7.99571022e-01,7.80610591e-01,5.59143180e-01],
[8.00017211e-01,7.81255420e-01,5.59366039e-01],
[8.00462362e-01,7.81900281e-01,5.59588791e-01],
[8.00906476e-01,7.82545175e-01,5.59811438e-01],
[8.01349552e-01,7.83190102e-01,5.60033983e-01],
[8.01791590e-01,7.83835063e-01,5.60256427e-01],
[8.02232591e-01,7.84480059e-01,5.60478773e-01],
[8.02672553e-01,7.85125090e-01,5.60701025e-01],
[8.03111477e-01,7.85770156e-01,5.60923183e-01],
[8.03549362e-01,7.86415259e-01,5.61145251e-01],
[8.03986209e-01,7.87060398e-01,5.61367232e-01],
[8.04422018e-01,7.87705573e-01,5.61589126e-01],
[8.04856787e-01,7.88350787e-01,5.61810938e-01],
[8.05290518e-01,7.88996038e-01,5.62032670e-01],
[8.05723210e-01,7.89641327e-01,5.62254323e-01],
[8.06154863e-01,7.90286656e-01,5.62475901e-01],
[8.06585476e-01,7.90932024e-01,5.62697405e-01],
[8.07015051e-01,7.91577431e-01,5.62918839e-01],
[8.07443586e-01,7.92222879e-01,5.63140204e-01],
[8.07871081e-01,7.92868367e-01,5.63361504e-01],
[8.08297537e-01,7.93513897e-01,5.63582740e-01],
[8.08722953e-01,7.94159468e-01,5.63803915e-01],
[8.09147330e-01,7.94805081e-01,5.64025032e-01],
[8.09570666e-01,7.95450737e-01,5.64246092e-01],
[8.09992963e-01,7.96096435e-01,5.64467099e-01],
[8.10414220e-01,7.96742177e-01,5.64688055e-01],
[8.10834437e-01,7.97387963e-01,5.64908962e-01],
[8.11253613e-01,7.98033793e-01,5.65129822e-01],
[8.11671750e-01,7.98679667e-01,5.65350639e-01],
[8.12088846e-01,7.99325586e-01,5.65571414e-01],
[8.12504902e-01,7.99971551e-01,5.65792150e-01],
[8.12919918e-01,8.00617561e-01,5.66012850e-01],
[8.13333893e-01,8.01263618e-01,5.66233515e-01],
[8.13746828e-01,8.01909721e-01,5.66454149e-01],
[8.14158722e-01,8.02555871e-01,5.66674753e-01],
[8.14569575e-01,8.03202068e-01,5.66895330e-01],
[8.14979389e-01,8.03848314e-01,5.67115883e-01],
[8.15388161e-01,8.04494607e-01,5.67336414e-01],
[8.15795893e-01,8.05140949e-01,5.67556925e-01],
[8.16202584e-01,8.05787339e-01,5.67777419e-01],
[8.16608235e-01,8.06433779e-01,5.67997898e-01],
[8.17012844e-01,8.07080269e-01,5.68218364e-01],
[8.17416413e-01,8.07726808e-01,5.68438821e-01],
[8.17818942e-01,8.08373398e-01,5.68659270e-01],
[8.18220429e-01,8.09020039e-01,5.68879714e-01],
[8.18620876e-01,8.09666730e-01,5.69100156e-01],
[8.19020282e-01,8.10313473e-01,5.69320597e-01],
[8.19418647e-01,8.10960267e-01,5.69541040e-01],
[8.19815972e-01,8.11607114e-01,5.69761487e-01],
[8.20212255e-01,8.12254013e-01,5.69981942e-01],
[8.20607498e-01,8.12900964e-01,5.70202406e-01],
[8.21001700e-01,8.13547969e-01,5.70422882e-01],
[8.21394862e-01,8.14195027e-01,5.70643371e-01],
[8.21786983e-01,8.14842138e-01,5.70863878e-01],
[8.22178063e-01,8.15489304e-01,5.71084403e-01],
[8.22568102e-01,8.16136524e-01,5.71304950e-01],
[8.22957101e-01,8.16783798e-01,5.71525521e-01],
[8.23345059e-01,8.17431127e-01,5.71746117e-01],
[8.23731977e-01,8.18078512e-01,5.71966743e-01],
[8.24117854e-01,8.18725952e-01,5.72187399e-01],
[8.24502690e-01,8.19373447e-01,5.72408088e-01],
[8.24886487e-01,8.20020999e-01,5.72628814e-01],
[8.25269243e-01,8.20668607e-01,5.72849577e-01],
[8.25650958e-01,8.21316272e-01,5.73070382e-01],
[8.26031634e-01,8.21963993e-01,5.73291229e-01],
[8.26411269e-01,8.22611772e-01,5.73512121e-01],
[8.26789864e-01,8.23259608e-01,5.73733061e-01],
[8.27167419e-01,8.23907502e-01,5.73954052e-01],
[8.27543934e-01,8.24555454e-01,5.74175095e-01],
[8.27919409e-01,8.25203464e-01,5.74396192e-01],
[8.28293844e-01,8.25851532e-01,5.74617348e-01],
[8.28667240e-01,8.26499659e-01,5.74838562e-01],
[8.29039596e-01,8.27147845e-01,5.75059839e-01],
[8.29410912e-01,8.27796091e-01,5.75281181e-01],
[8.29781189e-01,8.28444395e-01,5.75502589e-01],
[8.30150427e-01,8.29092760e-01,5.75724066e-01],
[8.30518625e-01,8.29741184e-01,5.75945615e-01],
[8.30885784e-01,8.30389668e-01,5.76167238e-01],
[8.31251905e-01,8.31038213e-01,5.76388938e-01],
[8.31616986e-01,8.31686818e-01,5.76610716e-01],
[8.31981028e-01,8.32335484e-01,5.76832575e-01],
[8.32344032e-01,8.32984211e-01,5.77054518e-01],
[8.32705997e-01,8.33632999e-01,5.77276547e-01],
[8.33066924e-01,8.34281849e-01,5.77498663e-01],
[8.33426812e-01,8.34930760e-01,5.77720871e-01],
[8.33785663e-01,8.35579733e-01,5.77943171e-01],
[8.34143475e-01,8.36228768e-01,5.78165567e-01],
[8.34500249e-01,8.36877865e-01,5.78388061e-01],
[8.34855986e-01,8.37527025e-01,5.78610655e-01],
[8.35210685e-01,8.38176247e-01,5.78833351e-01],
[8.35564347e-01,8.38825532e-01,5.79056152e-01],
[8.35916971e-01,8.39474879e-01,5.79279060e-01],
[8.36268558e-01,8.40124290e-01,5.79502078e-01],
[8.36619109e-01,8.40773764e-01,5.79725207e-01],
[8.36968622e-01,8.41423301e-01,5.79948451e-01],
[8.37317099e-01,8.42072902e-01,5.80171812e-01],
[8.37664540e-01,8.42722567e-01,5.80395292e-01],
[8.38010944e-01,8.43372295e-01,5.80618893e-01],
[8.38356312e-01,8.44022088e-01,5.80842617e-01],
[8.38700645e-01,8.44671945e-01,5.81066468e-01],
[8.39043941e-01,8.45321866e-01,5.81290447e-01],
[8.39386202e-01,8.45971851e-01,5.81514557e-01],
[8.39727428e-01,8.46621901e-01,5.81738800e-01],
[8.40067619e-01,8.47272016e-01,5.81963179e-01],
[8.40406775e-01,8.47922196e-01,5.82187696e-01],
[8.40744896e-01,8.48572440e-01,5.82412352e-01],
[8.41081983e-01,8.49222750e-01,5.82637151e-01],
[8.41418035e-01,8.49873125e-01,5.82862095e-01],
[8.41753054e-01,8.50523565e-01,5.83087187e-01],
[8.42087039e-01,8.51174071e-01,5.83312428e-01],
[8.42419990e-01,8.51824642e-01,5.83537821e-01],
[8.42751908e-01,8.52475279e-01,5.83763368e-01],
[8.43082792e-01,8.53125981e-01,5.83989071e-01],
[8.43412644e-01,8.53776750e-01,5.84214934e-01],
[8.43741463e-01,8.54427584e-01,5.84440958e-01],
[8.44069250e-01,8.55078484e-01,5.84667145e-01],
[8.44396005e-01,8.55729451e-01,5.84893499e-01],
[8.44721728e-01,8.56380484e-01,5.85120021e-01],
[8.45046419e-01,8.57031583e-01,5.85346713e-01],
[8.45370079e-01,8.57682748e-01,5.85573579e-01],
[8.45692708e-01,8.58333980e-01,5.85800619e-01],
[8.46014307e-01,8.58985278e-01,5.86027838e-01],
[8.46334874e-01,8.59636642e-01,5.86255236e-01],
[8.46654412e-01,8.60288074e-01,5.86482817e-01],
[8.46972919e-01,8.60939572e-01,5.86710582e-01],
[8.47290397e-01,8.61591137e-01,5.86938534e-01],
[8.47606845e-01,8.62242768e-01,5.87166675e-01],
[8.47922264e-01,8.62894467e-01,5.87395008e-01],
[8.48236655e-01,8.63546232e-01,5.87623535e-01],
[8.48550017e-01,8.64198064e-01,5.87852259e-01],
[8.48862350e-01,8.64849963e-01,5.88081180e-01],
[8.49173656e-01,8.65501929e-01,5.88310303e-01],
[8.49483935e-01,8.66153962e-01,5.88539629e-01],
[8.49793186e-01,8.66806062e-01,5.88769160e-01],
[8.50101410e-01,8.67458230e-01,5.88998900e-01],
[8.50408607e-01,8.68110464e-01,5.89228849e-01],
[8.50714779e-01,8.68762765e-01,5.89459011e-01],
[8.51019924e-01,8.69415134e-01,5.89689388e-01],
[8.51324044e-01,8.70067570e-01,5.89919981e-01],
[8.51627138e-01,8.70720072e-01,5.90150795e-01],
[8.51929208e-01,8.71372642e-01,5.90381829e-01],
[8.52230252e-01,8.72025280e-01,5.90613088e-01],
[8.52530273e-01,8.72677984e-01,5.90844574e-01],
[8.52829270e-01,8.73330755e-01,5.91076288e-01],
[8.53127243e-01,8.73983594e-01,5.91308233e-01],
[8.53424193e-01,8.74636499e-01,5.91540411e-01],
[8.53720120e-01,8.75289472e-01,5.91772824e-01],
[8.54015025e-01,8.75942512e-01,5.92005476e-01],
[8.54308908e-01,8.76595618e-01,5.92238368e-01],
[8.54601769e-01,8.77248792e-01,5.92471502e-01],
[8.54893609e-01,8.77902033e-01,5.92704881e-01],
[8.55184428e-01,8.78555341e-01,5.92938507e-01],
[8.55474227e-01,8.79208716e-01,5.93172383e-01],
[8.55763005e-01,8.79862157e-01,5.93406510e-01],
[8.56050764e-01,8.80515666e-01,5.93640891e-01],
[8.56337503e-01,8.81169241e-01,5.93875528e-01],
[8.56623223e-01,8.81822883e-01,5.94110424e-01],
[8.56907925e-01,8.82476592e-01,5.94345581e-01],
[8.57191609e-01,8.83130367e-01,5.94581000e-01],
[8.57474275e-01,8.83784209e-01,5.94816686e-01],
[8.57755923e-01,8.84438118e-01,5.95052639e-01],
[8.58036555e-01,8.85092093e-01,5.95288862e-01],
[8.58316171e-01,8.85746134e-01,5.95525357e-01],
[8.58594770e-01,8.86400241e-01,5.95762127e-01],
[8.58872354e-01,8.87054415e-01,5.95999173e-01],
[8.59148923e-01,8.87708655e-01,5.96236499e-01],
[8.59424478e-01,8.88362961e-01,5.96474106e-01],
[8.59699017e-01,8.89017334e-01,5.96711997e-01],
[8.59972544e-01,8.89671772e-01,5.96950174e-01],
[8.60245057e-01,8.90326275e-01,5.97188639e-01],
[8.60516557e-01,8.90980845e-01,5.97427395e-01],
[8.60787044e-01,8.91635480e-01,5.97666443e-01],
[8.61056520e-01,8.92290181e-01,5.97905786e-01],
[8.61324984e-01,8.92944947e-01,5.98145427e-01],
[8.61592438e-01,8.93599778e-01,5.98385368e-01],
[8.61858880e-01,8.94254675e-01,5.98625610e-01],
[8.62124313e-01,8.94909637e-01,5.98866157e-01],
[8.62388736e-01,8.95564663e-01,5.99107010e-01],
[8.62652150e-01,8.96219755e-01,5.99348171e-01],
[8.62914556e-01,8.96874911e-01,5.99589644e-01],
[8.63175954e-01,8.97530132e-01,5.99831430e-01],
[8.63436343e-01,8.98185417e-01,6.00073531e-01],
[8.63695726e-01,8.98840767e-01,6.00315951e-01],
[8.63954103e-01,8.99496181e-01,6.00558690e-01],
[8.64211473e-01,9.00151659e-01,6.00801751e-01],
[8.64467838e-01,9.00807201e-01,6.01045137e-01],
[8.64723198e-01,9.01462806e-01,6.01288850e-01],
[8.64977553e-01,9.02118476e-01,6.01532892e-01],
[8.65230904e-01,9.02774209e-01,6.01777265e-01],
[8.65483252e-01,9.03430005e-01,6.02021972e-01],
[8.65734597e-01,9.04085864e-01,6.02267015e-01],
[8.65984940e-01,9.04741786e-01,6.02512396e-01],
[8.66234281e-01,9.05397771e-01,6.02758117e-01],
[8.66482621e-01,9.06053819e-01,6.03004180e-01],
[8.66729959e-01,9.06709929e-01,6.03250589e-01],
[8.66976298e-01,9.07366102e-01,6.03497345e-01],
[8.67221637e-01,9.08022337e-01,6.03744450e-01],
[8.67465978e-01,9.08678633e-01,6.03991906e-01]])