import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface AnalysisServicesServerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#admin_users AnalysisServicesServer#admin_users}.
     *
     * @stability stable
     */
    readonly adminUsers?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#backup_blob_container_uri AnalysisServicesServer#backup_blob_container_uri}.
     *
     * @stability stable
     */
    readonly backupBlobContainerUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#enable_power_bi_service AnalysisServicesServer#enable_power_bi_service}.
     *
     * @stability stable
     */
    readonly enablePowerBiService?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#location AnalysisServicesServer#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#name AnalysisServicesServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#querypool_connection_mode AnalysisServicesServer#querypool_connection_mode}.
     *
     * @stability stable
     */
    readonly querypoolConnectionMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#resource_group_name AnalysisServicesServer#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#sku AnalysisServicesServer#sku}.
     *
     * @stability stable
     */
    readonly sku: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#tags AnalysisServicesServer#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * ipv4_firewall_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#ipv4_firewall_rule AnalysisServicesServer#ipv4_firewall_rule}
     *
     * @stability stable
     */
    readonly ipv4FirewallRule?: AnalysisServicesServerIpv4FirewallRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#timeouts AnalysisServicesServer#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: AnalysisServicesServerTimeouts;
}
/**
 * @stability stable
 */
export interface AnalysisServicesServerIpv4FirewallRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#name AnalysisServicesServer#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#range_end AnalysisServicesServer#range_end}.
     *
     * @stability stable
     */
    readonly rangeEnd: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#range_start AnalysisServicesServer#range_start}.
     *
     * @stability stable
     */
    readonly rangeStart: string;
}
export declare function analysisServicesServerIpv4FirewallRuleToTerraform(struct?: AnalysisServicesServerIpv4FirewallRule): any;
/**
 * @stability stable
 */
export interface AnalysisServicesServerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#create AnalysisServicesServer#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#delete AnalysisServicesServer#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#read AnalysisServicesServer#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html#update AnalysisServicesServer#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function analysisServicesServerTimeoutsToTerraform(struct?: AnalysisServicesServerTimeoutsOutputReference | AnalysisServicesServerTimeouts): any;
/**
 * @stability stable
 */
export declare class AnalysisServicesServerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): AnalysisServicesServerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: AnalysisServicesServerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html azurerm_analysis_services_server}.
 *
 * @stability stable
 */
export declare class AnalysisServicesServer extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/analysis_services_server.html azurerm_analysis_services_server} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: AnalysisServicesServerConfig);
    private _adminUsers?;
    /**
     * @stability stable
     */
    get adminUsers(): string[];
    /**
     * @stability stable
     */
    set adminUsers(value: string[]);
    /**
     * @stability stable
     */
    resetAdminUsers(): void;
    /**
     * @stability stable
     */
    get adminUsersInput(): string[] | undefined;
    private _backupBlobContainerUri?;
    /**
     * @stability stable
     */
    get backupBlobContainerUri(): string;
    /**
     * @stability stable
     */
    set backupBlobContainerUri(value: string);
    /**
     * @stability stable
     */
    resetBackupBlobContainerUri(): void;
    /**
     * @stability stable
     */
    get backupBlobContainerUriInput(): string | undefined;
    private _enablePowerBiService?;
    /**
     * @stability stable
     */
    get enablePowerBiService(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enablePowerBiService(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnablePowerBiService(): void;
    /**
     * @stability stable
     */
    get enablePowerBiServiceInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _querypoolConnectionMode?;
    /**
     * @stability stable
     */
    get querypoolConnectionMode(): string;
    /**
     * @stability stable
     */
    set querypoolConnectionMode(value: string);
    /**
     * @stability stable
     */
    resetQuerypoolConnectionMode(): void;
    /**
     * @stability stable
     */
    get querypoolConnectionModeInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get serverFullName(): string;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _ipv4FirewallRule?;
    /**
     * @stability stable
     */
    get ipv4FirewallRule(): AnalysisServicesServerIpv4FirewallRule[];
    /**
     * @stability stable
     */
    set ipv4FirewallRule(value: AnalysisServicesServerIpv4FirewallRule[]);
    /**
     * @stability stable
     */
    resetIpv4FirewallRule(): void;
    /**
     * @stability stable
     */
    get ipv4FirewallRuleInput(): AnalysisServicesServerIpv4FirewallRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): AnalysisServicesServerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: AnalysisServicesServerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): AnalysisServicesServerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
