import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementApiConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#api_management_name ApiManagementApi#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#description ApiManagementApi#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#display_name ApiManagementApi#display_name}.
     *
     * @stability stable
     */
    readonly displayName?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#name ApiManagementApi#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#path ApiManagementApi#path}.
     *
     * @stability stable
     */
    readonly path?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#protocols ApiManagementApi#protocols}.
     *
     * @stability stable
     */
    readonly protocols?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#resource_group_name ApiManagementApi#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#revision ApiManagementApi#revision}.
     *
     * @stability stable
     */
    readonly revision: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#revision_description ApiManagementApi#revision_description}.
     *
     * @stability stable
     */
    readonly revisionDescription?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#service_url ApiManagementApi#service_url}.
     *
     * @stability stable
     */
    readonly serviceUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#soap_pass_through ApiManagementApi#soap_pass_through}.
     *
     * @stability stable
     */
    readonly soapPassThrough?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#source_api_id ApiManagementApi#source_api_id}.
     *
     * @stability stable
     */
    readonly sourceApiId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#subscription_required ApiManagementApi#subscription_required}.
     *
     * @stability stable
     */
    readonly subscriptionRequired?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#version ApiManagementApi#version}.
     *
     * @stability stable
     */
    readonly version?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#version_description ApiManagementApi#version_description}.
     *
     * @stability stable
     */
    readonly versionDescription?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#version_set_id ApiManagementApi#version_set_id}.
     *
     * @stability stable
     */
    readonly versionSetId?: string;
    /**
     * import block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#import ApiManagementApi#import}
     *
     * @stability stable
     */
    readonly import?: ApiManagementApiImport;
    /**
     * oauth2_authorization block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#oauth2_authorization ApiManagementApi#oauth2_authorization}
     *
     * @stability stable
     */
    readonly oauth2Authorization?: ApiManagementApiOauth2Authorization;
    /**
     * openid_authentication block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#openid_authentication ApiManagementApi#openid_authentication}
     *
     * @stability stable
     */
    readonly openidAuthentication?: ApiManagementApiOpenidAuthentication;
    /**
     * subscription_key_parameter_names block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#subscription_key_parameter_names ApiManagementApi#subscription_key_parameter_names}
     *
     * @stability stable
     */
    readonly subscriptionKeyParameterNames?: ApiManagementApiSubscriptionKeyParameterNames;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#timeouts ApiManagementApi#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementApiTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementApiImportWsdlSelector {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#endpoint_name ApiManagementApi#endpoint_name}.
     *
     * @stability stable
     */
    readonly endpointName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#service_name ApiManagementApi#service_name}.
     *
     * @stability stable
     */
    readonly serviceName: string;
}
export declare function apiManagementApiImportWsdlSelectorToTerraform(struct?: ApiManagementApiImportWsdlSelectorOutputReference | ApiManagementApiImportWsdlSelector): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiImportWsdlSelectorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiImportWsdlSelector | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiImportWsdlSelector | undefined);
    private _endpointName?;
    /**
     * @stability stable
     */
    get endpointName(): string;
    /**
     * @stability stable
     */
    set endpointName(value: string);
    /**
     * @stability stable
     */
    get endpointNameInput(): string | undefined;
    private _serviceName?;
    /**
     * @stability stable
     */
    get serviceName(): string;
    /**
     * @stability stable
     */
    set serviceName(value: string);
    /**
     * @stability stable
     */
    get serviceNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiImport {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#content_format ApiManagementApi#content_format}.
     *
     * @stability stable
     */
    readonly contentFormat: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#content_value ApiManagementApi#content_value}.
     *
     * @stability stable
     */
    readonly contentValue: string;
    /**
     * wsdl_selector block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#wsdl_selector ApiManagementApi#wsdl_selector}
     *
     * @stability stable
     */
    readonly wsdlSelector?: ApiManagementApiImportWsdlSelector;
}
export declare function apiManagementApiImportToTerraform(struct?: ApiManagementApiImportOutputReference | ApiManagementApiImport): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiImportOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiImport | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiImport | undefined);
    private _contentFormat?;
    /**
     * @stability stable
     */
    get contentFormat(): string;
    /**
     * @stability stable
     */
    set contentFormat(value: string);
    /**
     * @stability stable
     */
    get contentFormatInput(): string | undefined;
    private _contentValue?;
    /**
     * @stability stable
     */
    get contentValue(): string;
    /**
     * @stability stable
     */
    set contentValue(value: string);
    /**
     * @stability stable
     */
    get contentValueInput(): string | undefined;
    private _wsdlSelector;
    /**
     * @stability stable
     */
    get wsdlSelector(): ApiManagementApiImportWsdlSelectorOutputReference;
    /**
     * @stability stable
     */
    putWsdlSelector(value: ApiManagementApiImportWsdlSelector): void;
    /**
     * @stability stable
     */
    resetWsdlSelector(): void;
    /**
     * @stability stable
     */
    get wsdlSelectorInput(): ApiManagementApiImportWsdlSelector | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiOauth2Authorization {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#authorization_server_name ApiManagementApi#authorization_server_name}.
     *
     * @stability stable
     */
    readonly authorizationServerName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#scope ApiManagementApi#scope}.
     *
     * @stability stable
     */
    readonly scope?: string;
}
export declare function apiManagementApiOauth2AuthorizationToTerraform(struct?: ApiManagementApiOauth2AuthorizationOutputReference | ApiManagementApiOauth2Authorization): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiOauth2AuthorizationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiOauth2Authorization | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiOauth2Authorization | undefined);
    private _authorizationServerName?;
    /**
     * @stability stable
     */
    get authorizationServerName(): string;
    /**
     * @stability stable
     */
    set authorizationServerName(value: string);
    /**
     * @stability stable
     */
    get authorizationServerNameInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    resetScope(): void;
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiOpenidAuthentication {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#bearer_token_sending_methods ApiManagementApi#bearer_token_sending_methods}.
     *
     * @stability stable
     */
    readonly bearerTokenSendingMethods?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#openid_provider_name ApiManagementApi#openid_provider_name}.
     *
     * @stability stable
     */
    readonly openidProviderName: string;
}
export declare function apiManagementApiOpenidAuthenticationToTerraform(struct?: ApiManagementApiOpenidAuthenticationOutputReference | ApiManagementApiOpenidAuthentication): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiOpenidAuthenticationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiOpenidAuthentication | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiOpenidAuthentication | undefined);
    private _bearerTokenSendingMethods?;
    /**
     * @stability stable
     */
    get bearerTokenSendingMethods(): string[];
    /**
     * @stability stable
     */
    set bearerTokenSendingMethods(value: string[]);
    /**
     * @stability stable
     */
    resetBearerTokenSendingMethods(): void;
    /**
     * @stability stable
     */
    get bearerTokenSendingMethodsInput(): string[] | undefined;
    private _openidProviderName?;
    /**
     * @stability stable
     */
    get openidProviderName(): string;
    /**
     * @stability stable
     */
    set openidProviderName(value: string);
    /**
     * @stability stable
     */
    get openidProviderNameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiSubscriptionKeyParameterNames {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#header ApiManagementApi#header}.
     *
     * @stability stable
     */
    readonly header: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#query ApiManagementApi#query}.
     *
     * @stability stable
     */
    readonly query: string;
}
export declare function apiManagementApiSubscriptionKeyParameterNamesToTerraform(struct?: ApiManagementApiSubscriptionKeyParameterNamesOutputReference | ApiManagementApiSubscriptionKeyParameterNames): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiSubscriptionKeyParameterNamesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiSubscriptionKeyParameterNames | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiSubscriptionKeyParameterNames | undefined);
    private _header?;
    /**
     * @stability stable
     */
    get header(): string;
    /**
     * @stability stable
     */
    set header(value: string);
    /**
     * @stability stable
     */
    get headerInput(): string | undefined;
    private _query?;
    /**
     * @stability stable
     */
    get query(): string;
    /**
     * @stability stable
     */
    set query(value: string);
    /**
     * @stability stable
     */
    get queryInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementApiTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#create ApiManagementApi#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#delete ApiManagementApi#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#read ApiManagementApi#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html#update ApiManagementApi#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementApiTimeoutsToTerraform(struct?: ApiManagementApiTimeoutsOutputReference | ApiManagementApiTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementApiTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementApiTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementApiTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html azurerm_api_management_api}.
 *
 * @stability stable
 */
export declare class ApiManagementApi extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_api.html azurerm_api_management_api} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementApiConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _displayName?;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    set displayName(value: string);
    /**
     * @stability stable
     */
    resetDisplayName(): void;
    /**
     * @stability stable
     */
    get displayNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get isCurrent(): any;
    /**
     * @stability stable
     */
    get isOnline(): any;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _protocols?;
    /**
     * @stability stable
     */
    get protocols(): string[];
    /**
     * @stability stable
     */
    set protocols(value: string[]);
    /**
     * @stability stable
     */
    resetProtocols(): void;
    /**
     * @stability stable
     */
    get protocolsInput(): string[] | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _revision?;
    /**
     * @stability stable
     */
    get revision(): string;
    /**
     * @stability stable
     */
    set revision(value: string);
    /**
     * @stability stable
     */
    get revisionInput(): string | undefined;
    private _revisionDescription?;
    /**
     * @stability stable
     */
    get revisionDescription(): string;
    /**
     * @stability stable
     */
    set revisionDescription(value: string);
    /**
     * @stability stable
     */
    resetRevisionDescription(): void;
    /**
     * @stability stable
     */
    get revisionDescriptionInput(): string | undefined;
    private _serviceUrl?;
    /**
     * @stability stable
     */
    get serviceUrl(): string;
    /**
     * @stability stable
     */
    set serviceUrl(value: string);
    /**
     * @stability stable
     */
    resetServiceUrl(): void;
    /**
     * @stability stable
     */
    get serviceUrlInput(): string | undefined;
    private _soapPassThrough?;
    /**
     * @stability stable
     */
    get soapPassThrough(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set soapPassThrough(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSoapPassThrough(): void;
    /**
     * @stability stable
     */
    get soapPassThroughInput(): boolean | cdktf.IResolvable | undefined;
    private _sourceApiId?;
    /**
     * @stability stable
     */
    get sourceApiId(): string;
    /**
     * @stability stable
     */
    set sourceApiId(value: string);
    /**
     * @stability stable
     */
    resetSourceApiId(): void;
    /**
     * @stability stable
     */
    get sourceApiIdInput(): string | undefined;
    private _subscriptionRequired?;
    /**
     * @stability stable
     */
    get subscriptionRequired(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set subscriptionRequired(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetSubscriptionRequired(): void;
    /**
     * @stability stable
     */
    get subscriptionRequiredInput(): boolean | cdktf.IResolvable | undefined;
    private _version?;
    /**
     * @stability stable
     */
    get version(): string;
    /**
     * @stability stable
     */
    set version(value: string);
    /**
     * @stability stable
     */
    resetVersion(): void;
    /**
     * @stability stable
     */
    get versionInput(): string | undefined;
    private _versionDescription?;
    /**
     * @stability stable
     */
    get versionDescription(): string;
    /**
     * @stability stable
     */
    set versionDescription(value: string);
    /**
     * @stability stable
     */
    resetVersionDescription(): void;
    /**
     * @stability stable
     */
    get versionDescriptionInput(): string | undefined;
    private _versionSetId?;
    /**
     * @stability stable
     */
    get versionSetId(): string;
    /**
     * @stability stable
     */
    set versionSetId(value: string);
    /**
     * @stability stable
     */
    resetVersionSetId(): void;
    /**
     * @stability stable
     */
    get versionSetIdInput(): string | undefined;
    private _import;
    /**
     * @stability stable
     */
    get import(): ApiManagementApiImportOutputReference;
    /**
     * @stability stable
     */
    putImport(value: ApiManagementApiImport): void;
    /**
     * @stability stable
     */
    resetImport(): void;
    /**
     * @stability stable
     */
    get importInput(): ApiManagementApiImport | undefined;
    private _oauth2Authorization;
    /**
     * @stability stable
     */
    get oauth2Authorization(): ApiManagementApiOauth2AuthorizationOutputReference;
    /**
     * @stability stable
     */
    putOauth2Authorization(value: ApiManagementApiOauth2Authorization): void;
    /**
     * @stability stable
     */
    resetOauth2Authorization(): void;
    /**
     * @stability stable
     */
    get oauth2AuthorizationInput(): ApiManagementApiOauth2Authorization | undefined;
    private _openidAuthentication;
    /**
     * @stability stable
     */
    get openidAuthentication(): ApiManagementApiOpenidAuthenticationOutputReference;
    /**
     * @stability stable
     */
    putOpenidAuthentication(value: ApiManagementApiOpenidAuthentication): void;
    /**
     * @stability stable
     */
    resetOpenidAuthentication(): void;
    /**
     * @stability stable
     */
    get openidAuthenticationInput(): ApiManagementApiOpenidAuthentication | undefined;
    private _subscriptionKeyParameterNames;
    /**
     * @stability stable
     */
    get subscriptionKeyParameterNames(): ApiManagementApiSubscriptionKeyParameterNamesOutputReference;
    /**
     * @stability stable
     */
    putSubscriptionKeyParameterNames(value: ApiManagementApiSubscriptionKeyParameterNames): void;
    /**
     * @stability stable
     */
    resetSubscriptionKeyParameterNames(): void;
    /**
     * @stability stable
     */
    get subscriptionKeyParameterNamesInput(): ApiManagementApiSubscriptionKeyParameterNames | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementApiTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementApiTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementApiTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
