import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementCertificateAConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#api_management_name ApiManagementCertificateA#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#data ApiManagementCertificateA#data}.
     *
     * @stability stable
     */
    readonly data?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#key_vault_identity_client_id ApiManagementCertificateA#key_vault_identity_client_id}.
     *
     * @stability stable
     */
    readonly keyVaultIdentityClientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#key_vault_secret_id ApiManagementCertificateA#key_vault_secret_id}.
     *
     * @stability stable
     */
    readonly keyVaultSecretId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#name ApiManagementCertificateA#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#password ApiManagementCertificateA#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#resource_group_name ApiManagementCertificateA#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#timeouts ApiManagementCertificateA#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementCertificateTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementCertificateTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#create ApiManagementCertificateA#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#delete ApiManagementCertificateA#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#read ApiManagementCertificateA#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html#update ApiManagementCertificateA#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementCertificateTimeoutsToTerraform(struct?: ApiManagementCertificateTimeoutsOutputReference | ApiManagementCertificateTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementCertificateTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementCertificateTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html azurerm_api_management_certificate}.
 *
 * @stability stable
 */
export declare class ApiManagementCertificateA extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_certificate.html azurerm_api_management_certificate} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementCertificateAConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _data?;
    /**
     * @stability stable
     */
    get data(): string;
    /**
     * @stability stable
     */
    set data(value: string);
    /**
     * @stability stable
     */
    resetData(): void;
    /**
     * @stability stable
     */
    get dataInput(): string | undefined;
    /**
     * @stability stable
     */
    get expiration(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _keyVaultIdentityClientId?;
    /**
     * @stability stable
     */
    get keyVaultIdentityClientId(): string;
    /**
     * @stability stable
     */
    set keyVaultIdentityClientId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultIdentityClientId(): void;
    /**
     * @stability stable
     */
    get keyVaultIdentityClientIdInput(): string | undefined;
    private _keyVaultSecretId?;
    /**
     * @stability stable
     */
    get keyVaultSecretId(): string;
    /**
     * @stability stable
     */
    set keyVaultSecretId(value: string);
    /**
     * @stability stable
     */
    resetKeyVaultSecretId(): void;
    /**
     * @stability stable
     */
    get keyVaultSecretIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    get thumbprint(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementCertificateTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementCertificateTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementCertificateTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
