import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementIdentityProviderAadb2CConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#allowed_tenant ApiManagementIdentityProviderAadb2C#allowed_tenant}.
     *
     * @stability stable
     */
    readonly allowedTenant: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#api_management_name ApiManagementIdentityProviderAadb2C#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#authority ApiManagementIdentityProviderAadb2C#authority}.
     *
     * @stability stable
     */
    readonly authority: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#client_id ApiManagementIdentityProviderAadb2C#client_id}.
     *
     * @stability stable
     */
    readonly clientId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#client_secret ApiManagementIdentityProviderAadb2C#client_secret}.
     *
     * @stability stable
     */
    readonly clientSecret: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#password_reset_policy ApiManagementIdentityProviderAadb2C#password_reset_policy}.
     *
     * @stability stable
     */
    readonly passwordResetPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#profile_editing_policy ApiManagementIdentityProviderAadb2C#profile_editing_policy}.
     *
     * @stability stable
     */
    readonly profileEditingPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#resource_group_name ApiManagementIdentityProviderAadb2C#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#signin_policy ApiManagementIdentityProviderAadb2C#signin_policy}.
     *
     * @stability stable
     */
    readonly signinPolicy: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#signin_tenant ApiManagementIdentityProviderAadb2C#signin_tenant}.
     *
     * @stability stable
     */
    readonly signinTenant: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#signup_policy ApiManagementIdentityProviderAadb2C#signup_policy}.
     *
     * @stability stable
     */
    readonly signupPolicy: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#timeouts ApiManagementIdentityProviderAadb2C#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementIdentityProviderAadb2CTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementIdentityProviderAadb2CTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#create ApiManagementIdentityProviderAadb2C#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#delete ApiManagementIdentityProviderAadb2C#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#read ApiManagementIdentityProviderAadb2C#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html#update ApiManagementIdentityProviderAadb2C#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementIdentityProviderAadb2CTimeoutsToTerraform(struct?: ApiManagementIdentityProviderAadb2CTimeoutsOutputReference | ApiManagementIdentityProviderAadb2CTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementIdentityProviderAadb2CTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementIdentityProviderAadb2CTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementIdentityProviderAadb2CTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html azurerm_api_management_identity_provider_aadb2c}.
 *
 * @stability stable
 */
export declare class ApiManagementIdentityProviderAadb2C extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_identity_provider_aadb2c.html azurerm_api_management_identity_provider_aadb2c} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementIdentityProviderAadb2CConfig);
    private _allowedTenant?;
    /**
     * @stability stable
     */
    get allowedTenant(): string;
    /**
     * @stability stable
     */
    set allowedTenant(value: string);
    /**
     * @stability stable
     */
    get allowedTenantInput(): string | undefined;
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _authority?;
    /**
     * @stability stable
     */
    get authority(): string;
    /**
     * @stability stable
     */
    set authority(value: string);
    /**
     * @stability stable
     */
    get authorityInput(): string | undefined;
    private _clientId?;
    /**
     * @stability stable
     */
    get clientId(): string;
    /**
     * @stability stable
     */
    set clientId(value: string);
    /**
     * @stability stable
     */
    get clientIdInput(): string | undefined;
    private _clientSecret?;
    /**
     * @stability stable
     */
    get clientSecret(): string;
    /**
     * @stability stable
     */
    set clientSecret(value: string);
    /**
     * @stability stable
     */
    get clientSecretInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _passwordResetPolicy?;
    /**
     * @stability stable
     */
    get passwordResetPolicy(): string;
    /**
     * @stability stable
     */
    set passwordResetPolicy(value: string);
    /**
     * @stability stable
     */
    resetPasswordResetPolicy(): void;
    /**
     * @stability stable
     */
    get passwordResetPolicyInput(): string | undefined;
    private _profileEditingPolicy?;
    /**
     * @stability stable
     */
    get profileEditingPolicy(): string;
    /**
     * @stability stable
     */
    set profileEditingPolicy(value: string);
    /**
     * @stability stable
     */
    resetProfileEditingPolicy(): void;
    /**
     * @stability stable
     */
    get profileEditingPolicyInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _signinPolicy?;
    /**
     * @stability stable
     */
    get signinPolicy(): string;
    /**
     * @stability stable
     */
    set signinPolicy(value: string);
    /**
     * @stability stable
     */
    get signinPolicyInput(): string | undefined;
    private _signinTenant?;
    /**
     * @stability stable
     */
    get signinTenant(): string;
    /**
     * @stability stable
     */
    set signinTenant(value: string);
    /**
     * @stability stable
     */
    get signinTenantInput(): string | undefined;
    private _signupPolicy?;
    /**
     * @stability stable
     */
    get signupPolicy(): string;
    /**
     * @stability stable
     */
    set signupPolicy(value: string);
    /**
     * @stability stable
     */
    get signupPolicyInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementIdentityProviderAadb2CTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementIdentityProviderAadb2CTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementIdentityProviderAadb2CTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
