import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApiManagementLoggerConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#api_management_name ApiManagementLogger#api_management_name}.
     *
     * @stability stable
     */
    readonly apiManagementName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#buffered ApiManagementLogger#buffered}.
     *
     * @stability stable
     */
    readonly buffered?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#description ApiManagementLogger#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#name ApiManagementLogger#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#resource_group_name ApiManagementLogger#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#resource_id ApiManagementLogger#resource_id}.
     *
     * @stability stable
     */
    readonly resourceId?: string;
    /**
     * application_insights block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#application_insights ApiManagementLogger#application_insights}
     *
     * @stability stable
     */
    readonly applicationInsights?: ApiManagementLoggerApplicationInsights;
    /**
     * eventhub block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#eventhub ApiManagementLogger#eventhub}
     *
     * @stability stable
     */
    readonly eventhub?: ApiManagementLoggerEventhub;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#timeouts ApiManagementLogger#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApiManagementLoggerTimeouts;
}
/**
 * @stability stable
 */
export interface ApiManagementLoggerApplicationInsights {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#instrumentation_key ApiManagementLogger#instrumentation_key}.
     *
     * @stability stable
     */
    readonly instrumentationKey: string;
}
export declare function apiManagementLoggerApplicationInsightsToTerraform(struct?: ApiManagementLoggerApplicationInsightsOutputReference | ApiManagementLoggerApplicationInsights): any;
/**
 * @stability stable
 */
export declare class ApiManagementLoggerApplicationInsightsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementLoggerApplicationInsights | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementLoggerApplicationInsights | undefined);
    private _instrumentationKey?;
    /**
     * @stability stable
     */
    get instrumentationKey(): string;
    /**
     * @stability stable
     */
    set instrumentationKey(value: string);
    /**
     * @stability stable
     */
    get instrumentationKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementLoggerEventhub {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#connection_string ApiManagementLogger#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#name ApiManagementLogger#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function apiManagementLoggerEventhubToTerraform(struct?: ApiManagementLoggerEventhubOutputReference | ApiManagementLoggerEventhub): any;
/**
 * @stability stable
 */
export declare class ApiManagementLoggerEventhubOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementLoggerEventhub | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementLoggerEventhub | undefined);
    private _connectionString?;
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    set connectionString(value: string);
    /**
     * @stability stable
     */
    get connectionStringInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ApiManagementLoggerTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#create ApiManagementLogger#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#delete ApiManagementLogger#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#read ApiManagementLogger#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html#update ApiManagementLogger#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function apiManagementLoggerTimeoutsToTerraform(struct?: ApiManagementLoggerTimeoutsOutputReference | ApiManagementLoggerTimeouts): any;
/**
 * @stability stable
 */
export declare class ApiManagementLoggerTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApiManagementLoggerTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApiManagementLoggerTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html azurerm_api_management_logger}.
 *
 * @stability stable
 */
export declare class ApiManagementLogger extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/api_management_logger.html azurerm_api_management_logger} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApiManagementLoggerConfig);
    private _apiManagementName?;
    /**
     * @stability stable
     */
    get apiManagementName(): string;
    /**
     * @stability stable
     */
    set apiManagementName(value: string);
    /**
     * @stability stable
     */
    get apiManagementNameInput(): string | undefined;
    private _buffered?;
    /**
     * @stability stable
     */
    get buffered(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set buffered(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetBuffered(): void;
    /**
     * @stability stable
     */
    get bufferedInput(): boolean | cdktf.IResolvable | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _resourceId?;
    /**
     * @stability stable
     */
    get resourceId(): string;
    /**
     * @stability stable
     */
    set resourceId(value: string);
    /**
     * @stability stable
     */
    resetResourceId(): void;
    /**
     * @stability stable
     */
    get resourceIdInput(): string | undefined;
    private _applicationInsights;
    /**
     * @stability stable
     */
    get applicationInsights(): ApiManagementLoggerApplicationInsightsOutputReference;
    /**
     * @stability stable
     */
    putApplicationInsights(value: ApiManagementLoggerApplicationInsights): void;
    /**
     * @stability stable
     */
    resetApplicationInsights(): void;
    /**
     * @stability stable
     */
    get applicationInsightsInput(): ApiManagementLoggerApplicationInsights | undefined;
    private _eventhub;
    /**
     * @stability stable
     */
    get eventhub(): ApiManagementLoggerEventhubOutputReference;
    /**
     * @stability stable
     */
    putEventhub(value: ApiManagementLoggerEventhub): void;
    /**
     * @stability stable
     */
    resetEventhub(): void;
    /**
     * @stability stable
     */
    get eventhubInput(): ApiManagementLoggerEventhub | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApiManagementLoggerTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApiManagementLoggerTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApiManagementLoggerTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
