import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ApplicationInsightsAnalyticsItemConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#application_insights_id ApplicationInsightsAnalyticsItem#application_insights_id}.
     *
     * @stability stable
     */
    readonly applicationInsightsId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#content ApplicationInsightsAnalyticsItem#content}.
     *
     * @stability stable
     */
    readonly content: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#function_alias ApplicationInsightsAnalyticsItem#function_alias}.
     *
     * @stability stable
     */
    readonly functionAlias?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#name ApplicationInsightsAnalyticsItem#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#scope ApplicationInsightsAnalyticsItem#scope}.
     *
     * @stability stable
     */
    readonly scope: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#type ApplicationInsightsAnalyticsItem#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#timeouts ApplicationInsightsAnalyticsItem#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ApplicationInsightsAnalyticsItemTimeouts;
}
/**
 * @stability stable
 */
export interface ApplicationInsightsAnalyticsItemTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#create ApplicationInsightsAnalyticsItem#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#delete ApplicationInsightsAnalyticsItem#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#read ApplicationInsightsAnalyticsItem#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html#update ApplicationInsightsAnalyticsItem#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function applicationInsightsAnalyticsItemTimeoutsToTerraform(struct?: ApplicationInsightsAnalyticsItemTimeoutsOutputReference | ApplicationInsightsAnalyticsItemTimeouts): any;
/**
 * @stability stable
 */
export declare class ApplicationInsightsAnalyticsItemTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ApplicationInsightsAnalyticsItemTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ApplicationInsightsAnalyticsItemTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html azurerm_application_insights_analytics_item}.
 *
 * @stability stable
 */
export declare class ApplicationInsightsAnalyticsItem extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/application_insights_analytics_item.html azurerm_application_insights_analytics_item} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ApplicationInsightsAnalyticsItemConfig);
    private _applicationInsightsId?;
    /**
     * @stability stable
     */
    get applicationInsightsId(): string;
    /**
     * @stability stable
     */
    set applicationInsightsId(value: string);
    /**
     * @stability stable
     */
    get applicationInsightsIdInput(): string | undefined;
    private _content?;
    /**
     * @stability stable
     */
    get content(): string;
    /**
     * @stability stable
     */
    set content(value: string);
    /**
     * @stability stable
     */
    get contentInput(): string | undefined;
    private _functionAlias?;
    /**
     * @stability stable
     */
    get functionAlias(): string;
    /**
     * @stability stable
     */
    set functionAlias(value: string);
    /**
     * @stability stable
     */
    resetFunctionAlias(): void;
    /**
     * @stability stable
     */
    get functionAliasInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _scope?;
    /**
     * @stability stable
     */
    get scope(): string;
    /**
     * @stability stable
     */
    set scope(value: string);
    /**
     * @stability stable
     */
    get scopeInput(): string | undefined;
    /**
     * @stability stable
     */
    get timeCreated(): string;
    /**
     * @stability stable
     */
    get timeModified(): string;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
    /**
     * @stability stable
     */
    get version(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ApplicationInsightsAnalyticsItemTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ApplicationInsightsAnalyticsItemTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ApplicationInsightsAnalyticsItemTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
