import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BlueprintAssignmentConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#location BlueprintAssignment#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#lock_exclude_principals BlueprintAssignment#lock_exclude_principals}.
     *
     * @stability stable
     */
    readonly lockExcludePrincipals?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#lock_mode BlueprintAssignment#lock_mode}.
     *
     * @stability stable
     */
    readonly lockMode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#name BlueprintAssignment#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#parameter_values BlueprintAssignment#parameter_values}.
     *
     * @stability stable
     */
    readonly parameterValues?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#resource_groups BlueprintAssignment#resource_groups}.
     *
     * @stability stable
     */
    readonly resourceGroups?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#target_subscription_id BlueprintAssignment#target_subscription_id}.
     *
     * @stability stable
     */
    readonly targetSubscriptionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#version_id BlueprintAssignment#version_id}.
     *
     * @stability stable
     */
    readonly versionId: string;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#identity BlueprintAssignment#identity}
     *
     * @stability stable
     */
    readonly identity?: BlueprintAssignmentIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#timeouts BlueprintAssignment#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BlueprintAssignmentTimeouts;
}
/**
 * @stability stable
 */
export interface BlueprintAssignmentIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#identity_ids BlueprintAssignment#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#type BlueprintAssignment#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function blueprintAssignmentIdentityToTerraform(struct?: BlueprintAssignmentIdentityOutputReference | BlueprintAssignmentIdentity): any;
/**
 * @stability stable
 */
export declare class BlueprintAssignmentIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BlueprintAssignmentIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BlueprintAssignmentIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface BlueprintAssignmentTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#create BlueprintAssignment#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#delete BlueprintAssignment#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#read BlueprintAssignment#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html#update BlueprintAssignment#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function blueprintAssignmentTimeoutsToTerraform(struct?: BlueprintAssignmentTimeoutsOutputReference | BlueprintAssignmentTimeouts): any;
/**
 * @stability stable
 */
export declare class BlueprintAssignmentTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BlueprintAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BlueprintAssignmentTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html azurerm_blueprint_assignment}.
 *
 * @stability stable
 */
export declare class BlueprintAssignment extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/blueprint_assignment.html azurerm_blueprint_assignment} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BlueprintAssignmentConfig);
    /**
     * @stability stable
     */
    get blueprintName(): string;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _lockExcludePrincipals?;
    /**
     * @stability stable
     */
    get lockExcludePrincipals(): string[];
    /**
     * @stability stable
     */
    set lockExcludePrincipals(value: string[]);
    /**
     * @stability stable
     */
    resetLockExcludePrincipals(): void;
    /**
     * @stability stable
     */
    get lockExcludePrincipalsInput(): string[] | undefined;
    private _lockMode?;
    /**
     * @stability stable
     */
    get lockMode(): string;
    /**
     * @stability stable
     */
    set lockMode(value: string);
    /**
     * @stability stable
     */
    resetLockMode(): void;
    /**
     * @stability stable
     */
    get lockModeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameterValues?;
    /**
     * @stability stable
     */
    get parameterValues(): string;
    /**
     * @stability stable
     */
    set parameterValues(value: string);
    /**
     * @stability stable
     */
    resetParameterValues(): void;
    /**
     * @stability stable
     */
    get parameterValuesInput(): string | undefined;
    private _resourceGroups?;
    /**
     * @stability stable
     */
    get resourceGroups(): string;
    /**
     * @stability stable
     */
    set resourceGroups(value: string);
    /**
     * @stability stable
     */
    resetResourceGroups(): void;
    /**
     * @stability stable
     */
    get resourceGroupsInput(): string | undefined;
    private _targetSubscriptionId?;
    /**
     * @stability stable
     */
    get targetSubscriptionId(): string;
    /**
     * @stability stable
     */
    set targetSubscriptionId(value: string);
    /**
     * @stability stable
     */
    get targetSubscriptionIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get type(): string;
    private _versionId?;
    /**
     * @stability stable
     */
    get versionId(): string;
    /**
     * @stability stable
     */
    set versionId(value: string);
    /**
     * @stability stable
     */
    get versionIdInput(): string | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): BlueprintAssignmentIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: BlueprintAssignmentIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): BlueprintAssignmentIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BlueprintAssignmentTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BlueprintAssignmentTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BlueprintAssignmentTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
