import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface BotChannelSmsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#bot_name BotChannelSms#bot_name}.
     *
     * @stability stable
     */
    readonly botName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#location BotChannelSms#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#phone_number BotChannelSms#phone_number}.
     *
     * @stability stable
     */
    readonly phoneNumber: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#resource_group_name BotChannelSms#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#sms_channel_account_security_id BotChannelSms#sms_channel_account_security_id}.
     *
     * @stability stable
     */
    readonly smsChannelAccountSecurityId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#sms_channel_auth_token BotChannelSms#sms_channel_auth_token}.
     *
     * @stability stable
     */
    readonly smsChannelAuthToken: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#timeouts BotChannelSms#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: BotChannelSmsTimeouts;
}
/**
 * @stability stable
 */
export interface BotChannelSmsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#create BotChannelSms#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#delete BotChannelSms#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#read BotChannelSms#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html#update BotChannelSms#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function botChannelSmsTimeoutsToTerraform(struct?: BotChannelSmsTimeoutsOutputReference | BotChannelSmsTimeouts): any;
/**
 * @stability stable
 */
export declare class BotChannelSmsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): BotChannelSmsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: BotChannelSmsTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html azurerm_bot_channel_sms}.
 *
 * @stability stable
 */
export declare class BotChannelSms extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/bot_channel_sms.html azurerm_bot_channel_sms} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: BotChannelSmsConfig);
    private _botName?;
    /**
     * @stability stable
     */
    get botName(): string;
    /**
     * @stability stable
     */
    set botName(value: string);
    /**
     * @stability stable
     */
    get botNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _phoneNumber?;
    /**
     * @stability stable
     */
    get phoneNumber(): string;
    /**
     * @stability stable
     */
    set phoneNumber(value: string);
    /**
     * @stability stable
     */
    get phoneNumberInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _smsChannelAccountSecurityId?;
    /**
     * @stability stable
     */
    get smsChannelAccountSecurityId(): string;
    /**
     * @stability stable
     */
    set smsChannelAccountSecurityId(value: string);
    /**
     * @stability stable
     */
    get smsChannelAccountSecurityIdInput(): string | undefined;
    private _smsChannelAuthToken?;
    /**
     * @stability stable
     */
    get smsChannelAuthToken(): string;
    /**
     * @stability stable
     */
    set smsChannelAuthToken(value: string);
    /**
     * @stability stable
     */
    get smsChannelAuthTokenInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): BotChannelSmsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: BotChannelSmsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): BotChannelSmsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
