import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#amount ConsumptionBudgetSubscription#amount}.
     *
     * @stability stable
     */
    readonly amount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#etag ConsumptionBudgetSubscription#etag}.
     *
     * @stability stable
     */
    readonly etag?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#name ConsumptionBudgetSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#subscription_id ConsumptionBudgetSubscription#subscription_id}.
     *
     * @stability stable
     */
    readonly subscriptionId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#time_grain ConsumptionBudgetSubscription#time_grain}.
     *
     * @stability stable
     */
    readonly timeGrain?: string;
    /**
     * filter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#filter ConsumptionBudgetSubscription#filter}
     *
     * @stability stable
     */
    readonly filter?: ConsumptionBudgetSubscriptionFilter;
    /**
     * notification block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#notification ConsumptionBudgetSubscription#notification}
     *
     * @stability stable
     */
    readonly notification: ConsumptionBudgetSubscriptionNotification[];
    /**
     * time_period block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#time_period ConsumptionBudgetSubscription#time_period}
     *
     * @stability stable
     */
    readonly timePeriod: ConsumptionBudgetSubscriptionTimePeriod;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#timeouts ConsumptionBudgetSubscription#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ConsumptionBudgetSubscriptionTimeouts;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionFilterDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#name ConsumptionBudgetSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#operator ConsumptionBudgetSubscription#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#values ConsumptionBudgetSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterDimensionToTerraform(struct?: ConsumptionBudgetSubscriptionFilterDimension): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionFilterNotDimension {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#name ConsumptionBudgetSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#operator ConsumptionBudgetSubscription#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#values ConsumptionBudgetSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterNotDimensionToTerraform(struct?: ConsumptionBudgetSubscriptionFilterNotDimensionOutputReference | ConsumptionBudgetSubscriptionFilterNotDimension): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetSubscriptionFilterNotDimensionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetSubscriptionFilterNotDimension | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetSubscriptionFilterNotDimension | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionFilterNotTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#name ConsumptionBudgetSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#operator ConsumptionBudgetSubscription#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#values ConsumptionBudgetSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterNotTagToTerraform(struct?: ConsumptionBudgetSubscriptionFilterNotTagOutputReference | ConsumptionBudgetSubscriptionFilterNotTag): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetSubscriptionFilterNotTagOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetSubscriptionFilterNotTag | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetSubscriptionFilterNotTag | undefined);
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _operator?;
    /**
     * @stability stable
     */
    get operator(): string;
    /**
     * @stability stable
     */
    set operator(value: string);
    /**
     * @stability stable
     */
    resetOperator(): void;
    /**
     * @stability stable
     */
    get operatorInput(): string | undefined;
    private _values?;
    /**
     * @stability stable
     */
    get values(): string[];
    /**
     * @stability stable
     */
    set values(value: string[]);
    /**
     * @stability stable
     */
    get valuesInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionFilterNot {
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#dimension ConsumptionBudgetSubscription#dimension}
     *
     * @stability stable
     */
    readonly dimension?: ConsumptionBudgetSubscriptionFilterNotDimension;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#tag ConsumptionBudgetSubscription#tag}
     *
     * @stability stable
     */
    readonly tag?: ConsumptionBudgetSubscriptionFilterNotTag;
}
export declare function consumptionBudgetSubscriptionFilterNotToTerraform(struct?: ConsumptionBudgetSubscriptionFilterNotOutputReference | ConsumptionBudgetSubscriptionFilterNot): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetSubscriptionFilterNotOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetSubscriptionFilterNot | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetSubscriptionFilterNot | undefined);
    private _dimension;
    /**
     * @stability stable
     */
    get dimension(): ConsumptionBudgetSubscriptionFilterNotDimensionOutputReference;
    /**
     * @stability stable
     */
    putDimension(value: ConsumptionBudgetSubscriptionFilterNotDimension): void;
    /**
     * @stability stable
     */
    resetDimension(): void;
    /**
     * @stability stable
     */
    get dimensionInput(): ConsumptionBudgetSubscriptionFilterNotDimension | undefined;
    private _tag;
    /**
     * @stability stable
     */
    get tag(): ConsumptionBudgetSubscriptionFilterNotTagOutputReference;
    /**
     * @stability stable
     */
    putTag(value: ConsumptionBudgetSubscriptionFilterNotTag): void;
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): ConsumptionBudgetSubscriptionFilterNotTag | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionFilterTag {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#name ConsumptionBudgetSubscription#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#operator ConsumptionBudgetSubscription#operator}.
     *
     * @stability stable
     */
    readonly operator?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#values ConsumptionBudgetSubscription#values}.
     *
     * @stability stable
     */
    readonly values: string[];
}
export declare function consumptionBudgetSubscriptionFilterTagToTerraform(struct?: ConsumptionBudgetSubscriptionFilterTag): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionFilter {
    /**
     * dimension block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#dimension ConsumptionBudgetSubscription#dimension}
     *
     * @stability stable
     */
    readonly dimension?: ConsumptionBudgetSubscriptionFilterDimension[];
    /**
     * not block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#not ConsumptionBudgetSubscription#not}
     *
     * @stability stable
     */
    readonly not?: ConsumptionBudgetSubscriptionFilterNot;
    /**
     * tag block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#tag ConsumptionBudgetSubscription#tag}
     *
     * @stability stable
     */
    readonly tag?: ConsumptionBudgetSubscriptionFilterTag[];
}
export declare function consumptionBudgetSubscriptionFilterToTerraform(struct?: ConsumptionBudgetSubscriptionFilterOutputReference | ConsumptionBudgetSubscriptionFilter): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetSubscriptionFilterOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetSubscriptionFilter | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetSubscriptionFilter | undefined);
    private _dimension?;
    /**
     * @stability stable
     */
    get dimension(): ConsumptionBudgetSubscriptionFilterDimension[];
    /**
     * @stability stable
     */
    set dimension(value: ConsumptionBudgetSubscriptionFilterDimension[]);
    /**
     * @stability stable
     */
    resetDimension(): void;
    /**
     * @stability stable
     */
    get dimensionInput(): ConsumptionBudgetSubscriptionFilterDimension[] | undefined;
    private _not;
    /**
     * @stability stable
     */
    get not(): ConsumptionBudgetSubscriptionFilterNotOutputReference;
    /**
     * @stability stable
     */
    putNot(value: ConsumptionBudgetSubscriptionFilterNot): void;
    /**
     * @stability stable
     */
    resetNot(): void;
    /**
     * @stability stable
     */
    get notInput(): ConsumptionBudgetSubscriptionFilterNot | undefined;
    private _tag?;
    /**
     * @stability stable
     */
    get tag(): ConsumptionBudgetSubscriptionFilterTag[];
    /**
     * @stability stable
     */
    set tag(value: ConsumptionBudgetSubscriptionFilterTag[]);
    /**
     * @stability stable
     */
    resetTag(): void;
    /**
     * @stability stable
     */
    get tagInput(): ConsumptionBudgetSubscriptionFilterTag[] | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionNotification {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#contact_emails ConsumptionBudgetSubscription#contact_emails}.
     *
     * @stability stable
     */
    readonly contactEmails?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#contact_groups ConsumptionBudgetSubscription#contact_groups}.
     *
     * @stability stable
     */
    readonly contactGroups?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#contact_roles ConsumptionBudgetSubscription#contact_roles}.
     *
     * @stability stable
     */
    readonly contactRoles?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#enabled ConsumptionBudgetSubscription#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#operator ConsumptionBudgetSubscription#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#threshold ConsumptionBudgetSubscription#threshold}.
     *
     * @stability stable
     */
    readonly threshold: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#threshold_type ConsumptionBudgetSubscription#threshold_type}.
     *
     * @stability stable
     */
    readonly thresholdType?: string;
}
export declare function consumptionBudgetSubscriptionNotificationToTerraform(struct?: ConsumptionBudgetSubscriptionNotification): any;
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionTimePeriod {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#end_date ConsumptionBudgetSubscription#end_date}.
     *
     * @stability stable
     */
    readonly endDate?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#start_date ConsumptionBudgetSubscription#start_date}.
     *
     * @stability stable
     */
    readonly startDate: string;
}
export declare function consumptionBudgetSubscriptionTimePeriodToTerraform(struct?: ConsumptionBudgetSubscriptionTimePeriodOutputReference | ConsumptionBudgetSubscriptionTimePeriod): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetSubscriptionTimePeriodOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetSubscriptionTimePeriod | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetSubscriptionTimePeriod | undefined);
    private _endDate?;
    /**
     * @stability stable
     */
    get endDate(): string;
    /**
     * @stability stable
     */
    set endDate(value: string);
    /**
     * @stability stable
     */
    resetEndDate(): void;
    /**
     * @stability stable
     */
    get endDateInput(): string | undefined;
    private _startDate?;
    /**
     * @stability stable
     */
    get startDate(): string;
    /**
     * @stability stable
     */
    set startDate(value: string);
    /**
     * @stability stable
     */
    get startDateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ConsumptionBudgetSubscriptionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#create ConsumptionBudgetSubscription#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#delete ConsumptionBudgetSubscription#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#read ConsumptionBudgetSubscription#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html#update ConsumptionBudgetSubscription#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function consumptionBudgetSubscriptionTimeoutsToTerraform(struct?: ConsumptionBudgetSubscriptionTimeoutsOutputReference | ConsumptionBudgetSubscriptionTimeouts): any;
/**
 * @stability stable
 */
export declare class ConsumptionBudgetSubscriptionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ConsumptionBudgetSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ConsumptionBudgetSubscriptionTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html azurerm_consumption_budget_subscription}.
 *
 * @stability stable
 */
export declare class ConsumptionBudgetSubscription extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/consumption_budget_subscription.html azurerm_consumption_budget_subscription} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ConsumptionBudgetSubscriptionConfig);
    private _amount?;
    /**
     * @stability stable
     */
    get amount(): number;
    /**
     * @stability stable
     */
    set amount(value: number);
    /**
     * @stability stable
     */
    get amountInput(): number | undefined;
    private _etag?;
    /**
     * @stability stable
     */
    get etag(): string;
    /**
     * @stability stable
     */
    set etag(value: string);
    /**
     * @stability stable
     */
    resetEtag(): void;
    /**
     * @stability stable
     */
    get etagInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _subscriptionId?;
    /**
     * @stability stable
     */
    get subscriptionId(): string;
    /**
     * @stability stable
     */
    set subscriptionId(value: string);
    /**
     * @stability stable
     */
    get subscriptionIdInput(): string | undefined;
    private _timeGrain?;
    /**
     * @stability stable
     */
    get timeGrain(): string;
    /**
     * @stability stable
     */
    set timeGrain(value: string);
    /**
     * @stability stable
     */
    resetTimeGrain(): void;
    /**
     * @stability stable
     */
    get timeGrainInput(): string | undefined;
    private _filter;
    /**
     * @stability stable
     */
    get filter(): ConsumptionBudgetSubscriptionFilterOutputReference;
    /**
     * @stability stable
     */
    putFilter(value: ConsumptionBudgetSubscriptionFilter): void;
    /**
     * @stability stable
     */
    resetFilter(): void;
    /**
     * @stability stable
     */
    get filterInput(): ConsumptionBudgetSubscriptionFilter | undefined;
    private _notification?;
    /**
     * @stability stable
     */
    get notification(): ConsumptionBudgetSubscriptionNotification[];
    /**
     * @stability stable
     */
    set notification(value: ConsumptionBudgetSubscriptionNotification[]);
    /**
     * @stability stable
     */
    get notificationInput(): ConsumptionBudgetSubscriptionNotification[] | undefined;
    private _timePeriod;
    /**
     * @stability stable
     */
    get timePeriod(): ConsumptionBudgetSubscriptionTimePeriodOutputReference;
    /**
     * @stability stable
     */
    putTimePeriod(value: ConsumptionBudgetSubscriptionTimePeriod): void;
    /**
     * @stability stable
     */
    get timePeriodInput(): ConsumptionBudgetSubscriptionTimePeriod | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ConsumptionBudgetSubscriptionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ConsumptionBudgetSubscriptionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ConsumptionBudgetSubscriptionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
