import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ContainerRegistryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#admin_enabled ContainerRegistry#admin_enabled}.
     *
     * @stability stable
     */
    readonly adminEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#anonymous_pull_enabled ContainerRegistry#anonymous_pull_enabled}.
     *
     * @stability stable
     */
    readonly anonymousPullEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#data_endpoint_enabled ContainerRegistry#data_endpoint_enabled}.
     *
     * @stability stable
     */
    readonly dataEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#encryption ContainerRegistry#encryption}.
     *
     * @stability stable
     */
    readonly encryption?: ContainerRegistryEncryption[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#georeplication_locations ContainerRegistry#georeplication_locations}.
     *
     * @stability stable
     */
    readonly georeplicationLocations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#georeplications ContainerRegistry#georeplications}.
     *
     * @stability stable
     */
    readonly georeplications?: ContainerRegistryGeoreplications[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#location ContainerRegistry#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#name ContainerRegistry#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#network_rule_bypass_option ContainerRegistry#network_rule_bypass_option}.
     *
     * @stability stable
     */
    readonly networkRuleBypassOption?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#network_rule_set ContainerRegistry#network_rule_set}.
     *
     * @stability stable
     */
    readonly networkRuleSet?: ContainerRegistryNetworkRuleSet[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#public_network_access_enabled ContainerRegistry#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#quarantine_policy_enabled ContainerRegistry#quarantine_policy_enabled}.
     *
     * @stability stable
     */
    readonly quarantinePolicyEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#resource_group_name ContainerRegistry#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#retention_policy ContainerRegistry#retention_policy}.
     *
     * @stability stable
     */
    readonly retentionPolicy?: ContainerRegistryRetentionPolicy[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#sku ContainerRegistry#sku}.
     *
     * @stability stable
     */
    readonly sku?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#storage_account_id ContainerRegistry#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#tags ContainerRegistry#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#trust_policy ContainerRegistry#trust_policy}.
     *
     * @stability stable
     */
    readonly trustPolicy?: ContainerRegistryTrustPolicy[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#zone_redundancy_enabled ContainerRegistry#zone_redundancy_enabled}.
     *
     * @stability stable
     */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#identity ContainerRegistry#identity}
     *
     * @stability stable
     */
    readonly identity?: ContainerRegistryIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#timeouts ContainerRegistry#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ContainerRegistryTimeouts;
}
/**
 * @stability stable
 */
export interface ContainerRegistryEncryption {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#enabled ContainerRegistry#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#identity_client_id ContainerRegistry#identity_client_id}.
     *
     * @stability stable
     */
    readonly identityClientId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#key_vault_key_id ContainerRegistry#key_vault_key_id}.
     *
     * @stability stable
     */
    readonly keyVaultKeyId?: string;
}
export declare function containerRegistryEncryptionToTerraform(struct?: ContainerRegistryEncryption): any;
/**
 * @stability stable
 */
export interface ContainerRegistryGeoreplications {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#location ContainerRegistry#location}.
     *
     * @stability stable
     */
    readonly location?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#regional_endpoint_enabled ContainerRegistry#regional_endpoint_enabled}.
     *
     * @stability stable
     */
    readonly regionalEndpointEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#tags ContainerRegistry#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#zone_redundancy_enabled ContainerRegistry#zone_redundancy_enabled}.
     *
     * @stability stable
     */
    readonly zoneRedundancyEnabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryGeoreplicationsToTerraform(struct?: ContainerRegistryGeoreplications): any;
/**
 * @stability stable
 */
export interface ContainerRegistryNetworkRuleSetIpRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#action ContainerRegistry#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#ip_range ContainerRegistry#ip_range}.
     *
     * @stability stable
     */
    readonly ipRange?: string;
}
export declare function containerRegistryNetworkRuleSetIpRuleToTerraform(struct?: ContainerRegistryNetworkRuleSetIpRule): any;
/**
 * @stability stable
 */
export interface ContainerRegistryNetworkRuleSetVirtualNetwork {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#action ContainerRegistry#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#subnet_id ContainerRegistry#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
}
export declare function containerRegistryNetworkRuleSetVirtualNetworkToTerraform(struct?: ContainerRegistryNetworkRuleSetVirtualNetwork): any;
/**
 * @stability stable
 */
export interface ContainerRegistryNetworkRuleSet {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#default_action ContainerRegistry#default_action}.
     *
     * @stability stable
     */
    readonly defaultAction?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#ip_rule ContainerRegistry#ip_rule}.
     *
     * @stability stable
     */
    readonly ipRule?: ContainerRegistryNetworkRuleSetIpRule[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#virtual_network ContainerRegistry#virtual_network}.
     *
     * @stability stable
     */
    readonly virtualNetwork?: ContainerRegistryNetworkRuleSetVirtualNetwork[];
}
export declare function containerRegistryNetworkRuleSetToTerraform(struct?: ContainerRegistryNetworkRuleSet): any;
/**
 * @stability stable
 */
export interface ContainerRegistryRetentionPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#days ContainerRegistry#days}.
     *
     * @stability stable
     */
    readonly days?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#enabled ContainerRegistry#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryRetentionPolicyToTerraform(struct?: ContainerRegistryRetentionPolicy): any;
/**
 * @stability stable
 */
export interface ContainerRegistryTrustPolicy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#enabled ContainerRegistry#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
}
export declare function containerRegistryTrustPolicyToTerraform(struct?: ContainerRegistryTrustPolicy): any;
/**
 * @stability stable
 */
export interface ContainerRegistryIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#identity_ids ContainerRegistry#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#type ContainerRegistry#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function containerRegistryIdentityToTerraform(struct?: ContainerRegistryIdentityOutputReference | ContainerRegistryIdentity): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface ContainerRegistryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#create ContainerRegistry#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#delete ContainerRegistry#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#read ContainerRegistry#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html#update ContainerRegistry#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function containerRegistryTimeoutsToTerraform(struct?: ContainerRegistryTimeoutsOutputReference | ContainerRegistryTimeouts): any;
/**
 * @stability stable
 */
export declare class ContainerRegistryTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ContainerRegistryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ContainerRegistryTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html azurerm_container_registry}.
 *
 * @stability stable
 */
export declare class ContainerRegistry extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/container_registry.html azurerm_container_registry} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ContainerRegistryConfig);
    private _adminEnabled?;
    /**
     * @stability stable
     */
    get adminEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set adminEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdminEnabled(): void;
    /**
     * @stability stable
     */
    get adminEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get adminPassword(): string;
    /**
     * @stability stable
     */
    get adminUsername(): string;
    private _anonymousPullEnabled?;
    /**
     * @stability stable
     */
    get anonymousPullEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set anonymousPullEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAnonymousPullEnabled(): void;
    /**
     * @stability stable
     */
    get anonymousPullEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dataEndpointEnabled?;
    /**
     * @stability stable
     */
    get dataEndpointEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dataEndpointEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDataEndpointEnabled(): void;
    /**
     * @stability stable
     */
    get dataEndpointEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _encryption?;
    /**
     * @stability stable
     */
    get encryption(): ContainerRegistryEncryption[];
    /**
     * @stability stable
     */
    set encryption(value: ContainerRegistryEncryption[]);
    /**
     * @stability stable
     */
    resetEncryption(): void;
    /**
     * @stability stable
     */
    get encryptionInput(): ContainerRegistryEncryption[] | undefined;
    private _georeplicationLocations?;
    /**
     * @stability stable
     */
    get georeplicationLocations(): string[];
    /**
     * @stability stable
     */
    set georeplicationLocations(value: string[]);
    /**
     * @stability stable
     */
    resetGeoreplicationLocations(): void;
    /**
     * @stability stable
     */
    get georeplicationLocationsInput(): string[] | undefined;
    private _georeplications?;
    /**
     * @stability stable
     */
    get georeplications(): ContainerRegistryGeoreplications[];
    /**
     * @stability stable
     */
    set georeplications(value: ContainerRegistryGeoreplications[]);
    /**
     * @stability stable
     */
    resetGeoreplications(): void;
    /**
     * @stability stable
     */
    get georeplicationsInput(): ContainerRegistryGeoreplications[] | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    /**
     * @stability stable
     */
    get loginServer(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _networkRuleBypassOption?;
    /**
     * @stability stable
     */
    get networkRuleBypassOption(): string;
    /**
     * @stability stable
     */
    set networkRuleBypassOption(value: string);
    /**
     * @stability stable
     */
    resetNetworkRuleBypassOption(): void;
    /**
     * @stability stable
     */
    get networkRuleBypassOptionInput(): string | undefined;
    private _networkRuleSet?;
    /**
     * @stability stable
     */
    get networkRuleSet(): ContainerRegistryNetworkRuleSet[];
    /**
     * @stability stable
     */
    set networkRuleSet(value: ContainerRegistryNetworkRuleSet[]);
    /**
     * @stability stable
     */
    resetNetworkRuleSet(): void;
    /**
     * @stability stable
     */
    get networkRuleSetInput(): ContainerRegistryNetworkRuleSet[] | undefined;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _quarantinePolicyEnabled?;
    /**
     * @stability stable
     */
    get quarantinePolicyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set quarantinePolicyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetQuarantinePolicyEnabled(): void;
    /**
     * @stability stable
     */
    get quarantinePolicyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _retentionPolicy?;
    /**
     * @stability stable
     */
    get retentionPolicy(): ContainerRegistryRetentionPolicy[];
    /**
     * @stability stable
     */
    set retentionPolicy(value: ContainerRegistryRetentionPolicy[]);
    /**
     * @stability stable
     */
    resetRetentionPolicy(): void;
    /**
     * @stability stable
     */
    get retentionPolicyInput(): ContainerRegistryRetentionPolicy[] | undefined;
    private _sku?;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    set sku(value: string);
    /**
     * @stability stable
     */
    resetSku(): void;
    /**
     * @stability stable
     */
    get skuInput(): string | undefined;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    resetStorageAccountId(): void;
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _trustPolicy?;
    /**
     * @stability stable
     */
    get trustPolicy(): ContainerRegistryTrustPolicy[];
    /**
     * @stability stable
     */
    set trustPolicy(value: ContainerRegistryTrustPolicy[]);
    /**
     * @stability stable
     */
    resetTrustPolicy(): void;
    /**
     * @stability stable
     */
    get trustPolicyInput(): ContainerRegistryTrustPolicy[] | undefined;
    private _zoneRedundancyEnabled?;
    /**
     * @stability stable
     */
    get zoneRedundancyEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneRedundancyEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneRedundancyEnabled(): void;
    /**
     * @stability stable
     */
    get zoneRedundancyEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): ContainerRegistryIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: ContainerRegistryIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): ContainerRegistryIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ContainerRegistryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ContainerRegistryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ContainerRegistryTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
