import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermAppConfigurationConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration.html#name DataAzurermAppConfiguration#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration.html#resource_group_name DataAzurermAppConfiguration#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration.html#timeouts DataAzurermAppConfiguration#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermAppConfigurationTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppConfigurationPrimaryReadKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get secret(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppConfigurationPrimaryWriteKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get secret(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppConfigurationSecondaryReadKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get secret(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermAppConfigurationSecondaryWriteKey extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get connectionString(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get secret(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermAppConfigurationTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration.html#read DataAzurermAppConfiguration#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermAppConfigurationTimeoutsToTerraform(struct?: DataAzurermAppConfigurationTimeoutsOutputReference | DataAzurermAppConfigurationTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermAppConfigurationTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermAppConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermAppConfigurationTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration.html azurerm_app_configuration}.
 *
 * @stability stable
 */
export declare class DataAzurermAppConfiguration extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/app_configuration.html azurerm_app_configuration} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermAppConfigurationConfig);
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    primaryReadKey(index: string): DataAzurermAppConfigurationPrimaryReadKey;
    /**
     * @stability stable
     */
    primaryWriteKey(index: string): DataAzurermAppConfigurationPrimaryWriteKey;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    secondaryReadKey(index: string): DataAzurermAppConfigurationSecondaryReadKey;
    /**
     * @stability stable
     */
    secondaryWriteKey(index: string): DataAzurermAppConfigurationSecondaryWriteKey;
    /**
     * @stability stable
     */
    get sku(): string;
    /**
     * @stability stable
     */
    tags(key: string): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermAppConfigurationTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermAppConfigurationTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermAppConfigurationTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
