import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetKustoDatabaseConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database.html#name DataAzurermDataShareDatasetKustoDatabase#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database.html#share_id DataAzurermDataShareDatasetKustoDatabase#share_id}.
     *
     * @stability stable
     */
    readonly shareId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database.html#timeouts DataAzurermDataShareDatasetKustoDatabase#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermDataShareDatasetKustoDatabaseTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermDataShareDatasetKustoDatabaseTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database.html#read DataAzurermDataShareDatasetKustoDatabase#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermDataShareDatasetKustoDatabaseTimeoutsToTerraform(struct?: DataAzurermDataShareDatasetKustoDatabaseTimeoutsOutputReference | DataAzurermDataShareDatasetKustoDatabaseTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetKustoDatabaseTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermDataShareDatasetKustoDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermDataShareDatasetKustoDatabaseTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database.html azurerm_data_share_dataset_kusto_database}.
 *
 * @stability stable
 */
export declare class DataAzurermDataShareDatasetKustoDatabase extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/data_share_dataset_kusto_database.html azurerm_data_share_dataset_kusto_database} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermDataShareDatasetKustoDatabaseConfig);
    /**
     * @stability stable
     */
    get displayName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kustoClusterLocation(): string;
    /**
     * @stability stable
     */
    get kustoDatabaseId(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _shareId?;
    /**
     * @stability stable
     */
    get shareId(): string;
    /**
     * @stability stable
     */
    set shareId(value: string);
    /**
     * @stability stable
     */
    get shareIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermDataShareDatasetKustoDatabaseTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermDataShareDatasetKustoDatabaseTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermDataShareDatasetKustoDatabaseTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
