import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermEventgridDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#inbound_ip_rule DataAzurermEventgridDomain#inbound_ip_rule}.
     *
     * @stability stable
     */
    readonly inboundIpRule?: DataAzurermEventgridDomainInboundIpRule[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#name DataAzurermEventgridDomain#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#public_network_access_enabled DataAzurermEventgridDomain#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#resource_group_name DataAzurermEventgridDomain#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#tags DataAzurermEventgridDomain#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#timeouts DataAzurermEventgridDomain#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermEventgridDomainTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermEventgridDomainInboundIpRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#action DataAzurermEventgridDomain#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#ip_mask DataAzurermEventgridDomain#ip_mask}.
     *
     * @stability stable
     */
    readonly ipMask?: string;
}
export declare function dataAzurermEventgridDomainInboundIpRuleToTerraform(struct?: DataAzurermEventgridDomainInboundIpRule): any;
/**
 * @stability stable
 */
export declare class DataAzurermEventgridDomainInputMappingDefaultValues extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dataVersion(): string;
    /**
     * @stability stable
     */
    get eventType(): string;
    /**
     * @stability stable
     */
    get subject(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermEventgridDomainInputMappingFields extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get dataVersion(): string;
    /**
     * @stability stable
     */
    get eventTime(): string;
    /**
     * @stability stable
     */
    get eventType(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    get topic(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermEventgridDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html#read DataAzurermEventgridDomain#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermEventgridDomainTimeoutsToTerraform(struct?: DataAzurermEventgridDomainTimeoutsOutputReference | DataAzurermEventgridDomainTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermEventgridDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermEventgridDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermEventgridDomainTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html azurerm_eventgrid_domain}.
 *
 * @stability stable
 */
export declare class DataAzurermEventgridDomain extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventgrid_domain.html azurerm_eventgrid_domain} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermEventgridDomainConfig);
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _inboundIpRule?;
    /**
     * @stability stable
     */
    get inboundIpRule(): DataAzurermEventgridDomainInboundIpRule[];
    /**
     * @stability stable
     */
    set inboundIpRule(value: DataAzurermEventgridDomainInboundIpRule[]);
    /**
     * @stability stable
     */
    resetInboundIpRule(): void;
    /**
     * @stability stable
     */
    get inboundIpRuleInput(): DataAzurermEventgridDomainInboundIpRule[] | undefined;
    /**
     * @stability stable
     */
    inputMappingDefaultValues(index: string): DataAzurermEventgridDomainInputMappingDefaultValues;
    /**
     * @stability stable
     */
    inputMappingFields(index: string): DataAzurermEventgridDomainInputMappingFields;
    /**
     * @stability stable
     */
    get inputSchema(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermEventgridDomainTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermEventgridDomainTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermEventgridDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
