import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermEventhubConsumerGroupConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html#eventhub_name DataAzurermEventhubConsumerGroup#eventhub_name}.
     *
     * @stability stable
     */
    readonly eventhubName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html#name DataAzurermEventhubConsumerGroup#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html#namespace_name DataAzurermEventhubConsumerGroup#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html#resource_group_name DataAzurermEventhubConsumerGroup#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html#timeouts DataAzurermEventhubConsumerGroup#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermEventhubConsumerGroupTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermEventhubConsumerGroupTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html#read DataAzurermEventhubConsumerGroup#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermEventhubConsumerGroupTimeoutsToTerraform(struct?: DataAzurermEventhubConsumerGroupTimeoutsOutputReference | DataAzurermEventhubConsumerGroupTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermEventhubConsumerGroupTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermEventhubConsumerGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermEventhubConsumerGroupTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html azurerm_eventhub_consumer_group}.
 *
 * @stability stable
 */
export declare class DataAzurermEventhubConsumerGroup extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/eventhub_consumer_group.html azurerm_eventhub_consumer_group} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermEventhubConsumerGroupConfig);
    private _eventhubName?;
    /**
     * @stability stable
     */
    get eventhubName(): string;
    /**
     * @stability stable
     */
    set eventhubName(value: string);
    /**
     * @stability stable
     */
    get eventhubNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get userMetadata(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermEventhubConsumerGroupTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermEventhubConsumerGroupTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermEventhubConsumerGroupTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
