import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermIothubDpsSharedAccessPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps_shared_access_policy.html#iothub_dps_name DataAzurermIothubDpsSharedAccessPolicy#iothub_dps_name}.
     *
     * @stability stable
     */
    readonly iothubDpsName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps_shared_access_policy.html#name DataAzurermIothubDpsSharedAccessPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps_shared_access_policy.html#resource_group_name DataAzurermIothubDpsSharedAccessPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps_shared_access_policy.html#timeouts DataAzurermIothubDpsSharedAccessPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermIothubDpsSharedAccessPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermIothubDpsSharedAccessPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps_shared_access_policy.html#read DataAzurermIothubDpsSharedAccessPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermIothubDpsSharedAccessPolicyTimeoutsToTerraform(struct?: DataAzurermIothubDpsSharedAccessPolicyTimeoutsOutputReference | DataAzurermIothubDpsSharedAccessPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermIothubDpsSharedAccessPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermIothubDpsSharedAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermIothubDpsSharedAccessPolicyTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps_shared_access_policy.html azurerm_iothub_dps_shared_access_policy}.
 *
 * @stability stable
 */
export declare class DataAzurermIothubDpsSharedAccessPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/iothub_dps_shared_access_policy.html azurerm_iothub_dps_shared_access_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermIothubDpsSharedAccessPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    private _iothubDpsName?;
    /**
     * @stability stable
     */
    get iothubDpsName(): string;
    /**
     * @stability stable
     */
    set iothubDpsName(value: string);
    /**
     * @stability stable
     */
    get iothubDpsNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryConnectionString(): string;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryConnectionString(): string;
    /**
     * @stability stable
     */
    get secondaryKey(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermIothubDpsSharedAccessPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermIothubDpsSharedAccessPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermIothubDpsSharedAccessPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
