import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultManagedHardwareSecurityModuleConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module.html#name DataAzurermKeyVaultManagedHardwareSecurityModule#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module.html#resource_group_name DataAzurermKeyVaultManagedHardwareSecurityModule#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module.html#timeouts DataAzurermKeyVaultManagedHardwareSecurityModule#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module.html#read DataAzurermKeyVaultManagedHardwareSecurityModule#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsToTerraform(struct?: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsOutputReference | DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module.html azurerm_key_vault_managed_hardware_security_module}.
 *
 * @stability stable
 */
export declare class DataAzurermKeyVaultManagedHardwareSecurityModule extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/key_vault_managed_hardware_security_module.html azurerm_key_vault_managed_hardware_security_module} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermKeyVaultManagedHardwareSecurityModuleConfig);
    /**
     * @stability stable
     */
    get adminObjectIds(): string[];
    /**
     * @stability stable
     */
    get hsmUri(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get purgeProtectionEnabled(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get skuName(): string;
    /**
     * @stability stable
     */
    get softDeleteRetentionDays(): number;
    /**
     * @stability stable
     */
    tags(key: string): string;
    /**
     * @stability stable
     */
    get tenantId(): string;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermKeyVaultManagedHardwareSecurityModuleTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermKeyVaultManagedHardwareSecurityModuleTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
