import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermLbBackendAddressPoolConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool.html#loadbalancer_id DataAzurermLbBackendAddressPool#loadbalancer_id}.
     *
     * @stability stable
     */
    readonly loadbalancerId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool.html#name DataAzurermLbBackendAddressPool#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool.html#timeouts DataAzurermLbBackendAddressPool#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermLbBackendAddressPoolTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermLbBackendAddressPoolBackendAddress extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get ipAddress(): string;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermLbBackendAddressPoolBackendIpConfigurations extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get id(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermLbBackendAddressPoolTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool.html#read DataAzurermLbBackendAddressPool#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermLbBackendAddressPoolTimeoutsToTerraform(struct?: DataAzurermLbBackendAddressPoolTimeoutsOutputReference | DataAzurermLbBackendAddressPoolTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermLbBackendAddressPoolTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermLbBackendAddressPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermLbBackendAddressPoolTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool.html azurerm_lb_backend_address_pool}.
 *
 * @stability stable
 */
export declare class DataAzurermLbBackendAddressPool extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/lb_backend_address_pool.html azurerm_lb_backend_address_pool} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermLbBackendAddressPoolConfig);
    /**
     * @stability stable
     */
    backendAddress(index: string): DataAzurermLbBackendAddressPoolBackendAddress;
    /**
     * @stability stable
     */
    backendIpConfigurations(index: string): DataAzurermLbBackendAddressPoolBackendIpConfigurations;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get loadBalancingRules(): string[];
    private _loadbalancerId?;
    /**
     * @stability stable
     */
    get loadbalancerId(): string;
    /**
     * @stability stable
     */
    set loadbalancerId(value: string);
    /**
     * @stability stable
     */
    get loadbalancerIdInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get outboundRules(): string[];
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermLbBackendAddressPoolTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermLbBackendAddressPoolTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermLbBackendAddressPoolTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
