import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermManagedApplicationDefinitionConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition.html#name DataAzurermManagedApplicationDefinition#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition.html#resource_group_name DataAzurermManagedApplicationDefinition#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition.html#timeouts DataAzurermManagedApplicationDefinition#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermManagedApplicationDefinitionTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermManagedApplicationDefinitionTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition.html#read DataAzurermManagedApplicationDefinition#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermManagedApplicationDefinitionTimeoutsToTerraform(struct?: DataAzurermManagedApplicationDefinitionTimeoutsOutputReference | DataAzurermManagedApplicationDefinitionTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermManagedApplicationDefinitionTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermManagedApplicationDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermManagedApplicationDefinitionTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition.html azurerm_managed_application_definition}.
 *
 * @stability stable
 */
export declare class DataAzurermManagedApplicationDefinition extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/managed_application_definition.html azurerm_managed_application_definition} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermManagedApplicationDefinitionConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermManagedApplicationDefinitionTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermManagedApplicationDefinitionTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermManagedApplicationDefinitionTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
