import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermServicebusTopicConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic.html#name DataAzurermServicebusTopic#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic.html#namespace_name DataAzurermServicebusTopic#namespace_name}.
     *
     * @stability stable
     */
    readonly namespaceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic.html#resource_group_name DataAzurermServicebusTopic#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic.html#timeouts DataAzurermServicebusTopic#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermServicebusTopicTimeouts;
}
/**
 * @stability stable
 */
export interface DataAzurermServicebusTopicTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic.html#read DataAzurermServicebusTopic#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermServicebusTopicTimeoutsToTerraform(struct?: DataAzurermServicebusTopicTimeoutsOutputReference | DataAzurermServicebusTopicTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermServicebusTopicTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermServicebusTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermServicebusTopicTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic.html azurerm_servicebus_topic}.
 *
 * @stability stable
 */
export declare class DataAzurermServicebusTopic extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/servicebus_topic.html azurerm_servicebus_topic} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermServicebusTopicConfig);
    /**
     * @stability stable
     */
    get autoDeleteOnIdle(): string;
    /**
     * @stability stable
     */
    get defaultMessageTtl(): string;
    /**
     * @stability stable
     */
    get duplicateDetectionHistoryTimeWindow(): string;
    /**
     * @stability stable
     */
    get enableBatchedOperations(): any;
    /**
     * @stability stable
     */
    get enableExpress(): any;
    /**
     * @stability stable
     */
    get enablePartitioning(): any;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get maxSizeInMegabytes(): number;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _namespaceName?;
    /**
     * @stability stable
     */
    get namespaceName(): string;
    /**
     * @stability stable
     */
    set namespaceName(value: string);
    /**
     * @stability stable
     */
    get namespaceNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get requiresDuplicateDetection(): any;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get status(): string;
    /**
     * @stability stable
     */
    get supportOrdering(): any;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermServicebusTopicTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermServicebusTopicTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermServicebusTopicTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
