import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataAzurermStorageManagementPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy.html#storage_account_id DataAzurermStorageManagementPolicy#storage_account_id}.
     *
     * @stability stable
     */
    readonly storageAccountId: string;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy.html#timeouts DataAzurermStorageManagementPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataAzurermStorageManagementPolicyTimeouts;
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyRuleActionsBaseBlob extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceModificationGreaterThan(): number;
    /**
     * @stability stable
     */
    get tierToArchiveAfterDaysSinceModificationGreaterThan(): number;
    /**
     * @stability stable
     */
    get tierToCoolAfterDaysSinceModificationGreaterThan(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyRuleActionsSnapshot extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreationGreaterThan(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyRuleActionsVersion extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get changeTierToArchiveAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    get changeTierToCoolAfterDaysSinceCreation(): number;
    /**
     * @stability stable
     */
    get deleteAfterDaysSinceCreation(): number;
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyRuleActions extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get baseBlob(): any;
    /**
     * @stability stable
     */
    get snapshot(): any;
    /**
     * @stability stable
     */
    get version(): any;
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyRuleFiltersMatchBlobIndexTag extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    get operation(): string;
    /**
     * @stability stable
     */
    get value(): string;
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyRuleFilters extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get blobTypes(): string[];
    /**
     * @stability stable
     */
    get matchBlobIndexTag(): any;
    /**
     * @stability stable
     */
    get prefixMatch(): string[];
}
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyRule extends cdktf.ComplexComputedList {
    /**
     * @stability stable
     */
    get actions(): any;
    /**
     * @stability stable
     */
    get enabled(): any;
    /**
     * @stability stable
     */
    get filters(): any;
    /**
     * @stability stable
     */
    get name(): string;
}
/**
 * @stability stable
 */
export interface DataAzurermStorageManagementPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy.html#read DataAzurermStorageManagementPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
}
export declare function dataAzurermStorageManagementPolicyTimeoutsToTerraform(struct?: DataAzurermStorageManagementPolicyTimeoutsOutputReference | DataAzurermStorageManagementPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataAzurermStorageManagementPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataAzurermStorageManagementPolicyTimeouts | undefined);
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy.html azurerm_storage_management_policy}.
 *
 * @stability stable
 */
export declare class DataAzurermStorageManagementPolicy extends cdktf.TerraformDataSource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/d/storage_management_policy.html azurerm_storage_management_policy} Data Source.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataAzurermStorageManagementPolicyConfig);
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    rule(index: string): DataAzurermStorageManagementPolicyRule;
    private _storageAccountId?;
    /**
     * @stability stable
     */
    get storageAccountId(): string;
    /**
     * @stability stable
     */
    set storageAccountId(value: string);
    /**
     * @stability stable
     */
    get storageAccountIdInput(): string | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataAzurermStorageManagementPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataAzurermStorageManagementPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataAzurermStorageManagementPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
