import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryDatasetBinaryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#additional_properties DataFactoryDatasetBinary#additional_properties}.
     *
     * @stability stable
     */
    readonly additionalProperties?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#annotations DataFactoryDatasetBinary#annotations}.
     *
     * @stability stable
     */
    readonly annotations?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#data_factory_name DataFactoryDatasetBinary#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#description DataFactoryDatasetBinary#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#folder DataFactoryDatasetBinary#folder}.
     *
     * @stability stable
     */
    readonly folder?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#linked_service_name DataFactoryDatasetBinary#linked_service_name}.
     *
     * @stability stable
     */
    readonly linkedServiceName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#name DataFactoryDatasetBinary#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#parameters DataFactoryDatasetBinary#parameters}.
     *
     * @stability stable
     */
    readonly parameters?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#resource_group_name DataFactoryDatasetBinary#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * azure_blob_storage_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#azure_blob_storage_location DataFactoryDatasetBinary#azure_blob_storage_location}
     *
     * @stability stable
     */
    readonly azureBlobStorageLocation?: DataFactoryDatasetBinaryAzureBlobStorageLocation;
    /**
     * compression block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#compression DataFactoryDatasetBinary#compression}
     *
     * @stability stable
     */
    readonly compression?: DataFactoryDatasetBinaryCompression;
    /**
     * http_server_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#http_server_location DataFactoryDatasetBinary#http_server_location}
     *
     * @stability stable
     */
    readonly httpServerLocation?: DataFactoryDatasetBinaryHttpServerLocation;
    /**
     * sftp_server_location block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#sftp_server_location DataFactoryDatasetBinary#sftp_server_location}
     *
     * @stability stable
     */
    readonly sftpServerLocation?: DataFactoryDatasetBinarySftpServerLocation;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#timeouts DataFactoryDatasetBinary#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryDatasetBinaryTimeouts;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetBinaryAzureBlobStorageLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#container DataFactoryDatasetBinary#container}.
     *
     * @stability stable
     */
    readonly container: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#dynamic_filename_enabled DataFactoryDatasetBinary#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#dynamic_path_enabled DataFactoryDatasetBinary#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#filename DataFactoryDatasetBinary#filename}.
     *
     * @stability stable
     */
    readonly filename?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#path DataFactoryDatasetBinary#path}.
     *
     * @stability stable
     */
    readonly path?: string;
}
export declare function dataFactoryDatasetBinaryAzureBlobStorageLocationToTerraform(struct?: DataFactoryDatasetBinaryAzureBlobStorageLocationOutputReference | DataFactoryDatasetBinaryAzureBlobStorageLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetBinaryAzureBlobStorageLocationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetBinaryAzureBlobStorageLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetBinaryAzureBlobStorageLocation | undefined);
    private _container?;
    /**
     * @stability stable
     */
    get container(): string;
    /**
     * @stability stable
     */
    set container(value: string);
    /**
     * @stability stable
     */
    get containerInput(): string | undefined;
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    resetFilename(): void;
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    resetPath(): void;
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetBinaryCompression {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#level DataFactoryDatasetBinary#level}.
     *
     * @stability stable
     */
    readonly level?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#type DataFactoryDatasetBinary#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function dataFactoryDatasetBinaryCompressionToTerraform(struct?: DataFactoryDatasetBinaryCompressionOutputReference | DataFactoryDatasetBinaryCompression): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetBinaryCompressionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetBinaryCompression | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetBinaryCompression | undefined);
    private _level?;
    /**
     * @stability stable
     */
    get level(): string;
    /**
     * @stability stable
     */
    set level(value: string);
    /**
     * @stability stable
     */
    resetLevel(): void;
    /**
     * @stability stable
     */
    get levelInput(): string | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetBinaryHttpServerLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#dynamic_filename_enabled DataFactoryDatasetBinary#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#dynamic_path_enabled DataFactoryDatasetBinary#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#filename DataFactoryDatasetBinary#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#path DataFactoryDatasetBinary#path}.
     *
     * @stability stable
     */
    readonly path: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#relative_url DataFactoryDatasetBinary#relative_url}.
     *
     * @stability stable
     */
    readonly relativeUrl: string;
}
export declare function dataFactoryDatasetBinaryHttpServerLocationToTerraform(struct?: DataFactoryDatasetBinaryHttpServerLocationOutputReference | DataFactoryDatasetBinaryHttpServerLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetBinaryHttpServerLocationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetBinaryHttpServerLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetBinaryHttpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
    private _relativeUrl?;
    /**
     * @stability stable
     */
    get relativeUrl(): string;
    /**
     * @stability stable
     */
    set relativeUrl(value: string);
    /**
     * @stability stable
     */
    get relativeUrlInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetBinarySftpServerLocation {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#dynamic_filename_enabled DataFactoryDatasetBinary#dynamic_filename_enabled}.
     *
     * @stability stable
     */
    readonly dynamicFilenameEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#dynamic_path_enabled DataFactoryDatasetBinary#dynamic_path_enabled}.
     *
     * @stability stable
     */
    readonly dynamicPathEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#filename DataFactoryDatasetBinary#filename}.
     *
     * @stability stable
     */
    readonly filename: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#path DataFactoryDatasetBinary#path}.
     *
     * @stability stable
     */
    readonly path: string;
}
export declare function dataFactoryDatasetBinarySftpServerLocationToTerraform(struct?: DataFactoryDatasetBinarySftpServerLocationOutputReference | DataFactoryDatasetBinarySftpServerLocation): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetBinarySftpServerLocationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetBinarySftpServerLocation | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetBinarySftpServerLocation | undefined);
    private _dynamicFilenameEnabled?;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicFilenameEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicFilenameEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicFilenameEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _dynamicPathEnabled?;
    /**
     * @stability stable
     */
    get dynamicPathEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set dynamicPathEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetDynamicPathEnabled(): void;
    /**
     * @stability stable
     */
    get dynamicPathEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _filename?;
    /**
     * @stability stable
     */
    get filename(): string;
    /**
     * @stability stable
     */
    set filename(value: string);
    /**
     * @stability stable
     */
    get filenameInput(): string | undefined;
    private _path?;
    /**
     * @stability stable
     */
    get path(): string;
    /**
     * @stability stable
     */
    set path(value: string);
    /**
     * @stability stable
     */
    get pathInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryDatasetBinaryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#create DataFactoryDatasetBinary#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#delete DataFactoryDatasetBinary#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#read DataFactoryDatasetBinary#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html#update DataFactoryDatasetBinary#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryDatasetBinaryTimeoutsToTerraform(struct?: DataFactoryDatasetBinaryTimeoutsOutputReference | DataFactoryDatasetBinaryTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryDatasetBinaryTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryDatasetBinaryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryDatasetBinaryTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html azurerm_data_factory_dataset_binary}.
 *
 * @stability stable
 */
export declare class DataFactoryDatasetBinary extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_dataset_binary.html azurerm_data_factory_dataset_binary} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryDatasetBinaryConfig);
    private _additionalProperties?;
    /**
     * @stability stable
     */
    get additionalProperties(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set additionalProperties(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetAdditionalProperties(): void;
    /**
     * @stability stable
     */
    get additionalPropertiesInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _annotations?;
    /**
     * @stability stable
     */
    get annotations(): string[];
    /**
     * @stability stable
     */
    set annotations(value: string[]);
    /**
     * @stability stable
     */
    resetAnnotations(): void;
    /**
     * @stability stable
     */
    get annotationsInput(): string[] | undefined;
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _folder?;
    /**
     * @stability stable
     */
    get folder(): string;
    /**
     * @stability stable
     */
    set folder(value: string);
    /**
     * @stability stable
     */
    resetFolder(): void;
    /**
     * @stability stable
     */
    get folderInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _linkedServiceName?;
    /**
     * @stability stable
     */
    get linkedServiceName(): string;
    /**
     * @stability stable
     */
    set linkedServiceName(value: string);
    /**
     * @stability stable
     */
    get linkedServiceNameInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _parameters?;
    /**
     * @stability stable
     */
    get parameters(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set parameters(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetParameters(): void;
    /**
     * @stability stable
     */
    get parametersInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _azureBlobStorageLocation;
    /**
     * @stability stable
     */
    get azureBlobStorageLocation(): DataFactoryDatasetBinaryAzureBlobStorageLocationOutputReference;
    /**
     * @stability stable
     */
    putAzureBlobStorageLocation(value: DataFactoryDatasetBinaryAzureBlobStorageLocation): void;
    /**
     * @stability stable
     */
    resetAzureBlobStorageLocation(): void;
    /**
     * @stability stable
     */
    get azureBlobStorageLocationInput(): DataFactoryDatasetBinaryAzureBlobStorageLocation | undefined;
    private _compression;
    /**
     * @stability stable
     */
    get compression(): DataFactoryDatasetBinaryCompressionOutputReference;
    /**
     * @stability stable
     */
    putCompression(value: DataFactoryDatasetBinaryCompression): void;
    /**
     * @stability stable
     */
    resetCompression(): void;
    /**
     * @stability stable
     */
    get compressionInput(): DataFactoryDatasetBinaryCompression | undefined;
    private _httpServerLocation;
    /**
     * @stability stable
     */
    get httpServerLocation(): DataFactoryDatasetBinaryHttpServerLocationOutputReference;
    /**
     * @stability stable
     */
    putHttpServerLocation(value: DataFactoryDatasetBinaryHttpServerLocation): void;
    /**
     * @stability stable
     */
    resetHttpServerLocation(): void;
    /**
     * @stability stable
     */
    get httpServerLocationInput(): DataFactoryDatasetBinaryHttpServerLocation | undefined;
    private _sftpServerLocation;
    /**
     * @stability stable
     */
    get sftpServerLocation(): DataFactoryDatasetBinarySftpServerLocationOutputReference;
    /**
     * @stability stable
     */
    putSftpServerLocation(value: DataFactoryDatasetBinarySftpServerLocation): void;
    /**
     * @stability stable
     */
    resetSftpServerLocation(): void;
    /**
     * @stability stable
     */
    get sftpServerLocationInput(): DataFactoryDatasetBinarySftpServerLocation | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryDatasetBinaryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryDatasetBinaryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryDatasetBinaryTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
