import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeManagedConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#data_factory_name DataFactoryIntegrationRuntimeManaged#data_factory_name}.
     *
     * @stability stable
     */
    readonly dataFactoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#description DataFactoryIntegrationRuntimeManaged#description}.
     *
     * @stability stable
     */
    readonly description?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#edition DataFactoryIntegrationRuntimeManaged#edition}.
     *
     * @stability stable
     */
    readonly edition?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#license_type DataFactoryIntegrationRuntimeManaged#license_type}.
     *
     * @stability stable
     */
    readonly licenseType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#location DataFactoryIntegrationRuntimeManaged#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#max_parallel_executions_per_node DataFactoryIntegrationRuntimeManaged#max_parallel_executions_per_node}.
     *
     * @stability stable
     */
    readonly maxParallelExecutionsPerNode?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#name DataFactoryIntegrationRuntimeManaged#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#node_size DataFactoryIntegrationRuntimeManaged#node_size}.
     *
     * @stability stable
     */
    readonly nodeSize: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#number_of_nodes DataFactoryIntegrationRuntimeManaged#number_of_nodes}.
     *
     * @stability stable
     */
    readonly numberOfNodes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#resource_group_name DataFactoryIntegrationRuntimeManaged#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * catalog_info block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#catalog_info DataFactoryIntegrationRuntimeManaged#catalog_info}
     *
     * @stability stable
     */
    readonly catalogInfo?: DataFactoryIntegrationRuntimeManagedCatalogInfo;
    /**
     * custom_setup_script block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#custom_setup_script DataFactoryIntegrationRuntimeManaged#custom_setup_script}
     *
     * @stability stable
     */
    readonly customSetupScript?: DataFactoryIntegrationRuntimeManagedCustomSetupScript;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#timeouts DataFactoryIntegrationRuntimeManaged#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryIntegrationRuntimeManagedTimeouts;
    /**
     * vnet_integration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#vnet_integration DataFactoryIntegrationRuntimeManaged#vnet_integration}
     *
     * @stability stable
     */
    readonly vnetIntegration?: DataFactoryIntegrationRuntimeManagedVnetIntegration;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeManagedCatalogInfo {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#administrator_login DataFactoryIntegrationRuntimeManaged#administrator_login}.
     *
     * @stability stable
     */
    readonly administratorLogin?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#administrator_password DataFactoryIntegrationRuntimeManaged#administrator_password}.
     *
     * @stability stable
     */
    readonly administratorPassword?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#pricing_tier DataFactoryIntegrationRuntimeManaged#pricing_tier}.
     *
     * @stability stable
     */
    readonly pricingTier?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#server_endpoint DataFactoryIntegrationRuntimeManaged#server_endpoint}.
     *
     * @stability stable
     */
    readonly serverEndpoint: string;
}
export declare function dataFactoryIntegrationRuntimeManagedCatalogInfoToTerraform(struct?: DataFactoryIntegrationRuntimeManagedCatalogInfoOutputReference | DataFactoryIntegrationRuntimeManagedCatalogInfo): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeManagedCatalogInfoOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeManagedCatalogInfo | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeManagedCatalogInfo | undefined);
    private _administratorLogin?;
    /**
     * @stability stable
     */
    get administratorLogin(): string;
    /**
     * @stability stable
     */
    set administratorLogin(value: string);
    /**
     * @stability stable
     */
    resetAdministratorLogin(): void;
    /**
     * @stability stable
     */
    get administratorLoginInput(): string | undefined;
    private _administratorPassword?;
    /**
     * @stability stable
     */
    get administratorPassword(): string;
    /**
     * @stability stable
     */
    set administratorPassword(value: string);
    /**
     * @stability stable
     */
    resetAdministratorPassword(): void;
    /**
     * @stability stable
     */
    get administratorPasswordInput(): string | undefined;
    private _pricingTier?;
    /**
     * @stability stable
     */
    get pricingTier(): string;
    /**
     * @stability stable
     */
    set pricingTier(value: string);
    /**
     * @stability stable
     */
    resetPricingTier(): void;
    /**
     * @stability stable
     */
    get pricingTierInput(): string | undefined;
    private _serverEndpoint?;
    /**
     * @stability stable
     */
    get serverEndpoint(): string;
    /**
     * @stability stable
     */
    set serverEndpoint(value: string);
    /**
     * @stability stable
     */
    get serverEndpointInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeManagedCustomSetupScript {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#blob_container_uri DataFactoryIntegrationRuntimeManaged#blob_container_uri}.
     *
     * @stability stable
     */
    readonly blobContainerUri: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#sas_token DataFactoryIntegrationRuntimeManaged#sas_token}.
     *
     * @stability stable
     */
    readonly sasToken: string;
}
export declare function dataFactoryIntegrationRuntimeManagedCustomSetupScriptToTerraform(struct?: DataFactoryIntegrationRuntimeManagedCustomSetupScriptOutputReference | DataFactoryIntegrationRuntimeManagedCustomSetupScript): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeManagedCustomSetupScriptOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeManagedCustomSetupScript | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeManagedCustomSetupScript | undefined);
    private _blobContainerUri?;
    /**
     * @stability stable
     */
    get blobContainerUri(): string;
    /**
     * @stability stable
     */
    set blobContainerUri(value: string);
    /**
     * @stability stable
     */
    get blobContainerUriInput(): string | undefined;
    private _sasToken?;
    /**
     * @stability stable
     */
    get sasToken(): string;
    /**
     * @stability stable
     */
    set sasToken(value: string);
    /**
     * @stability stable
     */
    get sasTokenInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeManagedTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#create DataFactoryIntegrationRuntimeManaged#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#delete DataFactoryIntegrationRuntimeManaged#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#read DataFactoryIntegrationRuntimeManaged#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#update DataFactoryIntegrationRuntimeManaged#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryIntegrationRuntimeManagedTimeoutsToTerraform(struct?: DataFactoryIntegrationRuntimeManagedTimeoutsOutputReference | DataFactoryIntegrationRuntimeManagedTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeManagedTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeManagedTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeManagedTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryIntegrationRuntimeManagedVnetIntegration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#subnet_name DataFactoryIntegrationRuntimeManaged#subnet_name}.
     *
     * @stability stable
     */
    readonly subnetName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html#vnet_id DataFactoryIntegrationRuntimeManaged#vnet_id}.
     *
     * @stability stable
     */
    readonly vnetId: string;
}
export declare function dataFactoryIntegrationRuntimeManagedVnetIntegrationToTerraform(struct?: DataFactoryIntegrationRuntimeManagedVnetIntegrationOutputReference | DataFactoryIntegrationRuntimeManagedVnetIntegration): any;
/**
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeManagedVnetIntegrationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIntegrationRuntimeManagedVnetIntegration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIntegrationRuntimeManagedVnetIntegration | undefined);
    private _subnetName?;
    /**
     * @stability stable
     */
    get subnetName(): string;
    /**
     * @stability stable
     */
    set subnetName(value: string);
    /**
     * @stability stable
     */
    get subnetNameInput(): string | undefined;
    private _vnetId?;
    /**
     * @stability stable
     */
    get vnetId(): string;
    /**
     * @stability stable
     */
    set vnetId(value: string);
    /**
     * @stability stable
     */
    get vnetIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html azurerm_data_factory_integration_runtime_managed}.
 *
 * @stability stable
 */
export declare class DataFactoryIntegrationRuntimeManaged extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory_integration_runtime_managed.html azurerm_data_factory_integration_runtime_managed} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryIntegrationRuntimeManagedConfig);
    private _dataFactoryName?;
    /**
     * @stability stable
     */
    get dataFactoryName(): string;
    /**
     * @stability stable
     */
    set dataFactoryName(value: string);
    /**
     * @stability stable
     */
    get dataFactoryNameInput(): string | undefined;
    private _description?;
    /**
     * @stability stable
     */
    get description(): string;
    /**
     * @stability stable
     */
    set description(value: string);
    /**
     * @stability stable
     */
    resetDescription(): void;
    /**
     * @stability stable
     */
    get descriptionInput(): string | undefined;
    private _edition?;
    /**
     * @stability stable
     */
    get edition(): string;
    /**
     * @stability stable
     */
    set edition(value: string);
    /**
     * @stability stable
     */
    resetEdition(): void;
    /**
     * @stability stable
     */
    get editionInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _licenseType?;
    /**
     * @stability stable
     */
    get licenseType(): string;
    /**
     * @stability stable
     */
    set licenseType(value: string);
    /**
     * @stability stable
     */
    resetLicenseType(): void;
    /**
     * @stability stable
     */
    get licenseTypeInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _maxParallelExecutionsPerNode?;
    /**
     * @stability stable
     */
    get maxParallelExecutionsPerNode(): number;
    /**
     * @stability stable
     */
    set maxParallelExecutionsPerNode(value: number);
    /**
     * @stability stable
     */
    resetMaxParallelExecutionsPerNode(): void;
    /**
     * @stability stable
     */
    get maxParallelExecutionsPerNodeInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _nodeSize?;
    /**
     * @stability stable
     */
    get nodeSize(): string;
    /**
     * @stability stable
     */
    set nodeSize(value: string);
    /**
     * @stability stable
     */
    get nodeSizeInput(): string | undefined;
    private _numberOfNodes?;
    /**
     * @stability stable
     */
    get numberOfNodes(): number;
    /**
     * @stability stable
     */
    set numberOfNodes(value: number);
    /**
     * @stability stable
     */
    resetNumberOfNodes(): void;
    /**
     * @stability stable
     */
    get numberOfNodesInput(): number | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _catalogInfo;
    /**
     * @stability stable
     */
    get catalogInfo(): DataFactoryIntegrationRuntimeManagedCatalogInfoOutputReference;
    /**
     * @stability stable
     */
    putCatalogInfo(value: DataFactoryIntegrationRuntimeManagedCatalogInfo): void;
    /**
     * @stability stable
     */
    resetCatalogInfo(): void;
    /**
     * @stability stable
     */
    get catalogInfoInput(): DataFactoryIntegrationRuntimeManagedCatalogInfo | undefined;
    private _customSetupScript;
    /**
     * @stability stable
     */
    get customSetupScript(): DataFactoryIntegrationRuntimeManagedCustomSetupScriptOutputReference;
    /**
     * @stability stable
     */
    putCustomSetupScript(value: DataFactoryIntegrationRuntimeManagedCustomSetupScript): void;
    /**
     * @stability stable
     */
    resetCustomSetupScript(): void;
    /**
     * @stability stable
     */
    get customSetupScriptInput(): DataFactoryIntegrationRuntimeManagedCustomSetupScript | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryIntegrationRuntimeManagedTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryIntegrationRuntimeManagedTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryIntegrationRuntimeManagedTimeouts | undefined;
    private _vnetIntegration;
    /**
     * @stability stable
     */
    get vnetIntegration(): DataFactoryIntegrationRuntimeManagedVnetIntegrationOutputReference;
    /**
     * @stability stable
     */
    putVnetIntegration(value: DataFactoryIntegrationRuntimeManagedVnetIntegration): void;
    /**
     * @stability stable
     */
    resetVnetIntegration(): void;
    /**
     * @stability stable
     */
    get vnetIntegrationInput(): DataFactoryIntegrationRuntimeManagedVnetIntegration | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
