import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataFactoryConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#customer_managed_key_id DataFactory#customer_managed_key_id}.
     *
     * @stability stable
     */
    readonly customerManagedKeyId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#location DataFactory#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#managed_virtual_network_enabled DataFactory#managed_virtual_network_enabled}.
     *
     * @stability stable
     */
    readonly managedVirtualNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#name DataFactory#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#public_network_enabled DataFactory#public_network_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#resource_group_name DataFactory#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#tags DataFactory#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * github_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#github_configuration DataFactory#github_configuration}
     *
     * @stability stable
     */
    readonly githubConfiguration?: DataFactoryGithubConfiguration;
    /**
     * global_parameter block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#global_parameter DataFactory#global_parameter}
     *
     * @stability stable
     */
    readonly globalParameter?: DataFactoryGlobalParameter[];
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#identity DataFactory#identity}
     *
     * @stability stable
     */
    readonly identity?: DataFactoryIdentity;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#timeouts DataFactory#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataFactoryTimeouts;
    /**
     * vsts_configuration block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#vsts_configuration DataFactory#vsts_configuration}
     *
     * @stability stable
     */
    readonly vstsConfiguration?: DataFactoryVstsConfiguration;
}
/**
 * @stability stable
 */
export interface DataFactoryGithubConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#account_name DataFactory#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#branch_name DataFactory#branch_name}.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#git_url DataFactory#git_url}.
     *
     * @stability stable
     */
    readonly gitUrl: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#repository_name DataFactory#repository_name}.
     *
     * @stability stable
     */
    readonly repositoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#root_folder DataFactory#root_folder}.
     *
     * @stability stable
     */
    readonly rootFolder: string;
}
export declare function dataFactoryGithubConfigurationToTerraform(struct?: DataFactoryGithubConfigurationOutputReference | DataFactoryGithubConfiguration): any;
/**
 * @stability stable
 */
export declare class DataFactoryGithubConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryGithubConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryGithubConfiguration | undefined);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _branchName?;
    /**
     * @stability stable
     */
    get branchName(): string;
    /**
     * @stability stable
     */
    set branchName(value: string);
    /**
     * @stability stable
     */
    get branchNameInput(): string | undefined;
    private _gitUrl?;
    /**
     * @stability stable
     */
    get gitUrl(): string;
    /**
     * @stability stable
     */
    set gitUrl(value: string);
    /**
     * @stability stable
     */
    get gitUrlInput(): string | undefined;
    private _repositoryName?;
    /**
     * @stability stable
     */
    get repositoryName(): string;
    /**
     * @stability stable
     */
    set repositoryName(value: string);
    /**
     * @stability stable
     */
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    /**
     * @stability stable
     */
    get rootFolder(): string;
    /**
     * @stability stable
     */
    set rootFolder(value: string);
    /**
     * @stability stable
     */
    get rootFolderInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryGlobalParameter {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#name DataFactory#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#type DataFactory#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#value DataFactory#value}.
     *
     * @stability stable
     */
    readonly value: string;
}
export declare function dataFactoryGlobalParameterToTerraform(struct?: DataFactoryGlobalParameter): any;
/**
 * @stability stable
 */
export interface DataFactoryIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#identity_ids DataFactory#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#type DataFactory#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function dataFactoryIdentityToTerraform(struct?: DataFactoryIdentityOutputReference | DataFactoryIdentity): any;
/**
 * @stability stable
 */
export declare class DataFactoryIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#create DataFactory#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#delete DataFactory#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#read DataFactory#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#update DataFactory#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataFactoryTimeoutsToTerraform(struct?: DataFactoryTimeoutsOutputReference | DataFactoryTimeouts): any;
/**
 * @stability stable
 */
export declare class DataFactoryTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataFactoryVstsConfiguration {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#account_name DataFactory#account_name}.
     *
     * @stability stable
     */
    readonly accountName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#branch_name DataFactory#branch_name}.
     *
     * @stability stable
     */
    readonly branchName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#project_name DataFactory#project_name}.
     *
     * @stability stable
     */
    readonly projectName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#repository_name DataFactory#repository_name}.
     *
     * @stability stable
     */
    readonly repositoryName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#root_folder DataFactory#root_folder}.
     *
     * @stability stable
     */
    readonly rootFolder: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html#tenant_id DataFactory#tenant_id}.
     *
     * @stability stable
     */
    readonly tenantId: string;
}
export declare function dataFactoryVstsConfigurationToTerraform(struct?: DataFactoryVstsConfigurationOutputReference | DataFactoryVstsConfiguration): any;
/**
 * @stability stable
 */
export declare class DataFactoryVstsConfigurationOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataFactoryVstsConfiguration | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataFactoryVstsConfiguration | undefined);
    private _accountName?;
    /**
     * @stability stable
     */
    get accountName(): string;
    /**
     * @stability stable
     */
    set accountName(value: string);
    /**
     * @stability stable
     */
    get accountNameInput(): string | undefined;
    private _branchName?;
    /**
     * @stability stable
     */
    get branchName(): string;
    /**
     * @stability stable
     */
    set branchName(value: string);
    /**
     * @stability stable
     */
    get branchNameInput(): string | undefined;
    private _projectName?;
    /**
     * @stability stable
     */
    get projectName(): string;
    /**
     * @stability stable
     */
    set projectName(value: string);
    /**
     * @stability stable
     */
    get projectNameInput(): string | undefined;
    private _repositoryName?;
    /**
     * @stability stable
     */
    get repositoryName(): string;
    /**
     * @stability stable
     */
    set repositoryName(value: string);
    /**
     * @stability stable
     */
    get repositoryNameInput(): string | undefined;
    private _rootFolder?;
    /**
     * @stability stable
     */
    get rootFolder(): string;
    /**
     * @stability stable
     */
    set rootFolder(value: string);
    /**
     * @stability stable
     */
    get rootFolderInput(): string | undefined;
    private _tenantId?;
    /**
     * @stability stable
     */
    get tenantId(): string;
    /**
     * @stability stable
     */
    set tenantId(value: string);
    /**
     * @stability stable
     */
    get tenantIdInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html azurerm_data_factory}.
 *
 * @stability stable
 */
export declare class DataFactory extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_factory.html azurerm_data_factory} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataFactoryConfig);
    private _customerManagedKeyId?;
    /**
     * @stability stable
     */
    get customerManagedKeyId(): string;
    /**
     * @stability stable
     */
    set customerManagedKeyId(value: string);
    /**
     * @stability stable
     */
    resetCustomerManagedKeyId(): void;
    /**
     * @stability stable
     */
    get customerManagedKeyIdInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _managedVirtualNetworkEnabled?;
    /**
     * @stability stable
     */
    get managedVirtualNetworkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set managedVirtualNetworkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetManagedVirtualNetworkEnabled(): void;
    /**
     * @stability stable
     */
    get managedVirtualNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _publicNetworkEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _githubConfiguration;
    /**
     * @stability stable
     */
    get githubConfiguration(): DataFactoryGithubConfigurationOutputReference;
    /**
     * @stability stable
     */
    putGithubConfiguration(value: DataFactoryGithubConfiguration): void;
    /**
     * @stability stable
     */
    resetGithubConfiguration(): void;
    /**
     * @stability stable
     */
    get githubConfigurationInput(): DataFactoryGithubConfiguration | undefined;
    private _globalParameter?;
    /**
     * @stability stable
     */
    get globalParameter(): DataFactoryGlobalParameter[];
    /**
     * @stability stable
     */
    set globalParameter(value: DataFactoryGlobalParameter[]);
    /**
     * @stability stable
     */
    resetGlobalParameter(): void;
    /**
     * @stability stable
     */
    get globalParameterInput(): DataFactoryGlobalParameter[] | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): DataFactoryIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: DataFactoryIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): DataFactoryIdentity | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataFactoryTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataFactoryTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataFactoryTimeouts | undefined;
    private _vstsConfiguration;
    /**
     * @stability stable
     */
    get vstsConfiguration(): DataFactoryVstsConfigurationOutputReference;
    /**
     * @stability stable
     */
    putVstsConfiguration(value: DataFactoryVstsConfiguration): void;
    /**
     * @stability stable
     */
    resetVstsConfiguration(): void;
    /**
     * @stability stable
     */
    get vstsConfigurationInput(): DataFactoryVstsConfiguration | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
