import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyDiskConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#backup_repeating_time_intervals DataProtectionBackupPolicyDisk#backup_repeating_time_intervals}.
     *
     * @stability stable
     */
    readonly backupRepeatingTimeIntervals: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#default_retention_duration DataProtectionBackupPolicyDisk#default_retention_duration}.
     *
     * @stability stable
     */
    readonly defaultRetentionDuration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#name DataProtectionBackupPolicyDisk#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#vault_id DataProtectionBackupPolicyDisk#vault_id}.
     *
     * @stability stable
     */
    readonly vaultId: string;
    /**
     * retention_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#retention_rule DataProtectionBackupPolicyDisk#retention_rule}
     *
     * @stability stable
     */
    readonly retentionRule?: DataProtectionBackupPolicyDiskRetentionRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#timeouts DataProtectionBackupPolicyDisk#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataProtectionBackupPolicyDiskTimeouts;
}
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyDiskRetentionRuleCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#absolute_criteria DataProtectionBackupPolicyDisk#absolute_criteria}.
     *
     * @stability stable
     */
    readonly absoluteCriteria?: string;
}
export declare function dataProtectionBackupPolicyDiskRetentionRuleCriteriaToTerraform(struct?: DataProtectionBackupPolicyDiskRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyDiskRetentionRuleCriteria): any;
/**
 * @stability stable
 */
export declare class DataProtectionBackupPolicyDiskRetentionRuleCriteriaOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataProtectionBackupPolicyDiskRetentionRuleCriteria | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataProtectionBackupPolicyDiskRetentionRuleCriteria | undefined);
    private _absoluteCriteria?;
    /**
     * @stability stable
     */
    get absoluteCriteria(): string;
    /**
     * @stability stable
     */
    set absoluteCriteria(value: string);
    /**
     * @stability stable
     */
    resetAbsoluteCriteria(): void;
    /**
     * @stability stable
     */
    get absoluteCriteriaInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyDiskRetentionRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#duration DataProtectionBackupPolicyDisk#duration}.
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#name DataProtectionBackupPolicyDisk#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#priority DataProtectionBackupPolicyDisk#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#criteria DataProtectionBackupPolicyDisk#criteria}
     *
     * @stability stable
     */
    readonly criteria: DataProtectionBackupPolicyDiskRetentionRuleCriteria;
}
export declare function dataProtectionBackupPolicyDiskRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyDiskRetentionRule): any;
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyDiskTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#create DataProtectionBackupPolicyDisk#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#delete DataProtectionBackupPolicyDisk#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#read DataProtectionBackupPolicyDisk#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html#update DataProtectionBackupPolicyDisk#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataProtectionBackupPolicyDiskTimeoutsToTerraform(struct?: DataProtectionBackupPolicyDiskTimeoutsOutputReference | DataProtectionBackupPolicyDiskTimeouts): any;
/**
 * @stability stable
 */
export declare class DataProtectionBackupPolicyDiskTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataProtectionBackupPolicyDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataProtectionBackupPolicyDiskTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html azurerm_data_protection_backup_policy_disk}.
 *
 * @stability stable
 */
export declare class DataProtectionBackupPolicyDisk extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_disk.html azurerm_data_protection_backup_policy_disk} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataProtectionBackupPolicyDiskConfig);
    private _backupRepeatingTimeIntervals?;
    /**
     * @stability stable
     */
    get backupRepeatingTimeIntervals(): string[];
    /**
     * @stability stable
     */
    set backupRepeatingTimeIntervals(value: string[]);
    /**
     * @stability stable
     */
    get backupRepeatingTimeIntervalsInput(): string[] | undefined;
    private _defaultRetentionDuration?;
    /**
     * @stability stable
     */
    get defaultRetentionDuration(): string;
    /**
     * @stability stable
     */
    set defaultRetentionDuration(value: string);
    /**
     * @stability stable
     */
    get defaultRetentionDurationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _vaultId?;
    /**
     * @stability stable
     */
    get vaultId(): string;
    /**
     * @stability stable
     */
    set vaultId(value: string);
    /**
     * @stability stable
     */
    get vaultIdInput(): string | undefined;
    private _retentionRule?;
    /**
     * @stability stable
     */
    get retentionRule(): DataProtectionBackupPolicyDiskRetentionRule[];
    /**
     * @stability stable
     */
    set retentionRule(value: DataProtectionBackupPolicyDiskRetentionRule[]);
    /**
     * @stability stable
     */
    resetRetentionRule(): void;
    /**
     * @stability stable
     */
    get retentionRuleInput(): DataProtectionBackupPolicyDiskRetentionRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataProtectionBackupPolicyDiskTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataProtectionBackupPolicyDiskTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataProtectionBackupPolicyDiskTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
