import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyPostgresqlConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#backup_repeating_time_intervals DataProtectionBackupPolicyPostgresql#backup_repeating_time_intervals}.
     *
     * @stability stable
     */
    readonly backupRepeatingTimeIntervals: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#default_retention_duration DataProtectionBackupPolicyPostgresql#default_retention_duration}.
     *
     * @stability stable
     */
    readonly defaultRetentionDuration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#name DataProtectionBackupPolicyPostgresql#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#resource_group_name DataProtectionBackupPolicyPostgresql#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#vault_name DataProtectionBackupPolicyPostgresql#vault_name}.
     *
     * @stability stable
     */
    readonly vaultName: string;
    /**
     * retention_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#retention_rule DataProtectionBackupPolicyPostgresql#retention_rule}
     *
     * @stability stable
     */
    readonly retentionRule?: DataProtectionBackupPolicyPostgresqlRetentionRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#timeouts DataProtectionBackupPolicyPostgresql#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DataProtectionBackupPolicyPostgresqlTimeouts;
}
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyPostgresqlRetentionRuleCriteria {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#absolute_criteria DataProtectionBackupPolicyPostgresql#absolute_criteria}.
     *
     * @stability stable
     */
    readonly absoluteCriteria?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#days_of_week DataProtectionBackupPolicyPostgresql#days_of_week}.
     *
     * @stability stable
     */
    readonly daysOfWeek?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#months_of_year DataProtectionBackupPolicyPostgresql#months_of_year}.
     *
     * @stability stable
     */
    readonly monthsOfYear?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#scheduled_backup_times DataProtectionBackupPolicyPostgresql#scheduled_backup_times}.
     *
     * @stability stable
     */
    readonly scheduledBackupTimes?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#weeks_of_month DataProtectionBackupPolicyPostgresql#weeks_of_month}.
     *
     * @stability stable
     */
    readonly weeksOfMonth?: string[];
}
export declare function dataProtectionBackupPolicyPostgresqlRetentionRuleCriteriaToTerraform(struct?: DataProtectionBackupPolicyPostgresqlRetentionRuleCriteriaOutputReference | DataProtectionBackupPolicyPostgresqlRetentionRuleCriteria): any;
/**
 * @stability stable
 */
export declare class DataProtectionBackupPolicyPostgresqlRetentionRuleCriteriaOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataProtectionBackupPolicyPostgresqlRetentionRuleCriteria | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataProtectionBackupPolicyPostgresqlRetentionRuleCriteria | undefined);
    private _absoluteCriteria?;
    /**
     * @stability stable
     */
    get absoluteCriteria(): string;
    /**
     * @stability stable
     */
    set absoluteCriteria(value: string);
    /**
     * @stability stable
     */
    resetAbsoluteCriteria(): void;
    /**
     * @stability stable
     */
    get absoluteCriteriaInput(): string | undefined;
    private _daysOfWeek?;
    /**
     * @stability stable
     */
    get daysOfWeek(): string[];
    /**
     * @stability stable
     */
    set daysOfWeek(value: string[]);
    /**
     * @stability stable
     */
    resetDaysOfWeek(): void;
    /**
     * @stability stable
     */
    get daysOfWeekInput(): string[] | undefined;
    private _monthsOfYear?;
    /**
     * @stability stable
     */
    get monthsOfYear(): string[];
    /**
     * @stability stable
     */
    set monthsOfYear(value: string[]);
    /**
     * @stability stable
     */
    resetMonthsOfYear(): void;
    /**
     * @stability stable
     */
    get monthsOfYearInput(): string[] | undefined;
    private _scheduledBackupTimes?;
    /**
     * @stability stable
     */
    get scheduledBackupTimes(): string[];
    /**
     * @stability stable
     */
    set scheduledBackupTimes(value: string[]);
    /**
     * @stability stable
     */
    resetScheduledBackupTimes(): void;
    /**
     * @stability stable
     */
    get scheduledBackupTimesInput(): string[] | undefined;
    private _weeksOfMonth?;
    /**
     * @stability stable
     */
    get weeksOfMonth(): string[];
    /**
     * @stability stable
     */
    set weeksOfMonth(value: string[]);
    /**
     * @stability stable
     */
    resetWeeksOfMonth(): void;
    /**
     * @stability stable
     */
    get weeksOfMonthInput(): string[] | undefined;
}
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyPostgresqlRetentionRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#duration DataProtectionBackupPolicyPostgresql#duration}.
     *
     * @stability stable
     */
    readonly duration: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#name DataProtectionBackupPolicyPostgresql#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#priority DataProtectionBackupPolicyPostgresql#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * criteria block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#criteria DataProtectionBackupPolicyPostgresql#criteria}
     *
     * @stability stable
     */
    readonly criteria: DataProtectionBackupPolicyPostgresqlRetentionRuleCriteria;
}
export declare function dataProtectionBackupPolicyPostgresqlRetentionRuleToTerraform(struct?: DataProtectionBackupPolicyPostgresqlRetentionRule): any;
/**
 * @stability stable
 */
export interface DataProtectionBackupPolicyPostgresqlTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#create DataProtectionBackupPolicyPostgresql#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#delete DataProtectionBackupPolicyPostgresql#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#read DataProtectionBackupPolicyPostgresql#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html#update DataProtectionBackupPolicyPostgresql#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dataProtectionBackupPolicyPostgresqlTimeoutsToTerraform(struct?: DataProtectionBackupPolicyPostgresqlTimeoutsOutputReference | DataProtectionBackupPolicyPostgresqlTimeouts): any;
/**
 * @stability stable
 */
export declare class DataProtectionBackupPolicyPostgresqlTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DataProtectionBackupPolicyPostgresqlTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DataProtectionBackupPolicyPostgresqlTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html azurerm_data_protection_backup_policy_postgresql}.
 *
 * @stability stable
 */
export declare class DataProtectionBackupPolicyPostgresql extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/data_protection_backup_policy_postgresql.html azurerm_data_protection_backup_policy_postgresql} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DataProtectionBackupPolicyPostgresqlConfig);
    private _backupRepeatingTimeIntervals?;
    /**
     * @stability stable
     */
    get backupRepeatingTimeIntervals(): string[];
    /**
     * @stability stable
     */
    set backupRepeatingTimeIntervals(value: string[]);
    /**
     * @stability stable
     */
    get backupRepeatingTimeIntervalsInput(): string[] | undefined;
    private _defaultRetentionDuration?;
    /**
     * @stability stable
     */
    get defaultRetentionDuration(): string;
    /**
     * @stability stable
     */
    set defaultRetentionDuration(value: string);
    /**
     * @stability stable
     */
    get defaultRetentionDurationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _vaultName?;
    /**
     * @stability stable
     */
    get vaultName(): string;
    /**
     * @stability stable
     */
    set vaultName(value: string);
    /**
     * @stability stable
     */
    get vaultNameInput(): string | undefined;
    private _retentionRule?;
    /**
     * @stability stable
     */
    get retentionRule(): DataProtectionBackupPolicyPostgresqlRetentionRule[];
    /**
     * @stability stable
     */
    set retentionRule(value: DataProtectionBackupPolicyPostgresqlRetentionRule[]);
    /**
     * @stability stable
     */
    resetRetentionRule(): void;
    /**
     * @stability stable
     */
    get retentionRuleInput(): DataProtectionBackupPolicyPostgresqlRetentionRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DataProtectionBackupPolicyPostgresqlTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DataProtectionBackupPolicyPostgresqlTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DataProtectionBackupPolicyPostgresqlTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
