import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface DnsSrvRecordConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#name DnsSrvRecord#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#resource_group_name DnsSrvRecord#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#tags DnsSrvRecord#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#ttl DnsSrvRecord#ttl}.
     *
     * @stability stable
     */
    readonly ttl: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#zone_name DnsSrvRecord#zone_name}.
     *
     * @stability stable
     */
    readonly zoneName: string;
    /**
     * record block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#record DnsSrvRecord#record}
     *
     * @stability stable
     */
    readonly record: DnsSrvRecordRecord[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#timeouts DnsSrvRecord#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: DnsSrvRecordTimeouts;
}
/**
 * @stability stable
 */
export interface DnsSrvRecordRecord {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#port DnsSrvRecord#port}.
     *
     * @stability stable
     */
    readonly port: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#priority DnsSrvRecord#priority}.
     *
     * @stability stable
     */
    readonly priority: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#target DnsSrvRecord#target}.
     *
     * @stability stable
     */
    readonly target: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#weight DnsSrvRecord#weight}.
     *
     * @stability stable
     */
    readonly weight: number;
}
export declare function dnsSrvRecordRecordToTerraform(struct?: DnsSrvRecordRecord): any;
/**
 * @stability stable
 */
export interface DnsSrvRecordTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#create DnsSrvRecord#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#delete DnsSrvRecord#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#read DnsSrvRecord#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html#update DnsSrvRecord#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function dnsSrvRecordTimeoutsToTerraform(struct?: DnsSrvRecordTimeoutsOutputReference | DnsSrvRecordTimeouts): any;
/**
 * @stability stable
 */
export declare class DnsSrvRecordTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): DnsSrvRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: DnsSrvRecordTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html azurerm_dns_srv_record}.
 *
 * @stability stable
 */
export declare class DnsSrvRecord extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/dns_srv_record.html azurerm_dns_srv_record} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: DnsSrvRecordConfig);
    /**
     * @stability stable
     */
    get fqdn(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _ttl?;
    /**
     * @stability stable
     */
    get ttl(): number;
    /**
     * @stability stable
     */
    set ttl(value: number);
    /**
     * @stability stable
     */
    get ttlInput(): number | undefined;
    private _zoneName?;
    /**
     * @stability stable
     */
    get zoneName(): string;
    /**
     * @stability stable
     */
    set zoneName(value: string);
    /**
     * @stability stable
     */
    get zoneNameInput(): string | undefined;
    private _record?;
    /**
     * @stability stable
     */
    get record(): DnsSrvRecordRecord[];
    /**
     * @stability stable
     */
    set record(value: DnsSrvRecordRecord[]);
    /**
     * @stability stable
     */
    get recordInput(): DnsSrvRecordRecord[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): DnsSrvRecordTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: DnsSrvRecordTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): DnsSrvRecordTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
