import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface EventgridDomainConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#inbound_ip_rule EventgridDomain#inbound_ip_rule}.
     *
     * @stability stable
     */
    readonly inboundIpRule?: EventgridDomainInboundIpRule[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#input_schema EventgridDomain#input_schema}.
     *
     * @stability stable
     */
    readonly inputSchema?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#location EventgridDomain#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#name EventgridDomain#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#public_network_access_enabled EventgridDomain#public_network_access_enabled}.
     *
     * @stability stable
     */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#resource_group_name EventgridDomain#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#tags EventgridDomain#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * identity block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#identity EventgridDomain#identity}
     *
     * @stability stable
     */
    readonly identity?: EventgridDomainIdentity;
    /**
     * input_mapping_default_values block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#input_mapping_default_values EventgridDomain#input_mapping_default_values}
     *
     * @stability stable
     */
    readonly inputMappingDefaultValues?: EventgridDomainInputMappingDefaultValues;
    /**
     * input_mapping_fields block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#input_mapping_fields EventgridDomain#input_mapping_fields}
     *
     * @stability stable
     */
    readonly inputMappingFields?: EventgridDomainInputMappingFields;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#timeouts EventgridDomain#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: EventgridDomainTimeouts;
}
/**
 * @stability stable
 */
export interface EventgridDomainInboundIpRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#action EventgridDomain#action}.
     *
     * @stability stable
     */
    readonly action?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#ip_mask EventgridDomain#ip_mask}.
     *
     * @stability stable
     */
    readonly ipMask?: string;
}
export declare function eventgridDomainInboundIpRuleToTerraform(struct?: EventgridDomainInboundIpRule): any;
/**
 * @stability stable
 */
export interface EventgridDomainIdentity {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#identity_ids EventgridDomain#identity_ids}.
     *
     * @stability stable
     */
    readonly identityIds?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#type EventgridDomain#type}.
     *
     * @stability stable
     */
    readonly type: string;
}
export declare function eventgridDomainIdentityToTerraform(struct?: EventgridDomainIdentityOutputReference | EventgridDomainIdentity): any;
/**
 * @stability stable
 */
export declare class EventgridDomainIdentityOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridDomainIdentity | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridDomainIdentity | undefined);
    private _identityIds?;
    /**
     * @stability stable
     */
    get identityIds(): string[];
    /**
     * @stability stable
     */
    set identityIds(value: string[]);
    /**
     * @stability stable
     */
    resetIdentityIds(): void;
    /**
     * @stability stable
     */
    get identityIdsInput(): string[] | undefined;
    private _type?;
    /**
     * @stability stable
     */
    get type(): string;
    /**
     * @stability stable
     */
    set type(value: string);
    /**
     * @stability stable
     */
    get typeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridDomainInputMappingDefaultValues {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#data_version EventgridDomain#data_version}.
     *
     * @stability stable
     */
    readonly dataVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#event_type EventgridDomain#event_type}.
     *
     * @stability stable
     */
    readonly eventType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#subject EventgridDomain#subject}.
     *
     * @stability stable
     */
    readonly subject?: string;
}
export declare function eventgridDomainInputMappingDefaultValuesToTerraform(struct?: EventgridDomainInputMappingDefaultValuesOutputReference | EventgridDomainInputMappingDefaultValues): any;
/**
 * @stability stable
 */
export declare class EventgridDomainInputMappingDefaultValuesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridDomainInputMappingDefaultValues | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridDomainInputMappingDefaultValues | undefined);
    private _dataVersion?;
    /**
     * @stability stable
     */
    get dataVersion(): string;
    /**
     * @stability stable
     */
    set dataVersion(value: string);
    /**
     * @stability stable
     */
    resetDataVersion(): void;
    /**
     * @stability stable
     */
    get dataVersionInput(): string | undefined;
    private _eventType?;
    /**
     * @stability stable
     */
    get eventType(): string;
    /**
     * @stability stable
     */
    set eventType(value: string);
    /**
     * @stability stable
     */
    resetEventType(): void;
    /**
     * @stability stable
     */
    get eventTypeInput(): string | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    set subject(value: string);
    /**
     * @stability stable
     */
    resetSubject(): void;
    /**
     * @stability stable
     */
    get subjectInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridDomainInputMappingFields {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#data_version EventgridDomain#data_version}.
     *
     * @stability stable
     */
    readonly dataVersion?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#event_time EventgridDomain#event_time}.
     *
     * @stability stable
     */
    readonly eventTime?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#event_type EventgridDomain#event_type}.
     *
     * @stability stable
     */
    readonly eventType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#id EventgridDomain#id}.
     *
     * @stability stable
     */
    readonly id?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#subject EventgridDomain#subject}.
     *
     * @stability stable
     */
    readonly subject?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#topic EventgridDomain#topic}.
     *
     * @stability stable
     */
    readonly topic?: string;
}
export declare function eventgridDomainInputMappingFieldsToTerraform(struct?: EventgridDomainInputMappingFieldsOutputReference | EventgridDomainInputMappingFields): any;
/**
 * @stability stable
 */
export declare class EventgridDomainInputMappingFieldsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridDomainInputMappingFields | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridDomainInputMappingFields | undefined);
    private _dataVersion?;
    /**
     * @stability stable
     */
    get dataVersion(): string;
    /**
     * @stability stable
     */
    set dataVersion(value: string);
    /**
     * @stability stable
     */
    resetDataVersion(): void;
    /**
     * @stability stable
     */
    get dataVersionInput(): string | undefined;
    private _eventTime?;
    /**
     * @stability stable
     */
    get eventTime(): string;
    /**
     * @stability stable
     */
    set eventTime(value: string);
    /**
     * @stability stable
     */
    resetEventTime(): void;
    /**
     * @stability stable
     */
    get eventTimeInput(): string | undefined;
    private _eventType?;
    /**
     * @stability stable
     */
    get eventType(): string;
    /**
     * @stability stable
     */
    set eventType(value: string);
    /**
     * @stability stable
     */
    resetEventType(): void;
    /**
     * @stability stable
     */
    get eventTypeInput(): string | undefined;
    private _id?;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    set id(value: string);
    /**
     * @stability stable
     */
    resetId(): void;
    /**
     * @stability stable
     */
    get idInput(): string | undefined;
    private _subject?;
    /**
     * @stability stable
     */
    get subject(): string;
    /**
     * @stability stable
     */
    set subject(value: string);
    /**
     * @stability stable
     */
    resetSubject(): void;
    /**
     * @stability stable
     */
    get subjectInput(): string | undefined;
    private _topic?;
    /**
     * @stability stable
     */
    get topic(): string;
    /**
     * @stability stable
     */
    set topic(value: string);
    /**
     * @stability stable
     */
    resetTopic(): void;
    /**
     * @stability stable
     */
    get topicInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface EventgridDomainTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#create EventgridDomain#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#delete EventgridDomain#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#read EventgridDomain#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html#update EventgridDomain#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function eventgridDomainTimeoutsToTerraform(struct?: EventgridDomainTimeoutsOutputReference | EventgridDomainTimeouts): any;
/**
 * @stability stable
 */
export declare class EventgridDomainTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): EventgridDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: EventgridDomainTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html azurerm_eventgrid_domain}.
 *
 * @stability stable
 */
export declare class EventgridDomain extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/eventgrid_domain.html azurerm_eventgrid_domain} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: EventgridDomainConfig);
    /**
     * @stability stable
     */
    get endpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    private _inboundIpRule?;
    /**
     * @stability stable
     */
    get inboundIpRule(): EventgridDomainInboundIpRule[];
    /**
     * @stability stable
     */
    set inboundIpRule(value: EventgridDomainInboundIpRule[]);
    /**
     * @stability stable
     */
    resetInboundIpRule(): void;
    /**
     * @stability stable
     */
    get inboundIpRuleInput(): EventgridDomainInboundIpRule[] | undefined;
    private _inputSchema?;
    /**
     * @stability stable
     */
    get inputSchema(): string;
    /**
     * @stability stable
     */
    set inputSchema(value: string);
    /**
     * @stability stable
     */
    resetInputSchema(): void;
    /**
     * @stability stable
     */
    get inputSchemaInput(): string | undefined;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    /**
     * @stability stable
     */
    get primaryAccessKey(): string;
    private _publicNetworkAccessEnabled?;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetPublicNetworkAccessEnabled(): void;
    /**
     * @stability stable
     */
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get secondaryAccessKey(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _identity;
    /**
     * @stability stable
     */
    get identity(): EventgridDomainIdentityOutputReference;
    /**
     * @stability stable
     */
    putIdentity(value: EventgridDomainIdentity): void;
    /**
     * @stability stable
     */
    resetIdentity(): void;
    /**
     * @stability stable
     */
    get identityInput(): EventgridDomainIdentity | undefined;
    private _inputMappingDefaultValues;
    /**
     * @stability stable
     */
    get inputMappingDefaultValues(): EventgridDomainInputMappingDefaultValuesOutputReference;
    /**
     * @stability stable
     */
    putInputMappingDefaultValues(value: EventgridDomainInputMappingDefaultValues): void;
    /**
     * @stability stable
     */
    resetInputMappingDefaultValues(): void;
    /**
     * @stability stable
     */
    get inputMappingDefaultValuesInput(): EventgridDomainInputMappingDefaultValues | undefined;
    private _inputMappingFields;
    /**
     * @stability stable
     */
    get inputMappingFields(): EventgridDomainInputMappingFieldsOutputReference;
    /**
     * @stability stable
     */
    putInputMappingFields(value: EventgridDomainInputMappingFields): void;
    /**
     * @stability stable
     */
    resetInputMappingFields(): void;
    /**
     * @stability stable
     */
    get inputMappingFieldsInput(): EventgridDomainInputMappingFields | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): EventgridDomainTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: EventgridDomainTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): EventgridDomainTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
