import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#custom_block_response_body FrontdoorFirewallPolicy#custom_block_response_body}.
     *
     * @stability stable
     */
    readonly customBlockResponseBody?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#custom_block_response_status_code FrontdoorFirewallPolicy#custom_block_response_status_code}.
     *
     * @stability stable
     */
    readonly customBlockResponseStatusCode?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#enabled FrontdoorFirewallPolicy#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#mode FrontdoorFirewallPolicy#mode}.
     *
     * @stability stable
     */
    readonly mode?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#name FrontdoorFirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#redirect_url FrontdoorFirewallPolicy#redirect_url}.
     *
     * @stability stable
     */
    readonly redirectUrl?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#resource_group_name FrontdoorFirewallPolicy#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#tags FrontdoorFirewallPolicy#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * custom_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#custom_rule FrontdoorFirewallPolicy#custom_rule}
     *
     * @stability stable
     */
    readonly customRule?: FrontdoorFirewallPolicyCustomRule[];
    /**
     * managed_rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#managed_rule FrontdoorFirewallPolicy#managed_rule}
     *
     * @stability stable
     */
    readonly managedRule?: FrontdoorFirewallPolicyManagedRule[];
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#timeouts FrontdoorFirewallPolicy#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: FrontdoorFirewallPolicyTimeouts;
}
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyCustomRuleMatchCondition {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#match_values FrontdoorFirewallPolicy#match_values}.
     *
     * @stability stable
     */
    readonly matchValues: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#match_variable FrontdoorFirewallPolicy#match_variable}.
     *
     * @stability stable
     */
    readonly matchVariable: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#negation_condition FrontdoorFirewallPolicy#negation_condition}.
     *
     * @stability stable
     */
    readonly negationCondition?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#operator FrontdoorFirewallPolicy#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#selector FrontdoorFirewallPolicy#selector}.
     *
     * @stability stable
     */
    readonly selector?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#transforms FrontdoorFirewallPolicy#transforms}.
     *
     * @stability stable
     */
    readonly transforms?: string[];
}
export declare function frontdoorFirewallPolicyCustomRuleMatchConditionToTerraform(struct?: FrontdoorFirewallPolicyCustomRuleMatchCondition): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyCustomRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#action FrontdoorFirewallPolicy#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#enabled FrontdoorFirewallPolicy#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#name FrontdoorFirewallPolicy#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#priority FrontdoorFirewallPolicy#priority}.
     *
     * @stability stable
     */
    readonly priority?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#rate_limit_duration_in_minutes FrontdoorFirewallPolicy#rate_limit_duration_in_minutes}.
     *
     * @stability stable
     */
    readonly rateLimitDurationInMinutes?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#rate_limit_threshold FrontdoorFirewallPolicy#rate_limit_threshold}.
     *
     * @stability stable
     */
    readonly rateLimitThreshold?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#type FrontdoorFirewallPolicy#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * match_condition block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#match_condition FrontdoorFirewallPolicy#match_condition}
     *
     * @stability stable
     */
    readonly matchCondition?: FrontdoorFirewallPolicyCustomRuleMatchCondition[];
}
export declare function frontdoorFirewallPolicyCustomRuleToTerraform(struct?: FrontdoorFirewallPolicyCustomRule): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyManagedRuleExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#match_variable FrontdoorFirewallPolicy#match_variable}.
     *
     * @stability stable
     */
    readonly matchVariable: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#operator FrontdoorFirewallPolicy#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#selector FrontdoorFirewallPolicy#selector}.
     *
     * @stability stable
     */
    readonly selector: string;
}
export declare function frontdoorFirewallPolicyManagedRuleExclusionToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleExclusion): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyManagedRuleOverrideExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#match_variable FrontdoorFirewallPolicy#match_variable}.
     *
     * @stability stable
     */
    readonly matchVariable: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#operator FrontdoorFirewallPolicy#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#selector FrontdoorFirewallPolicy#selector}.
     *
     * @stability stable
     */
    readonly selector: string;
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideExclusionToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideExclusion): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#match_variable FrontdoorFirewallPolicy#match_variable}.
     *
     * @stability stable
     */
    readonly matchVariable: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#operator FrontdoorFirewallPolicy#operator}.
     *
     * @stability stable
     */
    readonly operator: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#selector FrontdoorFirewallPolicy#selector}.
     *
     * @stability stable
     */
    readonly selector: string;
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideRuleExclusionToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyManagedRuleOverrideRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#action FrontdoorFirewallPolicy#action}.
     *
     * @stability stable
     */
    readonly action: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#enabled FrontdoorFirewallPolicy#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#rule_id FrontdoorFirewallPolicy#rule_id}.
     *
     * @stability stable
     */
    readonly ruleId: string;
    /**
     * exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#exclusion FrontdoorFirewallPolicy#exclusion}
     *
     * @stability stable
     */
    readonly exclusion?: FrontdoorFirewallPolicyManagedRuleOverrideRuleExclusion[];
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideRuleToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverrideRule): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyManagedRuleOverride {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#rule_group_name FrontdoorFirewallPolicy#rule_group_name}.
     *
     * @stability stable
     */
    readonly ruleGroupName: string;
    /**
     * exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#exclusion FrontdoorFirewallPolicy#exclusion}
     *
     * @stability stable
     */
    readonly exclusion?: FrontdoorFirewallPolicyManagedRuleOverrideExclusion[];
    /**
     * rule block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#rule FrontdoorFirewallPolicy#rule}
     *
     * @stability stable
     */
    readonly rule?: FrontdoorFirewallPolicyManagedRuleOverrideRule[];
}
export declare function frontdoorFirewallPolicyManagedRuleOverrideToTerraform(struct?: FrontdoorFirewallPolicyManagedRuleOverride): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyManagedRule {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#type FrontdoorFirewallPolicy#type}.
     *
     * @stability stable
     */
    readonly type: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#version FrontdoorFirewallPolicy#version}.
     *
     * @stability stable
     */
    readonly version: string;
    /**
     * exclusion block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#exclusion FrontdoorFirewallPolicy#exclusion}
     *
     * @stability stable
     */
    readonly exclusion?: FrontdoorFirewallPolicyManagedRuleExclusion[];
    /**
     * override block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#override FrontdoorFirewallPolicy#override}
     *
     * @stability stable
     */
    readonly override?: FrontdoorFirewallPolicyManagedRuleOverride[];
}
export declare function frontdoorFirewallPolicyManagedRuleToTerraform(struct?: FrontdoorFirewallPolicyManagedRule): any;
/**
 * @stability stable
 */
export interface FrontdoorFirewallPolicyTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#create FrontdoorFirewallPolicy#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#delete FrontdoorFirewallPolicy#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#read FrontdoorFirewallPolicy#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html#update FrontdoorFirewallPolicy#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function frontdoorFirewallPolicyTimeoutsToTerraform(struct?: FrontdoorFirewallPolicyTimeoutsOutputReference | FrontdoorFirewallPolicyTimeouts): any;
/**
 * @stability stable
 */
export declare class FrontdoorFirewallPolicyTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): FrontdoorFirewallPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: FrontdoorFirewallPolicyTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html azurerm_frontdoor_firewall_policy}.
 *
 * @stability stable
 */
export declare class FrontdoorFirewallPolicy extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/frontdoor_firewall_policy.html azurerm_frontdoor_firewall_policy} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: FrontdoorFirewallPolicyConfig);
    private _customBlockResponseBody?;
    /**
     * @stability stable
     */
    get customBlockResponseBody(): string;
    /**
     * @stability stable
     */
    set customBlockResponseBody(value: string);
    /**
     * @stability stable
     */
    resetCustomBlockResponseBody(): void;
    /**
     * @stability stable
     */
    get customBlockResponseBodyInput(): string | undefined;
    private _customBlockResponseStatusCode?;
    /**
     * @stability stable
     */
    get customBlockResponseStatusCode(): number;
    /**
     * @stability stable
     */
    set customBlockResponseStatusCode(value: number);
    /**
     * @stability stable
     */
    resetCustomBlockResponseStatusCode(): void;
    /**
     * @stability stable
     */
    get customBlockResponseStatusCodeInput(): number | undefined;
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get frontendEndpointIds(): string[];
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get location(): string;
    private _mode?;
    /**
     * @stability stable
     */
    get mode(): string;
    /**
     * @stability stable
     */
    set mode(value: string);
    /**
     * @stability stable
     */
    resetMode(): void;
    /**
     * @stability stable
     */
    get modeInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _redirectUrl?;
    /**
     * @stability stable
     */
    get redirectUrl(): string;
    /**
     * @stability stable
     */
    set redirectUrl(value: string);
    /**
     * @stability stable
     */
    resetRedirectUrl(): void;
    /**
     * @stability stable
     */
    get redirectUrlInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _customRule?;
    /**
     * @stability stable
     */
    get customRule(): FrontdoorFirewallPolicyCustomRule[];
    /**
     * @stability stable
     */
    set customRule(value: FrontdoorFirewallPolicyCustomRule[]);
    /**
     * @stability stable
     */
    resetCustomRule(): void;
    /**
     * @stability stable
     */
    get customRuleInput(): FrontdoorFirewallPolicyCustomRule[] | undefined;
    private _managedRule?;
    /**
     * @stability stable
     */
    get managedRule(): FrontdoorFirewallPolicyManagedRule[];
    /**
     * @stability stable
     */
    set managedRule(value: FrontdoorFirewallPolicyManagedRule[]);
    /**
     * @stability stable
     */
    resetManagedRule(): void;
    /**
     * @stability stable
     */
    get managedRuleInput(): FrontdoorFirewallPolicyManagedRule[] | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): FrontdoorFirewallPolicyTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: FrontdoorFirewallPolicyTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): FrontdoorFirewallPolicyTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
