import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#cluster_version HdinsightKafkaCluster#cluster_version}.
     *
     * @stability stable
     */
    readonly clusterVersion: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#encryption_in_transit_enabled HdinsightKafkaCluster#encryption_in_transit_enabled}.
     *
     * @stability stable
     */
    readonly encryptionInTransitEnabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#location HdinsightKafkaCluster#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#name HdinsightKafkaCluster#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#resource_group_name HdinsightKafkaCluster#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#tags HdinsightKafkaCluster#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#tier HdinsightKafkaCluster#tier}.
     *
     * @stability stable
     */
    readonly tier: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#tls_min_version HdinsightKafkaCluster#tls_min_version}.
     *
     * @stability stable
     */
    readonly tlsMinVersion?: string;
    /**
     * component_version block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#component_version HdinsightKafkaCluster#component_version}
     *
     * @stability stable
     */
    readonly componentVersion: HdinsightKafkaClusterComponentVersion;
    /**
     * gateway block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#gateway HdinsightKafkaCluster#gateway}
     *
     * @stability stable
     */
    readonly gateway: HdinsightKafkaClusterGateway;
    /**
     * metastores block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#metastores HdinsightKafkaCluster#metastores}
     *
     * @stability stable
     */
    readonly metastores?: HdinsightKafkaClusterMetastores;
    /**
     * monitor block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#monitor HdinsightKafkaCluster#monitor}
     *
     * @stability stable
     */
    readonly monitor?: HdinsightKafkaClusterMonitor;
    /**
     * rest_proxy block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#rest_proxy HdinsightKafkaCluster#rest_proxy}
     *
     * @stability stable
     */
    readonly restProxy?: HdinsightKafkaClusterRestProxy;
    /**
     * roles block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#roles HdinsightKafkaCluster#roles}
     *
     * @stability stable
     */
    readonly roles: HdinsightKafkaClusterRoles;
    /**
     * security_profile block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#security_profile HdinsightKafkaCluster#security_profile}
     *
     * @stability stable
     */
    readonly securityProfile?: HdinsightKafkaClusterSecurityProfile;
    /**
     * storage_account block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#storage_account HdinsightKafkaCluster#storage_account}
     *
     * @stability stable
     */
    readonly storageAccount?: HdinsightKafkaClusterStorageAccount[];
    /**
     * storage_account_gen2 block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#storage_account_gen2 HdinsightKafkaCluster#storage_account_gen2}
     *
     * @stability stable
     */
    readonly storageAccountGen2?: HdinsightKafkaClusterStorageAccountGen2;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#timeouts HdinsightKafkaCluster#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: HdinsightKafkaClusterTimeouts;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterComponentVersion {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#kafka HdinsightKafkaCluster#kafka}.
     *
     * @stability stable
     */
    readonly kafka: string;
}
export declare function hdinsightKafkaClusterComponentVersionToTerraform(struct?: HdinsightKafkaClusterComponentVersionOutputReference | HdinsightKafkaClusterComponentVersion): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterComponentVersionOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterComponentVersion | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterComponentVersion | undefined);
    private _kafka?;
    /**
     * @stability stable
     */
    get kafka(): string;
    /**
     * @stability stable
     */
    set kafka(value: string);
    /**
     * @stability stable
     */
    get kafkaInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterGateway {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#enabled HdinsightKafkaCluster#enabled}.
     *
     * @stability stable
     */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightKafkaClusterGatewayToTerraform(struct?: HdinsightKafkaClusterGatewayOutputReference | HdinsightKafkaClusterGateway): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterGatewayOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterGateway | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterGateway | undefined);
    private _enabled?;
    /**
     * @stability stable
     */
    get enabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set enabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEnabled(): void;
    /**
     * @stability stable
     */
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterMetastoresAmbari {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#database_name HdinsightKafkaCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#server HdinsightKafkaCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresAmbariToTerraform(struct?: HdinsightKafkaClusterMetastoresAmbariOutputReference | HdinsightKafkaClusterMetastoresAmbari): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterMetastoresAmbariOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterMetastoresAmbari | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterMetastoresAmbari | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterMetastoresHive {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#database_name HdinsightKafkaCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#server HdinsightKafkaCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresHiveToTerraform(struct?: HdinsightKafkaClusterMetastoresHiveOutputReference | HdinsightKafkaClusterMetastoresHive): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterMetastoresHiveOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterMetastoresHive | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterMetastoresHive | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterMetastoresOozie {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#database_name HdinsightKafkaCluster#database_name}.
     *
     * @stability stable
     */
    readonly databaseName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#server HdinsightKafkaCluster#server}.
     *
     * @stability stable
     */
    readonly server: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
}
export declare function hdinsightKafkaClusterMetastoresOozieToTerraform(struct?: HdinsightKafkaClusterMetastoresOozieOutputReference | HdinsightKafkaClusterMetastoresOozie): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterMetastoresOozieOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterMetastoresOozie | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterMetastoresOozie | undefined);
    private _databaseName?;
    /**
     * @stability stable
     */
    get databaseName(): string;
    /**
     * @stability stable
     */
    set databaseName(value: string);
    /**
     * @stability stable
     */
    get databaseNameInput(): string | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _server?;
    /**
     * @stability stable
     */
    get server(): string;
    /**
     * @stability stable
     */
    set server(value: string);
    /**
     * @stability stable
     */
    get serverInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterMetastores {
    /**
     * ambari block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#ambari HdinsightKafkaCluster#ambari}
     *
     * @stability stable
     */
    readonly ambari?: HdinsightKafkaClusterMetastoresAmbari;
    /**
     * hive block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#hive HdinsightKafkaCluster#hive}
     *
     * @stability stable
     */
    readonly hive?: HdinsightKafkaClusterMetastoresHive;
    /**
     * oozie block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#oozie HdinsightKafkaCluster#oozie}
     *
     * @stability stable
     */
    readonly oozie?: HdinsightKafkaClusterMetastoresOozie;
}
export declare function hdinsightKafkaClusterMetastoresToTerraform(struct?: HdinsightKafkaClusterMetastoresOutputReference | HdinsightKafkaClusterMetastores): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterMetastoresOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterMetastores | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterMetastores | undefined);
    private _ambari;
    /**
     * @stability stable
     */
    get ambari(): HdinsightKafkaClusterMetastoresAmbariOutputReference;
    /**
     * @stability stable
     */
    putAmbari(value: HdinsightKafkaClusterMetastoresAmbari): void;
    /**
     * @stability stable
     */
    resetAmbari(): void;
    /**
     * @stability stable
     */
    get ambariInput(): HdinsightKafkaClusterMetastoresAmbari | undefined;
    private _hive;
    /**
     * @stability stable
     */
    get hive(): HdinsightKafkaClusterMetastoresHiveOutputReference;
    /**
     * @stability stable
     */
    putHive(value: HdinsightKafkaClusterMetastoresHive): void;
    /**
     * @stability stable
     */
    resetHive(): void;
    /**
     * @stability stable
     */
    get hiveInput(): HdinsightKafkaClusterMetastoresHive | undefined;
    private _oozie;
    /**
     * @stability stable
     */
    get oozie(): HdinsightKafkaClusterMetastoresOozieOutputReference;
    /**
     * @stability stable
     */
    putOozie(value: HdinsightKafkaClusterMetastoresOozie): void;
    /**
     * @stability stable
     */
    resetOozie(): void;
    /**
     * @stability stable
     */
    get oozieInput(): HdinsightKafkaClusterMetastoresOozie | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterMonitor {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#log_analytics_workspace_id HdinsightKafkaCluster#log_analytics_workspace_id}.
     *
     * @stability stable
     */
    readonly logAnalyticsWorkspaceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#primary_key HdinsightKafkaCluster#primary_key}.
     *
     * @stability stable
     */
    readonly primaryKey: string;
}
export declare function hdinsightKafkaClusterMonitorToTerraform(struct?: HdinsightKafkaClusterMonitorOutputReference | HdinsightKafkaClusterMonitor): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterMonitorOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterMonitor | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterMonitor | undefined);
    private _logAnalyticsWorkspaceId?;
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceId(): string;
    /**
     * @stability stable
     */
    set logAnalyticsWorkspaceId(value: string);
    /**
     * @stability stable
     */
    get logAnalyticsWorkspaceIdInput(): string | undefined;
    private _primaryKey?;
    /**
     * @stability stable
     */
    get primaryKey(): string;
    /**
     * @stability stable
     */
    set primaryKey(value: string);
    /**
     * @stability stable
     */
    get primaryKeyInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterRestProxy {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#security_group_id HdinsightKafkaCluster#security_group_id}.
     *
     * @stability stable
     */
    readonly securityGroupId: string;
}
export declare function hdinsightKafkaClusterRestProxyToTerraform(struct?: HdinsightKafkaClusterRestProxyOutputReference | HdinsightKafkaClusterRestProxy): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterRestProxyOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterRestProxy | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterRestProxy | undefined);
    private _securityGroupId?;
    /**
     * @stability stable
     */
    get securityGroupId(): string;
    /**
     * @stability stable
     */
    set securityGroupId(value: string);
    /**
     * @stability stable
     */
    get securityGroupIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterRolesHeadNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#ssh_keys HdinsightKafkaCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#subnet_id HdinsightKafkaCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#virtual_network_id HdinsightKafkaCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#vm_size HdinsightKafkaCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesHeadNodeToTerraform(struct?: HdinsightKafkaClusterRolesHeadNodeOutputReference | HdinsightKafkaClusterRolesHeadNode): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterRolesHeadNodeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterRolesHeadNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterRolesHeadNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterRolesKafkaManagementNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#ssh_keys HdinsightKafkaCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#subnet_id HdinsightKafkaCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#virtual_network_id HdinsightKafkaCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#vm_size HdinsightKafkaCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesKafkaManagementNodeToTerraform(struct?: HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference | HdinsightKafkaClusterRolesKafkaManagementNode): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterRolesKafkaManagementNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterRolesKafkaManagementNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterRolesWorkerNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#min_instance_count HdinsightKafkaCluster#min_instance_count}.
     *
     * @stability stable
     */
    readonly minInstanceCount?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#number_of_disks_per_node HdinsightKafkaCluster#number_of_disks_per_node}.
     *
     * @stability stable
     */
    readonly numberOfDisksPerNode: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#ssh_keys HdinsightKafkaCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#subnet_id HdinsightKafkaCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#target_instance_count HdinsightKafkaCluster#target_instance_count}.
     *
     * @stability stable
     */
    readonly targetInstanceCount: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#virtual_network_id HdinsightKafkaCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#vm_size HdinsightKafkaCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesWorkerNodeToTerraform(struct?: HdinsightKafkaClusterRolesWorkerNodeOutputReference | HdinsightKafkaClusterRolesWorkerNode): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterRolesWorkerNodeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterRolesWorkerNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterRolesWorkerNode | undefined);
    private _minInstanceCount?;
    /**
     * @stability stable
     */
    get minInstanceCount(): number;
    /**
     * @stability stable
     */
    set minInstanceCount(value: number);
    /**
     * @stability stable
     */
    resetMinInstanceCount(): void;
    /**
     * @stability stable
     */
    get minInstanceCountInput(): number | undefined;
    private _numberOfDisksPerNode?;
    /**
     * @stability stable
     */
    get numberOfDisksPerNode(): number;
    /**
     * @stability stable
     */
    set numberOfDisksPerNode(value: number);
    /**
     * @stability stable
     */
    get numberOfDisksPerNodeInput(): number | undefined;
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _targetInstanceCount?;
    /**
     * @stability stable
     */
    get targetInstanceCount(): number;
    /**
     * @stability stable
     */
    set targetInstanceCount(value: number);
    /**
     * @stability stable
     */
    get targetInstanceCountInput(): number | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterRolesZookeeperNode {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#password HdinsightKafkaCluster#password}.
     *
     * @stability stable
     */
    readonly password?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#ssh_keys HdinsightKafkaCluster#ssh_keys}.
     *
     * @stability stable
     */
    readonly sshKeys?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#subnet_id HdinsightKafkaCluster#subnet_id}.
     *
     * @stability stable
     */
    readonly subnetId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#username HdinsightKafkaCluster#username}.
     *
     * @stability stable
     */
    readonly username: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#virtual_network_id HdinsightKafkaCluster#virtual_network_id}.
     *
     * @stability stable
     */
    readonly virtualNetworkId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#vm_size HdinsightKafkaCluster#vm_size}.
     *
     * @stability stable
     */
    readonly vmSize: string;
}
export declare function hdinsightKafkaClusterRolesZookeeperNodeToTerraform(struct?: HdinsightKafkaClusterRolesZookeeperNodeOutputReference | HdinsightKafkaClusterRolesZookeeperNode): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterRolesZookeeperNodeOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterRolesZookeeperNode | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterRolesZookeeperNode | undefined);
    private _password?;
    /**
     * @stability stable
     */
    get password(): string;
    /**
     * @stability stable
     */
    set password(value: string);
    /**
     * @stability stable
     */
    resetPassword(): void;
    /**
     * @stability stable
     */
    get passwordInput(): string | undefined;
    private _sshKeys?;
    /**
     * @stability stable
     */
    get sshKeys(): string[];
    /**
     * @stability stable
     */
    set sshKeys(value: string[]);
    /**
     * @stability stable
     */
    resetSshKeys(): void;
    /**
     * @stability stable
     */
    get sshKeysInput(): string[] | undefined;
    private _subnetId?;
    /**
     * @stability stable
     */
    get subnetId(): string;
    /**
     * @stability stable
     */
    set subnetId(value: string);
    /**
     * @stability stable
     */
    resetSubnetId(): void;
    /**
     * @stability stable
     */
    get subnetIdInput(): string | undefined;
    private _username?;
    /**
     * @stability stable
     */
    get username(): string;
    /**
     * @stability stable
     */
    set username(value: string);
    /**
     * @stability stable
     */
    get usernameInput(): string | undefined;
    private _virtualNetworkId?;
    /**
     * @stability stable
     */
    get virtualNetworkId(): string;
    /**
     * @stability stable
     */
    set virtualNetworkId(value: string);
    /**
     * @stability stable
     */
    resetVirtualNetworkId(): void;
    /**
     * @stability stable
     */
    get virtualNetworkIdInput(): string | undefined;
    private _vmSize?;
    /**
     * @stability stable
     */
    get vmSize(): string;
    /**
     * @stability stable
     */
    set vmSize(value: string);
    /**
     * @stability stable
     */
    get vmSizeInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterRoles {
    /**
     * head_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#head_node HdinsightKafkaCluster#head_node}
     *
     * @stability stable
     */
    readonly headNode: HdinsightKafkaClusterRolesHeadNode;
    /**
     * kafka_management_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#kafka_management_node HdinsightKafkaCluster#kafka_management_node}
     *
     * @stability stable
     */
    readonly kafkaManagementNode?: HdinsightKafkaClusterRolesKafkaManagementNode;
    /**
     * worker_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#worker_node HdinsightKafkaCluster#worker_node}
     *
     * @stability stable
     */
    readonly workerNode: HdinsightKafkaClusterRolesWorkerNode;
    /**
     * zookeeper_node block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#zookeeper_node HdinsightKafkaCluster#zookeeper_node}
     *
     * @stability stable
     */
    readonly zookeeperNode: HdinsightKafkaClusterRolesZookeeperNode;
}
export declare function hdinsightKafkaClusterRolesToTerraform(struct?: HdinsightKafkaClusterRolesOutputReference | HdinsightKafkaClusterRoles): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterRolesOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterRoles | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterRoles | undefined);
    private _headNode;
    /**
     * @stability stable
     */
    get headNode(): HdinsightKafkaClusterRolesHeadNodeOutputReference;
    /**
     * @stability stable
     */
    putHeadNode(value: HdinsightKafkaClusterRolesHeadNode): void;
    /**
     * @stability stable
     */
    get headNodeInput(): HdinsightKafkaClusterRolesHeadNode | undefined;
    private _kafkaManagementNode;
    /**
     * @stability stable
     */
    get kafkaManagementNode(): HdinsightKafkaClusterRolesKafkaManagementNodeOutputReference;
    /**
     * @stability stable
     */
    putKafkaManagementNode(value: HdinsightKafkaClusterRolesKafkaManagementNode): void;
    /**
     * @stability stable
     */
    resetKafkaManagementNode(): void;
    /**
     * @stability stable
     */
    get kafkaManagementNodeInput(): HdinsightKafkaClusterRolesKafkaManagementNode | undefined;
    private _workerNode;
    /**
     * @stability stable
     */
    get workerNode(): HdinsightKafkaClusterRolesWorkerNodeOutputReference;
    /**
     * @stability stable
     */
    putWorkerNode(value: HdinsightKafkaClusterRolesWorkerNode): void;
    /**
     * @stability stable
     */
    get workerNodeInput(): HdinsightKafkaClusterRolesWorkerNode | undefined;
    private _zookeeperNode;
    /**
     * @stability stable
     */
    get zookeeperNode(): HdinsightKafkaClusterRolesZookeeperNodeOutputReference;
    /**
     * @stability stable
     */
    putZookeeperNode(value: HdinsightKafkaClusterRolesZookeeperNode): void;
    /**
     * @stability stable
     */
    get zookeeperNodeInput(): HdinsightKafkaClusterRolesZookeeperNode | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterSecurityProfile {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#aadds_resource_id HdinsightKafkaCluster#aadds_resource_id}.
     *
     * @stability stable
     */
    readonly aaddsResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#cluster_users_group_dns HdinsightKafkaCluster#cluster_users_group_dns}.
     *
     * @stability stable
     */
    readonly clusterUsersGroupDns?: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#domain_name HdinsightKafkaCluster#domain_name}.
     *
     * @stability stable
     */
    readonly domainName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#domain_user_password HdinsightKafkaCluster#domain_user_password}.
     *
     * @stability stable
     */
    readonly domainUserPassword: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#domain_username HdinsightKafkaCluster#domain_username}.
     *
     * @stability stable
     */
    readonly domainUsername: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#ldaps_urls HdinsightKafkaCluster#ldaps_urls}.
     *
     * @stability stable
     */
    readonly ldapsUrls: string[];
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#msi_resource_id HdinsightKafkaCluster#msi_resource_id}.
     *
     * @stability stable
     */
    readonly msiResourceId: string;
}
export declare function hdinsightKafkaClusterSecurityProfileToTerraform(struct?: HdinsightKafkaClusterSecurityProfileOutputReference | HdinsightKafkaClusterSecurityProfile): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterSecurityProfileOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterSecurityProfile | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterSecurityProfile | undefined);
    private _aaddsResourceId?;
    /**
     * @stability stable
     */
    get aaddsResourceId(): string;
    /**
     * @stability stable
     */
    set aaddsResourceId(value: string);
    /**
     * @stability stable
     */
    get aaddsResourceIdInput(): string | undefined;
    private _clusterUsersGroupDns?;
    /**
     * @stability stable
     */
    get clusterUsersGroupDns(): string[];
    /**
     * @stability stable
     */
    set clusterUsersGroupDns(value: string[]);
    /**
     * @stability stable
     */
    resetClusterUsersGroupDns(): void;
    /**
     * @stability stable
     */
    get clusterUsersGroupDnsInput(): string[] | undefined;
    private _domainName?;
    /**
     * @stability stable
     */
    get domainName(): string;
    /**
     * @stability stable
     */
    set domainName(value: string);
    /**
     * @stability stable
     */
    get domainNameInput(): string | undefined;
    private _domainUserPassword?;
    /**
     * @stability stable
     */
    get domainUserPassword(): string;
    /**
     * @stability stable
     */
    set domainUserPassword(value: string);
    /**
     * @stability stable
     */
    get domainUserPasswordInput(): string | undefined;
    private _domainUsername?;
    /**
     * @stability stable
     */
    get domainUsername(): string;
    /**
     * @stability stable
     */
    set domainUsername(value: string);
    /**
     * @stability stable
     */
    get domainUsernameInput(): string | undefined;
    private _ldapsUrls?;
    /**
     * @stability stable
     */
    get ldapsUrls(): string[];
    /**
     * @stability stable
     */
    set ldapsUrls(value: string[]);
    /**
     * @stability stable
     */
    get ldapsUrlsInput(): string[] | undefined;
    private _msiResourceId?;
    /**
     * @stability stable
     */
    get msiResourceId(): string;
    /**
     * @stability stable
     */
    set msiResourceId(value: string);
    /**
     * @stability stable
     */
    get msiResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterStorageAccount {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#is_default HdinsightKafkaCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#storage_account_key HdinsightKafkaCluster#storage_account_key}.
     *
     * @stability stable
     */
    readonly storageAccountKey: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#storage_container_id HdinsightKafkaCluster#storage_container_id}.
     *
     * @stability stable
     */
    readonly storageContainerId: string;
}
export declare function hdinsightKafkaClusterStorageAccountToTerraform(struct?: HdinsightKafkaClusterStorageAccount): any;
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterStorageAccountGen2 {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#filesystem_id HdinsightKafkaCluster#filesystem_id}.
     *
     * @stability stable
     */
    readonly filesystemId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#is_default HdinsightKafkaCluster#is_default}.
     *
     * @stability stable
     */
    readonly isDefault: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#managed_identity_resource_id HdinsightKafkaCluster#managed_identity_resource_id}.
     *
     * @stability stable
     */
    readonly managedIdentityResourceId: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#storage_resource_id HdinsightKafkaCluster#storage_resource_id}.
     *
     * @stability stable
     */
    readonly storageResourceId: string;
}
export declare function hdinsightKafkaClusterStorageAccountGen2ToTerraform(struct?: HdinsightKafkaClusterStorageAccountGen2OutputReference | HdinsightKafkaClusterStorageAccountGen2): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterStorageAccountGen2OutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterStorageAccountGen2 | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterStorageAccountGen2 | undefined);
    private _filesystemId?;
    /**
     * @stability stable
     */
    get filesystemId(): string;
    /**
     * @stability stable
     */
    set filesystemId(value: string);
    /**
     * @stability stable
     */
    get filesystemIdInput(): string | undefined;
    private _isDefault?;
    /**
     * @stability stable
     */
    get isDefault(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set isDefault(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    get isDefaultInput(): boolean | cdktf.IResolvable | undefined;
    private _managedIdentityResourceId?;
    /**
     * @stability stable
     */
    get managedIdentityResourceId(): string;
    /**
     * @stability stable
     */
    set managedIdentityResourceId(value: string);
    /**
     * @stability stable
     */
    get managedIdentityResourceIdInput(): string | undefined;
    private _storageResourceId?;
    /**
     * @stability stable
     */
    get storageResourceId(): string;
    /**
     * @stability stable
     */
    set storageResourceId(value: string);
    /**
     * @stability stable
     */
    get storageResourceIdInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface HdinsightKafkaClusterTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#create HdinsightKafkaCluster#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#delete HdinsightKafkaCluster#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#read HdinsightKafkaCluster#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html#update HdinsightKafkaCluster#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function hdinsightKafkaClusterTimeoutsToTerraform(struct?: HdinsightKafkaClusterTimeoutsOutputReference | HdinsightKafkaClusterTimeouts): any;
/**
 * @stability stable
 */
export declare class HdinsightKafkaClusterTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): HdinsightKafkaClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: HdinsightKafkaClusterTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html azurerm_hdinsight_kafka_cluster}.
 *
 * @stability stable
 */
export declare class HdinsightKafkaCluster extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/hdinsight_kafka_cluster.html azurerm_hdinsight_kafka_cluster} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: HdinsightKafkaClusterConfig);
    private _clusterVersion?;
    /**
     * @stability stable
     */
    get clusterVersion(): string;
    /**
     * @stability stable
     */
    set clusterVersion(value: string);
    /**
     * @stability stable
     */
    get clusterVersionInput(): string | undefined;
    private _encryptionInTransitEnabled?;
    /**
     * @stability stable
     */
    get encryptionInTransitEnabled(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set encryptionInTransitEnabled(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetEncryptionInTransitEnabled(): void;
    /**
     * @stability stable
     */
    get encryptionInTransitEnabledInput(): boolean | cdktf.IResolvable | undefined;
    /**
     * @stability stable
     */
    get httpsEndpoint(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get kafkaRestProxyEndpoint(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get sshEndpoint(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _tier?;
    /**
     * @stability stable
     */
    get tier(): string;
    /**
     * @stability stable
     */
    set tier(value: string);
    /**
     * @stability stable
     */
    get tierInput(): string | undefined;
    private _tlsMinVersion?;
    /**
     * @stability stable
     */
    get tlsMinVersion(): string;
    /**
     * @stability stable
     */
    set tlsMinVersion(value: string);
    /**
     * @stability stable
     */
    resetTlsMinVersion(): void;
    /**
     * @stability stable
     */
    get tlsMinVersionInput(): string | undefined;
    private _componentVersion;
    /**
     * @stability stable
     */
    get componentVersion(): HdinsightKafkaClusterComponentVersionOutputReference;
    /**
     * @stability stable
     */
    putComponentVersion(value: HdinsightKafkaClusterComponentVersion): void;
    /**
     * @stability stable
     */
    get componentVersionInput(): HdinsightKafkaClusterComponentVersion | undefined;
    private _gateway;
    /**
     * @stability stable
     */
    get gateway(): HdinsightKafkaClusterGatewayOutputReference;
    /**
     * @stability stable
     */
    putGateway(value: HdinsightKafkaClusterGateway): void;
    /**
     * @stability stable
     */
    get gatewayInput(): HdinsightKafkaClusterGateway | undefined;
    private _metastores;
    /**
     * @stability stable
     */
    get metastores(): HdinsightKafkaClusterMetastoresOutputReference;
    /**
     * @stability stable
     */
    putMetastores(value: HdinsightKafkaClusterMetastores): void;
    /**
     * @stability stable
     */
    resetMetastores(): void;
    /**
     * @stability stable
     */
    get metastoresInput(): HdinsightKafkaClusterMetastores | undefined;
    private _monitor;
    /**
     * @stability stable
     */
    get monitor(): HdinsightKafkaClusterMonitorOutputReference;
    /**
     * @stability stable
     */
    putMonitor(value: HdinsightKafkaClusterMonitor): void;
    /**
     * @stability stable
     */
    resetMonitor(): void;
    /**
     * @stability stable
     */
    get monitorInput(): HdinsightKafkaClusterMonitor | undefined;
    private _restProxy;
    /**
     * @stability stable
     */
    get restProxy(): HdinsightKafkaClusterRestProxyOutputReference;
    /**
     * @stability stable
     */
    putRestProxy(value: HdinsightKafkaClusterRestProxy): void;
    /**
     * @stability stable
     */
    resetRestProxy(): void;
    /**
     * @stability stable
     */
    get restProxyInput(): HdinsightKafkaClusterRestProxy | undefined;
    private _roles;
    /**
     * @stability stable
     */
    get roles(): HdinsightKafkaClusterRolesOutputReference;
    /**
     * @stability stable
     */
    putRoles(value: HdinsightKafkaClusterRoles): void;
    /**
     * @stability stable
     */
    get rolesInput(): HdinsightKafkaClusterRoles | undefined;
    private _securityProfile;
    /**
     * @stability stable
     */
    get securityProfile(): HdinsightKafkaClusterSecurityProfileOutputReference;
    /**
     * @stability stable
     */
    putSecurityProfile(value: HdinsightKafkaClusterSecurityProfile): void;
    /**
     * @stability stable
     */
    resetSecurityProfile(): void;
    /**
     * @stability stable
     */
    get securityProfileInput(): HdinsightKafkaClusterSecurityProfile | undefined;
    private _storageAccount?;
    /**
     * @stability stable
     */
    get storageAccount(): HdinsightKafkaClusterStorageAccount[];
    /**
     * @stability stable
     */
    set storageAccount(value: HdinsightKafkaClusterStorageAccount[]);
    /**
     * @stability stable
     */
    resetStorageAccount(): void;
    /**
     * @stability stable
     */
    get storageAccountInput(): HdinsightKafkaClusterStorageAccount[] | undefined;
    private _storageAccountGen2;
    /**
     * @stability stable
     */
    get storageAccountGen2(): HdinsightKafkaClusterStorageAccountGen2OutputReference;
    /**
     * @stability stable
     */
    putStorageAccountGen2(value: HdinsightKafkaClusterStorageAccountGen2): void;
    /**
     * @stability stable
     */
    resetStorageAccountGen2(): void;
    /**
     * @stability stable
     */
    get storageAccountGen2Input(): HdinsightKafkaClusterStorageAccountGen2 | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): HdinsightKafkaClusterTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: HdinsightKafkaClusterTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): HdinsightKafkaClusterTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
