import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface ImageConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#hyper_v_generation Image#hyper_v_generation}.
     *
     * @stability stable
     */
    readonly hyperVGeneration?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#location Image#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#name Image#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#resource_group_name Image#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#source_virtual_machine_id Image#source_virtual_machine_id}.
     *
     * @stability stable
     */
    readonly sourceVirtualMachineId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#tags Image#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#zone_resilient Image#zone_resilient}.
     *
     * @stability stable
     */
    readonly zoneResilient?: boolean | cdktf.IResolvable;
    /**
     * data_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#data_disk Image#data_disk}
     *
     * @stability stable
     */
    readonly dataDisk?: ImageDataDisk[];
    /**
     * os_disk block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#os_disk Image#os_disk}
     *
     * @stability stable
     */
    readonly osDisk?: ImageOsDisk;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#timeouts Image#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: ImageTimeouts;
}
/**
 * @stability stable
 */
export interface ImageDataDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#blob_uri Image#blob_uri}.
     *
     * @stability stable
     */
    readonly blobUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#caching Image#caching}.
     *
     * @stability stable
     */
    readonly caching?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#lun Image#lun}.
     *
     * @stability stable
     */
    readonly lun?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#managed_disk_id Image#managed_disk_id}.
     *
     * @stability stable
     */
    readonly managedDiskId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#size_gb Image#size_gb}.
     *
     * @stability stable
     */
    readonly sizeGb?: number;
}
export declare function imageDataDiskToTerraform(struct?: ImageDataDisk): any;
/**
 * @stability stable
 */
export interface ImageOsDisk {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#blob_uri Image#blob_uri}.
     *
     * @stability stable
     */
    readonly blobUri?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#caching Image#caching}.
     *
     * @stability stable
     */
    readonly caching?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#managed_disk_id Image#managed_disk_id}.
     *
     * @stability stable
     */
    readonly managedDiskId?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#os_state Image#os_state}.
     *
     * @stability stable
     */
    readonly osState?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#os_type Image#os_type}.
     *
     * @stability stable
     */
    readonly osType?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#size_gb Image#size_gb}.
     *
     * @stability stable
     */
    readonly sizeGb?: number;
}
export declare function imageOsDiskToTerraform(struct?: ImageOsDiskOutputReference | ImageOsDisk): any;
/**
 * @stability stable
 */
export declare class ImageOsDiskOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ImageOsDisk | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ImageOsDisk | undefined);
    private _blobUri?;
    /**
     * @stability stable
     */
    get blobUri(): string;
    /**
     * @stability stable
     */
    set blobUri(value: string);
    /**
     * @stability stable
     */
    resetBlobUri(): void;
    /**
     * @stability stable
     */
    get blobUriInput(): string | undefined;
    private _caching?;
    /**
     * @stability stable
     */
    get caching(): string;
    /**
     * @stability stable
     */
    set caching(value: string);
    /**
     * @stability stable
     */
    resetCaching(): void;
    /**
     * @stability stable
     */
    get cachingInput(): string | undefined;
    private _managedDiskId?;
    /**
     * @stability stable
     */
    get managedDiskId(): string;
    /**
     * @stability stable
     */
    set managedDiskId(value: string);
    /**
     * @stability stable
     */
    resetManagedDiskId(): void;
    /**
     * @stability stable
     */
    get managedDiskIdInput(): string | undefined;
    private _osState?;
    /**
     * @stability stable
     */
    get osState(): string;
    /**
     * @stability stable
     */
    set osState(value: string);
    /**
     * @stability stable
     */
    resetOsState(): void;
    /**
     * @stability stable
     */
    get osStateInput(): string | undefined;
    private _osType?;
    /**
     * @stability stable
     */
    get osType(): string;
    /**
     * @stability stable
     */
    set osType(value: string);
    /**
     * @stability stable
     */
    resetOsType(): void;
    /**
     * @stability stable
     */
    get osTypeInput(): string | undefined;
    private _sizeGb?;
    /**
     * @stability stable
     */
    get sizeGb(): number;
    /**
     * @stability stable
     */
    set sizeGb(value: number);
    /**
     * @stability stable
     */
    resetSizeGb(): void;
    /**
     * @stability stable
     */
    get sizeGbInput(): number | undefined;
}
/**
 * @stability stable
 */
export interface ImageTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#create Image#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#delete Image#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#read Image#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/image.html#update Image#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function imageTimeoutsToTerraform(struct?: ImageTimeoutsOutputReference | ImageTimeouts): any;
/**
 * @stability stable
 */
export declare class ImageTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): ImageTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: ImageTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/image.html azurerm_image}.
 *
 * @stability stable
 */
export declare class Image extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/image.html azurerm_image} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: ImageConfig);
    private _hyperVGeneration?;
    /**
     * @stability stable
     */
    get hyperVGeneration(): string;
    /**
     * @stability stable
     */
    set hyperVGeneration(value: string);
    /**
     * @stability stable
     */
    resetHyperVGeneration(): void;
    /**
     * @stability stable
     */
    get hyperVGenerationInput(): string | undefined;
    /**
     * @stability stable
     */
    get id(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    private _sourceVirtualMachineId?;
    /**
     * @stability stable
     */
    get sourceVirtualMachineId(): string;
    /**
     * @stability stable
     */
    set sourceVirtualMachineId(value: string);
    /**
     * @stability stable
     */
    resetSourceVirtualMachineId(): void;
    /**
     * @stability stable
     */
    get sourceVirtualMachineIdInput(): string | undefined;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _zoneResilient?;
    /**
     * @stability stable
     */
    get zoneResilient(): boolean | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set zoneResilient(value: boolean | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetZoneResilient(): void;
    /**
     * @stability stable
     */
    get zoneResilientInput(): boolean | cdktf.IResolvable | undefined;
    private _dataDisk?;
    /**
     * @stability stable
     */
    get dataDisk(): ImageDataDisk[];
    /**
     * @stability stable
     */
    set dataDisk(value: ImageDataDisk[]);
    /**
     * @stability stable
     */
    resetDataDisk(): void;
    /**
     * @stability stable
     */
    get dataDiskInput(): ImageDataDisk[] | undefined;
    private _osDisk;
    /**
     * @stability stable
     */
    get osDisk(): ImageOsDiskOutputReference;
    /**
     * @stability stable
     */
    putOsDisk(value: ImageOsDisk): void;
    /**
     * @stability stable
     */
    resetOsDisk(): void;
    /**
     * @stability stable
     */
    get osDiskInput(): ImageOsDisk | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): ImageTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: ImageTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): ImageTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
