import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
/**
 * @stability stable
 */
export interface IothubDpsConfig extends cdktf.TerraformMetaArguments {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#allocation_policy IothubDps#allocation_policy}.
     *
     * @stability stable
     */
    readonly allocationPolicy?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#location IothubDps#location}.
     *
     * @stability stable
     */
    readonly location: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#name IothubDps#name}.
     *
     * @stability stable
     */
    readonly name: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#resource_group_name IothubDps#resource_group_name}.
     *
     * @stability stable
     */
    readonly resourceGroupName: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#tags IothubDps#tags}.
     *
     * @stability stable
     */
    readonly tags?: {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * linked_hub block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#linked_hub IothubDps#linked_hub}
     *
     * @stability stable
     */
    readonly linkedHub?: IothubDpsLinkedHub[];
    /**
     * sku block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#sku IothubDps#sku}
     *
     * @stability stable
     */
    readonly sku: IothubDpsSku;
    /**
     * timeouts block.
     *
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#timeouts IothubDps#timeouts}
     *
     * @stability stable
     */
    readonly timeouts?: IothubDpsTimeouts;
}
/**
 * @stability stable
 */
export interface IothubDpsLinkedHub {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#allocation_weight IothubDps#allocation_weight}.
     *
     * @stability stable
     */
    readonly allocationWeight?: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#apply_allocation_policy IothubDps#apply_allocation_policy}.
     *
     * @stability stable
     */
    readonly applyAllocationPolicy?: boolean | cdktf.IResolvable;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#connection_string IothubDps#connection_string}.
     *
     * @stability stable
     */
    readonly connectionString: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#location IothubDps#location}.
     *
     * @stability stable
     */
    readonly location: string;
}
export declare function iothubDpsLinkedHubToTerraform(struct?: IothubDpsLinkedHub): any;
/**
 * @stability stable
 */
export interface IothubDpsSku {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#capacity IothubDps#capacity}.
     *
     * @stability stable
     */
    readonly capacity: number;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#name IothubDps#name}.
     *
     * @stability stable
     */
    readonly name: string;
}
export declare function iothubDpsSkuToTerraform(struct?: IothubDpsSkuOutputReference | IothubDpsSku): any;
/**
 * @stability stable
 */
export declare class IothubDpsSkuOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubDpsSku | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubDpsSku | undefined);
    private _capacity?;
    /**
     * @stability stable
     */
    get capacity(): number;
    /**
     * @stability stable
     */
    set capacity(value: number);
    /**
     * @stability stable
     */
    get capacityInput(): number | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
}
/**
 * @stability stable
 */
export interface IothubDpsTimeouts {
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#create IothubDps#create}.
     *
     * @stability stable
     */
    readonly create?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#delete IothubDps#delete}.
     *
     * @stability stable
     */
    readonly delete?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#read IothubDps#read}.
     *
     * @stability stable
     */
    readonly read?: string;
    /**
     * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html#update IothubDps#update}.
     *
     * @stability stable
     */
    readonly update?: string;
}
export declare function iothubDpsTimeoutsToTerraform(struct?: IothubDpsTimeoutsOutputReference | IothubDpsTimeouts): any;
/**
 * @stability stable
 */
export declare class IothubDpsTimeoutsOutputReference extends cdktf.ComplexObject {
    /**
     * @param terraformResource The parent resource.
     * @param terraformAttribute The attribute on the parent resource this class is referencing.
     * @param isSingleItem True if this is a block, false if it's a list.
     * @stability stable
     */
    constructor(terraformResource: cdktf.ITerraformResource, terraformAttribute: string, isSingleItem: boolean);
    /**
     * @stability stable
     */
    get internalValue(): IothubDpsTimeouts | undefined;
    /**
     * @stability stable
     */
    set internalValue(value: IothubDpsTimeouts | undefined);
    private _create?;
    /**
     * @stability stable
     */
    get create(): string;
    /**
     * @stability stable
     */
    set create(value: string);
    /**
     * @stability stable
     */
    resetCreate(): void;
    /**
     * @stability stable
     */
    get createInput(): string | undefined;
    private _delete?;
    /**
     * @stability stable
     */
    get delete(): string;
    /**
     * @stability stable
     */
    set delete(value: string);
    /**
     * @stability stable
     */
    resetDelete(): void;
    /**
     * @stability stable
     */
    get deleteInput(): string | undefined;
    private _read?;
    /**
     * @stability stable
     */
    get read(): string;
    /**
     * @stability stable
     */
    set read(value: string);
    /**
     * @stability stable
     */
    resetRead(): void;
    /**
     * @stability stable
     */
    get readInput(): string | undefined;
    private _update?;
    /**
     * @stability stable
     */
    get update(): string;
    /**
     * @stability stable
     */
    set update(value: string);
    /**
     * @stability stable
     */
    resetUpdate(): void;
    /**
     * @stability stable
     */
    get updateInput(): string | undefined;
}
/**
 * Represents a {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html azurerm_iothub_dps}.
 *
 * @stability stable
 */
export declare class IothubDps extends cdktf.TerraformResource {
    /**
     * @stability stable
     */
    static readonly tfResourceType: string;
    /**
     * Create a new {@link https://www.terraform.io/docs/providers/azurerm/r/iothub_dps.html azurerm_iothub_dps} Resource.
     *
     * @param scope The scope in which to define this construct.
     * @param id The scoped construct ID.
     * @stability stable
     */
    constructor(scope: Construct, id: string, config: IothubDpsConfig);
    private _allocationPolicy?;
    /**
     * @stability stable
     */
    get allocationPolicy(): string;
    /**
     * @stability stable
     */
    set allocationPolicy(value: string);
    /**
     * @stability stable
     */
    resetAllocationPolicy(): void;
    /**
     * @stability stable
     */
    get allocationPolicyInput(): string | undefined;
    /**
     * @stability stable
     */
    get deviceProvisioningHostName(): string;
    /**
     * @stability stable
     */
    get id(): string;
    /**
     * @stability stable
     */
    get idScope(): string;
    private _location?;
    /**
     * @stability stable
     */
    get location(): string;
    /**
     * @stability stable
     */
    set location(value: string);
    /**
     * @stability stable
     */
    get locationInput(): string | undefined;
    private _name?;
    /**
     * @stability stable
     */
    get name(): string;
    /**
     * @stability stable
     */
    set name(value: string);
    /**
     * @stability stable
     */
    get nameInput(): string | undefined;
    private _resourceGroupName?;
    /**
     * @stability stable
     */
    get resourceGroupName(): string;
    /**
     * @stability stable
     */
    set resourceGroupName(value: string);
    /**
     * @stability stable
     */
    get resourceGroupNameInput(): string | undefined;
    /**
     * @stability stable
     */
    get serviceOperationsHostName(): string;
    private _tags?;
    /**
     * @stability stable
     */
    get tags(): {
        [key: string]: string;
    } | cdktf.IResolvable;
    /**
     * @stability stable
     */
    set tags(value: {
        [key: string]: string;
    } | cdktf.IResolvable);
    /**
     * @stability stable
     */
    resetTags(): void;
    /**
     * @stability stable
     */
    get tagsInput(): cdktf.IResolvable | {
        [key: string]: string;
    } | undefined;
    private _linkedHub?;
    /**
     * @stability stable
     */
    get linkedHub(): IothubDpsLinkedHub[];
    /**
     * @stability stable
     */
    set linkedHub(value: IothubDpsLinkedHub[]);
    /**
     * @stability stable
     */
    resetLinkedHub(): void;
    /**
     * @stability stable
     */
    get linkedHubInput(): IothubDpsLinkedHub[] | undefined;
    private _sku;
    /**
     * @stability stable
     */
    get sku(): IothubDpsSkuOutputReference;
    /**
     * @stability stable
     */
    putSku(value: IothubDpsSku): void;
    /**
     * @stability stable
     */
    get skuInput(): IothubDpsSku | undefined;
    private _timeouts;
    /**
     * @stability stable
     */
    get timeouts(): IothubDpsTimeoutsOutputReference;
    /**
     * @stability stable
     */
    putTimeouts(value: IothubDpsTimeouts): void;
    /**
     * @stability stable
     */
    resetTimeouts(): void;
    /**
     * @stability stable
     */
    get timeoutsInput(): IothubDpsTimeouts | undefined;
    /**
     * @stability stable
     */
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
